from sys import argv, stderr, exit

fin  = open(argv[1] + ".in", "r")
fout = open(argv[1], "w")

lines = fin.readlines()
tests = []
linenr = 0
group = None

try:
    while linenr < len(lines):
        while not lines[linenr].strip() or lines[linenr].strip().startswith("//"): linenr += 1

        if group is None:
            if not lines[linenr].strip().startswith("group "): raise "parse error, expected 'group'"
            group = lines[linenr].strip()
            linenr += 1

        while not lines[linenr].strip() or lines[linenr].strip().startswith("//"): linenr += 1

        stylesheet = []
        source = []
        test = []

        if lines[linenr].strip() != "stylesheet": raise "parse error, expected 'stylesheet'"
        linenr += 1

        if lines[linenr].strip() != "{": raise "parse error, expected '{'"
        linenr += 1

        while lines[linenr].strip() != "}":
            stylesheet.append(lines[linenr])
            linenr += 1
        linenr += 1

        while not lines[linenr].strip(): linenr += 1

        if lines[linenr].strip() != "source": raise "parse error, expected 'source'"
        linenr += 1

        if lines[linenr].strip() != "{": raise "parse error, expected '{'"
        linenr += 1

        while lines[linenr].strip() != "}":
            source.append(lines[linenr])
            linenr += 1
        linenr += 1

        while not lines[linenr].strip(): linenr += 1

        if not lines[linenr].strip().startswith("test("): raise "parse error, expected 'test(...)'"
        test.append(lines[linenr].strip())
        linenr += 1

        if lines[linenr].strip() != "{": raise "parse error, expected '{'"
        test.append(lines[linenr].strip())
        linenr += 1

        while lines[linenr].strip() != "}":
            test.append(lines[linenr].rstrip())
            linenr += 1
        test.append(lines[linenr].strip())
        linenr += 1

        tests.append((stylesheet, source, test))

        while linenr < len(lines) and not lines[linenr].strip(): linenr += 1

except Exception, e:
    print >>stderr, "%s:%d: %s" % (argv[0], linenr + 1, e)
    exit(1)

print >>fout, "/* -*- mode: c++ -*- */"
print >>fout
print >>fout, "/* Note: this file is generated by xslt.ot.py from %s.  For a more" % (argv[1] + ".in")
print >>fout, "         useful view of these test cases, check out %s. */" % (argv[1] + ".in")
print >>fout
print >>fout, group
print >>fout, "require init;"
print >>fout, "require XPATH_SUPPORT;"
print >>fout, "require XSLT_SUPPORT;"
print >>fout, "language ecmascript;"

def stripIndent(lines):
    minIndent = 1000
    for line in lines:
        indent = len(line) - len(line.lstrip())
        if indent < minIndent:
            minIndent = indent
    if minIndent:
        for index in range(len(lines)):
            lines[index] = lines[index][minIndent:]

def urlEncode(s):
    return s.replace("%", "%25").replace("<", "%3C").replace(">", "%3E").replace("\"", "%22").replace("\n", "%0A").replace(" ", "%20")

def basicEncode(s):
    return s.replace("\"", "\\\"").replace("\n", "\\n").replace("\t", "\\t")

for stylesheet, source, test in tests:
    print >>fout
    print >>fout, r'xml'
    print >>fout, r'{'
    print >>fout, r'  "<?xml version=\"1.0\"?>"'
    fout.write(r'  "<?xml-stylesheet type=\"text/xsl\" href=\"data:text/xsl,')

    stripIndent(stylesheet)
    for line in stylesheet:
        fout.write(urlEncode(line))
        
    fout.write('\\"?>"\n')

    stripIndent(source)
    for line in source:
        print >>fout, r'  "%s"' % basicEncode(line)

    print >>fout, r'}'
    print >>fout

    for line in test:
        print >>fout, line
