/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2002 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
*/

#ifndef ES_UTILS_ESUTILS_H
#define ES_UTILS_ESUTILS_H

/** @mainpage ECMAScript Utils module
 *
 * This is the auto-generated API documentation for the ECMAScript Utils module.
 * For more information about the module, see the module's <a
 * href="http://wiki.intern.opera.no/cgi-bin/wiki/wiki.pl?Modules/ecmascript_utils">Wiki
 * page</a>.
 *
 * @section description Description
 *
 * The ECMAScript Utils module contains code that controls how and when the
 * ECMAScript engine gets to execute scripts, code that helps hide the
 * complexities of the ECMAScript engine's API from code that just want to
 * execute a script and possibly catch the end result and code that manages the
 * rather complicated handling of SCRIPT elements in HTML/XHTML documents.
 *
 * @subsection threadscheduling Threads and scheduling
 *
 * The ECMAScript engine has a function that executes a script at most a
 * specified number of "iterations".  How long such an iteration takes depends
 * at least on the script and the platform's execution speed.  Someone other
 * than the ECMAScript engine is responsible for executing a script in
 * reasonable timeslices until it is finished.  That someone is the ECMAScript
 * thread scheduler.  The scripts are called threads.
 *
 * The thread scheduler does not generally interleave threads, it executes them
 * in a FIFO order (with some exceptions).  However, since there is one thread
 * scheduler in each open document, threads in different documents can be
 * interleaved.
 *
 * There is a single thread scheduler implementation.  There are many thread
 * implementations, some of which do not even execute any ECMAScript code.  Such
 * non-executing threads are normally used to synchronize related actions with
 * the execution of real script threads.  Several thread implementations are
 * located in other modules.
 *
 * @subsection asyncif Asynchronous execution interface
 *
 * All execution of ECMAScript is asynchronous, since Opera is single threaded
 * and is designed to not nest event loops.  The ECMAScript Utils module
 * provides an asynchronous interface (ES_AsyncInterface) for executing scripts
 * through which scripts can be executed easily and their end result be handled
 * equally easily via a callback object provided by the caller.  Each document
 * that has a DOM environment created has an ES_AsyncInterface object.
 *
 * The interface provides functions for basic evaluation, calling functions,
 * calling methods, getting properties and setting properties.
 *
 * @subsection loadmanager SCRIPT handling
 *
 * The handling of SCRIPT elements during parsing is rather complex since the
 * parsing needs to be blocked while the script is executed waiting for possible
 * data generated by the script using the document.write function.  A script can
 * generate additional SCRIPT elements with document.write and such scripts are
 * executed (from the scripts perspective) synchronously during the call to
 * document.write.
 *
 * The class ES_LoadManager implements most of the handling of SCRIPT elements
 * and document.write.
 */

#ifdef ECMASCRIPT_REMOTE_DEBUGGER
enum RemoteScriptDebuggerType
{
	REMOTE_SCRIPT_DEBUGGER_OFF,
	REMOTE_SCRIPT_DEBUGGER_ACTIVE,
	REMOTE_SCRIPT_DEBUGGER_PASSIVE
};
#endif // ECMASCRIPT_REMOTE_DEBUGGER

struct ES_ErrorInfo;

class ES_Utils
{
public:
	static OP_STATUS Initialize();
	/**< Should be called during startup.  Uses preferences and g_socket_factory. */

	static void Destroy();

#ifdef OPERA_CONSOLE
	static OP_STATUS PostError(FramesDocument *document, const ES_ErrorInfo &info, const uni_char *context, const URL &url);
#endif // OPERA_CONSOLE
};

#endif /* ES_UTILS_ESUTILS_H */
