/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2005 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
*/

#ifndef DOM_SVGENUM_H
#define DOM_SVGENUM_H

#ifdef SVG_DOM

#include "modules/dom/src/opatom.h"

class DOM_SVGInterfaceSpec
{
public:
	DOM_SVGInterfaceSpec(unsigned int type = 0, const unsigned int* if_table = 0)
		: if_type(type)
	{
		inherited_ifs = if_table ? ResolveInheritance(if_type, if_table) : 0;
	}

	BOOL InheritsFrom(unsigned int type)
	{
		return (type < 32) && (inherited_ifs & (1L << type));
	}

	BOOL HasInterface(unsigned int type)
	{
		return (type == if_type) || InheritsFrom(type);
	}

private:
	unsigned int ResolveInheritance(unsigned int if_type, const unsigned int* if_table)
	{
		unsigned int resolved = if_table[if_type];

		if (resolved != 0) /* Does inherit */
		{
			unsigned int temp = resolved;
			unsigned int parent_type = 0; /* bit 0 => id 0 */

			while (temp)
			{
				if (temp & (1U << parent_type))
				{
					resolved |= ResolveInheritance(parent_type, if_table);
					temp &= ~(1U << parent_type);
				}
				parent_type++;
			}
		}
		return resolved;
	}

	unsigned int if_type;
	unsigned int inherited_ifs;
};

/**
* If the list is changed then make sure it's reflected in the DOM_SVGElementInterface::if_inheritance_table.
*/
class DOM_SVGElementInterface : public DOM_SVGInterfaceSpec
{
public:
	enum SVGElementInterface
	{
		/* Inherited interfaces */
		SVG_INTERFACE_ANIMATED_PATH_DATA,
		SVG_INTERFACE_ANIMATED_POINTS,
		SVG_INTERFACE_COMPONENT_TRANSFER_FUNCTION_ELEMENT, // SVG_IF_ELEMENT
		/*SVG_INTERFACE_CSS_RULE, */ // css::CSSRule
		SVG_INTERFACE_ELEMENT, // Element
		SVG_INTERFACE_EXTERNAL_RESOURCES_REQUIRED,
		SVG_INTERFACE_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES, // SVG_IF_STYLABLE
		SVG_INTERFACE_FIT_TO_VIEW_BOX,
		SVG_INTERFACE_GRADIENT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED
		SVG_INTERFACE_LANG_SPACE,
		SVG_INTERFACE_LOCATABLE,
		/*SVG_INTERFACE_RENDERING_INTENT,*/
		SVG_INTERFACE_STYLABLE,
		SVG_INTERFACE_TESTS,
		SVG_INTERFACE_TEXTCONTENT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | events::EventTarget
		SVG_INTERFACE_TEXTPOSITIONING_ELEMENT, // SVG_IF_TEXTCONTENT_ELEMENT
		SVG_INTERFACE_TRANSFORMABLE, // SVG_IF_LOCATABLE
		SVG_INTERFACE_UNIT_TYPES,
		SVG_INTERFACE_URI_REFERENCE,
		SVG_INTERFACE_ZOOM_AND_PAN,
		SVG_INTERFACE_SMIL_ELEMENT_TIME_CONTROL,
		SVG_INTERFACE_TIMED_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_SMIL_ELEMENT_TIME_CONTROL
		SVG_INTERFACE_CAN_REFERENCE_DOCUMENT,
		SVG_INTERFACE_VISUAL_MEDIA_ELEMENT, // SVG_IF_TIMED_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE /* 22 */

		/* Non-inherited interfaces */
		SVG_INTERFACE_ANIMATION_ELEMENT_BASE = 32, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_SMIL_ELEMENT_TIME_CONTROL | SVG_IF_TIMED_ELEMENT

		SVG_INTERFACE_CIRCLE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget
		SVG_INTERFACE_CLIPPATH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | SVG_IF_UNIT_TYPES

		SVG_INTERFACE_DEFS_ELEMENT,	// SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget
		SVG_INTERFACE_DESC_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_LANG_SPACE | SVG_IF_STYLABLE

		SVG_INTERFACE_ELLIPSE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget

		SVG_INTERFACE_FILTER_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_INTERFACE_UNIT_TYPES
		SVG_INTERFACE_FEBLEND_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FECOLORMATRIX_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FECOMPONENTTRANSFER_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES

		SVG_INTERFACE_FEFUNCR_ELEMENT,	// SVG_IF_COMPONENT_TRANSFER_FUNCTION_ELEMENT
		SVG_INTERFACE_FEFUNCG_ELEMENT,	// SVG_IF_COMPONENT_TRANSFER_FUNCTION_ELEMENT
		SVG_INTERFACE_FEFUNCB_ELEMENT,	// SVG_IF_COMPONENT_TRANSFER_FUNCTION_ELEMENT
		SVG_INTERFACE_FEFUNCA_ELEMENT,	// SVG_IF_COMPONENT_TRANSFER_FUNCTION_ELEMENT

		SVG_INTERFACE_FECOMPOSITE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FECONVOLVEMATRIX_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEDIFFUSELIGHTING_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES

		SVG_INTERFACE_FEDISTANTLIGHT_ELEMENT, // SVG_IF_ELEMENT
		SVG_INTERFACE_FEPOINTLIGHT_ELEMENT, // SVG_IF_ELEMENT
		SVG_INTERFACE_FESPOTLIGHT_ELEMENT, // SVG_IF_ELEMENT

		SVG_INTERFACE_FEDISPLACEMENTMAP_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEFLOOD_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEGAUSSIANBLUR_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEIMAGE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEMERGE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEMERGENODE_ELEMENT, // SVG_IF_ELEMENT
		SVG_INTERFACE_FEMORPHOLOGY_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FEOFFSET_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FESPECULARLIGHTING_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FETILE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES
		SVG_INTERFACE_FETURBULENCE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_FILTER_PRIMITIVE_STANDARD_ATTRIBUTES

		SVG_INTERFACE_G_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_TRANSFORMABLE | events::EventTarget

		SVG_INTERFACE_IMAGE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget

		SVG_INTERFACE_LINE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget
		SVG_INTERFACE_LINEARGRADIENT_ELEMENT, // SVG_IF_GRADIENT_ELEMENT

		SVG_INTERFACE_MARKER_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_FIT_TO_VIEW_BOX

		SVG_INTERFACE_MASK_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_UNIT_TYPES

		SVG_INTERFACE_RADIALGRADIENT_ELEMENT, // SVG_IF_GRADIENT_ELEMENT
		SVG_INTERFACE_RECT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget

		SVG_INTERFACE_PATH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | SVG_IF_ANIMATED_PATH_DATA | events::EventTarget
		SVG_INTERFACE_PATTERN_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_FIT_TO_VIEW_BOX | SVG_IF_UNIT_TYPES
		SVG_INTERFACE_POLYGON_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | SVG_IF_ANIMATED_POINTS
		SVG_INTERFACE_POLYLINE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | SVG_IF_ANIMATED_POINTS

		SVG_INTERFACE_STOP_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_STYLABLE
		SVG_INTERFACE_STYLE_ELEMENT, // SVG_IF_ELEMENT
		SVG_INTERFACE_SVG_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_LOCATABLE | SVG_IF_FIT_TO_VIEW_BOX | SVG_IF_ZOOM_AND_PAN | SVG_IF_TIMED_ELEMENT
		SVG_INTERFACE_SYMBOL_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_FIT_TO_VIEW_BOX | events::EventTarget
		SVG_INTERFACE_SWITCH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget

		SVG_INTERFACE_TEXTPATH_ELEMENT, // SVG_IF_TEXTCONTENT_ELEMENT | SVG_IF_URI_REFERENCE
		SVG_INTERFACE_TEXT_ELEMENT, // SVG_IF_TEXTPOSITIONING_ELEMENT | SVG_IF_TRANSFORMABLE
		SVG_INTERFACE_TITLE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_LANG_SPACE | SVG_IF_STYLABLE
		SVG_INTERFACE_TREF_ELEMENT, // SVG_IF_TEXTPOSITIONING_ELEMENT | SVG_IF_URI_REFERENCE
		SVG_INTERFACE_TSPAN_ELEMENT, // SVG_IF_TEXTPOSITIONING_ELEMENT

		SVG_INTERFACE_USE_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URIREFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget
		SVG_INTERFACE_VIEW_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_FIT_TO_VIEW_BOX | SVG_IF_ZOOM_AND_PAN
		SVG_INTERFACE_A_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URIREFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | events::EventTarget
		SVG_INTERFACE_SCRIPT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URIREFERENCE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | events::EventTarget
		SVG_INTERFACE_MPATH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_URIREFERENCE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED
		SVG_INTERFACE_FONT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_STYLABLE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED

		SVG_INTERFACE_GLYPH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_STYLABLE
		SVG_INTERFACE_MISSING_GLYPH_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_STYLABLE
		SVG_INTERFACE_FOREIGNOBJECT_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TESTS | SVG_IF_URI_REFERENCE (1.2 ext) | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE | SVG_IF_TRANSFORMABLE | SVG_IF_CAN_REFERENCE_DOCUMENT | events::EventTarget

		SVG_INTERFACE_AUDIO_ELEMENT, // SVG_IF_TIMED_ELEMENT | SVG_IF_URI_REFERENCE | SVG_IF_TESTS | SVG_IF_LANG_SPACE | SVG_IF_EXTERNAL_RESOURCES_REQUIRED | SVG_IF_STYLABLE
		SVG_INTERFACE_TEXTAREA_ELEMENT, // SVG_IF_ELEMENT | SVG_IF_TRANSFORMABLE
		SVG_INTERFACE_ANIMATION_ELEMENT, // SVG_IF_VISUAL_MEDIA_ELEMENT | SVG_IF_CAN_REFERENCE_DOCUMENT

		SVG_NUM_ELEMENT_INTERFACES
	};

	DOM_SVGElementInterface(unsigned int type = 0);
};

struct DOM_SVGInterfaceEntry
{
	int ifs;
	OpAtom atom;
};

struct SVGElementSpec
{
	Markup::Type type;
	DOM_SVGElementInterface::SVGElementInterface svgelm_interface;
	const char* classname;
	int prototype; /* DOM_Runtime::SVGElementPrototype */
};

#endif // SVG_DOM
#endif // DOM_SVGENUM_H
