/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2006-2007 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
** Peter Krefting
*/

#include "core/pch.h"

#include "modules/about/opsuppressedurl.h"
#include "modules/locale/locale-enum.h"
#include "modules/locale/oplanguagemanager.h"
#include "modules/util/htmlify.h"
#include "modules/prefs/prefsmanager/collections/pc_files.h"

OP_STATUS OpSuppressedURL::GenerateData()
{
	/* Determine which strings to use */
	Str::LocaleString header_id = Str::NOT_A_STRING;
	Str::LocaleString locale_id = Str::NOT_A_STRING;

#ifdef _MIME_SUPPORT_
	if (!m_downloadlink)
	{
		header_id = Str::SI_IDSTR_SUPPRESSED_FRAME_TITLE;
		locale_id = Str::S_SUPPRESSED_FRAME_NEW;
	}
	else
#endif
	{
		header_id = Str::S_DOWNLOAD_CONTENT_HEADER;
		locale_id = Str::S_DOWNLOAD_CONTENT;
	}

#ifndef _MIME_SUPPORT_
	OP_ASSERT(m_downloadlink || !"Not supported in this build.");
#endif
	
	/* Generate header */
#ifdef _LOCALHOST_SUPPORT_
	RETURN_IF_ERROR(OpenDocument(header_id, PrefsCollectionFiles::StyleMessageFile));
#else
	RETURN_IF_ERROR(OpenDocument(header_id));
#endif

	RETURN_IF_ERROR(OpenBody(Str::S_DOWNLOAD_CONTENT_HEADER));
	RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("<p>")));

	OpString locale_str;
	RETURN_IF_ERROR(g_languageManager->GetString(locale_id, locale_str));

	OpString filename;
	RETURN_IF_LEAVE(m_suppressed.GetAttribute(URL::KSuggestedFileName_L, filename, FALSE));

	uni_char *htmlified_filename = HTMLify_string(filename.CStr());
	if (!htmlified_filename)
		return OpStatus::ERR_NO_MEMORY;

	OpString suppressed_url_name;
	OP_STATUS res;
	if (m_downloadlink)
		res = m_suppressed.GetAttribute(URL::KUniName_Username_Password_Hidden, suppressed_url_name);
	else
		res = m_suppressed.GetAttribute(URL::KUniName_With_Fragment_Username_Password_NOT_FOR_UI, suppressed_url_name);	

	uni_char *url_string = NULL;
	if (OpStatus::IsSuccess(res))
		url_string = HTMLify_string(suppressed_url_name.CStr());
	if (!url_string)
	{
		delete[] htmlified_filename;
		return OpStatus::ERR_NO_MEMORY;
	}

	uni_char *url_displayable = m_downloadlink
		? (htmlified_filename ? htmlified_filename : url_string)
		: url_string;

	m_url.WriteDocumentDataUniSprintf(locale_str.CStr(), url_string, url_displayable);
	delete[] url_string;
	delete[] htmlified_filename;

	RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("</p>\n")));

	/* Say that page is generated by Opera. */
	GeneratedByOpera();

	/* Done */
	return CloseDocument();
}
