/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2012-2012 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

/**
 * @file libopeay_util.cpp
 *
 * Utility functions.
 *
 * @author Alexei Khlebnikov <alexeik@opera.com>
 *
 */

#if defined(_DEBUG) || defined(SELFTEST)

#include "modules/libopeay/addon/libopeay_util.h"
#include "modules/libopeay/openssl/cryptlib.h"
#include "modules/libopeay/openssl/evp.h"
#include "modules/libopeay/openssl/x509_vfy.h"


#ifdef CASE_ELEMENT
#error "#define collision: CASE_ELEMENT is already defined."
#endif
#define CASE_ELEMENT(name) case name: return #name

const char* EVP_PKEY_type_name(int pkey_type)
{
	switch (pkey_type)
	{
		// The list is taken from evp.h.
		CASE_ELEMENT(EVP_PKEY_NONE);
		CASE_ELEMENT(EVP_PKEY_RSA);
		CASE_ELEMENT(EVP_PKEY_RSA2);
		CASE_ELEMENT(EVP_PKEY_DSA);
		CASE_ELEMENT(EVP_PKEY_DSA1);
		CASE_ELEMENT(EVP_PKEY_DSA2);
		CASE_ELEMENT(EVP_PKEY_DSA3);
		CASE_ELEMENT(EVP_PKEY_DSA4);
		CASE_ELEMENT(EVP_PKEY_DH);
		CASE_ELEMENT(EVP_PKEY_EC);
		CASE_ELEMENT(EVP_PKEY_HMAC);
	}

	return "(Unknown EVP_PKEY type)";
}


const char* X509_V_ERR_name(int err)
{
	switch (err)
	{
		// The list is taken from x509_vfy.h.
		CASE_ELEMENT(X509_V_OK);
		case 1: return "(illegal error (for uninitialized values, to avoid X509_V_OK): 1)";
		// The rest of the list is generated by the following command:
		// cat x509_vfy.h | awk '/X509_V_ERR_/ { print "CASE_ELEMENT(" $2 ");" }'
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_GET_CRL);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY);
		CASE_ELEMENT(X509_V_ERR_CERT_SIGNATURE_FAILURE);
		CASE_ELEMENT(X509_V_ERR_CRL_SIGNATURE_FAILURE);
		CASE_ELEMENT(X509_V_ERR_CERT_NOT_YET_VALID);
		CASE_ELEMENT(X509_V_ERR_CERT_HAS_EXPIRED);
		CASE_ELEMENT(X509_V_ERR_CRL_NOT_YET_VALID);
		CASE_ELEMENT(X509_V_ERR_CRL_HAS_EXPIRED);
		CASE_ELEMENT(X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD);
		CASE_ELEMENT(X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD);
		CASE_ELEMENT(X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD);
		CASE_ELEMENT(X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD);
		CASE_ELEMENT(X509_V_ERR_OUT_OF_MEM);
		CASE_ELEMENT(X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT);
		CASE_ELEMENT(X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE);
		CASE_ELEMENT(X509_V_ERR_CERT_CHAIN_TOO_LONG);
		CASE_ELEMENT(X509_V_ERR_CERT_REVOKED);
		CASE_ELEMENT(X509_V_ERR_INVALID_CA);
		CASE_ELEMENT(X509_V_ERR_PATH_LENGTH_EXCEEDED);
		CASE_ELEMENT(X509_V_ERR_INVALID_PURPOSE);
		CASE_ELEMENT(X509_V_ERR_CERT_UNTRUSTED);
		CASE_ELEMENT(X509_V_ERR_CERT_REJECTED);
		CASE_ELEMENT(X509_V_ERR_SUBJECT_ISSUER_MISMATCH);
		CASE_ELEMENT(X509_V_ERR_AKID_SKID_MISMATCH);
		CASE_ELEMENT(X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH);
		CASE_ELEMENT(X509_V_ERR_KEYUSAGE_NO_CERTSIGN);
		CASE_ELEMENT(X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER);
		CASE_ELEMENT(X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION);
		CASE_ELEMENT(X509_V_ERR_KEYUSAGE_NO_CRL_SIGN);
		CASE_ELEMENT(X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION);
		CASE_ELEMENT(X509_V_ERR_INVALID_NON_CA);
		CASE_ELEMENT(X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED);
		CASE_ELEMENT(X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE);
		CASE_ELEMENT(X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED);
		CASE_ELEMENT(X509_V_ERR_INVALID_EXTENSION);
		CASE_ELEMENT(X509_V_ERR_INVALID_POLICY_EXTENSION);
		CASE_ELEMENT(X509_V_ERR_NO_EXPLICIT_POLICY);
		CASE_ELEMENT(X509_V_ERR_DIFFERENT_CRL_SCOPE);
		CASE_ELEMENT(X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE);
		CASE_ELEMENT(X509_V_ERR_UNNESTED_RESOURCE);
		CASE_ELEMENT(X509_V_ERR_PERMITTED_VIOLATION);
		CASE_ELEMENT(X509_V_ERR_EXCLUDED_VIOLATION);
		CASE_ELEMENT(X509_V_ERR_SUBTREE_MINMAX);
		CASE_ELEMENT(X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE);
		CASE_ELEMENT(X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX);
		CASE_ELEMENT(X509_V_ERR_UNSUPPORTED_NAME_SYNTAX);
		CASE_ELEMENT(X509_V_ERR_CRL_PATH_VALIDATION_ERROR);
		CASE_ELEMENT(X509_V_ERR_APPLICATION_VERIFICATION);
	}

	return "(Unknown X509_V_ERR_* code)";
}

#undef CASE_ELEMENT

#endif // defined(_DEBUG) || defined(SELFTEST)
