#! /usr/bin/python
import sys
import re

def error(message):
	print >>sys.stderr, message
	sys.exit(1)

pattern = re.compile(' ([\dA-Fa-f]+); ([^ ]+) *# (.*)')
table = []

# Open and parse the input data
try:
	file = open('exceptions.txt', 'r')
except:
	error("Error opening exceptions.txt")

for line in file.readlines():
	m = pattern.match(line)
	if not m:
		continue

	# Get codepoint, IDNAProperty value and comment from the parsed line
	codepoint, idnaproperty, comment = m.group(1, 2, 3)
	idnaproperty = "IDNALabelValidator::IDNA_"+idnaproperty

	table.append([int(codepoint, 16), idnaproperty, comment])

table = sorted(table)

# Write the requested exceptions table
print "/** @file exceptions.inl"
print " * This file is auto-generated by modules/idna/tables/make_exceptions.py."
print " * DO NOT EDIT THIS FILE MANUALLY."
print " */\n"
print 'const Exception_st exceptions_table[] = {'
for t in table:
	print "\t{0x%.4x, %s}, // %s" % (t[0], t[1], t[2])
print '};'

