/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; c-file-style: "stroustrup" -*-
**
** Copyright (C) 1995-2005 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
*/
#ifndef SVG_INTERNAL_ENUM
#define SVG_INTERNAL_ENUM

#ifdef SVG_SUPPORT

#include "modules/svg/svg_external_types.h" // enum types used in layoutprops are defined here
#include "modules/svg/src/svgpch.h"
#include "modules/style/src/css_values.h"
#include "modules/display/cursor.h"
#include "modules/svg/src/SVGAttribute.h"
#include "modules/svg/src/SVGInternalEnumTables.h"
#include "modules/svg/src/SVGObject.h"

#define SVG_GET_ENUM_VALUE(enm, type, instr, len, res)					\
	int nval = SVGEnumUtils::GetEnumValue((type),(instr),(len));		\
	if (nval != -1)														\
	{																	\
		res = (enm)nval;												\
		return OpStatus::OK;											\
	}																	\
	else																\
	{																	\
		return OpSVGStatus::INVALID_ARGUMENT;							\
	}																	\


class SVGEnumUtils
{
public:
	static const char* GetEnumName(SVGEnumType type, int enum_val);
	static int GetEnumValue(SVGEnumType type, const uni_char* str, unsigned str_len);
};

/**
 * Matches SVGENUM_SPREAD_METHOD_TYPE
 */
enum SVGSpreadMethodType
{
	SVGSPREAD_UNKNOWN = 0,
	SVGSPREAD_PAD 	  = 1,
	SVGSPREAD_REFLECT = 2,
	SVGSPREAD_REPEAT  = 3
};

/**
 * Matches SVGENUM_UNITS_TYPE
 */
enum SVGUnitsType
{
	SVGUNITS_UNKNOWN 		= 0,
	SVGUNITS_USERSPACEONUSE = 1,
	SVGUNITS_OBJECTBBOX 	= 2
};

/**
 * Matches SVGENUM_TRANSFORM_TYPE.
 *
 * The constants (except for REF) are from SVG DOM, and must match
 * them.
 */
enum SVGTransformType {
	SVGTRANSFORM_UNKNOWN = 0,
	SVGTRANSFORM_MATRIX = 1,
	SVGTRANSFORM_TRANSLATE = 2,
	SVGTRANSFORM_SCALE = 3,
	SVGTRANSFORM_ROTATE = 4,
	SVGTRANSFORM_SKEWX = 5,
	SVGTRANSFORM_SKEWY = 6,
	SVGTRANSFORM_REF
};

/**
 * Matches SVGENUM_CALCMODE
 */
enum SVGCalcMode
{
	SVGCALCMODE_DISCRETE,
	SVGCALCMODE_LINEAR,
	SVGCALCMODE_PACED,
	SVGCALCMODE_SPLINE,
	SVGCALCMODE_UNKNOWN
};

/**
 * Matches SVGENUM_VISIBILITY
 */
enum SVGVisibilityType
{
	SVGVISIBILITY_VISIBLE,
	SVGVISIBILITY_HIDDEN,
	SVGVISIBILITY_COLLAPSE,
	SVGVISIBILITY_UNKNOWN
};

/**
 * Matches SVGENUM_ANIMATEFILLTYPE
 */
enum SVGAnimateFillType
{
	SVGANIMATEFILL_FREEZE,
	SVGANIMATEFILL_REMOVE,
	SVGANIMATEFILL_UNKNOWN
};

/**
 * Matches SVGENUM_ADDITIVE
 */
enum SVGAdditiveType
{
	SVGADDITIVE_REPLACE,
	SVGADDITIVE_SUM,
	SVGADDITIVE_UNKNOWN
};

/**
 * Matches SVGENUM_ACCUMULATE
 */
enum SVGAccumulateType
{
	SVGACCUMULATE_NONE,
	SVGACCUMULATE_SUM,
	SVGACCUMULATE_UNKNOWN
};

/**
 * Matches SVGENUM_DISPLAY
 */
enum SVGDisplayType
{
	SVGDISPLAY_INLINE,
	SVGDISPLAY_BLOCK,
	SVGDISPLAY_LISTITEM,
	SVGDISPLAY_RUNIN,
	SVGDISPLAY_COMPACT,
	SVGDISPLAY_MARKER,
	SVGDISPLAY_TABLE,
	SVGDISPLAY_INLINETABLE,
	SVGDISPLAY_TABLEROWGROUP,
	SVGDISPLAY_TABLEHEADERGROUP,
	SVGDISPLAY_TABLEFOOTERGROUP,
	SVGDISPLAY_TABLEROW,
	SVGDISPLAY_TABLECOLUMNGROUP,
	SVGDISPLAY_TABLECOLUMN,
	SVGDISPLAY_TABLECELL,
	SVGDISPLAY_TABLECAPTION,
	SVGDISPLAY_NONE,
	SVGDISPLAY_UNKNOWN
};

/**
 * Matches SVGENUM_ZOOM_AND_PAN
 */
enum SVGZoomAndPan
{
	SVGZOOMANDPAN_UNKNOWN = 0,
	SVGZOOMANDPAN_DISABLE = 1,
	SVGZOOMANDPAN_MAGNIFY = 2
};

/**
 * Matches SVGENUM_FONT_WEIGHT
 */
enum SVGFontWeight
{
	SVGFONTWEIGHT_NORMAL = 0,
	SVGFONTWEIGHT_BOLD,
	SVGFONTWEIGHT_BOLDER,
	SVGFONTWEIGHT_LIGHTER,
	SVGFONTWEIGHT_100,
	SVGFONTWEIGHT_200,
	SVGFONTWEIGHT_300,
	SVGFONTWEIGHT_400,
	SVGFONTWEIGHT_500,
	SVGFONTWEIGHT_600,
	SVGFONTWEIGHT_700,
	SVGFONTWEIGHT_800,
	SVGFONTWEIGHT_900,
	SVGFONTWEIGHT_ALL,
	SVGFONTWEIGHT_UNKNOWN
};

/**
 * Matches SVGENUM_FONT_STYLE
 */
enum SVGFontStyle
{
	SVGFONTSTYLE_NORMAL,
	SVGFONTSTYLE_ITALIC,
	SVGFONTSTYLE_OBLIQUE,
	SVGFONTSTYLE_UNKNOWN
};

/**
 * Matches SVGENUM_FONT_VARIANT
 */
enum SVGFontVariant
{
	SVGFONTVARIANT_NORMAL,
	SVGFONTVARIANT_SMALLCAPS
};

/**
 * Matches SVGENUM_RESTART
 */
enum SVGRestartType
{
	SVGRESTART_ALWAYS,
	SVGRESTART_WHENNOTACTIVE,
	SVGRESTART_NEVER,
	SVGRESTART_UNKNOWN
};

/**
 * Matches SVGENUM_REQUIREDFEATURES
 */
enum SVGFeatureType
{
	SVGFEATURE_SVG = 0,
	SVGFEATURE_SVGDOM,
	SVGFEATURE_SVGSTATIC,
	SVGFEATURE_SVGDOMSTATIC,
	SVGFEATURE_SVGANIMATION,
	SVGFEATURE_SVGDOMANIMATION,
	SVGFEATURE_SVGDYNAMIC,
	SVGFEATURE_SVGDOMDYNAMIC,
	SVGFEATURE_COREATTRIBUTE,
	SVGFEATURE_STRUCTURE,
	SVGFEATURE_CONTAINERATTRIBUTE,
	SVGFEATURE_CONDITIONALPROCESSING,
	SVGFEATURE_IMAGE,
	SVGFEATURE_STYLE,
	SVGFEATURE_VIEWPORTATTRIBUTE,
	SVGFEATURE_SHAPE,
	SVGFEATURE_TEXT,
	SVGFEATURE_PAINTATTRIBUTE,
	SVGFEATURE_OPACITYATTRIBUTE,
	SVGFEATURE_GRAPHICSATTRIBUTE,
	SVGFEATURE_MARKER,
	SVGFEATURE_COLORPROFILE,
	SVGFEATURE_GRADIENT,
	SVGFEATURE_PATTERN,
	SVGFEATURE_CLIP,
	SVGFEATURE_MASK,
	SVGFEATURE_FILTER,
	SVGFEATURE_DOCUMENTEVENTSATTRIBUTE,
	SVGFEATURE_GRAPHICALEVENTSATTRIBUTE,
	SVGFEATURE_ANIMATIONEVENTSATTRIBUTE,
	SVGFEATURE_CURSOR,
	SVGFEATURE_HYPERLINKING,
	SVGFEATURE_XLINKATTRIBUTE,
	SVGFEATURE_EXTERNALRESOURCESREQUIRED,
	SVGFEATURE_VIEW,
	SVGFEATURE_SCRIPT,
	SVGFEATURE_ANIMATION,
	SVGFEATURE_FONT,
	SVGFEATURE_EXTENSIBILITY,
	SVGFEATURE_BASIC_BASE,
	SVGFEATURE_BASIC_CLIP,
	SVGFEATURE_BASIC_CSS,
	SVGFEATURE_BASIC_DOMCORE,
	SVGFEATURE_BASIC_DOMEXTENDED,
	SVGFEATURE_BASIC_FILTER,
	SVGFEATURE_BASIC_FONT,
	SVGFEATURE_BASIC_GRAPHICSATTRIBUTE,
	SVGFEATURE_BASIC_INTERACTIVITY,
	SVGFEATURE_BASIC_PAINTATTRIBUTE,
	SVGFEATURE_BASIC_STRUCTURE,
	SVGFEATURE_BASIC_TEXT,
	SVGFEATURE_BASIC_ALL /*=  SVGFEATURE_BASIC_BASE | 
							SVGFEATURE_BASIC_CLIP | 
							SVGFEATURE_BASIC_CSS | 
							SVGFEATURE_BASIC_DOMCORE |
							SVGFEATURE_BASIC_DOMEXTENDED |
							SVGFEATURE_BASIC_FILTER |
							SVGFEATURE_BASIC_FONT |
							SVGFEATURE_BASIC_GRAPHICSATTRIBUTE |
							SVGFEATURE_BASIC_INTERACTIVITY |
							SVGFEATURE_BASIC_PAINTATTRIBUTE |
							SVGFEATURE_BASIC_STRUCTURE |
							SVGFEATURE_BASIC_TEXT */,
	SVGFEATURE_TINY_BASE,
	SVGFEATURE_TINY_INTERACTIVITY,
	SVGFEATURE_TINY_ALL /* = SVGFEATURE_TINY_BASE | SVGFEATURE_TINY_INTERACTIVITY */,
	SVGFEATURE_1_0,
	SVGFEATURE_1_0_STATIC,
	SVGFEATURE_1_0_DYNAMIC,
	SVGFEATURE_1_0_ANIMATION,
	SVGFEATURE_1_0_ALL,
	SVGFEATURE_1_0_DOM,
	SVGFEATURE_1_0_DOM_STATIC,
	SVGFEATURE_1_0_DOM_DYNAMIC,
	SVGFEATURE_1_0_DOM_ANIMATION,
	SVGFEATURE_1_0_DOM_ALL,

#ifdef SVG_TINY_12
	SVGFEATURE_1_2_SVGSTATIC,
	SVGFEATURE_1_2_SVGSTATICDOM,
	SVGFEATURE_1_2_SVGANIMATED,
	SVGFEATURE_1_2_SVGINTERACTIVE,
	SVGFEATURE_1_2_SVGALL,
	SVGFEATURE_1_2_CORE_ATTRIBUTE,
	SVGFEATURE_1_2_NAVIGATION_ATTRIBUTE,
	SVGFEATURE_1_2_STRUCTURE,
	SVGFEATURE_1_2_CONDITIONAL_PROCESSING,
	SVGFEATURE_1_2_CONDITIONAL_PROCESSING_ATTRIBUTE,
	SVGFEATURE_1_2_IMAGE,
	SVGFEATURE_1_2_PREFETCH,
	SVGFEATURE_1_2_DISCARD,
	SVGFEATURE_1_2_SHAPE,
	SVGFEATURE_1_2_TEXT,
	SVGFEATURE_1_2_PAINT_ATTRIBUTE,
	SVGFEATURE_1_2_OPACITY_ATTRIBUTE,
	SVGFEATURE_1_2_GRAPHICS_ATTRIBUTE,
	SVGFEATURE_1_2_GRADIENT,
	SVGFEATURE_1_2_SOLID_COLOR,
	SVGFEATURE_1_2_HYPERLINKING,
	SVGFEATURE_1_2_XLINK_ATTRIBUTE,
	SVGFEATURE_1_2_EXTERNALRESOURCESREQUIRED,
	SVGFEATURE_1_2_SCRIPTING,
	SVGFEATURE_1_2_HANDLER,
	SVGFEATURE_1_2_LISTENER,
	SVGFEATURE_1_2_TIMEDANIMATION,
	SVGFEATURE_1_2_ANIMATION,
	SVGFEATURE_1_2_AUDIO,
	SVGFEATURE_1_2_VIDEO,
	SVGFEATURE_1_2_FONT,
	SVGFEATURE_1_2_EXTENSIBILITY,
	SVGFEATURE_1_2_MEDIA_ATTRIBUTE,
	SVGFEATURE_1_2_TEXTFLOW,
	SVGFEATURE_1_2_TRANSFORMEDVIDEO,
	SVGFEATURE_1_2_COMPOSEDVIDEO,
	SVGFEATURE_1_2_EDITABLE_ATTRIBUTE,
#endif // SVG_TINY_12

	SVGFEATURE_UNKNOWN
};

/**
 * Matches SVGENUM_METHOD
 */
enum SVGMethod
{
	SVGMETHOD_UNKNOWN = 0,
	SVGMETHOD_ALIGN   = 1,
	SVGMETHOD_STRETCH = 2
};

/**
 * Matches SVGENUM_SPACING
 */
enum SVGSpacing
{
	SVGSPACING_UNKNOWN = 0,
	SVGSPACING_AUTO    = 1,
	SVGSPACING_EXACT   = 2
};

/**
 * Matches SVGENUM_STITCHTILES
 */
enum SVGStitchType
{
	SVGSTITCH_UNKNOWN  = 0,
	SVGSTITCH_STITCH   = 1,
	SVGSTITCH_NOSTITCH = 2
};

/**
 * Matches SVGENUM_DISPLACEMENTSELECTOR
 */
enum SVGDisplacementSelector
{
	SVGDISPLACEMENT_UNKNOWN = 0,
	SVGDISPLACEMENT_R 		= 1,
	SVGDISPLACEMENT_G 		= 2,
	SVGDISPLACEMENT_B 		= 3,
	SVGDISPLACEMENT_A 		= 4
};

/**
 * Matches SVGENUM_CONVOLVEEDGEMODE
 */
enum SVGConvolveEdgeMode
{
	SVGCONVOLVEEDGEMODE_UNKNOWN   = 0,
	SVGCONVOLVEEDGEMODE_DUPLICATE = 1,
	SVGCONVOLVEEDGEMODE_WRAP 	  = 2,
	SVGCONVOLVEEDGEMODE_NONE 	  = 3
};

/**
 * Matches SVGENUM_COMPOSITEOPERATOR
 */
enum SVGCompositeOperator
{
	SVGCOMPOSITEOPERATOR_UNKNOWN 	= 0,
	SVGCOMPOSITEOPERATOR_OVER 		= 1,
	SVGCOMPOSITEOPERATOR_IN 		= 2,
	SVGCOMPOSITEOPERATOR_OUT 		= 3,
	SVGCOMPOSITEOPERATOR_ATOP 		= 4,
	SVGCOMPOSITEOPERATOR_XOR 		= 5,
	SVGCOMPOSITEOPERATOR_ARITHMETIC = 6
};

/**
 * Matches SVGENUM_MORPHOLOGYOPERATOR
 */
enum SVGMorphologyOperator
{
	SVGMORPHOPERATOR_UNKNOWN = 0,
	SVGMORPHOPERATOR_ERODE 	 = 1,
	SVGMORPHOPERATOR_DILATE  = 2
};

/**
 * Matches SVGENUM_BLENDMODE
 */
enum SVGBlendMode
{
	SVGBLENDMODE_UNKNOWN  = 0,
	SVGBLENDMODE_NORMAL   = 1,
	SVGBLENDMODE_MULTIPLY = 2,
	SVGBLENDMODE_SCREEN   = 3,
	SVGBLENDMODE_DARKEN   = 4,
	SVGBLENDMODE_LIGHTEN  = 5
};

/**
 * Matches SVGENUM_TURBULENCETYPE
 */
enum SVGTurbulenceType
{
	SVGTURBULENCE_UNKNOWN 	   = 0,
	SVGTURBULENCE_FRACTALNOISE = 1,
	SVGTURBULENCE_TURBULENCE   = 2
};

/**
 * Matches SVGENUM_COLORMATRIXTYPE
 */
enum SVGColorMatrixType
{
	SVGCOLORMATRIX_UNKNOWN 			= 0,
	SVGCOLORMATRIX_MATRIX 			= 1,
	SVGCOLORMATRIX_SATURATE 		= 2,
	SVGCOLORMATRIX_HUEROTATE 		= 3, 
	SVGCOLORMATRIX_LUMINANCETOALPHA = 4
};

/**
 * Matches SVGENUM_FUNCTYPE
 */
enum SVGFuncType
{
	SVGFUNC_UNKNOWN  = 0,
	SVGFUNC_IDENTITY = 1,
	SVGFUNC_TABLE 	 = 2,
	SVGFUNC_DISCRETE = 3,
	SVGFUNC_LINEAR 	 = 4,
	SVGFUNC_GAMMA 	 = 5
};

/**
 * Matches SVGENUM_LENGTHADJUST
 */
enum SVGLengthAdjust
{
	SVGLENADJUST_UNKNOWN 		  = 0,
	SVGLENADJUST_SPACING 		  = 1,
	SVGLENADJUST_SPACINGANDGLYPHS = 2
};

/**
 * Matches SVGENUM_TEXTDECORATION
 */
enum SVGTextDecoration
{
	SVGTEXTDECORATION_NONE = 1,
	SVGTEXTDECORATION_UNDERLINE = 2,
	SVGTEXTDECORATION_OVERLINE = 3,
	SVGTEXTDECORATION_LINETHROUGH = 4,
	SVGTEXTDECORATION_BLINK = 5,
	SVGTEXTDECORATION_UNKNOWN = 0
};

/**
 * Matches SVGENUM_MARKER_UNITS
 */
enum SVGMarkerUnitsType
{
	SVGMARKERUNITS_UNKNOWN		  = 0,
	SVGMARKERUNITS_USERSPACEONUSE = 1,
	SVGMARKERUNITS_STROKEWIDTH	  = 2
};

/**
 * Matches SVGENUM_FOCUSABLE
 */
enum SVGFocusable
{
	SVGFOCUSABLE_TRUE	= 0,
	SVGFOCUSABLE_FALSE	= 1,
	SVGFOCUSABLE_AUTO	= 2
};

/**
 * Matches SVGENUM_FOCUSHIGHLIGHT
 */
enum SVGFocusHighlight
{
	SVGFOCUSHIGHLIGHT_NONE	= 0,
	SVGFOCUSHIGHLIGHT_AUTO	= 1
};

/**
 * Matches SVGENUM_INITIALVISIBILITY
 */
enum SVGInitialVisibility
{
	SVGINITIALVISIBILITY_WHENSTARTED = 0,
	SVGINITIALVISIBILITY_ALWAYS = 1
};

/**
 * Matches SVGENUM_TRANSFORMBEHAVIOR
 */
enum SVGTransformBehavior
{
	SVGTRANSFORMBEHAVIOR_GEOMETRIC = 0,
	SVGTRANSFORMBEHAVIOR_PINNED = 1,
	SVGTRANSFORMBEHAVIOR_PINNED90 = 2,
	SVGTRANSFORMBEHAVIOR_PINNED180 = 3,
	SVGTRANSFORMBEHAVIOR_PINNED270 = 4
};

/**
 * Matches SVGENUM_OVERLAY
 */
enum SVGOverlayType
{
	SVGOVERLAY_TOP = 0,
	SVGOVERLAY_NONE = 1
};

/**
 * Matches SVGENUM_DISPLAY_ALIGN
 */
enum SVGDisplayAlign
{
	SVGDISPLAYALIGN_AUTO = 0,
	SVGDISPLAYALIGN_BEFORE = 1,
	SVGDISPLAYALIGN_CENTER = 2,
	SVGDISPLAYALIGN_AFTER = 3
};

/**
 * Matches SVGENUM_EDITABLE
 */
enum SVGEditableType
{
	SVGEDITABLE_NONE = 0,
	SVGEDITABLE_SIMPLE = 1
};

/**
 * Matches SVGENUM_TEXTALIGN
 */
enum SVGTextAlign
{
	SVGTEXTALIGN_START = CSS_VALUE_start,
	SVGTEXTALIGN_CENTER = CSS_VALUE_center,
	SVGTEXTALIGN_END = CSS_VALUE_end
};

/**
 * Matches SVGENUM_AUTO
 */
enum SVGAuto
{
	SVGAUTO_AUTO
};

/**
 * Matches SVGENUM_NONE
 */
enum SVGSnapshotTime
{
	SVGSNAPSHOTTIME_NONE
};

/**
 * Matched SVGENUM_SYNCBEHAVIOR
 */
enum SVGSyncBehavior
{
	SVGSYNCBEHAVIOR_CANSLIP,
	SVGSYNCBEHAVIOR_LOCKED,
	SVGSYNCBEHAVIOR_INDEPENDENT,
	SVGSYNCBEHAVIOR_INHERIT,
	SVGSYNCBEHAVIOR_DEFAULT
};

/**
 * Matched SVGENUM_TIMELINEBEGIN
 */
enum SVGTimelineBegin
{
	SVGTIMELINEBEGIN_ONLOAD,
	SVGTIMELINEBEGIN_ONSTART
};

#endif // SVG_SUPPORT
#endif // SVG_INTERNAL_ENUM
