# -*- Mode: python; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-

import sys
import os

#
# global variables
#

debug = False
verbosity = 0
table_files = []
in_file_name = ""
max_tag_len = 0

#
# definition of functions and classes used
#

def verbose(s, level = 0):
    global verbosity
    if verbosity >= level:
        print s

def toFile(file, s):
	global debug
	if debug:
		verbose(s, 4)
	else:
		file.write(s)

def makeArray(s, ns):
	out_str = ""
	if s == "textArea":
		ns = "SVG"
	index_increment = 1
	str_len = len(s)
	add_flattened = s != s.lower()
	if add_flattened:
		out_str += "%d, HTML5Element::%s" % ((str_len + 1), ns.upper())
	else:
		out_str += "0, 0"

	index_increment += str_len + 1
	for i in range(str_len):
		out_str += ", '%s'" % s[i]
		out_str += ", 0"

	out_str += ", 0, 0"

	if add_flattened:
		index_increment += str_len + 1
		for i in range(str_len):
			out_str += ", '%s'" % s[i].lower()
			out_str += ", 0"
		out_str += ", 0, 0"

	return [out_str, index_increment * 2]


if len(sys.argv) < 2:
    print "\nUsage: mkattrs.py tag-file\n"
    sys.exit()

verbose("Creating tag tables...")

in_file_name = sys.argv[1]
in_file_dir = os.path.dirname(os.path.abspath(in_file_name)) + "/"

type_file_name = in_file_dir + "elementtypes.h"
name_file_name = in_file_dir + "elementnames.h"

in_file = open(in_file_name, "r")
type_file = None
name_file = None
if not debug:
	type_file = open(type_file_name, "w")
	name_file = open(name_file_name, "w")

first = True
tag_map = {}
tag_list = []
tag_indices = []
tag_index = 0

for line in in_file:
	tag_entry = line.strip()
	[tag_name, ns] = tag_entry.split(',')
	if not tag_name in tag_map:
		tag_map[tag_name] = ns
	tag_list.append([tag_name, ns])

in_file.close()

tag_list.sort()


# write files
header = """/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; c-file-style: "stroustrup" -*-
 *
 * Copyright (C) 2011 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */

/***********************************************************************
 * This file is generated by the mktags.py script in the logdoc module.
 *
 * DO NOT EDIT BY HAND. CHANGE THE html5tags.txt FILE AND REGENERATE!!
 *
 ***********************************************************************/

"""

toFile(type_file, header)
toFile(type_file, "enum Type\n{\n\tHTE_DOC_ROOT\n\t, HTE_TEXT\n\t, HTE_TEXTGROUP\n\t, HTE_COMMENT\n\t, HTE_PROCINST\n\t, HTE_DOCTYPE\n\t, HTE_ENTITY\n\t, HTE_ENTITYREF\n\t, HTE_CDATA\n\t, HTE_UNKNOWNDECL\n\t, HTE_ANY\n\t, HTE_UNKNOWN\n")
toFile(name_file, header)
toFile(name_file, "char const g_html5_tag_names[] = {\n")

upper_names = "CONST_ARRAY(g_html5_tag_names_upper, uni_char*)\n"
placeholder = ""
for [tag_name, ns] in tag_list:
	if len(tag_name) > max_tag_len:
		max_tag_len = len(tag_name)
	tag_name_esc = tag_name.replace('-', '_').upper()
	if ns != tag_map[tag_name]:
		toFile(type_file, "\t, BEFORE_%sE_%s%s\n" % (ns.upper(), tag_name_esc, placeholder))
		toFile(type_file, "\t, %sE_%s = %sE_%s\n" % (ns.upper(), tag_name_esc, tag_map[tag_name].upper(), tag_name_esc))
		placeholder = " = BEFORE_%sE_%s" % (ns.upper(), tag_name_esc)
	else:
		toFile(type_file, "\t, %sE_%s%s\n" % (ns.upper(), tag_name_esc.upper(), placeholder))
		tag_indices.append(tag_index)
		placeholder = ""
		result = makeArray(tag_name, ns)
		tag_index += result[1]
		if first:
			toFile(name_file, "\t%s\n" % result[0])
			upper_names += "\tCONST_ENTRY(UNI_L(\"%s\"))\n" % tag_name.upper()
			first = False
		else:
			toFile(name_file, "\t, %s\n" % result[0])
			upper_names += "\t, CONST_ENTRY(UNI_L(\"%s\"))\n" % tag_name.upper()

toFile(type_file, "\t, HTE_LAST // Last that maps to a string\n")

# Add some special SVG types
toFile(type_file, "\t, SVGE_SHADOW\n\t, SVGE_BASE_SHADOWROOT\n\t, SVGE_ANIMATED_SHADOWROOT\n")

toFile(type_file, "\t, HTE_ABSOLUTELY_LAST\n};\n")
toFile(name_file, "};\n\n#define HTML5_MAX_TAG_LEN %d\n\n" % max_tag_len)

toFile(name_file, "const unsigned g_html5_tag_indices[] = {\n")
for index in tag_indices:
	if index == 0:
		toFile(name_file, "\t%d\n" % index)
	else:
		toFile(name_file, "\t, %d\n" % index)
toFile(name_file, "};\n\n")
upper_names += "CONST_END(g_html5_tag_names_upper)\n"
toFile(name_file, upper_names);

if not debug:
	type_file.close()
	name_file.close()

verbose("  Wrote %s" % type_file_name);
verbose("  Wrote %s" % name_file_name);
verbose("\nRemember to run mkhash.py to optimize hashing")
