/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2002-2010 Opera Software AS.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */
#ifndef DOM_EVENTTYPES_H
#define DOM_EVENTTYPES_H

enum ES_EventPhase
{
	ES_PHASE_CAPTURING = 1, /**< DOM: Event.CAPTURING_PHASE */
	ES_PHASE_AT_TARGET,     /**< DOM: Event.AT_TARGET */
	ES_PHASE_BUBBLING,      /**< DOM: Event.BUBBLING_PHASE */
	ES_PHASE_ANY            /**< Used internally. */
};

/** Origin of a DOM key event. Some keypress events behave
 *  differently depending on their context.
 */
enum DOM_KeyEventOrigin
{
	DOM_KEYEVENT_DOCUMENT = 0,
	DOM_KEYEVENT_DOCUMENTEDIT
};

/**
 * Constants for common events.
 *
 * This enum has to be kept in sync with the table in domeventdata.cpp
 */
enum DOM_EventType
{
	ONRESIZE,
	ONSCROLL,
	ONFOCUSIN,
	ONFOCUSOUT,
	ONGAINSELECTION,
	ONLOSESELECTION,
	ONACTIVATE,
	ONCLICK,
	ONMOUSEDOWN,
	ONMOUSEUP,
	ONMOUSEOVER,
	ONMOUSEENTER,
	ONMOUSEMOVE,
	ONMOUSEOUT,
	ONMOUSELEAVE,
	ONMOUSEWHEEL,
	ONMOUSEWHEELH,
	ONMOUSEWHEELV,
	ONKEYPRESS,
	ONKEYDOWN,
	ONKEYUP,
	ONLOAD,
	ONUNLOAD,
	ONABORT,
	ONERROR,
	ONSELECT,
	ONCHANGE,
	ONSUBMIT,
	ONRESET,
	ONFOCUS,
	ONBLUR,
	ONDBLCLICK,
	ONCONTEXTMENU,
	ONREADYSTATECHANGE,
	ONVISIBILITYCHANGE,
	ONHASHCHANGE,
	ONINPUT,
	ONONLINE,
	ONOFFLINE,
	ONMESSAGE,
	DOMFOCUSIN,
	DOMFOCUSOUT,
	DOMACTIVATE,
#ifdef DOM2_MUTATION_EVENTS
	DOMSUBTREEMODIFIED,
	DOMNODEINSERTED,
	DOMNODEREMOVED,
	DOMNODEREMOVEDFROMDOCUMENT,
	DOMNODEINSERTEDINTODOCUMENT,
	DOMATTRMODIFIED,
	DOMCHARACTERDATAMODIFIED,
#endif // DOM2_MUTATION_EVENTS
	DOMCONTENTLOADED,
	DOMFRAMECONTENTLOADED,
	ONINVALID,
	ONFORMINPUT,
	ONFORMCHANGE,
#ifdef SVG_DOM
	SVGLOAD,
	SVGUNLOAD,
	SVGABORT,
	SVGERROR,
	SVGRESIZE,
	SVGSCROLL,
	SVGZOOM,
	BEGINEVENT,
	ENDEVENT,
	REPEATEVENT,
#endif // SVG_DOM
#if defined(PROGRESS_EVENTS_SUPPORT) || defined(MEDIA_HTML_SUPPORT)
	ONLOADSTART,
	ONPROGRESS,
	ONSUSPEND,
	ONSTALLED,
	ONLOADEND,
	ONTIMEOUT,
#endif // defined(PROGRESS_EVENTS_SUPPORT) || defined(MEDIA_HTML_SUPPORT)
#ifdef MEDIA_HTML_SUPPORT
	MEDIAEMPTIED,
	MEDIAPLAY,
	MEDIAPAUSE,
	MEDIALOADEDMETADATA,
	MEDIALOADEDDATA,
	MEDIAWAITING,
	MEDIAPLAYING,
	MEDIASEEKING,
	MEDIASEEKED,
	MEDIATIMEUPDATE,
	MEDIAENDED,
	MEDIACANPLAY,
	MEDIACANPLAYTHROUGH,
	MEDIARATECHANGE,
	MEDIADURATIONCHANGE,
	MEDIAVOLUMECHANGE,
	MEDIACUECHANGE,
	MEDIACUEENTER,
	MEDIACUEEXIT,
	MEDIAADDTRACK,
	MEDIAREMOVETRACK,
#endif // MEDIA_HTML_SUPPORT
#ifdef CSS_TRANSITIONS
	WEBKITTRANSITIONEND,
	OTRANSITIONEND,
	TRANSITIONEND,
#endif // CSS_TRANSITIONS
#ifdef CSS_ANIMATIONS
	ANIMATIONSTART,
	ANIMATIONEND,
	ANIMATIONITERATION,
#endif
#ifdef CLIENTSIDE_STORAGE_SUPPORT
	STORAGE,
#endif // CLIENTSIDE_STORAGE_SUPPORT
	SEARCHSUGGESTS,
#ifdef DOM_FULLSCREEN_MODE
	FULLSCREENERROR,
	FULLSCREENCHANGE,
#endif // DOM_FULLSCREEN_MODE
#ifdef APPLICATION_CACHE_SUPPORT
	APPCACHECHECKING,
	APPCACHENOUPDATE,
	APPCACHEDOWNLOADING,
	APPCACHEUPDATEREADY,
	APPCACHECACHED,
	APPCACHEOBSOLETE,
#endif
#if defined(EVENT_SOURCE_SUPPORT) || defined(WEBSOCKETS_SUPPORT)
	ONOPEN,
#endif
#ifdef WEBSOCKETS_SUPPORT
	ONCLOSE,
#endif // WEBSOCKETS_SUPPORT
#ifdef DOM_CROSSDOCUMENT_MESSAGING_SUPPORT
	ONCONNECT,
#endif // DOM_CROSSDOCUMENT_MESSAGING_SUPPORT
#ifdef CANVAS3D_SUPPORT
	ONFRAMEEND,
#endif //CANVAS3D_SUPPORT
#ifdef TOUCH_EVENTS_SUPPORT
	TOUCHSTART,
	TOUCHMOVE,
	TOUCHEND,
	TOUCHCANCEL,
#endif // TOUCH_EVENTS_SUPPORT
#ifdef EXTENSION_SUPPORT
	ONCREATE,
	ONDISCONNECT,
	ONMOVE,
	ONREMOVE,
	ONUPDATE,
#endif // EXTENSION_SUPPORT
	ONPOPSTATE,
#ifdef DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
	ONDEVICEORIENTATION,
	ONCOMPASSNEEDSCALIBRATION,
	ONDEVICEMOTION,
#endif // DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
#ifdef PAGED_MEDIA_SUPPORT
	ONPAGECHANGE,
#endif // PAGED_MEDIA_SUPPORT
#ifdef DRAG_SUPPORT
	ONDRAGSTART,
	ONDRAG,
	ONDRAGENTER,
	ONDRAGLEAVE,
	ONDRAGOVER,
	ONDROP,
	ONDRAGEND,
#endif // DRAG_SUPPORT
#ifdef USE_OP_CLIPBOARD
	ONCOPY,
	ONCUT,
	ONPASTE,
#endif // USE_OP_CLIPBOARD
	TEXTINPUT,
#ifdef URL_FILTER
	ONCONTENTBLOCKED,
	ONCONTENTUNBLOCKED,
	#ifdef SELFTEST
		ONCONTENTALLOWED,
	#endif // SELFTEST
#endif // URL_FILTER
	// All additions should normally be *ABOVE* this line !
	DOM_EVENTS_COUNT,

	DOM_EVENT_CUSTOM,		/**< Custom event type, identified by a string (Event::type_string). */
	DOM_EVENT_NONE			/**< No event type or not set yet. */
};

enum DOM_EventWithNamespaceData
{
	DOM_EVENT_WITH_NS_DATA_REPETITIONADDED,
	DOM_EVENT_WITH_NS_DATA_REPETITIONREMOVED,
	DOM_EVENT_WITH_NS_DATA_REPETITIONMOVED,

	DOM_EVENTS_WITH_NS_DATA_COUNT
};

#endif // DOM_EVENTTYPES_H
