#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
An English dictionary based on UI strings, in the format {word: (root, [inflections])}

The intention is to apply fuzzy matching at the level of words, not characters.
We construct equivalence classes, where all inflections are treated equally.
Each member of a class is normalized to a root form before searching.
"""

fuzzy = { \
u'24-hour': (u'24-hour', [u'24-hour']),
u'able': (u'able', [u'able']),
u'aboriginal': (u'aborigin', [u'aboriginal']),
u'abort': (u'abort', [u'abort', u'aborted']),
u'aborted': (u'abort', [u'abort', u'aborted']),
u'about': (u'about', [u'about']),
u'above': (u'above', [u'above']),
u'absolute': (u'absolute', [u'absolute']),
u'acceleration': (u'accelerat', [u'acceleration']),
u'accept': (u'accept', [u'accept', u'acceptable', u'acceptance', u'accepted', u'accepting']),
u'acceptable': (u'accept', [u'accept', u'acceptable', u'acceptance', u'accepted', u'accepting']),
u'acceptance': (u'accept', [u'accept', u'acceptable', u'acceptance', u'accepted', u'accepting']),
u'accepted': (u'accept', [u'accept', u'acceptable', u'acceptance', u'accepted', u'accepting']),
u'accepting': (u'accept', [u'accept', u'acceptable', u'acceptance', u'accepted', u'accepting']),
u'access': (u'access', [u'access', u'accessed', u'accessibility', u'accessible', u'accessing']),
u'accessed': (u'access', [u'access', u'accessed', u'accessibility', u'accessible', u'accessing']),
u'accessibility': (u'access', [u'access', u'accessed', u'accessibility', u'accessible', u'accessing']),
u'accessible': (u'access', [u'access', u'accessed', u'accessibility', u'accessible', u'accessing']),
u'accessing': (u'access', [u'access', u'accessed', u'accessibility', u'accessible', u'accessing']),
u'according': (u'according', [u'according']),
u'account': (u'account', [u'account', u'accounts', u'accounts.ini']),
u'accounts': (u'account', [u'account', u'accounts', u'accounts.ini']),
u'accounts.ini': (u'account', [u'account', u'accounts', u'accounts.ini']),
u'across': (u'across', [u'across']),
u'action': (u'action', [u'action', u'actions']),
u'actions': (u'action', [u'action', u'actions']),
u'activate': (u'activ', [u'activate', u'activated', u'active', u'actively', u'activity']),
u'activated': (u'activ', [u'activate', u'activated', u'active', u'actively', u'activity']),
u'active': (u'activ', [u'activate', u'activated', u'active', u'actively', u'activity']),
u'actively': (u'activ', [u'activate', u'activated', u'active', u'actively', u'activity']),
u'activity': (u'activ', [u'activate', u'activated', u'active', u'actively', u'activity']),
u'actually': (u'actual', [u'actually']),
u'adapted': (u'adapt', [u'adapted', u'adapter']),
u'adapter': (u'adapt', [u'adapted', u'adapter']),
u'add': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'add-on': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'add-ons': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'added': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'adding': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'additional': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'address': (u'address', [u'address', u'addresses', u'addressing']),
u'addresses': (u'address', [u'address', u'addresses', u'addressing']),
u'addressing': (u'address', [u'address', u'addresses', u'addressing']),
u'adds': (u'addd', [u'add', u'add-on', u'add-ons', u'added', u'adding', u'additional', u'adds']),
u'adjust': (u'adjust', [u'adjust', u'adjusted']),
u'adjusted': (u'adjust', [u'adjust', u'adjusted']),
u'admin': (u'admin', [u'admin', u'administer', u'administrative', u'administrator', u'administrator-level']),
u'administer': (u'admin', [u'admin', u'administer', u'administrative', u'administrator', u'administrator-level']),
u'administrative': (u'admin', [u'admin', u'administer', u'administrative', u'administrator', u'administrator-level']),
u'administrator': (u'admin', [u'admin', u'administer', u'administrative', u'administrator', u'administrator-level']),
u'administrator-level': (u'admin', [u'admin', u'administer', u'administrative', u'administrator', u'administrator-level']),
u'adobe': (u'adobe', [u'adobe']),
u'advance': (u'advanc', [u'advance', u'advanced']),
u'advanced': (u'advanc', [u'advance', u'advanced']),
u'advertise': (u'advertis', [u'advertise', u'advertisements', u'advertising']),
u'advertisements': (u'advertis', [u'advertise', u'advertisements', u'advertising']),
u'advertising': (u'advertis', [u'advertise', u'advertisements', u'advertising']),
u'advised': (u'advis', [u'advised', u'advisory']),
u'advisory': (u'advis', [u'advised', u'advisory']),
u'affects': (u'affect', [u'affects']),
u'africa': (u'africa', [u'africa']),
u'after': (u'after', [u'after', u'afterwards']),
u'afterwards': (u'after', [u'after', u'afterwards']),
u'again': (u'again', [u'again']),
u'age': (u'ag-', [u'age']),
u'agent': (u'agent', [u'agent']),
u'aggregate': (u'aggregat', [u'aggregate']),
u'aggressive': (u'aggress', [u'aggressive']),
u'ago': (u'ago', [u'ago']),
u'agree': (u'agree', [u'agree', u'agreeing', u'agreement']),
u'agreeing': (u'agree', [u'agree', u'agreeing', u'agreement']),
u'agreement': (u'agree', [u'agree', u'agreeing', u'agreement']),
u'alarm': (u'alarm', [u'alarm']),
u'album': (u'album', [u'album']),
u'alert': (u'alert', [u'alert', u'alerts']),
u'alerts': (u'alert', [u'alert', u'alerts']),
u'algorithm': (u'algorithm', [u'algorithm']),
u'aliases': (u'alias', [u'aliases']),
u'align': (u'align', [u'align', u'aligned']),
u'aligned': (u'align', [u'align', u'aligned']),
u'all': (u'alll', [u'all']),
u'allow': (u'allow', [u'allow', u'allowed', u'allows']),
u'allowed': (u'allow', [u'allow', u'allowed', u'allows']),
u'allows': (u'allow', [u'allow', u'allowed', u'allows']),
u'almost': (u'almost', [u'almost']),
u'along': (u'along', [u'along']),
u'alphabetic': (u'alphabet', [u'alphabetic']),
u'already': (u'already', [u'already']),
u'also': (u'also', [u'also']),
u'alt': (u'altt', [u'alt']),
u'alter': (u'alterr', [u'alter']),
u'alternate': (u'alternat', [u'alternate', u'alternative', u'alternatively']),
u'alternative': (u'alternat', [u'alternate', u'alternative', u'alternatively']),
u'alternatively': (u'alternat', [u'alternate', u'alternative', u'alternatively']),
u'although': (u'although', [u'although']),
u'always': (u'always', [u'always']),
u'am': (u'am-time', [u'am']),
u'america': (u'america', [u'america']),
u'among': (u'among', [u'among']),
u'amount': (u'amount', [u'amount']),
u'and': (u'and-conjunction', [u'and']),
u'angry': (u'angr', [u'angry']),
u'animated': (u'animat', [u'animated', u'animation', u'animations']),
u'animation': (u'animat', [u'animated', u'animation', u'animations']),
u'animations': (u'animat', [u'animated', u'animation', u'animations']),
u'annoyance': (u'annoy', [u'annoyance']),
u'anonymous': (u'anonym', [u'anonymous']),
u'another': (u'another', [u'another']),
u'ansi': (u'ansi', [u'ansi']),
u'anti-virus': (u'anti-virus', [u'anti-virus']),
u'any': (u'any', [u'any', u'anyone', u'anyway', u'anywhere']),
u'anyone': (u'anyone', [u'anyone']),
u'anyway': (u'anyway', [u'anyway']),
u'anywhere': (u'anywhere', [u'anywhere']),
u'apache': (u'apache', [u'apache']),
u'apart': (u'apart', [u'apart']),
u'aperture': (u'aperture', [u'aperture']),
u'app': (u'apps', [u'app', u'application', u'applications', u'apps']),
u'appear': (u'appear', [u'appear', u'appearance', u'appears']),
u'appearance': (u'appear', [u'appear', u'appearance', u'appears']),
u'appears': (u'appear', [u'appear', u'appearance', u'appears']),
u'append': (u'append', [u'append', u'appended', u'appending']),
u'appended': (u'append', [u'append', u'appended', u'appending']),
u'appending': (u'append', [u'append', u'appended', u'appending']),
u'apple': (u'apple-company', [u'apple']),
u'applet': (u'applet', [u'applet']),
u'application': (u'apps', [u'app', u'application', u'applications', u'apps']),
u'applications': (u'apps', [u'app', u'application', u'applications', u'apps']),
u'applied': (u'apply', [u'applied', u'applies', u'apply', u'applying']),
u'applies': (u'apply', [u'applied', u'applies', u'apply', u'applying']),
u'apply': (u'apply', [u'applied', u'applies', u'apply', u'applying']),
u'applying': (u'apply', [u'applied', u'applies', u'apply', u'applying']),
u'approach': (u'approach', [u'approach']),
u'appropriate': (u'appropriate', [u'appropriate']),
u'approve': (u'approv', [u'approve', u'approved']),
u'approved': (u'approv', [u'approve', u'approved']),
u'apps': (u'apps', [u'app', u'application', u'applications', u'apps']),
u'apr': (u'apr', [u'apr', u'april']),
u'april': (u'apr', [u'apr', u'april']),
u'arabic': (u'arab', [u'arabic']),
u'architecture': (u'architecture', [u'architecture']),
u'archive': (u'archiv', [u'archive', u'archived', u'archives']),
u'archived': (u'archiv', [u'archive', u'archived', u'archives']),
u'archives': (u'archiv', [u'archive', u'archived', u'archives']),
u'archos': (u'archos', [u'archos']),
u'are': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'area': (u'area', [u'area']),
u'argument': (u'argu', [u'argument', u'arguments']),
u'arguments': (u'argu', [u'argument', u'arguments']),
u'armenian': (u'armenian', [u'armenian']),
u'around': (u'around', [u'around']),
u'arrange': (u'arrang', [u'arrange']),
u'array': (u'array', [u'array']),
u'arrive': (u'arriv', [u'arrive', u'arrives']),
u'arrives': (u'arriv', [u'arrive', u'arrives']),
u'arrows': (u'arrow', [u'arrows']),
u'article': (u'article', [u'article', u'articles']),
u'articles': (u'article', [u'article', u'articles']),
u'artwork': (u'artwork', [u'artwork']),
u'ascending': (u'ascend', [u'ascending']),
u'ascii': (u'ascii', [u'ascii']),
u'asia': (u'asia', [u'asia']),
u'ask': (u'ask', [u'ask', u'asked']),
u'asked': (u'ask', [u'ask', u'asked']),
u'assign': (u'assign', [u'assign', u'assigned']),
u'assigned': (u'assign', [u'assign', u'assigned']),
u'associate': (u'associat', [u'associate', u'associated', u'association']),
u'associated': (u'associat', [u'associate', u'associated', u'association']),
u'association': (u'associat', [u'associate', u'associated', u'association']),
u'assume': (u'assum', [u'assume']),
u'asynchronous': (u'asynchronous', [u'asynchronous']),
u'attach': (u'attach', [u'attach', u'attached', u'attachment', u'attachments']),
u'attached': (u'attach', [u'attach', u'attached', u'attachment', u'attachments']),
u'attachment': (u'attach', [u'attach', u'attached', u'attachment', u'attachments']),
u'attachments': (u'attach', [u'attach', u'attached', u'attachment', u'attachments']),
u'attempt': (u'attempt', [u'attempt', u'attempted', u'attempting', u'attempts']),
u'attempted': (u'attempt', [u'attempt', u'attempted', u'attempting', u'attempts']),
u'attempting': (u'attempt', [u'attempt', u'attempted', u'attempting', u'attempts']),
u'attempts': (u'attempt', [u'attempt', u'attempted', u'attempting', u'attempts']),
u'attention': (u'attention', [u'attention']),
u'attribute': (u'attribute', [u'attribute', u'attributes']),
u'attributes': (u'attribute', [u'attribute', u'attributes']),
u'audio': (u'audio', [u'audio']),
u'aug': (u'aug', [u'aug', u'august']),
u'august': (u'aug', [u'aug', u'august']),
u'authenticate': (u'authenticat', [u'authenticate', u'authenticated', u'authenticating', u'authentication']),
u'authenticated': (u'authenticat', [u'authenticate', u'authenticated', u'authenticating', u'authentication']),
u'authenticating': (u'authenticat', [u'authenticate', u'authenticated', u'authenticating', u'authentication']),
u'authentication': (u'authenticat', [u'authenticate', u'authenticated', u'authenticating', u'authentication']),
u'author': (u'author-writer', [u'author']),
u'authorities': (u'authori', [u'authorities', u'authority', u'authorized']),
u'authority': (u'authori', [u'authorities', u'authority', u'authorized']),
u'authorized': (u'authori', [u'authorities', u'authority', u'authorized']),
u'auto': (u'auto', [u'auto', u'auto-complete', u'auto-completion', u'auto-config', u'auto-detection', u'auto-fill', u'auto-hide', u'auto-resume', u'auto-save', u'auto-scroll', u'auto-update', u'autocomplete', u'autocompletion', u'automated', u'automatic', u'automatically', u'autoreply']),
u'auto-complete': (u'autocomplet', [u'auto-complete', u'auto-completion']),
u'auto-completion': (u'autocomplet', [u'auto-complete', u'auto-completion']),
u'auto-config': (u'auto-config', [u'auto-config']),
u'auto-detection': (u'auto-detect', [u'auto-detection']),
u'auto-fill': (u'auto-fill', [u'auto-fill']),
u'auto-hide': (u'auto-hid', [u'auto-hide']),
u'auto-resume': (u'auto-resume', [u'auto-resume']),
u'auto-save': (u'auto-save', [u'auto-save']),
u'auto-scroll': (u'auto-scroll', [u'auto-scroll']),
u'auto-update': (u'auto-updat', [u'auto-update']),
u'autocomplete': (u'auto-complet', [u'autocomplete', u'autocompletion']),
u'autocompletion': (u'auto-complet', [u'autocomplete', u'autocompletion']),
u'automated': (u'automat', [u'automated', u'automatic', u'automatically']),
u'automatic': (u'automat', [u'automated', u'automatic', u'automatically']),
u'automatically': (u'automat', [u'automated', u'automatic', u'automatically']),
u'autoreply': (u'autoreply', [u'autoreply']),
u'availability': (u'avail', [u'availability', u'available']),
u'available': (u'avail', [u'availability', u'available']),
u'average': (u'average', [u'average']),
u'avoid': (u'avoid', [u'avoid']),
u'awaiting': (u'await', [u'awaiting', u'awaits']),
u'awaits': (u'await', [u'awaiting', u'awaits']),
u'away': (u'away', [u'away']),
u'awful': (u'awful', [u'awful']),
u'back': (u'back', [u'back', u'backend', u'background', u'backspace', u'backup']),
u'backend': (u'backend', [u'backend']),
u'background': (u'background', [u'background']),
u'backspace': (u'backspace', [u'backspace']),
u'backup': (u'backup', [u'backup']),
u'bad': (u'bad', [u'bad']),
u'balance': (u'balance', [u'balance']),
u'baltic': (u'baltic', [u'baltic']),
u'ban': (u'bann', [u'ban', u'banned']),
u'bandwidth': (u'bandwidth', [u'bandwidth']),
u'banned': (u'bann', [u'ban', u'banned']),
u'bar': (u'bar', [u'bar', u'bars']),
u'bars': (u'bar', [u'bar', u'bars']),
u'based': (u'base', [u'based']),
u'basic': (u'basic', [u'basic']),
u'battle-tested': (u'battle', [u'battle-tested']),
u'bayes': (u'bayes', [u'bayes']),
u'bbcode': (u'bbcode', [u'bbcode']),
u'bcc': (u'bcc', [u'bcc']),
u'be': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'beautifully': (u'beautiful', [u'beautifully']),
u'because': (u'because', [u'because']),
u'become': (u'becom', [u'become']),
u'been': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'before': (u'before', [u'before']),
u'begin': (u'begin', [u'begin', u'beginning', u'begins']),
u'beginning': (u'begin', [u'begin', u'beginning', u'begins']),
u'begins': (u'begin', [u'begin', u'beginning', u'begins']),
u'behaves': (u'behav', [u'behaves', u'behavior']),
u'behavior': (u'behav', [u'behaves', u'behavior']),
u'behind': (u'behind', [u'behind']),
u'being': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'below': (u'below', [u'below']),
u'bengali': (u'bengali', [u'bengali']),
u'best': (u'best', [u'best', u'bestfit']),
u'bestfit': (u'bestfit', [u'bestfit']),
u'better': (u'better', [u'better']),
u'between': (u'between', [u'between']),
u'beyond': (u'beyond', [u'beyond']),
u'bias': (u'bias', [u'bias']),
u'big': (u'big', [u'big', u'big5', u'big5-hkscs', u'bigger', u'biggest']),
u'big5': (u'big5', [u'big5', u'big5-hkscs']),
u'big5-hkscs': (u'big5-hkscs', [u'big5-hkscs']),
u'bigger': (u'big', [u'big', u'big5', u'big5-hkscs', u'bigger', u'biggest']),
u'biggest': (u'big', [u'big', u'big5', u'big5-hkscs', u'bigger', u'biggest']),
u'billing': (u'billing', [u'billing']),
u'bin': (u'bin', [u'bin', u'binary']),
u'binary': (u'bin', [u'bin', u'binary']),
u'birthday': (u'birthday', [u'birthday']),
u'bit': (u'bit', [u'bit', u'biting', u'bits', u'bittorrent']),
u'biting': (u'biting', [u'biting']),
u'bits': (u'bit', [u'bit', u'biting', u'bits', u'bittorrent']),
u'bittorrent': (u'bittorrent', [u'bittorrent']),
u'black': (u'black', [u'black', u'blackberry', u'blacklisted']),
u'blackberry': (u'blackberry', [u'blackberry']),
u'blacklisted': (u'blacklist', [u'blacklisted']),
u'blank': (u'blank', [u'blank']),
u'block': (u'block', [u'block', u'blocked', u'blocker', u'blocking', u'blocklist', u'blockquote']),
u'blocked': (u'block', [u'block', u'blocked', u'blocker', u'blocking', u'blocklist', u'blockquote']),
u'blocker': (u'block', [u'block', u'blocked', u'blocker', u'blocking', u'blocklist', u'blockquote']),
u'blocking': (u'block', [u'block', u'blocked', u'blocker', u'blocking', u'blocklist', u'blockquote']),
u'blocklist': (u'blocklist', [u'blocklist']),
u'blockquote': (u'blockquote', [u'blockquote']),
u'blog': (u'blog', [u'blog', u'blogging']),
u'blogging': (u'blog', [u'blog', u'blogging']),
u'blue': (u'blue', [u'blue', u'bluetooth']),
u'bluetooth': (u'bluetooth', [u'bluetooth']),
u'bmp': (u'bmp', [u'bmp']),
u'bodies': (u'bod', [u'bodies', u'body']),
u'body': (u'bod', [u'bodies', u'body']),
u'bold': (u'bold', [u'bold']),
u'book': (u'book', [u'book', u'bookmark', u'bookmarked', u'bookmarks']),
u'bookmark': (u'bookmark', [u'bookmark', u'bookmarked', u'bookmarks']),
u'bookmarked': (u'bookmark', [u'bookmark', u'bookmarked', u'bookmarks']),
u'bookmarks': (u'bookmark', [u'bookmark', u'bookmarked', u'bookmarks']),
u'border': (u'border', [u'border']),
u'both': (u'both', [u'both']),
u'bottom': (u'bottom', [u'bottom']),
u'bound': (u'bound', [u'bound']),
u'box': (u'box', [u'box', u'boxes', u'boxtile']),
u'boxes': (u'box', [u'box', u'boxes', u'boxtile']),
u'boxtile': (u'boxtile', [u'boxtile']),
u'br': (u'br-html', [u'br']),
u'brackets': (u'bracket', [u'brackets']),
u'breach': (u'breach', [u'breach']),
u'breadcrumb': (u'breadcrumb', [u'breadcrumb']),
u'break': (u'break', [u'break', u'breakpoint', u'breakpoints', u'breaks']),
u'breakpoint': (u'breakpoint', [u'breakpoint', u'breakpoints']),
u'breakpoints': (u'breakpoint', [u'breakpoint', u'breakpoints']),
u'breaks': (u'break', [u'break', u'breakpoint', u'breakpoints', u'breaks']),
u'brightness': (u'brightness', [u'brightness']),
u'bring': (u'bring', [u'bring']),
u'broken': (u'broken', [u'broken']),
u'browse': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'browsed': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'browser': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'browser-specific': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'browsers': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'browsing': (u'brows', [u'browse', u'browsed', u'browser', u'browser-specific', u'browsers', u'browsing']),
u'bug': (u'bug', [u'bug', u'bugs.opera.com']),
u'bugs.opera.com': (u'bugs.opera.com', [u'bugs.opera.com']),
u'build': (u'build', [u'build']),
u'built-in': (u'built-in', [u'built-in']),
u'bullets': (u'bullet', [u'bullets']),
u'business': (u'business', [u'business']),
u'busy': (u'busy', [u'busy']),
u'but': (u'but-conjunction', [u'but']),
u'button': (u'button', [u'button', u'buttons']),
u'buttons': (u'button', [u'button', u'buttons']),
u'buy': (u'buy', [u'buy', u'buying']),
u'buying': (u'buy', [u'buy', u'buying']),
u'by': (u'by-preposition', [u'by']),
u'byte': (u'byte', [u'byte', u'bytes']),
u'bytes': (u'byte', [u'byte', u'bytes']),
u'c5e': (u'c5e', [u'c5e']),
u'cache': (u'cach', [u'cache', u'cached', u'caching']),
u'cached': (u'cach', [u'cache', u'cached', u'caching']),
u'caching': (u'cach', [u'cache', u'cached', u'caching']),
u'calculation': (u'calculation', [u'calculation']),
u'calendar': (u'calendar', [u'calendar']),
u'calibrate': (u'calibrate', [u'calibrate']),
u'call': (u'call', [u'call', u'called', u'calls']),
u'called': (u'call', [u'call', u'called', u'calls']),
u'calls': (u'call', [u'call', u'called', u'calls']),
u'came': (u'came', [u'came', u'camera']),
u'camera': (u'camera', [u'camera']),
u'can': (u'can', [u'can', u'canadian', u'cancel', u'canceled', u'canceling', u'cancelled', u'cannot']),
u'canadian': (u'canadian', [u'canadian']),
u'cancel': (u'cancel', [u'cancel', u'canceled', u'canceling', u'cancelled']),
u'canceled': (u'cancel', [u'cancel', u'canceled', u'canceling', u'cancelled']),
u'canceling': (u'cancel', [u'cancel', u'canceled', u'canceling', u'cancelled']),
u'cancelled': (u'cancel', [u'cancel', u'canceled', u'canceling', u'cancelled']),
u'cannot': (u'cannot', [u'cannot']),
u'capable': (u'capable', [u'capable']),
u'capture': (u'capture', [u'capture']),
u'card': (u'card', [u'card', u'cardreader']),
u'cardreader': (u'cardreader', [u'cardreader']),
u'cascade': (u'cascade', [u'cascade']),
u'case': (u'case', [u'case']),
u'cast': (u'cast', [u'cast']),
u'catalog': (u'catalog', [u'catalog']),
u'categories': (u'categor', [u'categories', u'category']),
u'category': (u'categor', [u'categories', u'category']),
u'cause': (u'caus', [u'cause', u'causing']),
u'causing': (u'caus', [u'cause', u'causing']),
u'caution': (u'caution', [u'caution']),
u'cc': (u'cc', [u'cc']),
u'cdata': (u'cdata', [u'cdata']),
u'celtic': (u'celtic', [u'celtic']),
u'center': (u'center', [u'center']),
u'centimeters': (u'centimeters', [u'centimeters']),
u'central': (u'central', [u'central']),
u'cept': (u'cept', [u'cept']),
u'cer': (u'cer', [u'cer', u'certain', u'certain-sized', u'certificate', u'certificates', u'certify']),
u'certain': (u'certain', [u'certain', u'certain-sized']),
u'certain-sized': (u'certain-sized', [u'certain-sized']),
u'certificate': (u'certif', [u'certificate', u'certificates', u'certify']),
u'certificates': (u'certif', [u'certificate', u'certificates', u'certify']),
u'certify': (u'certif', [u'certificate', u'certificates', u'certify']),
u'chain': (u'chain', [u'chain']),
u'change': (u'chang', [u'change', u'changed', u'changelog', u'changes', u'changing']),
u'changed': (u'chang', [u'change', u'changed', u'changelog', u'changes', u'changing']),
u'changelog': (u'chang', [u'change', u'changed', u'changelog', u'changes', u'changing']),
u'changes': (u'chang', [u'change', u'changed', u'changelog', u'changes', u'changing']),
u'changing': (u'chang', [u'change', u'changed', u'changelog', u'changes', u'changing']),
u'channel': (u'channel', [u'channel', u'channels']),
u'channels': (u'channel', [u'channel', u'channels']),
u'character': (u'character', [u'character', u'characters']),
u'characters': (u'character', [u'character', u'characters']),
u'charge': (u'charge', [u'charge', u'charges']),
u'charges': (u'charge', [u'charge', u'charges']),
u'chat': (u'chat', [u'chat']),
u'check': (u'check', [u'check', u'checked', u'checker', u'checking']),
u'checked': (u'check', [u'check', u'checked', u'checker', u'checking']),
u'checker': (u'check', [u'check', u'checked', u'checker', u'checking']),
u'checking': (u'check', [u'check', u'checked', u'checker', u'checking']),
u'cheeky': (u'cheeky', [u'cheeky']),
u'cherokee': (u'cherokee', [u'cherokee']),
u'children': (u'children', [u'children']),
u'chinese': (u'chinese', [u'chinese']),
u'choice': (u'choice', [u'choice', u'choices']),
u'choices': (u'choice', [u'choice', u'choices']),
u'choose': (u'choos', [u'choose', u'chooses', u'choosing']),
u'chooses': (u'choos', [u'choose', u'chooses', u'choosing']),
u'choosing': (u'choos', [u'choose', u'chooses', u'choosing']),
u'chosen': (u'chosen', [u'chosen']),
u'cipher': (u'cipher', [u'cipher', u'ciphers']),
u'ciphers': (u'cipher', [u'cipher', u'ciphers']),
u'city': (u'city', [u'city']),
u'cjk': (u'cjk', [u'cjk']),
u'class': (u'class', [u'class', u'classes', u'classic', u'classification', u'classified']),
u'classes': (u'class', [u'class', u'classes', u'classic', u'classification', u'classified']),
u'classic': (u'class', [u'class', u'classes', u'classic', u'classification', u'classified']),
u'classification': (u'classif', [u'classification', u'classified']),
u'classified': (u'classif', [u'classification', u'classified']),
u'clean': (u'clean', [u'clean', u'cleanup']),
u'cleanup': (u'cleanup', [u'cleanup']),
u'clear': (u'clear', [u'clear', u'cleared', u'clearing']),
u'cleared': (u'clear', [u'clear', u'cleared', u'clearing']),
u'clearing': (u'clear', [u'clear', u'cleared', u'clearing']),
u'click': (u'click', [u'click', u'clicked', u'clicking']),
u'clicked': (u'click', [u'click', u'clicked', u'clicking']),
u'clicking': (u'click', [u'click', u'clicked', u'clicking']),
u'client': (u'client', [u'client', u'clients']),
u'clients': (u'client', [u'client', u'clients']),
u'clipboard': (u'clipboard', [u'clipboard']),
u'clock': (u'clock', [u'clock']),
u'clone': (u'clone', [u'clone']),
u'close': (u'clos', [u'close', u'closed', u'closing']),
u'closed': (u'clos', [u'close', u'closed', u'closing']),
u'closing': (u'clos', [u'close', u'closed', u'closing']),
u'cm': (u'cm', [u'cm']),
u'code': (u'code', [u'code', u'code-signing', u'codepage']),
u'code-signing': (u'code-signing', [u'code-signing']),
u'codepage': (u'codepage', [u'codepage']),
u'coefficient': (u'coefficient', [u'coefficient']),
u'collapse': (u'collaps', [u'collapse', u'collapsed']),
u'collapsed': (u'collaps', [u'collapse', u'collapsed']),
u'collect': (u'collect', [u'collect', u'collected']),
u'collected': (u'collect', [u'collect', u'collected']),
u'colon': (u'col', [u'collapse', u'collapsed', u'collect', u'collected', u'colon', u'color', u'colorize', u'colorized', u'colors', u'column', u'columns']),
u'color': (u'color', [u'color', u'colorize', u'colorized', u'colors']),
u'colorize': (u'color', [u'color', u'colorize', u'colorized', u'colors']),
u'colorized': (u'color', [u'color', u'colorize', u'colorized', u'colors']),
u'colors': (u'color', [u'color', u'colorize', u'colorized', u'colors']),
u'column': (u'column', [u'column', u'columns']),
u'columns': (u'column', [u'column', u'columns']),
u'come': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'comma': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'comma-separated': (u'comma-separated', [u'comma-separated']),
u'command': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'command-line': (u'command', [u'command', u'command-line', u'commands']),
u'commands': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'comment': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'comments': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'commerce': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'common': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'communicate': (u'communicat', [u'communicate', u'communication']),
u'communication': (u'communicat', [u'communicate', u'communication']),
u'community': (u'com', [u'come', u'comma', u'comma-separated', u'command', u'command-line', u'commands', u'comment', u'comments', u'commerce', u'common', u'communicate', u'communication', u'community', u'company', u'comparison', u'compass', u'compatibility', u'compatible', u'compilation', u'complete', u'completed', u'completely', u'completes', u'completion', u'comply', u'component', u'components', u'compose', u'compress', u'compression', u'compromised', u'computed', u'computer', u'computers']),
u'company': (u'company', [u'company']),
u'comparison': (u'comparison', [u'comparison']),
u'compass': (u'compass', [u'compass']),
u'compatibility': (u'compat', [u'compatibility', u'compatible']),
u'compatible': (u'compat', [u'compatibility', u'compatible']),
u'compilation': (u'compilation', [u'compilation']),
u'complete': (u'complet', [u'complete', u'completed', u'completely', u'completes', u'completion']),
u'completed': (u'complet', [u'complete', u'completed', u'completely', u'completes', u'completion']),
u'completely': (u'complet', [u'complete', u'completed', u'completely', u'completes', u'completion']),
u'completes': (u'complet', [u'complete', u'completed', u'completely', u'completes', u'completion']),
u'completion': (u'complet', [u'complete', u'completed', u'completely', u'completes', u'completion']),
u'comply': (u'comply', [u'comply']),
u'component': (u'component', [u'component', u'components']),
u'components': (u'component', [u'component', u'components']),
u'compose': (u'compose', [u'compose']),
u'compress': (u'compress', [u'compress', u'compression']),
u'compression': (u'compress', [u'compress', u'compression']),
u'compromised': (u'compromised', [u'compromised']),
u'computed': (u'comput', [u'computed', u'computer', u'computers']),
u'computer': (u'comput', [u'computed', u'computer', u'computers']),
u'computers': (u'comput', [u'computed', u'computer', u'computers']),
u'condition': (u'condition', [u'condition', u'conditions']),
u'conditions': (u'condition', [u'condition', u'conditions']),
u'confidence': (u'confidence', [u'confidence']),
u'confidential': (u'confidential', [u'confidential']),
u'config': (u'config', [u'config', u'config.xml', u'configuration', u'configure', u'configured', u'configuring']),
u'config.xml': (u'config.xml', [u'config.xml']),
u'configuration': (u'configur', [u'configuration', u'configure', u'configured', u'configuring']),
u'configure': (u'configur', [u'configuration', u'configure', u'configured', u'configuring']),
u'configured': (u'configur', [u'configuration', u'configure', u'configured', u'configuring']),
u'configuring': (u'configur', [u'configuration', u'configure', u'configured', u'configuring']),
u'confirm': (u'confirm', [u'confirm', u'confirmation']),
u'confirmation': (u'confirm', [u'confirm', u'confirmation']),
u'conflict': (u'conflict', [u'conflict']),
u'connect': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'connected': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'connecting': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'connection': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'connections': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'connector': (u'connect', [u'connect', u'connected', u'connecting', u'connection', u'connections', u'connector']),
u'consider': (u'consider', [u'consider', u'considered']),
u'considered': (u'consider', [u'consider', u'considered']),
u'consistent': (u'consistent', [u'consistent']),
u'console': (u'console', [u'console']),
u'contact': (u'contact', [u'contact', u'contacting', u'contacts']),
u'contacting': (u'contact', [u'contact', u'contacting', u'contacts']),
u'contacts': (u'contact', [u'contact', u'contacting', u'contacts']),
u'contain': (u'contain', [u'contain', u'containing', u'contains']),
u'containing': (u'contain', [u'contain', u'containing', u'contains']),
u'contains': (u'contain', [u'contain', u'containing', u'contains']),
u'content': (u'content', [u'content', u'content-length', u'contents']),
u'content-length': (u'content', [u'content', u'content-length', u'contents']),
u'contents': (u'content', [u'content', u'content-length', u'contents']),
u'context': (u'context', [u'context', u'contexts']),
u'contexts': (u'context', [u'context', u'contexts']),
u'continually': (u'continu', [u'continually', u'continue', u'continueto', u'continuing']),
u'continue': (u'continu', [u'continually', u'continue', u'continueto', u'continuing']),
u'continueto': (u'continu', [u'continually', u'continue', u'continueto', u'continuing']),
u'continuing': (u'continu', [u'continually', u'continue', u'continueto', u'continuing']),
u'contrast': (u'contrast', [u'contrast']),
u'contribute': (u'contribut', [u'contribute', u'contributions']),
u'contributions': (u'contribut', [u'contribute', u'contributions']),
u'control': (u'control', [u'control', u'controls']),
u'controls': (u'control', [u'control', u'controls']),
u'convenient': (u'convenient', [u'convenient']),
u'conversation': (u'conversation', [u'conversation', u'conversations']),
u'conversations': (u'conversation', [u'conversation', u'conversations']),
u'converted': (u'convert', [u'converted', u'converting']),
u'converting': (u'convert', [u'converted', u'converting']),
u'cookbook': (u'cookbook', [u'cookbook']),
u'cookie': (u'cookie', [u'cookie', u'cookies']),
u'cookies': (u'cookie', [u'cookie', u'cookies']),
u'cool': (u'cool', [u'cool']),
u'copied': (u'cop', [u'copied', u'copies', u'copy', u'copying', u'copyright', u'copyrightholder']),
u'copies': (u'cop', [u'copied', u'copies', u'copy', u'copying', u'copyright', u'copyrightholder']),
u'copy': (u'cop', [u'copied', u'copies', u'copy', u'copying', u'copyright', u'copyrightholder']),
u'copying': (u'cop', [u'copied', u'copies', u'copy', u'copying', u'copyright', u'copyrightholder']),
u'copyright': (u'copy', [u'copy', u'copying', u'copyright', u'copyrightholder']),
u'copyrightholder': (u'copyrightholder', [u'copyrightholder']),
u'corner': (u'corner', [u'corner']),
u'correct': (u'correct', [u'correct', u'corrected', u'correctly']),
u'corrected': (u'correct', [u'correct', u'corrected', u'correctly']),
u'correctly': (u'correct', [u'correct', u'corrected', u'correctly']),
u'correspond': (u'correspond', [u'correspond', u'corresponds']),
u'corresponds': (u'correspond', [u'correspond', u'corresponds']),
u'corrupt': (u'corrupt', [u'corrupt', u'corrupted', u'corruption']),
u'corrupted': (u'corrupt', [u'corrupt', u'corrupted', u'corruption']),
u'corruption': (u'corrupt', [u'corrupt', u'corrupted', u'corruption']),
u'cost': (u'cost', [u'cost', u'costs']),
u'costs': (u'cost', [u'cost', u'costs']),
u'could': (u'could', [u'could', u'couldn']),
u'couldn': (u'couldn', [u'couldn']),
u'count': (u'count', [u'count', u'countries', u'country']),
u'countries': (u'countr', [u'countries', u'country']),
u'country': (u'countr', [u'countries', u'country']),
u'coverage': (u'coverage', [u'coverage']),
u'covers': (u'covers', [u'covers']),
u'crash': (u'crash', [u'crash', u'crashed']),
u'crashed': (u'crash', [u'crash', u'crashed']),
u'crazy': (u'crazy', [u'crazy']),
u'create': (u'creat', [u'create', u'created', u'creating', u'creation', u'creator']),
u'created': (u'creat', [u'create', u'created', u'creating', u'creation', u'creator']),
u'creating': (u'creat', [u'create', u'created', u'creating', u'creation', u'creator']),
u'creation': (u'creat', [u'create', u'created', u'creating', u'creation', u'creator']),
u'creator': (u'creat', [u'create', u'created', u'creating', u'creation', u'creator']),
u'credentials': (u'credentials', [u'credentials']),
u'criminals': (u'criminals', [u'criminals']),
u'crimson': (u'crimson', [u'crimson']),
u'criteria': (u'criteria', [u'criteria']),
u'critical': (u'critical', [u'critical']),
u'crl': (u'crl', [u'crl']),
u'cross': (u'cross', [u'cross']),
u'crt': (u'crt', [u'crt']),
u'crying': (u'crying', [u'crying']),
u'css': (u'css', [u'css']),
u'csv': (u'csv', [u'csv']),
u'ctrl': (u'ctrl', [u'ctrl']),
u'cu': (u'cu', [u'cu', u'cups', u'currency', u'current', u'currently', u'cursive', u'cursor', u'custom', u'customizations', u'customize', u'customized', u'customizing', u'cut', u'cutting-edge']),
u'cups': (u'cups', [u'cups']),
u'currency': (u'currency', [u'currency']),
u'current': (u'current', [u'current', u'currently']),
u'currently': (u'current', [u'current', u'currently']),
u'cursive': (u'curs', [u'cursive', u'cursor']),
u'cursor': (u'curs', [u'cursive', u'cursor']),
u'custom': (u'custom', [u'custom', u'customizations', u'customize', u'customized', u'customizing']),
u'customizations': (u'custom', [u'custom', u'customizations', u'customize', u'customized', u'customizing']),
u'customize': (u'custom', [u'custom', u'customizations', u'customize', u'customized', u'customizing']),
u'customized': (u'custom', [u'custom', u'customizations', u'customize', u'customized', u'customizing']),
u'customizing': (u'custom', [u'custom', u'customizations', u'customize', u'customized', u'customizing']),
u'cut': (u'cut', [u'cut', u'cutting-edge']),
u'cutting-edge': (u'cutting-edge', [u'cutting-edge']),
u'cycle': (u'cycl', [u'cycle', u'cycling']),
u'cycling': (u'cycl', [u'cycle', u'cycling']),
u'cyrillic': (u'cyrillic', [u'cyrillic']),
u'daily': (u'daily', [u'daily']),
u'dalnet': (u'dalnet', [u'dalnet']),
u'dangerous': (u'dangerous', [u'dangerous']),
u'dark': (u'dark', [u'dark']),
u'data': (u'dat', [u'data', u'database', u'databases', u'date', u'dates']),
u'database': (u'database', [u'database', u'databases']),
u'databases': (u'database', [u'database', u'databases']),
u'date': (u'date', [u'date', u'dates']),
u'dates': (u'date', [u'date', u'dates']),
u'day': (u'day', [u'day', u'daylight', u'days']),
u'daylight': (u'day', [u'day', u'daylight', u'days']),
u'days': (u'day', [u'day', u'daylight', u'days']),
u'dcc': (u'dcc', [u'dcc']),
u'dd': (u'dd', [u'dd']),
u'deactivate': (u'deactivat', [u'deactivate', u'deactivated', u'deactivating']),
u'deactivated': (u'deactivat', [u'deactivate', u'deactivated', u'deactivating']),
u'deactivating': (u'deactivat', [u'deactivate', u'deactivated', u'deactivating']),
u'dear': (u'dear', [u'dear']),
u'debug': (u'debug', [u'debug', u'debugged', u'debugger', u'debugging']),
u'debugged': (u'debugg', [u'debugged', u'debugger', u'debugging']),
u'debugger': (u'debugg', [u'debugged', u'debugger', u'debugging']),
u'debugging': (u'debugg', [u'debugged', u'debugger', u'debugging']),
u'dec': (u'dec', [u'dec', u'december', u'decide', u'deck', u'declaration', u'declarations', u'decline', u'decoding', u'decompressing', u'decoration', u'decrease']),
u'december': (u'december', [u'december']),
u'decide': (u'decide', [u'decide']),
u'deck': (u'deck', [u'deck']),
u'declaration': (u'declaration', [u'declaration', u'declarations']),
u'declarations': (u'declaration', [u'declaration', u'declarations']),
u'decline': (u'decline', [u'decline']),
u'decoding': (u'decoding', [u'decoding']),
u'decompressing': (u'decompressing', [u'decompressing']),
u'decoration': (u'decoration', [u'decoration']),
u'decrease': (u'decrease', [u'decrease']),
u'default': (u'default', [u'default', u'defaults']),
u'defaults': (u'default', [u'default', u'defaults']),
u'define': (u'defin', [u'define', u'defined']),
u'defined': (u'defin', [u'define', u'defined']),
u'del': (u'del', [u'del', u'delete', u'deleted', u'deletes', u'deleting', u'deletion', u'delimited', u'deliver', u'delivery']),
u'delete': (u'delet', [u'delete', u'deleted', u'deletes', u'deleting', u'deletion']),
u'deleted': (u'delet', [u'delete', u'deleted', u'deletes', u'deleting', u'deletion']),
u'deletes': (u'delet', [u'delete', u'deleted', u'deletes', u'deleting', u'deletion']),
u'deleting': (u'delet', [u'delete', u'deleted', u'deletes', u'deleting', u'deletion']),
u'deletion': (u'delet', [u'delete', u'deleted', u'deletes', u'deleting', u'deletion']),
u'delimited': (u'delimited', [u'delimited']),
u'deliver': (u'deliver', [u'deliver', u'delivery']),
u'delivery': (u'deliver', [u'deliver', u'delivery']),
u'demand': (u'demand', [u'demand']),
u'denied': (u'den', [u'denied', u'density', u'deny']),
u'density': (u'den', [u'denied', u'density', u'deny']),
u'deny': (u'den', [u'denied', u'density', u'deny']),
u'deop': (u'deop', [u'deop']),
u'dep': (u'dep', [u'dep', u'department', u'dependency', u'depth']),
u'department': (u'department', [u'department']),
u'dependency': (u'dependency', [u'dependency']),
u'depth': (u'depth', [u'depth']),
u'der': (u'der', [u'der']),
u'descending': (u'descending', [u'descending']),
u'describe': (u'describe', [u'describe']),
u'description': (u'descript', [u'description', u'descriptions', u'descriptive', u'descriptor']),
u'descriptions': (u'descript', [u'description', u'descriptions', u'descriptive', u'descriptor']),
u'descriptive': (u'descript', [u'description', u'descriptions', u'descriptive', u'descriptor']),
u'descriptor': (u'descript', [u'description', u'descriptions', u'descriptive', u'descriptor']),
u'deselect': (u'deselect', [u'deselect']),
u'design': (u'design', [u'design']),
u'desk': (u'desk', [u'desk', u'desktop']),
u'desktop': (u'desktop', [u'desktop']),
u'destination': (u'destination', [u'destination']),
u'detach': (u'detach', [u'detach']),
u'detail': (u'detail', [u'detail', u'detailed', u'details']),
u'detailed': (u'detail', [u'detail', u'detailed', u'details']),
u'details': (u'detail', [u'detail', u'detailed', u'details']),
u'detect': (u'detect', [u'detect', u'detected', u'detection']),
u'detected': (u'detect', [u'detect', u'detected', u'detection']),
u'detection': (u'detect', [u'detect', u'detected', u'detection']),
u'determine': (u'determin', [u'determine', u'determined']),
u'determined': (u'determin', [u'determine', u'determined']),
u'dev.opera.com': (u'dev.opera.com', [u'dev.opera.com']),
u'devanagari': (u'devanagari', [u'devanagari']),
u'develop': (u'develop', [u'develop', u'developed', u'developer', u'developers', u'development']),
u'developed': (u'develop', [u'develop', u'developed', u'developer', u'developers', u'development']),
u'developer': (u'develop', [u'develop', u'developed', u'developer', u'developers', u'development']),
u'developers': (u'develop', [u'develop', u'developed', u'developer', u'developers', u'development']),
u'development': (u'develop', [u'develop', u'developed', u'developer', u'developers', u'development']),
u'device': (u'device', [u'device', u'devices']),
u'devices': (u'device', [u'device', u'devices']),
u'devoice': (u'devoice', [u'devoice']),
u'dh': (u'dh', [u'dh']),
u'dial': (u'dial', [u'dial', u'dial-up', u'dialog', u'dialogs', u'dialup']),
u'dial-up': (u'dial-up', [u'dial-up']),
u'dialog': (u'dialog', [u'dialog', u'dialogs']),
u'dialogs': (u'dialog', [u'dialog', u'dialogs']),
u'dialup': (u'dialup', [u'dialup']),
u'dictionaries': (u'dictionar', [u'dictionaries', u'dictionary']),
u'dictionary': (u'dictionar', [u'dictionaries', u'dictionary']),
u'did': (u'did', [u'did', u'didn']),
u'didn': (u'didn', [u'didn']),
u'different': (u'different', [u'different', u'differently']),
u'differently': (u'different', [u'different', u'differently']),
u'digest': (u'digest', [u'digest']),
u'digital': (u'digital', [u'digital']),
u'dimensions': (u'dimensions', [u'dimensions']),
u'dir': (u'dir', [u'dir', u'direct', u'direction', u'directly', u'directories', u'directory']),
u'direct': (u'direct', [u'direct', u'direction', u'directly', u'directories', u'directory']),
u'direction': (u'direct', [u'direct', u'direction', u'directly', u'directories', u'directory']),
u'directly': (u'direct', [u'direct', u'direction', u'directly', u'directories', u'directory']),
u'directories': (u'direct', [u'direct', u'direction', u'directly', u'directories', u'directory']),
u'directory': (u'direct', [u'direct', u'direction', u'directly', u'directories', u'directory']),
u'disable': (u'disabl', [u'disable', u'disabled', u'disabling']),
u'disabled': (u'disabl', [u'disable', u'disabled', u'disabling']),
u'disabling': (u'disabl', [u'disable', u'disabled', u'disabling']),
u'disagree': (u'disagree', [u'disagree']),
u'disapproved': (u'disapproved', [u'disapproved']),
u'discard': (u'discard', [u'discard', u'discarded']),
u'discarded': (u'discard', [u'discard', u'discarded']),
u'disconnect': (u'disconnect', [u'disconnect', u'disconnected']),
u'disconnected': (u'disconnect', [u'disconnect', u'disconnected']),
u'discontinued': (u'discontinued', [u'discontinued']),
u'discouraged': (u'discourag', [u'discouraged', u'discourages']),
u'discourages': (u'discourag', [u'discouraged', u'discourages']),
u'discover': (u'discover', [u'discover', u'discovery']),
u'discovery': (u'discover', [u'discover', u'discovery']),
u'disk': (u'disk', [u'disk', u'diskspace']),
u'diskspace': (u'diskspace', [u'diskspace']),
u'dismiss': (u'dismiss', [u'dismiss']),
u'display': (u'display', [u'display', u'displayed', u'displaying']),
u'displayed': (u'display', [u'display', u'displayed', u'displaying']),
u'displaying': (u'display', [u'display', u'displayed', u'displaying']),
u'distance': (u'distance', [u'distance']),
u'distinguish': (u'distinguish', [u'distinguish']),
u'distributing': (u'distribut', [u'distributing', u'distribution']),
u'distribution': (u'distribut', [u'distributing', u'distribution']),
u'dkb': (u'dkb', [u'dkb']),
u'dle': (u'dle', [u'dle']),
u'dll': (u'dll', [u'dll']),
u'dmb': (u'dmb', [u'dmb']),
u'dns': (u'dns', [u'dns']),
u'do': (u'do', [u'do', u'dock', u'document', u'documentation', u'documents', u'does', u'doing', u'dom', u'domain', u'domains', u'don', u'done', u'double', u'double-click', u'doubles', u'down', u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'dock': (u'dock', [u'dock']),
u'document': (u'document', [u'document', u'documentation', u'documents']),
u'documentation': (u'document', [u'document', u'documentation', u'documents']),
u'documents': (u'document', [u'document', u'documentation', u'documents']),
u'does': (u'does', [u'does']),
u'doing': (u'doing', [u'doing']),
u'dom': (u'dom', [u'dom', u'domain', u'domains']),
u'domain': (u'domain', [u'domain', u'domains']),
u'domains': (u'domain', [u'domain', u'domains']),
u'don': (u'don', [u'don', u'done']),
u'done': (u'done', [u'done']),
u'double': (u'double', [u'double', u'double-click', u'doubles']),
u'double-click': (u'double', [u'double', u'double-click', u'doubles']),
u'doubles': (u'double', [u'double', u'double-click', u'doubles']),
u'down': (u'down', [u'down', u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'download': (u'download', [u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'downloaded': (u'download', [u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'downloading': (u'download', [u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'downloads': (u'download', [u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'downloads-list': (u'download', [u'download', u'downloaded', u'downloading', u'downloads', u'downloads-list']),
u'draft': (u'draft', [u'draft', u'drafts']),
u'drafts': (u'draft', [u'draft', u'drafts']),
u'drag': (u'drag', [u'drag', u'dragged-and-dropped', u'dragging', u'dragonfly']),
u'dragged-and-dropped': (u'dragged-and-dropped', [u'dragged-and-dropped']),
u'dragging': (u'dragging', [u'dragging']),
u'dragonfly': (u'dragonfly', [u'dragonfly']),
u'draw': (u'draw', [u'draw']),
u'drive': (u'driv', [u'drive', u'driver', u'drivers', u'drives']),
u'driver': (u'driv', [u'drive', u'driver', u'drivers', u'drives']),
u'drivers': (u'driv', [u'drive', u'driver', u'drivers', u'drives']),
u'drives': (u'driv', [u'drive', u'driver', u'drivers', u'drives']),
u'drm': (u'drm', [u'drm']),
u'drop': (u'drop', [u'drop', u'dropdown', u'dropped']),
u'dropdown': (u'dropdown', [u'dropdown']),
u'dropped': (u'dropped', [u'dropped']),
u'dsa': (u'dsa', [u'dsa']),
u'due': (u'due', [u'due']),
u'duplicate': (u'duplicate', [u'duplicate', u'duplicates']),
u'duplicates': (u'duplicate', [u'duplicate', u'duplicates']),
u'duration': (u'duration', [u'duration']),
u'during': (u'during', [u'during']),
u'dynamic': (u'dynamic', [u'dynamic']),
u'e.g': (u'e.g', [u'e.g']),
u'each': (u'each', [u'each']),
u'earlier': (u'earlier', [u'earlier']),
u'ease': (u'eas', [u'ease', u'easier', u'easily', u'east', u'easy']),
u'easier': (u'easi', [u'easier', u'easily']),
u'easily': (u'easi', [u'easier', u'easily']),
u'east': (u'eas', [u'ease', u'easier', u'easily', u'east', u'easy']),
u'easy': (u'eas', [u'ease', u'easier', u'easily', u'east', u'easy']),
u'eavesdrop': (u'eavesdrop', [u'eavesdrop', u'eavesdropping']),
u'eavesdropping': (u'eavesdropping', [u'eavesdropping']),
u'ebay.com': (u'ebay.com', [u'ebay.com']),
u'edge': (u'edge', [u'edge']),
u'edit': (u'edit', [u'edit', u'edited', u'editing', u'edition', u'editor']),
u'edited': (u'edit', [u'edit', u'edited', u'editing', u'edition', u'editor']),
u'editing': (u'edit', [u'edit', u'edited', u'editing', u'edition', u'editor']),
u'edition': (u'edit', [u'edit', u'edited', u'editing', u'edition', u'editor']),
u'editor': (u'edit', [u'edit', u'edited', u'editing', u'edition', u'editor']),
u'education': (u'education', [u'education']),
u'effect': (u'effect', [u'effect', u'effects']),
u'effects': (u'effect', [u'effect', u'effects']),
u'efficient': (u'efficient', [u'efficient']),
u'effortless': (u'effortless', [u'effortless', u'effortlessly']),
u'effortlessly': (u'effortless', [u'effortless', u'effortlessly']),
u'efforts': (u'efforts', [u'efforts']),
u'efnet': (u'efnet', [u'efnet']),
u'either': (u'either', [u'either']),
u'elapsed': (u'elapsed', [u'elapsed']),
u'electronic': (u'electronic', [u'electronic']),
u'elegant': (u'elegant', [u'elegant']),
u'element': (u'element', [u'element', u'elements']),
u'elements': (u'element', [u'element', u'elements']),
u'eload': (u'eload', [u'eload']),
u'email': (u'email', [u'email', u'emails']),
u'emails': (u'email', [u'email', u'emails']),
u'embedded': (u'embedded', [u'embedded']),
u'emptied': (u'empt', [u'emptied', u'empty', u'emptying']),
u'empty': (u'empt', [u'emptied', u'empty', u'emptying']),
u'emptying': (u'empt', [u'emptied', u'empty', u'emptying']),
u'emulate': (u'emulat', [u'emulate', u'emulator']),
u'emulator': (u'emulat', [u'emulate', u'emulator']),
u'enable': (u'enabl', [u'enable', u'enabled', u'enables', u'enabling']),
u'enabled': (u'enabl', [u'enable', u'enabled', u'enables', u'enabling']),
u'enables': (u'enabl', [u'enable', u'enabled', u'enables', u'enabling']),
u'enabling': (u'enabl', [u'enable', u'enabled', u'enables', u'enabling']),
u'encode': (u'encod', [u'encode', u'encoded', u'encoding']),
u'encoded': (u'encod', [u'encode', u'encoded', u'encoding']),
u'encoding': (u'encod', [u'encode', u'encoded', u'encoding']),
u'encountered': (u'encounter', [u'encountered', u'encountering']),
u'encountering': (u'encounter', [u'encountered', u'encountering']),
u'encourage': (u'encourage', [u'encourage']),
u'encrypt': (u'encrypt', [u'encrypt', u'encrypted', u'encrypting', u'encryption']),
u'encrypted': (u'encrypt', [u'encrypt', u'encrypted', u'encrypting', u'encryption']),
u'encrypting': (u'encrypt', [u'encrypt', u'encrypted', u'encrypting', u'encryption']),
u'encryption': (u'encrypt', [u'encrypt', u'encrypted', u'encrypting', u'encryption']),
u'encyclopedia': (u'encyclopedia', [u'encyclopedia']),
u'end': (u'end', [u'end', u'endpoint', u'ends']),
u'endpoint': (u'end', [u'end', u'endpoint', u'ends']),
u'ends': (u'end', [u'end', u'endpoint', u'ends']),
u'energy': (u'energy', [u'energy']),
u'engine': (u'engine', [u'engine', u'engines']),
u'engines': (u'engine', [u'engine', u'engines']),
u'english': (u'english', [u'english']),
u'enhanced': (u'enhanc', [u'enhanced', u'enhancements']),
u'enhancements': (u'enhanc', [u'enhanced', u'enhancements']),
u'enjoy': (u'enjoy', [u'enjoy', u'enjoyable']),
u'enjoyable': (u'enjoy', [u'enjoy', u'enjoyable']),
u'enough': (u'enough', [u'enough']),
u'ensure': (u'ensure', [u'ensure']),
u'enter': (u'enter', [u'enter', u'entered', u'entering', u'entertainment']),
u'entered': (u'enter', [u'enter', u'entered', u'entering', u'entertainment']),
u'entering': (u'enter', [u'enter', u'entered', u'entering', u'entertainment']),
u'entertainment': (u'enter', [u'enter', u'entered', u'entering', u'entertainment']),
u'entire': (u'ent', [u'enter', u'entered', u'entering', u'entertainment', u'entire', u'entity', u'entries', u'entry']),
u'entity': (u'ent', [u'enter', u'entered', u'entering', u'entertainment', u'entire', u'entity', u'entries', u'entry']),
u'entries': (u'entr', [u'entries', u'entry']),
u'entry': (u'entr', [u'entries', u'entry']),
u'envelope': (u'envelope', [u'envelope']),
u'environment': (u'environment', [u'environment']),
u'equal': (u'equal', [u'equal']),
u'equipment': (u'equipment', [u'equipment']),
u'equivalent': (u'equivalent', [u'equivalent']),
u'erased': (u'erased', [u'erased']),
u'err': (u'err', [u'err', u'erroneous', u'error', u'errors']),
u'erroneous': (u'err', [u'err', u'erroneous', u'error', u'errors']),
u'error': (u'err', [u'err', u'erroneous', u'error', u'errors']),
u'errors': (u'err', [u'err', u'erroneous', u'error', u'errors']),
u'es262-32.dll': (u'es262-32.dll', [u'es262-32.dll']),
u'esc': (u'esc', [u'esc']),
u'establish': (u'establish', [u'establish', u'established']),
u'established': (u'establish', [u'establish', u'established']),
u'estimated': (u'estimated', [u'estimated']),
u'etc': (u'etc', [u'etc']),
u'ethiopic': (u'ethiopic', [u'ethiopic']),
u'euc-jp': (u'euc-jp', [u'euc-jp']),
u'euc-kr': (u'euc-kr', [u'euc-kr']),
u'euc-tw': (u'euc-tw', [u'euc-tw']),
u'eudora': (u'eudora', [u'eudora', u'eudora.ini']),
u'eudora.ini': (u'eudora.ini', [u'eudora.ini']),
u'eula': (u'eula', [u'eula']),
u'europe': (u'europe', [u'europe', u'european']),
u'european': (u'european', [u'european']),
u'eval': (u'eval', [u'eval', u'evaluation']),
u'evaluation': (u'evaluation', [u'evaluation']),
u'even': (u'even', [u'even', u'event', u'event-handler', u'events']),
u'event': (u'event', [u'event', u'event-handler', u'events']),
u'event-handler': (u'event', [u'event', u'event-handler', u'events']),
u'events': (u'event', [u'event', u'event-handler', u'events']),
u'every': (u'every', [u'every', u'everyone']),
u'everyone': (u'everyone', [u'everyone']),
u'exact': (u'exact', [u'exact']),
u'example': (u'example', [u'example', u'examples']),
u'examples': (u'example', [u'example', u'examples']),
u'exceeded': (u'exceed', [u'exceeded', u'exceeds']),
u'exceeds': (u'exceed', [u'exceeded', u'exceeds']),
u'excellent': (u'excellent', [u'excellent']),
u'except': (u'except', [u'except', u'exception', u'exceptions']),
u'exception': (u'except', [u'except', u'exception', u'exceptions']),
u'exceptions': (u'except', [u'except', u'exception', u'exceptions']),
u'exchange': (u'exchang', [u'exchange', u'exchanging']),
u'exchanging': (u'exchang', [u'exchange', u'exchanging']),
u'exciting': (u'exciting', [u'exciting']),
u'excluding': (u'excluding', [u'excluding']),
u'exe': (u'exe', [u'exe', u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'executable': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'executed': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'executes': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'executing': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'execution': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'executive': (u'execut', [u'executable', u'executed', u'executes', u'executing', u'execution', u'executive']),
u'exist': (u'exist', [u'exist', u'existing', u'exists']),
u'existing': (u'exist', [u'exist', u'existing', u'exists']),
u'exists': (u'exist', [u'exist', u'existing', u'exists']),
u'exit': (u'exit', [u'exit', u'exiting']),
u'exiting': (u'exit', [u'exit', u'exiting']),
u'expand': (u'expand', [u'expand', u'expanded']),
u'expanded': (u'expand', [u'expand', u'expanded']),
u'expectation': (u'expectation', [u'expectation']),
u'experiencing': (u'experiencing', [u'experiencing']),
u'expired': (u'expir', [u'expired', u'expires']),
u'expires': (u'expir', [u'expired', u'expires']),
u'explain': (u'explain', [u'explain']),
u'explore': (u'explor', [u'explore', u'explorer']),
u'explorer': (u'explor', [u'explore', u'explorer']),
u'exponent': (u'exponent', [u'exponent', u'exponent1', u'exponent2']),
u'exponent1': (u'exponent1', [u'exponent1']),
u'exponent2': (u'exponent2', [u'exponent2']),
u'export': (u'export', [u'export', u'exported', u'exporting']),
u'exported': (u'export', [u'export', u'exported', u'exporting']),
u'exporting': (u'export', [u'export', u'exported', u'exporting']),
u'exposure': (u'exposure', [u'exposure']),
u'express': (u'express', [u'express', u'expression']),
u'expression': (u'express', [u'express', u'expression']),
u'extended': (u'extend', [u'extended', u'extended-a', u'extended-b', u'extender']),
u'extended-a': (u'extend', [u'extended', u'extended-a', u'extended-b', u'extender']),
u'extended-b': (u'extend', [u'extended', u'extended-a', u'extended-b', u'extender']),
u'extender': (u'extend', [u'extended', u'extended-a', u'extended-b', u'extender']),
u'extension': (u'extension', [u'extension', u'extensions']),
u'extensions': (u'extension', [u'extension', u'extensions']),
u'external': (u'external', [u'external', u'externally']),
u'externally': (u'external', [u'external', u'externally']),
u'extra': (u'extra', [u'extra', u'extract', u'extracting']),
u'extract': (u'extract', [u'extract', u'extracting']),
u'extracting': (u'extract', [u'extract', u'extracting']),
u'f12': (u'f12', [u'f12']),
u'f4': (u'f4', [u'f4']),
u'face': (u'face', [u'face']),
u'failed': (u'fail', [u'failed', u'fails', u'failure']),
u'fails': (u'fail', [u'failed', u'fails', u'failure']),
u'failure': (u'fail', [u'failed', u'fails', u'failure']),
u'fake': (u'fake', [u'fake']),
u'fallback': (u'fallback', [u'fallback']),
u'familiar': (u'familiar', [u'familiar']),
u'family': (u'family', [u'family']),
u'fantasy': (u'fantasy', [u'fantasy']),
u'fast': (u'fast', [u'fast', u'faster']),
u'faster': (u'fast', [u'fast', u'faster']),
u'fatal': (u'fatal', [u'fatal']),
u'favicons': (u'favicons', [u'favicons']),
u'favorite': (u'favorite', [u'favorite', u'favorites']),
u'favorites': (u'favorite', [u'favorite', u'favorites']),
u'fax': (u'fax', [u'fax']),
u'fbo': (u'fbo', [u'fbo']),
u'fdn': (u'fdn', [u'fdn']),
u'feature': (u'featur', [u'feature', u'featured', u'features', u'featuring']),
u'featured': (u'featur', [u'feature', u'featured', u'features', u'featuring']),
u'features': (u'featur', [u'feature', u'featured', u'features', u'featuring']),
u'featuring': (u'featur', [u'feature', u'featured', u'features', u'featuring']),
u'feb': (u'feb', [u'feb', u'february']),
u'february': (u'february', [u'february']),
u'feed': (u'feed', [u'feed', u'feedback', u'feeds']),
u'feedback': (u'feed', [u'feed', u'feedback', u'feeds']),
u'feeds': (u'feed', [u'feed', u'feedback', u'feeds']),
u'feel': (u'feel', [u'feel']),
u'female': (u'female', [u'female']),
u'fetch': (u'fetch', [u'fetch', u'fetched', u'fetching']),
u'fetched': (u'fetch', [u'fetch', u'fetched', u'fetching']),
u'fetching': (u'fetch', [u'fetch', u'fetched', u'fetching']),
u'few': (u'few', [u'few', u'fewer']),
u'fewer': (u'few', [u'few', u'fewer']),
u'field': (u'field', [u'field', u'fieldname', u'fields']),
u'fieldname': (u'field', [u'field', u'fieldname', u'fields']),
u'fields': (u'field', [u'field', u'fieldname', u'fields']),
u'file': (u'file', [u'file', u'filename', u'files', u'filesystem', u'filetype']),
u'filename': (u'file', [u'file', u'filename', u'files', u'filesystem', u'filetype']),
u'files': (u'file', [u'file', u'filename', u'files', u'filesystem', u'filetype']),
u'filesystem': (u'file', [u'file', u'filename', u'files', u'filesystem', u'filetype']),
u'filetype': (u'file', [u'file', u'filename', u'files', u'filesystem', u'filetype']),
u'fill': (u'fil', [u'file', u'filename', u'files', u'filesystem', u'filetype', u'fill', u'film', u'filter', u'filtered', u'filtering', u'filters']),
u'film': (u'fil', [u'file', u'filename', u'files', u'filesystem', u'filetype', u'fill', u'film', u'filter', u'filtered', u'filtering', u'filters']),
u'filter': (u'filter', [u'filter', u'filtered', u'filtering', u'filters']),
u'filtered': (u'filter', [u'filter', u'filtered', u'filtering', u'filters']),
u'filtering': (u'filter', [u'filter', u'filtered', u'filtering', u'filters']),
u'filters': (u'filter', [u'filter', u'filtered', u'filtering', u'filters']),
u'final': (u'final', [u'final']),
u'finance': (u'finance', [u'finance']),
u'financial': (u'financial', [u'financial']),
u'find': (u'find', [u'find', u'finding']),
u'finding': (u'find', [u'find', u'finding']),
u'fine': (u'fine', [u'fine']),
u'finger': (u'finger', [u'finger', u'fingerprint']),
u'fingerprint': (u'fingerprint', [u'fingerprint']),
u'finish': (u'finish', [u'finish', u'finished', u'finishes']),
u'finished': (u'finish', [u'finish', u'finished', u'finishes']),
u'finishes': (u'finish', [u'finish', u'finished', u'finishes']),
u'firefox': (u'firefox', [u'firefox']),
u'firewall': (u'firewall', [u'firewall']),
u'first': (u'first', [u'first', u'first-time']),
u'first-time': (u'first-time', [u'first-time']),
u'fit': (u'fit', [u'fit', u'fitness', u'fitted']),
u'fitness': (u'fitness', [u'fitness']),
u'fitted': (u'fitted', [u'fitted']),
u'five': (u'five', [u'five']),
u'fix': (u'fix', [u'fix', u'fixed', u'fixes']),
u'fixed': (u'fix', [u'fix', u'fixed', u'fixes']),
u'fixes': (u'fix', [u'fix', u'fixed', u'fixes']),
u'flag': (u'flag', [u'flag', u'flagged']),
u'flagged': (u'flagged', [u'flagged']),
u'flash': (u'flash', [u'flash', u'flashy']),
u'flashy': (u'flash', [u'flash', u'flashy']),
u'flat': (u'flat', [u'flat', u'flat-rate']),
u'flat-rate': (u'flat-rate', [u'flat-rate']),
u'flick': (u'flick', [u'flick']),
u'flight': (u'flight', [u'flight']),
u'flip': (u'flip', [u'flip']),
u'floating': (u'float', [u'floating', u'floats']),
u'floats': (u'float', [u'floating', u'floats']),
u'focal': (u'focal', [u'focal']),
u'focus': (u'focus', [u'focus', u'focused']),
u'focused': (u'focus', [u'focus', u'focused']),
u'folder': (u'fold', [u'folder', u'folders', u'folding']),
u'folders': (u'fold', [u'folder', u'folders', u'folding']),
u'folding': (u'fold', [u'folder', u'folders', u'folding']),
u'folio': (u'folio', [u'folio']),
u'follow': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'followed': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'follower': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'following': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'followup': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'followup-to': (u'follow', [u'follow', u'followed', u'follower', u'following', u'followup', u'followup-to']),
u'font': (u'font', [u'font', u'font-family', u'fontname', u'fonts']),
u'font-family': (u'font', [u'font', u'font-family', u'fontname', u'fonts']),
u'fontname': (u'font', [u'font', u'font-family', u'fontname', u'fonts']),
u'fonts': (u'font', [u'font', u'font-family', u'fontname', u'fonts']),
u'food': (u'food', [u'food']),
u'footers': (u'footers', [u'footers']),
u'for': (u'for', [u'for', u'forbidden', u'force', u'forced', u'forcing', u'foreground', u'forever', u'forgot', u'form', u'format', u'formats', u'formatting', u'forms', u'forums', u'forward', u'forwarded', u'forwarding']),
u'forbidden': (u'forbidden', [u'forbidden']),
u'force': (u'forc', [u'force', u'forced', u'forcing']),
u'forced': (u'forc', [u'force', u'forced', u'forcing']),
u'forcing': (u'forc', [u'force', u'forced', u'forcing']),
u'foreground': (u'foreground', [u'foreground']),
u'forever': (u'forever', [u'forever']),
u'forgot': (u'forgot', [u'forgot']),
u'form': (u'form', [u'form', u'format', u'formats', u'formatting', u'forms']),
u'format': (u'format', [u'format', u'formats', u'formatting']),
u'formats': (u'format', [u'format', u'formats', u'formatting']),
u'formatting': (u'format', [u'format', u'formats', u'formatting']),
u'forms': (u'form', [u'form', u'format', u'formats', u'formatting', u'forms']),
u'forums': (u'forums', [u'forums']),
u'forward': (u'forward', [u'forward', u'forwarded', u'forwarding']),
u'forwarded': (u'forward', [u'forward', u'forwarded', u'forwarding']),
u'forwarding': (u'forward', [u'forward', u'forwarded', u'forwarding']),
u'found': (u'found', [u'found', u'foundation']),
u'foundation': (u'found', [u'found', u'foundation']),
u'fragment': (u'fragment', [u'fragment']),
u'frame': (u'frame', [u'frame', u'frames', u'framework']),
u'frames': (u'frame', [u'frame', u'frames', u'framework']),
u'framework': (u'frame', [u'frame', u'frames', u'framework']),
u'fraud': (u'fraud', [u'fraud', u'fraudulent']),
u'fraudulent': (u'fraudulent', [u'fraudulent']),
u'free': (u'free', [u'free', u'freenode']),
u'freenode': (u'freenode', [u'freenode']),
u'french': (u'french', [u'french']),
u'frequency': (u'frequency', [u'frequency']),
u'frequent': (u'frequent', [u'frequent', u'frequently']),
u'frequently': (u'frequent', [u'frequent', u'frequently']),
u'fresh': (u'fresh', [u'fresh']),
u'fri': (u'fri', [u'fri', u'friday', u'friend']),
u'friday': (u'friday', [u'friday']),
u'friend': (u'friend', [u'friend']),
u'from': (u'from', [u'from', u'from-address', u'from-to']),
u'from-address': (u'from-address', [u'from-address']),
u'from-to': (u'from-to', [u'from-to']),
u'front': (u'front', [u'front']),
u'ftp': (u'ftp', [u'ftp']),
u'full': (u'full', [u'full', u'full-screen', u'fullscreen', u'fullwidth', u'fully']),
u'full-screen': (u'full', [u'full', u'full-screen', u'fullscreen', u'fullwidth', u'fully']),
u'fullscreen': (u'full', [u'full', u'full-screen', u'fullscreen', u'fullwidth', u'fully']),
u'fullwidth': (u'full', [u'full', u'full-screen', u'fullscreen', u'fullwidth', u'fully']),
u'fully': (u'full', [u'full', u'full-screen', u'fullscreen', u'fullwidth', u'fully']),
u'fun': (u'fun', [u'fun', u'function', u'functionality', u'functioning', u'funny']),
u'function': (u'function', [u'function', u'functionality', u'functioning']),
u'functionality': (u'function', [u'function', u'functionality', u'functioning']),
u'functioning': (u'function', [u'function', u'functionality', u'functioning']),
u'funny': (u'funny', [u'funny']),
u'further': (u'further', [u'further']),
u'fuse': (u'fuse', [u'fuse']),
u'future': (u'future', [u'future']),
u'g': (u'g', [u'g', u'gain', u'gallery', u'games', u'gateway', u'gathers', u'gb', u'gb18030', u'gb2312', u'gbk', u'gears', u'geir', u'gender', u'general', u'generate', u'generated', u'generating', u'generation', u'generator', u'generic', u'geolocation', u'georgian', u'german', u'gesture', u'gestures', u'get', u'gets', u'getting', u'gif', u'girow', u'give', u'given', u'gives', u'global', u'glossary', u'gmail', u'go', u'going', u'gold', u'good', u'google', u'gopher', u'goto', u'gprs', u'gpu', u'grab', u'graph', u'grateful', u'grayscale', u'great', u'greater', u'greatly', u'greek', u'green', u'grinning', u'group', u'grouped', u'grouping', u'groups', u'gsm', u'guarantee', u'guaranteed', u'guide', u'guidelines', u'gujarati', u'gurmukhi']),
u'gain': (u'gain', [u'gain']),
u'gallery': (u'gallery', [u'gallery']),
u'games': (u'games', [u'games']),
u'gateway': (u'gateway', [u'gateway']),
u'gathers': (u'gathers', [u'gathers']),
u'gb': (u'gb', [u'gb', u'gb18030', u'gb2312', u'gbk']),
u'gb18030': (u'gb18030', [u'gb18030']),
u'gb2312': (u'gb2312', [u'gb2312']),
u'gbk': (u'gbk', [u'gbk']),
u'gears': (u'gears', [u'gears']),
u'geir': (u'geir', [u'geir']),
u'gender': (u'gender', [u'gender']),
u'general': (u'general', [u'general']),
u'generate': (u'generat', [u'generate', u'generated', u'generating', u'generation', u'generator']),
u'generated': (u'generat', [u'generate', u'generated', u'generating', u'generation', u'generator']),
u'generating': (u'generat', [u'generate', u'generated', u'generating', u'generation', u'generator']),
u'generation': (u'generat', [u'generate', u'generated', u'generating', u'generation', u'generator']),
u'generator': (u'generat', [u'generate', u'generated', u'generating', u'generation', u'generator']),
u'generic': (u'generic', [u'generic']),
u'geolocation': (u'geolocation', [u'geolocation']),
u'georgian': (u'georgian', [u'georgian']),
u'german': (u'german', [u'german']),
u'gesture': (u'gesture', [u'gesture', u'gestures']),
u'gestures': (u'gesture', [u'gesture', u'gestures']),
u'get': (u'get', [u'get', u'gets', u'getting']),
u'gets': (u'get', [u'get', u'gets', u'getting']),
u'getting': (u'get', [u'get', u'gets', u'getting']),
u'gif': (u'gif', [u'gif']),
u'girow': (u'girow', [u'girow']),
u'give': (u'give', [u'give', u'given', u'gives']),
u'given': (u'give', [u'give', u'given', u'gives']),
u'gives': (u'give', [u'give', u'given', u'gives']),
u'global': (u'global', [u'global']),
u'glossary': (u'glossary', [u'glossary']),
u'gmail': (u'gmail', [u'gmail']),
u'go': (u'go', [u'go', u'going', u'gold', u'good', u'google', u'gopher', u'goto']),
u'going': (u'going', [u'going']),
u'gold': (u'gold', [u'gold']),
u'good': (u'good', [u'good']),
u'google': (u'google', [u'google']),
u'gopher': (u'gopher', [u'gopher']),
u'goto': (u'goto', [u'goto']),
u'gprs': (u'gprs', [u'gprs']),
u'gpu': (u'gpu', [u'gpu']),
u'grab': (u'grab', [u'grab']),
u'graph': (u'graph', [u'graph']),
u'grateful': (u'grateful', [u'grateful']),
u'grayscale': (u'grayscale', [u'grayscale']),
u'great': (u'great', [u'great', u'greater', u'greatly']),
u'greater': (u'great', [u'great', u'greater', u'greatly']),
u'greatly': (u'great', [u'great', u'greater', u'greatly']),
u'greek': (u'greek', [u'greek']),
u'green': (u'green', [u'green']),
u'grinning': (u'grinning', [u'grinning']),
u'group': (u'group', [u'group', u'grouped', u'grouping', u'groups']),
u'grouped': (u'group', [u'group', u'grouped', u'grouping', u'groups']),
u'grouping': (u'group', [u'group', u'grouped', u'grouping', u'groups']),
u'groups': (u'group', [u'group', u'grouped', u'grouping', u'groups']),
u'gsm': (u'gsm', [u'gsm']),
u'guarantee': (u'guarante', [u'guarantee', u'guaranteed']),
u'guaranteed': (u'guarante', [u'guarantee', u'guaranteed']),
u'guide': (u'guide', [u'guide', u'guidelines']),
u'guidelines': (u'guidelines', [u'guidelines']),
u'gujarati': (u'gujarati', [u'gujarati']),
u'gurmukhi': (u'gurmukhi', [u'gurmukhi']),
u'h': (u'h', [u'h', u'h1', u'h2', u'h3', u'h4', u'h5', u'h6', u'had', u'halfwidth', u'handheld', u'handle', u'handled', u'handler', u'handlers', u'handling', u'handshake', u'hangul', u'happy', u'hardware-accelerated', u'harm', u'harmful', u'has', u'have', u'head', u'header', u'header-name', u'header-value', u'headers', u'health', u'hebrew', u'height', u'held', u'help', u'helper', u'helps', u'her', u'here', u'hidden', u'hide', u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly', u'him', u'hint', u'hints', u'hiragana', u'his', u'history', u'hit', u'hmm', u'hold', u'holder', u'holding', u'home', u'hope', u'horizontal', u'horizontally', u'host', u'hostname', u'hostname.domain', u'hosts', u'hotmail', u'hour', u'hours', u'hovering', u'how', u'however', u'hr', u'htm', u'html', u'http', u'httponly', u'https', u'hu', u'hue', u'huge', u'hundred', u'hyphens', u'hz-gb2312']),
u'h1': (u'h1', [u'h1']),
u'h2': (u'h2', [u'h2']),
u'h3': (u'h3', [u'h3']),
u'h4': (u'h4', [u'h4']),
u'h5': (u'h5', [u'h5']),
u'h6': (u'h6', [u'h6']),
u'had': (u'had', [u'had']),
u'halfwidth': (u'halfwidth', [u'halfwidth']),
u'handheld': (u'handheld', [u'handheld']),
u'handle': (u'handl', [u'handle', u'handled', u'handler', u'handlers', u'handling']),
u'handled': (u'handl', [u'handle', u'handled', u'handler', u'handlers', u'handling']),
u'handler': (u'handl', [u'handle', u'handled', u'handler', u'handlers', u'handling']),
u'handlers': (u'handl', [u'handle', u'handled', u'handler', u'handlers', u'handling']),
u'handling': (u'handl', [u'handle', u'handled', u'handler', u'handlers', u'handling']),
u'handshake': (u'handshake', [u'handshake']),
u'hangul': (u'hangul', [u'hangul']),
u'happy': (u'happy', [u'happy']),
u'hardware-accelerated': (u'hardware-accelerated', [u'hardware-accelerated']),
u'harm': (u'harm', [u'harm', u'harmful']),
u'harmful': (u'harmful', [u'harmful']),
u'has': (u'has', [u'has']),
u'have': (u'have', [u'have']),
u'head': (u'head', [u'head', u'header', u'header-name', u'header-value', u'headers']),
u'header': (u'head', [u'head', u'header', u'header-name', u'header-value', u'headers']),
u'header-name': (u'head', [u'head', u'header', u'header-name', u'header-value', u'headers']),
u'header-value': (u'head', [u'head', u'header', u'header-name', u'header-value', u'headers']),
u'headers': (u'head', [u'head', u'header', u'header-name', u'header-value', u'headers']),
u'health': (u'health', [u'health']),
u'hebrew': (u'hebrew', [u'hebrew']),
u'height': (u'height', [u'height']),
u'held': (u'held', [u'held']),
u'help': (u'help', [u'help', u'helper', u'helps']),
u'helper': (u'help', [u'help', u'helper', u'helps']),
u'helps': (u'help', [u'help', u'helper', u'helps']),
u'her': (u'her', [u'her', u'here']),
u'here': (u'here', [u'here']),
u'hidden': (u'hidden', [u'hidden']),
u'hide': (u'hide', [u'hide']),
u'high': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'higher': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'highest': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'highlight': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'highlighted': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'highly': (u'high', [u'high', u'higher', u'highest', u'highlight', u'highlighted', u'highly']),
u'him': (u'him', [u'him']),
u'hint': (u'hint', [u'hint', u'hints']),
u'hints': (u'hint', [u'hint', u'hints']),
u'hiragana': (u'hiragana', [u'hiragana']),
u'his': (u'his', [u'his', u'history']),
u'history': (u'history', [u'history']),
u'hit': (u'hit', [u'hit']),
u'hmm': (u'hmm', [u'hmm']),
u'hold': (u'hold', [u'hold', u'holder', u'holding']),
u'holder': (u'hold', [u'hold', u'holder', u'holding']),
u'holding': (u'hold', [u'hold', u'holder', u'holding']),
u'home': (u'home', [u'home']),
u'hope': (u'hope', [u'hope']),
u'horizontal': (u'horizontal', [u'horizontal', u'horizontally']),
u'horizontally': (u'horizontal', [u'horizontal', u'horizontally']),
u'host': (u'host', [u'host', u'hostname', u'hostname.domain', u'hosts']),
u'hostname': (u'host', [u'host', u'hostname', u'hostname.domain', u'hosts']),
u'hostname.domain': (u'hostname.domain', [u'hostname.domain']),
u'hosts': (u'host', [u'host', u'hostname', u'hostname.domain', u'hosts']),
u'hotmail': (u'hotmail', [u'hotmail']),
u'hour': (u'hour', [u'hour', u'hours']),
u'hours': (u'hour', [u'hour', u'hours']),
u'hovering': (u'hovering', [u'hovering']),
u'how': (u'how', [u'how', u'however']),
u'however': (u'however', [u'however']),
u'hr': (u'hr', [u'hr']),
u'htm': (u'htm', [u'htm', u'html']),
u'html': (u'html', [u'html']),
u'http': (u'http', [u'http', u'httponly', u'https']),
u'httponly': (u'http', [u'http', u'httponly', u'https']),
u'https': (u'http', [u'http', u'httponly', u'https']),
u'hu': (u'hu', [u'hu', u'hue', u'huge', u'hundred']),
u'hue': (u'hue', [u'hue']),
u'huge': (u'huge', [u'huge']),
u'hundred': (u'hundred', [u'hundred']),
u'hyphens': (u'hyphens', [u'hyphens']),
u'hz-gb2312': (u'hz-gb2312', [u'hz-gb2312']),
u'ibm': (u'ibm', [u'ibm']),
u'ico': (u'ico', [u'ico', u'icon', u'icons']),
u'icon': (u'icon', [u'icon', u'icons']),
u'icons': (u'icon', [u'icon', u'icons']),
u'id': (u'id', [u'id', u'idea', u'identification', u'identified', u'identifies', u'identify', u'identity', u'idle']),
u'idea': (u'idea', [u'idea']),
u'identification': (u'identif', [u'identification', u'identified', u'identifies', u'identify']),
u'identified': (u'identif', [u'identification', u'identified', u'identifies', u'identify']),
u'identifies': (u'identif', [u'identification', u'identified', u'identifies', u'identify']),
u'identify': (u'identif', [u'identification', u'identified', u'identifies', u'identify']),
u'identity': (u'identity', [u'identity']),
u'idle': (u'idle', [u'idle']),
u'ie': (u'ie', [u'ie']),
u'if': (u'if', [u'if', u'iframe']),
u'iframe': (u'iframe', [u'iframe']),
u'ignore': (u'ignor', [u'ignore', u'ignored', u'ignoring']),
u'ignored': (u'ignor', [u'ignore', u'ignored', u'ignoring']),
u'ignoring': (u'ignor', [u'ignore', u'ignored', u'ignoring']),
u'illegal': (u'illegal', [u'illegal']),
u'image': (u'image', [u'image', u'images']),
u'images': (u'image', [u'image', u'images']),
u'imagine': (u'imagin', [u'imagine', u'imagined']),
u'imagined': (u'imagin', [u'imagine', u'imagined']),
u'imap': (u'imap', [u'imap']),
u'imei': (u'imei', [u'imei']),
u'immediately': (u'immediately', [u'immediately']),
u'implementation': (u'implement', [u'implementation', u'implemented']),
u'implemented': (u'implement', [u'implementation', u'implemented']),
u'implications': (u'implications', [u'implications']),
u'import': (u'import', [u'import', u'important', u'imported', u'importing']),
u'important': (u'import', [u'import', u'important', u'imported', u'importing']),
u'imported': (u'import', [u'import', u'important', u'imported', u'importing']),
u'importing': (u'import', [u'import', u'important', u'imported', u'importing']),
u'impossible': (u'impossible', [u'impossible']),
u'improve': (u'improv', [u'improve', u'improved']),
u'improved': (u'improv', [u'improve', u'improved']),
u'in': (u'in', [u'in', u'inaccessible', u'inactive', u'inactivity', u'inbox', u'inches', u'include', u'included', u'includes', u'including', u'incoming', u'incompatible', u'incomplete', u'inconvenience', u'incorrect', u'incorrectly', u'increase', u'indecent', u'indent', u'indentation', u'index', u'index.html', u'indic', u'indicated', u'indicator', u'indifferent', u'indigo', u'individuals', u'info', u'information', u'inherited', u'initial', u'initialization', u'initializing', u'initiate', u'initiated', u'injected', u'inline', u'input', u'ins', u'insecure', u'insert', u'inserted', u'inside', u'inspect', u'inspection', u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield', u'instance', u'instances', u'instant', u'instantly', u'instead', u'instmsia.exe', u'instmsiw.exe', u'instruction', u'instructions', u'insufficient', u'integrated', u'integrity', u'intelligently', u'intended', u'interaction', u'interacts', u'interface', u'interfere', u'intermediate', u'internal', u'international', u'internet', u'interrupted', u'interval', u'intialization', u'into', u'intranet', u'introduces', u'introduction', u'intuitive', u'invalid', u'inverted', u'invitation', u'invite', u'invited']),
u'inaccessible': (u'inaccessible', [u'inaccessible']),
u'inactive': (u'inactiv', [u'inactive', u'inactivity']),
u'inactivity': (u'inactiv', [u'inactive', u'inactivity']),
u'inbox': (u'inbox', [u'inbox']),
u'inches': (u'inches', [u'inches']),
u'include': (u'includ', [u'include', u'included', u'includes', u'including']),
u'included': (u'includ', [u'include', u'included', u'includes', u'including']),
u'includes': (u'includ', [u'include', u'included', u'includes', u'including']),
u'including': (u'includ', [u'include', u'included', u'includes', u'including']),
u'incoming': (u'incoming', [u'incoming']),
u'incompatible': (u'incompatible', [u'incompatible']),
u'incomplete': (u'incomplete', [u'incomplete']),
u'inconvenience': (u'inconvenience', [u'inconvenience']),
u'incorrect': (u'incorrect', [u'incorrect', u'incorrectly']),
u'incorrectly': (u'incorrect', [u'incorrect', u'incorrectly']),
u'increase': (u'increase', [u'increase']),
u'indecent': (u'indecent', [u'indecent']),
u'indent': (u'indent', [u'indent', u'indentation']),
u'indentation': (u'indent', [u'indent', u'indentation']),
u'index': (u'index', [u'index', u'index.html']),
u'index.html': (u'index.html', [u'index.html']),
u'indic': (u'indic', [u'indic', u'indicated', u'indicator']),
u'indicated': (u'indicat', [u'indicated', u'indicator']),
u'indicator': (u'indicat', [u'indicated', u'indicator']),
u'indifferent': (u'indifferent', [u'indifferent']),
u'indigo': (u'indigo', [u'indigo']),
u'individuals': (u'individuals', [u'individuals']),
u'info': (u'info', [u'info', u'information']),
u'information': (u'information', [u'information']),
u'inherited': (u'inherited', [u'inherited']),
u'initial': (u'initial', [u'initial', u'initialization', u'initializing']),
u'initialization': (u'initial', [u'initial', u'initialization', u'initializing']),
u'initializing': (u'initial', [u'initial', u'initialization', u'initializing']),
u'initiate': (u'initiat', [u'initiate', u'initiated']),
u'initiated': (u'initiat', [u'initiate', u'initiated']),
u'injected': (u'injected', [u'injected']),
u'inline': (u'inline', [u'inline']),
u'input': (u'input', [u'input']),
u'ins': (u'ins', [u'ins', u'insecure', u'insert', u'inserted', u'inside', u'inspect', u'inspection', u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield', u'instance', u'instances', u'instant', u'instantly', u'instead', u'instmsia.exe', u'instmsiw.exe', u'instruction', u'instructions', u'insufficient']),
u'insecure': (u'insecure', [u'insecure']),
u'insert': (u'insert', [u'insert', u'inserted']),
u'inserted': (u'insert', [u'insert', u'inserted']),
u'inside': (u'inside', [u'inside']),
u'inspect': (u'inspect', [u'inspect', u'inspection']),
u'inspection': (u'inspect', [u'inspect', u'inspection']),
u'install': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installation': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installdir': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installdriver': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installed': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installer': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installing': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installs': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installscript': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'installshield': (u'install', [u'install', u'installation', u'installdir', u'installdriver', u'installed', u'installer', u'installing', u'installs', u'installscript', u'installshield']),
u'instance': (u'instance', [u'instance', u'instances']),
u'instances': (u'instance', [u'instance', u'instances']),
u'instant': (u'instant', [u'instant', u'instantly']),
u'instantly': (u'instant', [u'instant', u'instantly']),
u'instead': (u'instead', [u'instead']),
u'instmsia.exe': (u'instmsia.exe', [u'instmsia.exe']),
u'instmsiw.exe': (u'instmsiw.exe', [u'instmsiw.exe']),
u'instruction': (u'instruction', [u'instruction', u'instructions']),
u'instructions': (u'instruction', [u'instruction', u'instructions']),
u'insufficient': (u'insufficient', [u'insufficient']),
u'integrated': (u'integrated', [u'integrated']),
u'integrity': (u'integrity', [u'integrity']),
u'intelligently': (u'intelligently', [u'intelligently']),
u'intended': (u'intended', [u'intended']),
u'interaction': (u'interact', [u'interaction', u'interacts']),
u'interacts': (u'interact', [u'interaction', u'interacts']),
u'interface': (u'interface', [u'interface']),
u'interfere': (u'interfere', [u'interfere']),
u'intermediate': (u'intermediate', [u'intermediate']),
u'internal': (u'internal', [u'internal']),
u'international': (u'international', [u'international']),
u'internet': (u'internet', [u'internet']),
u'interrupted': (u'interrupted', [u'interrupted']),
u'interval': (u'interval', [u'interval']),
u'intialization': (u'intialization', [u'intialization']),
u'into': (u'into', [u'into']),
u'intranet': (u'intranet', [u'intranet']),
u'introduces': (u'introduces', [u'introduces']),
u'introduction': (u'introduction', [u'introduction']),
u'intuitive': (u'intuitive', [u'intuitive']),
u'invalid': (u'invalid', [u'invalid']),
u'inverted': (u'invert', [u'inverted']),
u'invitation': (u'invit', [u'invitation', u'invite', u'invited']),
u'invite': (u'invit', [u'invitation', u'invite', u'invited']),
u'invited': (u'invit', [u'invitation', u'invite', u'invited']),
u'ip': (u'ip', [u'ip']),
u'irc': (u'irc', [u'irc', u'ircnet']),
u'ircnet': (u'irc', [u'irc', u'ircnet']),
u'is': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'iso': (u'iso', [u'iso', u'iso-2022-cn', u'iso-2022-jp', u'iso-2022-kr', u'iso-8859-1', u'iso-8859-10', u'iso-8859-11', u'iso-8859-13', u'iso-8859-14', u'iso-8859-15', u'iso-8859-16', u'iso-8859-2', u'iso-8859-3', u'iso-8859-4', u'iso-8859-5', u'iso-8859-6', u'iso-8859-7', u'iso-8859-8', u'iso-8859-9']),
u'iso-2022-cn': (u'iso-2022-cn', [u'iso-2022-cn']),
u'iso-2022-jp': (u'iso-2022-jp', [u'iso-2022-jp']),
u'iso-2022-kr': (u'iso-2022-kr', [u'iso-2022-kr']),
u'iso-8859-1': (u'iso-8859-1', [u'iso-8859-1', u'iso-8859-10', u'iso-8859-11', u'iso-8859-13', u'iso-8859-14', u'iso-8859-15', u'iso-8859-16']),
u'iso-8859-10': (u'iso-8859-10', [u'iso-8859-10']),
u'iso-8859-11': (u'iso-8859-11', [u'iso-8859-11']),
u'iso-8859-13': (u'iso-8859-13', [u'iso-8859-13']),
u'iso-8859-14': (u'iso-8859-14', [u'iso-8859-14']),
u'iso-8859-15': (u'iso-8859-15', [u'iso-8859-15']),
u'iso-8859-16': (u'iso-8859-16', [u'iso-8859-16']),
u'iso-8859-2': (u'iso-8859-2', [u'iso-8859-2']),
u'iso-8859-3': (u'iso-8859-3', [u'iso-8859-3']),
u'iso-8859-4': (u'iso-8859-4', [u'iso-8859-4']),
u'iso-8859-5': (u'iso-8859-5', [u'iso-8859-5']),
u'iso-8859-6': (u'iso-8859-6', [u'iso-8859-6']),
u'iso-8859-7': (u'iso-8859-7', [u'iso-8859-7']),
u'iso-8859-8': (u'iso-8859-8', [u'iso-8859-8']),
u'iso-8859-9': (u'iso-8859-9', [u'iso-8859-9']),
u'isscript.msi': (u'isscript.msi', [u'isscript.msi']),
u'issue': (u'issu', [u'issue', u'issued', u'issuer', u'issues', u'issuing']),
u'issued': (u'issu', [u'issue', u'issued', u'issuer', u'issues', u'issuing']),
u'issuer': (u'issu', [u'issue', u'issued', u'issuer', u'issues', u'issuing']),
u'issues': (u'issu', [u'issue', u'issued', u'issuer', u'issues', u'issuing']),
u'issuing': (u'issu', [u'issue', u'issued', u'issuer', u'issues', u'issuing']),
u'it': (u'it', [u'it', u'italian', u'italic', u'item', u'items', u'its', u'itself']),
u'italian': (u'italian', [u'italian']),
u'italic': (u'italic', [u'italic']),
u'item': (u'item', [u'item', u'items']),
u'items': (u'item', [u'item', u'items']),
u'its': (u'its', [u'its', u'itself']),
u'itself': (u'itself', [u'itself']),
u'ivarsøy': (u'ivarsøy', [u'ivarsøy']),
u'ix': (u'ix', [u'ix']),
u'jan': (u'jan', [u'jan', u'january']),
u'january': (u'january', [u'january']),
u'japanese': (u'japanese', [u'japanese']),
u'jar': (u'jar', [u'jar']),
u'java': (u'java', [u'java', u'javascript']),
u'javascript': (u'javascript', [u'javascript']),
u'job': (u'job', [u'job']),
u'join': (u'join', [u'join', u'joined', u'joining']),
u'joined': (u'join', [u'join', u'joined', u'joining']),
u'joining': (u'join', [u'join', u'joined', u'joining']),
u'joystick': (u'joystick', [u'joystick']),
u'jpe': (u'jpe', [u'jpe', u'jpeg']),
u'jpeg': (u'jpeg', [u'jpeg']),
u'jpg': (u'jpg', [u'jpg']),
u'jquery': (u'jquery', [u'jquery']),
u'js': (u'js', [u'js', u'jsr-75']),
u'jsr-75': (u'jsr-75', [u'jsr-75']),
u'jul': (u'jul', [u'jul', u'july']),
u'july': (u'jul', [u'jul', u'july']),
u'jump': (u'jump', [u'jump']),
u'jun': (u'jun', [u'jun', u'june', u'jungle', u'junk']),
u'june': (u'june', [u'june']),
u'jungle': (u'jungle', [u'jungle']),
u'junk': (u'junk', [u'junk']),
u'just': (u'just', [u'just', u'justify']),
u'justify': (u'justify', [u'justify']),
u'kanji': (u'kanji', [u'kanji']),
u'kannada': (u'kannada', [u'kannada']),
u'katakana': (u'katakana', [u'katakana']),
u'kb': (u'kb', [u'kb']),
u'kde': (u'kde', [u'kde', u'kde1']),
u'kde1': (u'kde1', [u'kde1']),
u'keep': (u'keep', [u'keep']),
u'kept': (u'kept', [u'kept']),
u'key': (u'key', [u'key', u'keyboard', u'keypad', u'keys', u'keyword', u'keywords']),
u'keyboard': (u'key', [u'key', u'keyboard', u'keypad', u'keys', u'keyword', u'keywords']),
u'keypad': (u'key', [u'key', u'keyboard', u'keypad', u'keys', u'keyword', u'keywords']),
u'keys': (u'key', [u'key', u'keyboard', u'keypad', u'keys', u'keyword', u'keywords']),
u'keyword': (u'keyword', [u'keyword', u'keywords']),
u'keywords': (u'keyword', [u'keyword', u'keywords']),
u'khmer': (u'khmer', [u'khmer']),
u'kib': (u'kib', [u'kib']),
u'kick': (u'kick', [u'kick', u'kicked']),
u'kicked': (u'kick', [u'kick', u'kicked']),
u'kids': (u'kids', [u'kids']),
u'kind': (u'kind', [u'kind']),
u'kiosk': (u'kiosk', [u'kiosk']),
u'know': (u'know', [u'know', u'known', u'knows']),
u'known': (u'know', [u'know', u'known', u'knows']),
u'knows': (u'know', [u'know', u'known', u'knows']),
u'koi8-r': (u'koi8-r', [u'koi8-r']),
u'koi8-u': (u'koi8-u', [u'koi8-u']),
u'konqueror': (u'konqueror', [u'konqueror']),
u'korean': (u'korean', [u'korean']),
u'label': (u'label', [u'label', u'labeled', u'labels']),
u'labeled': (u'label', [u'label', u'labeled', u'labels']),
u'labels': (u'label', [u'label', u'labeled', u'labels']),
u'lack': (u'lack', [u'lack', u'lacking', u'lacks']),
u'lacking': (u'lack', [u'lack', u'lacking', u'lacks']),
u'lacks': (u'lack', [u'lack', u'lacking', u'lacks']),
u'lan': (u'lan', [u'lan', u'landscape', u'language', u'languagecode', u'languagename', u'languages']),
u'landscape': (u'landscape', [u'landscape']),
u'language': (u'language', [u'language', u'languagecode', u'languagename', u'languages']),
u'languagecode': (u'language', [u'language', u'languagecode', u'languagename', u'languages']),
u'languagename': (u'language', [u'language', u'languagecode', u'languagename', u'languages']),
u'languages': (u'language', [u'language', u'languagecode', u'languagename', u'languages']),
u'lao': (u'lao', [u'lao']),
u'large': (u'larg', [u'large', u'larger']),
u'larger': (u'larg', [u'large', u'larger']),
u'last': (u'last', [u'last']),
u'later': (u'lat', [u'later', u'latest', u'latin', u'latin-1']),
u'latest': (u'lat', [u'later', u'latest', u'latin', u'latin-1']),
u'latin': (u'lat', [u'later', u'latest', u'latin', u'latin-1']),
u'latin-1': (u'lat', [u'later', u'latest', u'latin', u'latin-1']),
u'launch': (u'launch', [u'launch', u'launched', u'launcher', u'launcher.ini', u'launching']),
u'launched': (u'launch', [u'launch', u'launched', u'launcher', u'launcher.ini', u'launching']),
u'launcher': (u'launch', [u'launch', u'launched', u'launcher', u'launcher.ini', u'launching']),
u'launcher.ini': (u'launch', [u'launch', u'launched', u'launcher', u'launcher.ini', u'launching']),
u'launching': (u'launch', [u'launch', u'launched', u'launcher', u'launcher.ini', u'launching']),
u'law': (u'law', [u'law']),
u'layers': (u'layers', [u'layers']),
u'layout': (u'layout', [u'layout']),
u'ld': (u'ld', [u'ld']),
u'lead': (u'lead', [u'lead']),
u'lear': (u'lear', [u'lear', u'learn']),
u'learn': (u'learn', [u'learn']),
u'least': (u'least', [u'least']),
u'leave': (u'leav', [u'leave', u'leaving']),
u'leaving': (u'leav', [u'leave', u'leaving']),
u'ledger': (u'ledger', [u'ledger']),
u'left': (u'left', [u'left', u'left-hand', u'left-handed', u'left-to-right']),
u'left-hand': (u'left-hand', [u'left-hand', u'left-handed']),
u'left-handed': (u'left-hand', [u'left-hand', u'left-handed']),
u'left-to-right': (u'left-to-right', [u'left-to-right']),
u'legacy': (u'legacy', [u'legacy']),
u'legal': (u'legal', [u'legal']),
u'length': (u'length', [u'length']),
u'lens': (u'lens', [u'lens']),
u'less': (u'less', [u'less']),
u'let': (u'let', [u'let', u'lets', u'letter', u'letters']),
u'lets': (u'let', [u'let', u'lets', u'letter', u'letters']),
u'letter': (u'letter', [u'letter', u'letters']),
u'letters': (u'letter', [u'letter', u'letters']),
u'level': (u'level', [u'level']),
u'li': (u'li', [u'li', u'libnpp.so', u'library', u'license', u'licensed', u'licenses', u'lifestyle', u'light', u'like', u'likely', u'limit', u'limited', u'line', u'lines', u'link', u'linked', u'links', u'linux', u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists', u'little', u'live']),
u'libnpp.so': (u'libnpp.so', [u'libnpp.so']),
u'library': (u'library', [u'library']),
u'license': (u'licens', [u'license', u'licensed', u'licenses']),
u'licensed': (u'licens', [u'license', u'licensed', u'licenses']),
u'licenses': (u'licens', [u'license', u'licensed', u'licenses']),
u'lifestyle': (u'lifestyle', [u'lifestyle']),
u'light': (u'light', [u'light']),
u'like': (u'like', [u'like', u'likely']),
u'likely': (u'like', [u'like', u'likely']),
u'limit': (u'limit', [u'limit', u'limited']),
u'limited': (u'limit', [u'limit', u'limited']),
u'line': (u'line', [u'line', u'lines']),
u'lines': (u'line', [u'line', u'lines']),
u'link': (u'link', [u'link', u'linked', u'links']),
u'linked': (u'link', [u'link', u'linked', u'links']),
u'links': (u'link', [u'link', u'linked', u'links']),
u'linux': (u'lin', [u'line', u'lines', u'link', u'linked', u'links', u'linux']),
u'list': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'list-like': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'listed': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'listen': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'listening': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'listing': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'listings': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'lists': (u'list', [u'list', u'list-like', u'listed', u'listen', u'listening', u'listing', u'listings', u'lists']),
u'little': (u'little', [u'little']),
u'live': (u'live', [u'live']),
u'll': (u'll', [u'll']),
u'lng': (u'lng', [u'lng']),
u'load': (u'load', [u'load', u'loaded', u'loader', u'loading']),
u'loaded': (u'load', [u'load', u'loaded', u'loader', u'loading']),
u'loader': (u'load', [u'load', u'loaded', u'loader', u'loading']),
u'loading': (u'load', [u'load', u'loaded', u'loader', u'loading']),
u'local': (u'local', [u'local', u'locally']),
u'locally': (u'local', [u'local', u'locally']),
u'locate': (u'locat', [u'locate', u'location', u'locations']),
u'location': (u'locat', [u'locate', u'location', u'locations']),
u'locations': (u'locat', [u'locate', u'location', u'locations']),
u'lock': (u'lock', [u'lock', u'locked']),
u'locked': (u'lock', [u'lock', u'locked']),
u'log': (u'log', [u'log', u'logged', u'logging', u'logical', u'login', u'logins', u'logo']),
u'logged': (u'logg', [u'logged', u'logging']),
u'logging': (u'logg', [u'logged', u'logging']),
u'logical': (u'logical', [u'logical']),
u'login': (u'login', [u'login', u'logins']),
u'logins': (u'login', [u'login', u'logins']),
u'logo': (u'logo', [u'logo']),
u'long': (u'long', [u'long', u'long-click', u'long-clicking', u'longer']),
u'long-click': (u'long-click', [u'long-click', u'long-clicking']),
u'long-clicking': (u'long-click', [u'long-click', u'long-clicking']),
u'longer': (u'long', [u'long', u'long-click', u'long-clicking', u'longer']),
u'look': (u'look', [u'look', u'looking', u'looks', u'lookup']),
u'looking': (u'look', [u'look', u'looking', u'looks', u'lookup']),
u'looks': (u'look', [u'look', u'looking', u'looks', u'lookup']),
u'lookup': (u'look', [u'look', u'looking', u'looks', u'lookup']),
u'loop': (u'loop', [u'loop']),
u'lose': (u'lose', [u'lose']),
u'loss': (u'loss', [u'loss']),
u'lost': (u'lost', [u'lost']),
u'loud': (u'loud', [u'loud']),
u'low': (u'low', [u'low', u'low-bandwidth', u'lower', u'lowering', u'lowest']),
u'low-bandwidth': (u'low-bandwidth', [u'low-bandwidth']),
u'lower': (u'low', [u'low', u'low-bandwidth', u'lower', u'lowering', u'lowest']),
u'lowering': (u'low', [u'low', u'low-bandwidth', u'lower', u'lowering', u'lowest']),
u'lowest': (u'low', [u'low', u'low-bandwidth', u'lower', u'lowering', u'lowest']),
u'lpha': (u'lpha', [u'lpha']),
u'ltr': (u'ltr', [u'ltr']),
u'lu': (u'lu', [u'lu', u'luminosity', u'lunch']),
u'luminosity': (u'luminosity', [u'luminosity']),
u'lunch': (u'lunch', [u'lunch']),
u'ma': (u'ma', [u'ma', u'mac', u'machine', u'macintosh', u'made', u'magnifier', u'mail', u'mailbox', u'mailer', u'mailing', u'mailto', u'main', u'maintain', u'maintenance', u'major', u'major.minor-tag', u'make', u'makes', u'making', u'malayalam', u'male', u'malformed', u'malicious', u'malware', u'manage', u'management', u'manager', u'managers', u'mandatory', u'manual', u'manually', u'manufacturer', u'many', u'map', u'mar', u'march', u'margin', u'margins', u'mark', u'marked', u'marker', u'marks', u'markup', u'mask', u'master', u'match', u'matches', u'matching', u'max', u'maximize', u'maximized', u'maximum', u'may', u'maybe']),
u'mac': (u'mac', [u'mac', u'machine', u'macintosh']),
u'machine': (u'machine', [u'machine']),
u'macintosh': (u'macintosh', [u'macintosh']),
u'made': (u'made', [u'made']),
u'magnifier': (u'magnifier', [u'magnifier']),
u'mail': (u'mail', [u'mail', u'mailbox', u'mailer', u'mailing', u'mailto']),
u'mailbox': (u'mail', [u'mail', u'mailbox', u'mailer', u'mailing', u'mailto']),
u'mailer': (u'mail', [u'mail', u'mailbox', u'mailer', u'mailing', u'mailto']),
u'mailing': (u'mail', [u'mail', u'mailbox', u'mailer', u'mailing', u'mailto']),
u'mailto': (u'mail', [u'mail', u'mailbox', u'mailer', u'mailing', u'mailto']),
u'main': (u'main', [u'main', u'maintain', u'maintenance']),
u'maintain': (u'maintain', [u'maintain']),
u'maintenance': (u'maintenance', [u'maintenance']),
u'major': (u'major', [u'major', u'major.minor-tag']),
u'major.minor-tag': (u'major.minor-tag', [u'major.minor-tag']),
u'make': (u'mak', [u'make', u'makes', u'making']),
u'makes': (u'mak', [u'make', u'makes', u'making']),
u'making': (u'mak', [u'make', u'makes', u'making']),
u'malayalam': (u'malayalam', [u'malayalam']),
u'male': (u'male', [u'male']),
u'malformed': (u'malformed', [u'malformed']),
u'malicious': (u'malicious', [u'malicious']),
u'malware': (u'malware', [u'malware']),
u'manage': (u'manag', [u'manage', u'management', u'manager', u'managers']),
u'management': (u'manag', [u'manage', u'management', u'manager', u'managers']),
u'manager': (u'manag', [u'manage', u'management', u'manager', u'managers']),
u'managers': (u'manag', [u'manage', u'management', u'manager', u'managers']),
u'mandatory': (u'mandatory', [u'mandatory']),
u'manual': (u'manual', [u'manual', u'manually']),
u'manually': (u'manual', [u'manual', u'manually']),
u'manufacturer': (u'manufacturer', [u'manufacturer']),
u'many': (u'many', [u'many']),
u'map': (u'map', [u'map']),
u'mar': (u'mar', [u'mar', u'march', u'margin', u'margins', u'mark', u'marked', u'marker', u'marks', u'markup']),
u'march': (u'march', [u'march']),
u'margin': (u'margin', [u'margin', u'margins']),
u'margins': (u'margin', [u'margin', u'margins']),
u'mark': (u'mark', [u'mark', u'marked', u'marker', u'marks', u'markup']),
u'marked': (u'mark', [u'mark', u'marked', u'marker', u'marks', u'markup']),
u'marker': (u'mark', [u'mark', u'marked', u'marker', u'marks', u'markup']),
u'marks': (u'mark', [u'mark', u'marked', u'marker', u'marks', u'markup']),
u'markup': (u'mark', [u'mark', u'marked', u'marker', u'marks', u'markup']),
u'mask': (u'mask', [u'mask']),
u'master': (u'master', [u'master']),
u'match': (u'match', [u'match', u'matches', u'matching']),
u'matches': (u'match', [u'match', u'matches', u'matching']),
u'matching': (u'match', [u'match', u'matches', u'matching']),
u'max': (u'max', [u'max', u'maximize', u'maximized', u'maximum']),
u'maximize': (u'maximiz', [u'maximize', u'maximized']),
u'maximized': (u'maximiz', [u'maximize', u'maximized']),
u'maximum': (u'maxim', [u'maximize', u'maximized', u'maximum']),
u'may': (u'may', [u'may', u'maybe']),
u'maybe': (u'maybe', [u'maybe']),
u'mb': (u'mb', [u'mb', u'mbox', u'mbs']),
u'mbox': (u'mbox', [u'mbox']),
u'mbs': (u'mbs', [u'mbs']),
u'me': (u'me', [u'me', u'mean', u'meaning', u'measures', u'mechanism', u'media', u'medium', u'meet', u'meeting', u'members', u'memory', u'menu', u'menus', u'merge', u'merged', u'message', u'message-id', u'messages', u'messaging', u'meta', u'metadata', u'metering', u'method', u'methods', u'metrics']),
u'mean': (u'mean', [u'mean', u'meaning']),
u'meaning': (u'mean', [u'mean', u'meaning']),
u'measures': (u'measures', [u'measures']),
u'mechanism': (u'mechanism', [u'mechanism']),
u'media': (u'media', [u'media']),
u'medium': (u'medium', [u'medium']),
u'meet': (u'meet', [u'meet', u'meeting']),
u'meeting': (u'meet', [u'meet', u'meeting']),
u'members': (u'members', [u'members']),
u'memory': (u'memory', [u'memory']),
u'menu': (u'menu', [u'menu', u'menus']),
u'menus': (u'menu', [u'menu', u'menus']),
u'merge': (u'merg', [u'merge', u'merged']),
u'merged': (u'merg', [u'merge', u'merged']),
u'message': (u'messag', [u'message', u'message-id', u'messages', u'messaging']),
u'message-id': (u'messag', [u'message', u'message-id', u'messages', u'messaging']),
u'messages': (u'messag', [u'message', u'message-id', u'messages', u'messaging']),
u'messaging': (u'messag', [u'message', u'message-id', u'messages', u'messaging']),
u'meta': (u'meta', [u'meta', u'metadata']),
u'metadata': (u'metadata', [u'metadata']),
u'metering': (u'metering', [u'metering']),
u'method': (u'method', [u'method', u'methods']),
u'methods': (u'method', [u'method', u'methods']),
u'metrics': (u'metrics', [u'metrics']),
u'mht': (u'mht', [u'mht']),
u'mi': (u'mi', [u'mi', u'microsoft', u'mid', u'middle', u'middle-click', u'midi', u'might', u'migrate', u'million', u'mime', u'mime-encoding', u'min', u'mini', u'mini.opera.com', u'minimal', u'minimize', u'minimized', u'minimum', u'minor', u'minute', u'minutes', u'misc', u'mismatch', u'mismatched', u'missing', u'mistake', u'mistakes', u'mistyped', u'mixed', u'mixture']),
u'microsoft': (u'microsoft', [u'microsoft']),
u'mid': (u'mid', [u'mid', u'middle', u'middle-click', u'midi']),
u'middle': (u'middle', [u'middle', u'middle-click']),
u'middle-click': (u'middle-click', [u'middle-click']),
u'midi': (u'midi', [u'midi']),
u'might': (u'might', [u'might']),
u'migrate': (u'migrate', [u'migrate']),
u'million': (u'million', [u'million']),
u'mime': (u'mime', [u'mime', u'mime-encoding']),
u'mime-encoding': (u'mime-encoding', [u'mime-encoding']),
u'min': (u'min', [u'min', u'mini', u'mini.opera.com', u'minimal', u'minimize', u'minimized', u'minimum', u'minor', u'minute', u'minutes']),
u'mini': (u'min', [u'min', u'mini', u'mini.opera.com', u'minimal', u'minimize', u'minimized', u'minimum', u'minor', u'minute', u'minutes']),
u'mini.opera.com': (u'mini.opera.com', [u'mini.opera.com']),
u'minimal': (u'minim', [u'minimal', u'minimize', u'minimized', u'minimum']),
u'minimize': (u'minimiz', [u'minimize', u'minimized']),
u'minimized': (u'minimiz', [u'minimize', u'minimized']),
u'minimum': (u'minim', [u'minimal', u'minimize', u'minimized', u'minimum']),
u'minor': (u'min', [u'min', u'mini', u'mini.opera.com', u'minimal', u'minimize', u'minimized', u'minimum', u'minor', u'minute', u'minutes']),
u'minute': (u'minute', [u'minute', u'minutes']),
u'minutes': (u'minute', [u'minute', u'minutes']),
u'misc': (u'misc', [u'misc']),
u'mismatch': (u'mismatch', [u'mismatch', u'mismatched']),
u'mismatched': (u'mismatch', [u'mismatch', u'mismatched']),
u'missing': (u'missing', [u'missing']),
u'mistake': (u'mistake', [u'mistake', u'mistakes']),
u'mistakes': (u'mistake', [u'mistake', u'mistakes']),
u'mistyped': (u'mistyped', [u'mistyped']),
u'mixed': (u'mixed', [u'mixed']),
u'mixture': (u'mixture', [u'mixture']),
u'mm': (u'mm', [u'mm', u'mms']),
u'mms': (u'mms', [u'mms']),
u'mobile': (u'mobile', [u'mobile']),
u'mode': (u'mode', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes']),
u'model': (u'mode', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes']),
u'modem': (u'mode', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes']),
u'moderate': (u'moderat', [u'moderate', u'moderated', u'moderation', u'moderators']),
u'moderated': (u'moderat', [u'moderate', u'moderated', u'moderation', u'moderators']),
u'moderation': (u'moderat', [u'moderate', u'moderated', u'moderation', u'moderators']),
u'moderators': (u'moderat', [u'moderate', u'moderated', u'moderation', u'moderators']),
u'modern': (u'mode', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes']),
u'modes': (u'mode', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes']),
u'modified': (u'modif', [u'modified', u'modify']),
u'modify': (u'modif', [u'modified', u'modify']),
u'module': (u'mod', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes', u'modified', u'modify', u'module', u'modulus']),
u'modulus': (u'mod', [u'mode', u'model', u'modem', u'moderate', u'moderated', u'moderation', u'moderators', u'modern', u'modes', u'modified', u'modify', u'module', u'modulus']),
u'moment': (u'moment', [u'moment', u'momentarily', u'moments']),
u'momentarily': (u'moment', [u'moment', u'momentarily', u'moments']),
u'moments': (u'moment', [u'moment', u'momentarily', u'moments']),
u'mon': (u'mon', [u'mon', u'monday', u'mongolian', u'monospace', u'monotonic', u'month', u'months']),
u'monday': (u'monday', [u'monday']),
u'mongolian': (u'mongolian', [u'mongolian']),
u'monospace': (u'monospace', [u'monospace']),
u'monotonic': (u'monotonic', [u'monotonic']),
u'month': (u'month', [u'month', u'months']),
u'months': (u'month', [u'month', u'months']),
u'more': (u'more', [u'more']),
u'most': (u'most', [u'most']),
u'motif': (u'motif', [u'motif']),
u'motorola': (u'motorola', [u'motorola']),
u'mouse': (u'mouse', [u'mouse']),
u'move': (u'mov', [u'move', u'moved', u'movements', u'movies', u'moving']),
u'moved': (u'mov', [u'move', u'moved', u'movements', u'movies', u'moving']),
u'movements': (u'mov', [u'move', u'moved', u'movements', u'movies', u'moving']),
u'movies': (u'mov', [u'move', u'moved', u'movements', u'movies', u'moving']),
u'moving': (u'mov', [u'move', u'moved', u'movements', u'movies', u'moving']),
u'mp3': (u'mp3', [u'mp3']),
u'msi': (u'msi', [u'msi', u'msiexec.exe']),
u'msiexec.exe': (u'msiexec.exe', [u'msiexec.exe']),
u'mssansbold8': (u'mssansbold8', [u'mssansbold8']),
u'much': (u'much', [u'much']),
u'multi-line': (u'multi-line', [u'multi-line']),
u'multimedia': (u'multimedia', [u'multimedia']),
u'multimodal': (u'multimodal', [u'multimodal']),
u'multiple': (u'multiple', [u'multiple']),
u'music': (u'music', [u'music']),
u'must': (u'must', [u'must']),
u'mute': (u'mute', [u'mute']),
u'my': (u'my', [u'my', u'my.opera.com', u'myanmar', u'myself']),
u'my.opera.com': (u'my.opera.com', [u'my.opera.com']),
u'myanmar': (u'myanmar', [u'myanmar']),
u'myself': (u'myself', [u'myself']),
u'name': (u'nam', [u'name', u'named', u'names', u'namespace']),
u'named': (u'nam', [u'name', u'named', u'names', u'namespace']),
u'names': (u'nam', [u'name', u'named', u'names', u'namespace']),
u'namespace': (u'nam', [u'name', u'named', u'names', u'namespace']),
u'narrow': (u'narrow', [u'narrow']),
u'native': (u'native', [u'native']),
u'navigate': (u'navigat', [u'navigate', u'navigation']),
u'navigation': (u'navigat', [u'navigate', u'navigation']),
u'ncc': (u'ncc', [u'ncc']),
u'ndate': (u'ndate', [u'ndate']),
u'neater': (u'neat', [u'neater', u'neatly']),
u'neatly': (u'neat', [u'neater', u'neatly']),
u'necessary': (u'necessary', [u'necessary']),
u'need': (u'need', [u'need', u'needed', u'needs']),
u'needed': (u'need', [u'need', u'needed', u'needs']),
u'needs': (u'need', [u'need', u'needed', u'needs']),
u'negotiate': (u'negotiate', [u'negotiate']),
u'net': (u'net', [u'net', u'netscape', u'network', u'networks']),
u'netscape': (u'netscape', [u'netscape']),
u'network': (u'network', [u'network', u'networks']),
u'networks': (u'network', [u'network', u'networks']),
u'never': (u'never', [u'never']),
u'new': (u'new', [u'new', u'newer', u'newest', u'news', u'newsgroup', u'newsgroups']),
u'newer': (u'new', [u'new', u'newer', u'newest', u'news', u'newsgroup', u'newsgroups']),
u'newest': (u'new', [u'new', u'newer', u'newest', u'news', u'newsgroup', u'newsgroups']),
u'news': (u'new', [u'new', u'newer', u'newest', u'news', u'newsgroup', u'newsgroups']),
u'newsgroup': (u'newsgroup', [u'newsgroup', u'newsgroups']),
u'newsgroups': (u'newsgroup', [u'newsgroup', u'newsgroups']),
u'next': (u'next', [u'next']),
u'nfrom': (u'nfrom', [u'nfrom']),
u'nick': (u'nick', [u'nick', u'nickname', u'nicknames']),
u'nickname': (u'nickname', [u'nickname', u'nicknames']),
u'nicknames': (u'nickname', [u'nickname', u'nicknames']),
u'nimize': (u'nimize', [u'nimize']),
u'nintendo': (u'nintendo', [u'nintendo', u'nintendo.com']),
u'nintendo.com': (u'nintendo.com', [u'nintendo.com']),
u'nnewsgroups': (u'nnewsgroups', [u'nnewsgroups']),
u'nntp': (u'nntp', [u'nntp']),
u'no': (u'no', [u'no', u'node', u'nodes', u'non-alphabetic', u'non-critical', u'non-enumerable', u'non-linking', u'non-loading', u'non-native', u'non-power-of-two', u'non-spam', u'non-technical', u'non-verifiable', u'none', u'nonpremium', u'nordic', u'noreply', u'normal', u'normally', u'north', u'nostalgia', u'not', u'note', u'notepad', u'notes', u'noteworthy', u'nothing', u'notice', u'notification', u'notifications', u'notified', u'notify', u'nov', u'november', u'now']),
u'node': (u'node', [u'node', u'nodes']),
u'nodes': (u'node', [u'node', u'nodes']),
u'non-alphabetic': (u'non-alphabetic', [u'non-alphabetic']),
u'non-critical': (u'non-critical', [u'non-critical']),
u'non-enumerable': (u'non-enumerable', [u'non-enumerable']),
u'non-linking': (u'non-linking', [u'non-linking']),
u'non-loading': (u'non-loading', [u'non-loading']),
u'non-native': (u'non-native', [u'non-native']),
u'non-power-of-two': (u'non-power-of-two', [u'non-power-of-two']),
u'non-spam': (u'non-spam', [u'non-spam']),
u'non-technical': (u'non-technical', [u'non-technical']),
u'non-verifiable': (u'non-verifiable', [u'non-verifiable']),
u'none': (u'none', [u'none']),
u'nonpremium': (u'nonpremium', [u'nonpremium']),
u'nordic': (u'nordic', [u'nordic']),
u'noreply': (u'noreply', [u'noreply']),
u'normal': (u'normal', [u'normal', u'normally']),
u'normally': (u'normal', [u'normal', u'normally']),
u'north': (u'north', [u'north']),
u'nostalgia': (u'nostalgia', [u'nostalgia']),
u'not': (u'not', [u'not', u'note', u'notepad', u'notes', u'noteworthy', u'nothing', u'notice', u'notification', u'notifications', u'notified', u'notify']),
u'note': (u'note', [u'note', u'notepad', u'notes', u'noteworthy']),
u'notepad': (u'note', [u'note', u'notepad', u'notes', u'noteworthy']),
u'notes': (u'note', [u'note', u'notepad', u'notes', u'noteworthy']),
u'noteworthy': (u'note', [u'note', u'notepad', u'notes', u'noteworthy']),
u'nothing': (u'not', [u'not', u'note', u'notepad', u'notes', u'noteworthy', u'nothing', u'notice', u'notification', u'notifications', u'notified', u'notify']),
u'notice': (u'not', [u'not', u'note', u'notepad', u'notes', u'noteworthy', u'nothing', u'notice', u'notification', u'notifications', u'notified', u'notify']),
u'notification': (u'notif', [u'notification', u'notifications', u'notified', u'notify']),
u'notifications': (u'notif', [u'notification', u'notifications', u'notified', u'notify']),
u'notified': (u'notif', [u'notification', u'notifications', u'notified', u'notify']),
u'notify': (u'notif', [u'notification', u'notifications', u'notified', u'notify']),
u'nov': (u'nov', [u'nov', u'november']),
u'november': (u'november', [u'november']),
u'now': (u'now', [u'now']),
u'ns': (u'ns', [u'ns', u'nsubject']),
u'nsubject': (u'nsubject', [u'nsubject']),
u'nt': (u'nt', [u'nt', u'ntlm', u'nto']),
u'ntlm': (u'ntlm', [u'ntlm']),
u'nto': (u'nto', [u'nto']),
u'null': (u'null', [u'null']),
u'number': (u'number', [u'number', u'numbers']),
u'numbers': (u'number', [u'number', u'numbers']),
u'numeric': (u'numeric', [u'numeric']),
u'numf': (u'numf', [u'numf']),
u'nurl': (u'nurl', [u'nurl']),
u'object': (u'object', [u'object', u'objects']),
u'objects': (u'object', [u'object', u'objects']),
u'obml': (u'obml', [u'obml']),
u'obtain': (u'obtain', [u'obtain']),
u'occurred': (u'occurred', [u'occurred']),
u'occurs': (u'occurs', [u'occurs']),
u'oceania': (u'oceania', [u'oceania']),
u'ocsp': (u'ocsp', [u'ocsp']),
u'oct': (u'oct', [u'oct', u'october']),
u'october': (u'october', [u'october']),
u'oe': (u'oe', [u'oe']),
u'of': (u'of', [u'of', u'off', u'offered', u'offers', u'offline', u'offset', u'offsets', u'often']),
u'off': (u'off', [u'off', u'offered', u'offers', u'offline', u'offset', u'offsets']),
u'offered': (u'offer', [u'offered', u'offers']),
u'offers': (u'offer', [u'offered', u'offers']),
u'offline': (u'off', [u'off', u'offered', u'offers', u'offline', u'offset', u'offsets']),
u'offset': (u'offset', [u'offset', u'offsets']),
u'offsets': (u'offset', [u'offset', u'offsets']),
u'often': (u'often', [u'often']),
u'ogg': (u'ogg', [u'ogg']),
u'ogham': (u'ogham', [u'ogham']),
u'ok': (u'ok', [u'ok']),
u'old': (u'old', [u'old', u'older', u'oldest']),
u'older': (u'old', [u'old', u'older', u'oldest']),
u'oldest': (u'old', [u'old', u'older', u'oldest']),
u'oma': (u'oma', [u'oma']),
u'on': (u'on', [u'on', u'once', u'one', u'one-off', u'ones', u'ongoing', u'online', u'only', u'onto']),
u'once': (u'once', [u'once']),
u'one': (u'one', [u'one', u'one-off', u'ones']),
u'one-off': (u'one', [u'one', u'one-off', u'ones']),
u'ones': (u'one', [u'one', u'one-off', u'ones']),
u'ongoing': (u'ongoing', [u'ongoing']),
u'online': (u'online', [u'online']),
u'only': (u'only', [u'only']),
u'onto': (u'onto', [u'onto']),
u'oops': (u'oops', [u'oops']),
u'op': (u'op', [u'op', u'opacity', u'open', u'opened', u'opening', u'opens', u'opera', u'opera.com', u'opera6.ini', u'operamini', u'operamotifwrapper', u'operanet', u'operapluginwrapper', u'operated', u'operating', u'operation', u'operations', u'operator', u'operators', u'opml', u'optimize', u'optimized', u'option', u'optional', u'optionally', u'options']),
u'opacity': (u'opacity', [u'opacity']),
u'open': (u'open', [u'open', u'opened', u'opening', u'opens']),
u'opened': (u'open', [u'open', u'opened', u'opening', u'opens']),
u'opening': (u'open', [u'open', u'opened', u'opening', u'opens']),
u'opens': (u'open', [u'open', u'opened', u'opening', u'opens']),
u'opera': (u'oper', [u'opera', u'opera.com', u'opera6.ini', u'operamini', u'operamotifwrapper', u'operanet', u'operapluginwrapper', u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'opera.com': (u'opera.', [u'opera.com']),
u'opera6.ini': (u'oper', [u'opera', u'opera.com', u'opera6.ini', u'operamini', u'operamotifwrapper', u'operanet', u'operapluginwrapper', u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operamini': (u'oper', [u'opera', u'opera.com', u'opera6.ini', u'operamini', u'operamotifwrapper', u'operanet', u'operapluginwrapper', u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operamotifwrapper': (u'operamotifwrapper', [u'operamotifwrapper']),
u'operanet': (u'oper', [u'opera', u'opera.com', u'opera6.ini', u'operamini', u'operamotifwrapper', u'operanet', u'operapluginwrapper', u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operapluginwrapper': (u'operapluginwrapper', [u'operapluginwrapper']),
u'operated': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operating': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operation': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operations': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operator': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'operators': (u'operat', [u'operated', u'operating', u'operation', u'operations', u'operator', u'operators']),
u'opml': (u'opml', [u'opml']),
u'optimize': (u'optimiz', [u'optimize', u'optimized']),
u'optimized': (u'optimiz', [u'optimize', u'optimized']),
u'option': (u'option', [u'option', u'optional', u'optionally', u'options']),
u'optional': (u'optional', [u'optional', u'optionally']),
u'optionally': (u'optional', [u'optional', u'optionally']),
u'options': (u'option', [u'option', u'optional', u'optionally', u'options']),
u'or': (u'or', [u'or', u'order', u'ordered', u'ordinary', u'organization', u'organize', u'orientation', u'origin', u'original', u'originating', u'oriya']),
u'order': (u'order', [u'order', u'ordered']),
u'ordered': (u'order', [u'order', u'ordered']),
u'ordinary': (u'ordinary', [u'ordinary']),
u'organization': (u'organ', [u'organization', u'organize']),
u'organize': (u'organ', [u'organization', u'organize']),
u'orientation': (u'orientation', [u'orientation']),
u'origin': (u'origin', [u'origin', u'original', u'originating']),
u'original': (u'original', [u'original']),
u'originating': (u'originating', [u'originating']),
u'oriya': (u'oriya', [u'oriya']),
u'os': (u'os', [u'os']),
u'other': (u'other', [u'other', u'others', u'otherwise']),
u'others': (u'other', [u'other', u'others', u'otherwise']),
u'otherwise': (u'other', [u'other', u'others', u'otherwise']),
u'our': (u'our', [u'our']),
u'out': (u'out', [u'out', u'out-of-memory', u'outbox', u'outdated', u'outdent', u'outgoing', u'outline', u'outlook', u'output', u'outside']),
u'out-of-memory': (u'out-of-memory', [u'out-of-memory']),
u'outbox': (u'outbox', [u'outbox']),
u'outdated': (u'outdated', [u'outdated']),
u'outdent': (u'outdent', [u'outdent']),
u'outgoing': (u'outgoing', [u'outgoing']),
u'outline': (u'outline', [u'outline']),
u'outlook': (u'outlook', [u'outlook']),
u'output': (u'output', [u'output']),
u'outside': (u'outside', [u'outside']),
u'over': (u'over', [u'over', u'over-protective', u'overline', u'overloaded', u'override', u'overrides', u'overriding', u'overview', u'overwrite', u'overwritten']),
u'over-protective': (u'over-protective', [u'over-protective']),
u'overline': (u'overline', [u'overline']),
u'overloaded': (u'overloaded', [u'overloaded']),
u'override': (u'overrid', [u'override', u'overrides', u'overriding']),
u'overrides': (u'overrid', [u'override', u'overrides', u'overriding']),
u'overriding': (u'overrid', [u'override', u'overrides', u'overriding']),
u'overview': (u'overview', [u'overview']),
u'overwrite': (u'overwrite', [u'overwrite']),
u'overwritten': (u'overwritten', [u'overwritten']),
u'own': (u'own', [u'own', u'owner', u'owners']),
u'owner': (u'own', [u'own', u'owner', u'owners']),
u'owners': (u'own', [u'own', u'owner', u'owners']),
u'p12': (u'p12', [u'p12']),
u'p7': (u'p7', [u'p7', u'p7s']),
u'p7s': (u'p7s', [u'p7s']),
u'pac': (u'pac', [u'pac', u'pack', u'package', u'packages', u'packaging', u'packet']),
u'pack': (u'pack', [u'pack', u'package', u'packages', u'packaging', u'packet']),
u'package': (u'packag', [u'package', u'packages', u'packaging']),
u'packages': (u'packag', [u'package', u'packages', u'packaging']),
u'packaging': (u'packag', [u'package', u'packages', u'packaging']),
u'packet': (u'packet', [u'packet']),
u'page': (u'pag', [u'page', u'page-specific', u'pagedown', u'pager', u'pages', u'pageup']),
u'page-specific': (u'page-specific', [u'page-specific']),
u'pagedown': (u'pag', [u'page', u'page-specific', u'pagedown', u'pager', u'pages', u'pageup']),
u'pager': (u'pag', [u'page', u'page-specific', u'pagedown', u'pager', u'pages', u'pageup']),
u'pages': (u'pag', [u'page', u'page-specific', u'pagedown', u'pager', u'pages', u'pageup']),
u'pageup': (u'pag', [u'page', u'page-specific', u'pagedown', u'pager', u'pages', u'pageup']),
u'pair': (u'pair', [u'pair']),
u'palette': (u'palette', [u'palette']),
u'panel': (u'panel', [u'panel', u'panels']),
u'panels': (u'panel', [u'panel', u'panels']),
u'panning': (u'panning', [u'panning']),
u'paper': (u'paper', [u'paper']),
u'paragraph': (u'paragraph', [u'paragraph']),
u'parameter': (u'parameter', [u'parameter', u'parameters']),
u'parameters': (u'parameter', [u'parameter', u'parameters']),
u'parent': (u'parent', [u'parent', u'parental']),
u'parental': (u'parental', [u'parental']),
u'parse': (u'pars', [u'parse', u'parsed', u'parsing']),
u'parsed': (u'pars', [u'parse', u'parsed', u'parsing']),
u'parsing': (u'pars', [u'parse', u'parsed', u'parsing']),
u'part': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'partial': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'partially': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'participate': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'particular': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'parties': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'partition': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'partner': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'parts': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'party': (u'part', [u'part', u'partial', u'partially', u'participate', u'particular', u'parties', u'partition', u'partner', u'parts', u'party']),
u'pass': (u'pass', [u'pass', u'passed', u'passwd', u'password', u'passwords']),
u'passed': (u'pass', [u'pass', u'passed', u'passwd', u'password', u'passwords']),
u'passwd': (u'pass', [u'pass', u'passed', u'passwd', u'password', u'passwords']),
u'password': (u'password', [u'password', u'passwords']),
u'passwords': (u'password', [u'password', u'passwords']),
u'paste': (u'past', [u'paste', u'pasting']),
u'pasting': (u'past', [u'paste', u'pasting']),
u'patch': (u'patch', [u'patch']),
u'path': (u'path', [u'path', u'paths']),
u'paths': (u'path', [u'path', u'paths']),
u'pause': (u'paus', [u'pause', u'paused']),
u'paused': (u'paus', [u'pause', u'paused']),
u'payment': (u'payment', [u'payment']),
u'pdf': (u'pdf', [u'pdf']),
u'peers': (u'peers', [u'peers']),
u'pem': (u'pem', [u'pem']),
u'pending': (u'pending', [u'pending']),
u'people': (u'people', [u'people']),
u'per': (u'per', [u'per', u'perform', u'performed', u'performing', u'period', u'periodically', u'permanent', u'permanently', u'permission', u'permissions', u'permit', u'permitted', u'persian', u'persistent', u'persists', u'person', u'persona', u'persona.ini', u'personal', u'personalities', u'personality']),
u'perform': (u'perform', [u'perform', u'performed', u'performing']),
u'performed': (u'perform', [u'perform', u'performed', u'performing']),
u'performing': (u'perform', [u'perform', u'performed', u'performing']),
u'period': (u'period', [u'period', u'periodically']),
u'periodically': (u'periodically', [u'periodically']),
u'permanent': (u'permanent', [u'permanent', u'permanently']),
u'permanently': (u'permanent', [u'permanent', u'permanently']),
u'permission': (u'permission', [u'permission', u'permissions']),
u'permissions': (u'permission', [u'permission', u'permissions']),
u'permit': (u'permit', [u'permit', u'permitted']),
u'permitted': (u'permitted', [u'permitted']),
u'persian': (u'persian', [u'persian']),
u'persistent': (u'persistent', [u'persistent']),
u'persists': (u'persists', [u'persists']),
u'person': (u'person', [u'person', u'persona', u'persona.ini', u'personal', u'personalities', u'personality']),
u'persona': (u'persona', [u'persona', u'persona.ini', u'personal', u'personalities', u'personality']),
u'persona.ini': (u'persona.ini', [u'persona.ini']),
u'personal': (u'personal', [u'personal', u'personalities', u'personality']),
u'personalities': (u'personalit', [u'personalities', u'personality']),
u'personality': (u'personalit', [u'personalities', u'personality']),
u'pfx': (u'pfx', [u'pfx']),
u'phase': (u'phase', [u'phase']),
u'phone': (u'phone', [u'phone', u'phones']),
u'phones': (u'phone', [u'phone', u'phones']),
u'photo': (u'photo', [u'photo', u'photos']),
u'photos': (u'photo', [u'photo', u'photos']),
u'phrase': (u'phrase', [u'phrase']),
u'pick': (u'pick', [u'pick', u'picker']),
u'picker': (u'pick', [u'pick', u'picker']),
u'picture': (u'picture', [u'picture', u'pictures']),
u'pictures': (u'picture', [u'picture', u'pictures']),
u'pin': (u'pin', [u'pin', u'pink', u'pinned', u'pinning']),
u'pink': (u'pink', [u'pink']),
u'pinned': (u'pinn', [u'pinned', u'pinning']),
u'pinning': (u'pinn', [u'pinned', u'pinning']),
u'pitch': (u'pitch', [u'pitch']),
u'pixel': (u'pixel', [u'pixel', u'pixels']),
u'pixels': (u'pixel', [u'pixel', u'pixels']),
u'pkcs': (u'pkcs', [u'pkcs']),
u'place': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'placed': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'placeholder': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'placement': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'places': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'places.sqlite': (u'plac', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite']),
u'plain': (u'pla', [u'place', u'placed', u'placeholder', u'placement', u'places', u'places.sqlite', u'plain', u'plaintext', u'plan', u'plane', u'plans', u'platform', u'platforms', u'play', u'player', u'playing']),
u'plaintext': (u'plaintext', [u'plaintext']),
u'plan': (u'plan', [u'plan', u'plane', u'plans']),
u'plane': (u'plan', [u'plan', u'plane', u'plans']),
u'plans': (u'plan', [u'plan', u'plane', u'plans']),
u'platform': (u'platform', [u'platform', u'platforms']),
u'platforms': (u'platform', [u'platform', u'platforms']),
u'play': (u'play', [u'play', u'player', u'playing']),
u'player': (u'play', [u'play', u'player', u'playing']),
u'playing': (u'play', [u'play', u'player', u'playing']),
u'please': (u'please', [u'please']),
u'plug-in': (u'plug-in', [u'plug-in', u'plug-ins']),
u'plug-ins': (u'plug-in', [u'plug-in', u'plug-ins']),
u'pm': (u'pm', [u'pm']),
u'png': (u'png', [u'png']),
u'po': (u'po', [u'po', u'point', u'pointer', u'policy', u'pool', u'poor', u'pop', u'pop-up', u'pop-ups', u'pop3', u'popular', u'popularity', u'populating', u'port', u'portrait', u'ports', u'portuguese', u'poses', u'position', u'positioning', u'possible', u'possibly', u'post', u'postal', u'posted', u'posts', u'postscript', u'potential', u'power']),
u'point': (u'point', [u'point', u'pointer']),
u'pointer': (u'point', [u'point', u'pointer']),
u'policy': (u'policy', [u'policy']),
u'pool': (u'pool', [u'pool']),
u'poor': (u'poor', [u'poor']),
u'pop': (u'pop', [u'pop', u'pop-up', u'pop-ups', u'pop3', u'popular', u'popularity', u'populating']),
u'pop-up': (u'pop-up', [u'pop-up', u'pop-ups']),
u'pop-ups': (u'pop-up', [u'pop-up', u'pop-ups']),
u'pop3': (u'pop3', [u'pop3']),
u'popular': (u'popular', [u'popular', u'popularity']),
u'popularity': (u'popularity', [u'popularity']),
u'populating': (u'populating', [u'populating']),
u'port': (u'port', [u'port', u'portrait', u'ports', u'portuguese']),
u'portrait': (u'port', [u'port', u'portrait', u'ports', u'portuguese']),
u'ports': (u'port', [u'port', u'portrait', u'ports', u'portuguese']),
u'portuguese': (u'port', [u'port', u'portrait', u'ports', u'portuguese']),
u'poses': (u'poses', [u'poses']),
u'position': (u'position', [u'position', u'positioning']),
u'positioning': (u'position', [u'position', u'positioning']),
u'possible': (u'possible', [u'possible']),
u'possibly': (u'possibly', [u'possibly']),
u'post': (u'post', [u'post', u'postal', u'posted', u'posts', u'postscript']),
u'postal': (u'post', [u'post', u'postal', u'posted', u'posts', u'postscript']),
u'posted': (u'post', [u'post', u'postal', u'posted', u'posts', u'postscript']),
u'posts': (u'post', [u'post', u'postal', u'posted', u'posts', u'postscript']),
u'postscript': (u'post', [u'post', u'postal', u'posted', u'posts', u'postscript']),
u'potential': (u'potential', [u'potential']),
u'power': (u'power', [u'power']),
u'pre': (u'pre', [u'pre', u'pre-fill', u'precedence', u'preconditions', u'prefer', u'preference', u'preferences', u'preferred', u'prefix', u'prefixed', u'prefixes', u'prefs', u'prefs.js', u'preinstalled', u'premium', u'premiumwidgets', u'preparing', u'present', u'presentation', u'presented', u'presents', u'presets', u'press', u'pressed', u'pressing', u'pretty', u'prevent', u'prevention', u'preview', u'previous', u'previously']),
u'pre-fill': (u'pre-fill', [u'pre-fill']),
u'precedence': (u'precedence', [u'precedence']),
u'preconditions': (u'preconditions', [u'preconditions']),
u'prefer': (u'pref', [u'prefer', u'preference', u'preferences', u'preferred', u'prefix', u'prefixed', u'prefixes', u'prefs', u'prefs.js']),
u'preference': (u'preference', [u'preference', u'preferences']),
u'preferences': (u'preference', [u'preference', u'preferences']),
u'preferred': (u'pref', [u'prefer', u'preference', u'preferences', u'preferred', u'prefix', u'prefixed', u'prefixes', u'prefs', u'prefs.js']),
u'prefix': (u'prefix', [u'prefix', u'prefixed', u'prefixes']),
u'prefixed': (u'prefix', [u'prefix', u'prefixed', u'prefixes']),
u'prefixes': (u'prefix', [u'prefix', u'prefixed', u'prefixes']),
u'prefs': (u'pref', [u'prefer', u'preference', u'preferences', u'preferred', u'prefix', u'prefixed', u'prefixes', u'prefs', u'prefs.js']),
u'prefs.js': (u'pref', [u'prefer', u'preference', u'preferences', u'preferred', u'prefix', u'prefixed', u'prefixes', u'prefs', u'prefs.js']),
u'preinstalled': (u'preinstalled', [u'preinstalled']),
u'premium': (u'premium', [u'premium', u'premiumwidgets']),
u'premiumwidgets': (u'premiumwidgets', [u'premiumwidgets']),
u'preparing': (u'preparing', [u'preparing']),
u'present': (u'present', [u'present', u'presentation', u'presented', u'presents']),
u'presentation': (u'present', [u'present', u'presentation', u'presented', u'presents']),
u'presented': (u'present', [u'present', u'presentation', u'presented', u'presents']),
u'presents': (u'present', [u'present', u'presentation', u'presented', u'presents']),
u'presets': (u'presets', [u'presets']),
u'press': (u'press', [u'press', u'pressed', u'pressing']),
u'pressed': (u'press', [u'press', u'pressed', u'pressing']),
u'pressing': (u'press', [u'press', u'pressed', u'pressing']),
u'pretty': (u'pretty', [u'pretty']),
u'prevent': (u'prevent', [u'prevent', u'prevention']),
u'prevention': (u'prevent', [u'prevent', u'prevention']),
u'preview': (u'preview', [u'preview']),
u'previous': (u'previous', [u'previous', u'previously']),
u'previously': (u'previous', [u'previous', u'previously']),
u'price': (u'price', [u'price']),
u'primary': (u'primary', [u'primary']),
u'prime1': (u'prime1', [u'prime1']),
u'prime2': (u'prime2', [u'prime2']),
u'print': (u'print', [u'print', u'printed', u'printer', u'printers', u'printing']),
u'printed': (u'print', [u'print', u'printed', u'printer', u'printers', u'printing']),
u'printer': (u'print', [u'print', u'printed', u'printer', u'printers', u'printing']),
u'printers': (u'print', [u'print', u'printed', u'printer', u'printers', u'printing']),
u'printing': (u'print', [u'print', u'printed', u'printer', u'printers', u'printing']),
u'prior': (u'prior', [u'prior', u'priority']),
u'priority': (u'priority', [u'priority']),
u'privacy': (u'privacy', [u'privacy']),
u'private': (u'private', [u'private', u'privateexponent']),
u'privateexponent': (u'privateexponent', [u'privateexponent']),
u'privilege': (u'privilege', [u'privilege', u'privileges']),
u'privileges': (u'privilege', [u'privilege', u'privileges']),
u'probably': (u'probably', [u'probably']),
u'problem': (u'problem', [u'problem', u'problems']),
u'problems': (u'problem', [u'problem', u'problems']),
u'procedure': (u'procedure', [u'procedure']),
u'proceed': (u'proceed', [u'proceed', u'proceeding']),
u'proceeding': (u'proceed', [u'proceed', u'proceeding']),
u'process': (u'process', [u'process', u'processed', u'processing']),
u'processed': (u'process', [u'process', u'processed', u'processing']),
u'processing': (u'process', [u'process', u'processed', u'processing']),
u'product': (u'product', [u'product', u'productivity', u'productname']),
u'productivity': (u'productivity', [u'productivity']),
u'productname': (u'productname', [u'productname']),
u'profile': (u'profile', [u'profile', u'profiles']),
u'profiles': (u'profile', [u'profile', u'profiles']),
u'program': (u'program', [u'program', u'programs']),
u'programs': (u'program', [u'program', u'programs']),
u'progress': (u'progress', [u'progress', u'progressive']),
u'progressive': (u'progress', [u'progress', u'progressive']),
u'promised': (u'promised', [u'promised']),
u'promo': (u'promo', [u'promo', u'promotional']),
u'promotional': (u'promotional', [u'promotional']),
u'prompt': (u'prompt', [u'prompt']),
u'properly': (u'properly', [u'properly']),
u'properties': (u'propert', [u'properties', u'property']),
u'property': (u'propert', [u'properties', u'property']),
u'protect': (u'protect', [u'protect', u'protected', u'protecting', u'protection']),
u'protected': (u'protect', [u'protect', u'protected', u'protecting', u'protection']),
u'protecting': (u'protect', [u'protect', u'protected', u'protecting', u'protection']),
u'protection': (u'protect', [u'protect', u'protected', u'protecting', u'protection']),
u'protocol': (u'protocol', [u'protocol', u'protocols']),
u'protocols': (u'protocol', [u'protocol', u'protocols']),
u'prototype': (u'prototype', [u'prototype', u'prototypes']),
u'prototypes': (u'prototype', [u'prototype', u'prototypes']),
u'provide': (u'provid', [u'provide', u'provided', u'provider', u'providers', u'provides']),
u'provided': (u'provid', [u'provide', u'provided', u'provider', u'providers', u'provides']),
u'provider': (u'provid', [u'provide', u'provided', u'provider', u'providers', u'provides']),
u'providers': (u'provid', [u'provide', u'provided', u'provider', u'providers', u'provides']),
u'provides': (u'provid', [u'provide', u'provided', u'provider', u'providers', u'provides']),
u'proxy': (u'proxy', [u'proxy', u'proxyhost']),
u'proxyhost': (u'proxyhost', [u'proxyhost']),
u'ps': (u'ps', [u'ps', u'pseudo-elements']),
u'pseudo-elements': (u'pseudo-elements', [u'pseudo-elements']),
u'public': (u'public', [u'public', u'publicexponent', u'publicly']),
u'publicexponent': (u'public', [u'public', u'publicexponent', u'publicly']),
u'publicly': (u'public', [u'public', u'publicexponent', u'publicly']),
u'publish': (u'publish', [u'publish', u'published', u'publishing']),
u'published': (u'publish', [u'publish', u'published', u'publishing']),
u'publishing': (u'publish', [u'publish', u'published', u'publishing']),
u'punctuated': (u'punctuat', [u'punctuated', u'punctuation']),
u'punctuation': (u'punctuat', [u'punctuated', u'punctuation']),
u'purchase': (u'purchase', [u'purchase']),
u'purge': (u'purge', [u'purge']),
u'purple': (u'purple', [u'purple']),
u'purpose': (u'purpose', [u'purpose', u'purposes']),
u'purposes': (u'purpose', [u'purpose', u'purposes']),
u'push': (u'push', [u'push']),
u'put': (u'put', [u'put', u'puts']),
u'puts': (u'put', [u'put', u'puts']),
u'qn': (u'qn', [u'qn']),
u'qt': (u'qt', [u'qt']),
u'quality': (u'quality', [u'quality']),
u'query': (u'query', [u'query']),
u'question': (u'question', [u'question']),
u'queue': (u'queu', [u'queue', u'queued']),
u'queued': (u'queu', [u'queue', u'queued']),
u'quick': (u'quick', [u'quick', u'quickly']),
u'quickly': (u'quick', [u'quick', u'quickly']),
u'quiet': (u'quiet', [u'quiet']),
u'quirks': (u'quirks', [u'quirks']),
u'quit': (u'quit', [u'quit']),
u'quota': (u'quot', [u'quota', u'quote', u'quoted']),
u'quote': (u'quot', [u'quota', u'quote', u'quoted']),
u'quoted': (u'quot', [u'quota', u'quote', u'quoted']),
u'r': (u'r', [u'r', u'raising', u'random', u'randomly-generated', u'range', u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio', u'raw', u're', u're-enable', u're-enter', u're-install', u're-submit', u're-synchronizing', u're-type', u're-typed', u'reachable', u'reached', u'reactivate', u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready', u'real', u'really', u'realm', u'realtime', u'rearrange', u'reason', u'reasons', u'reboot', u'receipt', u'receive', u'received', u'receiver', u'receiving', u'recent', u'recently', u'recipient', u'recipients', u'recognizable', u'recognize', u'recognized', u'recommend', u'recommended', u'recommends', u'reconnect', u'reconnecting', u'reconnection', u'record', u'recover', u'recursive', u'recv', u'red', u'redirect', u'redirected', u'redirecting', u'redirection', u'redistributable', u'redo', u'redraw', u'reduced', u'reducing', u'refer', u'reference', u'referrer', u'refined', u'reformatted', u'refresh', u'refuse', u'refused', u'refuses', u'regexp', u'region', u'register', u'registered', u'registration', u'registry', u'regular', u'regularly', u'reindex', u'reinstall', u'reinstalling', u'reject', u'rejected', u'rejected-not', u'rejecting', u'related', u'relating', u'relative', u'relaunch', u'relaunching', u'reload', u'reloading', u'reloads', u'rely', u'remain', u'remaining', u'remains', u'remember', u'remind', u'reminded', u'remote', u'remotely', u'removable', u'removal', u'remove', u'removed', u'removing', u'rename', u'renamed', u'renaming', u'render', u'rendered', u'rendering', u'renegotiation', u'reorder', u'repair', u'reparse', u'repeat', u'repeated', u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying', u'report', u'reported', u'reporting', u'reports', u'repost', u'represent', u'request', u'requested', u'requesting', u'requests', u'require', u'required', u'requirement', u'requirements', u'requires', u'resending', u'resent-from', u'reserved', u'reset', u'resetting', u'resize', u'resizing', u'resolution', u'resolved', u'resource', u'resources', u'respond', u'responded', u'response', u'responses', u'restart', u'restarted', u'restarting', u'restoration', u'restore', u'restored', u'restrict', u'restricted', u'restriction', u'restrictions', u'result', u'results', u'resume', u'resuming', u'resynchronize', u'retain', u'retracted', u'retrieval', u'retrieve', u'retrieved', u'retrieving', u'retry', u'retrying', u'return', u'returned', u'retype', u'reuse', u'rev', u'revealing', u'revert', u'review', u'reviews', u'revision', u'revocation', u'revoked', u'rewind', u'rich', u'right', u'right-click', u'right-to-left', u'rights', u'ringtone', u'ringtones', u'risk', u'roaming', u'room', u'rooms', u'root', u'roups', u'route', u'router', u'rpm', u'rpm-build', u'rss', u'rule', u'rules', u'run', u'runic', u'running', u'runs', u'runtime', u'russian']),
u'raising': (u'raising', [u'raising']),
u'random': (u'random', [u'random', u'randomly-generated']),
u'randomly-generated': (u'randomly-generated', [u'randomly-generated']),
u'range': (u'range', [u'range']),
u'rate': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'rated': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'rates': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'rather': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'rating': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'ratings': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'ratio': (u'rat', [u'rate', u'rated', u'rates', u'rather', u'rating', u'ratings', u'ratio']),
u'raw': (u'raw', [u'raw']),
u're': (u're', [u're', u're-enable', u're-enter', u're-install', u're-submit', u're-synchronizing', u're-type', u're-typed', u'reachable', u'reached', u'reactivate', u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready', u'real', u'really', u'realm', u'realtime', u'rearrange', u'reason', u'reasons', u'reboot', u'receipt', u'receive', u'received', u'receiver', u'receiving', u'recent', u'recently', u'recipient', u'recipients', u'recognizable', u'recognize', u'recognized', u'recommend', u'recommended', u'recommends', u'reconnect', u'reconnecting', u'reconnection', u'record', u'recover', u'recursive', u'recv', u'red', u'redirect', u'redirected', u'redirecting', u'redirection', u'redistributable', u'redo', u'redraw', u'reduced', u'reducing', u'refer', u'reference', u'referrer', u'refined', u'reformatted', u'refresh', u'refuse', u'refused', u'refuses', u'regexp', u'region', u'register', u'registered', u'registration', u'registry', u'regular', u'regularly', u'reindex', u'reinstall', u'reinstalling', u'reject', u'rejected', u'rejected-not', u'rejecting', u'related', u'relating', u'relative', u'relaunch', u'relaunching', u'reload', u'reloading', u'reloads', u'rely', u'remain', u'remaining', u'remains', u'remember', u'remind', u'reminded', u'remote', u'remotely', u'removable', u'removal', u'remove', u'removed', u'removing', u'rename', u'renamed', u'renaming', u'render', u'rendered', u'rendering', u'renegotiation', u'reorder', u'repair', u'reparse', u'repeat', u'repeated', u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying', u'report', u'reported', u'reporting', u'reports', u'repost', u'represent', u'request', u'requested', u'requesting', u'requests', u'require', u'required', u'requirement', u'requirements', u'requires', u'resending', u'resent-from', u'reserved', u'reset', u'resetting', u'resize', u'resizing', u'resolution', u'resolved', u'resource', u'resources', u'respond', u'responded', u'response', u'responses', u'restart', u'restarted', u'restarting', u'restoration', u'restore', u'restored', u'restrict', u'restricted', u'restriction', u'restrictions', u'result', u'results', u'resume', u'resuming', u'resynchronize', u'retain', u'retracted', u'retrieval', u'retrieve', u'retrieved', u'retrieving', u'retry', u'retrying', u'return', u'returned', u'retype', u'reuse', u'rev', u'revealing', u'revert', u'review', u'reviews', u'revision', u'revocation', u'revoked', u'rewind']),
u're-enable': (u're-enable', [u're-enable']),
u're-enter': (u're-enter', [u're-enter']),
u're-install': (u're-install', [u're-install']),
u're-submit': (u're-submit', [u're-submit']),
u're-synchronizing': (u're-synchronizing', [u're-synchronizing']),
u're-type': (u're-typ', [u're-type', u're-typed']),
u're-typed': (u're-typ', [u're-type', u're-typed']),
u'reachable': (u'reach', [u'reachable', u'reached']),
u'reached': (u'reach', [u'reachable', u'reached']),
u'reactivate': (u'reactivate', [u'reactivate']),
u'read': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'read-only': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'read-write': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'reader': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'reading': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'readonly': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'ready': (u'read', [u'read', u'read-only', u'read-write', u'reader', u'reading', u'readonly', u'ready']),
u'real': (u'real', [u'real', u'really', u'realm', u'realtime']),
u'really': (u'real', [u'real', u'really', u'realm', u'realtime']),
u'realm': (u'real', [u'real', u'really', u'realm', u'realtime']),
u'realtime': (u'real', [u'real', u'really', u'realm', u'realtime']),
u'rearrange': (u'rearrange', [u'rearrange']),
u'reason': (u'reason', [u'reason', u'reasons']),
u'reasons': (u'reason', [u'reason', u'reasons']),
u'reboot': (u'reboot', [u'reboot']),
u'receipt': (u'receipt', [u'receipt']),
u'receive': (u'receiv', [u'receive', u'received', u'receiver', u'receiving']),
u'received': (u'receiv', [u'receive', u'received', u'receiver', u'receiving']),
u'receiver': (u'receiv', [u'receive', u'received', u'receiver', u'receiving']),
u'receiving': (u'receiv', [u'receive', u'received', u'receiver', u'receiving']),
u'recent': (u'recent', [u'recent', u'recently']),
u'recently': (u'recent', [u'recent', u'recently']),
u'recipient': (u'recipient', [u'recipient', u'recipients']),
u'recipients': (u'recipient', [u'recipient', u'recipients']),
u'recognizable': (u'recogniz', [u'recognizable', u'recognize', u'recognized']),
u'recognize': (u'recogniz', [u'recognizable', u'recognize', u'recognized']),
u'recognized': (u'recogniz', [u'recognizable', u'recognize', u'recognized']),
u'recommend': (u'recommend', [u'recommend', u'recommended', u'recommends']),
u'recommended': (u'recommend', [u'recommend', u'recommended', u'recommends']),
u'recommends': (u'recommend', [u'recommend', u'recommended', u'recommends']),
u'reconnect': (u'reconnect', [u'reconnect', u'reconnecting', u'reconnection']),
u'reconnecting': (u'reconnect', [u'reconnect', u'reconnecting', u'reconnection']),
u'reconnection': (u'reconnect', [u'reconnect', u'reconnecting', u'reconnection']),
u'record': (u'record', [u'record']),
u'recover': (u'recover', [u'recover']),
u'recursive': (u'recursive', [u'recursive']),
u'recv': (u'recv', [u'recv']),
u'red': (u'red', [u'red', u'redirect', u'redirected', u'redirecting', u'redirection', u'redistributable', u'redo', u'redraw', u'reduced', u'reducing']),
u'redirect': (u'redirect', [u'redirect', u'redirected', u'redirecting', u'redirection']),
u'redirected': (u'redirect', [u'redirect', u'redirected', u'redirecting', u'redirection']),
u'redirecting': (u'redirect', [u'redirect', u'redirected', u'redirecting', u'redirection']),
u'redirection': (u'redirect', [u'redirect', u'redirected', u'redirecting', u'redirection']),
u'redistributable': (u'redistributable', [u'redistributable']),
u'redo': (u'redo', [u'redo']),
u'redraw': (u'redraw', [u'redraw']),
u'reduced': (u'reduc', [u'reduced', u'reducing']),
u'reducing': (u'reduc', [u'reduced', u'reducing']),
u'refer': (u'refer', [u'refer', u'reference', u'referrer']),
u'reference': (u'reference', [u'reference']),
u'referrer': (u'referrer', [u'referrer']),
u'refined': (u'refined', [u'refined']),
u'reformatted': (u'reformatted', [u'reformatted']),
u'refresh': (u'refresh', [u'refresh']),
u'refuse': (u'refus', [u'refuse', u'refused', u'refuses']),
u'refused': (u'refus', [u'refuse', u'refused', u'refuses']),
u'refuses': (u'refus', [u'refuse', u'refused', u'refuses']),
u'regexp': (u'regexp', [u'regexp']),
u'region': (u'region', [u'region']),
u'register': (u'register', [u'register', u'registered']),
u'registered': (u'register', [u'register', u'registered']),
u'registration': (u'registr', [u'registration', u'registry']),
u'registry': (u'registr', [u'registration', u'registry']),
u'regular': (u'regular', [u'regular', u'regularly']),
u'regularly': (u'regular', [u'regular', u'regularly']),
u'reindex': (u'reindex', [u'reindex']),
u'reinstall': (u'reinstall', [u'reinstall', u'reinstalling']),
u'reinstalling': (u'reinstall', [u'reinstall', u'reinstalling']),
u'reject': (u'reject', [u'reject', u'rejected', u'rejected-not', u'rejecting']),
u'rejected': (u'reject', [u'reject', u'rejected', u'rejected-not', u'rejecting']),
u'rejected-not': (u'reject', [u'reject', u'rejected', u'rejected-not', u'rejecting']),
u'rejecting': (u'reject', [u'reject', u'rejected', u'rejected-not', u'rejecting']),
u'related': (u'relat', [u'related', u'relating', u'relative']),
u'relating': (u'relat', [u'related', u'relating', u'relative']),
u'relative': (u'relat', [u'related', u'relating', u'relative']),
u'relaunch': (u'relaunch', [u'relaunch', u'relaunching']),
u'relaunching': (u'relaunch', [u'relaunch', u'relaunching']),
u'reload': (u'reload', [u'reload', u'reloading', u'reloads']),
u'reloading': (u'reload', [u'reload', u'reloading', u'reloads']),
u'reloads': (u'reload', [u'reload', u'reloading', u'reloads']),
u'rely': (u'rely', [u'rely']),
u'remain': (u'remain', [u'remain', u'remaining', u'remains']),
u'remaining': (u'remain', [u'remain', u'remaining', u'remains']),
u'remains': (u'remain', [u'remain', u'remaining', u'remains']),
u'remember': (u'remember', [u'remember']),
u'remind': (u'remind', [u'remind', u'reminded']),
u'reminded': (u'remind', [u'remind', u'reminded']),
u'remote': (u'remote', [u'remote', u'remotely']),
u'remotely': (u'remote', [u'remote', u'remotely']),
u'removable': (u'remov', [u'removable', u'removal', u'remove', u'removed', u'removing']),
u'removal': (u'remov', [u'removable', u'removal', u'remove', u'removed', u'removing']),
u'remove': (u'remov', [u'removable', u'removal', u'remove', u'removed', u'removing']),
u'removed': (u'remov', [u'removable', u'removal', u'remove', u'removed', u'removing']),
u'removing': (u'remov', [u'removable', u'removal', u'remove', u'removed', u'removing']),
u'rename': (u'renam', [u'rename', u'renamed', u'renaming']),
u'renamed': (u'renam', [u'rename', u'renamed', u'renaming']),
u'renaming': (u'renam', [u'rename', u'renamed', u'renaming']),
u'render': (u'render', [u'render', u'rendered', u'rendering']),
u'rendered': (u'render', [u'render', u'rendered', u'rendering']),
u'rendering': (u'render', [u'render', u'rendered', u'rendering']),
u'renegotiation': (u'renegotiation', [u'renegotiation']),
u'reorder': (u'reorder', [u'reorder']),
u'repair': (u'repair', [u'repair']),
u'reparse': (u'reparse', [u'reparse']),
u'repeat': (u'repeat', [u'repeat', u'repeated']),
u'repeated': (u'repeat', [u'repeat', u'repeated']),
u'replace': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'replaced': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'replies': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'reply': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'reply-to': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'replying': (u'repl', [u'replace', u'replaced', u'replies', u'reply', u'reply-to', u'replying']),
u'report': (u'report', [u'report', u'reported', u'reporting', u'reports']),
u'reported': (u'report', [u'report', u'reported', u'reporting', u'reports']),
u'reporting': (u'report', [u'report', u'reported', u'reporting', u'reports']),
u'reports': (u'report', [u'report', u'reported', u'reporting', u'reports']),
u'repost': (u'repost', [u'repost']),
u'represent': (u'represent', [u'represent']),
u'request': (u'request', [u'request', u'requested', u'requesting', u'requests']),
u'requested': (u'request', [u'request', u'requested', u'requesting', u'requests']),
u'requesting': (u'request', [u'request', u'requested', u'requesting', u'requests']),
u'requests': (u'request', [u'request', u'requested', u'requesting', u'requests']),
u'require': (u'requir', [u'require', u'required', u'requirement', u'requirements', u'requires']),
u'required': (u'requir', [u'require', u'required', u'requirement', u'requirements', u'requires']),
u'requirement': (u'requir', [u'require', u'required', u'requirement', u'requirements', u'requires']),
u'requirements': (u'requir', [u'require', u'required', u'requirement', u'requirements', u'requires']),
u'requires': (u'requir', [u'require', u'required', u'requirement', u'requirements', u'requires']),
u'resending': (u'resending', [u'resending']),
u'resent-from': (u'resent-from', [u'resent-from']),
u'reserved': (u'reserved', [u'reserved']),
u'reset': (u'reset', [u'reset', u'resetting']),
u'resetting': (u'resetting', [u'resetting']),
u'resize': (u'resiz', [u'resize', u'resizing']),
u'resizing': (u'resiz', [u'resize', u'resizing']),
u'resolution': (u'resolution', [u'resolution']),
u'resolved': (u'resolved', [u'resolved']),
u'resource': (u'resource', [u'resource', u'resources']),
u'resources': (u'resource', [u'resource', u'resources']),
u'respond': (u'respond', [u'respond', u'responded']),
u'responded': (u'respond', [u'respond', u'responded']),
u'response': (u'response', [u'response', u'responses']),
u'responses': (u'response', [u'response', u'responses']),
u'restart': (u'restart', [u'restart', u'restarted', u'restarting']),
u'restarted': (u'restart', [u'restart', u'restarted', u'restarting']),
u'restarting': (u'restart', [u'restart', u'restarted', u'restarting']),
u'restoration': (u'restor', [u'restoration', u'restore', u'restored']),
u'restore': (u'restor', [u'restoration', u'restore', u'restored']),
u'restored': (u'restor', [u'restoration', u'restore', u'restored']),
u'restrict': (u'restrict', [u'restrict', u'restricted', u'restriction', u'restrictions']),
u'restricted': (u'restrict', [u'restrict', u'restricted', u'restriction', u'restrictions']),
u'restriction': (u'restrict', [u'restrict', u'restricted', u'restriction', u'restrictions']),
u'restrictions': (u'restrict', [u'restrict', u'restricted', u'restriction', u'restrictions']),
u'result': (u'result', [u'result', u'results']),
u'results': (u'result', [u'result', u'results']),
u'resume': (u'resum', [u'resume', u'resuming']),
u'resuming': (u'resum', [u'resume', u'resuming']),
u'resynchronize': (u'resynchronize', [u'resynchronize']),
u'retain': (u'retain', [u'retain']),
u'retracted': (u'retr', [u'retracted', u'retrieval', u'retrieve', u'retrieved', u'retrieving', u'retry', u'retrying']),
u'retrieval': (u'retriev', [u'retrieval', u'retrieve', u'retrieved', u'retrieving']),
u'retrieve': (u'retriev', [u'retrieval', u'retrieve', u'retrieved', u'retrieving']),
u'retrieved': (u'retriev', [u'retrieval', u'retrieve', u'retrieved', u'retrieving']),
u'retrieving': (u'retriev', [u'retrieval', u'retrieve', u'retrieved', u'retrieving']),
u'retry': (u'retry', [u'retry', u'retrying']),
u'retrying': (u'retry', [u'retry', u'retrying']),
u'return': (u'return', [u'return', u'returned']),
u'returned': (u'return', [u'return', u'returned']),
u'retype': (u'retype', [u'retype']),
u'reuse': (u'reuse', [u'reuse']),
u'rev': (u'rev', [u'rev', u'revealing', u'revert', u'review', u'reviews', u'revision', u'revocation', u'revoked']),
u'revealing': (u'revealing', [u'revealing']),
u'revert': (u'revert', [u'revert']),
u'review': (u'review', [u'review', u'reviews']),
u'reviews': (u'review', [u'review', u'reviews']),
u'revision': (u'revision', [u'revision']),
u'revocation': (u'revocation', [u'revocation']),
u'revoked': (u'revoked', [u'revoked']),
u'rewind': (u'rewind', [u'rewind']),
u'rich': (u'rich', [u'rich']),
u'right': (u'right', [u'right', u'right-click', u'right-to-left', u'rights']),
u'right-click': (u'right', [u'right', u'right-click', u'right-to-left', u'rights']),
u'right-to-left': (u'right', [u'right', u'right-click', u'right-to-left', u'rights']),
u'rights': (u'right', [u'right', u'right-click', u'right-to-left', u'rights']),
u'ringtone': (u'ringtone', [u'ringtone', u'ringtones']),
u'ringtones': (u'ringtone', [u'ringtone', u'ringtones']),
u'risk': (u'risk', [u'risk']),
u'roaming': (u'roaming', [u'roaming']),
u'room': (u'room', [u'room', u'rooms']),
u'rooms': (u'room', [u'room', u'rooms']),
u'root': (u'root', [u'root']),
u'roups': (u'roups', [u'roups']),
u'route': (u'rout', [u'route', u'router']),
u'router': (u'rout', [u'route', u'router']),
u'rpm': (u'rpm', [u'rpm', u'rpm-build']),
u'rpm-build': (u'rpm-build', [u'rpm-build']),
u'rss': (u'rss', [u'rss']),
u'rule': (u'rule', [u'rule', u'rules']),
u'rules': (u'rule', [u'rule', u'rules']),
u'run': (u'run', [u'run', u'runic', u'running', u'runs', u'runtime']),
u'runic': (u'run', [u'run', u'runic', u'running', u'runs', u'runtime']),
u'running': (u'run', [u'run', u'runic', u'running', u'runs', u'runtime']),
u'runs': (u'run', [u'run', u'runic', u'running', u'runs', u'runtime']),
u'runtime': (u'run', [u'run', u'runic', u'running', u'runs', u'runtime']),
u'russian': (u'russian', [u'russian']),
u's': (u's', [u's', u's-files', u'safe', u'safely', u'safer', u'said', u'same', u'sample', u'samsung', u'sand', u'sans-serif', u'sat', u'satisfy', u'saturation', u'saturday', u'save', u'saved', u'saving', u'savings', u'says', u'sbe', u'scale', u'scanned', u'scanner', u'scene', u'scheduling', u'scheme', u'scope', u'screen', u'screenshot', u'screenshots', u'script', u'scripting', u'scripts', u'scroll', u'scrollbars', u'scrolling', u'sd', u'sdo', u'sdocuments', u'sea', u'search', u'searchable', u'searched', u'searches', u'searching', u'sec', u'second', u'secondary', u'seconds', u'secret', u'section', u'sections', u'secure', u'securely', u'security', u'see', u'seeds', u'seem', u'seems', u'seen', u'select', u'selected', u'selecting', u'selection', u'selector', u'send', u'sender', u'senders', u'sending', u'sends', u'sensing', u'sensitive', u'sensitivity', u'sent', u'sep', u'separate', u'separately', u'separator', u'september', u'sequence', u'serial', u'serif', u'server', u'server-side', u'servername', u'servers', u'service', u'services', u'session', u'sessions', u'set', u'sets', u'setting', u'settings', u'setup', u'setup.ini', u'setups', u'several', u'severe', u'sha-1', u'shader', u'share', u'shared', u'sharing', u'sharpness', u'sheet', u'sheets', u'shift', u'shift-jis', u'shipped', u'shop', u'shopping', u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly', u'should', u'show', u'showcase', u'showing', u'shown', u'shows', u'shut', u'shutter', u'shutting', u'siblings', u'side', u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing', u'silent', u'sim', u'similar', u'simple', u'simplified', u'since', u'single', u'single-column', u'single-key', u'single-line', u'sinhala', u'site', u'sitecheck2.opera.com', u'sites', u'size', u'skin', u'skin.ini', u'skinning', u'skip', u'skipped', u'slash', u'sleek', u'slow', u'small', u'small-screen', u'smaller', u'smallest', u'smart-printing', u'smiley', u'smileys', u'smooth', u'sms', u'smtp', u'snaps', u'snip', u'snow', u'so', u'social', u'socialize', u'socket', u'sockets', u'socks', u'soft', u'software', u'some', u'somebody', u'someone', u'something', u'soon', u'sorry', u'sort', u'sorted', u'sorting', u'sound', u'sounds', u'source', u'sources', u'south', u'southern', u'space', u'spacer', u'spacers', u'spaces', u'spam', u'spanish', u'speak', u'speaking', u'special', u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying', u'spectral', u'speech', u'speed', u'speeddial', u'speeds', u'speedy', u'spell', u'spell-checker', u'spelled', u'spelling', u'spent', u'split', u'sports', u'spot', u'ssid', u'ssl', u'stack', u'stage', u'stand-alone', u'standalone', u'standard', u'standards', u'star', u'starred', u'stars', u'start', u'started', u'starting', u'starts', u'startup', u'state', u'statement', u'statically', u'statistics', u'status', u'stay', u'stdin', u'step', u'steps', u'stick', u'still', u'stop', u'stopped', u'stopping', u'storage', u'store', u'stored', u'stores', u'storing', u'stream', u'street', u'strength', u'stretch', u'strike', u'strikeout', u'strikethrough', u'string', u'strings', u'stripped', u'strong', u'strongest', u'strongly', u'structural', u'structure', u'style', u'styles', u'stylesheet', u'stylesheets', u'styling', u'sub-messages', u'subfolder', u'subfolders', u'subject', u'submission', u'submit', u'submitted', u'submitting', u'subscribe', u'subscribed', u'subscribing', u'subscript', u'subscription', u'subtree', u'subviews', u'succeed', u'succeeded', u'success', u'successful', u'successfully', u'such', u'sufficient', u'sufficiently', u'suffix', u'suffixes', u'suggested', u'suggestion', u'suggestions', u'suitable', u'summary', u'sun', u'sunday', u'super', u'superscript', u'supplement', u'supplied', u'support', u'supported', u'supports', u'supposed', u'suppressed', u'sure', u'surf', u'surfing', u'surprised', u'suspected', u'suspend', u'suspended', u'svg', u'svgz', u'switch', u'switches', u'switching', u'syllabic', u'symbol', u'symbols', u'symlink', u'sync', u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing', u'synchronous', u'syntax', u'syriac', u'system', u'systems']),
u's-files': (u's-files', [u's-files']),
u'safe': (u'saf', [u'safe', u'safely', u'safer']),
u'safely': (u'saf', [u'safe', u'safely', u'safer']),
u'safer': (u'saf', [u'safe', u'safely', u'safer']),
u'said': (u'said', [u'said']),
u'same': (u'same', [u'same']),
u'sample': (u'sample', [u'sample']),
u'samsung': (u'samsung', [u'samsung']),
u'sand': (u'sand', [u'sand']),
u'sans-serif': (u'sans-serif', [u'sans-serif']),
u'sat': (u'sat', [u'sat', u'satisfy', u'saturation', u'saturday']),
u'satisfy': (u'satisfy', [u'satisfy']),
u'saturation': (u'saturation', [u'saturation']),
u'saturday': (u'saturday', [u'saturday']),
u'save': (u'sav', [u'save', u'saved', u'saving', u'savings']),
u'saved': (u'sav', [u'save', u'saved', u'saving', u'savings']),
u'saving': (u'sav', [u'save', u'saved', u'saving', u'savings']),
u'savings': (u'sav', [u'save', u'saved', u'saving', u'savings']),
u'says': (u'says', [u'says']),
u'sbe': (u'sbe', [u'sbe']),
u'scale': (u'scale', [u'scale']),
u'scanned': (u'scann', [u'scanned', u'scanner']),
u'scanner': (u'scann', [u'scanned', u'scanner']),
u'scene': (u'scene', [u'scene']),
u'scheduling': (u'scheduling', [u'scheduling']),
u'scheme': (u'scheme', [u'scheme']),
u'scope': (u'scope', [u'scope']),
u'screen': (u'screen', [u'screen', u'screenshot', u'screenshots']),
u'screenshot': (u'screenshot', [u'screenshot', u'screenshots']),
u'screenshots': (u'screenshot', [u'screenshot', u'screenshots']),
u'script': (u'script', [u'script', u'scripting', u'scripts']),
u'scripting': (u'script', [u'script', u'scripting', u'scripts']),
u'scripts': (u'script', [u'script', u'scripting', u'scripts']),
u'scroll': (u'scroll', [u'scroll', u'scrollbars', u'scrolling']),
u'scrollbars': (u'scroll', [u'scroll', u'scrollbars', u'scrolling']),
u'scrolling': (u'scroll', [u'scroll', u'scrollbars', u'scrolling']),
u'sd': (u'sd', [u'sd', u'sdo', u'sdocuments']),
u'sdo': (u'sdo', [u'sdo', u'sdocuments']),
u'sdocuments': (u'sdocuments', [u'sdocuments']),
u'sea': (u'sea', [u'sea', u'search', u'searchable', u'searched', u'searches', u'searching']),
u'search': (u'search', [u'search', u'searchable', u'searched', u'searches', u'searching']),
u'searchable': (u'search', [u'search', u'searchable', u'searched', u'searches', u'searching']),
u'searched': (u'search', [u'search', u'searchable', u'searched', u'searches', u'searching']),
u'searches': (u'search', [u'search', u'searchable', u'searched', u'searches', u'searching']),
u'searching': (u'search', [u'search', u'searchable', u'searched', u'searches', u'searching']),
u'sec': (u'sec', [u'sec', u'second', u'secondary', u'seconds', u'secret', u'section', u'sections', u'secure', u'securely', u'security']),
u'second': (u'second', [u'second', u'secondary', u'seconds']),
u'secondary': (u'second', [u'second', u'secondary', u'seconds']),
u'seconds': (u'second', [u'second', u'secondary', u'seconds']),
u'secret': (u'secret', [u'secret']),
u'section': (u'section', [u'section', u'sections']),
u'sections': (u'section', [u'section', u'sections']),
u'secure': (u'secur', [u'secure', u'securely', u'security']),
u'securely': (u'secur', [u'secure', u'securely', u'security']),
u'security': (u'secur', [u'secure', u'securely', u'security']),
u'see': (u'see', [u'see', u'seeds', u'seem', u'seems', u'seen']),
u'seeds': (u'seeds', [u'seeds']),
u'seem': (u'seem', [u'seem', u'seems']),
u'seems': (u'seem', [u'seem', u'seems']),
u'seen': (u'seen', [u'seen']),
u'select': (u'select', [u'select', u'selected', u'selecting', u'selection', u'selector']),
u'selected': (u'select', [u'select', u'selected', u'selecting', u'selection', u'selector']),
u'selecting': (u'select', [u'select', u'selected', u'selecting', u'selection', u'selector']),
u'selection': (u'select', [u'select', u'selected', u'selecting', u'selection', u'selector']),
u'selector': (u'select', [u'select', u'selected', u'selecting', u'selection', u'selector']),
u'send': (u'send', [u'send', u'sender', u'senders', u'sending', u'sends']),
u'sender': (u'send', [u'send', u'sender', u'senders', u'sending', u'sends']),
u'senders': (u'send', [u'send', u'sender', u'senders', u'sending', u'sends']),
u'sending': (u'send', [u'send', u'sender', u'senders', u'sending', u'sends']),
u'sends': (u'send', [u'send', u'sender', u'senders', u'sending', u'sends']),
u'sensing': (u'sensing', [u'sensing']),
u'sensitive': (u'sensitiv', [u'sensitive', u'sensitivity']),
u'sensitivity': (u'sensitiv', [u'sensitive', u'sensitivity']),
u'sent': (u'sent', [u'sent']),
u'sep': (u'sep', [u'sep', u'separate', u'separately', u'separator', u'september']),
u'separate': (u'separat', [u'separate', u'separately', u'separator']),
u'separately': (u'separat', [u'separate', u'separately', u'separator']),
u'separator': (u'separat', [u'separate', u'separately', u'separator']),
u'september': (u'september', [u'september']),
u'sequence': (u'sequence', [u'sequence']),
u'serial': (u'serial', [u'serial']),
u'serif': (u'serif', [u'serif']),
u'server': (u'server', [u'server', u'server-side', u'servername', u'servers']),
u'server-side': (u'server', [u'server', u'server-side', u'servername', u'servers']),
u'servername': (u'server', [u'server', u'server-side', u'servername', u'servers']),
u'servers': (u'server', [u'server', u'server-side', u'servername', u'servers']),
u'service': (u'service', [u'service', u'services']),
u'services': (u'service', [u'service', u'services']),
u'session': (u'session', [u'session', u'sessions']),
u'sessions': (u'session', [u'session', u'sessions']),
u'set': (u'set', [u'set', u'sets', u'setting', u'settings', u'setup', u'setup.ini', u'setups']),
u'sets': (u'set', [u'set', u'sets', u'setting', u'settings', u'setup', u'setup.ini', u'setups']),
u'setting': (u'setting', [u'setting', u'settings']),
u'settings': (u'setting', [u'setting', u'settings']),
u'setup': (u'setup', [u'setup', u'setup.ini', u'setups']),
u'setup.ini': (u'setup', [u'setup', u'setup.ini', u'setups']),
u'setups': (u'setup', [u'setup', u'setup.ini', u'setups']),
u'several': (u'several', [u'several']),
u'severe': (u'severe', [u'severe']),
u'sha-1': (u'sha-1', [u'sha-1']),
u'shader': (u'shader', [u'shader']),
u'share': (u'shar', [u'share', u'shared', u'sharing', u'sharpness']),
u'shared': (u'shar', [u'share', u'shared', u'sharing', u'sharpness']),
u'sharing': (u'shar', [u'share', u'shared', u'sharing', u'sharpness']),
u'sharpness': (u'shar', [u'share', u'shared', u'sharing', u'sharpness']),
u'sheet': (u'sheet', [u'sheet', u'sheets']),
u'sheets': (u'sheet', [u'sheet', u'sheets']),
u'shift': (u'shift', [u'shift', u'shift-jis']),
u'shift-jis': (u'shift-jis', [u'shift-jis']),
u'shipped': (u'shipped', [u'shipped']),
u'shop': (u'shop', [u'shop', u'shopping']),
u'shopping': (u'shopping', [u'shopping']),
u'short': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'shortcut': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'shortcuts': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'shorter': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'shorthands': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'shortly': (u'short', [u'short', u'shortcut', u'shortcuts', u'shorter', u'shorthands', u'shortly']),
u'should': (u'should', [u'should']),
u'show': (u'show', [u'show', u'showcase', u'showing', u'shown', u'shows']),
u'showcase': (u'show', [u'show', u'showcase', u'showing', u'shown', u'shows']),
u'showing': (u'show', [u'show', u'showcase', u'showing', u'shown', u'shows']),
u'shown': (u'show', [u'show', u'showcase', u'showing', u'shown', u'shows']),
u'shows': (u'show', [u'show', u'showcase', u'showing', u'shown', u'shows']),
u'shut': (u'shut', [u'shut', u'shutter', u'shutting']),
u'shutter': (u'shutt', [u'shutter', u'shutting']),
u'shutting': (u'shutt', [u'shutter', u'shutting']),
u'siblings': (u'siblings', [u'siblings']),
u'side': (u'side', [u'side']),
u'sign': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'signature': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'signatures': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'signed': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'signer': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'significantly': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'signing': (u'sign', [u'sign', u'signature', u'signatures', u'signed', u'signer', u'significantly', u'signing']),
u'silent': (u'silent', [u'silent']),
u'sim': (u'sim', [u'sim', u'similar', u'simple', u'simplified']),
u'similar': (u'similar', [u'similar']),
u'simple': (u'simple', [u'simple']),
u'simplified': (u'simplified', [u'simplified']),
u'since': (u'since', [u'since']),
u'single': (u'single', [u'single', u'single-column', u'single-key', u'single-line']),
u'single-column': (u'single-column', [u'single-column']),
u'single-key': (u'single-key', [u'single-key']),
u'single-line': (u'single-line', [u'single-line']),
u'sinhala': (u'sinhala', [u'sinhala']),
u'site': (u'site', [u'site', u'sitecheck2.opera.com', u'sites']),
u'sitecheck2.opera.com': (u'sitecheck2.opera.com', [u'sitecheck2.opera.com']),
u'sites': (u'site', [u'site', u'sitecheck2.opera.com', u'sites']),
u'size': (u'size', [u'size']),
u'skin': (u'skin', [u'skin', u'skin.ini', u'skinning']),
u'skin.ini': (u'skin.ini', [u'skin.ini']),
u'skinning': (u'skinning', [u'skinning']),
u'skip': (u'skip', [u'skip', u'skipped']),
u'skipped': (u'skipped', [u'skipped']),
u'slash': (u'slash', [u'slash']),
u'sleek': (u'sleek', [u'sleek']),
u'slow': (u'slow', [u'slow']),
u'small': (u'small', [u'small', u'small-screen', u'smaller', u'smallest']),
u'small-screen': (u'small', [u'small', u'small-screen', u'smaller', u'smallest']),
u'smaller': (u'small', [u'small', u'small-screen', u'smaller', u'smallest']),
u'smallest': (u'small', [u'small', u'small-screen', u'smaller', u'smallest']),
u'smart-printing': (u'smart-printing', [u'smart-printing']),
u'smiley': (u'smiley', [u'smiley', u'smileys']),
u'smileys': (u'smiley', [u'smiley', u'smileys']),
u'smooth': (u'smooth', [u'smooth']),
u'sms': (u'sms', [u'sms']),
u'smtp': (u'smtp', [u'smtp']),
u'snaps': (u'snaps', [u'snaps']),
u'snip': (u'snip', [u'snip']),
u'snow': (u'snow', [u'snow']),
u'so': (u'so', [u'so', u'social', u'socialize', u'socket', u'sockets', u'socks', u'soft', u'software', u'some', u'somebody', u'someone', u'something', u'soon', u'sorry', u'sort', u'sorted', u'sorting', u'sound', u'sounds', u'source', u'sources', u'south', u'southern']),
u'social': (u'social', [u'social', u'socialize']),
u'socialize': (u'social', [u'social', u'socialize']),
u'socket': (u'socket', [u'socket', u'sockets']),
u'sockets': (u'socket', [u'socket', u'sockets']),
u'socks': (u'socks', [u'socks']),
u'soft': (u'soft', [u'soft', u'software']),
u'software': (u'software', [u'software']),
u'some': (u'some', [u'some', u'somebody', u'someone', u'something']),
u'somebody': (u'somebody', [u'somebody']),
u'someone': (u'someone', [u'someone']),
u'something': (u'something', [u'something']),
u'soon': (u'soon', [u'soon']),
u'sorry': (u'sorry', [u'sorry']),
u'sort': (u'sort', [u'sort', u'sorted', u'sorting']),
u'sorted': (u'sort', [u'sort', u'sorted', u'sorting']),
u'sorting': (u'sort', [u'sort', u'sorted', u'sorting']),
u'sound': (u'sound', [u'sound', u'sounds']),
u'sounds': (u'sound', [u'sound', u'sounds']),
u'source': (u'source', [u'source', u'sources']),
u'sources': (u'source', [u'source', u'sources']),
u'south': (u'south', [u'south', u'southern']),
u'southern': (u'southern', [u'southern']),
u'space': (u'spac', [u'space', u'spacer', u'spacers', u'spaces']),
u'spacer': (u'spac', [u'space', u'spacer', u'spacers', u'spaces']),
u'spacers': (u'spac', [u'space', u'spacer', u'spacers', u'spaces']),
u'spaces': (u'spac', [u'space', u'spacer', u'spacers', u'spaces']),
u'spam': (u'spam', [u'spam']),
u'spanish': (u'spanish', [u'spanish']),
u'speak': (u'speak', [u'speak', u'speaking']),
u'speaking': (u'speak', [u'speak', u'speaking']),
u'special': (u'special', [u'special']),
u'specific': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'specification': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'specified': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'specifies': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'specify': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'specifying': (u'specif', [u'specific', u'specification', u'specified', u'specifies', u'specify', u'specifying']),
u'spectral': (u'spectral', [u'spectral']),
u'speech': (u'speech', [u'speech']),
u'speed': (u'speed', [u'speed', u'speeddial', u'speeds', u'speedy']),
u'speeddial': (u'speed', [u'speed', u'speeddial', u'speeds', u'speedy']),
u'speeds': (u'speed', [u'speed', u'speeddial', u'speeds', u'speedy']),
u'speedy': (u'speed', [u'speed', u'speeddial', u'speeds', u'speedy']),
u'spell': (u'spell', [u'spell', u'spell-checker', u'spelled', u'spelling']),
u'spell-checker': (u'spell', [u'spell', u'spell-checker', u'spelled', u'spelling']),
u'spelled': (u'spell', [u'spell', u'spell-checker', u'spelled', u'spelling']),
u'spelling': (u'spell', [u'spell', u'spell-checker', u'spelled', u'spelling']),
u'spent': (u'spent', [u'spent']),
u'split': (u'split', [u'split']),
u'sports': (u'sports', [u'sports']),
u'spot': (u'spot', [u'spot']),
u'ssid': (u'ssid', [u'ssid']),
u'ssl': (u'ssl', [u'ssl']),
u'stack': (u'stack', [u'stack']),
u'stage': (u'stage', [u'stage']),
u'stand-alone': (u'stand-alone', [u'stand-alone']),
u'standalone': (u'standalone', [u'standalone']),
u'standard': (u'standard', [u'standard', u'standards']),
u'standards': (u'standard', [u'standard', u'standards']),
u'star': (u'star', [u'star', u'starred', u'stars', u'start', u'started', u'starting', u'starts', u'startup']),
u'starred': (u'star', [u'star', u'starred', u'stars', u'start', u'started', u'starting', u'starts', u'startup']),
u'stars': (u'star', [u'star', u'starred', u'stars', u'start', u'started', u'starting', u'starts', u'startup']),
u'start': (u'start', [u'start', u'started', u'starting', u'starts', u'startup']),
u'started': (u'start', [u'start', u'started', u'starting', u'starts', u'startup']),
u'starting': (u'start', [u'start', u'started', u'starting', u'starts', u'startup']),
u'starts': (u'start', [u'start', u'started', u'starting', u'starts', u'startup']),
u'startup': (u'start', [u'start', u'started', u'starting', u'starts', u'startup']),
u'state': (u'stat', [u'state', u'statement', u'statically', u'statistics', u'status']),
u'statement': (u'state', [u'state', u'statement']),
u'statically': (u'stat', [u'state', u'statement', u'statically', u'statistics', u'status']),
u'statistics': (u'stat', [u'state', u'statement', u'statically', u'statistics', u'status']),
u'status': (u'stat', [u'state', u'statement', u'statically', u'statistics', u'status']),
u'stay': (u'stay', [u'stay']),
u'stdin': (u'stdin', [u'stdin']),
u'step': (u'step', [u'step', u'steps']),
u'steps': (u'step', [u'step', u'steps']),
u'stick': (u'stick', [u'stick']),
u'still': (u'still', [u'still']),
u'stop': (u'stop', [u'stop', u'stopped', u'stopping']),
u'stopped': (u'stopp', [u'stopped', u'stopping']),
u'stopping': (u'stopp', [u'stopped', u'stopping']),
u'storage': (u'stor', [u'storage', u'store', u'stored', u'stores', u'storing']),
u'store': (u'stor', [u'storage', u'store', u'stored', u'stores', u'storing']),
u'stored': (u'stor', [u'storage', u'store', u'stored', u'stores', u'storing']),
u'stores': (u'stor', [u'storage', u'store', u'stored', u'stores', u'storing']),
u'storing': (u'stor', [u'storage', u'store', u'stored', u'stores', u'storing']),
u'stream': (u'stream', [u'stream']),
u'street': (u'street', [u'street']),
u'strength': (u'strength', [u'strength']),
u'stretch': (u'stretch', [u'stretch']),
u'strike': (u'strike', [u'strike', u'strikeout', u'strikethrough']),
u'strikeout': (u'strikeout', [u'strikeout']),
u'strikethrough': (u'strikethrough', [u'strikethrough']),
u'string': (u'string', [u'string', u'strings']),
u'strings': (u'string', [u'string', u'strings']),
u'stripped': (u'stripped', [u'stripped']),
u'strong': (u'strong', [u'strong', u'strongest', u'strongly']),
u'strongest': (u'strong', [u'strong', u'strongest', u'strongly']),
u'strongly': (u'strong', [u'strong', u'strongest', u'strongly']),
u'structural': (u'structural', [u'structural']),
u'structure': (u'structure', [u'structure']),
u'style': (u'styl', [u'style', u'styles', u'stylesheet', u'stylesheets', u'styling']),
u'styles': (u'styl', [u'style', u'styles', u'stylesheet', u'stylesheets', u'styling']),
u'stylesheet': (u'styl', [u'style', u'styles', u'stylesheet', u'stylesheets', u'styling']),
u'stylesheets': (u'stylesheet', [u'stylesheet', u'stylesheets']),
u'styling': (u'styl', [u'style', u'styles', u'stylesheet', u'stylesheets', u'styling']),
u'sub-messages': (u'sub-messages', [u'sub-messages']),
u'subfolder': (u'subfolder', [u'subfolder', u'subfolders']),
u'subfolders': (u'subfolder', [u'subfolder', u'subfolders']),
u'subject': (u'subject', [u'subject']),
u'submission': (u'submission', [u'submission']),
u'submit': (u'submit', [u'submit', u'submitted', u'submitting']),
u'submitted': (u'submitt', [u'submitted', u'submitting']),
u'submitting': (u'submitt', [u'submitted', u'submitting']),
u'subscribe': (u'subscrib', [u'subscribe', u'subscribed', u'subscribing']),
u'subscribed': (u'subscrib', [u'subscribe', u'subscribed', u'subscribing']),
u'subscribing': (u'subscrib', [u'subscribe', u'subscribed', u'subscribing']),
u'subscript': (u'subscript', [u'subscript', u'subscription']),
u'subscription': (u'subscript', [u'subscript', u'subscription']),
u'subtree': (u'subtree', [u'subtree']),
u'subviews': (u'subviews', [u'subviews']),
u'succeed': (u'succeed', [u'succeed', u'succeeded']),
u'succeeded': (u'succeed', [u'succeed', u'succeeded']),
u'success': (u'success', [u'success', u'successful', u'successfully']),
u'successful': (u'successful', [u'successful', u'successfully']),
u'successfully': (u'successful', [u'successful', u'successfully']),
u'such': (u'such', [u'such']),
u'sufficient': (u'sufficient', [u'sufficient', u'sufficiently']),
u'sufficiently': (u'sufficient', [u'sufficient', u'sufficiently']),
u'suffix': (u'suffix', [u'suffix', u'suffixes']),
u'suffixes': (u'suffix', [u'suffix', u'suffixes']),
u'suggested': (u'suggest', [u'suggested', u'suggestion', u'suggestions']),
u'suggestion': (u'suggest', [u'suggested', u'suggestion', u'suggestions']),
u'suggestions': (u'suggest', [u'suggested', u'suggestion', u'suggestions']),
u'suitable': (u'suitable', [u'suitable']),
u'summary': (u'summary', [u'summary']),
u'sun': (u'sun', [u'sun', u'sunday']),
u'sunday': (u'sunday', [u'sunday']),
u'super': (u'super', [u'super', u'superscript']),
u'superscript': (u'superscript', [u'superscript']),
u'supplement': (u'supplement', [u'supplement']),
u'supplied': (u'supplied', [u'supplied']),
u'support': (u'support', [u'support', u'supported', u'supports']),
u'supported': (u'support', [u'support', u'supported', u'supports']),
u'supports': (u'support', [u'support', u'supported', u'supports']),
u'supposed': (u'supposed', [u'supposed']),
u'suppressed': (u'suppressed', [u'suppressed']),
u'sure': (u'sure', [u'sure']),
u'surf': (u'surf', [u'surf', u'surfing']),
u'surfing': (u'surf', [u'surf', u'surfing']),
u'surprised': (u'surprised', [u'surprised']),
u'suspected': (u'suspected', [u'suspected']),
u'suspend': (u'suspend', [u'suspend', u'suspended']),
u'suspended': (u'suspend', [u'suspend', u'suspended']),
u'svg': (u'svg', [u'svg', u'svgz']),
u'svgz': (u'svgz', [u'svgz']),
u'switch': (u'switch', [u'switch', u'switches', u'switching']),
u'switches': (u'switch', [u'switch', u'switches', u'switching']),
u'switching': (u'switch', [u'switch', u'switches', u'switching']),
u'syllabic': (u'syllabic', [u'syllabic']),
u'symbol': (u'symbol', [u'symbol', u'symbols']),
u'symbols': (u'symbol', [u'symbol', u'symbols']),
u'symlink': (u'symlink', [u'symlink']),
u'sync': (u'sync', [u'sync', u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing', u'synchronous']),
u'synchronization': (u'synchroniz', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing']),
u'synchronize': (u'synchroniz', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing']),
u'synchronized': (u'synchroniz', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing']),
u'synchronizes': (u'synchroniz', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing']),
u'synchronizing': (u'synchroniz', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing']),
u'synchronous': (u'synchron', [u'synchronization', u'synchronize', u'synchronized', u'synchronizes', u'synchronizing', u'synchronous']),
u'syntax': (u'syntax', [u'syntax']),
u'syriac': (u'syriac', [u'syriac']),
u'system': (u'system', [u'system', u'systems']),
u'systems': (u'system', [u'system', u'systems']),
u't': (u't', [u't', u't-mobile', u'tab', u'tabbed', u'table', u'tables', u'tabloid', u'tabs', u'tag', u'tags', u'tahomabold10', u'tahomawhite8', u'tahomawhitebold10', u'take', u'taken', u'takes', u'talk', u'talking', u'taller', u'tamil', u'tap', u'target', u'targeted', u'targets', u'tariff', u'tariffs', u'task', u'taskbar', u'tb', u'team', u'technical', u'technology', u'telephone', u'telephony', u'tell', u'telnet', u'telugu', u'temporarily', u'temporary', u'term', u'terminal', u'terminals', u'terminated', u'terms', u'test', u'tested', u'testing', u'text', u'text-only', u'text-to-speech', u'textbox', u'textures', u'thaana', u'thai', u'than', u'thank', u'thanks', u'that', u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they', u'think', u'third', u'third-party', u'this', u'those', u'thread', u'threaded', u'threading', u'threads', u'three', u'through', u'thrown', u'thu', u'thumbnail', u'thumbnails', u'thunderbird', u'thursday', u'tibetan', u'tile', u'time', u'timed', u'timeout', u'times', u'tint', u'tinyline', u'tired', u'tis-620', u'title', u'titles', u'tls', u'tn3270', u'to', u'today', u'together', u'toggle', u'token', u'tomorrow', u'too', u'toolbar', u'toolbars', u'tools', u'tooltip', u'tooltips', u'top', u'top-right', u'topic', u'topics', u'torrent', u'torrents', u'tos', u'total', u'touching', u'touchscreen', u'trace', u'track', u'tracked', u'tracker', u'tracking', u'trackwheel', u'traditional', u'traffic', u'trail', u'transaction', u'transactions', u'transcoder', u'transferred', u'transfers', u'transformations', u'translate', u'translations', u'transmission', u'transmitted', u'transport', u'trash', u'travel', u'tray', u'treat', u'treaties', u'tree', u'trial', u'trick', u'tried', u'trust', u'trusted', u'trustworthy', u'try', u'trying', u'tue', u'tuesday', u'turbo', u'turkish', u'turn', u'turned', u'turning', u'tutorial', u'tv', u'tweet', u'twenty', u'twice', u'two', u'two-word', u'txt', u'type', u'typed', u'typed-in', u'types', u'typical']),
u't-mobile': (u't-mobile', [u't-mobile']),
u'tab': (u'tab', [u'tab', u'tabbed', u'table', u'tables', u'tabloid', u'tabs']),
u'tabbed': (u'tab', [u'tab', u'tabbed', u'table', u'tables', u'tabloid', u'tabs']),
u'table': (u'table', [u'table', u'tables']),
u'tables': (u'table', [u'table', u'tables']),
u'tabloid': (u'tabl', [u'table', u'tables', u'tabloid']),
u'tabs': (u'tab', [u'tab', u'tabbed', u'table', u'tables', u'tabloid', u'tabs']),
u'tag': (u'tag', [u'tag', u'tags']),
u'tags': (u'tag', [u'tag', u'tags']),
u'tahomabold10': (u'tahomabold10', [u'tahomabold10']),
u'tahomawhite8': (u'tahomawhite8', [u'tahomawhite8']),
u'tahomawhitebold10': (u'tahomawhitebold10', [u'tahomawhitebold10']),
u'take': (u'take', [u'take', u'taken', u'takes']),
u'taken': (u'take', [u'take', u'taken', u'takes']),
u'takes': (u'take', [u'take', u'taken', u'takes']),
u'talk': (u'talk', [u'talk', u'talking']),
u'talking': (u'talk', [u'talk', u'talking']),
u'taller': (u'taller', [u'taller']),
u'tamil': (u'tamil', [u'tamil']),
u'tap': (u'tap', [u'tap']),
u'target': (u'target', [u'target', u'targeted', u'targets']),
u'targeted': (u'target', [u'target', u'targeted', u'targets']),
u'targets': (u'target', [u'target', u'targeted', u'targets']),
u'tariff': (u'tariff', [u'tariff', u'tariffs']),
u'tariffs': (u'tariff', [u'tariff', u'tariffs']),
u'task': (u'task', [u'task', u'taskbar']),
u'taskbar': (u'taskbar', [u'taskbar']),
u'tb': (u'tb', [u'tb']),
u'team': (u'team', [u'team']),
u'technical': (u'technical', [u'technical']),
u'technology': (u'technology', [u'technology']),
u'telephone': (u'telephone', [u'telephone']),
u'telephony': (u'telephony', [u'telephony']),
u'tell': (u'tell', [u'tell']),
u'telnet': (u'telnet', [u'telnet']),
u'telugu': (u'telugu', [u'telugu']),
u'temporarily': (u'temporarily', [u'temporarily']),
u'temporary': (u'temporary', [u'temporary']),
u'term': (u'term', [u'term', u'terminal', u'terminals', u'terminated', u'terms']),
u'terminal': (u'terminal', [u'terminal', u'terminals']),
u'terminals': (u'terminal', [u'terminal', u'terminals']),
u'terminated': (u'term', [u'term', u'terminal', u'terminals', u'terminated', u'terms']),
u'terms': (u'term', [u'term', u'terminal', u'terminals', u'terminated', u'terms']),
u'test': (u'test', [u'test', u'tested', u'testing']),
u'tested': (u'test', [u'test', u'tested', u'testing']),
u'testing': (u'test', [u'test', u'tested', u'testing']),
u'text': (u'text', [u'text', u'text-only', u'text-to-speech', u'textbox', u'textures']),
u'text-only': (u'text-only', [u'text-only']),
u'text-to-speech': (u'text-to-speech', [u'text-to-speech']),
u'textbox': (u'textbox', [u'textbox']),
u'textures': (u'textures', [u'textures']),
u'thaana': (u'thaana', [u'thaana']),
u'thai': (u'thai', [u'thai']),
u'than': (u'than', [u'than', u'thank', u'thanks']),
u'thank': (u'thank', [u'thank', u'thanks']),
u'thanks': (u'thank', [u'thank', u'thanks']),
u'that': (u'that', [u'that']),
u'the': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'theft': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'their': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'them': (u'them', [u'them', u'theme', u'themes']),
u'theme': (u'theme', [u'theme', u'themes']),
u'themes': (u'theme', [u'theme', u'themes']),
u'then': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'there': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'therefore': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'these': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'they': (u'the', [u'the', u'theft', u'their', u'them', u'theme', u'themes', u'then', u'there', u'therefore', u'these', u'they']),
u'think': (u'think', [u'think']),
u'third': (u'third', [u'third', u'third-party']),
u'third-party': (u'third-party', [u'third-party']),
u'this': (u'this', [u'this']),
u'those': (u'those', [u'those']),
u'thread': (u'thread', [u'thread', u'threaded', u'threading', u'threads']),
u'threaded': (u'thread', [u'thread', u'threaded', u'threading', u'threads']),
u'threading': (u'thread', [u'thread', u'threaded', u'threading', u'threads']),
u'threads': (u'thread', [u'thread', u'threaded', u'threading', u'threads']),
u'three': (u'three', [u'three']),
u'through': (u'through', [u'through']),
u'thrown': (u'thrown', [u'thrown']),
u'thu': (u'thu', [u'thu', u'thumbnail', u'thumbnails', u'thunderbird', u'thursday']),
u'thumbnail': (u'thumbnail', [u'thumbnail', u'thumbnails']),
u'thumbnails': (u'thumbnail', [u'thumbnail', u'thumbnails']),
u'thunderbird': (u'thunderbird', [u'thunderbird']),
u'thursday': (u'thursday', [u'thursday']),
u'tibetan': (u'tibetan', [u'tibetan']),
u'tile': (u'tile', [u'tile']),
u'time': (u'tim', [u'time', u'timed', u'timeout', u'times']),
u'timed': (u'tim', [u'time', u'timed', u'timeout', u'times']),
u'timeout': (u'tim', [u'time', u'timed', u'timeout', u'times']),
u'times': (u'tim', [u'time', u'timed', u'timeout', u'times']),
u'tint': (u'tint', [u'tint']),
u'tinyline': (u'tinyline', [u'tinyline']),
u'tired': (u'tired', [u'tired']),
u'tis-620': (u'tis-620', [u'tis-620']),
u'title': (u'title', [u'title', u'titles']),
u'titles': (u'title', [u'title', u'titles']),
u'tls': (u'tls', [u'tls']),
u'tn3270': (u'tn3270', [u'tn3270']),
u'to': (u'to', [u'to', u'today', u'together', u'toggle', u'token', u'tomorrow', u'too', u'toolbar', u'toolbars', u'tools', u'tooltip', u'tooltips', u'top', u'top-right', u'topic', u'topics', u'torrent', u'torrents', u'tos', u'total', u'touching', u'touchscreen']),
u'today': (u'today', [u'today']),
u'together': (u'together', [u'together']),
u'toggle': (u'toggle', [u'toggle']),
u'token': (u'token', [u'token']),
u'tomorrow': (u'tomorrow', [u'tomorrow']),
u'too': (u'too', [u'too', u'toolbar', u'toolbars', u'tools', u'tooltip', u'tooltips']),
u'toolbar': (u'toolbar', [u'toolbar', u'toolbars']),
u'toolbars': (u'toolbar', [u'toolbar', u'toolbars']),
u'tools': (u'tools', [u'tools']),
u'tooltip': (u'tooltip', [u'tooltip', u'tooltips']),
u'tooltips': (u'tooltip', [u'tooltip', u'tooltips']),
u'top': (u'top', [u'top', u'top-right', u'topic', u'topics']),
u'top-right': (u'top-right', [u'top-right']),
u'topic': (u'topic', [u'topic', u'topics']),
u'topics': (u'topic', [u'topic', u'topics']),
u'torrent': (u'torrent', [u'torrent', u'torrents']),
u'torrents': (u'torrent', [u'torrent', u'torrents']),
u'tos': (u'tos', [u'tos']),
u'total': (u'total', [u'total']),
u'touching': (u'touching', [u'touching']),
u'touchscreen': (u'touchscreen', [u'touchscreen']),
u'trace': (u'trace', [u'trace']),
u'track': (u'track', [u'track', u'tracked', u'tracker', u'tracking', u'trackwheel']),
u'tracked': (u'track', [u'track', u'tracked', u'tracker', u'tracking', u'trackwheel']),
u'tracker': (u'track', [u'track', u'tracked', u'tracker', u'tracking', u'trackwheel']),
u'tracking': (u'track', [u'track', u'tracked', u'tracker', u'tracking', u'trackwheel']),
u'trackwheel': (u'track', [u'track', u'tracked', u'tracker', u'tracking', u'trackwheel']),
u'traditional': (u'traditional', [u'traditional']),
u'traffic': (u'traffic', [u'traffic']),
u'trail': (u'trail', [u'trail']),
u'transaction': (u'transaction', [u'transaction', u'transactions']),
u'transactions': (u'transaction', [u'transaction', u'transactions']),
u'transcoder': (u'transcoder', [u'transcoder']),
u'transferred': (u'transferred', [u'transferred']),
u'transfers': (u'transfers', [u'transfers']),
u'transformations': (u'transformations', [u'transformations']),
u'translate': (u'translat', [u'translate', u'translations']),
u'translations': (u'translat', [u'translate', u'translations']),
u'transmission': (u'transmission', [u'transmission']),
u'transmitted': (u'transmitted', [u'transmitted']),
u'transport': (u'transport', [u'transport']),
u'trash': (u'trash', [u'trash']),
u'travel': (u'travel', [u'travel']),
u'tray': (u'tray', [u'tray']),
u'treat': (u'treat', [u'treat', u'treaties']),
u'treaties': (u'treaties', [u'treaties']),
u'tree': (u'tree', [u'tree']),
u'trial': (u'trial', [u'trial']),
u'trick': (u'trick', [u'trick']),
u'tried': (u'tried', [u'tried']),
u'trust': (u'trust', [u'trust', u'trusted', u'trustworthy']),
u'trusted': (u'trust', [u'trust', u'trusted', u'trustworthy']),
u'trustworthy': (u'trust', [u'trust', u'trusted', u'trustworthy']),
u'try': (u'try', [u'try', u'trying']),
u'trying': (u'try', [u'try', u'trying']),
u'tue': (u'tue', [u'tue', u'tuesday']),
u'tuesday': (u'tuesday', [u'tuesday']),
u'turbo': (u'turbo', [u'turbo']),
u'turkish': (u'turkish', [u'turkish']),
u'turn': (u'turn', [u'turn', u'turned', u'turning']),
u'turned': (u'turn', [u'turn', u'turned', u'turning']),
u'turning': (u'turn', [u'turn', u'turned', u'turning']),
u'tutorial': (u'tutorial', [u'tutorial']),
u'tv': (u'tv', [u'tv']),
u'tweet': (u'tweet', [u'tweet']),
u'twenty': (u'twenty', [u'twenty']),
u'twice': (u'twice', [u'twice']),
u'two': (u'two', [u'two', u'two-word']),
u'two-word': (u'two-word', [u'two-word']),
u'txt': (u'txt', [u'txt']),
u'type': (u'typ', [u'type', u'typed', u'typed-in', u'types', u'typical']),
u'typed': (u'typ', [u'type', u'typed', u'typed-in', u'types', u'typical']),
u'typed-in': (u'typ', [u'type', u'typed', u'typed-in', u'types', u'typical']),
u'types': (u'typ', [u'type', u'typed', u'typed-in', u'types', u'typical']),
u'typical': (u'typ', [u'type', u'typed', u'typed-in', u'types', u'typical']),
u'ua': (u'ua', [u'ua']),
u'ue': (u'ue', [u'ue']),
u'uidl': (u'uidl', [u'uidl']),
u'ulimit': (u'ulimit', [u'ulimit']),
u'um': (u'um', [u'um']),
u'unable': (u'unable', [u'unable']),
u'unassign': (u'unassign', [u'unassign', u'unassigned']),
u'unassigned': (u'unassign', [u'unassign', u'unassigned']),
u'unauthorized': (u'unauthorized', [u'unauthorized']),
u'unavailable': (u'unavailable', [u'unavailable']),
u'unblocking': (u'unblocking', [u'unblocking']),
u'unchanged': (u'unchanged', [u'unchanged']),
u'uncheck': (u'uncheck', [u'uncheck']),
u'unclosed': (u'unclosed', [u'unclosed']),
u'undefined': (u'undefined', [u'undefined']),
u'undelete': (u'undelet', [u'undelete', u'undeleted']),
u'undeleted': (u'undelet', [u'undelete', u'undeleted']),
u'under': (u'under', [u'under', u'underline', u'undernet', u'understand']),
u'underline': (u'underline', [u'underline']),
u'undernet': (u'undernet', [u'undernet']),
u'understand': (u'understand', [u'understand']),
u'undo': (u'undo', [u'undo', u'undock']),
u'undock': (u'undock', [u'undock']),
u'unencrypted': (u'unencrypted', [u'unencrypted']),
u'uneven': (u'uneven', [u'uneven']),
u'unexpected': (u'unexpected', [u'unexpected', u'unexpectedly']),
u'unexpectedly': (u'unexpected', [u'unexpected', u'unexpectedly']),
u'unfeature': (u'unfeature', [u'unfeature']),
u'unflagged': (u'unflagged', [u'unflagged']),
u'unfortunately': (u'unfortunately', [u'unfortunately']),
u'unhandled': (u'unhandled', [u'unhandled']),
u'unhappy': (u'unhappy', [u'unhappy']),
u'unicode': (u'unicode', [u'unicode']),
u'unified': (u'unified', [u'unified']),
u'uninstall': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'uninstallation': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'uninstalled': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'uninstaller': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'uninstalling': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'uninstalls': (u'uninstall', [u'uninstall', u'uninstallation', u'uninstalled', u'uninstaller', u'uninstalling', u'uninstalls']),
u'unique': (u'unique', [u'unique', u'uniquely']),
u'uniquely': (u'unique', [u'unique', u'uniquely']),
u'unit': (u'unit', [u'unit', u'unite', u'unite.opera.com']),
u'unite': (u'unite', [u'unite', u'unite.opera.com']),
u'unite.opera.com': (u'unite.opera.com', [u'unite.opera.com']),
u'unknown': (u'unknown', [u'unknown']),
u'unless': (u'unless', [u'unless']),
u'unlimited': (u'unlimited', [u'unlimited']),
u'unlocked': (u'unlocked', [u'unlocked']),
u'unmark': (u'unmark', [u'unmark']),
u'unmute': (u'unmute', [u'unmute']),
u'unnamed': (u'unnamed', [u'unnamed']),
u'unordered': (u'unordered', [u'unordered']),
u'unpack': (u'unpack', [u'unpack']),
u'unpin': (u'unpin', [u'unpin', u'unpinned']),
u'unpinned': (u'unpinned', [u'unpinned']),
u'unquote': (u'unquote', [u'unquote']),
u'unread': (u'unread', [u'unread']),
u'unrecognized': (u'unrecognized', [u'unrecognized']),
u'unrecommend': (u'unrecommend', [u'unrecommend']),
u'unreferenced': (u'unreferenced', [u'unreferenced']),
u'unregistered': (u'unregistered', [u'unregistered']),
u'unreliable': (u'unreliable', [u'unreliable']),
u'unrestricted': (u'unrestricted', [u'unrestricted']),
u'unsaved': (u'unsaved', [u'unsaved']),
u'unsorted': (u'unsorted', [u'unsorted']),
u'unspecified': (u'unspecified', [u'unspecified']),
u'unstable': (u'unstable', [u'unstable']),
u'unstack': (u'unstack', [u'unstack']),
u'unsubscribe': (u'unsubscrib', [u'unsubscribe', u'unsubscribed', u'unsubscribing']),
u'unsubscribed': (u'unsubscrib', [u'unsubscribe', u'unsubscribed', u'unsubscribing']),
u'unsubscribing': (u'unsubscrib', [u'unsubscribe', u'unsubscribed', u'unsubscribing']),
u'unsuccessful': (u'unsuccessful', [u'unsuccessful']),
u'unsuited': (u'unsuited', [u'unsuited']),
u'unsupported': (u'unsupported', [u'unsupported']),
u'unsure': (u'unsure', [u'unsure']),
u'until': (u'until', [u'until']),
u'untitled': (u'untitled', [u'untitled']),
u'unusable': (u'unus', [u'unusable', u'unused']),
u'unused': (u'unus', [u'unusable', u'unused']),
u'unviewed': (u'unviewed', [u'unviewed']),
u'unwanted': (u'unwanted', [u'unwanted']),
u'up': (u'up', [u'up', u'up-to-date', u'update', u'updated', u'updates', u'updating', u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading', u'upload', u'uploaded', u'uploading', u'uploads', u'upnp', u'upper']),
u'up-to-date': (u'up-to-date', [u'up-to-date']),
u'update': (u'updat', [u'update', u'updated', u'updates', u'updating']),
u'updated': (u'updat', [u'update', u'updated', u'updates', u'updating']),
u'updates': (u'updat', [u'update', u'updated', u'updates', u'updating']),
u'updating': (u'updat', [u'update', u'updated', u'updates', u'updating']),
u'upgrade': (u'upgrad', [u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading']),
u'upgrade.opera.com': (u'upgrad', [u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading']),
u'upgraded': (u'upgrad', [u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading']),
u'upgrades': (u'upgrad', [u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading']),
u'upgrading': (u'upgrad', [u'upgrade', u'upgrade.opera.com', u'upgraded', u'upgrades', u'upgrading']),
u'upload': (u'upload', [u'upload', u'uploaded', u'uploading', u'uploads']),
u'uploaded': (u'upload', [u'upload', u'uploaded', u'uploading', u'uploads']),
u'uploading': (u'upload', [u'upload', u'uploaded', u'uploading', u'uploads']),
u'uploads': (u'upload', [u'upload', u'uploaded', u'uploading', u'uploads']),
u'upnp': (u'upnp', [u'upnp']),
u'upper': (u'upper', [u'upper']),
u'url': (u'url', [u'url', u'urls']),
u'urls': (u'url', [u'url', u'urls']),
u'us': (u'us', [u'us', u'usage', u'usb', u'use', u'used', u'useful', u'usenet-message', u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users', u'uses', u'using', u'usr', u'usual']),
u'usage': (u'usage', [u'usage']),
u'usb': (u'usb', [u'usb']),
u'use': (u'use', [u'use', u'used', u'useful', u'usenet-message', u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users', u'uses']),
u'used': (u'use', [u'use', u'used', u'useful', u'usenet-message', u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users', u'uses']),
u'useful': (u'use', [u'use', u'used', u'useful', u'usenet-message', u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users', u'uses']),
u'usenet-message': (u'usenet-message', [u'usenet-message']),
u'user': (u'user', [u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users']),
u'user-agent': (u'user', [u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users']),
u'user-confirmation': (u'user-confirmation', [u'user-confirmation']),
u'user-defined': (u'user', [u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users']),
u'username': (u'username', [u'username', u'usernames']),
u'usernames': (u'username', [u'username', u'usernames']),
u'users': (u'user', [u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users']),
u'uses': (u'use', [u'use', u'used', u'useful', u'usenet-message', u'user', u'user-agent', u'user-confirmation', u'user-defined', u'username', u'usernames', u'users', u'uses']),
u'using': (u'using', [u'using']),
u'usr': (u'usr', [u'usr']),
u'usual': (u'usual', [u'usual']),
u'utc': (u'utc', [u'utc']),
u'utf-16': (u'utf-16', [u'utf-16']),
u'utf-32': (u'utf-32', [u'utf-32']),
u'utf-7': (u'utf-7', [u'utf-7']),
u'utf-8': (u'utf-8', [u'utf-8']),
u'utilities': (u'utilities', [u'utilities']),
u'uw': (u'uw', [u'uw']),
u'v': (u'v', [u'v', u'v2', u'val', u'valid', u'validate', u'validated', u'validating', u'validation', u'validator', u'valuable', u'value', u'values', u'variants', u'varies', u'vcard', u've', u'vega', u'vendor', u'verbose', u'verification', u'verified', u'verifies', u'verify', u'verifying', u'version', u'versions', u'vertex', u'vertical', u'vertically', u'very', u'via', u'vibration', u'video', u'videos', u'vietnamese', u'view', u'viewer', u'viewing', u'views', u'virtual', u'virus', u'viruses', u'viscii', u'visibility', u'visible', u'visit', u'visited', u'visiting', u'visitor', u'visits', u'visual', u'vodafone', u'voice', u'voice-controlled', u'voiced', u'voicexml', u'volume', u'volumes', u'vps', u'vulnerable']),
u'v2': (u'v2', [u'v2']),
u'val': (u'val', [u'val', u'valid', u'validate', u'validated', u'validating', u'validation', u'validator', u'valuable', u'value', u'values']),
u'valid': (u'valid', [u'valid', u'validate', u'validated', u'validating', u'validation', u'validator']),
u'validate': (u'validat', [u'validate', u'validated', u'validating', u'validation', u'validator']),
u'validated': (u'validat', [u'validate', u'validated', u'validating', u'validation', u'validator']),
u'validating': (u'validat', [u'validate', u'validated', u'validating', u'validation', u'validator']),
u'validation': (u'validat', [u'validate', u'validated', u'validating', u'validation', u'validator']),
u'validator': (u'validat', [u'validate', u'validated', u'validating', u'validation', u'validator']),
u'valuable': (u'valu', [u'valuable', u'value', u'values']),
u'value': (u'valu', [u'valuable', u'value', u'values']),
u'values': (u'valu', [u'valuable', u'value', u'values']),
u'variants': (u'variants', [u'variants']),
u'varies': (u'varies', [u'varies']),
u'vcard': (u'vcard', [u'vcard']),
u've': (u've', [u've', u'vega', u'vendor', u'verbose', u'verification', u'verified', u'verifies', u'verify', u'verifying', u'version', u'versions', u'vertex', u'vertical', u'vertically', u'very']),
u'vega': (u'vega', [u'vega']),
u'vendor': (u'vendor', [u'vendor']),
u'verbose': (u'verbose', [u'verbose']),
u'verification': (u'verif', [u'verification', u'verified', u'verifies', u'verify', u'verifying']),
u'verified': (u'verif', [u'verification', u'verified', u'verifies', u'verify', u'verifying']),
u'verifies': (u'verif', [u'verification', u'verified', u'verifies', u'verify', u'verifying']),
u'verify': (u'verif', [u'verification', u'verified', u'verifies', u'verify', u'verifying']),
u'verifying': (u'verif', [u'verification', u'verified', u'verifies', u'verify', u'verifying']),
u'version': (u'version', [u'version', u'versions']),
u'versions': (u'version', [u'version', u'versions']),
u'vertex': (u'vertex', [u'vertex']),
u'vertical': (u'vertical', [u'vertical', u'vertically']),
u'vertically': (u'vertical', [u'vertical', u'vertically']),
u'very': (u'very', [u'very']),
u'via': (u'via', [u'via']),
u'vibration': (u'vibration', [u'vibration']),
u'video': (u'video', [u'video', u'videos']),
u'videos': (u'video', [u'video', u'videos']),
u'vietnamese': (u'vietnamese', [u'vietnamese']),
u'view': (u'view', [u'view', u'viewer', u'viewing', u'views']),
u'viewer': (u'view', [u'view', u'viewer', u'viewing', u'views']),
u'viewing': (u'view', [u'view', u'viewer', u'viewing', u'views']),
u'views': (u'view', [u'view', u'viewer', u'viewing', u'views']),
u'virtual': (u'virtual', [u'virtual']),
u'virus': (u'virus', [u'virus', u'viruses']),
u'viruses': (u'virus', [u'virus', u'viruses']),
u'viscii': (u'viscii', [u'viscii']),
u'visibility': (u'vis', [u'viscii', u'visibility', u'visible', u'visit', u'visited', u'visiting', u'visitor', u'visits', u'visual']),
u'visible': (u'vis', [u'viscii', u'visibility', u'visible', u'visit', u'visited', u'visiting', u'visitor', u'visits', u'visual']),
u'visit': (u'visit', [u'visit', u'visited', u'visiting', u'visitor', u'visits']),
u'visited': (u'visit', [u'visit', u'visited', u'visiting', u'visitor', u'visits']),
u'visiting': (u'visit', [u'visit', u'visited', u'visiting', u'visitor', u'visits']),
u'visitor': (u'visit', [u'visit', u'visited', u'visiting', u'visitor', u'visits']),
u'visits': (u'visit', [u'visit', u'visited', u'visiting', u'visitor', u'visits']),
u'visual': (u'visual', [u'visual']),
u'vodafone': (u'vodafone', [u'vodafone']),
u'voice': (u'voic', [u'voice', u'voice-controlled', u'voiced', u'voicexml']),
u'voice-controlled': (u'voic', [u'voice', u'voice-controlled', u'voiced', u'voicexml']),
u'voiced': (u'voic', [u'voice', u'voice-controlled', u'voiced', u'voicexml']),
u'voicexml': (u'voic', [u'voice', u'voice-controlled', u'voiced', u'voicexml']),
u'volume': (u'volume', [u'volume', u'volumes']),
u'volumes': (u'volume', [u'volume', u'volumes']),
u'vps': (u'vps', [u'vps']),
u'vulnerable': (u'vulnerable', [u'vulnerable']),
u'w': (u'w', [u'w', u'w3c', u'wais', u'wait', u'waiting', u'walk', u'wall', u'wallpaper', u'want', u'wants', u'wap', u'warn', u'warned', u'warning', u'warnings', u'warp', u'was', u'wasn', u'watch', u'watches', u'wav', u'wave', u'way', u'ways', u'we', u'weak', u'weather', u'web', u'weblog', u'webm', u'webmail', u'webmaster', u'webpage', u'webpages', u'webserver', u'website', u'websites', u'wed', u'wednesday', u'week', u'weeks', u'weight', u'welcome', u'well', u'well-formed', u'went', u'were', u'western', u'what', u'when', u'where', u'wherever', u'whether', u'which', u'while', u'white', u'whitespace', u'whiz', u'who', u'whole', u'why', u'wi-fi', u'wid', u'wide', u'wider', u'widescreen', u'widget', u'widgets', u'width', u'widths', u'wii', u'wii.com', u'wiiconnect24', u'will', u'willcom', u'willing', u'win', u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2', u'wininet.dll', u'winking', u'winsock', u'wise', u'wish', u'wishes', u'with', u'within', u'without', u'wizard', u'wml', u'wnload.com', u'word', u'work', u'working', u'works', u'worldwide', u'worry', u'worst', u'would', u'wrap', u'wrapper', u'wrapping', u'wraps', u'writable', u'write', u'write-only', u'writing', u'written', u'wrong', u'wrote', u'wsock32.dll', u'wtai', u'wtls', u'www.apache.org', u'www.opera.com', u'www.w3.org']),
u'w3c': (u'w3c', [u'w3c']),
u'wais': (u'wais', [u'wais']),
u'wait': (u'wait', [u'wait', u'waiting']),
u'waiting': (u'wait', [u'wait', u'waiting']),
u'walk': (u'walk', [u'walk']),
u'wall': (u'wall', [u'wall', u'wallpaper']),
u'wallpaper': (u'wallpaper', [u'wallpaper']),
u'want': (u'want', [u'want', u'wants']),
u'wants': (u'want', [u'want', u'wants']),
u'wap': (u'wap', [u'wap']),
u'warn': (u'warn', [u'warn', u'warned', u'warning', u'warnings']),
u'warned': (u'warn', [u'warn', u'warned', u'warning', u'warnings']),
u'warning': (u'warn', [u'warn', u'warned', u'warning', u'warnings']),
u'warnings': (u'warn', [u'warn', u'warned', u'warning', u'warnings']),
u'warp': (u'warp', [u'warp']),
u'was': (u'be-infinitive', [u'are', u'be', u'been', u'being', u'is', u'was']),
u'wasn': (u'wasn', [u'wasn']),
u'watch': (u'watch', [u'watch', u'watches']),
u'watches': (u'watch', [u'watch', u'watches']),
u'wav': (u'wav', [u'wav', u'wave']),
u'wave': (u'wave', [u'wave']),
u'way': (u'way', [u'way', u'ways']),
u'ways': (u'way', [u'way', u'ways']),
u'we': (u'we', [u'we', u'weak', u'weather', u'web', u'weblog', u'webm', u'webmail', u'webmaster', u'webpage', u'webpages', u'webserver', u'website', u'websites', u'wed', u'wednesday', u'week', u'weeks', u'weight', u'welcome', u'well', u'well-formed', u'went', u'were', u'western']),
u'weak': (u'weak', [u'weak']),
u'weather': (u'weather', [u'weather']),
u'web': (u'web', [u'web', u'weblog', u'webm', u'webmail', u'webmaster', u'webpage', u'webpages', u'webserver', u'website', u'websites']),
u'weblog': (u'weblog', [u'weblog']),
u'webm': (u'webm', [u'webm', u'webmail', u'webmaster']),
u'webmail': (u'webmail', [u'webmail']),
u'webmaster': (u'webmaster', [u'webmaster']),
u'webpage': (u'webpage', [u'webpage', u'webpages']),
u'webpages': (u'webpage', [u'webpage', u'webpages']),
u'webserver': (u'webserver', [u'webserver']),
u'website': (u'website', [u'website', u'websites']),
u'websites': (u'website', [u'website', u'websites']),
u'wed': (u'wed', [u'wed', u'wednesday']),
u'wednesday': (u'wednesday', [u'wednesday']),
u'week': (u'week', [u'week', u'weeks']),
u'weeks': (u'week', [u'week', u'weeks']),
u'weight': (u'weight', [u'weight']),
u'welcome': (u'welcome', [u'welcome']),
u'well': (u'well', [u'well', u'well-formed']),
u'well-formed': (u'well-formed', [u'well-formed']),
u'went': (u'went', [u'went']),
u'were': (u'were', [u'were']),
u'western': (u'western', [u'western']),
u'what': (u'what', [u'what']),
u'when': (u'when', [u'when']),
u'where': (u'where', [u'where', u'wherever']),
u'wherever': (u'wherever', [u'wherever']),
u'whether': (u'whether', [u'whether']),
u'which': (u'which', [u'which']),
u'while': (u'while', [u'while']),
u'white': (u'white', [u'white', u'whitespace']),
u'whitespace': (u'whitespace', [u'whitespace']),
u'whiz': (u'whiz', [u'whiz']),
u'who': (u'who', [u'who', u'whole']),
u'whole': (u'whole', [u'whole']),
u'why': (u'why', [u'why']),
u'wi-fi': (u'wi-fi', [u'wi-fi']),
u'wid': (u'wid', [u'wid', u'wide', u'wider', u'widescreen', u'widget', u'widgets', u'width', u'widths']),
u'wide': (u'wid', [u'wid', u'wide', u'wider', u'widescreen', u'widget', u'widgets', u'width', u'widths']),
u'wider': (u'wid', [u'wid', u'wide', u'wider', u'widescreen', u'widget', u'widgets', u'width', u'widths']),
u'widescreen': (u'wid', [u'wid', u'wide', u'wider', u'widescreen', u'widget', u'widgets', u'width', u'widths']),
u'widget': (u'widget', [u'widget', u'widgets']),
u'widgets': (u'widget', [u'widget', u'widgets']),
u'width': (u'width', [u'width', u'widths']),
u'widths': (u'width', [u'width', u'widths']),
u'wii': (u'wii', [u'wii', u'wii.com', u'wiiconnect24']),
u'wii.com': (u'wii.com', [u'wii.com']),
u'wiiconnect24': (u'wiiconnect24', [u'wiiconnect24']),
u'will': (u'will', [u'will', u'willcom', u'willing']),
u'willcom': (u'will', [u'will', u'willcom', u'willing']),
u'willing': (u'will', [u'will', u'willcom', u'willing']),
u'win': (u'win', [u'win', u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2', u'wininet.dll', u'winking', u'winsock']),
u'window': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windowed': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1250': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1251': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1252': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1253': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1254': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1255': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1256': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1257': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-1258': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'windows-sami-2': (u'window', [u'window', u'windowed', u'windows', u'windows-1250', u'windows-1251', u'windows-1252', u'windows-1253', u'windows-1254', u'windows-1255', u'windows-1256', u'windows-1257', u'windows-1258', u'windows-sami-2']),
u'wininet.dll': (u'wininet.dll', [u'wininet.dll']),
u'winking': (u'winking', [u'winking']),
u'winsock': (u'winsock', [u'winsock']),
u'wise': (u'wise', [u'wise']),
u'wish': (u'wish', [u'wish', u'wishes']),
u'wishes': (u'wish', [u'wish', u'wishes']),
u'with': (u'with', [u'with', u'within', u'without']),
u'within': (u'within', [u'within']),
u'without': (u'without', [u'without']),
u'wizard': (u'wizard', [u'wizard']),
u'wml': (u'wml', [u'wml']),
u'wnload.com': (u'wnload.com', [u'wnload.com']),
u'word': (u'word', [u'word']),
u'work': (u'work', [u'work', u'working', u'works']),
u'working': (u'work', [u'work', u'working', u'works']),
u'works': (u'work', [u'work', u'working', u'works']),
u'worldwide': (u'worldwide', [u'worldwide']),
u'worry': (u'worry', [u'worry']),
u'worst': (u'worst', [u'worst']),
u'would': (u'would', [u'would']),
u'wrap': (u'wrap', [u'wrap', u'wrapper', u'wrapping', u'wraps']),
u'wrapper': (u'wrapp', [u'wrapper', u'wrapping']),
u'wrapping': (u'wrapp', [u'wrapper', u'wrapping']),
u'wraps': (u'wrap', [u'wrap', u'wrapper', u'wrapping', u'wraps']),
u'writable': (u'writ', [u'writable', u'write', u'write-only', u'writing', u'written']),
u'write': (u'writ', [u'writable', u'write', u'write-only', u'writing', u'written']),
u'write-only': (u'writ', [u'writable', u'write', u'write-only', u'writing', u'written']),
u'writing': (u'writ', [u'writable', u'write', u'write-only', u'writing', u'written']),
u'written': (u'writ', [u'writable', u'write', u'write-only', u'writing', u'written']),
u'wrong': (u'wrong', [u'wrong']),
u'wrote': (u'wrote', [u'wrote']),
u'wsock32.dll': (u'wsock32.dll', [u'wsock32.dll']),
u'wtai': (u'wtai', [u'wtai']),
u'wtls': (u'wtls', [u'wtls']),
u'www.apache.org': (u'www.apache.org', [u'www.apache.org']),
u'www.opera.com': (u'www.opera.com', [u'www.opera.com']),
u'www.w3.org': (u'www.w3.org', [u'www.w3.org']),
u'x': (u'x', [u'x', u'x509', u'xbm', u'xhr', u'xhtml', u'ximize', u'xml', u'xmlhttprequests', u'xpath', u'xsl', u'xslt']),
u'x509': (u'x509', [u'x509']),
u'xbm': (u'xbm', [u'xbm']),
u'xhr': (u'xhr', [u'xhr']),
u'xhtml': (u'xhtml', [u'xhtml']),
u'ximize': (u'ximize', [u'ximize']),
u'xml': (u'xml', [u'xml', u'xmlhttprequests']),
u'xmlhttprequests': (u'xmlhttprequests', [u'xmlhttprequests']),
u'xpath': (u'xpath', [u'xpath']),
u'xsl': (u'xsl', [u'xsl', u'xslt']),
u'xslt': (u'xslt', [u'xslt']),
u'y': (u'y', [u'y', u'yahoo', u'year', u'years', u'yellow', u'yes', u'yesterday', u'yet', u'you', u'your', u'yours']),
u'yahoo': (u'yahoo', [u'yahoo']),
u'year': (u'year', [u'year', u'years']),
u'years': (u'year', [u'year', u'years']),
u'yellow': (u'yellow', [u'yellow']),
u'yes': (u'yes', [u'yes', u'yesterday']),
u'yesterday': (u'yesterday', [u'yesterday']),
u'yet': (u'yet', [u'yet']),
u'you': (u'you', [u'you', u'your', u'yours']),
u'your': (u'your', [u'your', u'yours']),
u'yours': (u'your', [u'your', u'yours']),
u'z': (u'z', [u'z', u'zero', u'zip', u'zipped', u'zon.com', u'zone', u'zoom', u'zooming']),
u'zero': (u'zero', [u'zero']),
u'zip': (u'zip', [u'zip', u'zipped']),
u'zipped': (u'zipped', [u'zipped']),
u'zon.com': (u'zon.com', [u'zon.com']),
u'zone': (u'zone', [u'zone']),
u'zoom': (u'zoom', [u'zoom', u'zooming']),
u'zooming': (u'zoom', [u'zoom', u'zooming']),
}
