/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 1995-2009 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */
#ifndef WEBSERVERSTATECHANGEGENERATOR_H
#define	WEBSERVERSTATECHANGEGENERATOR_H

#ifdef WIDGET_RUNTIME_SUPPORT
# ifdef WIDGET_RUNTIME_UNITE_SUPPORT

#include "modules/util/adt/oplisteners.h"
#include "modules/util/opstring.h"
#include "modules/webserver/webserver-api.h"

class WebServerStateListener;


/**
 * Implements the common functionality of WebServerStateListener event
 * notifiers.
 *
 * @author Wojciech Dzierzanowski (wdzierzanowski)
 * @see WebServerStateListener
 */
class WebServerStateGenerator
{
public:
	/**
	 * Subscribes a listener.  The listener will be notified of all the events
	 * generated by this instance.
	 *
	 * @param listener the listener to be subscribed
	 * @return status
	 */
	OP_STATUS AddWebServerStateListener(WebServerStateListener& listener);

protected:
	void NotifyLoggedIn();
	void NotifyWebServerSetUpCompleted(const OpStringC& shared_secret);
	void NotifyWebServerStarted();
	void NotifyWebServerStartUpError();
	void NotifyWebServerStopped();
	void NotifyWebServerError(
			WebserverStatus web_server_status = WEBSERVER_ERROR);

private:
	OpListeners<WebServerStateListener> m_listeners;
};

# endif // WIDGET_RUNTIME_UNITE_SUPPORT
#endif // WIDGET_RUNTIME_SUPPORT

#endif // WEBSERVERSTATECHANGEGENERATOR_H
