/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; c-file-style: "stroustrup" -*-
**
** Copyright (C) 2005 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
** THIS FILE IS AUTO-GENERATED BY A SCRIPT. DO NOT EDIT THIS FILE DIRECTLY!
*/

#include "core/pch.h"

#ifdef SVG_SUPPORT

#include "modules/svg/src/svgpch.h"
#include "modules/svg/src/SVGInternalEnum.h"
#include "modules/svg/src/SVGInternalEnumTables.h"
#include "modules/svg/src/SVGManagerImpl.h"

#include "modules/style/css_all_values.h"
#include "modules/display/cursor.h"

#ifdef _DEBUG
CONST_ARRAY(g_svg_enum_type_strings, char*)
	CONST_ENTRY("SVGENUM_UNKNOWN"),
	CONST_ENTRY("SVGENUM_SPREAD_METHOD_TYPE"),
	CONST_ENTRY("SVGENUM_UNITS_TYPE"),
	CONST_ENTRY("SVGENUM_TRANSFORM_TYPE"),
	CONST_ENTRY("SVGENUM_ATTRIBUTE_TYPE"),
	CONST_ENTRY("SVGENUM_CALCMODE"),
	CONST_ENTRY("SVGENUM_VISIBILITY"),
	CONST_ENTRY("SVGENUM_ANIMATEFILLTYPE"),
	CONST_ENTRY("SVGENUM_ADDITIVE"),
	CONST_ENTRY("SVGENUM_ACCUMULATE"),
	CONST_ENTRY("SVGENUM_FILL_RULE"),
	CONST_ENTRY("SVGENUM_STROKE_LINECAP"),
	CONST_ENTRY("SVGENUM_STROKE_LINEJOIN"),
	CONST_ENTRY("SVGENUM_DISPLAY"),
	CONST_ENTRY("SVGENUM_ZOOM_AND_PAN"),
	CONST_ENTRY("SVGENUM_FONT_WEIGHT"),
	CONST_ENTRY("SVGENUM_FONT_STYLE"),
	CONST_ENTRY("SVGENUM_TEXT_ANCHOR"),
	CONST_ENTRY("SVGENUM_FONT_VARIANT"),
	CONST_ENTRY("SVGENUM_RESTART"),
	CONST_ENTRY("SVGENUM_REQUIREDFEATURES"),
	CONST_ENTRY("SVGENUM_POINTER_EVENTS"),
	CONST_ENTRY("SVGENUM_METHOD"),
#ifdef SVG_SUPPORT_FILTERS
	CONST_ENTRY("SVGENUM_STITCHTILES"),
	CONST_ENTRY("SVGENUM_DISPLACEMENTSELECTOR"),
	CONST_ENTRY("SVGENUM_CONVOLVEEDGEMODE"),
	CONST_ENTRY("SVGENUM_COMPOSITEOPERATOR"),
	CONST_ENTRY("SVGENUM_MORPHOLOGYOPERATOR"),
	CONST_ENTRY("SVGENUM_BLENDMODE"),
	CONST_ENTRY("SVGENUM_TURBULENCETYPE"),
	CONST_ENTRY("SVGENUM_COLORMATRIXTYPE"),
	CONST_ENTRY("SVGENUM_FUNCTYPE"),
#endif // SVG_SUPPORT_FILTERS
	CONST_ENTRY("SVGENUM_BOOLEAN"),
	CONST_ENTRY("SVGENUM_LENGTHADJUST"),
	CONST_ENTRY("SVGENUM_TEXTDECORATION"),
	CONST_ENTRY("SVGENUM_SPACING"),
	CONST_ENTRY("SVGENUM_CURSOR"),
	CONST_ENTRY("SVGENUM_OVERFLOW"),
	CONST_ENTRY("SVGENUM_UNICODE_BIDI"),
	CONST_ENTRY("SVGENUM_WRITING_MODE"),
	CONST_ENTRY("SVGENUM_ALIGNMENT_BASELINE"),
	CONST_ENTRY("SVGENUM_DOMINANT_BASELINE"),
	CONST_ENTRY("SVGENUM_ARABIC_FORM"),
	CONST_ENTRY("SVGENUM_DIRECTION"),
	CONST_ENTRY("SVGENUM_IMAGE_RENDERING"),
	CONST_ENTRY("SVGENUM_MARKER_UNITS"),
	CONST_ENTRY("SVGENUM_TEXT_RENDERING"),
	CONST_ENTRY("SVGENUM_COLOR_INTERPOLATION"),
	CONST_ENTRY("SVGENUM_FOCUSABLE"),
	CONST_ENTRY("SVGENUM_VECTOR_EFFECT"),
	CONST_ENTRY("SVGENUM_FOCUSHIGHLIGHT"),
	CONST_ENTRY("SVGENUM_INITIALVISIBILITY"),
	CONST_ENTRY("SVGENUM_TRANSFORMBEHAVIOR"),
	CONST_ENTRY("SVGENUM_OVERLAY"),
	CONST_ENTRY("SVGENUM_DISPLAY_ALIGN"),
	CONST_ENTRY("SVGENUM_EDITABLE"),
	CONST_ENTRY("SVGENUM_TEXT_ALIGN"),
	CONST_ENTRY("SVGENUM_TEXT_OVERFLOW"),
	CONST_ENTRY("SVGENUM_AUTO"),
	CONST_ENTRY("SVGENUM_SYNCBEHAVIOR"),
	CONST_ENTRY("SVGENUM_NONE"),
	CONST_ENTRY("SVGENUM_SHAPE_RENDERING"),
	CONST_ENTRY("SVGENUM_BUFFERED_RENDERING"),
	CONST_ENTRY("SVGENUM_TIMELINEBEGIN")
CONST_END(g_svg_enum_type_strings)

CONST_ARRAY(g_svg_enum_name_strings, char*)
	CONST_ENTRY("SVGSPREAD_PAD"),
	CONST_ENTRY("SVGSPREAD_REFLECT"),
	CONST_ENTRY("SVGSPREAD_REPEAT"),
	CONST_ENTRY("SVGUNITS_USERSPACEONUSE"),
	CONST_ENTRY("SVGUNITS_OBJECTBBOX"),
	CONST_ENTRY("SVGTRANSFORM_MATRIX"),
	CONST_ENTRY("SVGTRANSFORM_TRANSLATE"),
	CONST_ENTRY("SVGTRANSFORM_ROTATE"),
	CONST_ENTRY("SVGTRANSFORM_SCALE"),
	CONST_ENTRY("SVGTRANSFORM_SKEWX"),
	CONST_ENTRY("SVGTRANSFORM_SKEWY"),
	CONST_ENTRY("SVGATTRIBUTE_CSS"),
	CONST_ENTRY("SVGATTRIBUTE_XML"),
	CONST_ENTRY("SVGATTRIBUTE_AUTO"),
	CONST_ENTRY("SVGCALCMODE_DISCRETE"),
	CONST_ENTRY("SVGCALCMODE_LINEAR"),
	CONST_ENTRY("SVGCALCMODE_SPLINE"),
	CONST_ENTRY("SVGCALCMODE_PACED"),
	CONST_ENTRY("SVGVISIBILITY_VISIBLE"),
	CONST_ENTRY("SVGVISIBILITY_HIDDEN"),
	CONST_ENTRY("SVGVISIBILITY_COLLAPSE"),
	CONST_ENTRY("SVGANIMATEFILL_FREEZE"),
	CONST_ENTRY("SVGANIMATEFILL_REMOVE"),
	CONST_ENTRY("SVGADDITIVE_REPLACE"),
	CONST_ENTRY("SVGADDITIVE_SUM"),
	CONST_ENTRY("SVGACCUMULATE_NONE"),
	CONST_ENTRY("SVGACCUMULATE_SUM"),
	CONST_ENTRY("SVGFILL_EVEN_ODD"),
	CONST_ENTRY("SVGFILL_NON_ZERO"),
	CONST_ENTRY("SVGCAP_BUTT"),
	CONST_ENTRY("SVGCAP_ROUND"),
	CONST_ENTRY("SVGCAP_SQUARE"),
	CONST_ENTRY("SVGJOIN_MITER"),
	CONST_ENTRY("SVGJOIN_ROUND"),
	CONST_ENTRY("SVGJOIN_BEVEL"),
	CONST_ENTRY("SVGDISPLAY_INLINE"),
	CONST_ENTRY("SVGDISPLAY_BLOCK"),
	CONST_ENTRY("SVGDISPLAY_LISTITEM"),
	CONST_ENTRY("SVGDISPLAY_RUNIN"),
	CONST_ENTRY("SVGDISPLAY_COMPACT"),
	CONST_ENTRY("SVGDISPLAY_MARKER"),
	CONST_ENTRY("SVGDISPLAY_TABLE"),
	CONST_ENTRY("SVGDISPLAY_INLINETABLE"),
	CONST_ENTRY("SVGDISPLAY_TABLEROWGROUP"),
	CONST_ENTRY("SVGDISPLAY_TABLEHEADERGROUP"),
	CONST_ENTRY("SVGDISPLAY_TABLEFOOTERGROUP"),
	CONST_ENTRY("SVGDISPLAY_TABLEROW"),
	CONST_ENTRY("SVGDISPLAY_TABLECOLUMNGROUP"),
	CONST_ENTRY("SVGDISPLAY_TABLECOLUMN"),
	CONST_ENTRY("SVGDISPLAY_TABLECELL"),
	CONST_ENTRY("SVGDISPLAY_TABLECAPTION"),
	CONST_ENTRY("SVGDISPLAY_NONE"),
	CONST_ENTRY("SVGZOOMANDPAN_DISABLE"),
	CONST_ENTRY("SVGZOOMANDPAN_MAGNIFY"),
	CONST_ENTRY("SVGFONTWEIGHT_NORMAL"),
	CONST_ENTRY("SVGFONTWEIGHT_BOLD"),
	CONST_ENTRY("SVGFONTWEIGHT_BOLDER"),
	CONST_ENTRY("SVGFONTWEIGHT_LIGHTER"),
	CONST_ENTRY("SVGFONTWEIGHT_100"),
	CONST_ENTRY("SVGFONTWEIGHT_200"),
	CONST_ENTRY("SVGFONTWEIGHT_300"),
	CONST_ENTRY("SVGFONTWEIGHT_400"),
	CONST_ENTRY("SVGFONTWEIGHT_500"),
	CONST_ENTRY("SVGFONTWEIGHT_600"),
	CONST_ENTRY("SVGFONTWEIGHT_700"),
	CONST_ENTRY("SVGFONTWEIGHT_800"),
	CONST_ENTRY("SVGFONTWEIGHT_900"),
	CONST_ENTRY("SVGFONTSTYLE_NORMAL"),
	CONST_ENTRY("SVGFONTSTYLE_ITALIC"),
	CONST_ENTRY("SVGFONTSTYLE_OBLIQUE"),
	CONST_ENTRY("SVGTEXTANCHOR_START"),
	CONST_ENTRY("SVGTEXTANCHOR_MIDDLE"),
	CONST_ENTRY("SVGTEXTANCHOR_END"),
	CONST_ENTRY("SVGFONTVARIANT_NORMAL"),
	CONST_ENTRY("SVGFONTVARIANT_SMALLCAPS"),
	CONST_ENTRY("SVGRESTART_ALWAYS"),
	CONST_ENTRY("SVGRESTART_WHENNOTACTIVE"),
	CONST_ENTRY("SVGRESTART_NEVER"),
	CONST_ENTRY("SVGRESTART_UNKNOWN"),
	CONST_ENTRY("SVGFEATURE_SVG"),
	CONST_ENTRY("SVGFEATURE_SVGDOM"),
	CONST_ENTRY("SVGFEATURE_SVGSTATIC"),
	CONST_ENTRY("SVGFEATURE_SVGDOMSTATIC"),
	CONST_ENTRY("SVGFEATURE_SVGANIMATION"),
	CONST_ENTRY("SVGFEATURE_SVGDOMANIMATION"),
	CONST_ENTRY("SVGFEATURE_SVGDYNAMIC"),
	CONST_ENTRY("SVGFEATURE_SVGDOMDYNAMIC"),
	CONST_ENTRY("SVGFEATURE_COREATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_STRUCTURE"),
	CONST_ENTRY("SVGFEATURE_CONTAINERATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_CONDITIONALPROCESSING"),
	CONST_ENTRY("SVGFEATURE_IMAGE"),
	CONST_ENTRY("SVGFEATURE_STYLE"),
	CONST_ENTRY("SVGFEATURE_VIEWPORTATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_SHAPE"),
	CONST_ENTRY("SVGFEATURE_TEXT"),
	CONST_ENTRY("SVGFEATURE_PAINTATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_OPACITYATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_GRAPHICSATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_MARKER"),
	CONST_ENTRY("SVGFEATURE_COLORPROFILE"),
	CONST_ENTRY("SVGFEATURE_GRADIENT"),
	CONST_ENTRY("SVGFEATURE_PATTERN"),
	CONST_ENTRY("SVGFEATURE_CLIP"),
	CONST_ENTRY("SVGFEATURE_MASK"),
	CONST_ENTRY("SVGFEATURE_FILTER"),
	CONST_ENTRY("SVGFEATURE_DOCUMENTEVENTSATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_GRAPHICALEVENTSATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_ANIMATIONEVENTSATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_CURSOR"),
	CONST_ENTRY("SVGFEATURE_HYPERLINKING"),
	CONST_ENTRY("SVGFEATURE_XLINKATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_EXTERNALRESOURCESREQUIRED"),
	CONST_ENTRY("SVGFEATURE_VIEW"),
	CONST_ENTRY("SVGFEATURE_SCRIPT"),
	CONST_ENTRY("SVGFEATURE_ANIMATION"),
	CONST_ENTRY("SVGFEATURE_FONT"),
	CONST_ENTRY("SVGFEATURE_EXTENSIBILITY"),
	CONST_ENTRY("SVGFEATURE_TINY_BASE"),
	CONST_ENTRY("SVGFEATURE_TINY_INTERACTIVITY"),
	CONST_ENTRY("SVGFEATURE_TINY_ALL"),
	CONST_ENTRY("SVGFEATURE_BASIC_ALL"),
	CONST_ENTRY("SVGFEATURE_BASIC_BASE"),
	CONST_ENTRY("SVGFEATURE_BASIC_CLIP"),
	CONST_ENTRY("SVGFEATURE_BASIC_CSS"),
	CONST_ENTRY("SVGFEATURE_BASIC_DOMCORE"),
	CONST_ENTRY("SVGFEATURE_BASIC_DOMEXTENDED"),
	CONST_ENTRY("SVGFEATURE_BASIC_FILTER"),
	CONST_ENTRY("SVGFEATURE_BASIC_FONT"),
	CONST_ENTRY("SVGFEATURE_BASIC_GRAPHICSATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_BASIC_INTERACTIVITY"),
	CONST_ENTRY("SVGFEATURE_BASIC_PAINTATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_BASIC_STRUCTURE"),
	CONST_ENTRY("SVGFEATURE_BASIC_TEXT"),
	CONST_ENTRY("SVGFEATURE_1_0"),
	CONST_ENTRY("SVGFEATURE_1_0_STATIC"),
	CONST_ENTRY("SVGFEATURE_1_0_DYNAMIC"),
	CONST_ENTRY("SVGFEATURE_1_0_ANIMATION"),
	CONST_ENTRY("SVGFEATURE_1_0_ALL"),
	CONST_ENTRY("SVGFEATURE_1_0_DOM"),
	CONST_ENTRY("SVGFEATURE_1_0_DOM_STATIC"),
	CONST_ENTRY("SVGFEATURE_1_0_DOM_DYNAMIC"),
	CONST_ENTRY("SVGFEATURE_1_0_DOM_ANIMATION"),
	CONST_ENTRY("SVGFEATURE_1_0_DOM_ALL"),
	CONST_ENTRY("SVGFEATURE_1_2_SVGSTATIC"),
	CONST_ENTRY("SVGFEATURE_1_2_SVGSTATICDOM"),
	CONST_ENTRY("SVGFEATURE_1_2_SVGANIMATED"),
	CONST_ENTRY("SVGFEATURE_1_2_SVGINTERACTIVE"),
	CONST_ENTRY("SVGFEATURE_1_2_SVGALL"),
	CONST_ENTRY("SVGFEATURE_1_2_CORE_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_NAVIGATION_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_STRUCTURE"),
	CONST_ENTRY("SVGFEATURE_1_2_CONDITIONAL_PROCESSING"),
	CONST_ENTRY("SVGFEATURE_1_2_CONDITIONAL_PROCESSING_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_IMAGE"),
	CONST_ENTRY("SVGFEATURE_1_2_PREFETCH"),
	CONST_ENTRY("SVGFEATURE_1_2_DISCARD"),
	CONST_ENTRY("SVGFEATURE_1_2_SHAPE"),
	CONST_ENTRY("SVGFEATURE_1_2_TEXT"),
	CONST_ENTRY("SVGFEATURE_1_2_PAINT_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_OPACITY_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_GRAPHICS_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_GRADIENT"),
	CONST_ENTRY("SVGFEATURE_1_2_SOLID_COLOR"),
	CONST_ENTRY("SVGFEATURE_1_2_HYPERLINKING"),
	CONST_ENTRY("SVGFEATURE_1_2_XLINK_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_EXTERNALRESOURCESREQUIRED"),
	CONST_ENTRY("SVGFEATURE_1_2_SCRIPTING"),
	CONST_ENTRY("SVGFEATURE_1_2_HANDLER"),
	CONST_ENTRY("SVGFEATURE_1_2_LISTENER"),
	CONST_ENTRY("SVGFEATURE_1_2_TIMEDANIMATION"),
	CONST_ENTRY("SVGFEATURE_1_2_ANIMATION"),
	CONST_ENTRY("SVGFEATURE_1_2_AUDIO"),
	CONST_ENTRY("SVGFEATURE_1_2_VIDEO"),
	CONST_ENTRY("SVGFEATURE_1_2_FONT"),
	CONST_ENTRY("SVGFEATURE_1_2_EXTENSIBILITY"),
	CONST_ENTRY("SVGFEATURE_1_2_MEDIA_ATTRIBUTE"),
	CONST_ENTRY("SVGFEATURE_1_2_TEXTFLOW"),
	CONST_ENTRY("SVGFEATURE_1_2_TRANSFORMEDVIDEO"),
	CONST_ENTRY("SVGFEATURE_1_2_COMPOSEDVIDEO"),
	CONST_ENTRY("SVGFEATURE_1_2_EDITABLE_ATTRIBUTE"),
	CONST_ENTRY("SVGPOINTEREVENTS_VISIBLEPAINTED"),
	CONST_ENTRY("SVGPOINTEREVENTS_VISIBLEFILL"),
	CONST_ENTRY("SVGPOINTEREVENTS_VISIBLESTROKE"),
	CONST_ENTRY("SVGPOINTEREVENTS_VISIBLE"),
	CONST_ENTRY("SVGPOINTEREVENTS_PAINTED"),
	CONST_ENTRY("SVGPOINTEREVENTS_FILL"),
	CONST_ENTRY("SVGPOINTEREVENTS_STROKE"),
	CONST_ENTRY("SVGPOINTEREVENTS_ALL"),
	CONST_ENTRY("SVGPOINTEREVENTS_NONE"),
	CONST_ENTRY("SVGPOINTEREVENTS_BOUNDINGBOX"),
	CONST_ENTRY("SVGMETHOD_ALIGN"),
	CONST_ENTRY("SVGMETHOD_STRETCH"),
#ifdef SVG_SUPPORT_FILTERS
	CONST_ENTRY("SVGSTITCH_STITCH"),
	CONST_ENTRY("SVGSTITCH_NOSTITCH"),
	CONST_ENTRY("SVGDISPLACEMENT_R"),
	CONST_ENTRY("SVGDISPLACEMENT_G"),
	CONST_ENTRY("SVGDISPLACEMENT_B"),
	CONST_ENTRY("SVGDISPLACEMENT_A"),
	CONST_ENTRY("SVGCONVOLVEEDGEMODE_DUPLICATE"),
	CONST_ENTRY("SVGCONVOLVEEDGEMODE_WRAP"),
	CONST_ENTRY("SVGCONVOLVEEDGEMODE_NONE"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_OVER"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_IN"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_OUT"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_ATOP"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_XOR"),
	CONST_ENTRY("SVGCOMPOSITEOPERATOR_ARITHMETIC"),
	CONST_ENTRY("SVGMORPHOPERATOR_ERODE"),
	CONST_ENTRY("SVGMORPHOPERATOR_DILATE"),
	CONST_ENTRY("SVGBLENDMODE_NORMAL"),
	CONST_ENTRY("SVGBLENDMODE_MULTIPLY"),
	CONST_ENTRY("SVGBLENDMODE_SCREEN"),
	CONST_ENTRY("SVGBLENDMODE_DARKEN"),
	CONST_ENTRY("SVGBLENDMODE_LIGHTEN"),
	CONST_ENTRY("SVGTURBULENCE_FRACTALNOISE"),
	CONST_ENTRY("SVGTURBULENCE_TURBULENCE"),
	CONST_ENTRY("SVGCOLORMATRIX_MATRIX"),
	CONST_ENTRY("SVGCOLORMATRIX_SATURATE"),
	CONST_ENTRY("SVGCOLORMATRIX_HUEROTATE"),
	CONST_ENTRY("SVGCOLORMATRIX_LUMINANCETOALPHA"),
	CONST_ENTRY("SVGFUNC_IDENTITY"),
	CONST_ENTRY("SVGFUNC_TABLE"),
	CONST_ENTRY("SVGFUNC_DISCRETE"),
	CONST_ENTRY("SVGFUNC_LINEAR"),
	CONST_ENTRY("SVGFUNC_GAMMA"),
#endif // SVG_SUPPORT_FILTERS
	CONST_ENTRY("FALSE"),
	CONST_ENTRY("TRUE"),
	CONST_ENTRY("SVGLENADJUST_SPACING"),
	CONST_ENTRY("SVGLENADJUST_SPACINGANDGLYPHS"),
	CONST_ENTRY("SVGTEXTDECORATION_NONE"),
	CONST_ENTRY("SVGTEXTDECORATION_UNDERLINE"),
	CONST_ENTRY("SVGTEXTDECORATION_OVERLINE"),
	CONST_ENTRY("SVGTEXTDECORATION_LINETHROUGH"),
	CONST_ENTRY("SVGTEXTDECORATION_BLINK"),
	CONST_ENTRY("SVGSPACING_AUTO"),
	CONST_ENTRY("SVGSPACING_EXACT"),
	CONST_ENTRY("CURSOR_URI"),
	CONST_ENTRY("CURSOR_CROSSHAIR"),
	CONST_ENTRY("CURSOR_DEFAULT_ARROW"),
	CONST_ENTRY("CURSOR_CUR_POINTER"),
	CONST_ENTRY("CURSOR_MOVE"),
	CONST_ENTRY("CURSOR_E_RESIZE"),
	CONST_ENTRY("CURSOR_NE_RESIZE"),
	CONST_ENTRY("CURSOR_NW_RESIZE"),
	CONST_ENTRY("CURSOR_N_RESIZE"),
	CONST_ENTRY("CURSOR_SE_RESIZE"),
	CONST_ENTRY("CURSOR_SW_RESIZE"),
	CONST_ENTRY("CURSOR_S_RESIZE"),
	CONST_ENTRY("CURSOR_W_RESIZE"),
	CONST_ENTRY("CURSOR_TEXT"),
	CONST_ENTRY("CURSOR_WAIT"),
	CONST_ENTRY("CURSOR_HELP"),
	CONST_ENTRY("CSS_VALUE_visible"),
	CONST_ENTRY("CSS_VALUE_hidden"),
	CONST_ENTRY("CSS_VALUE_scroll"),
	CONST_ENTRY("CSS_VALUE_auto"),
	CONST_ENTRY("CSS_VALUE_normal"),
	CONST_ENTRY("CSS_VALUE_embed"),
	CONST_ENTRY("CSS_VALUE_bidi_override"),
	CONST_ENTRY("SVGWRITINGMODE_LR_TB"),
	CONST_ENTRY("SVGWRITINGMODE_RL_TB"),
	CONST_ENTRY("SVGWRITINGMODE_TB_RL"),
	CONST_ENTRY("SVGWRITINGMODE_LR"),
	CONST_ENTRY("SVGWRITINGMODE_RL"),
	CONST_ENTRY("SVGWRITINGMODE_TB"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_AUTO"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_BASELINE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_BEFORE_EDGE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_TEXT_BEFORE_EDGE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_MIDDLE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_CENTRAL"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_AFTER_EDGE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_TEXT_AFTER_EDGE"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_IDEOGRAPHIC"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_ALPHABETIC"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_HANGING"),
	CONST_ENTRY("SVGALIGNMENTBASELINE_MATHEMATICAL"),
	CONST_ENTRY("SVGDOMINANTBASELINE_AUTO"),
	CONST_ENTRY("SVGDOMINANTBASELINE_USE_SCRIPT"),
	CONST_ENTRY("SVGDOMINANTBASELINE_NO_CHANGE"),
	CONST_ENTRY("SVGDOMINANTBASELINE_RESET_SIZE"),
	CONST_ENTRY("SVGDOMINANTBASELINE_IDEOGRAPHIC"),
	CONST_ENTRY("SVGDOMINANTBASELINE_ALPHABETIC"),
	CONST_ENTRY("SVGDOMINANTBASELINE_HANGING"),
	CONST_ENTRY("SVGDOMINANTBASELINE_MATHEMATICAL"),
	CONST_ENTRY("SVGDOMINANTBASELINE_CENTRAL"),
	CONST_ENTRY("SVGDOMINANTBASELINE_MIDDLE"),
	CONST_ENTRY("SVGDOMINANTBASELINE_TEXT_AFTER_EDGE"),
	CONST_ENTRY("SVGDOMINANTBASELINE_TEXT_BEFORE_EDGE"),
	CONST_ENTRY("SVGARABICFORM_INITIAL"),
	CONST_ENTRY("SVGARABICFORM_MEDIAL"),
	CONST_ENTRY("SVGARABICFORM_TERMINAL"),
	CONST_ENTRY("SVGARABICFORM_ISOLATED"),
	CONST_ENTRY("CSS_VALUE_ltr"),
	CONST_ENTRY("CSS_VALUE_rtl"),
	CONST_ENTRY("SVGIMAGERENDERING_AUTO"),
	CONST_ENTRY("SVGIMAGERENDERING_OPTIMIZESPEED"),
	CONST_ENTRY("SVGIMAGERENDERING_OPTIMIZEQUALITY"),
	CONST_ENTRY("SVGMARKERUNITS_STROKEWIDTH"),
	CONST_ENTRY("SVGMARKERUNITS_USERSPACEONUSE"),
	CONST_ENTRY("SVGTEXTRENDERING_AUTO"),
	CONST_ENTRY("SVGTEXTRENDERING_OPTIMIZESPEED"),
	CONST_ENTRY("SVGTEXTRENDERING_OPTIMIZELEGIBILITY"),
	CONST_ENTRY("SVGTEXTRENDERING_GEOMETRICPRECISION"),
	CONST_ENTRY("SVGCOLORINTERPOLATION_AUTO"),
	CONST_ENTRY("SVGCOLORINTERPOLATION_SRGB"),
	CONST_ENTRY("SVGCOLORINTERPOLATION_LINEARRGB"),
	CONST_ENTRY("SVGFOCUSABLE_TRUE"),
	CONST_ENTRY("SVGFOCUSABLE_FALSE"),
	CONST_ENTRY("SVGFOCUSABLE_AUTO"),
	CONST_ENTRY("SVGVECTOREFFECT_NONE"),
	CONST_ENTRY("SVGVECTOREFFECT_NON_SCALING_STROKE"),
	CONST_ENTRY("SVGFOCUSHIGHLIGHT_NONE"),
	CONST_ENTRY("SVGFOCUSHIGHLIGHT_AUTO"),
	CONST_ENTRY("SVGINITIALVISIBILITY_WHENSTARTED"),
	CONST_ENTRY("SVGINITIALVISIBILITY_ALWAYS"),
	CONST_ENTRY("SVGTRANSFORMBEHAVIOR_GEOMETRIC"),
	CONST_ENTRY("SVGTRANSFORMBEHAVIOR_PINNED"),
	CONST_ENTRY("SVGTRANSFORMBEHAVIOR_PINNED90"),
	CONST_ENTRY("SVGTRANSFORMBEHAVIOR_PINNED180"),
	CONST_ENTRY("SVGTRANSFORMBEHAVIOR_PINNED270"),
	CONST_ENTRY("SVGOVERLAY_TOP"),
	CONST_ENTRY("SVGOVERLAY_NONE"),
	CONST_ENTRY("SVGDISPLAYALIGN_AUTO"),
	CONST_ENTRY("SVGDISPLAYALIGN_BEFORE"),
	CONST_ENTRY("SVGDISPLAYALIGN_CENTER"),
	CONST_ENTRY("SVGDISPLAYALIGN_AFTER"),
	CONST_ENTRY("SVGEDITABLE_NONE"),
	CONST_ENTRY("SVGEDITABLE_SIMPLE"),
	CONST_ENTRY("CSS_VALUE_start"),
	CONST_ENTRY("CSS_VALUE_center"),
	CONST_ENTRY("CSS_VALUE_end"),
	CONST_ENTRY("CSS_VALUE_clip"),
	CONST_ENTRY("CSS_VALUE_ellipsis"),
	CONST_ENTRY("SVGAUTO_AUTO"),
	CONST_ENTRY("SVGSYNCBEHAVIOR_CANSLIP"),
	CONST_ENTRY("SVGSYNCBEHAVIOR_LOCKED"),
	CONST_ENTRY("SVGSYNCBEHAVIOR_INDEPENDENT"),
	CONST_ENTRY("SVGSYNCBEHAVIOR_DEFAULT"),
	CONST_ENTRY("SVGSYNCBEHAVIOR_INHERIT"),
	CONST_ENTRY("SVGSNAPSHOTTIME_NONE"),
	CONST_ENTRY("SVGSHAPERENDERING_AUTO"),
	CONST_ENTRY("SVGSHAPERENDERING_OPTIMIZESPEED"),
	CONST_ENTRY("SVGSHAPERENDERING_CRISPEDGES"),
	CONST_ENTRY("SVGSHAPERENDERING_GEOMETRICPRECISION"),
	CONST_ENTRY("SVGBUFFEREDRENDERING_AUTO"),
	CONST_ENTRY("SVGBUFFEREDRENDERING_STATIC"),
	CONST_ENTRY("SVGBUFFEREDRENDERING_DYNAMIC"),
	CONST_ENTRY("SVGTIMELINEBEGIN_ONLOAD"),
	CONST_ENTRY("SVGTIMELINEBEGIN_ONSTART")
CONST_END(g_svg_enum_name_strings)

#endif // _DEBUG

const int svg_enum_lookup[] = {
	-1,
	SVG_ENUM_IDX_SVGENUM_SPREAD_METHOD_TYPE,
	SVG_ENUM_IDX_SVGENUM_UNITS_TYPE,
	SVG_ENUM_IDX_SVGENUM_TRANSFORM_TYPE,
	SVG_ENUM_IDX_SVGENUM_ATTRIBUTE_TYPE,
	SVG_ENUM_IDX_SVGENUM_CALCMODE,
	SVG_ENUM_IDX_SVGENUM_VISIBILITY,
	SVG_ENUM_IDX_SVGENUM_ANIMATEFILLTYPE,
	SVG_ENUM_IDX_SVGENUM_ADDITIVE,
	SVG_ENUM_IDX_SVGENUM_ACCUMULATE,
	SVG_ENUM_IDX_SVGENUM_FILL_RULE,
	SVG_ENUM_IDX_SVGENUM_STROKE_LINECAP,
	SVG_ENUM_IDX_SVGENUM_STROKE_LINEJOIN,
	SVG_ENUM_IDX_SVGENUM_DISPLAY,
	SVG_ENUM_IDX_SVGENUM_ZOOM_AND_PAN,
	SVG_ENUM_IDX_SVGENUM_FONT_WEIGHT,
	SVG_ENUM_IDX_SVGENUM_FONT_STYLE,
	SVG_ENUM_IDX_SVGENUM_TEXT_ANCHOR,
	SVG_ENUM_IDX_SVGENUM_FONT_VARIANT,
	SVG_ENUM_IDX_SVGENUM_RESTART,
	SVG_ENUM_IDX_SVGENUM_REQUIREDFEATURES,
	SVG_ENUM_IDX_SVGENUM_POINTER_EVENTS,
	SVG_ENUM_IDX_SVGENUM_METHOD,
#ifdef SVG_SUPPORT_FILTERS
	SVG_ENUM_IDX_SVGENUM_STITCHTILES,
	SVG_ENUM_IDX_SVGENUM_DISPLACEMENTSELECTOR,
	SVG_ENUM_IDX_SVGENUM_CONVOLVEEDGEMODE,
	SVG_ENUM_IDX_SVGENUM_COMPOSITEOPERATOR,
	SVG_ENUM_IDX_SVGENUM_MORPHOLOGYOPERATOR,
	SVG_ENUM_IDX_SVGENUM_BLENDMODE,
	SVG_ENUM_IDX_SVGENUM_TURBULENCETYPE,
	SVG_ENUM_IDX_SVGENUM_COLORMATRIXTYPE,
	SVG_ENUM_IDX_SVGENUM_FUNCTYPE,
#endif // SVG_SUPPORT_FILTERS
	SVG_ENUM_IDX_SVGENUM_BOOLEAN,
	SVG_ENUM_IDX_SVGENUM_LENGTHADJUST,
	SVG_ENUM_IDX_SVGENUM_TEXTDECORATION,
	SVG_ENUM_IDX_SVGENUM_SPACING,
	SVG_ENUM_IDX_SVGENUM_CURSOR,
	SVG_ENUM_IDX_SVGENUM_OVERFLOW,
	SVG_ENUM_IDX_SVGENUM_UNICODE_BIDI,
	SVG_ENUM_IDX_SVGENUM_WRITING_MODE,
	SVG_ENUM_IDX_SVGENUM_ALIGNMENT_BASELINE,
	SVG_ENUM_IDX_SVGENUM_DOMINANT_BASELINE,
	SVG_ENUM_IDX_SVGENUM_ARABIC_FORM,
	SVG_ENUM_IDX_SVGENUM_DIRECTION,
	SVG_ENUM_IDX_SVGENUM_IMAGE_RENDERING,
	SVG_ENUM_IDX_SVGENUM_MARKER_UNITS,
	SVG_ENUM_IDX_SVGENUM_TEXT_RENDERING,
	SVG_ENUM_IDX_SVGENUM_COLOR_INTERPOLATION,
	SVG_ENUM_IDX_SVGENUM_FOCUSABLE,
	SVG_ENUM_IDX_SVGENUM_VECTOR_EFFECT,
	SVG_ENUM_IDX_SVGENUM_FOCUSHIGHLIGHT,
	SVG_ENUM_IDX_SVGENUM_INITIALVISIBILITY,
	SVG_ENUM_IDX_SVGENUM_TRANSFORMBEHAVIOR,
	SVG_ENUM_IDX_SVGENUM_OVERLAY,
	SVG_ENUM_IDX_SVGENUM_DISPLAY_ALIGN,
	SVG_ENUM_IDX_SVGENUM_EDITABLE,
	SVG_ENUM_IDX_SVGENUM_TEXT_ALIGN,
	SVG_ENUM_IDX_SVGENUM_TEXT_OVERFLOW,
	SVG_ENUM_IDX_SVGENUM_AUTO,
	SVG_ENUM_IDX_SVGENUM_SYNCBEHAVIOR,
	SVG_ENUM_IDX_SVGENUM_NONE,
	SVG_ENUM_IDX_SVGENUM_SHAPE_RENDERING,
	SVG_ENUM_IDX_SVGENUM_BUFFERED_RENDERING,
	SVG_ENUM_IDX_SVGENUM_TIMELINEBEGIN,
};

SVG_ENUMS_START
	SVG_ENUMS_ENTRY(SVGENUM_SPREAD_METHOD_TYPE, SVGSPREAD_PAD, "pad", 3)
	SVG_ENUMS_ENTRY(SVGENUM_SPREAD_METHOD_TYPE, SVGSPREAD_REFLECT, "reflect", 7)
	SVG_ENUMS_ENTRY(SVGENUM_SPREAD_METHOD_TYPE, SVGSPREAD_REPEAT, "repeat", 6)
	SVG_ENUMS_ENTRY(SVGENUM_UNITS_TYPE, SVGUNITS_USERSPACEONUSE, "userSpaceOnUse", 14)
	SVG_ENUMS_ENTRY(SVGENUM_UNITS_TYPE, SVGUNITS_OBJECTBBOX, "objectBoundingBox", 17)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_MATRIX, "matrix", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_TRANSLATE, "translate", 9)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_ROTATE, "rotate", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_SCALE, "scale", 5)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_SKEWX, "skewX", 5)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORM_TYPE, SVGTRANSFORM_SKEWY, "skewY", 5)
	SVG_ENUMS_ENTRY(SVGENUM_ATTRIBUTE_TYPE, SVGATTRIBUTE_CSS, "CSS", 3)
	SVG_ENUMS_ENTRY(SVGENUM_ATTRIBUTE_TYPE, SVGATTRIBUTE_XML, "XML", 3)
	SVG_ENUMS_ENTRY(SVGENUM_ATTRIBUTE_TYPE, SVGATTRIBUTE_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CALCMODE, SVGCALCMODE_DISCRETE, "discrete", 8)
	SVG_ENUMS_ENTRY(SVGENUM_CALCMODE, SVGCALCMODE_LINEAR, "linear", 6)
	SVG_ENUMS_ENTRY(SVGENUM_CALCMODE, SVGCALCMODE_SPLINE, "spline", 6)
	SVG_ENUMS_ENTRY(SVGENUM_CALCMODE, SVGCALCMODE_PACED, "paced", 5)
	SVG_ENUMS_ENTRY(SVGENUM_VISIBILITY, SVGVISIBILITY_VISIBLE, "visible", 7)
	SVG_ENUMS_ENTRY(SVGENUM_VISIBILITY, SVGVISIBILITY_HIDDEN, "hidden", 6)
	SVG_ENUMS_ENTRY(SVGENUM_VISIBILITY, SVGVISIBILITY_COLLAPSE, "collapse", 8)
	SVG_ENUMS_ENTRY(SVGENUM_ANIMATEFILLTYPE, SVGANIMATEFILL_FREEZE, "freeze", 6)
	SVG_ENUMS_ENTRY(SVGENUM_ANIMATEFILLTYPE, SVGANIMATEFILL_REMOVE, "remove", 6)
	SVG_ENUMS_ENTRY(SVGENUM_ADDITIVE, SVGADDITIVE_REPLACE, "replace", 7)
	SVG_ENUMS_ENTRY(SVGENUM_ADDITIVE, SVGADDITIVE_SUM, "sum", 3)
	SVG_ENUMS_ENTRY(SVGENUM_ACCUMULATE, SVGACCUMULATE_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_ACCUMULATE, SVGACCUMULATE_SUM, "sum", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FILL_RULE, SVGFILL_EVEN_ODD, "evenodd", 7)
	SVG_ENUMS_ENTRY(SVGENUM_FILL_RULE, SVGFILL_NON_ZERO, "nonzero", 7)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINECAP, SVGCAP_BUTT, "butt", 4)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINECAP, SVGCAP_ROUND, "round", 5)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINECAP, SVGCAP_SQUARE, "square", 6)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINEJOIN, SVGJOIN_MITER, "miter", 5)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINEJOIN, SVGJOIN_ROUND, "round", 5)
	SVG_ENUMS_ENTRY(SVGENUM_STROKE_LINEJOIN, SVGJOIN_BEVEL, "bevel", 5)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_INLINE, "inline", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_BLOCK, "block", 5)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_LISTITEM, "list-item", 9)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_RUNIN, "run-in", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_COMPACT, "compact", 7)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_MARKER, "marker", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLE, "table", 5)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_INLINETABLE, "inline-table", 12)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLEROWGROUP, "table-row-group", 15)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLEHEADERGROUP, "table-header-group", 18)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLEFOOTERGROUP, "table-footer-group", 18)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLEROW, "table-row", 9)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLECOLUMNGROUP, "table-column-group", 18)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLECOLUMN, "table-column", 12)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLECELL, "table-cell", 10)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_TABLECAPTION, "table-caption", 13)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY, SVGDISPLAY_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_ZOOM_AND_PAN, SVGZOOMANDPAN_DISABLE, "disable", 7)
	SVG_ENUMS_ENTRY(SVGENUM_ZOOM_AND_PAN, SVGZOOMANDPAN_MAGNIFY, "magnify", 7)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_NORMAL, "normal", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_BOLD, "bold", 4)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_BOLDER, "bolder", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_LIGHTER, "lighter", 7)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_100, "100", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_200, "200", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_300, "300", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_400, "400", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_500, "500", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_600, "600", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_700, "700", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_800, "800", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_WEIGHT, SVGFONTWEIGHT_900, "900", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_STYLE, SVGFONTSTYLE_NORMAL, "normal", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_STYLE, SVGFONTSTYLE_ITALIC, "italic", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_STYLE, SVGFONTSTYLE_OBLIQUE, "oblique", 7)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ANCHOR, SVGTEXTANCHOR_START, "start", 5)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ANCHOR, SVGTEXTANCHOR_MIDDLE, "middle", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ANCHOR, SVGTEXTANCHOR_END, "end", 3)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_VARIANT, SVGFONTVARIANT_NORMAL, "normal", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FONT_VARIANT, SVGFONTVARIANT_SMALLCAPS, "small-caps", 10)
	SVG_ENUMS_ENTRY(SVGENUM_RESTART, SVGRESTART_ALWAYS, "always", 6)
	SVG_ENUMS_ENTRY(SVGENUM_RESTART, SVGRESTART_WHENNOTACTIVE, "whenNotActive", 13)
	SVG_ENUMS_ENTRY(SVGENUM_RESTART, SVGRESTART_NEVER, "never", 5)
	SVG_ENUMS_ENTRY(SVGENUM_RESTART, SVGRESTART_UNKNOWN, "unknown", 7)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVG, "http://www.w3.org/TR/SVG11/feature#SVG", 38)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGDOM, "http://www.w3.org/TR/SVG11/feature#SVGDOM", 41)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGSTATIC, "http://www.w3.org/TR/SVG11/feature#SVG-static", 45)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGDOMSTATIC, "http://www.w3.org/TR/SVG11/feature#SVGDOM-static", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGANIMATION, "http://www.w3.org/TR/SVG11/feature#SVG-animation", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGDOMANIMATION, "http://www.w3.org/TR/SVG11/feature#SVGDOM-animation", 51)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGDYNAMIC, "http://www.w3.org/TR/SVG11/feature#SVG-dynamic", 46)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SVGDOMDYNAMIC, "http://www.w3.org/TR/SVG11/feature#SVGDOM-dynamic", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_COREATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#CoreAttribute", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_STRUCTURE, "http://www.w3.org/TR/SVG11/feature#Structure", 44)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_CONTAINERATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#ContainerAttribute", 53)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_CONDITIONALPROCESSING, "http://www.w3.org/TR/SVG11/feature#ConditionalProcessing", 56)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_IMAGE, "http://www.w3.org/TR/SVG11/feature#Image", 40)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_STYLE, "http://www.w3.org/TR/SVG11/feature#Style", 40)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_VIEWPORTATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#ViewportAttribute", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SHAPE, "http://www.w3.org/TR/SVG11/feature#Shape", 40)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_TEXT, "http://www.w3.org/TR/SVG11/feature#Text", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_PAINTATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#PaintAttribute", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_OPACITYATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#OpacityAttribute", 51)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_GRAPHICSATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#GraphicsAttribute", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_MARKER, "http://www.w3.org/TR/SVG11/feature#Marker", 41)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_COLORPROFILE, "http://www.w3.org/TR/SVG11/feature#ColorProfile", 47)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_GRADIENT, "http://www.w3.org/TR/SVG11/feature#Gradient", 43)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_PATTERN, "http://www.w3.org/TR/SVG11/feature#Pattern", 42)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_CLIP, "http://www.w3.org/TR/SVG11/feature#Clip", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_MASK, "http://www.w3.org/TR/SVG11/feature#Mask", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_FILTER, "http://www.w3.org/TR/SVG11/feature#Filter", 41)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_DOCUMENTEVENTSATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#DocumentEventsAttribute", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_GRAPHICALEVENTSATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#GraphicalEventsAttribute", 59)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_ANIMATIONEVENTSATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#AnimationEventsAttribute", 59)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_CURSOR, "http://www.w3.org/TR/SVG11/feature#Cursor", 41)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_HYPERLINKING, "http://www.w3.org/TR/SVG11/feature#Hyperlinking", 47)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_XLINKATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#XlinkAttribute", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_EXTERNALRESOURCESREQUIRED, "http://www.w3.org/TR/SVG11/feature#ExternalResourcesRequired", 60)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_VIEW, "http://www.w3.org/TR/SVG11/feature#View", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_SCRIPT, "http://www.w3.org/TR/SVG11/feature#Script", 41)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_ANIMATION, "http://www.w3.org/TR/SVG11/feature#Animation", 44)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_FONT, "http://www.w3.org/TR/SVG11/feature#Font", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_EXTENSIBILITY, "http://www.w3.org/TR/SVG11/feature#Extensibility", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_TINY_BASE, "http://www.w3.org/TR/SVG11/feature#base", 39)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_TINY_INTERACTIVITY, "http://www.w3.org/TR/SVG11/feature#interactivity", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_TINY_ALL, "http://www.w3.org/TR/SVG11/feature#all", 38)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_ALL, "http://www.w3.org/TR/SVGMobile/Basic/feature#all", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_BASE, "http://www.w3.org/TR/SVGMobile/Basic/feature#base", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_CLIP, "http://www.w3.org/TR/SVG11/feature#BasicClip", 44)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_CSS, "http://www.w3.org/TR/SVGMobile/Basic/feature#css", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_DOMCORE, "http://www.w3.org/TR/SVGMobile/Basic/feature#SVGBasicDomCore", 60)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_DOMEXTENDED, "http://www.w3.org/TR/SVGMobile/Basic/feature#SVGBasicDomExtended", 64)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_FILTER, "http://www.w3.org/TR/SVG11/feature#BasicFilter", 46)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_FONT, "http://www.w3.org/TR/SVG11/feature#BasicFont", 44)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_GRAPHICSATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#BasicGraphicsAttribute", 57)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_INTERACTIVITY, "http://www.w3.org/TR/SVGMobile/Basic/feature#interactivity", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_PAINTATTRIBUTE, "http://www.w3.org/TR/SVG11/feature#BasicPaintAttribute", 54)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_STRUCTURE, "http://www.w3.org/TR/SVG11/feature#BasicStructure", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_BASIC_TEXT, "http://www.w3.org/TR/SVG11/feature#BasicText", 44)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0, "org.w3c.svg", 11)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_STATIC, "org.w3c.svg.static", 18)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DYNAMIC, "org.w3c.svg.dynamic", 19)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_ANIMATION, "org.w3c.svg.animation", 21)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_ALL, "org.w3c.svg.all", 15)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DOM, "org.w3c.dom.svg", 15)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DOM_STATIC, "org.w3c.dom.svg.static", 22)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DOM_DYNAMIC, "org.w3c.dom.svg.dynamic", 23)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DOM_ANIMATION, "org.w3c.dom.svg.animation", 25)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_0_DOM_ALL, "org.w3c.dom.svg.all", 19)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SVGSTATIC, "http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-static", 54)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SVGSTATICDOM, "http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-static-DOM", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SVGANIMATED, "http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-animated", 56)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SVGINTERACTIVE, "http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-interactive", 59)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SVGALL, "http://www.w3.org/Graphics/SVG/feature/1.2/#SVG-all", 51)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_CORE_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#CoreAttribute", 57)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_NAVIGATION_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#NavigationAttribute", 63)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_STRUCTURE, "http://www.w3.org/Graphics/SVG/feature/1.2/#Structure", 53)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_CONDITIONAL_PROCESSING, "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessing", 65)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_CONDITIONAL_PROCESSING_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#ConditionalProcessingAttribute", 74)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_IMAGE, "http://www.w3.org/Graphics/SVG/feature/1.2/#Image", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_PREFETCH, "http://www.w3.org/Graphics/SVG/feature/1.2/#Prefetch", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_DISCARD, "http://www.w3.org/Graphics/SVG/feature/1.2/#Discard", 51)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SHAPE, "http://www.w3.org/Graphics/SVG/feature/1.2/#Shape", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_TEXT, "http://www.w3.org/Graphics/SVG/feature/1.2/#Text", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_PAINT_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#PaintAttribute", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_OPACITY_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#OpacityAttribute", 60)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_GRAPHICS_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#GraphicsAttribute", 61)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_GRADIENT, "http://www.w3.org/Graphics/SVG/feature/1.2/#Gradient", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SOLID_COLOR, "http://www.w3.org/Graphics/SVG/feature/1.2/#SolidColor", 54)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_HYPERLINKING, "http://www.w3.org/Graphics/SVG/feature/1.2/#Hyperlinking", 56)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_XLINK_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#XlinkAttribute", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_EXTERNALRESOURCESREQUIRED, "http://www.w3.org/Graphics/SVG/feature/1.2/#ExternalResourcesRequired", 69)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_SCRIPTING, "http://www.w3.org/Graphics/SVG/feature/1.2/#Scripting", 53)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_HANDLER, "http://www.w3.org/Graphics/SVG/feature/1.2/#Handler", 51)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_LISTENER, "http://www.w3.org/Graphics/SVG/feature/1.2/#Listener", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_TIMEDANIMATION, "http://www.w3.org/Graphics/SVG/feature/1.2/#TimedAnimation", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_ANIMATION, "http://www.w3.org/Graphics/SVG/feature/1.2/#Animation", 53)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_AUDIO, "http://www.w3.org/Graphics/SVG/feature/1.2/#Audio", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_VIDEO, "http://www.w3.org/Graphics/SVG/feature/1.2/#Video", 49)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_FONT, "http://www.w3.org/Graphics/SVG/feature/1.2/#Font", 48)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_EXTENSIBILITY, "http://www.w3.org/Graphics/SVG/feature/1.2/#Extensibility", 57)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_MEDIA_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#MediaAttribute", 58)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_TEXTFLOW, "http://www.w3.org/Graphics/SVG/feature/1.2/#TextFlow", 52)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_TRANSFORMEDVIDEO, "http://www.w3.org/Graphics/SVG/feature/1.2/#TransformedVideo", 60)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_COMPOSEDVIDEO, "http://www.w3.org/Graphics/SVG/feature/1.2/#ComposedVideo", 57)
	SVG_ENUMS_ENTRY(SVGENUM_REQUIREDFEATURES, SVGFEATURE_1_2_EDITABLE_ATTRIBUTE, "http://www.w3.org/Graphics/SVG/feature/1.2/#EditableTextAttribute", 65)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_VISIBLEPAINTED, "visiblePainted", 14)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_VISIBLEFILL, "visibleFill", 11)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_VISIBLESTROKE, "visibleStroke", 13)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_VISIBLE, "visible", 7)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_PAINTED, "painted", 7)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_FILL, "fill", 4)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_STROKE, "stroke", 6)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_ALL, "all", 3)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_POINTER_EVENTS, SVGPOINTEREVENTS_BOUNDINGBOX, "boundingBox", 11)
	SVG_ENUMS_ENTRY(SVGENUM_METHOD, SVGMETHOD_ALIGN, "align", 5)
	SVG_ENUMS_ENTRY(SVGENUM_METHOD, SVGMETHOD_STRETCH, "stretch", 7)
#ifdef SVG_SUPPORT_FILTERS
	SVG_ENUMS_ENTRY(SVGENUM_STITCHTILES, SVGSTITCH_STITCH, "stitch", 6)
	SVG_ENUMS_ENTRY(SVGENUM_STITCHTILES, SVGSTITCH_NOSTITCH, "noStitch", 8)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLACEMENTSELECTOR, SVGDISPLACEMENT_R, "R", 1)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLACEMENTSELECTOR, SVGDISPLACEMENT_G, "G", 1)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLACEMENTSELECTOR, SVGDISPLACEMENT_B, "B", 1)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLACEMENTSELECTOR, SVGDISPLACEMENT_A, "A", 1)
	SVG_ENUMS_ENTRY(SVGENUM_CONVOLVEEDGEMODE, SVGCONVOLVEEDGEMODE_DUPLICATE, "duplicate", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CONVOLVEEDGEMODE, SVGCONVOLVEEDGEMODE_WRAP, "wrap", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CONVOLVEEDGEMODE, SVGCONVOLVEEDGEMODE_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_OVER, "over", 4)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_IN, "in", 2)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_OUT, "out", 3)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_ATOP, "atop", 4)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_XOR, "xor", 3)
	SVG_ENUMS_ENTRY(SVGENUM_COMPOSITEOPERATOR, SVGCOMPOSITEOPERATOR_ARITHMETIC, "arithmetic", 10)
	SVG_ENUMS_ENTRY(SVGENUM_MORPHOLOGYOPERATOR, SVGMORPHOPERATOR_ERODE, "erode", 5)
	SVG_ENUMS_ENTRY(SVGENUM_MORPHOLOGYOPERATOR, SVGMORPHOPERATOR_DILATE, "dilate", 6)
	SVG_ENUMS_ENTRY(SVGENUM_BLENDMODE, SVGBLENDMODE_NORMAL, "normal", 6)
	SVG_ENUMS_ENTRY(SVGENUM_BLENDMODE, SVGBLENDMODE_MULTIPLY, "multiply", 8)
	SVG_ENUMS_ENTRY(SVGENUM_BLENDMODE, SVGBLENDMODE_SCREEN, "screen", 6)
	SVG_ENUMS_ENTRY(SVGENUM_BLENDMODE, SVGBLENDMODE_DARKEN, "darken", 6)
	SVG_ENUMS_ENTRY(SVGENUM_BLENDMODE, SVGBLENDMODE_LIGHTEN, "lighten", 7)
	SVG_ENUMS_ENTRY(SVGENUM_TURBULENCETYPE, SVGTURBULENCE_FRACTALNOISE, "fractalNoise", 12)
	SVG_ENUMS_ENTRY(SVGENUM_TURBULENCETYPE, SVGTURBULENCE_TURBULENCE, "turbulence", 10)
	SVG_ENUMS_ENTRY(SVGENUM_COLORMATRIXTYPE, SVGCOLORMATRIX_MATRIX, "matrix", 6)
	SVG_ENUMS_ENTRY(SVGENUM_COLORMATRIXTYPE, SVGCOLORMATRIX_SATURATE, "saturate", 8)
	SVG_ENUMS_ENTRY(SVGENUM_COLORMATRIXTYPE, SVGCOLORMATRIX_HUEROTATE, "hueRotate", 9)
	SVG_ENUMS_ENTRY(SVGENUM_COLORMATRIXTYPE, SVGCOLORMATRIX_LUMINANCETOALPHA, "luminanceToAlpha", 16)
	SVG_ENUMS_ENTRY(SVGENUM_FUNCTYPE, SVGFUNC_IDENTITY, "identity", 8)
	SVG_ENUMS_ENTRY(SVGENUM_FUNCTYPE, SVGFUNC_TABLE, "table", 5)
	SVG_ENUMS_ENTRY(SVGENUM_FUNCTYPE, SVGFUNC_DISCRETE, "discrete", 8)
	SVG_ENUMS_ENTRY(SVGENUM_FUNCTYPE, SVGFUNC_LINEAR, "linear", 6)
	SVG_ENUMS_ENTRY(SVGENUM_FUNCTYPE, SVGFUNC_GAMMA, "gamma", 5)
#endif // SVG_SUPPORT_FILTERS
	SVG_ENUMS_ENTRY(SVGENUM_BOOLEAN, FALSE, "false", 5)
	SVG_ENUMS_ENTRY(SVGENUM_BOOLEAN, TRUE, "true", 4)
	SVG_ENUMS_ENTRY(SVGENUM_LENGTHADJUST, SVGLENADJUST_SPACING, "spacing", 7)
	SVG_ENUMS_ENTRY(SVGENUM_LENGTHADJUST, SVGLENADJUST_SPACINGANDGLYPHS, "spacingAndGlyphs", 16)
	SVG_ENUMS_ENTRY(SVGENUM_TEXTDECORATION, SVGTEXTDECORATION_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_TEXTDECORATION, SVGTEXTDECORATION_UNDERLINE, "underline", 9)
	SVG_ENUMS_ENTRY(SVGENUM_TEXTDECORATION, SVGTEXTDECORATION_OVERLINE, "overline", 8)
	SVG_ENUMS_ENTRY(SVGENUM_TEXTDECORATION, SVGTEXTDECORATION_LINETHROUGH, "line-through", 12)
	SVG_ENUMS_ENTRY(SVGENUM_TEXTDECORATION, SVGTEXTDECORATION_BLINK, "blink", 5)
	SVG_ENUMS_ENTRY(SVGENUM_SPACING, SVGSPACING_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_SPACING, SVGSPACING_EXACT, "exact", 5)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_URI, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_CROSSHAIR, "crosshair", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_DEFAULT_ARROW, "default", 7)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_CUR_POINTER, "pointer", 7)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_MOVE, "move", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_E_RESIZE, "e-resize", 8)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_NE_RESIZE, "ne-resize", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_NW_RESIZE, "nw-resize", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_N_RESIZE, "n-resize", 8)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_SE_RESIZE, "se-resize", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_SW_RESIZE, "sw-resize", 9)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_S_RESIZE, "s-resize", 8)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_W_RESIZE, "w-resize", 8)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_TEXT, "text", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_WAIT, "wait", 4)
	SVG_ENUMS_ENTRY(SVGENUM_CURSOR, CURSOR_HELP, "help", 4)
	SVG_ENUMS_ENTRY(SVGENUM_OVERFLOW, CSS_VALUE_visible, "visible", 7)
	SVG_ENUMS_ENTRY(SVGENUM_OVERFLOW, CSS_VALUE_hidden, "hidden", 6)
	SVG_ENUMS_ENTRY(SVGENUM_OVERFLOW, CSS_VALUE_scroll, "scroll", 6)
	SVG_ENUMS_ENTRY(SVGENUM_OVERFLOW, CSS_VALUE_auto, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_UNICODE_BIDI, CSS_VALUE_normal, "normal", 6)
	SVG_ENUMS_ENTRY(SVGENUM_UNICODE_BIDI, CSS_VALUE_embed, "embed", 5)
	SVG_ENUMS_ENTRY(SVGENUM_UNICODE_BIDI, CSS_VALUE_bidi_override, "bidi-override", 13)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_LR_TB, "lr-tb", 5)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_RL_TB, "rl-tb", 5)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_TB_RL, "tb-rl", 5)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_LR, "lr", 2)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_RL, "rl", 2)
	SVG_ENUMS_ENTRY(SVGENUM_WRITING_MODE, SVGWRITINGMODE_TB, "tb", 2)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_BASELINE, "baseline", 8)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_BEFORE_EDGE, "before-edge", 11)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_TEXT_BEFORE_EDGE, "text-before-edge", 16)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_MIDDLE, "middle", 6)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_CENTRAL, "central", 7)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_AFTER_EDGE, "after-edge", 10)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_TEXT_AFTER_EDGE, "text-after-edge", 15)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_IDEOGRAPHIC, "ideographic", 11)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_ALPHABETIC, "alphabetic", 10)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_HANGING, "hanging", 7)
	SVG_ENUMS_ENTRY(SVGENUM_ALIGNMENT_BASELINE, SVGALIGNMENTBASELINE_MATHEMATICAL, "mathematical", 12)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_USE_SCRIPT, "use-script", 10)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_NO_CHANGE, "no-change", 9)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_RESET_SIZE, "reset-size", 10)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_IDEOGRAPHIC, "ideographic", 11)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_ALPHABETIC, "alphabetic", 10)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_HANGING, "hanging", 7)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_MATHEMATICAL, "mathematical", 12)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_CENTRAL, "central", 7)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_MIDDLE, "middle", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_TEXT_AFTER_EDGE, "text-after-edge", 15)
	SVG_ENUMS_ENTRY(SVGENUM_DOMINANT_BASELINE, SVGDOMINANTBASELINE_TEXT_BEFORE_EDGE, "text-before-edge", 16)
	SVG_ENUMS_ENTRY(SVGENUM_ARABIC_FORM, SVGARABICFORM_INITIAL, "initial", 7)
	SVG_ENUMS_ENTRY(SVGENUM_ARABIC_FORM, SVGARABICFORM_MEDIAL, "medial", 6)
	SVG_ENUMS_ENTRY(SVGENUM_ARABIC_FORM, SVGARABICFORM_TERMINAL, "terminal", 8)
	SVG_ENUMS_ENTRY(SVGENUM_ARABIC_FORM, SVGARABICFORM_ISOLATED, "isolated", 8)
	SVG_ENUMS_ENTRY(SVGENUM_DIRECTION, CSS_VALUE_ltr, "ltr", 3)
	SVG_ENUMS_ENTRY(SVGENUM_DIRECTION, CSS_VALUE_rtl, "rtl", 3)
	SVG_ENUMS_ENTRY(SVGENUM_IMAGE_RENDERING, SVGIMAGERENDERING_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_IMAGE_RENDERING, SVGIMAGERENDERING_OPTIMIZESPEED, "optimizeSpeed", 13)
	SVG_ENUMS_ENTRY(SVGENUM_IMAGE_RENDERING, SVGIMAGERENDERING_OPTIMIZEQUALITY, "optimizeQuality", 15)
	SVG_ENUMS_ENTRY(SVGENUM_MARKER_UNITS, SVGMARKERUNITS_STROKEWIDTH, "strokeWidth", 11)
	SVG_ENUMS_ENTRY(SVGENUM_MARKER_UNITS, SVGMARKERUNITS_USERSPACEONUSE, "userSpaceOnUse", 14)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_RENDERING, SVGTEXTRENDERING_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_RENDERING, SVGTEXTRENDERING_OPTIMIZESPEED, "optimizeSpeed", 13)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_RENDERING, SVGTEXTRENDERING_OPTIMIZELEGIBILITY, "optimizeLegibility", 18)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_RENDERING, SVGTEXTRENDERING_GEOMETRICPRECISION, "geometricPrecision", 18)
	SVG_ENUMS_ENTRY(SVGENUM_COLOR_INTERPOLATION, SVGCOLORINTERPOLATION_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_COLOR_INTERPOLATION, SVGCOLORINTERPOLATION_SRGB, "sRGB", 4)
	SVG_ENUMS_ENTRY(SVGENUM_COLOR_INTERPOLATION, SVGCOLORINTERPOLATION_LINEARRGB, "linearRGB", 9)
	SVG_ENUMS_ENTRY(SVGENUM_FOCUSABLE, SVGFOCUSABLE_TRUE, "true", 4)
	SVG_ENUMS_ENTRY(SVGENUM_FOCUSABLE, SVGFOCUSABLE_FALSE, "false", 5)
	SVG_ENUMS_ENTRY(SVGENUM_FOCUSABLE, SVGFOCUSABLE_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_VECTOR_EFFECT, SVGVECTOREFFECT_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_VECTOR_EFFECT, SVGVECTOREFFECT_NON_SCALING_STROKE, "non-scaling-stroke", 18)
	SVG_ENUMS_ENTRY(SVGENUM_FOCUSHIGHLIGHT, SVGFOCUSHIGHLIGHT_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_FOCUSHIGHLIGHT, SVGFOCUSHIGHLIGHT_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_INITIALVISIBILITY, SVGINITIALVISIBILITY_WHENSTARTED, "whenStarted", 11)
	SVG_ENUMS_ENTRY(SVGENUM_INITIALVISIBILITY, SVGINITIALVISIBILITY_ALWAYS, "always", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORMBEHAVIOR, SVGTRANSFORMBEHAVIOR_GEOMETRIC, "geometric", 9)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORMBEHAVIOR, SVGTRANSFORMBEHAVIOR_PINNED, "pinned", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORMBEHAVIOR, SVGTRANSFORMBEHAVIOR_PINNED90, "pinned90", 8)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORMBEHAVIOR, SVGTRANSFORMBEHAVIOR_PINNED180, "pinned180", 9)
	SVG_ENUMS_ENTRY(SVGENUM_TRANSFORMBEHAVIOR, SVGTRANSFORMBEHAVIOR_PINNED270, "pinned270", 9)
	SVG_ENUMS_ENTRY(SVGENUM_OVERLAY, SVGOVERLAY_TOP, "top", 3)
	SVG_ENUMS_ENTRY(SVGENUM_OVERLAY, SVGOVERLAY_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY_ALIGN, SVGDISPLAYALIGN_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY_ALIGN, SVGDISPLAYALIGN_BEFORE, "before", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY_ALIGN, SVGDISPLAYALIGN_CENTER, "center", 6)
	SVG_ENUMS_ENTRY(SVGENUM_DISPLAY_ALIGN, SVGDISPLAYALIGN_AFTER, "after", 5)
	SVG_ENUMS_ENTRY(SVGENUM_EDITABLE, SVGEDITABLE_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_EDITABLE, SVGEDITABLE_SIMPLE, "simple", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ALIGN, CSS_VALUE_start, "start", 5)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ALIGN, CSS_VALUE_center, "center", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_ALIGN, CSS_VALUE_end, "end", 3)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_OVERFLOW, CSS_VALUE_clip, "clip", 4)
	SVG_ENUMS_ENTRY(SVGENUM_TEXT_OVERFLOW, CSS_VALUE_ellipsis, "ellipsis", 8)
	SVG_ENUMS_ENTRY(SVGENUM_AUTO, SVGAUTO_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_SYNCBEHAVIOR, SVGSYNCBEHAVIOR_CANSLIP, "canSlip", 7)
	SVG_ENUMS_ENTRY(SVGENUM_SYNCBEHAVIOR, SVGSYNCBEHAVIOR_LOCKED, "locked", 6)
	SVG_ENUMS_ENTRY(SVGENUM_SYNCBEHAVIOR, SVGSYNCBEHAVIOR_INDEPENDENT, "independent", 11)
	SVG_ENUMS_ENTRY(SVGENUM_SYNCBEHAVIOR, SVGSYNCBEHAVIOR_DEFAULT, "default", 7)
	SVG_ENUMS_ENTRY(SVGENUM_SYNCBEHAVIOR, SVGSYNCBEHAVIOR_INHERIT, "inherit", 7)
	SVG_ENUMS_ENTRY(SVGENUM_NONE, SVGSNAPSHOTTIME_NONE, "none", 4)
	SVG_ENUMS_ENTRY(SVGENUM_SHAPE_RENDERING, SVGSHAPERENDERING_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_SHAPE_RENDERING, SVGSHAPERENDERING_OPTIMIZESPEED, "optimizeSpeed", 13)
	SVG_ENUMS_ENTRY(SVGENUM_SHAPE_RENDERING, SVGSHAPERENDERING_CRISPEDGES, "crispEdges", 10)
	SVG_ENUMS_ENTRY(SVGENUM_SHAPE_RENDERING, SVGSHAPERENDERING_GEOMETRICPRECISION, "geometricPrecision", 18)
	SVG_ENUMS_ENTRY(SVGENUM_BUFFERED_RENDERING, SVGBUFFEREDRENDERING_AUTO, "auto", 4)
	SVG_ENUMS_ENTRY(SVGENUM_BUFFERED_RENDERING, SVGBUFFEREDRENDERING_STATIC, "static", 6)
	SVG_ENUMS_ENTRY(SVGENUM_BUFFERED_RENDERING, SVGBUFFEREDRENDERING_DYNAMIC, "dynamic", 7)
	SVG_ENUMS_ENTRY(SVGENUM_TIMELINEBEGIN, SVGTIMELINEBEGIN_ONLOAD, "onLoad", 6)
	SVG_ENUMS_ENTRY(SVGENUM_TIMELINEBEGIN, SVGTIMELINEBEGIN_ONSTART, "onStart", 7)
SVG_ENUMS_END

#endif // SVG_SUPPORT
