/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 1995-2011 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.	It may not be distributed
 * under any circumstances.
 */

#include <core/pch.h>

#ifdef SECMAN_DOMOBJECT_ACCESS_RULES

#include "modules/security_manager/src/security_dom_object.h"
#ifdef GADGET_SUPPORT
# include "modules/security_manager/src/security_gadget.h"
# include "modules/gadgets/OpGadget.h"
#endif // GADGET_SUPPORT

#include "modules/dochand/winman_constants.h"
#include "modules/dochand/win.h"
#include "modules/windowcommander/src/WindowCommander.h"
#include "modules/device_api/jil/JILFeatures.h"

OpSecurityManager_DOMObject::OpSecurityManager_DOMObject()
{
}

OpSecurityManager_DOMObject::~OpSecurityManager_DOMObject()
{
}

// TODO: what about file and network access privileges?
#define ADD_SECURITY_RULE(domain, operation_name, permission, operation)					\
	LEAVE_IF_ERROR(AddSecurityRule(domain, operation_name, permission, OpPermissionListener::DOMPermissionCallback::OPERATION_TYPE_##operation));
#define ADD_FEATURE_RULE(feature_set, operation_name, feature_uri)	\
	LEAVE_IF_ERROR(AddFeatureRule(feature_set, operation_name, feature_uri))

OP_STATUS
OpSecurityManager_DOMObject::AddSecurityRule(OpSecurityManager_DOMObject::TrustDomain trust_domain,
											 const char* operation_name,
											 OpSecurityManager_DOMObject::SecurityPermission permission,
											 OpPermissionListener::DOMPermissionCallback::OperationType operation_type)
{
	SecurityRule* to_add = OP_NEW_L(SecurityRule, ());
	to_add->permission = permission;
	to_add->operation_type = operation_type;
	OP_STATUS add_status = rulesets[static_cast<int>(trust_domain)].Add(operation_name, to_add);
	if (OpStatus::IsError(add_status))
	{
		OP_DELETE(to_add);
		return add_status;
	}
	return OpStatus::OK;
}

OP_STATUS
OpSecurityManager_DOMObject::AddFeatureRule(OpSecurityManager_DOMObject::FeatureSet feature_set,
											const char* operation_name,
											const char* feature_uri)
{
	return features[feature_set].Add(operation_name, feature_uri);
}

#ifdef SELFTEST
OP_STATUS
OpSecurityManager_DOMObject::RemoveSecurityRule(OpSecurityManager_DOMObject::TrustDomain trust_domain, const char* operation_name)
{
	SecurityRule* removed_rule;
	RETURN_IF_ERROR(rulesets[static_cast<int>(trust_domain)].Remove(operation_name, &removed_rule));
	OP_DELETE(removed_rule);
	return OpStatus::OK;
}

OP_STATUS
OpSecurityManager_DOMObject::RemoveFeatureRule(OpSecurityManager_DOMObject::FeatureSet feature_set, const char* operation_name)
{
	return features[static_cast<int>(feature_set)].Remove(operation_name);
}
#endif // SELFTEST

void
OpSecurityManager_DOMObject::ConstructL()
{
#ifdef DOM_JIL_API_SUPPORT

	// Domain TRUST_DOMAIN_WIDGET_UNSIGNED
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "AccountInfo.phoneMSISDN"				, DISALLOWED, JIL_ACCOUNTINFO_PHONEMSISDN);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "AccountInfo.userSubscriptionType"		, ACCESS_PERSISTENT, JIL_ACCOUNTINFO_USERSUBSCRIPTIONTYPE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "AccountInfo.userAccountBalance"		, ACCESS_PERSISTENT, JIL_ACCOUNTINFO_USERACCOUNTBALANCE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "AddressBookItem.update"				, INVOCATION_ONE_SHOT, JIL_ADDRESSBOOKITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "CalendarItem.update"					, INVOCATION_ONE_SHOT, JIL_CALENDARITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Camera.captureImage"					, INVOCATION_ONE_SHOT, JIL_CAMERA_CAPTUREIMAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Camera.startVideoCapture"				, INVOCATION_ONE_SHOT, JIL_CAMERA_STARTVIDEOCAPTURE);


	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Config.msgRingtoneVolume"				, ACCESS_ONE_SHOT, JIL_CONFIG_MSGRINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Config.ringtoneVolume"					, ACCESS_ONE_SHOT, JIL_CONFIG_RINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Config.vibrationSetting"				, ACCESS_ONE_SHOT, JIL_CONFIG_VIBRATIONSETTING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Config.setAsWallpaper"						, INVOCATION_ONE_SHOT, JIL_CONFIG_SETASWALLPAPER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Config.setDefaultRingtone"				, INVOCATION_ONE_SHOT, JIL_CONFIG_SETDEFAULTRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.clipboardString"					, ACCESS_SESSION, JIL_DEVICE_CLIPBOARDSTRING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.copyFile"						, INVOCATION_ONE_SHOT, JIL_DEVICE_COPYFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.deleteFile"						, INVOCATION_ONE_SHOT, JIL_DEVICE_DELETEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.findFiles"						, INVOCATION_SESSION, JIL_DEVICE_FINDFILES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.getAvailableApplications"		, INVOCATION_PERSISTENT, JIL_DEVICE_GETAVAILABLEAPPLICATIONS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.getDirectoryFileNames"			, INVOCATION_PERSISTENT, JIL_DEVICE_GETDIRECTORYFILENAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.getFile"							, INVOCATION_ONE_SHOT, JIL_DEVICE_GETFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.getFileSystemRoots"				, INVOCATION_PERSISTENT, JIL_DEVICE_GETFILESYSTEMROOTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.launchApplication"				, INVOCATION_ONE_SHOT, JIL_DEVICE_LAUNCHAPPLICATION);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.moveFile"							, INVOCATION_ONE_SHOT, JIL_DEVICE_MOVEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Device.setRingtone"						, INVOCATION_ONE_SHOT, JIL_DEVICE_SETRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "DeviceInfo.ownerInfo"					, DISALLOWED, JIL_DEVICEINFO_OWNERINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "DeviceStateInfo.requestPositionInfo"	, INVOCATION_ONE_SHOT, JIL_DEVICESTATEINFO_REQUESTPOSITIONINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Message.deleteAddress"                 , DISALLOWED, JIL_MESSAGE_DELETEADDRESS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Message.deleteAttachment"              , DISALLOWED, JIL_MESSAGE_DELETEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Message.saveAttachment"                , INVOCATION_ONE_SHOT, JIL_MESSAGE_SAVEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.copyMessageToFolder"         , INVOCATION_SESSION, JIL_MESSAGING_COPYMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.createFolder"                , INVOCATION_ONE_SHOT, JIL_MESSAGING_CREATEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.deleteAllMessages"           , DISALLOWED, JIL_MESSAGING_DELETEALLMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.deleteEmailAccount"          , DISALLOWED, JIL_MESSAGING_DELETEEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.deleteFolder"                , DISALLOWED, JIL_MESSAGING_DELETEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.deleteMessage"               , DISALLOWED, JIL_MESSAGING_DELETEMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.findMessages"                , INVOCATION_SESSION, JIL_MESSAGING_FINDMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.getCurrentEmailAccount"      , INVOCATION_SESSION, JIL_MESSAGING_GETCURRENTEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.getEmailAccounts"            , INVOCATION_SESSION, JIL_MESSAGING_GETEMAILACCOUNTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.getFolderNames"              , INVOCATION_SESSION, JIL_MESSAGING_GETFOLDERNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.getMessage"                  , INVOCATION_SESSION, JIL_MESSAGING_GETMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.moveMessageToFolder"         , INVOCATION_SESSION, JIL_MESSAGING_MOVEMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.sendMessage"                 , INVOCATION_ONE_SHOT, JIL_MESSAGING_SENDMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Messaging.setCurrentEmailAccount"      , INVOCATION_SESSION, JIL_MESSAGING_SETCURRENTEMAILACCOUNT);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.addAddressBookItem"					, INVOCATION_ONE_SHOT, JIL_PIM_ADDADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.addCalendarItem"					, INVOCATION_ONE_SHOT, JIL_PIM_ADDCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.createAddressBookGroup"				, INVOCATION_ONE_SHOT, JIL_PIM_CREATEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.deleteAddressBookGroup"				, DISALLOWED, JIL_PIM_DELETEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.deleteAddressBookItem"				, DISALLOWED, JIL_PIM_DELETEADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.deleteCalendarItem"					, DISALLOWED, JIL_PIM_DELETECALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.exportAsVCard"						, INVOCATION_ONE_SHOT, JIL_PIM_EXPORTASVCARD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.findAddressBookItems"				, INVOCATION_SESSION, JIL_PIM_FINDADDRESSBOOKITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.findCalendarItems"					, INVOCATION_SESSION, JIL_PIM_FINDCALENDARITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getAddressBookGroupMembers"			, INVOCATION_ONE_SHOT, JIL_PIM_GETADDRESSBOOKGROUPMEMBERS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getAddressBookItem"					, INVOCATION_ONE_SHOT, JIL_PIM_GETADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getAddressBookItemsCount"			, INVOCATION_SESSION, JIL_PIM_GETADDRESSBOOKITEMSCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getAvailableAddressGroupNames"		, INVOCATION_SESSION, JIL_PIM_GETAVAILABLEADDRESSGROUPNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getCalendarItem"					, INVOCATION_SESSION, JIL_PIM_GETCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "PIM.getCalendarItems"					, INVOCATION_SESSION, JIL_PIM_GETCALENDARITEMS);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.deleteAllCallRecords"        , DISALLOWED, JIL_TELEPHONY_DELETEALLCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.deleteCallRecord"            , DISALLOWED, JIL_TELEPHONY_DELETECALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.findCallRecords"             , INVOCATION_SESSION, JIL_TELEPHONY_FINDCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.getCallRecord"               , INVOCATION_ONE_SHOT, JIL_TELEPHONY_GETCALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.getCallRecordCnt"            , INVOCATION_SESSION, JIL_TELEPHONY_GETCALLRECORDCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "Telephony.initiateVoiceCall"           , INVOCATION_ONE_SHOT, JIL_TELEPHONY_INITIATEVOICECALL);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "XmlHttpRequest"							, ACCESS_SESSION, XMLHTTPREQUEST);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_UNSIGNED, "WidgetManager.checkWidgetInstallationStatus", INVOCATION_SESSION, JIL_WIDGETMANAGER_CHECKWIDGETINSTALLATIONSTATUS);
	// ~Domain TRUST_DOMAIN_WIDGET_UNSIGNED


	// Domain TRUST_DOMAIN_WIDGET_SIGNED
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "AccountInfo.phoneMSISDN"					, ACCESS_ONE_SHOT, JIL_ACCOUNTINFO_PHONEMSISDN);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "AccountInfo.userSubscriptionType"			, ACCESS_PERSISTENT, JIL_ACCOUNTINFO_USERSUBSCRIPTIONTYPE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "AccountInfo.userAccountBalance"			, ACCESS_PERSISTENT, JIL_ACCOUNTINFO_USERACCOUNTBALANCE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "AddressBookItem.update"					, INVOCATION_PERSISTENT, JIL_ADDRESSBOOKITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "CalendarItem.update"						, INVOCATION_PERSISTENT, JIL_CALENDARITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Camera.captureImage"						, INVOCATION_PERSISTENT, JIL_CAMERA_CAPTUREIMAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Camera.startVideoCapture"					, INVOCATION_PERSISTENT, JIL_CAMERA_STARTVIDEOCAPTURE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Config.msgRingtoneVolume"				, ACCESS_SESSION, JIL_CONFIG_MSGRINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Config.ringtoneVolume"					, ACCESS_SESSION, JIL_CONFIG_RINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Config.vibrationSetting"				, ACCESS_SESSION, JIL_CONFIG_VIBRATIONSETTING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Config.setAsWallpaper"					, INVOCATION_PERSISTENT, JIL_CONFIG_SETASWALLPAPER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Config.setDefaultRingtone"				, INVOCATION_PERSISTENT, JIL_CONFIG_SETDEFAULTRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.clipboardString"					, ALLOWED, JIL_DEVICE_CLIPBOARDSTRING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.copyFile"							, INVOCATION_PERSISTENT, JIL_DEVICE_COPYFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.deleteFile"						, INVOCATION_PERSISTENT, JIL_DEVICE_DELETEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.findFiles"							, INVOCATION_PERSISTENT, JIL_DEVICE_FINDFILES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.getAvailableApplications"			, ALLOWED, JIL_DEVICE_GETAVAILABLEAPPLICATIONS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.getDirectoryFileNames"				, INVOCATION_PERSISTENT, JIL_DEVICE_GETDIRECTORYFILENAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.getFile"							, INVOCATION_PERSISTENT, JIL_DEVICE_GETFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.getFileSystemRoots"				, ALLOWED, JIL_DEVICE_GETFILESYSTEMROOTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.launchApplication"					, INVOCATION_PERSISTENT, JIL_DEVICE_LAUNCHAPPLICATION);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.moveFile"							, INVOCATION_PERSISTENT, JIL_DEVICE_MOVEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Device.setRingtone"						, INVOCATION_PERSISTENT, JIL_DEVICE_SETRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "DeviceInfo.ownerInfo"						, ACCESS_ONE_SHOT, JIL_DEVICEINFO_OWNERINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "DeviceStateInfo.requestPositionInfo"		, INVOCATION_SESSION, JIL_DEVICESTATEINFO_REQUESTPOSITIONINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Message.deleteAddress"                   , INVOCATION_ONE_SHOT, JIL_MESSAGE_DELETEADDRESS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Message.deleteAttachment"                , INVOCATION_ONE_SHOT, JIL_MESSAGE_DELETEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Message.saveAttachment"                  , INVOCATION_SESSION, JIL_MESSAGE_SAVEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.copyMessageToFolder"           , INVOCATION_PERSISTENT, JIL_MESSAGING_COPYMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.createFolder"                  , INVOCATION_PERSISTENT, JIL_MESSAGING_CREATEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.deleteAllMessages"             , INVOCATION_ONE_SHOT, JIL_MESSAGING_DELETEALLMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.deleteEmailAccount"            , INVOCATION_ONE_SHOT, JIL_MESSAGING_DELETEEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.deleteFolder"                  , INVOCATION_ONE_SHOT, JIL_MESSAGING_DELETEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.deleteMessage"                 , INVOCATION_ONE_SHOT, JIL_MESSAGING_DELETEMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.findMessages"                  , INVOCATION_PERSISTENT, JIL_MESSAGING_FINDMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.getCurrentEmailAccount"        , INVOCATION_PERSISTENT, JIL_MESSAGING_GETCURRENTEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.getEmailAccounts"              , INVOCATION_PERSISTENT, JIL_MESSAGING_GETEMAILACCOUNTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.getFolderNames"                , INVOCATION_PERSISTENT, JIL_MESSAGING_GETFOLDERNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.getMessage"                    , INVOCATION_PERSISTENT, JIL_MESSAGING_GETMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.moveMessageToFolder"           , INVOCATION_PERSISTENT, JIL_MESSAGING_MOVEMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.sendMessage"                   , INVOCATION_PERSISTENT, JIL_MESSAGING_SENDMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Messaging.setCurrentEmailAccount"        , ALLOWED, JIL_MESSAGING_SETCURRENTEMAILACCOUNT);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.addAddressBookItem"					, INVOCATION_PERSISTENT, JIL_PIM_ADDADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.addCalendarItem"						, INVOCATION_PERSISTENT, JIL_PIM_ADDCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.createAddressBookGroup"				, INVOCATION_PERSISTENT, JIL_PIM_CREATEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.deleteAddressBookGroup"				, INVOCATION_ONE_SHOT, JIL_PIM_DELETEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.deleteAddressBookItem"				, INVOCATION_ONE_SHOT, JIL_PIM_DELETEADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.deleteCalendarItem"					, INVOCATION_ONE_SHOT, JIL_PIM_DELETECALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.exportAsVCard"						, INVOCATION_PERSISTENT, JIL_PIM_EXPORTASVCARD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.findAddressBookItems"					, INVOCATION_PERSISTENT, JIL_PIM_FINDADDRESSBOOKITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.findCalendarItems"					, INVOCATION_PERSISTENT, JIL_PIM_FINDCALENDARITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getAddressBookItem"					, INVOCATION_PERSISTENT, JIL_PIM_GETADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getAddressBookItemsCount"				, INVOCATION_PERSISTENT, JIL_PIM_GETADDRESSBOOKITEMSCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getAddressBookGroupMembers"			, INVOCATION_PERSISTENT, JIL_PIM_GETADDRESSBOOKGROUPMEMBERS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getAvailableAddressGroupNames"		, INVOCATION_PERSISTENT, JIL_PIM_GETAVAILABLEADDRESSGROUPNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getCalendarItem"						, INVOCATION_PERSISTENT, JIL_PIM_GETCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "PIM.getCalendarItems"						, INVOCATION_PERSISTENT, JIL_PIM_GETCALENDARITEMS);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.deleteAllCallRecords"          , INVOCATION_ONE_SHOT, JIL_TELEPHONY_DELETEALLCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.deleteCallRecord"              , INVOCATION_ONE_SHOT, JIL_TELEPHONY_DELETECALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.findCallRecords"               , INVOCATION_PERSISTENT, JIL_TELEPHONY_FINDCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.getCallRecord"                 , INVOCATION_PERSISTENT, JIL_TELEPHONY_GETCALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.getCallRecordCnt"              , ALLOWED, JIL_TELEPHONY_GETCALLRECORDCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "Telephony.initiateVoiceCall"             , INVOCATION_ONE_SHOT, JIL_TELEPHONY_INITIATEVOICECALL);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "XmlHttpRequest"							, ALLOWED, XMLHTTPREQUEST);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_SIGNED, "WidgetManager.checkWidgetInstallationStatus", ALLOWED, JIL_WIDGETMANAGER_CHECKWIDGETINSTALLATIONSTATUS);
	// ~Domain TRUST_DOMAIN_WIDGET_SIGNED

	// Domain TRUST_DOMAIN_WIDGET_PRIVILEGED
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "AccountInfo.phoneMSISDN",				ALLOWED, JIL_ACCOUNTINFO_PHONEMSISDN);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "AccountInfo.userSubscriptionType",		ALLOWED, JIL_ACCOUNTINFO_USERSUBSCRIPTIONTYPE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "AccountInfo.userAccountBalance",			ALLOWED, JIL_ACCOUNTINFO_USERACCOUNTBALANCE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "AddressBookItem.update",					ALLOWED, JIL_ADDRESSBOOKITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "CalendarItem.update",					ALLOWED, JIL_CALENDARITEM_UPDATE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Camera.captureImage",					ALLOWED, JIL_CAMERA_CAPTUREIMAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Camera.startVideoCapture",				ALLOWED, JIL_CAMERA_STARTVIDEOCAPTURE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Config.msgRingtoneVolume"				, ACCESS_PERSISTENT, JIL_CONFIG_MSGRINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Config.ringtoneVolume"					, ACCESS_PERSISTENT, JIL_CONFIG_RINGTONEVOLUME);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Config.vibrationSetting"				, ACCESS_PERSISTENT, JIL_CONFIG_VIBRATIONSETTING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Config.setAsWallpaper",					INVOCATION_PERSISTENT, JIL_CONFIG_SETASWALLPAPER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Config.setDefaultRingtone",				INVOCATION_PERSISTENT, JIL_CONFIG_SETDEFAULTRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.clipboardString",					ALLOWED, JIL_DEVICE_CLIPBOARDSTRING);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.copyFile",						ALLOWED, JIL_DEVICE_COPYFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.deleteFile",						ALLOWED, JIL_DEVICE_DELETEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.findFiles",						ALLOWED, JIL_DEVICE_FINDFILES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.getAvailableApplications",		ALLOWED, JIL_DEVICE_GETAVAILABLEAPPLICATIONS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.getDirectoryFileNames",			ALLOWED, JIL_DEVICE_GETDIRECTORYFILENAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.getFile",							ALLOWED, JIL_DEVICE_GETFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.getFileSystemRoots",			ALLOWED, JIL_DEVICE_GETFILESYSTEMROOTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.launchApplication",				ALLOWED, JIL_DEVICE_LAUNCHAPPLICATION);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.moveFile",						ALLOWED, JIL_DEVICE_MOVEFILE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Device.setRingtone",						ALLOWED, JIL_DEVICE_SETRINGTONE);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "DeviceInfo.ownerInfo",					ALLOWED, JIL_DEVICEINFO_OWNERINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "DeviceStateInfo.requestPositionInfo",	ALLOWED, JIL_DEVICESTATEINFO_REQUESTPOSITIONINFO);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Message.deleteAddress"                  , ALLOWED, JIL_MESSAGE_DELETEADDRESS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Message.deleteAttachment"               , ALLOWED, JIL_MESSAGE_DELETEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Message.saveAttachment"                 , INVOCATION_PERSISTENT, JIL_MESSAGE_SAVEATTACHMENT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.copyMessageToFolder"          , ALLOWED, JIL_MESSAGING_COPYMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.createFolder"                 , ALLOWED, JIL_MESSAGING_CREATEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.deleteAllMessages"            , ALLOWED, JIL_MESSAGING_DELETEALLMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.deleteEmailAccount"           , ALLOWED, JIL_MESSAGING_DELETEEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.deleteFolder"                 , ALLOWED, JIL_MESSAGING_DELETEFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.deleteMessage"                , ALLOWED, JIL_MESSAGING_DELETEMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.findMessages"                 , ALLOWED, JIL_MESSAGING_FINDMESSAGES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.getCurrentEmailAccount"       , ALLOWED, JIL_MESSAGING_GETCURRENTEMAILACCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.getEmailAccounts"             , ALLOWED, JIL_MESSAGING_GETEMAILACCOUNTS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.getFolderNames"               , ALLOWED, JIL_MESSAGING_GETFOLDERNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.getMessage"                   , ALLOWED, JIL_MESSAGING_GETMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.moveMessageToFolder"          , ALLOWED, JIL_MESSAGING_MOVEMESSAGETOFOLDER);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.sendMessage"                  , ALLOWED, JIL_MESSAGING_SENDMESSAGE);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Messaging.setCurrentEmailAccount"       , ALLOWED, JIL_MESSAGING_SETCURRENTEMAILACCOUNT);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.addAddressBookItem"					, ALLOWED, JIL_PIM_ADDADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.addCalendarItem"					, ALLOWED, JIL_PIM_ADDCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.createAddressBookGroup"				, ALLOWED, JIL_PIM_CREATEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.deleteAddressBookGroup"				, ALLOWED, JIL_PIM_DELETEADDRESSBOOKGROUP);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.deleteAddressBookItem"				, ALLOWED, JIL_PIM_DELETEADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.deleteCalendarItem"					, ALLOWED, JIL_PIM_DELETECALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.exportAsVCard"						, ALLOWED, JIL_PIM_EXPORTASVCARD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.findAddressBookItems"				, ALLOWED, JIL_PIM_FINDADDRESSBOOKITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.findCalendarItems"					, ALLOWED, JIL_PIM_FINDCALENDARITEMS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getAddressBookGroupMembers"			, ALLOWED, JIL_PIM_GETADDRESSBOOKGROUPMEMBERS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getAddressBookItem"					, ALLOWED, JIL_PIM_GETADDRESSBOOKITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getAddressBookItemsCount"			, ALLOWED, JIL_PIM_GETADDRESSBOOKITEMSCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getAvailableAddressGroupNames"		, ALLOWED, JIL_PIM_GETAVAILABLEADDRESSGROUPNAMES);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getCalendarItem"					, ALLOWED, JIL_PIM_GETCALENDARITEM);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "PIM.getCalendarItems"					, ALLOWED, JIL_PIM_GETCALENDARITEMS);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.deleteAllCallRecords"          , ALLOWED, JIL_TELEPHONY_DELETEALLCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.deleteCallRecord"              , ALLOWED, JIL_TELEPHONY_DELETECALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.findCallRecords"               , ALLOWED, JIL_TELEPHONY_FINDCALLRECORDS);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.getCallRecord"                 , ALLOWED, JIL_TELEPHONY_GETCALLRECORD);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.getCallRecordCnt"              , ALLOWED, JIL_TELEPHONY_GETCALLRECORDCOUNT);
	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "Telephony.initiateVoiceCall"             , ALLOWED, JIL_TELEPHONY_INITIATEVOICECALL);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "XmlHttpRequest"							, ALLOWED, XMLHTTPREQUEST);

	ADD_SECURITY_RULE(TRUST_DOMAIN_WIDGET_PRIVILEGED, "WidgetManager.checkWidgetInstallationStatus", ALLOWED, JIL_WIDGETMANAGER_CHECKWIDGETINSTALLATIONSTATUS);
	// ~Domain TRUST_DOMAIN_WIDGET_PRIVILEGED


	// JIL 1.0-1.1 features
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "AccountInfo.phoneUserUniqueId"              , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ACCOUNTINFO_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "AccountInfo.phoneMSISDN"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ACCOUNTINFO_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "AccountInfo.userSubscriptionType"           , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ACCOUNTINFO_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "AccountInfo.userAccountBalance"             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ACCOUNTINFO_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "AddressBookItem.update"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "CalendarItem.update"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Camera.captureImage"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CAMERA_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Camera.startVideoCapture"                   , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CAMERA_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Camera.stopVideoCapture"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CAMERA_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Camera.onCameraCaptured"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CAMERA_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Config.setAsWallpaper"                      , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CONFIG_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Config.setDefaultRingtone"                  , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CONFIG_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.copyFile"                            , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.deleteFile"                          , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.findFiles"                           , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.getDirectoryFileNames"               , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.getFile"                             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.moveFile"                            , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILESYSTEM_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.getAvailableApplications"            , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_APPLICATION_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.launchApplication"                   , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_APPLICATION_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.setRingtone"                         , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CONFIG_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Device.clipboardString"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CLIPBOARD_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "DeviceInfo.ownerInfo"                       , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_DEVICEINFO_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "DeviceStateInfo.requestPositionInfo"        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_LOCATION_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.copyMessageToFolder"              , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.createFolder"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.deleteAllMessages"                , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.deleteEmailAccount"               , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.deleteFolder"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.deleteMessage"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.findMessages"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.getCurrentEmailAccount"           , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.getEmailAccounts"                 , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.getFolderNames"                   , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.getMessage"                       , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.getMessageQuantities"             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.moveMessageToFolder"              , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.sendMessage"                      , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Messaging.setCurrentEmailAccount"           , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGING_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.addCalendarItem"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getAddressBookGroupMembers"             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.deleteCalendarItem"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.findCalendarItems"                      , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getCalendarItem"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getCalendarItems"                       , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDAR_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.exportAsVCard"                          , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.addAddressBookItem"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.findAddressBookItems"                   , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.createAddressBookGroup"                 , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.deleteAddressBookGroup"                 , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.deleteAddressBookItem"                  , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getAddressBookItem"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getAddressBookItemsCount"               , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "PIM.getAvailableAddressGroupNames"          , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOK_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.deleteAllCallRecords"             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.deleteCallRecord"                 , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.findCallRecords"                  , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.getCallRecord"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.getCallRecordCnt"                 , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));
	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "Telephony.initiateVoiceCall"                , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_TELEPHONY_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "XmlHttpRequest"                             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_XMLHTTPREQUEST_1_1));

	ADD_FEATURE_RULE(FEATURE_SET_JIL_1_0, "WidgetManager.checkWidgetInstallationStatus", JILFeatures::GetFeatureURI(JILFeatures::JIL_API_WIDGETMANAGER_1_1));
	// ~JIL 1.0-1.1 features

	// JIL 1.2 features
	// Because in JIL 1.2 objects not defined by features are not created, only those functions/properties
	// are defined here that result in creation of other objects
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Exception.type"                             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_EXCEPTION));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Device.getFile"                             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_FILE));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "DeviceInfo.ownerInfo"                       , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOKITEM));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "DeviceStateInfo.requestPositionInfo"        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_POSITIONINFO));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Messaging.createMessage"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGE));
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Messaging.getCurrentEmailAccount"           , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ACCOUNT));
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Messaging.getMessage"                       , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGE));
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Messaging.getMessageQuantities"             , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_MESSAGEQUANTITIES));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Message.attachments"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ATTACHMENT));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "PIM.createAddressBookItem"                  , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOKITEM));
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "PIM.getAddressBookItem"                     , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_ADDRESSBOOKITEM));
	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "PIM.getCalendarItem"                        , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALENDARITEM));

	ADD_FEATURE_RULE(FEATURE_SET_REGULAR, "Telephony.getCallRecord"                    , JILFeatures::GetFeatureURI(JILFeatures::JIL_API_CALLRECORD));
	// ~JIL 1.2 features

#endif // DOM_JIL_API_SUPPORT
}
#undef ADD_SECURITY_RULE
#undef ADD_FEATURE_RULE

OpSecurityManager_DOMObject::TrustDomain
OpSecurityManager_DOMObject::GetTrustDomain(const OpSecurityContext& security_context) const
{
#ifdef GADGET_SUPPORT
	if (security_context.IsGadget())
	{
		return GetTrustDomain(security_context.GetGadget());
	}
#endif // GADGET_SUPPORT

	return TRUST_DOMAIN_NO_WIDGET;
}

#ifdef GADGET_SUPPORT
OpSecurityManager_DOMObject::TrustDomain
OpSecurityManager_DOMObject::GetTrustDomain(OpGadget* gadget) const
{
	OP_ASSERT(gadget);

	OpGadgetClass* gadget_class = gadget->GetClass();

	OP_ASSERT(gadget_class->SignatureState() != GADGET_SIGNATURE_UNKNOWN);
#ifdef GADGET_PRIVILEGED_SIGNING_SUPPORT
	if (gadget_class->SignatureState() == GADGET_SIGNATURE_SIGNED)
		return gadget_class->IsSignedWithPrivilegedCert() ? TRUST_DOMAIN_WIDGET_PRIVILEGED : TRUST_DOMAIN_WIDGET_SIGNED;
	else
		return TRUST_DOMAIN_WIDGET_UNSIGNED;
#else
	return (gadget_class->SignatureState() == GADGET_SIGNATURE_SIGNED) ? TRUST_DOMAIN_WIDGET_SIGNED : TRUST_DOMAIN_WIDGET_UNSIGNED;
#endif // GADGET_PRIVILEGED_SIGNING_SUPPORT
}

BOOL
OpSecurityManager_DOMObject::HasRequiredFeature(OpGadget* gadget, const char* operation_name) const
{
	OP_ASSERT(gadget);

	FeatureSet feature_set = gadget->GetClass()->SupportsNamespace(GADGETNS_JIL_1_0) ? FEATURE_SET_JIL_1_0 : FEATURE_SET_REGULAR;

	if (feature_set < FEATURE_SET_LAST)
	{
		const char* feature_uri = NULL;
		OP_STATUS get_status = features[feature_set].GetData(operation_name, &feature_uri);
		if (OpStatus::IsError(get_status))
			return TRUE;	// No feature required

		return (!gadget->HasFeatureTagSupport() || gadget->IsFeatureRequested(feature_uri));
	}
	else
	{
		OP_ASSERT(FALSE);
		return FALSE;
	}
}
#endif // GADGET_SUPPORT

class OpSecurityDialogCallback : public OpPermissionListener::DOMPermissionCallback
{
private:
	enum
	{
		ARGUMENT_1,
		ARGUMENT_2
	};
public:
	OpSecurityDialogCallback(OpSecurityCheckCallback* security_callback, OperationType operation_type, OpSecurityPersistenceProvider* persistence_provider, ChoicePersistenceType available_persistence_choice)
		: persistence_provider(persistence_provider)
		, operation_type(operation_type)
		, security_callback(security_callback)
		, is_async(FALSE)
		, is_finished(FALSE)
		, number_of_arguments(0)
	{
		OP_ASSERT(persistence_provider);
		OP_ASSERT(security_callback);
		SetAvailableChoices(available_persistence_choice);
	}

	~OpSecurityDialogCallback()
	{
		OP_DELETE(persistence_provider);
	}

	virtual void OnAllowed(PersistenceType persistence)
	{
		ProcessChoice(persistence, TRUE);
	}

	virtual void OnDisallowed(PersistenceType persistence)
	{
		ProcessChoice(persistence, FALSE);
	}

	virtual PermissionType Type()			{ return PERMISSION_TYPE_DOM_ACCESS_REQUEST; }
	virtual const uni_char* GetURL()		{ return url.CStr(); }
	virtual OperationType GetOperation()	{ return operation_type; }
	virtual int AffirmativeChoices()		{ return affirmative_choices; }
	virtual int NegativeChoices()			{ return negative_choices; }

	void SetAsync() { is_async = TRUE;}
	BOOL IsFinished() { return is_finished;}

	virtual const uni_char* GetArgument(unsigned int index)
	{
		OP_ASSERT(index < number_of_arguments);
		switch (index)
		{
			case ARGUMENT_1:
				return argument1.CStr();
			case ARGUMENT_2:
				return argument2.CStr();
			default:
				{
					OP_ASSERT(!"Wrong argument index");
					return NULL;
				}
		}
	}
	virtual unsigned int GetNumberOfArguments() { return number_of_arguments; }

	/** Sets operation name and (optional) arguments in the callback.
	 *
	 * The values are copied so that they are available when the callback is called.
	 */
	OP_STATUS SetOperationNameAndArgs(const char* operation_name_, const uni_char* argument1_, const uni_char* argument2_)
	{
		RETURN_IF_ERROR(operation_name.Set(operation_name_));

		number_of_arguments = 0;
		OP_ASSERT(argument1_ || (!argument1_ && !argument2_));
		if (argument1_)
			++number_of_arguments;
		if (argument2_)
			++number_of_arguments;

		RETURN_IF_ERROR(argument1.Set(argument1_));
		RETURN_IF_ERROR(argument2.Set(argument2_));
		return OpStatus::OK;
	}

	/**
	 * Sets the url for the permission callback.
	 * @param url is the url of the associated document that requests
	 *   the permission callback. This url is returned by
	 *   OpPermissionListener::PermissionCallback::GetURL(). The
	 *   string is used to be displayed in the ui dialog.
	 */
	OP_STATUS SetURL(const uni_char* url) { return this->url.Set(url); }

protected:

	void ProcessChoice(PersistenceType persistence, BOOL allowed)
	{
		persistence_provider->SetIsAllowed(allowed, ToChoicePersistence(persistence));

		security_callback->OnSecurityCheckSuccess(allowed);
		OP_DELETE(this);
	}

private:
	void SetAvailableChoices(ChoicePersistenceType available_persistence_choice)
	{
		// According to: Vodafone Widget User Agent Security Requirements Version 0.3, Section: User Prompting
		switch(available_persistence_choice)
		{
		case PERSISTENCE_NONE:
			negative_choices = PERSISTENCE_TYPE_NONE | PERSISTENCE_TYPE_ALWAYS;
			affirmative_choices = PERSISTENCE_TYPE_NONE;
			break;
		case PERSISTENCE_SESSION:
			negative_choices = PERSISTENCE_TYPE_SESSION | PERSISTENCE_TYPE_ALWAYS;
			affirmative_choices = PERSISTENCE_TYPE_SESSION;
			break;
		case PERSISTENCE_FULL:
			negative_choices = PERSISTENCE_TYPE_ALWAYS;
			affirmative_choices = PERSISTENCE_TYPE_ALWAYS;
			break;
		}
	}

	OpSecurityPersistenceProvider* persistence_provider;
	OpString url;
	OpString8 operation_name;
	OpString argument1;
	OpString argument2;
	OperationType operation_type;
	OpSecurityCheckCallback* security_callback;
	BOOL is_async;
	BOOL is_finished;
	int affirmative_choices;
	int negative_choices;
	unsigned number_of_arguments;
};

void
OpSecurityManager_DOMObject::AskForConfirmation(OpSecurityCheckCallback* security_callback, WindowCommander* win_cmd,
												const char* operation_name, OpPermissionListener::DOMPermissionCallback::OperationType operation_type,
												OpSecurityPersistenceProvider* persistence_provider, ChoicePersistenceType persistence,
												const uni_char* argument1, const uni_char* argument2, const uni_char* url)
{
	OP_ASSERT(win_cmd);
	OP_ASSERT(operation_name);
	OP_ASSERT(persistence_provider);
	OP_ASSERT(security_callback);
	OpPermissionListener* listener = win_cmd->GetPermissionListener();
	OpAutoPtr<OpSecurityPersistenceProvider> ap_persistence_provider(persistence_provider);	// TODO: use OpAutoPtr for argument passing

	if (!listener)
	{
		OP_ASSERT(FALSE && "No PermissionListener implemented?");
		security_callback->OnSecurityCheckError(OpStatus::ERR);
		return;
	}

	OpSecurityDialogCallback* dialog_callback = OP_NEW(OpSecurityDialogCallback, (security_callback, operation_type, ap_persistence_provider.release(), persistence));
	if (!dialog_callback)
	{
		security_callback->OnSecurityCheckError(OpStatus::ERR_NO_MEMORY);
		return;
	}

	OP_STATUS status = dialog_callback->SetOperationNameAndArgs(operation_name, argument1, argument2);
	if (OpStatus::IsSuccess(status))
		status = dialog_callback->SetURL(url);

	if (OpStatus::IsError(status))
	{
		OP_DELETE(dialog_callback);
		security_callback->OnSecurityCheckError(status);
		return;
	}
	listener->OnAskForPermission(win_cmd, dialog_callback);
}

OP_STATUS
OpSecurityManager_DOMObject::CheckDOMObjectSecurity(const OpSecurityContext& source, const OpSecurityContext& target, OpSecurityCheckCallback* security_callback, OpSecurityManager_DOMObject::AccessType access_type)
{
	OP_ASSERT(source.GetWindow());
	OP_ASSERT(target.IsDOMObjectAccess());
	// Currently only gadgets are supported.
	TrustDomain trust_domain = GetTrustDomain(source);
	if (trust_domain == TRUST_DOMAIN_NO_WIDGET)
	{
		security_callback->OnSecurityCheckSuccess(FALSE);
		return OpStatus::OK;
	}

	const char* operation_name = target.GetOperationName();
	SecurityRule* rule = NULL;
	rulesets[static_cast<int>(trust_domain)].GetData(operation_name, &rule);	// NULL may be returned
	SecurityPermission permission = rule ? rule->permission : UNRESTRICTED;

	if (access_type == ACCESS_TYPE_PROPERTY_ACCESS && (permission == INVOCATION_ONE_SHOT || permission == INVOCATION_SESSION || permission == INVOCATION_PERSISTENT))
	{
		// this is a security check in put or get for function -> actual security check should be postponed till actual function call
		security_callback->OnSecurityCheckSuccess(TRUE);
		return OpStatus::OK;
	}

#ifdef GADGET_SUPPORT
	if (permission != UNRESTRICTED && source.IsGadget() && !HasRequiredFeature(source.GetGadget(), operation_name))
	{
		security_callback->OnSecurityCheckSuccess(FALSE);
		return OpStatus::OK;
	}
#endif // GADGET_SUPPORT

	WindowCommander* window_commander = source.GetWindow()->GetWindowCommander();
	const uni_char* url = source.GetURL().IsValid() ? source.GetURL().GetAttribute(URL::KUniName_With_Fragment_Username_Password_Hidden).CStr() : 0;

	switch(permission)
	{
		case UNRESTRICTED:
		case ALLOWED:
			security_callback->OnSecurityCheckSuccess(TRUE);
			return OpStatus::OK;
		case DISALLOWED:
			security_callback->OnSecurityCheckSuccess(FALSE);
			return OpStatus::OK;
		case ACCESS_ONE_SHOT:
		case INVOCATION_ONE_SHOT:
			{
				OpSecurityPersistenceProvider* persistence_provider;
				RETURN_IF_ERROR(CreatePersistenceProvider(&persistence_provider, source, target, FALSE));
				AskForConfirmation(security_callback, window_commander, operation_name, rule->operation_type, persistence_provider, PERSISTENCE_NONE, target.GetArgument1(), target.GetArgument2(), url);
				break;
			}
		case ACCESS_SESSION:
		case INVOCATION_SESSION:
		case ACCESS_PERSISTENT:
		case INVOCATION_PERSISTENT:
			{
				OpSecurityPersistenceProvider* persistence_provider;
				BOOL is_fully_persistent = (permission == ACCESS_PERSISTENT || permission == INVOCATION_PERSISTENT);
				RETURN_IF_ERROR(CreatePersistenceProvider(&persistence_provider, source, target, is_fully_persistent));
				OpAutoPtr<OpSecurityPersistenceProvider> ap_persistence_provider(persistence_provider);
				switch (persistence_provider->IsAllowed(NULL))
				{
					case YES:
					{
						security_callback->OnSecurityCheckSuccess(TRUE);
						return OpStatus::OK;
					}
					case NO:
					{
						security_callback->OnSecurityCheckSuccess(FALSE);
						return OpStatus::OK;
					}
					case MAYBE:
					{
						ChoicePersistenceType persistence = is_fully_persistent ? PERSISTENCE_FULL : PERSISTENCE_SESSION;

						AskForConfirmation(security_callback, window_commander, operation_name, rule->operation_type, ap_persistence_provider.release(), persistence, target.GetArgument1(), target.GetArgument2(), url);
						break;
					}
				}
			}
			break;
		default:
			{
				OP_ASSERT(FALSE);
				security_callback->OnSecurityCheckError(OpStatus::ERR);
				return OpStatus::OK;
			}

	}
	return OpStatus::OK;
}

#ifdef GADGET_SUPPORT

/** Manages security choice persistence for a gadget.
 *
 * The persistence types are handled as follows:
 * PERSISTENCE_NONE - no persistence (access has to be confirmed each time)
 * PERSISTENCE_RUNTIME - choice is persisted until the widget is closed
 * PERSISTENCE_SESSION - same as runtime (since widgets don't share a session)
 * PERSISTENCE_FULL - the choice is saved forever (e.g. on disk)
 */
class GadgetPersistenceProvider : public OpSecurityPersistenceProvider
{
public:
	GadgetPersistenceProvider(OpGadget* gadget, BOOL is_fully_persistent) : gadget(gadget), is_fully_persistent(is_fully_persistent)
	{
	}

	OP_STATUS Construct(const char* operation)
	{
		return operation_name.Set(operation);
	}

	// Note: this implementation doesn't set the persistence value.
	virtual UserConsentType IsAllowed(ChoicePersistenceType* persistence) const;
	virtual OP_STATUS SetIsAllowed(BOOL is_allowed, ChoicePersistenceType persistence);
private:
	OP_STATUS GetKeyName(OpString* key_name, const char* operation_name) const;

	OpGadget* gadget;
	BOOL is_fully_persistent;
	OpString8 operation_name;
};

OP_STATUS
GadgetPersistenceProvider::GetKeyName(OpString* key_name, const char* operation_name) const
{
	OP_ASSERT(key_name);
	OP_ASSERT(operation_name);
	RETURN_IF_ERROR(key_name->Set(UNI_L("SecurityRulePermission\\")));
	return key_name->Append(operation_name);
}

/* virtual */ UserConsentType
GadgetPersistenceProvider::IsAllowed(ChoicePersistenceType* persistence) const
{
	OpString key_name;
	RETURN_VALUE_IF_ERROR(GetKeyName(&key_name, operation_name.CStr()), ASK);
	const uni_char* permission = NULL;

	if (is_fully_persistent)
		permission = gadget->GetUIData(key_name.CStr());
	if (!permission)
		permission = gadget->GetSessionData(key_name.CStr());

	if (!permission)
		return ASK; // user didn't accept/reject usage of API
	if (permission[0] == UNI_L("0")[0])
		return DENIED;
	if (permission[0] == UNI_L("1")[0])
		return ALLOWED;

	return ASK; // unexpected data in widget storage - better to ask user again?
}

/* virtual */ OP_STATUS
GadgetPersistenceProvider::SetIsAllowed(BOOL is_allowed, ChoicePersistenceType persistence)
{
	if (persistence == PERSISTENCE_NONE)
		return OpStatus::OK;

	OpString key_name;
	RETURN_IF_ERROR(GetKeyName(&key_name, operation_name.CStr()));

	const uni_char* allowed_string = is_allowed ? UNI_L("1") : UNI_L("0");
	if (persistence == PERSISTENCE_FULL)
		RETURN_IF_ERROR(gadget->SetUIData(key_name.CStr(), allowed_string));
	else	// PERSISTENCE_SESSION and PERSISTENCE_RUNTIME are the same for a gadget
		RETURN_IF_ERROR(gadget->SetSessionData(key_name.CStr(), allowed_string));
	return OpStatus::OK;
}

#endif // GADGET_SUPPORT

OP_STATUS
OpSecurityManager_DOMObject::CreatePersistenceProvider(OpSecurityPersistenceProvider** new_provider, const OpSecurityContext& source_context, const OpSecurityContext& target_context, BOOL is_fully_persistent) const
{
#ifdef GADGET_SUPPORT
	if (source_context.IsGadget())
	{
		GadgetPersistenceProvider* gadget_persistence_provider = OP_NEW(GadgetPersistenceProvider, (source_context.GetGadget(), is_fully_persistent));
		RETURN_OOM_IF_NULL(gadget_persistence_provider);
		OP_STATUS construct_status = (gadget_persistence_provider)->Construct(target_context.GetOperationName());
		if (OpStatus::IsError(construct_status))
			OP_DELETE(gadget_persistence_provider);
		else
			*new_provider = gadget_persistence_provider;
		return construct_status;
	}
#endif // GADGET_SUPPORT
	return OpStatus::ERR_NOT_SUPPORTED;
}

#endif // SECMAN_DOMOBJECT_ACCESS_RULES
