######################################################################
# mkcolornames.pl - Script to make color tables for named colors
######################################################################
# usage:      mkcolornames.pl color-file
# creates a file html_col.h.tmp that must be moved to modules/logdoc/html_col.h
# (2004-01-12, stighal) Opera Software
# (2004-03-29, rune) (footprint optimizations).
######################################################################

sub addstring
{
    $string_buffer = shift;
    $new_string = lc(shift);
    if ($$string_buffer =~ /$new_string\0/) {
	return $-[0];
    }
    else
    {
	$ret = length($$string_buffer);
	$$string_buffer .= "$new_string\0";
	return $ret;
    }
}

if( $#ARGV < 0 ) {
    die("to few parameters.\nUsage:   mkcolornames.pl color-file\n");
}

if( ! (-T $ARGV[0] && open(InFile, "$ARGV[0]")) ) {
    die("File does not exist or cannot open.\n$!");
}

$hxfile = "html_col.h.tmp";
open(HXFILE, ">$hxfile") || die "Can't open headerfile\n";


$col_idx = "const int COLOR_idx[] =\n{\n\n";
$col_name = "const uni_char* const far COLOR_name[] =\n{\n";
$col_val = "const COLORREF COLOR_val[] =\n{\n";

$collen = 0;
$colcount = 0;

# Read in all color values
while (<InFile>) {
    chomp;
    /(\S+)\s+(\S+)/;
    if ($1 eq "extra") {
	/(\S+)\s+(\S+)\s+(\S+)/;
	$col_arr_extra{$2} = $3;
    }
    else {
	$col_arr{$1} = $2;
    }
}

# All colors in col_arr_extra
@col_arr_extra{keys %col_arr} = values %col_arr;

sub mysort
{
    length($a) - length($b) || $a cmp $b;
}

sub writecolortables
{
    $colors = shift;
    @keys_sorted = sort mysort (keys %$colors);
    $longest = length($keys_sorted[$#keys_sorted]);

    print HXFILE "const int COLOR_SIZE = " . @keys_sorted . ";\n";
    print HXFILE "const int COLOR_MAX_SIZE = " . $longest . ";\n\n";

    print HXFILE "#ifdef DEFINE_COLORS\n\n";

    %length_counts = ();

    $str_buf = "";
    $str_idx = "};";
    foreach $new_str (reverse @keys_sorted) {
	$length_counts{length($new_str)} += 1;
	$str_idx = sprintf("\t0x%x, // \"%s\" -> %s\n", addstring(\$str_buf, $new_str), $new_str, $$colors{$new_str}) . $str_idx;
    }
    $str_idx = "const unsigned short COLOR_name[] =\n{\n" . $str_idx;

    print HXFILE "static const uni_char _COLOR_[] =\n{";
    $cnt = 0;
    foreach $char (split //, $str_buf) {
	if ($cnt == 0)
	{
	    print HXFILE "\n\t";
	}
	print HXFILE sprintf("0x%02x, ", ord($char));
	$cnt = ($cnt+1) % 16;
    }
    print HXFILE "\n};\n\n";

    print HXFILE "const unsigned short COLOR_idx[] =\n{\n";

    $accum_idx = 0;
    for ($i=0; $i<=$longest+1; $i++)
    {
	print HXFILE "\t$accum_idx,\t// start idx size $i\n";
	$accum_idx += $length_counts{$i};
    }

    print HXFILE "};\n\n";

    print HXFILE "$str_idx\n\n";

    print HXFILE "const COLORREF COLOR_val[] =\n{\n";

    foreach $str (@keys_sorted) {
	$tmp_col_val = "OP_RGB(0x" . substr($$colors{$str}, 2, 2) . ", 0x" . substr($$colors{$str}, 4, 2) . ", 0x" . substr($$colors{$str}, 6, 2) . ")";
	print HXFILE sprintf("\t%s, // %s\n", $tmp_col_val, $str);
	$length_counts{length($new_str)} += 1;
	$str_idx = sprintf("\t0x%x, // \"%s\" -> %s\n", addstring(\$str_buf, $new_str), $new_str, $$colors{$new_str}) . $str_idx;
    }

    print HXFILE "};\n\n";

    print HXFILE "#endif // DEFINE_COLORS\n\n";
}

print HXFILE "

  /************************************************************
   * This file is generated by the script mkcolornames.pl
   * found in the <OperaSrc>/modules/logdoc/scripts/ directory
   *
   *     !!! DO NOT EDIT THIS FILE BY HAND !!!
   *
   * All changes will be lost when the files are 
   * generated again. (stighal, 2002-04-15)
   ************************************************************/

#ifndef HTML_COL_H
#define HTML_COL_H

";

print HXFILE "#ifdef X11_COLORS_ONLY\n\n";

writecolortables(\%col_arr);

print HXFILE "#else // X11_COLORS_ONLY\n\n";

writecolortables(\%col_arr_extra);

print HXFILE "#endif // X11_COLORS_ONLY\n\n";
print HXFILE "#endif // HTML_COL_H\n";
