/*
 * Copyright (C) 1995-2017 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */

/*
 * Please do not modify this file.
 *
 * This file is automatically generated by viewers.py
 *
 * To change this file, change modules/viewers/module.viewers, and run
 * the operasetup.py script.
 */

#ifdef HAS_COMPLEX_GLOBALS

const ViewerTypes Viewers::defaultOperaViewerTypes[] =
{

#if defined(_QT_) || defined(_MACINTOSH_) || defined(_NANOX)
	{ "*/*", "*", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_QT_) || defined(_MACINTOSH_) || defined(_NANOX)
	{ "...", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, false, false },
#if !defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	{ "application/mime", "mim,mime,mht,mhtml,mbs", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MIME_CONTENT), VIEWER_NULL, false, false },
#endif // !defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	{ "application/mime", "mim,mime,mbs", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MIME_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	{ "application/x-opera-mime-archive", "mht,mhtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MHTML_ARCHIVE), VIEWER_NULL, false, false },
#endif // defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	{ "application/x-pem-file", "pem", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_PEM_FILE), VIEWER_NULL, false, false },
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	{ "application/x-x509-ca-cert", "crt,ca,cer,509, der", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_X509_CA_CERT), VIEWER_NULL, false, false },
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	{ "application/x-x509-user-cert", "usr", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_X509_USER_CERT), VIEWER_NULL, false, false },
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	{ "application/x-pkcs12", "pfx,p12", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PFX_CONTENT), VIEWER_NULL, false, false },
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	{ "application/x-javascript", "js", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "application/x-ecmascript", "js,es", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "application/javascript", "js", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "application/ecmascript", "js,es", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "text/javascript", "js", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "text/ecmascript", "js,es", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_JAVASCRIPT), VIEWER_NULL, false, false },
	{ "image/gif", "gif", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_GIF_CONTENT), VIEWER_NULL, false, false },
	{ "image/jpeg", "jpeg,jpe,jpg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_JPG_CONTENT), VIEWER_NULL, false, false },
	{ "image/jpg", "jpeg,jpe,jpg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_JPG_CONTENT), VIEWER_NULL, false, false },
	{ "image/pjpeg", "jpeg,jpe,jpg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_JPG_CONTENT), VIEWER_NULL, false, false },
#if defined(HAS_ATVEF_SUPPORT)
	{ "image/atvef", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_TV_CONTENT), VIEWER_NULL, false, false },
#endif // defined(HAS_ATVEF_SUPPORT)
	{ "image/bmp", "bmp", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_BMP_CONTENT), VIEWER_NULL, false, false },
	{ "image/webp", "webp", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WEBP_CONTENT), VIEWER_NULL, false, false },
	{ "image/x-windows-bmp", "bmp", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_BMP_CONTENT), VIEWER_NULL, false, false },
	{ "image/x-ms-bmp", "bmp", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_BMP_CONTENT), VIEWER_NULL, false, false },
	{ "image/x-xbitmap", "xbm", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XBM_CONTENT), VIEWER_NULL, false, false },
	{ "image/xbm", "xbm", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XBM_CONTENT), VIEWER_NULL, false, false },
	{ "text/css", "css", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_CSS_CONTENT), VIEWER_NULL, false, false },
	{ "text/html", "htm,html,shtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_HTML_CONTENT), VIEWER_NULL, false, false },
	{ "text/plain", "txt", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_TEXT_CONTENT), VIEWER_NULL, false, false },
	{ "application/ce-html+xml", "htm,html,shtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/x-ce-html+xml", "htm,html,shtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/vnd.hbbtv.xhtml+xml", "htm,html,shtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
#if defined(PREFS_DOWNLOAD)
	{ "application/x-opera-configuration-siteprefs", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PREFS_CONTENT), VIEWER_NULL, false, false },
#endif // defined(PREFS_DOWNLOAD)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MULTI_CONFIGURATION_CONTENT), VIEWER_NULL, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-skin", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_SKIN_CONFIGURATION_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration-skin", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_SKIN_CONFIGURATION_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration-mouse", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MOUSE_CONFIGURATION_CONTENT), VIEWER_NULL, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration-keyboard", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_KEYBOARD_CONFIGURATION_CONTENT), VIEWER_NULL, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration-toolbar", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_TOOLBAR_CONFIGURATION_CONTENT), VIEWER_NULL, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	{ "application/x-opera-configuration-menu", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MENU_CONFIGURATION_CONTENT), VIEWER_NULL, false, false },
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(GADGET_SUPPORT)
	{ "application/widget", "wgt", VIEWERS_WIDGET_ACTION, FROM_RANGED_ENUM(URLContentType, URL_GADGET_INSTALL_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(GADGET_SUPPORT)
#if defined(GADGET_SUPPORT)
	{ "application/x-opera-widgets", "wgt", VIEWERS_WIDGET_ACTION, FROM_RANGED_ENUM(URLContentType, URL_GADGET_INSTALL_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(GADGET_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && defined(GADGET_SUPPORT)
	{ "application/x-opera-uniteapplication", "us,ua", VIEWERS_UNITE_ACTION, FROM_RANGED_ENUM(URLContentType, URL_UNITESERVICE_INSTALL_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(WEBSERVER_SUPPORT) && defined(GADGET_SUPPORT)
#if defined(EXTENSION_SUPPORT)
	{ "application/x-opera-extension", "oex", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_EXTENSION_INSTALL_CONTENT), VIEWER_APPLICATION_ZIP, false, false },
#endif // defined(EXTENSION_SUPPORT)
	{ "text/xml", "xml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/xml", "xml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/vnd.wap.xhtml+xml", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_HTML_CONTENT), VIEWER_NULL, false, false },
	{ "application/xhtml+xml", "xht,xhtm,xhtml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/rss+xml", "rss", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, true, false },
	{ "application/atom+xml", "atom", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, true, false },
	{ "application/xslt+xml", "xslt", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/mathml+xml", "mathml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/rdf+xml", "rdf", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
	{ "application/wml+xml", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
#if defined(WBXML_SUPPORT)
	{ "application/vnd.wap.wbxml", "wbxml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_CONTENT), VIEWER_NULL, false, false },
#endif // defined(WBXML_SUPPORT)
#if defined(WBXML_SUPPORT)
	{ "application/vnd.wap.wmlc", "wmlc", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WML_CONTENT), VIEWER_NULL, false, false },
#endif // defined(WBXML_SUPPORT)
#if defined(APPLICATION_CACHE_SUPPORT)
	{ "text/cache-manifest", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MANIFEST_CONTENT), VIEWER_NULL, false, false },
#endif // defined(APPLICATION_CACHE_SUPPORT)
#if defined(_WML_SUPPORT_)
	{ "text/vnd.wap.wml", "wml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WML_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_WML_SUPPORT_)
#if defined(_WML_SUPPORT_)
	{ "text/wml", "wml", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WML_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_WML_SUPPORT_)
#if defined(WBMP_SUPPORT)
	{ "image/vnd.wap.wbmp", "wbmp", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WBMP_CONTENT), VIEWER_NULL, false, false },
#endif // defined(WBMP_SUPPORT)
#if defined(SVG_SUPPORT)
	{ "image/svg+xml", "svg,svgz", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_SVG_CONTENT), VIEWER_APPLICATION_X_GZIP, false, false },
#endif // defined(SVG_SUPPORT)
#if defined(SVG_SUPPORT)
	{ "image/svg-xml", "svg,svgz", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_SVG_CONTENT), VIEWER_NULL, false, false },
#endif // defined(SVG_SUPPORT)
#if defined(SVG_SUPPORT)
	{ "image/vnd.adobe.svg+xml", "svg,svgz", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_SVG_CONTENT), VIEWER_NULL, false, false },
#endif // defined(SVG_SUPPORT)
#if defined(ICO_SUPPORT)
	{ "image/x-icon", "ico", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_ICO_CONTENT), VIEWER_NULL, false, false },
#endif // defined(ICO_SUPPORT)
#if defined(_PNG_SUPPORT_)
	{ "image/png", "png", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PNG_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_PNG_SUPPORT_)
#if defined(_PNG_SUPPORT_)
	{ "image/x-png", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PNG_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_PNG_SUPPORT_)
	{ "audio/midi", "midi,mid", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_MIDI_CONTENT), VIEWER_NULL, false, false },
	{ "audio/mid", "mid,midi,smf,kar", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_MIDI_CONTENT), VIEWER_NULL, false, false },
	{ "audio/x-midi", "mid,midi", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_MIDI_CONTENT), VIEWER_NULL, false, false },
#if defined(MEDIA_HTML_SUPPORT)
	{ "audio/wav", "wav", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WAV_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "audio/x-wav", "wav", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_WAV_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-msvideo", "avi", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_AVI_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/mpeg", "mpeg,mpg,mpe,m2v,m1v,mpa", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_MPG_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/mp4", "mp4,mpg4", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_MP4_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
	{ "application/x-ns-proxy-autoconfig", "pac", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PAC_CONTENT), VIEWER_NULL, false, false },
#endif // defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
#if defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
	{ "application/x-javascript-config", "jsc", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_PAC_CONTENT), VIEWER_NULL, false, false },
#endif // defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
#if defined(_BITTORRENT_SUPPORT_)
	{ "application/x-bittorrent", "torrent", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_P2P_BITTORRENT), VIEWER_NULL, true, false },
#endif // defined(_BITTORRENT_SUPPORT_)
#if defined(EVENT_SOURCE_SUPPORT)
	{ "text/event-stream", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_EVENTSOURCE_CONTENT), VIEWER_NULL, false, false },
#endif // defined(EVENT_SOURCE_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "application/ogg", "ogg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MEDIA_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "video/ogg", "ogv,ogg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MEDIA_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "audio/ogg", "oga,ogg", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MEDIA_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "video/webm", "webm", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MEDIA_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	{ "audio/webm", "webm", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MEDIA_CONTENT), VIEWER_NULL, false, false },
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(XML_AIT_SUPPORT)
	{ "application/vnd.dvb.ait+xml", "ait", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_AIT), VIEWER_NULL, false, false },
#endif // defined(XML_AIT_SUPPORT)
#if defined(XML_AIT_SUPPORT)
	{ "application/dvb.ait+xml", "ait", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_XML_AIT), VIEWER_NULL, false, false },
#endif // defined(XML_AIT_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	{ "text/enriched", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/mpeg", "mp3,mp2,mpga", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/mp3", "mp3", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-mpegurl", "m3u", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-wais-source", "src", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/sgml", "sgml,sgm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-iso-image", "iso", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(FONT_MIMETYPES)
	{ "application/x-font-ttf", "ttf,ttc", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(FONT_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "image/g3fax", "g3f", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/basic", "au", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/qif", "qif", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/comma-separated-values", "csv", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/epub+zip", "epub", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-lha", "lha,lzh", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-aiff", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-compress", "z", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-gtar", "gtar", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-gzip", "gz,gzip,tgz", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/bzip2", "bz2,tbz,tbz2", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-lzma", "lzma,tlz,tlzma", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-xz", "xz,txz", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-tar", "tar,tgz,gz,tbz,tbz2,bz2,tlz,tlzma,lzma,txz,xz", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_X_GZIP, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	{ "application/x-rpm", "rpm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	{ "application/x-redhat-package", "rpm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	{ "application/deb", "deb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	{ "application/x-debian-package", "deb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	{ "application/x-deb", "deb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES)
	{ "text/x-uuencode", "uu,uue", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-latex", "latex,ltx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-tcl", "tcl", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-tex", "tex", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-texinfo", "texinfo", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-troff", "roff,t,tr", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-troff-man", "man", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-troff-me", "me", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-troff-ms", "ms", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-framemaker", "mif", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-next", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/pgp", "pgp,asc", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/mac-binhex40", "hqx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-stuffit", "sit", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-macbinary", "bin", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-apple-diskimage", "dmg", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "image/x-pict", "pict", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-macaudio", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/quicktime", "qt,mov", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/calendar", "ics", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/pdf", "pdf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.adobe.xdp+xml", "xdp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.adobe.xfd+xml", "xfd", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/postscript", "ps,eps,ai", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "image/tiff", "tif,tiff", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msdownload", "exe,dll,bat,pif,com,scr,msi", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, true },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msdos-program", "exe,dll,bat,pif,com,scr,msi", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && defined(_ISHORTCUT_SUPPORT)
	{ "application/internet-shortcut", "url", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_ISHORTCUT_CONTENT), VIEWER_NULL, false, false },
#endif // defined(EXTENDED_MIMETYPES) && defined(_ISHORTCUT_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	{ "application/zip", "zip,apk", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-zip-compressed", "zip", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-arj", "arj", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-rar-compressed", "rar", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/msword", "doc,dot,wiz,wzs", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/rtf", "rtf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/richtext", "rtx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.ms-excel", "xls,xl,xla,xlb,xlc,xld,xlk,xll,xlm,xlt,xlv,xlw,csv", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.ms-powerpoint", "pot,ppa,pps,ppt,pwz", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.ms-project", "mpp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.ms-works", "wcm,wdb,wks,wps", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/winhlp", "hlp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msaccess", "mdb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-mscardfile", "crd", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msclip", "clp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msdownload", "dll", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, true },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msmediaview", "m13,m14,mvb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msmetafile", "wmf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msmoney", "mny", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-mspublisher", "pub", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msschedule", "scd", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-msterminal", "trm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-mswrite", "wri", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "dotx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "xltx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "ppsx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.presentationml.template", "potx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.openxmlformats-officedocument.presentationml.slide", "sldx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-word.document.macroEnabled.12", "docm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-word.template.macroEnabled.12", "dotm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-excel.sheet.macroEnabled.12", "xlsm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-excel.template.macroEnabled.12", "xltm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-excel.sheet.binary.macroEnabled.12", "xlsb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-excel.addin.macroEnabled.12", "xlam", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-powerpoint.presentation.macroEnabled.12", "pptm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-powerpoint.slideshow.macroEnabled.12", "ppsm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-powerpoint.template.macroEnabled.12", "potm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-powerpoint.addin.macroEnabled.12", "ppam", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/vnd.ms-powerpoint.slide.macroEnabled.12", "sldm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	{ "application/onenote", "onetoc,onetoc2,onetmp,onepkg", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.database", "odb", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.chart", "odc", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.formula", "odf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.graphics", "odg", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.graphics-template", "otg", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.image", "odi", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.text-master", "odm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.presentation", "odp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.presentation-template", "otp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.spreadsheet", "ods", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.spreadsheet-template", "ots", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.text", "odt", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.text-template", "ott", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	{ "application/vnd.oasis.opendocument.text-web", "oth", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/asx", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-ms-asf-plugin", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-mplayer2", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-ms-wm", "wm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-ms-wma", "wma", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-ms-wax", "wax", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-ms-wvx", "wvx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-ms-wmv", "wmv,wmx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/x-ms-asf", "asf,asx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-ms-wmp", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/smil", "smi,smil", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/streamingmedia", "ssm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.rn-rsml", "rsml", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.rn-realplayer", "rnx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.rn-rn_music_package", "rmp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.rn-realsystem-rmx", "rmx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/vnd.rn-realsystem-rjs", "rjs", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-pn-realmedia", "rm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "audio/x-pn-realaudio", "ram,ra", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "video/vnd.rn-realvideo", "rv", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "image/vnd.rn-realflash", "rf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/vnd.rn-realtext", "rt", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "image/vnd.rn-realpix", "rp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/sdp", "sdp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-sdp", "sdp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && !defined(UNIX)
	{ "audio/x-pn-realaudio-plugin", "rpm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES) && !defined(UNIX)
#if defined(EXTENDED_MIMETYPES)
	{ "application/wordperfect5.1", "doc,wp4,wp5,wp6,wp,wkb,wpd", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-director", "dcr,dir,dxr", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/futuresplash", "spl", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-shockwave-flash", "swf,swt", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_FLASH_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(JAD_SUPPORT)
	{ "text/vnd.sun.j2me.app-descriptor", "jad", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_JAD_CONTENT), VIEWER_NULL, true, false },
#endif // defined(JAD_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-java-jnlp-file", "jnlp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(JAD_SUPPORT)
	{ "application/java-archive", "jar", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_APPLICATION_ZIP, true, false },
#endif // defined(JAD_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-silverlight", "scr", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "application/x-silverlight-2", "scr", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
	{ "application/divxplayer-plugin", "scr", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#if defined(EXTENDED_MIMETYPES)
	{ "video/3gpp", "3gp", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/x-vcard", "vcf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	{ "text/x-imelody", "imy", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(EXTENDED_MIMETYPES)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	{ "application/ogg", "ogg,ogx,ogm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	{ "video/ogg", "ogg,ogv,ogm", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	{ "audio/ogg", "ogg,oga,spx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	{ "audio/flac", "flac", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	{ "application/annodex", "anx", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	{ "video/annodex", "axv", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	{ "audio/annodex", "axa", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	{ "application/xspf+xml", "xspf", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#endif // defined(WEBSERVER_SUPPORT)
	{ "application/octet-stream", "", VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
#if defined(_MIME_SUPPORT_)
	{ "message/rfc822", "mime", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_MIME_CONTENT), VIEWER_NULL, false, false },
#endif // defined(_MIME_SUPPORT_)
	{ "multipart/x-mixed-replace", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_MIXED_REPLACE_CONTENT), VIEWER_NULL, false, false },
	{ "multipart/mixed", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_MIXED_REPLACE_CONTENT), VIEWER_NULL, false, false },
#if defined(WBMULTIPART_MIXED_SUPPORT)
	{ "application/vnd.wap.multipart.mixed", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_MIXED_BIN_REPLACE_CONTENT), VIEWER_NULL, false, false },
#endif // defined(WBMULTIPART_MIXED_SUPPORT)
#if defined(WBMULTIPART_MIXED_SUPPORT)
	{ "application/vnd.wap.multipart.related", "", VIEWER_OPERA, FROM_RANGED_ENUM(URLContentType, URL_X_MIXED_BIN_REPLACE_CONTENT), VIEWER_NULL, false, false },
#endif // defined(WBMULTIPART_MIXED_SUPPORT)
	{ NULL, NULL, VIEWER_ASK_USER, FROM_RANGED_ENUM(URLContentType, URL_UNKNOWN_CONTENT), VIEWER_NULL, true, false },
};

#else //HAS_COMPLEX_GLOBALS

void Viewers::init_defaultOperaViewerTypes()
{
	ViewerTypes *local = defaultOperaViewerTypes;
	int i = 0;

#if defined(_QT_) || defined(_MACINTOSH_) || defined(_NANOX)
	local[i].type="*/*", local[i].ext="*", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_QT_) || defined(_MACINTOSH_) || defined(_NANOX)
	local[i].type="...", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if !defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	local[i].type="application/mime", local[i].ext="mim,mime,mht,mhtml,mbs", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIME_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // !defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	local[i].type="application/mime", local[i].ext="mim,mime,mbs", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIME_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
	local[i].type="application/x-opera-mime-archive", local[i].ext="mht,mhtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MHTML_ARCHIVE), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MHTML_ARCHIVE_REDIRECT_SUPPORT)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	local[i].type="application/x-pem-file", local[i].ext="pem", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_PEM_FILE), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	local[i].type="application/x-x509-ca-cert", local[i].ext="crt,ca,cer,509, der", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_X509_CA_CERT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	local[i].type="application/x-x509-user-cert", local[i].ext="usr", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_X509_USER_CERT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
#if !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	local[i].type="application/x-pkcs12", local[i].ext="pfx,p12", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PFX_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // !defined(BREW) && !defined(_EXTERNAL_SSL_SUPPORT_)
	local[i].type="application/x-javascript", local[i].ext="js", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/x-ecmascript", local[i].ext="js,es", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/javascript", local[i].ext="js", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/ecmascript", local[i].ext="js,es", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="text/javascript", local[i].ext="js", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="text/ecmascript", local[i].ext="js,es", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_JAVASCRIPT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/gif", local[i].ext="gif", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_GIF_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/jpeg", local[i].ext="jpeg,jpe,jpg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_JPG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/jpg", local[i].ext="jpeg,jpe,jpg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_JPG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/pjpeg", local[i].ext="jpeg,jpe,jpg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_JPG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if defined(HAS_ATVEF_SUPPORT)
	local[i].type="image/atvef", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_TV_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(HAS_ATVEF_SUPPORT)
	local[i].type="image/bmp", local[i].ext="bmp", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_BMP_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/webp", local[i].ext="webp", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WEBP_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/x-windows-bmp", local[i].ext="bmp", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_BMP_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/x-ms-bmp", local[i].ext="bmp", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_BMP_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/x-xbitmap", local[i].ext="xbm", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XBM_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="image/xbm", local[i].ext="xbm", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XBM_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="text/css", local[i].ext="css", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_CSS_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="text/html", local[i].ext="htm,html,shtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_HTML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="text/plain", local[i].ext="txt", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_TEXT_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/ce-html+xml", local[i].ext="htm,html,shtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/x-ce-html+xml", local[i].ext="htm,html,shtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/vnd.hbbtv.xhtml+xml", local[i].ext="htm,html,shtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if defined(PREFS_DOWNLOAD)
	local[i].type="application/x-opera-configuration-siteprefs", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PREFS_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(PREFS_DOWNLOAD)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MULTI_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-skin", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_SKIN_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration-skin", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_SKIN_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration-mouse", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MOUSE_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration-keyboard", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_KEYBOARD_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration-toolbar", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_TOOLBAR_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
	local[i].type="application/x-opera-configuration-menu", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MENU_CONFIGURATION_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(OPERA_SETUP_DOWNLOAD_APPLY_SUPPORT)
#if defined(GADGET_SUPPORT)
	local[i].type="application/widget", local[i].ext="wgt", local[i].action=VIEWERS_WIDGET_ACTION, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_GADGET_INSTALL_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(GADGET_SUPPORT)
#if defined(GADGET_SUPPORT)
	local[i].type="application/x-opera-widgets", local[i].ext="wgt", local[i].action=VIEWERS_WIDGET_ACTION, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_GADGET_INSTALL_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(GADGET_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && defined(GADGET_SUPPORT)
	local[i].type="application/x-opera-uniteapplication", local[i].ext="us,ua", local[i].action=VIEWERS_UNITE_ACTION, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNITESERVICE_INSTALL_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT) && defined(GADGET_SUPPORT)
#if defined(EXTENSION_SUPPORT)
	local[i].type="application/x-opera-extension", local[i].ext="oex", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_EXTENSION_INSTALL_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(EXTENSION_SUPPORT)
	local[i].type="text/xml", local[i].ext="xml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/xml", local[i].ext="xml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/vnd.wap.xhtml+xml", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_HTML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/xhtml+xml", local[i].ext="xht,xhtm,xhtml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/rss+xml", local[i].ext="rss", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
	local[i].type="application/atom+xml", local[i].ext="atom", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
	local[i].type="application/xslt+xml", local[i].ext="xslt", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/mathml+xml", local[i].ext="mathml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/rdf+xml", local[i].ext="rdf", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="application/wml+xml", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if defined(WBXML_SUPPORT)
	local[i].type="application/vnd.wap.wbxml", local[i].ext="wbxml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WBXML_SUPPORT)
#if defined(WBXML_SUPPORT)
	local[i].type="application/vnd.wap.wmlc", local[i].ext="wmlc", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WBXML_SUPPORT)
#if defined(APPLICATION_CACHE_SUPPORT)
	local[i].type="text/cache-manifest", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MANIFEST_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(APPLICATION_CACHE_SUPPORT)
#if defined(_WML_SUPPORT_)
	local[i].type="text/vnd.wap.wml", local[i].ext="wml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_WML_SUPPORT_)
#if defined(_WML_SUPPORT_)
	local[i].type="text/wml", local[i].ext="wml", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WML_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_WML_SUPPORT_)
#if defined(WBMP_SUPPORT)
	local[i].type="image/vnd.wap.wbmp", local[i].ext="wbmp", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WBMP_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WBMP_SUPPORT)
#if defined(SVG_SUPPORT)
	local[i].type="image/svg+xml", local[i].ext="svg,svgz", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_SVG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(SVG_SUPPORT)
#if defined(SVG_SUPPORT)
	local[i].type="image/svg-xml", local[i].ext="svg,svgz", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_SVG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(SVG_SUPPORT)
#if defined(SVG_SUPPORT)
	local[i].type="image/vnd.adobe.svg+xml", local[i].ext="svg,svgz", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_SVG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(SVG_SUPPORT)
#if defined(ICO_SUPPORT)
	local[i].type="image/x-icon", local[i].ext="ico", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_ICO_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(ICO_SUPPORT)
#if defined(_PNG_SUPPORT_)
	local[i].type="image/png", local[i].ext="png", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PNG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_PNG_SUPPORT_)
#if defined(_PNG_SUPPORT_)
	local[i].type="image/x-png", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PNG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_PNG_SUPPORT_)
	local[i].type="audio/midi", local[i].ext="midi,mid", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIDI_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="audio/mid", local[i].ext="mid,midi,smf,kar", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIDI_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="audio/x-midi", local[i].ext="mid,midi", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIDI_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="audio/wav", local[i].ext="wav", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WAV_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="audio/x-wav", local[i].ext="wav", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_WAV_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-msvideo", local[i].ext="avi", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_AVI_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/mpeg", local[i].ext="mpeg,mpg,mpe,m2v,m1v,mpa", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MPG_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/mp4", local[i].ext="mp4,mpg4", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MP4_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
	local[i].type="application/x-ns-proxy-autoconfig", local[i].ext="pac", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PAC_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
#if defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
	local[i].type="application/x-javascript-config", local[i].ext="jsc", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_PAC_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(SUPPORT_AUTO_PROXY_CONFIGURATION)
#if defined(_BITTORRENT_SUPPORT_)
	local[i].type="application/x-bittorrent", local[i].ext="torrent", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_P2P_BITTORRENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(_BITTORRENT_SUPPORT_)
#if defined(EVENT_SOURCE_SUPPORT)
	local[i].type="text/event-stream", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_EVENTSOURCE_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(EVENT_SOURCE_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="application/ogg", local[i].ext="ogg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MEDIA_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="video/ogg", local[i].ext="ogv,ogg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MEDIA_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="audio/ogg", local[i].ext="oga,ogg", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MEDIA_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="video/webm", local[i].ext="webm", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MEDIA_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(MEDIA_HTML_SUPPORT)
	local[i].type="audio/webm", local[i].ext="webm", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MEDIA_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(MEDIA_HTML_SUPPORT)
#if defined(XML_AIT_SUPPORT)
	local[i].type="application/vnd.dvb.ait+xml", local[i].ext="ait", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_AIT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(XML_AIT_SUPPORT)
#if defined(XML_AIT_SUPPORT)
	local[i].type="application/dvb.ait+xml", local[i].ext="ait", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_XML_AIT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(XML_AIT_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/enriched", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/mpeg", local[i].ext="mp3,mp2,mpga", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/mp3", local[i].ext="mp3", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-mpegurl", local[i].ext="m3u", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-wais-source", local[i].ext="src", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/sgml", local[i].ext="sgml,sgm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-iso-image", local[i].ext="iso", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(FONT_MIMETYPES)
	local[i].type="application/x-font-ttf", local[i].ext="ttf,ttc", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(FONT_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="image/g3fax", local[i].ext="g3f", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/basic", local[i].ext="au", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/qif", local[i].ext="qif", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/comma-separated-values", local[i].ext="csv", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/epub+zip", local[i].ext="epub", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-lha", local[i].ext="lha,lzh", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-aiff", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-compress", local[i].ext="z", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-gtar", local[i].ext="gtar", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-gzip", local[i].ext="gz,gzip,tgz", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/bzip2", local[i].ext="bz2,tbz,tbz2", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-lzma", local[i].ext="lzma,tlz,tlzma", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-xz", local[i].ext="xz,txz", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-tar", local[i].ext="tar,tgz,gz,tbz,tbz2,bz2,tlz,tlzma,lzma,txz,xz", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	local[i].type="application/x-rpm", local[i].ext="rpm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	local[i].type="application/x-redhat-package", local[i].ext="rpm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	local[i].type="application/deb", local[i].ext="deb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	local[i].type="application/x-debian-package", local[i].ext="deb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES) && defined(UNIX)
	local[i].type="application/x-deb", local[i].ext="deb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(UNIX)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/x-uuencode", local[i].ext="uu,uue", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-latex", local[i].ext="latex,ltx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-tcl", local[i].ext="tcl", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-tex", local[i].ext="tex", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-texinfo", local[i].ext="texinfo", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-troff", local[i].ext="roff,t,tr", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-troff-man", local[i].ext="man", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-troff-me", local[i].ext="me", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-troff-ms", local[i].ext="ms", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-framemaker", local[i].ext="mif", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-next", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/pgp", local[i].ext="pgp,asc", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/mac-binhex40", local[i].ext="hqx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-stuffit", local[i].ext="sit", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-macbinary", local[i].ext="bin", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-apple-diskimage", local[i].ext="dmg", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="image/x-pict", local[i].ext="pict", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-macaudio", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/quicktime", local[i].ext="qt,mov", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/calendar", local[i].ext="ics", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/pdf", local[i].ext="pdf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.adobe.xdp+xml", local[i].ext="xdp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.adobe.xfd+xml", local[i].ext="xfd", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/postscript", local[i].ext="ps,eps,ai", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="image/tiff", local[i].ext="tif,tiff", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msdownload", local[i].ext="exe,dll,bat,pif,com,scr,msi", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=true;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msdos-program", local[i].ext="exe,dll,bat,pif,com,scr,msi", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && defined(_ISHORTCUT_SUPPORT)
	local[i].type="application/internet-shortcut", local[i].ext="url", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_ISHORTCUT_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && defined(_ISHORTCUT_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/zip", local[i].ext="zip,apk", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-zip-compressed", local[i].ext="zip", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-arj", local[i].ext="arj", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-rar-compressed", local[i].ext="rar", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/msword", local[i].ext="doc,dot,wiz,wzs", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/rtf", local[i].ext="rtf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/richtext", local[i].ext="rtx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.ms-excel", local[i].ext="xls,xl,xla,xlb,xlc,xld,xlk,xll,xlm,xlt,xlv,xlw,csv", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint", local[i].ext="pot,ppa,pps,ppt,pwz", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.ms-project", local[i].ext="mpp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.ms-works", local[i].ext="wcm,wdb,wks,wps", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/winhlp", local[i].ext="hlp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msaccess", local[i].ext="mdb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-mscardfile", local[i].ext="crd", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msclip", local[i].ext="clp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msdownload", local[i].ext="dll", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=true;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msmediaview", local[i].ext="m13,m14,mvb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msmetafile", local[i].ext="wmf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msmoney", local[i].ext="mny", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-mspublisher", local[i].ext="pub", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msschedule", local[i].ext="scd", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-msterminal", local[i].ext="trm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-mswrite", local[i].ext="wri", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.wordprocessingml.document", local[i].ext="docx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.wordprocessingml.template", local[i].ext="dotx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", local[i].ext="xlsx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.spreadsheetml.template", local[i].ext="xltx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.presentationml.presentation", local[i].ext="pptx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.presentationml.slideshow", local[i].ext="ppsx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.presentationml.template", local[i].ext="potx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.openxmlformats-officedocument.presentationml.slide", local[i].ext="sldx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-word.document.macroEnabled.12", local[i].ext="docm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-word.template.macroEnabled.12", local[i].ext="dotm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-excel.sheet.macroEnabled.12", local[i].ext="xlsm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-excel.template.macroEnabled.12", local[i].ext="xltm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-excel.sheet.binary.macroEnabled.12", local[i].ext="xlsb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-excel.addin.macroEnabled.12", local[i].ext="xlam", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint.presentation.macroEnabled.12", local[i].ext="pptm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint.slideshow.macroEnabled.12", local[i].ext="ppsm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint.template.macroEnabled.12", local[i].ext="potm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint.addin.macroEnabled.12", local[i].ext="ppam", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/vnd.ms-powerpoint.slide.macroEnabled.12", local[i].ext="sldm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(EXTENDED_MS_MIMETYPES)
	local[i].type="application/onenote", local[i].ext="onetoc,onetoc2,onetmp,onepkg", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MS_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.database", local[i].ext="odb", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.chart", local[i].ext="odc", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.formula", local[i].ext="odf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.graphics", local[i].ext="odg", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.graphics-template", local[i].ext="otg", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.image", local[i].ext="odi", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.text-master", local[i].ext="odm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.presentation", local[i].ext="odp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.presentation-template", local[i].ext="otp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.spreadsheet", local[i].ext="ods", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.spreadsheet-template", local[i].ext="ots", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.text", local[i].ext="odt", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.text-template", local[i].ext="ott", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(OPENDOCUMENT_MIMETYPES)
	local[i].type="application/vnd.oasis.opendocument.text-web", local[i].ext="oth", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(OPENDOCUMENT_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/asx", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-ms-asf-plugin", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-mplayer2", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-ms-wm", local[i].ext="wm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-ms-wma", local[i].ext="wma", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-ms-wax", local[i].ext="wax", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-ms-wvx", local[i].ext="wvx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-ms-wmv", local[i].ext="wmv,wmx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/x-ms-asf", local[i].ext="asf,asx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-ms-wmp", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/smil", local[i].ext="smi,smil", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/streamingmedia", local[i].ext="ssm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.rn-rsml", local[i].ext="rsml", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.rn-realplayer", local[i].ext="rnx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.rn-rn_music_package", local[i].ext="rmp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.rn-realsystem-rmx", local[i].ext="rmx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/vnd.rn-realsystem-rjs", local[i].ext="rjs", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-pn-realmedia", local[i].ext="rm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="audio/x-pn-realaudio", local[i].ext="ram,ra", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/vnd.rn-realvideo", local[i].ext="rv", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="image/vnd.rn-realflash", local[i].ext="rf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/vnd.rn-realtext", local[i].ext="rt", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="image/vnd.rn-realpix", local[i].ext="rp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/sdp", local[i].ext="sdp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-sdp", local[i].ext="sdp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES) && !defined(UNIX)
	local[i].type="audio/x-pn-realaudio-plugin", local[i].ext="rpm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES) && !defined(UNIX)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/wordperfect5.1", local[i].ext="doc,wp4,wp5,wp6,wp,wkb,wpd", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-director", local[i].ext="dcr,dir,dxr", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/futuresplash", local[i].ext="spl", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-shockwave-flash", local[i].ext="swf,swt", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_FLASH_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(JAD_SUPPORT)
	local[i].type="text/vnd.sun.j2me.app-descriptor", local[i].ext="jad", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_JAD_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(JAD_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-java-jnlp-file", local[i].ext="jnlp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(JAD_SUPPORT)
	local[i].type="application/java-archive", local[i].ext="jar", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(JAD_SUPPORT)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-silverlight", local[i].ext="scr", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="application/x-silverlight-2", local[i].ext="scr", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
	local[i].type="application/divxplayer-plugin", local[i].ext="scr", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#if defined(EXTENDED_MIMETYPES)
	local[i].type="video/3gpp", local[i].ext="3gp", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/x-vcard", local[i].ext="vcf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(EXTENDED_MIMETYPES)
	local[i].type="text/x-imelody", local[i].ext="imy", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(EXTENDED_MIMETYPES)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	local[i].type="application/ogg", local[i].ext="ogg,ogx,ogm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	local[i].type="video/ogg", local[i].ext="ogg,ogv,ogm", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
	local[i].type="audio/ogg", local[i].ext="ogg,oga,spx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT) && !defined(MEDIA_HTML_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	local[i].type="audio/flac", local[i].ext="flac", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	local[i].type="application/annodex", local[i].ext="anx", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	local[i].type="video/annodex", local[i].ext="axv", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	local[i].type="audio/annodex", local[i].ext="axa", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT)
#if defined(WEBSERVER_SUPPORT)
	local[i].type="application/xspf+xml", local[i].ext="xspf", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#endif // defined(WEBSERVER_SUPPORT)
	local[i].type="application/octet-stream", local[i].ext="", local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;
#if defined(_MIME_SUPPORT_)
	local[i].type="message/rfc822", local[i].ext="mime", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_MIME_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(_MIME_SUPPORT_)
	local[i].type="multipart/x-mixed-replace", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_MIXED_REPLACE_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
	local[i].type="multipart/mixed", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_MIXED_REPLACE_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#if defined(WBMULTIPART_MIXED_SUPPORT)
	local[i].type="application/vnd.wap.multipart.mixed", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_MIXED_BIN_REPLACE_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WBMULTIPART_MIXED_SUPPORT)
#if defined(WBMULTIPART_MIXED_SUPPORT)
	local[i].type="application/vnd.wap.multipart.related", local[i].ext="", local[i].action=VIEWER_OPERA, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_X_MIXED_BIN_REPLACE_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=false;local[i++].allow_any_extension=false;
#endif // defined(WBMULTIPART_MIXED_SUPPORT)
	local[i].type=NULL, local[i].ext=NULL, local[i].action=VIEWER_ASK_USER, local[i].ctype=FROM_RANGED_ENUM(URLContentType,URL_UNKNOWN_CONTENT), local[i].container=VIEWER_NULL;local[i].web_handler_allowed=true;local[i++].allow_any_extension=false;

	OP_ASSERT(i == defaultOperaViewerTypes_SIZE);
}

#endif //HAS_COMPLEX_GLOBALS
