/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionUnix, PCUNIX_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef _UNIX_DESKTOP_
	P(SUserPrefs, "Custom Colors", UNI_L("")),
#endif
#ifdef PREFS_HAVE_NEW_WIN_SIZE
	P(SUserPrefs, "NewWinSize", UNI_L("-1,-1")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionUnix, PCUNIX_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef PREFS_HAVE_FILESELECTOR
	I(SFileSelector, "Dialog Toolkit", 0, prefssetting::integer),
	I(SFileSelector, "Show Details", FALSE, prefssetting::boolean),
	I(SFileSelector, "Show Hidden Files", FALSE, prefssetting::boolean),
#endif
#ifdef _UNIX_DESKTOP_
	I(SFonts, "Prefer Fontconfig Settings", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_UNIX_PLUGIN
	I(SState, "Reading Plugins", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_APPEND_DEFAULT_EXT
	I(SUserPrefs, "Append Extension To Filename", TRUE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_X_FONTS
	I(SUserPrefs, "Draw Anti Aliased Fonts", TRUE, prefssetting::boolean),
#endif
#ifdef _UNIX_DESKTOP_
	I(SUserPrefs, "Enable Edit Triple Click", TRUE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_X_FONTS
	I(SUserPrefs, "Force DPI", 0, prefssetting::integer),
#endif
#ifdef _UNIX_DESKTOP_
	I(SUserPrefs, "Has Restored Extensions", 0, prefssetting::integer),
	I(SUserPrefs, "Has Restored MIME Flag", 0, prefssetting::integer),
	I(SUserPrefs, "Has Shown KDE Shortcut Message", 0, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_UNIX_PLUGIN
	I(SUserPrefs, "Has Shown Plugin Error", FALSE, prefssetting::boolean),
#endif
#ifdef _UNIX_DESKTOP_
	I(SUserPrefs, "Hide Mouse Cursor", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Localhost In DnD", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_META_KEY
	I(SUserPrefs, "Map Meta Button To Alt Button", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Open Dialog Under Mouse", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Panning mode", 0, prefssetting::integer),
#ifdef _UNIX_DESKTOP_
	I(SUserPrefs, "Show Window Border", 0, prefssetting::integer),
	I(SUserPrefs, "Window Menu Max Item Width", 40, prefssetting::integer),
#endif
	I(SUserPrefs, "Window Placement By Opera", TRUE, prefssetting::boolean),
#ifdef PREFS_HAVE_WORKSPACE
	I(SWorkspace, "Button Style", 0, prefssetting::integer),
	I(SWorkspace, "Button Type", MDI_BUTTON_ALL, prefssetting::integer),
	I(SWorkspace, "Window Border Width", 1, prefssetting::integer),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionUnix::stringpref e)
{
	switch (e) {
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::CustomColors:
		return dbg << "PrefsCollectionUnix::CustomColors";
#endif
#ifdef PREFS_HAVE_NEW_WIN_SIZE
	case PrefsCollectionUnix::NewWinSize:
		return dbg << "PrefsCollectionUnix::NewWinSize";
#endif
	default:
		return dbg << "PrefsCollectionUnix::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionUnix::integerpref e)
{
	switch (e) {
#ifdef PREFS_HAVE_FILESELECTOR
	case PrefsCollectionUnix::FileSelectorToolkit:
		return dbg << "PrefsCollectionUnix::FileSelectorToolkit";
	case PrefsCollectionUnix::FileSelectorShowDetails:
		return dbg << "PrefsCollectionUnix::FileSelectorShowDetails";
	case PrefsCollectionUnix::FileSelectorShowHiddenFiles:
		return dbg << "PrefsCollectionUnix::FileSelectorShowHiddenFiles";
#endif
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::PreferFontconfigSettings:
		return dbg << "PrefsCollectionUnix::PreferFontconfigSettings";
#endif
#ifdef PREFS_HAVE_UNIX_PLUGIN
	case PrefsCollectionUnix::ReadingPlugins:
		return dbg << "PrefsCollectionUnix::ReadingPlugins";
#endif
#ifdef PREFS_HAVE_APPEND_DEFAULT_EXT
	case PrefsCollectionUnix::AppendExtensionToFilename:
		return dbg << "PrefsCollectionUnix::AppendExtensionToFilename";
#endif
#ifdef PREFS_HAVE_X_FONTS
	case PrefsCollectionUnix::DrawAntiAliasedFonts:
		return dbg << "PrefsCollectionUnix::DrawAntiAliasedFonts";
#endif
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::EnableEditTripleClick:
		return dbg << "PrefsCollectionUnix::EnableEditTripleClick";
#endif
#ifdef PREFS_HAVE_X_FONTS
	case PrefsCollectionUnix::ForceDPI:
		return dbg << "PrefsCollectionUnix::ForceDPI";
#endif
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::HasRestoredExtenstions:
		return dbg << "PrefsCollectionUnix::HasRestoredExtenstions";
	case PrefsCollectionUnix::HasRestoredMIMEFlag:
		return dbg << "PrefsCollectionUnix::HasRestoredMIMEFlag";
	case PrefsCollectionUnix::HasShownKDEShortcutMessage:
		return dbg << "PrefsCollectionUnix::HasShownKDEShortcutMessage";
#endif
#ifdef PREFS_HAVE_UNIX_PLUGIN
	case PrefsCollectionUnix::HasShownPluginError:
		return dbg << "PrefsCollectionUnix::HasShownPluginError";
#endif
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::HideMouseCursor:
		return dbg << "PrefsCollectionUnix::HideMouseCursor";
	case PrefsCollectionUnix::LocalhostInDnD:
		return dbg << "PrefsCollectionUnix::LocalhostInDnD";
#endif
#ifdef PREFS_HAVE_META_KEY
	case PrefsCollectionUnix::MapMetaButtonToAltButton:
		return dbg << "PrefsCollectionUnix::MapMetaButtonToAltButton";
#endif
	case PrefsCollectionUnix::OpenDialogUnderMouse:
		return dbg << "PrefsCollectionUnix::OpenDialogUnderMouse";
	case PrefsCollectionUnix::PanningMode:
		return dbg << "PrefsCollectionUnix::PanningMode";
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionUnix::ShowWindowBorder:
		return dbg << "PrefsCollectionUnix::ShowWindowBorder";
	case PrefsCollectionUnix::WindowMenuMaxItemWidth:
		return dbg << "PrefsCollectionUnix::WindowMenuMaxItemWidth";
#endif
	case PrefsCollectionUnix::WindowPlacementByOpera:
		return dbg << "PrefsCollectionUnix::WindowPlacementByOpera";
#ifdef PREFS_HAVE_WORKSPACE
	case PrefsCollectionUnix::WorkSpaceButtonStyle:
		return dbg << "PrefsCollectionUnix::WorkSpaceButtonStyle";
	case PrefsCollectionUnix::WorkspaceButtonType:
		return dbg << "PrefsCollectionUnix::WorkspaceButtonType";
	case PrefsCollectionUnix::WorkspaceWindowBorderWidth:
		return dbg << "PrefsCollectionUnix::WorkspaceWindowBorderWidth";
#endif
	default:
		return dbg << "PrefsCollectionUnix::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
