/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionTools, PCTOOLS_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef INTEGRATED_DEVTOOLS_SUPPORT
	P(SDeveloperTools, "Developer Tools URL", UNI_L("https://dragonfly.opera.com/app/")),
#endif
#ifdef PREFS_TOOLS_PROXY
	P(SDeveloperTools, "Proxy Host", UNI_L("127.0.0.1")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionTools, PCTOOLS_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef PREFS_SCRIPT_DEBUG
	I(SDeveloperTools, "Enable Script Debugging", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_TOOLS_PROXY
	I(SDeveloperTools, "Proxy Auto Connect", FALSE, prefssetting::boolean),
	I(SDeveloperTools, "Proxy Port", 7001, prefssetting::integer),
#endif
#ifdef WEBSERVER_SUPPORT
	I(SDeveloperTools, "UPnP webserver port", WEB_PARM_DEFAULT_PORT + 1, prefssetting::integer),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionTools::stringpref e)
{
	switch (e) {
#ifdef INTEGRATED_DEVTOOLS_SUPPORT
	case PrefsCollectionTools::DevToolsUrl:
		return dbg << "PrefsCollectionTools::DevToolsUrl";
#endif
#ifdef PREFS_TOOLS_PROXY
	case PrefsCollectionTools::ProxyHost:
		return dbg << "PrefsCollectionTools::ProxyHost";
#endif
	default:
		return dbg << "PrefsCollectionTools::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionTools::integerpref e)
{
	switch (e) {
#ifdef PREFS_SCRIPT_DEBUG
	case PrefsCollectionTools::ScriptDebugging:
		return dbg << "PrefsCollectionTools::ScriptDebugging";
#endif
#ifdef PREFS_TOOLS_PROXY
	case PrefsCollectionTools::ProxyAutoConnect:
		return dbg << "PrefsCollectionTools::ProxyAutoConnect";
	case PrefsCollectionTools::ProxyPort:
		return dbg << "PrefsCollectionTools::ProxyPort";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionTools::UPnPWebserverPort:
		return dbg << "PrefsCollectionTools::UPnPWebserverPort";
#endif
	default:
		return dbg << "PrefsCollectionTools::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
