/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
	ServerAddress, ///< Address of the link server to synchronize with
	SyncClientState, ///< Opera Link (sync) sync state, generated by the server
	SyncClientStateBookmarks, ///< Opera Link (sync) sync state, generated by the server, and saved for Bookmarks
#ifdef SYNC_HAVE_EXTENSIONS
	SyncClientStateExtensions, ///< Opera Link (sync) sync state, generated by the server, and saved for Extensions
#endif
#ifdef SYNC_HAVE_NOTES
	SyncClientStateNotes, ///< Opera Link (sync) sync state, generated by the server, and saved for Notes
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	SyncClientStatePasswordManager, ///< Opera Link (sync) sync state, generated by the server, and saved for password manager
#endif
#ifdef SYNC_HAVE_SEARCHES
	SyncClientStateSearches, ///< Opera Link (sync) sync state, generated by the server, and saved for Searches
#endif
#if defined(SYNC_HAVE_SPEED_DIAL) && !defined(SYNC_HAVE_SPEED_DIAL_2)
	SyncClientStateSpeeddial, ///< Opera Link (sync) sync state, generated by the server, and saved for Speed dials
#endif
#ifdef SYNC_HAVE_SPEED_DIAL_2
	SyncClientStateSpeeddial2, ///< Opera Link (sync) sync state, generated by the server, and saved for Speed Dial 2
#endif
#ifdef SYNC_TYPED_HISTORY
	SyncClientStateTypedHistory, ///< Opera Link (sync) sync state, generated by the server, and saved for Typed History
#endif
#ifdef SYNC_CONTENT_FILTERS
	SyncClientStateURLFilter, ///< Opera Link (sync) sync state, generated by the server, and saved for URL Filter
#endif
#ifdef SUPPORT_DATA_SYNC
	SyncDataProvider, ///< Which data provider to use
#endif

	DummyLastStringPref
};
#define PCSYNC_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionSync::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
	CompleteSync, ///< If set, a complete sync is done on next sync
	SyncLogTraffic, ///< If set, will make the sync module log incoming and outgoing data
	LastCachedAccess, ///< Time for last signups
	LastCachedAccessNum, ///< Number of signups on day represented by "Time for last signups"
#ifdef SYNC_HAVE_BOOKMARKS
	SyncBookmarks, ///< If set, bookmarks will be synchronized
#endif
	SyncEnabled, ///< If set, Opera Link is enabled otherwise it's disabled
#ifdef SYNC_HAVE_EXTENSIONS
	SyncExtensions, ///< If set, installed extensions will be synchronized
#endif
#ifdef SYNC_HAVE_FEEDS
	SyncFeeds, ///< If set, feeds will be synchronized
#endif
	SyncLastUsed, ///< Last time Link was used. This is the number of seconds since epoch.
#ifdef SYNC_HAVE_NOTES
	SyncNotes, ///< If set, bookmarks on personalbar will be synchronized
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	SyncPasswordManager, ///< If set, passwords will be synchronized
#endif
#ifdef SYNC_HAVE_PERSONAL_BAR
	SyncPersonalbar, ///< If set, bookmarks on personalbar will be synchronized
#endif
#ifdef SYNC_HAVE_SEARCHES
	SyncSearches, ///< If set, search engines will be synchronized
#endif
#ifdef SYNC_HAVE_SPEED_DIAL
	SyncSpeeddial, ///< If set, speeddials will be synchronized
#endif
#ifdef SYNC_HAVE_TYPED_HISTORY
	SyncTypedHistory, ///< If set, typed history will be synchronized
#endif
#ifdef SYNC_CONTENT_FILTERS
	SyncURLFilter, ///< If set, URL filters will be synchronized
#endif
	SyncUsed, ///< If set, user has used Link

	DummyLastIntegerPref
};
#define PCSYNC_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionSync::DummyLastIntegerPref)

