/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionPrint, PCPRINT_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef _UNIX_DESKTOP_
	P(SPrinter, "FileName", UNI_L("")),
#endif
#ifdef GENERIC_PRINTING
	P(SPrinter, "Print Left Footer String", UNI_L("&u")),
	P(SPrinter, "Print Left Header String", UNI_L("&w")),
	P(SPrinter, "Print Right Footer String", UNI_L("&d &t")),
	P(SPrinter, "Print Right Header String", UNI_L("&p")),
#endif
#ifdef _UNIX_DESKTOP_
	P(SPrinter, "PrinterName", UNI_L("")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionPrint, PCPRINT_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SPrinter, "Bottom Margin", DEFAULT_BOTTOM_MARGIN, prefssetting::integer),
#ifdef GENERIC_PRINTING
	I(SPrinter, "Default Frames Print Type", PRINT_ALL_FRAMES, prefssetting::integer),
#endif
	I(SPrinter, "Fit To Width Print", TRUE, prefssetting::boolean),
	I(SPrinter, "Left Margin", DEFAULT_LEFT_MARGIN, prefssetting::integer),
	I(SPrinter, "Print Background", DEFAULT_PRINT_BACKGROUND, prefssetting::boolean),
#ifdef PREFS_HAVE_PRINT_JOB_TYPE
	I(SPrinter, "Print Job Type", PRINT_ALL_PAGES, prefssetting::integer),
#endif
	I(SPrinter, "Print To File DPI", 100, prefssetting::integer),
	I(SPrinter, "Print To File Height", 1169, prefssetting::integer),
	I(SPrinter, "Print To File Width", 827, prefssetting::integer),
#ifdef _UNIX_DESKTOP_
	I(SPrinter, "PrintToFile", FALSE, prefssetting::boolean),
#endif
	I(SPrinter, "Right Margin", DEFAULT_RIGHT_MARGIN, prefssetting::integer),
	I(SPrinter, "Scale", DEFAULT_PRINT_SCALE, prefssetting::integer),
	I(SPrinter, "Show Printer Header", DEFAULT_PRINT_HEADER, prefssetting::boolean),
	I(SPrinter, "Top Margin", DEFAULT_TOP_MARGIN, prefssetting::integer),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionPrint::stringpref e)
{
	switch (e) {
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionPrint::PrinterFileName:
		return dbg << "PrefsCollectionPrint::PrinterFileName";
#endif
#ifdef GENERIC_PRINTING
	case PrefsCollectionPrint::PrintLeftFooterString:
		return dbg << "PrefsCollectionPrint::PrintLeftFooterString";
	case PrefsCollectionPrint::PrintLeftHeaderString:
		return dbg << "PrefsCollectionPrint::PrintLeftHeaderString";
	case PrefsCollectionPrint::PrintRightFooterString:
		return dbg << "PrefsCollectionPrint::PrintRightFooterString";
	case PrefsCollectionPrint::PrintRightHeaderString:
		return dbg << "PrefsCollectionPrint::PrintRightHeaderString";
#endif
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionPrint::PrinterPrinterName:
		return dbg << "PrefsCollectionPrint::PrinterPrinterName";
#endif
	default:
		return dbg << "PrefsCollectionPrint::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionPrint::integerpref e)
{
	switch (e) {
	case PrefsCollectionPrint::MarginBottom:
		return dbg << "PrefsCollectionPrint::MarginBottom";
#ifdef GENERIC_PRINTING
	case PrefsCollectionPrint::DefaultFramesPrintType:
		return dbg << "PrefsCollectionPrint::DefaultFramesPrintType";
#endif
	case PrefsCollectionPrint::FitToWidthPrint:
		return dbg << "PrefsCollectionPrint::FitToWidthPrint";
	case PrefsCollectionPrint::MarginLeft:
		return dbg << "PrefsCollectionPrint::MarginLeft";
	case PrefsCollectionPrint::PrintBackground:
		return dbg << "PrefsCollectionPrint::PrintBackground";
#ifdef PREFS_HAVE_PRINT_JOB_TYPE
	case PrefsCollectionPrint::PrintJobType:
		return dbg << "PrefsCollectionPrint::PrintJobType";
#endif
	case PrefsCollectionPrint::PrintToFileDPI:
		return dbg << "PrefsCollectionPrint::PrintToFileDPI";
	case PrefsCollectionPrint::PrintToFileHeight:
		return dbg << "PrefsCollectionPrint::PrintToFileHeight";
	case PrefsCollectionPrint::PrintToFileWidth:
		return dbg << "PrefsCollectionPrint::PrintToFileWidth";
#ifdef _UNIX_DESKTOP_
	case PrefsCollectionPrint::PrinterToFile:
		return dbg << "PrefsCollectionPrint::PrinterToFile";
#endif
	case PrefsCollectionPrint::MarginRight:
		return dbg << "PrefsCollectionPrint::MarginRight";
	case PrefsCollectionPrint::PrinterScale:
		return dbg << "PrefsCollectionPrint::PrinterScale";
	case PrefsCollectionPrint::ShowPrintHeader:
		return dbg << "PrefsCollectionPrint::ShowPrintHeader";
	case PrefsCollectionPrint::MarginTop:
		return dbg << "PrefsCollectionPrint::MarginTop";
	default:
		return dbg << "PrefsCollectionPrint::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
