/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionOperaAccount, PCOPERA_ACCOUNT_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef WEBSERVER_SUPPORT
	P(SOperaAccount, "Computer ID", UNI_L("")),
#endif
#ifdef OPERA_AUTH_SUPPORT
	P(SOperaAccount, "OAuth Consumer Key", OAUTH_OPERA_ACCOUNT_CONSUMER_KEY_DEFAULT),
	P(SOperaAccount, "OAuth Consumer Secret", OAUTH_OPERA_ACCOUNT_CONSUMER_SECRET_DEFAULT),
	P(SOperaAccount, "OAuth access token URI", OAUTH_OPERA_ACCOUNT_ACCESS_TOKEN_URI_DEFAULT),
#endif
	P(SOperaAccount, "Server Address", DEFAULT_OPERA_AUTH_SERVER),
	P(SOperaAccount, "Username", UNI_L("")),

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionOperaAccount, PCOPERA_ACCOUNT_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SOperaAccount, "Opera Account Used", FALSE, prefssetting::boolean),
	I(SOperaAccount, "Save Password", TRUE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionOperaAccount::stringpref e)
{
	switch (e) {
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionOperaAccount::ComputerID:
		return dbg << "PrefsCollectionOperaAccount::ComputerID";
#endif
#ifdef OPERA_AUTH_SUPPORT
	case PrefsCollectionOperaAccount::OAuthOperaAccountConsumerKey:
		return dbg << "PrefsCollectionOperaAccount::OAuthOperaAccountConsumerKey";
	case PrefsCollectionOperaAccount::OAuthOperaAccountConsumerSecret:
		return dbg << "PrefsCollectionOperaAccount::OAuthOperaAccountConsumerSecret";
	case PrefsCollectionOperaAccount::OAuthOperaAccountAccessTokenURI:
		return dbg << "PrefsCollectionOperaAccount::OAuthOperaAccountAccessTokenURI";
#endif
	case PrefsCollectionOperaAccount::ServerAddress:
		return dbg << "PrefsCollectionOperaAccount::ServerAddress";
	case PrefsCollectionOperaAccount::Username:
		return dbg << "PrefsCollectionOperaAccount::Username";
	default:
		return dbg << "PrefsCollectionOperaAccount::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionOperaAccount::integerpref e)
{
	switch (e) {
	case PrefsCollectionOperaAccount::OperaAccountUsed:
		return dbg << "PrefsCollectionOperaAccount::OperaAccountUsed";
	case PrefsCollectionOperaAccount::SavePassword:
		return dbg << "PrefsCollectionOperaAccount::SavePassword";
	default:
		return dbg << "PrefsCollectionOperaAccount::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
