/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITFILES(PrefsCollectionFiles, PCFILES_NUMBEROFFILEPREFS)
{
	INITSTART
	/* Section, Key, Default folder, Default filename, Use default if file is not found */
#ifdef _BITTORRENT_SUPPORT_
	F(SBitTorrent, "Log File", OPFILE_HOME_FOLDER, UNI_L("bittorrent.log"), FALSE),
#endif
#ifdef PREFS_HAVE_HOTLIST_EXTRA
	F(SMailBox, "AddressFile", OPFILE_HOME_FOLDER, UNI_L("contacts.adr"), FALSE),
	F(SMailBox, "MusicFile", OPFILE_HOME_FOLDER, UNI_L("music.adr"), FALSE),
	F(SMailBox, "NotesFile", OPFILE_HOME_FOLDER, UNI_L("notes.adr"), FALSE),
#endif
#ifdef M2_SUPPORT
	F(SMail, "Mail Style File", OPFILE_STYLE_FOLDER, UNI_L("mail.css"), TRUE),
#endif
#ifdef _PLUGIN_SUPPORT_
	F(SNetwork, "Plugin Ignore File", OPFILE_INI_FOLDER, DEFAULT_PLUGINIGNORE_FILE, FALSE),
#endif
#ifdef URL_FILTER
	F(SNetwork, "URL Filter File", OPFILE_USERPREFS_FOLDER, DEFAULT_URLFILTER_FILE, FALSE),
#endif
#ifdef WEB_TURBO_MODE
	F(SProxy, "Opera Turbo Config File", OPFILE_INI_FOLDER, UNI_L("turbosettings.xml"), TRUE),
#endif
#if defined OPERA_URL_SUPPORT
	F(SUserPrefs, "About Style File", OPFILE_STYLE_FOLDER, UNI_L("about.css"), TRUE),
#endif
#ifdef AUTOSAVE_WINDOWS
	F(SUserPrefs, "Automatic Window Storage File", OPFILE_SESSION_FOLDER, UNI_L("autopera.win"), FALSE),
#endif
#ifdef PREFS_HAVE_BOOKMARKS_FILE
	F(SUserPrefs, "Bookmarks File", OPFILE_HOME_FOLDER, DEFAULT_CORE_BOOKMARKS_FILE, FALSE),
#endif
#ifdef OPERABOOKMARKS_URL
	F(SUserPrefs, "Bookmarks Style File", OPFILE_STYLE_FOLDER, UNI_L("bookmarks.css"), TRUE),
#endif
	F(SUserPrefs, "Browser CSS File", OPFILE_STYLE_FOLDER, UNI_L("browser.css"), TRUE),
#ifdef SKIN_SUPPORT
	F(SUserPrefs, "Button Set", OPFILE_DEFAULT_SKIN_FOLDER, DEFAULT_SKIN_FILE, FALSE),
#endif
#if defined CPUUSAGETRACKING
	F(SUserPrefs, "CPU Style File", OPFILE_STYLE_FOLDER, UNI_L("cpu.css"), TRUE),
#endif
#ifdef OPERA_URL_SUPPORT
	F(SUserPrefs, "Cache Style File", OPFILE_STYLE_FOLDER, UNI_L("cache.css"), TRUE),
#endif
#ifdef _SSL_SUPPORT_
	F(SUserPrefs, "Certificate Info CSS File", OPFILE_STYLE_FOLDER, UNI_L("certinfo.css"), TRUE),
#endif
#if defined OPERA_URL_SUPPORT && defined OPERACONFIG_URL
	F(SUserPrefs, "Config Style File", OPFILE_STYLE_FOLDER, UNI_L("config.css"), TRUE),
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	F(SUserPrefs, "Console Error Log", OPFILE_HOME_FOLDER, UNI_L("error.log"), FALSE),
#endif
#ifdef SUPPORT_VISUAL_ADBLOCK
	F(SUserPrefs, "Content Block CSS File", OPFILE_STYLE_FOLDER, UNI_L("contentblock.css"), TRUE),
#endif
#ifdef ABOUT_OPERA_DEBUG
	F(SUserPrefs, "Debug Style File", OPFILE_STYLE_FOLDER, UNI_L("debug.css"), TRUE),
#endif
#if defined DOM_JIL_API_SUPPORT
	F(SUserPrefs, "Device Settings File", OPFILE_DEVICE_SETTINGS_FOLDER, UNI_L("device.ini"), FALSE),
#endif
#if defined PREFS_HAVE_TOOLBARS
	F(SUserPrefs, "Dialog Configuration", OPFILE_HOME_FOLDER, UNI_L("dialog.ini"), FALSE),
#endif
#if defined _LOCALHOST_SUPPORT_ || defined FTP_SUPPORT
	F(SUserPrefs, "Dir Style File", OPFILE_STYLE_FOLDER, UNI_L("dir.css"), TRUE),
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	F(SUserPrefs, "Direct History File", OPFILE_HOME_FOLDER, DEFAULT_DIRECTHISTORY_FILE, FALSE),
#endif
#if defined PREFS_HOSTOVERRIDE && defined PREFSFILE_WRITE_GLOBAL
	F(SUserPrefs, "Downloaded Overrides File", OPFILE_HOME_FOLDER, DEFAULT_DL_OVERRIDES_FILE, FALSE),
#endif
#if defined _LOCALHOST_SUPPORT_ && defined SYS_CAP_FILESYSTEM_HAS_MULTIPLE_DRIVES
	F(SUserPrefs, "Drives Style File", OPFILE_STYLE_FOLDER, UNI_L("drives.css"), TRUE),
#endif
#ifdef PREFS_HAVE_ERROR_CSS
	F(SUserPrefs, "Error Style File", OPFILE_STYLE_FOLDER, UNI_L("error.css"), TRUE),
#endif
#if defined PREFS_HAVE_FASTFORWARD
	F(SUserPrefs, "Fast Forward Configuration", OPFILE_HOME_FOLDER, UNI_L("fastforward.ini"), FALSE),
#endif
#if defined OPERA_URL_SUPPORT
	F(SUserPrefs, "GPU Style File", OPFILE_STYLE_FOLDER, UNI_L("gpu.css"), TRUE),
#endif
#ifdef HISTORY_SUPPORT
	F(SUserPrefs, "Global History File", OPFILE_HOME_FOLDER, DEFAULT_GLOBALHISTORY_FILE, FALSE),
#endif
	F(SUserPrefs, "Handlers Data File", OPFILE_USERPREFS_FOLDER, UNI_L("handlers.ini"), FALSE),
#ifdef WEB_HANDLERS_SUPPORT
	F(SUserPrefs, "Handlers Ignore File", OPFILE_HANDLERS_FOLDER, UNI_L("handlers-ignore.ini"), FALSE),
#endif
#if defined OPERA_URL_SUPPORT && defined HISTORY_SUPPORT
	F(SUserPrefs, "History Style File", OPFILE_STYLE_FOLDER, UNI_L("history.css"), TRUE),
#endif
#ifdef PREFS_HAVE_HOTLIST
	F(SUserPrefs, "Hot List File Ver2", OPFILE_HOME_FOLDER, DEFAULT_BOOKMARKS_FILE, FALSE),
#endif
#ifdef M2_SUPPORT
	F(SUserPrefs, "IM Style File", OPFILE_STYLE_FOLDER, UNI_L("im.css"), TRUE),
#endif
	F(SUserPrefs, "Image Style File", OPFILE_STYLE_FOLDER, UNI_L("image.css"), TRUE),
#ifdef DOC_HAS_PAGE_INFO
	F(SUserPrefs, "Info CSS File", OPFILE_STYLE_FOLDER, UNI_L("info.css"), TRUE),
#endif
#if defined PREFS_HAVE_KEYBOARD_CONFIG
	F(SUserPrefs, "Keyboard Configuration", OPFILE_KEYBOARDSETUP_FOLDER, UNI_L("standard_keyboard.ini"), FALSE),
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	F(SUserPrefs, "Language File", OpFileFolder(-1), NULL, TRUE),
#endif
	F(SUserPrefs, "Local CSS File", OPFILE_STYLE_FOLDER, UNI_L("user.css"), TRUE),
#ifdef _MIME_SUPPORT_
	F(SUserPrefs, "MIME Style File", OPFILE_STYLE_FOLDER, UNI_L("mime.css"), TRUE),
#endif
#ifdef CSS_MATHML_STYLESHEET
	F(SUserPrefs, "MathML CSS File", OPFILE_STYLE_FOLDER, UNI_L("mathml.css"), TRUE),
#endif
#ifdef MEDIA_HTML_SUPPORT
	F(SUserPrefs, "Media Style File", OPFILE_STYLE_FOLDER, UNI_L("media.css"), TRUE),
#endif
#if defined PREFS_HAVE_TOOLBARS
	F(SUserPrefs, "Menu Configuration", OPFILE_MENUSETUP_FOLDER, UNI_L("standard_menu.ini"), FALSE),
#endif
	F(SUserPrefs, "Message Style File", OPFILE_STYLE_FOLDER, UNI_L("message.css"), TRUE),
#if defined PREFS_HAVE_MOUSE_CONFIG
	F(SUserPrefs, "Mouse Configuration", OPFILE_MOUSESETUP_FOLDER, UNI_L("standard_mouse.ini"), FALSE),
#endif
#ifdef SELFTEST
	F(SUserPrefs, "Opera Selftest Style File", OPFILE_STYLE_FOLDER, UNI_L("selftest.css"), TRUE),
#endif
#if defined OPERAUNITE_URL || defined OPERAWIDGETS_URL
	F(SUserPrefs, "Opera Widgets/Unite Style File", OPFILE_STYLE_FOLDER, UNI_L("widgets.css"), TRUE),
#endif
#ifdef PREFS_HOSTOVERRIDE
	F(SUserPrefs, "Overrides File", OPFILE_HOME_FOLDER, DEFAULT_OVERRIDES_FILE, FALSE),
#endif
#if defined SKIN_SUPPORT && defined PERSONA_SKIN_SUPPORT
	F(SUserPrefs, "Persona File", OPFILE_DEFAULT_SKIN_FOLDER, UNI_L(""), FALSE),
#endif
#if defined OPERA_URL_SUPPORT && defined _PLUGIN_SUPPORT_
	F(SUserPrefs, "Plugins Style File", OPFILE_STYLE_FOLDER, UNI_L("plugins.css"), TRUE),
#endif
	F(SUserPrefs, "Private Mode Style File", OPFILE_STYLE_FOLDER, UNI_L("private.css"), TRUE),
#if !defined CORE_SPEED_DIAL_SUPPORT
	F(SUserPrefs, "Speed Dial File", OPFILE_USERPREFS_FOLDER, UNI_L("speeddial.ini"), FALSE),
#endif
#ifdef OPERASPEEDDIAL_URL
	F(SUserPrefs, "Speed Dial Style File", OPFILE_STYLE_FOLDER, UNI_L("speeddial.css"), TRUE),
#endif
#if defined PREFS_HAVE_TOOLBARS
	F(SUserPrefs, "Toolbar Configuration", OPFILE_TOOLBARSETUP_FOLDER, UNI_L("standard_toolbar.ini"), FALSE),
#endif
	F(SUserPrefs, "User Style Info File", OPFILE_HOME_FOLDER, UNI_L("userstyle.ini"), TRUE),
#ifdef MEDIA_HTML_SUPPORT
	F(SUserPrefs, "Videobackend File", OPFILE_VIDEO_FOLDER, UNI_L("videobackend.so"), FALSE),
#endif
#ifdef OPERAHISTORYSEARCH_URL
	F(SUserPrefs, "Visited Pages Search Style", OPFILE_STYLE_FOLDER, UNI_L("search.css"), TRUE),
#endif
#ifdef _WML_SUPPORT_
	F(SUserPrefs, "WML CSS File", OPFILE_STYLE_FOLDER, UNI_L("wml.css"), TRUE),
#endif
#ifdef WAND_SUPPORT
	F(SUserPrefs, "Wand Storage File", OPFILE_SECURE_FOLDER, UNI_L("wand.dat"), TRUE),
#endif
	F(SUserPrefs, "Warning Page CSS File", OPFILE_STYLE_FOLDER, UNI_L("warning.css"), TRUE),
#if defined DATABASE_STORAGE_SUPPORT || defined CLIENTSIDE_STORAGE_SUPPORT
	F(SUserPrefs, "WebStorage Style File", OPFILE_STYLE_FOLDER, UNI_L("webstorage.css"), TRUE),
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && defined USE_ABOUT_TEMPLATES
	F(SUserPrefs, "Webfeeds HTML Template File", OPFILE_STYLE_FOLDER, UNI_L("webfeeds.html"), TRUE),
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && !defined USE_ABOUT_TEMPLATES
	F(SUserPrefs, "Webfeeds Style File", OPFILE_STYLE_FOLDER, UNI_L("webfeed.css"), TRUE),
#endif
#ifdef SESSION_SUPPORT
	F(SUserPrefs, "Windows Storage File", OPFILE_SESSION_FOLDER, DEFAULT_WINSTORAGE_FILE, FALSE),
#endif
#ifdef WEBSERVER_SUPPORT
	F(SWebServer, "Resource Configuration", OPFILE_HOME_FOLDER, UNI_L("webserver.ini"), FALSE),
	F(SWebServer, "Trusted Repositories File", OPFILE_USERPREFS_FOLDER, UNI_L("trusted_repositories.ini"), FALSE),
#endif
#if defined PREFS_HAVE_HOTLIST_EXTRA && defined GADGET_SUPPORT
	F(SWidgets, "Widgets File", OPFILE_HOME_FOLDER, UNI_L("widgets.adr"), FALSE),
#endif

	// Sentinel, always the last entry
	F(SNone, NULL, OpFileFolder(-1), NULL, FALSE)
	INITEND
};

#ifdef PREFS_READ
/** The directories that can be configured here are defined by
  * OpFolderManager's OpFileFolder enumeration.*/
INITFOLDERS(PrefsCollectionFiles, PCFILES_NUMBEROFFOLDERPREFS)
{
	INITSTART
	/* Folder, Section, Key */
#ifdef M2_SUPPORT
	// Mail root directory
	D(OPFILE_MAIL_FOLDER, SMail, "Mail Root Directory"),
#endif
#ifdef _FILE_UPLOAD_SUPPORT_
	// File-Open directory
	D(OPFILE_OPEN_FOLDER, SSavedSettings, "Open Dir"),
	// File-Save directory
	D(OPFILE_SAVE_FOLDER, SSavedSettings, "Save Dir"),
#endif
#ifdef PREFS_HAVE_BUTTON_FOLDER
	// Skin directory
	D(OPFILE_BUTTON_FOLDER, SUserPrefs, "Button Directory"),
#endif
#ifdef DISK_CACHE_SUPPORT
	// Cache directory
	D(OPFILE_CACHE_FOLDER, SUserPrefs, "Cache Directory4"),
#endif
	// Cookies (write) directory
	D(OPFILE_COOKIE_FOLDER, SUserPrefs, "Cookies Directory"),
#if defined DOM_JIL_API_SUPPORT
	// Directory containing device specific configuration files
	D(OPFILE_DEVICE_SETTINGS_FOLDER, SUserPrefs, "Device Settings Directory"),
#endif
#ifdef PREFS_HAVE_DOWNLOAD_FOLDER
	// Download directory
	D(OPFILE_DOWNLOAD_FOLDER, SUserPrefs, "Download Directory"),
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	// Opera language directory. This is the default location to look for language files etc. Note that the current language file may well reside somewhere else.
	D(OPFILE_LANGUAGE_FOLDER, SUserPrefs, "Language Files Directory"),
#endif
#ifdef PREFS_USE_CSS_FOLDER_SCAN
	// User style sheets directory
	D(OPFILE_USERPREFSSTYLE_FOLDER, SUserPrefs, "Local CSS Files Directory"),
#endif
	// Opera home (write) directory
	D(OPFILE_HOME_FOLDER, SUserPrefs, "Opera Directory"),
#ifdef UTIL_HAVE_LOCAL_HOME_FOLDER
	// Opera home (write) directory that is not part of the roaming profile
	D(OPFILE_LOCAL_HOME_FOLDER, SUserPrefs, "Opera Local Directory"),
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	// Operator cache directory
	D(OPFILE_OCACHE_FOLDER, SUserPrefs, "Operator Cache Directory4"),
#endif
#ifdef SKIN_SUPPORT
	// Skin directory
	D(OPFILE_SKIN_FOLDER, SUserPrefs, "Skin Directory"),
#endif
#ifdef EXTERNAL_APPLICATIONS_SUPPORT
	// Temporary Download directory
	D(OPFILE_TEMPDOWNLOAD_FOLDER, SUserPrefs, "Temporary Download Directory"),
#endif
#ifdef WEBSERVER_SUPPORT
	// Absolute path for web server's directory
	D(OPFILE_WEBSERVER_FOLDER, SWebServer, "Directory"),
#endif

	// Sentinel, always the last entry
	D(OpFileFolder(-1), SNone, NULL)
	INITEND
};
#endif


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionFiles::filepref e)
{
	switch (e) {
#ifdef _BITTORRENT_SUPPORT_
	case PrefsCollectionFiles::BTLogfile:
		return dbg << "PrefsCollectionFiles::BTLogfile";
#endif
#ifdef PREFS_HAVE_HOTLIST_EXTRA
	case PrefsCollectionFiles::ContactListFile:
		return dbg << "PrefsCollectionFiles::ContactListFile";
	case PrefsCollectionFiles::MusicListFile:
		return dbg << "PrefsCollectionFiles::MusicListFile";
	case PrefsCollectionFiles::NoteListFile:
		return dbg << "PrefsCollectionFiles::NoteListFile";
#endif
#ifdef M2_SUPPORT
	case PrefsCollectionFiles::StyleMailFile:
		return dbg << "PrefsCollectionFiles::StyleMailFile";
#endif
#ifdef _PLUGIN_SUPPORT_
	case PrefsCollectionFiles::PluginIgnoreFile:
		return dbg << "PrefsCollectionFiles::PluginIgnoreFile";
#endif
#ifdef URL_FILTER
	case PrefsCollectionFiles::UrlFilterFile:
		return dbg << "PrefsCollectionFiles::UrlFilterFile";
#endif
#ifdef WEB_TURBO_MODE
	case PrefsCollectionFiles::WebTurboConfigFile:
		return dbg << "PrefsCollectionFiles::WebTurboConfigFile";
#endif
#if defined OPERA_URL_SUPPORT
	case PrefsCollectionFiles::StyleAboutFile:
		return dbg << "PrefsCollectionFiles::StyleAboutFile";
#endif
#ifdef AUTOSAVE_WINDOWS
	case PrefsCollectionFiles::AutosaveWindowsStorageFile:
		return dbg << "PrefsCollectionFiles::AutosaveWindowsStorageFile";
#endif
#ifdef PREFS_HAVE_BOOKMARKS_FILE
	case PrefsCollectionFiles::BookmarksFile:
		return dbg << "PrefsCollectionFiles::BookmarksFile";
#endif
#ifdef OPERABOOKMARKS_URL
	case PrefsCollectionFiles::StyleBookmarksFile:
		return dbg << "PrefsCollectionFiles::StyleBookmarksFile";
#endif
	case PrefsCollectionFiles::BrowserCSSFile:
		return dbg << "PrefsCollectionFiles::BrowserCSSFile";
#ifdef SKIN_SUPPORT
	case PrefsCollectionFiles::ButtonSet:
		return dbg << "PrefsCollectionFiles::ButtonSet";
#endif
#if defined CPUUSAGETRACKING
	case PrefsCollectionFiles::StyleCPUFile:
		return dbg << "PrefsCollectionFiles::StyleCPUFile";
#endif
#ifdef OPERA_URL_SUPPORT
	case PrefsCollectionFiles::StyleCacheFile:
		return dbg << "PrefsCollectionFiles::StyleCacheFile";
#endif
#ifdef _SSL_SUPPORT_
	case PrefsCollectionFiles::StyleCertificateInfoPanelFile:
		return dbg << "PrefsCollectionFiles::StyleCertificateInfoPanelFile";
#endif
#if defined OPERA_URL_SUPPORT && defined OPERACONFIG_URL
	case PrefsCollectionFiles::StyleConfigFile:
		return dbg << "PrefsCollectionFiles::StyleConfigFile";
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	case PrefsCollectionFiles::ConsoleErrorLogName:
		return dbg << "PrefsCollectionFiles::ConsoleErrorLogName";
#endif
#ifdef SUPPORT_VISUAL_ADBLOCK
	case PrefsCollectionFiles::ContentBlockCSSFile:
		return dbg << "PrefsCollectionFiles::ContentBlockCSSFile";
#endif
#ifdef ABOUT_OPERA_DEBUG
	case PrefsCollectionFiles::StyleDebugFile:
		return dbg << "PrefsCollectionFiles::StyleDebugFile";
#endif
#if defined DOM_JIL_API_SUPPORT
	case PrefsCollectionFiles::DeviceSettingsFile:
		return dbg << "PrefsCollectionFiles::DeviceSettingsFile";
#endif
#if defined PREFS_HAVE_TOOLBARS
	case PrefsCollectionFiles::DialogConfig:
		return dbg << "PrefsCollectionFiles::DialogConfig";
#endif
#if defined _LOCALHOST_SUPPORT_ || defined FTP_SUPPORT
	case PrefsCollectionFiles::StyleDirFile:
		return dbg << "PrefsCollectionFiles::StyleDirFile";
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	case PrefsCollectionFiles::DirectHistoryFile:
		return dbg << "PrefsCollectionFiles::DirectHistoryFile";
#endif
#if defined PREFS_HOSTOVERRIDE && defined PREFSFILE_WRITE_GLOBAL
	case PrefsCollectionFiles::DownloadedOverridesFile:
		return dbg << "PrefsCollectionFiles::DownloadedOverridesFile";
#endif
#if defined _LOCALHOST_SUPPORT_ && defined SYS_CAP_FILESYSTEM_HAS_MULTIPLE_DRIVES
	case PrefsCollectionFiles::StyleDrivesFile:
		return dbg << "PrefsCollectionFiles::StyleDrivesFile";
#endif
#ifdef PREFS_HAVE_ERROR_CSS
	case PrefsCollectionFiles::StyleErrorFile:
		return dbg << "PrefsCollectionFiles::StyleErrorFile";
#endif
#if defined PREFS_HAVE_FASTFORWARD
	case PrefsCollectionFiles::FastForwardFile:
		return dbg << "PrefsCollectionFiles::FastForwardFile";
#endif
#if defined OPERA_URL_SUPPORT
	case PrefsCollectionFiles::StyleGPUFile:
		return dbg << "PrefsCollectionFiles::StyleGPUFile";
#endif
#ifdef HISTORY_SUPPORT
	case PrefsCollectionFiles::GlobalHistoryFile:
		return dbg << "PrefsCollectionFiles::GlobalHistoryFile";
#endif
	case PrefsCollectionFiles::HandlersDataFile:
		return dbg << "PrefsCollectionFiles::HandlersDataFile";
#ifdef WEB_HANDLERS_SUPPORT
	case PrefsCollectionFiles::HandlersIgnoreFile:
		return dbg << "PrefsCollectionFiles::HandlersIgnoreFile";
#endif
#if defined OPERA_URL_SUPPORT && defined HISTORY_SUPPORT
	case PrefsCollectionFiles::StyleHistoryFile:
		return dbg << "PrefsCollectionFiles::StyleHistoryFile";
#endif
#ifdef PREFS_HAVE_HOTLIST
	case PrefsCollectionFiles::HotListFile:
		return dbg << "PrefsCollectionFiles::HotListFile";
#endif
#ifdef M2_SUPPORT
	case PrefsCollectionFiles::StyleIMFile:
		return dbg << "PrefsCollectionFiles::StyleIMFile";
#endif
	case PrefsCollectionFiles::StyleImageFile:
		return dbg << "PrefsCollectionFiles::StyleImageFile";
#ifdef DOC_HAS_PAGE_INFO
	case PrefsCollectionFiles::StyleInfoPanelFile:
		return dbg << "PrefsCollectionFiles::StyleInfoPanelFile";
#endif
#if defined PREFS_HAVE_KEYBOARD_CONFIG
	case PrefsCollectionFiles::KeyboardConfig:
		return dbg << "PrefsCollectionFiles::KeyboardConfig";
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	case PrefsCollectionFiles::LanguageFile:
		return dbg << "PrefsCollectionFiles::LanguageFile";
#endif
	case PrefsCollectionFiles::LocalCSSFile:
		return dbg << "PrefsCollectionFiles::LocalCSSFile";
#ifdef _MIME_SUPPORT_
	case PrefsCollectionFiles::StyleMIMEFile:
		return dbg << "PrefsCollectionFiles::StyleMIMEFile";
#endif
#ifdef CSS_MATHML_STYLESHEET
	case PrefsCollectionFiles::MathMLCSSFile:
		return dbg << "PrefsCollectionFiles::MathMLCSSFile";
#endif
#ifdef MEDIA_HTML_SUPPORT
	case PrefsCollectionFiles::StyleMediaFile:
		return dbg << "PrefsCollectionFiles::StyleMediaFile";
#endif
#if defined PREFS_HAVE_TOOLBARS
	case PrefsCollectionFiles::MenuConfig:
		return dbg << "PrefsCollectionFiles::MenuConfig";
#endif
	case PrefsCollectionFiles::StyleMessageFile:
		return dbg << "PrefsCollectionFiles::StyleMessageFile";
#if defined PREFS_HAVE_MOUSE_CONFIG
	case PrefsCollectionFiles::MouseConfig:
		return dbg << "PrefsCollectionFiles::MouseConfig";
#endif
#ifdef SELFTEST
	case PrefsCollectionFiles::StyleSelftestFile:
		return dbg << "PrefsCollectionFiles::StyleSelftestFile";
#endif
#if defined OPERAUNITE_URL || defined OPERAWIDGETS_URL
	case PrefsCollectionFiles::StyleWidgetsFile:
		return dbg << "PrefsCollectionFiles::StyleWidgetsFile";
#endif
#ifdef PREFS_HOSTOVERRIDE
	case PrefsCollectionFiles::OverridesFile:
		return dbg << "PrefsCollectionFiles::OverridesFile";
#endif
#if defined SKIN_SUPPORT && defined PERSONA_SKIN_SUPPORT
	case PrefsCollectionFiles::PersonaFile:
		return dbg << "PrefsCollectionFiles::PersonaFile";
#endif
#if defined OPERA_URL_SUPPORT && defined _PLUGIN_SUPPORT_
	case PrefsCollectionFiles::StylePluginsFile:
		return dbg << "PrefsCollectionFiles::StylePluginsFile";
#endif
	case PrefsCollectionFiles::StylePrivateModeFile:
		return dbg << "PrefsCollectionFiles::StylePrivateModeFile";
#if !defined CORE_SPEED_DIAL_SUPPORT
	case PrefsCollectionFiles::SpeedDialFile:
		return dbg << "PrefsCollectionFiles::SpeedDialFile";
#endif
#ifdef OPERASPEEDDIAL_URL
	case PrefsCollectionFiles::StyleSpeedDialFile:
		return dbg << "PrefsCollectionFiles::StyleSpeedDialFile";
#endif
#if defined PREFS_HAVE_TOOLBARS
	case PrefsCollectionFiles::ToolbarConfig:
		return dbg << "PrefsCollectionFiles::ToolbarConfig";
#endif
	case PrefsCollectionFiles::UserStyleIniFile:
		return dbg << "PrefsCollectionFiles::UserStyleIniFile";
#ifdef MEDIA_HTML_SUPPORT
	case PrefsCollectionFiles::VideobackendFile:
		return dbg << "PrefsCollectionFiles::VideobackendFile";
#endif
#ifdef OPERAHISTORYSEARCH_URL
	case PrefsCollectionFiles::StyleSearchFile:
		return dbg << "PrefsCollectionFiles::StyleSearchFile";
#endif
#ifdef _WML_SUPPORT_
	case PrefsCollectionFiles::WMLCSSFile:
		return dbg << "PrefsCollectionFiles::WMLCSSFile";
#endif
#ifdef WAND_SUPPORT
	case PrefsCollectionFiles::WandFile:
		return dbg << "PrefsCollectionFiles::WandFile";
#endif
	case PrefsCollectionFiles::StyleWarningFile:
		return dbg << "PrefsCollectionFiles::StyleWarningFile";
#if defined DATABASE_STORAGE_SUPPORT || defined CLIENTSIDE_STORAGE_SUPPORT
	case PrefsCollectionFiles::StyleWebStorageFile:
		return dbg << "PrefsCollectionFiles::StyleWebStorageFile";
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && defined USE_ABOUT_TEMPLATES
	case PrefsCollectionFiles::TemplateWebFeedsDisplay:
		return dbg << "PrefsCollectionFiles::TemplateWebFeedsDisplay";
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && !defined USE_ABOUT_TEMPLATES
	case PrefsCollectionFiles::StyleWebFeedsDisplay:
		return dbg << "PrefsCollectionFiles::StyleWebFeedsDisplay";
#endif
#ifdef SESSION_SUPPORT
	case PrefsCollectionFiles::WindowsStorageFile:
		return dbg << "PrefsCollectionFiles::WindowsStorageFile";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionFiles::WebserverResourceConfiguration:
		return dbg << "PrefsCollectionFiles::WebserverResourceConfiguration";
	case PrefsCollectionFiles::TrustedRepositoriesFile:
		return dbg << "PrefsCollectionFiles::TrustedRepositoriesFile";
#endif
#if defined PREFS_HAVE_HOTLIST_EXTRA && defined GADGET_SUPPORT
	case PrefsCollectionFiles::GadgetListFile:
		return dbg << "PrefsCollectionFiles::GadgetListFile";
#endif
	default:
		return dbg << "PrefsCollectionFiles::filepref(unknown:" << (int)e << ")";
	}
}

#ifdef PREFS_READ
Debug& operator<<(Debug& dbg, enum PrefsCollectionFiles::directorypref e)
{
	switch (e) {
#ifdef M2_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_MAIL_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_MAIL_FOLDER";
#endif
#ifdef _FILE_UPLOAD_SUPPORT_
	case PrefsCollectionFiles::dummy_OPFILE_OPEN_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_OPEN_FOLDER";
	case PrefsCollectionFiles::dummy_OPFILE_SAVE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_SAVE_FOLDER";
#endif
#ifdef PREFS_HAVE_BUTTON_FOLDER
	case PrefsCollectionFiles::dummy_OPFILE_BUTTON_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_BUTTON_FOLDER";
#endif
#ifdef DISK_CACHE_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_CACHE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_CACHE_FOLDER";
#endif
	case PrefsCollectionFiles::dummy_OPFILE_COOKIE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_COOKIE_FOLDER";
#if defined DOM_JIL_API_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_DEVICE_SETTINGS_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_DEVICE_SETTINGS_FOLDER";
#endif
#ifdef PREFS_HAVE_DOWNLOAD_FOLDER
	case PrefsCollectionFiles::dummy_OPFILE_DOWNLOAD_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_DOWNLOAD_FOLDER";
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	case PrefsCollectionFiles::dummy_OPFILE_LANGUAGE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_LANGUAGE_FOLDER";
#endif
#ifdef PREFS_USE_CSS_FOLDER_SCAN
	case PrefsCollectionFiles::dummy_OPFILE_USERPREFSSTYLE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_USERPREFSSTYLE_FOLDER";
#endif
	case PrefsCollectionFiles::dummy_OPFILE_HOME_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_HOME_FOLDER";
#ifdef UTIL_HAVE_LOCAL_HOME_FOLDER
	case PrefsCollectionFiles::dummy_OPFILE_LOCAL_HOME_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_LOCAL_HOME_FOLDER";
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	case PrefsCollectionFiles::dummy_OPFILE_OCACHE_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_OCACHE_FOLDER";
#endif
#ifdef SKIN_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_SKIN_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_SKIN_FOLDER";
#endif
#ifdef EXTERNAL_APPLICATIONS_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_TEMPDOWNLOAD_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_TEMPDOWNLOAD_FOLDER";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionFiles::dummy_OPFILE_WEBSERVER_FOLDER:
		return dbg << "PrefsCollectionFiles::OPFILE_WEBSERVER_FOLDER";
#endif
	default:
		return dbg << "PrefsCollectionFiles::directorypref(unknown:" << (int)e << ")";
	}
}
#endif

#endif // DEBUG
