/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
#ifdef PREFS_DOWNLOAD
	PreferenceServer, ///< URL of Operas customized preference server
#endif
	Address, ///< Address for form autocomplete
	City, ///< City for form autocomplete
	Country, ///< Country for form autocomplete
	EMail, ///< E-mail address for form autocomplete
	Firstname, ///< First name for form autocomple
	Home, ///< Home page for form autocomplete
	Special1, ///< Extra field 1 for form autocomplete
	Special2, ///< Extra field 2 for form autocomplete
	Special3, ///< Extra field 3 for form autocomplete
	State, ///< State for form autocomplete
	Surname, ///< Surname for form autocomplete
	Telefax, ///< Mobile/telefax number for form autocomplete
	Telephone, ///< Telephone number for form autocomplete
	Zip, ///< Zip code for form autocomplete
#if defined(VEGA_BACKENDS_BLOCKLIST_FETCH)
	BlocklistLocation, ///< location of the blocklist files used to determine whether hw acc can be enabled
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	ErrorLogFilter, ///< Filter to use in console error log
#endif
#ifdef PREFS_HAVE_CUSTOM_UA
	CustomUAString, ///< Custom User-Agent string
#endif
	HomeURL, ///< Global start page
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	LastUsedSpellcheckLanguage, ///< Last language used for spellchecking
#endif

	DummyLastStringPref
};
#define PCCORE_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionCore::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
#ifdef APPLICATION_CACHE_SUPPORT
	DefaultApplicationCacheQuota, ///< Default maximum size for offline application caches in kbytes
#endif
	RamCacheDocs, ///< Enable caching of documents in memory
	RamCacheFigs, ///< Enable caching of images in memory
	DocumentCacheSize, ///< Size of document RAM cache in kbytes
	ImageRAMCacheSize, ///< Size of image RAM cache in kbytes
#ifdef SVG_SUPPORT
	SVGRAMCacheSize, ///< Size of svg image RAM cache in kbytes
#endif
#ifdef NEARBY_ELEMENT_DETECTION
	AlwaysExpandLinks, ///< Always expand nearby elements, even if user clicks directly inside an element and there are no nearby elements
	DetectNearbyElements, ///< Detect nearby anchor and form elements within a radius specified by NearbyElementsRadius
	ExpandedMinimumSize, ///< Expanded elements window minimum size. Elements will be drawn scaled or positioned centered inside if they are not big enough.
	NearbyElementsRadius, ///< Radius (in points (1/72 inch)) within which to look for nearby anchor and form elements. NearbyElementsRadius must be enabled for this to have any effect. The default of 22pt is about 7.6mm, which is allegedly Microsoft's definition of finger size.
#endif
#ifdef PREFS_HAVE_ANIMATION_THROTTLING
	LagThresholdForAnimationThrottling, ///< The average lag (in ms) of messages in dispatcher's queue that should be considered as throttling trigger. This value is a threshold used to determine whether the throttling of animated content is needed or not.
	SwitchAnimationThrottlingInterval, ///< The minimal interval (in ms) that should be kept between enabling/disabling the throttling of animated content. This value is used used to not switch the throttling to often.
#endif
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	AllowComponentsInUAStringComment, ///< Allow adding extra components to UA string
#endif
#ifdef WAND_SUPPORT
	AutocompleteOffDisablesWand, ///< Enable support for autocomplete="off"
#endif
#ifdef VEGA_BACKENDS_BLOCKLIST_FETCH
	BlocklistRefetchDelay, ///< how long to wait, in seconds, before updating the blocklist
	BlocklistRetryDelay, ///< how long to wait, in seconds, before a new attempt is made to fetch blocklist on failure
#endif
	ColorSchemeMode, ///< Auto color scheme system enabled
#ifdef OPERA_CONSOLE_LOGFILE
	UseErrorLog, ///< Enable logging of console errors to file
#endif
#ifdef MOUSE_SUPPORT
	EnableGesture, ///< Enable mouse gestures
#endif
#ifdef VEGA_3DDEVICE
	EnableHardwareAcceleration, ///< Set 0 to disable hardware acceleration, 1 for autodetect (default), 2 to force on if available (use at your own risk).
#endif
#ifdef MOUSE_SUPPORT
	EnableMouseFlips, ///< Enable mouse flip back and forward
#endif
#ifdef CORE_SPEED_DIAL_SUPPORT
	EnableSpeedDial, ///< Set to false to disable speed dial
#endif
#ifdef DOM_LOAD_TV_APP
	EnableTVStore, ///< Enable TV Store functionality
#endif
#ifdef WAND_SUPPORT
	EnableWand, ///< Enable Wand support
#endif
#ifdef CANVAS3D_SUPPORT
	EnableWebGL, ///< Set 0 to disable WebGL, 1 for autodetect (default), 2 to force on if possible (use at your own risk).
#endif
#ifdef OPERACONFIG_URL
	OperaConfigEnabled, ///< Enable opera:config
#endif
#ifdef MOUSE_SUPPORT
	GestureThreshold, ///< Threshold for mouse gestures
#endif
#ifdef PREFS_HAVE_LAST_SITEPATCH_UPDATE_CHECK
	LastSitepatchUpdateCheck, ///< Identifies when the last sitepatch update check was performed. The integer represents the number of seconds since epoch, when the last update check was performed.
#endif
#ifdef OPERA_CONSOLE
	MaxConsoleMessages, ///< Maximum number of messages in the console
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	MaxDirectHistory, ///< Maximum number of direct addressing history items
#endif
	MaxGlobalHistory, ///< Maximum number of global history items
	MaxWindowHistory, ///< Maximum number of window history items
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	BookmarksMaxFolderDepth, ///< Maximum allowed bookmark folder depth
	BookmarksCreatedMaxLength, ///< Maximum allowed length of created time string
	BookmarksDescMaxLength, ///< Maximum allowed length of bookmark description
	BookmarksFaviconFileMaxLength, ///< Maximum allowed length of bookmark favicon file name
	BookmarksSnMaxLength, ///< Maximum allowed length of bookmark shortname
	BookmarksThumbnailFileMaxLength, ///< Maximum allowed length of bookmark thumbnail file name
	BookmarksTitleMaxLength, ///< Maximum allowed length of bookmark title
	BookmarksUrlMaxLength, ///< Maximum allowed length of bookmark url
	BookmarksVisitedMaxLength, ///< Maximum allowed length of visited time string
	BookmarksMaxCount, ///< Maximum total number of bookmarks
	BookmarksMaxCountPerFolder, ///< Maximum allowed bookmark count per folder
#endif
#ifdef SEARCH_ENGINES
	PreferredNumberOfHits, ///< Preferred number of search hits
#endif
#ifdef PREFS_HAVE_SPOOF_TIMESTAMP
	SpoofServerTimeStamp, ///< Timestamp of the overrides file which is currently available at the server. This value is different from SpoofTimeStamp if an overrides file update is available on the server, but the update was not yet downloaded and installed.
	SpoofTimeStamp, ///< Timestamp of the currently used overrides file, used when checking for updates.
#endif
#if defined UPGRADE_SUPPORT && defined PREFS_WRITE
	PreferenceUpgrade, ///< Internal flag for prefs for upgrades
#endif
#if defined PREFS_HAVE_PREFERRED_RENDERER
	PreferredRenderer, ///< Set to 0 for OpenGL, 1 for DX10 (Hardware), 2 for DX10 (Warp).
#endif
#ifdef WEB_HANDLERS_SUPPORT
	ProtocolsListServerTimeStamp, ///< Timestamp of the handler-ignore.ini file which is currently available at the server. This value is different from ProtocolsWLTimeStamp if an handlers-ignore.ini file update is available on the server, but the update was not yet downloaded and installed.
	ProtocolsListTimeStamp, ///< Timestamp of the currently used handler-ignore.ini file, used when checking for updates.
#endif
#ifdef MOUSE_SUPPORT
	ReverseButtonFlipping, ///< Use left-handed flipback/flipforward gestures
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	BookmarksSavePolicy, ///< Save policy used when bookmarks have changed
#endif
#ifdef PHONE_SN_HANDLER
	ScrollStep, ///< Percent to scroll with arrow key in desktop mode
	ScrollStepHandheld, ///< Percent to scroll with arrow key in handheld mode
	ScrollStepHorizontal, ///< Percent to scroll horizontally with arrow key
#endif
#ifdef AB_ERROR_SEARCH_FORM
	EnableSearchFieldErrorPage, ///< Adds a form with a search field on error pages using the user's default search engine
#endif
	SkinScale, ///< Zoom for skin images in percent
	SpecialEffects, ///< Enable skin special effects
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	SpellcheckEnabledByDefault, ///< Determine if spellchecking should be enabled by default
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	BookmarksSaveTimeout, ///< Timeout value in milliseconds to wait before saving bookmark changes
#endif
#ifdef VISITED_PAGES_SEARCH
	VisitedPages, ///< Enable/Disable visited pages indexing
#endif
#ifdef WAND_SUPPORT
	WandAutosubmit, ///< Wand submits forms data automatically
#endif

	DummyLastIntegerPref
};
#define PCCORE_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionCore::DummyLastIntegerPref)

