/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionCore, PCCORE_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef PREFS_DOWNLOAD
	P(SInstall, "Preference URL", UNI_L("http://xml.opera.com/spoof/")),
#endif
	P(SPersonalInfo, "Address", UNI_L("")),
	P(SPersonalInfo, "City", UNI_L("")),
	P(SPersonalInfo, "Country", UNI_L("")),
	P(SPersonalInfo, "EMail", UNI_L("")),
	P(SPersonalInfo, "First Name", UNI_L("")),
	P(SPersonalInfo, "Home Page", UNI_L("")),
	P(SPersonalInfo, "Special 1", UNI_L("")),
	P(SPersonalInfo, "Special 2", UNI_L("")),
	P(SPersonalInfo, "Special 3", UNI_L("")),
	P(SPersonalInfo, "State", UNI_L("")),
	P(SPersonalInfo, "Surname", UNI_L("")),
	P(SPersonalInfo, "Telefax", UNI_L("")),
	P(SPersonalInfo, "Telephone", UNI_L("")),
	P(SPersonalInfo, "Zip", UNI_L("")),
#if defined(VEGA_BACKENDS_BLOCKLIST_FETCH)
	P(SUserPrefs, "Blocklist Location", UNI_L("http://get.geo.opera.com/res/servicefiles/hardware-acceleration/")),
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	P(SUserPrefs, "Console Error Log Filter", UNI_L("javascript")),
#endif
#ifdef PREFS_HAVE_CUSTOM_UA
	P(SUserPrefs, "Custom User-Agent", UNI_L("")),
#endif
	P(SUserPrefs, "Home URL", DF_HOMEPAGE),
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	P(SUserPrefs, "Last Used Spellcheck Language", UNI_L("")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionCore, PCCORE_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef APPLICATION_CACHE_SUPPORT
	I(SCache, "Application Cache Quota", DEFAULT_APPLICATION_CACHE_DISK_QUOTA, prefssetting::integer),
#endif
	I(SCache, "Cache Docs", DEFAULT_CACHE_RAM_DOCS, prefssetting::boolean),
	I(SCache, "Cache Figs", DEFAULT_CACHE_RAM_FIGS, prefssetting::boolean),
	I(SCache, "Document", DEFAULT_CACHE_RAM_SIZE, prefssetting::integer),
	I(SCache, "Figure", DEFAULT_CACHE_RAM_FIGS_SIZE, prefssetting::integer),
#ifdef SVG_SUPPORT
	I(SCache, "SVG Cache Size", DEFAULT_SVG_CACHED_BITMAPS_MAX_KILOBYTES_SIZE, prefssetting::integer),
#endif
#ifdef NEARBY_ELEMENT_DETECTION
	I(SLink, "Always Expand Nearby Elements", FALSE, prefssetting::boolean),
	I(SLink, "Detect Nearby Elements", FALSE, prefssetting::boolean),
	I(SLink, "Expanded Minimum Size", 30, prefssetting::integer),
	I(SLink, "Nearby Elements Radius", 22, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_ANIMATION_THROTTLING
	I(SPerformance, "Lag Threshold For Animation Throttling", 50, prefssetting::integer),
	I(SPerformance, "Switch Animation Throttling Interval", 2000, prefssetting::integer),
#endif
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	I(SUserAgent, "Allow Components In UA String Comment", DEFAULT_COMPONENTINUASTRING, prefssetting::boolean),
#endif
#ifdef WAND_SUPPORT
	I(SUserPrefs, "AutocompleteOff Disables Wand", FALSE, prefssetting::boolean),
#endif
#ifdef VEGA_BACKENDS_BLOCKLIST_FETCH
	I(SUserPrefs, "Blocklist Refetch Delay", 60*60*24*7, prefssetting::integer),
	I(SUserPrefs, "Blocklist Retry Delay", 60*10, prefssetting::integer),
#endif
	I(SUserPrefs, "Color Scheme Mode", 0, prefssetting::integer),
#ifdef OPERA_CONSOLE_LOGFILE
	I(SUserPrefs, "Console Error Log Enabled", FALSE, prefssetting::boolean),
#endif
#ifdef MOUSE_SUPPORT
	I(SUserPrefs, "Enable Gesture", TRUE, prefssetting::boolean),
#endif
#ifdef VEGA_3DDEVICE
	I(SUserPrefs, "Enable Hardware Acceleration", PREFS_DEFAULT_HWACC_ENABLED, prefssetting::integer),
#endif
#ifdef MOUSE_SUPPORT
	I(SUserPrefs, "Enable Mouse Flips", TRUE, prefssetting::boolean),
#endif
#ifdef CORE_SPEED_DIAL_SUPPORT
	I(SUserPrefs, "Enable Speed Dial", TRUE, prefssetting::boolean),
#endif
#ifdef DOM_LOAD_TV_APP
	I(SUserPrefs, "Enable TV Store", FALSE, prefssetting::boolean),
#endif
#ifdef WAND_SUPPORT
	I(SUserPrefs, "Enable Wand", DEFAULT_WAND_ENABLE, prefssetting::boolean),
#endif
#ifdef CANVAS3D_SUPPORT
	I(SUserPrefs, "Enable WebGL", DEFAULT_ENABLE_WEBGL, prefssetting::integer),
#endif
#ifdef OPERACONFIG_URL
	I(SUserPrefs, "Enable config URL", TRUE, prefssetting::boolean),
#endif
#ifdef MOUSE_SUPPORT
	I(SUserPrefs, "Gesture Threshold", 5, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_LAST_SITEPATCH_UPDATE_CHECK
	I(SUserPrefs, "Last Sitepatch Update Check", 0, prefssetting::integer),
#endif
#ifdef OPERA_CONSOLE
	I(SUserPrefs, "Max Console Messages", DEFAULT_MAX_CONSOLE_MESSAGES, prefssetting::integer),
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	I(SUserPrefs, "Max Direct History Lines", DEFAULT_MAX_DIRECT_HISTORY_LINES, prefssetting::integer),
#endif
	I(SUserPrefs, "Max Global History Lines", DEFAULT_MAX_GLOBAL_HISTORY_LINES, prefssetting::integer),
	I(SUserPrefs, "Max Window History Lines", DEFAULT_MAX_WINDOW_HISTORY_LINES, prefssetting::integer),
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	I(SUserPrefs, "Maximum bookmark folder depth", 1000000, prefssetting::integer),
	I(SUserPrefs, "Maximum length of created time string", DEFAULT_BOOKMARKS_CREATED_TIME_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of description", DEFAULT_BOOKMARKS_DESC_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of favicon file name", DEFAULT_BOOKMARKS_FAVICON_FILE_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of shortname", DEFAULT_BOOKMARKS_SHORT_NAME_MAXLENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of thumbnail file name", DEFAULT_BOOKMARKS_THUMBNAIL_FILE_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of title", DEFAULT_BOOKMARKS_TITLE_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of url", DEFAULT_BOOKMARKS_URL_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum length of visited time string", DEFAULT_BOOKMARKS_VISITED_TIME_MAX_LENGTH, prefssetting::integer),
	I(SUserPrefs, "Maximum number of bookmarks", 1000000, prefssetting::integer),
	I(SUserPrefs, "Maximum number per folder", 1000000, prefssetting::integer),
#endif
#ifdef SEARCH_ENGINES
	I(SUserPrefs, "Number Of Hits", 0, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_SPOOF_TIMESTAMP
	I(SUserPrefs, "Overrides Server Timestamp", 0, prefssetting::integer),
	I(SUserPrefs, "Overrides Timestamp", 0, prefssetting::integer),
#endif
#if defined UPGRADE_SUPPORT && defined PREFS_WRITE
	I(SUserPrefs, "Preferences Version", 0, prefssetting::integer),
#endif
#if defined PREFS_HAVE_PREFERRED_RENDERER
	I(SUserPrefs, "Preferred renderer", DEFAULT_PREFERRED_RENDERER, prefssetting::integer),
#endif
#ifdef WEB_HANDLERS_SUPPORT
	I(SUserPrefs, "Protocols List Server Timestamp", 0, prefssetting::integer),
	I(SUserPrefs, "Protocols List Timestamp", 0, prefssetting::integer),
#endif
#ifdef MOUSE_SUPPORT
	I(SUserPrefs, "Reverse Button Flipping", -1, prefssetting::boolean),
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	I(SUserPrefs, "Save policy for bookmarks", 3, prefssetting::integer),
#endif
#ifdef PHONE_SN_HANDLER
	I(SUserPrefs, "Scroll Step", DEFAULT_SPATIAL_NAV_SCROLL_STEP, prefssetting::integer),
	I(SUserPrefs, "Scroll Step Handheld", 25, prefssetting::integer),
	I(SUserPrefs, "Scroll Step Horizontal", DEFAULT_SPATNAV_HORIZONTAL_SCROLL_STEP, prefssetting::integer),
#endif
#ifdef AB_ERROR_SEARCH_FORM
	I(SUserPrefs, "Search Field On Error Pages", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Skin scale", 100, prefssetting::integer),
	I(SUserPrefs, "Special effects", DEFAULT_UI_SPECIAL_EFFECTS, prefssetting::boolean),
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	I(SUserPrefs, "Spellcheck enabled by default", TRUE, prefssetting::boolean),
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	I(SUserPrefs, "Timeout value for bookmark save", BOOKMARKS_DEFAULT_SAVE_TIMEOUT, prefssetting::integer),
#endif
#ifdef VISITED_PAGES_SEARCH
	I(SUserPrefs, "Visited Pages", TRUE, prefssetting::boolean),
#endif
#ifdef WAND_SUPPORT
	I(SUserPrefs, "Wand Autosubmit", DEFAULT_WAND_AUTO_SUBMIT, prefssetting::boolean),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionCore::stringpref e)
{
	switch (e) {
#ifdef PREFS_DOWNLOAD
	case PrefsCollectionCore::PreferenceServer:
		return dbg << "PrefsCollectionCore::PreferenceServer";
#endif
	case PrefsCollectionCore::Address:
		return dbg << "PrefsCollectionCore::Address";
	case PrefsCollectionCore::City:
		return dbg << "PrefsCollectionCore::City";
	case PrefsCollectionCore::Country:
		return dbg << "PrefsCollectionCore::Country";
	case PrefsCollectionCore::EMail:
		return dbg << "PrefsCollectionCore::EMail";
	case PrefsCollectionCore::Firstname:
		return dbg << "PrefsCollectionCore::Firstname";
	case PrefsCollectionCore::Home:
		return dbg << "PrefsCollectionCore::Home";
	case PrefsCollectionCore::Special1:
		return dbg << "PrefsCollectionCore::Special1";
	case PrefsCollectionCore::Special2:
		return dbg << "PrefsCollectionCore::Special2";
	case PrefsCollectionCore::Special3:
		return dbg << "PrefsCollectionCore::Special3";
	case PrefsCollectionCore::State:
		return dbg << "PrefsCollectionCore::State";
	case PrefsCollectionCore::Surname:
		return dbg << "PrefsCollectionCore::Surname";
	case PrefsCollectionCore::Telefax:
		return dbg << "PrefsCollectionCore::Telefax";
	case PrefsCollectionCore::Telephone:
		return dbg << "PrefsCollectionCore::Telephone";
	case PrefsCollectionCore::Zip:
		return dbg << "PrefsCollectionCore::Zip";
#if defined(VEGA_BACKENDS_BLOCKLIST_FETCH)
	case PrefsCollectionCore::BlocklistLocation:
		return dbg << "PrefsCollectionCore::BlocklistLocation";
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	case PrefsCollectionCore::ErrorLogFilter:
		return dbg << "PrefsCollectionCore::ErrorLogFilter";
#endif
#ifdef PREFS_HAVE_CUSTOM_UA
	case PrefsCollectionCore::CustomUAString:
		return dbg << "PrefsCollectionCore::CustomUAString";
#endif
	case PrefsCollectionCore::HomeURL:
		return dbg << "PrefsCollectionCore::HomeURL";
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	case PrefsCollectionCore::LastUsedSpellcheckLanguage:
		return dbg << "PrefsCollectionCore::LastUsedSpellcheckLanguage";
#endif
	default:
		return dbg << "PrefsCollectionCore::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionCore::integerpref e)
{
	switch (e) {
#ifdef APPLICATION_CACHE_SUPPORT
	case PrefsCollectionCore::DefaultApplicationCacheQuota:
		return dbg << "PrefsCollectionCore::DefaultApplicationCacheQuota";
#endif
	case PrefsCollectionCore::RamCacheDocs:
		return dbg << "PrefsCollectionCore::RamCacheDocs";
	case PrefsCollectionCore::RamCacheFigs:
		return dbg << "PrefsCollectionCore::RamCacheFigs";
	case PrefsCollectionCore::DocumentCacheSize:
		return dbg << "PrefsCollectionCore::DocumentCacheSize";
	case PrefsCollectionCore::ImageRAMCacheSize:
		return dbg << "PrefsCollectionCore::ImageRAMCacheSize";
#ifdef SVG_SUPPORT
	case PrefsCollectionCore::SVGRAMCacheSize:
		return dbg << "PrefsCollectionCore::SVGRAMCacheSize";
#endif
#ifdef NEARBY_ELEMENT_DETECTION
	case PrefsCollectionCore::AlwaysExpandLinks:
		return dbg << "PrefsCollectionCore::AlwaysExpandLinks";
	case PrefsCollectionCore::DetectNearbyElements:
		return dbg << "PrefsCollectionCore::DetectNearbyElements";
	case PrefsCollectionCore::ExpandedMinimumSize:
		return dbg << "PrefsCollectionCore::ExpandedMinimumSize";
	case PrefsCollectionCore::NearbyElementsRadius:
		return dbg << "PrefsCollectionCore::NearbyElementsRadius";
#endif
#ifdef PREFS_HAVE_ANIMATION_THROTTLING
	case PrefsCollectionCore::LagThresholdForAnimationThrottling:
		return dbg << "PrefsCollectionCore::LagThresholdForAnimationThrottling";
	case PrefsCollectionCore::SwitchAnimationThrottlingInterval:
		return dbg << "PrefsCollectionCore::SwitchAnimationThrottlingInterval";
#endif
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	case PrefsCollectionCore::AllowComponentsInUAStringComment:
		return dbg << "PrefsCollectionCore::AllowComponentsInUAStringComment";
#endif
#ifdef WAND_SUPPORT
	case PrefsCollectionCore::AutocompleteOffDisablesWand:
		return dbg << "PrefsCollectionCore::AutocompleteOffDisablesWand";
#endif
#ifdef VEGA_BACKENDS_BLOCKLIST_FETCH
	case PrefsCollectionCore::BlocklistRefetchDelay:
		return dbg << "PrefsCollectionCore::BlocklistRefetchDelay";
	case PrefsCollectionCore::BlocklistRetryDelay:
		return dbg << "PrefsCollectionCore::BlocklistRetryDelay";
#endif
	case PrefsCollectionCore::ColorSchemeMode:
		return dbg << "PrefsCollectionCore::ColorSchemeMode";
#ifdef OPERA_CONSOLE_LOGFILE
	case PrefsCollectionCore::UseErrorLog:
		return dbg << "PrefsCollectionCore::UseErrorLog";
#endif
#ifdef MOUSE_SUPPORT
	case PrefsCollectionCore::EnableGesture:
		return dbg << "PrefsCollectionCore::EnableGesture";
#endif
#ifdef VEGA_3DDEVICE
	case PrefsCollectionCore::EnableHardwareAcceleration:
		return dbg << "PrefsCollectionCore::EnableHardwareAcceleration";
#endif
#ifdef MOUSE_SUPPORT
	case PrefsCollectionCore::EnableMouseFlips:
		return dbg << "PrefsCollectionCore::EnableMouseFlips";
#endif
#ifdef CORE_SPEED_DIAL_SUPPORT
	case PrefsCollectionCore::EnableSpeedDial:
		return dbg << "PrefsCollectionCore::EnableSpeedDial";
#endif
#ifdef DOM_LOAD_TV_APP
	case PrefsCollectionCore::EnableTVStore:
		return dbg << "PrefsCollectionCore::EnableTVStore";
#endif
#ifdef WAND_SUPPORT
	case PrefsCollectionCore::EnableWand:
		return dbg << "PrefsCollectionCore::EnableWand";
#endif
#ifdef CANVAS3D_SUPPORT
	case PrefsCollectionCore::EnableWebGL:
		return dbg << "PrefsCollectionCore::EnableWebGL";
#endif
#ifdef OPERACONFIG_URL
	case PrefsCollectionCore::OperaConfigEnabled:
		return dbg << "PrefsCollectionCore::OperaConfigEnabled";
#endif
#ifdef MOUSE_SUPPORT
	case PrefsCollectionCore::GestureThreshold:
		return dbg << "PrefsCollectionCore::GestureThreshold";
#endif
#ifdef PREFS_HAVE_LAST_SITEPATCH_UPDATE_CHECK
	case PrefsCollectionCore::LastSitepatchUpdateCheck:
		return dbg << "PrefsCollectionCore::LastSitepatchUpdateCheck";
#endif
#ifdef OPERA_CONSOLE
	case PrefsCollectionCore::MaxConsoleMessages:
		return dbg << "PrefsCollectionCore::MaxConsoleMessages";
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	case PrefsCollectionCore::MaxDirectHistory:
		return dbg << "PrefsCollectionCore::MaxDirectHistory";
#endif
	case PrefsCollectionCore::MaxGlobalHistory:
		return dbg << "PrefsCollectionCore::MaxGlobalHistory";
	case PrefsCollectionCore::MaxWindowHistory:
		return dbg << "PrefsCollectionCore::MaxWindowHistory";
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	case PrefsCollectionCore::BookmarksMaxFolderDepth:
		return dbg << "PrefsCollectionCore::BookmarksMaxFolderDepth";
	case PrefsCollectionCore::BookmarksCreatedMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksCreatedMaxLength";
	case PrefsCollectionCore::BookmarksDescMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksDescMaxLength";
	case PrefsCollectionCore::BookmarksFaviconFileMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksFaviconFileMaxLength";
	case PrefsCollectionCore::BookmarksSnMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksSnMaxLength";
	case PrefsCollectionCore::BookmarksThumbnailFileMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksThumbnailFileMaxLength";
	case PrefsCollectionCore::BookmarksTitleMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksTitleMaxLength";
	case PrefsCollectionCore::BookmarksUrlMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksUrlMaxLength";
	case PrefsCollectionCore::BookmarksVisitedMaxLength:
		return dbg << "PrefsCollectionCore::BookmarksVisitedMaxLength";
	case PrefsCollectionCore::BookmarksMaxCount:
		return dbg << "PrefsCollectionCore::BookmarksMaxCount";
	case PrefsCollectionCore::BookmarksMaxCountPerFolder:
		return dbg << "PrefsCollectionCore::BookmarksMaxCountPerFolder";
#endif
#ifdef SEARCH_ENGINES
	case PrefsCollectionCore::PreferredNumberOfHits:
		return dbg << "PrefsCollectionCore::PreferredNumberOfHits";
#endif
#ifdef PREFS_HAVE_SPOOF_TIMESTAMP
	case PrefsCollectionCore::SpoofServerTimeStamp:
		return dbg << "PrefsCollectionCore::SpoofServerTimeStamp";
	case PrefsCollectionCore::SpoofTimeStamp:
		return dbg << "PrefsCollectionCore::SpoofTimeStamp";
#endif
#if defined UPGRADE_SUPPORT && defined PREFS_WRITE
	case PrefsCollectionCore::PreferenceUpgrade:
		return dbg << "PrefsCollectionCore::PreferenceUpgrade";
#endif
#if defined PREFS_HAVE_PREFERRED_RENDERER
	case PrefsCollectionCore::PreferredRenderer:
		return dbg << "PrefsCollectionCore::PreferredRenderer";
#endif
#ifdef WEB_HANDLERS_SUPPORT
	case PrefsCollectionCore::ProtocolsListServerTimeStamp:
		return dbg << "PrefsCollectionCore::ProtocolsListServerTimeStamp";
	case PrefsCollectionCore::ProtocolsListTimeStamp:
		return dbg << "PrefsCollectionCore::ProtocolsListTimeStamp";
#endif
#ifdef MOUSE_SUPPORT
	case PrefsCollectionCore::ReverseButtonFlipping:
		return dbg << "PrefsCollectionCore::ReverseButtonFlipping";
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	case PrefsCollectionCore::BookmarksSavePolicy:
		return dbg << "PrefsCollectionCore::BookmarksSavePolicy";
#endif
#ifdef PHONE_SN_HANDLER
	case PrefsCollectionCore::ScrollStep:
		return dbg << "PrefsCollectionCore::ScrollStep";
	case PrefsCollectionCore::ScrollStepHandheld:
		return dbg << "PrefsCollectionCore::ScrollStepHandheld";
	case PrefsCollectionCore::ScrollStepHorizontal:
		return dbg << "PrefsCollectionCore::ScrollStepHorizontal";
#endif
#ifdef AB_ERROR_SEARCH_FORM
	case PrefsCollectionCore::EnableSearchFieldErrorPage:
		return dbg << "PrefsCollectionCore::EnableSearchFieldErrorPage";
#endif
	case PrefsCollectionCore::SkinScale:
		return dbg << "PrefsCollectionCore::SkinScale";
	case PrefsCollectionCore::SpecialEffects:
		return dbg << "PrefsCollectionCore::SpecialEffects";
#ifdef INTERNAL_SPELLCHECK_SUPPORT
	case PrefsCollectionCore::SpellcheckEnabledByDefault:
		return dbg << "PrefsCollectionCore::SpellcheckEnabledByDefault";
#endif
#if defined CORE_BOOKMARKS_SUPPORT && defined PREFS_HAVE_BOOKMARK
	case PrefsCollectionCore::BookmarksSaveTimeout:
		return dbg << "PrefsCollectionCore::BookmarksSaveTimeout";
#endif
#ifdef VISITED_PAGES_SEARCH
	case PrefsCollectionCore::VisitedPages:
		return dbg << "PrefsCollectionCore::VisitedPages";
#endif
#ifdef WAND_SUPPORT
	case PrefsCollectionCore::WandAutosubmit:
		return dbg << "PrefsCollectionCore::WandAutosubmit";
#endif
	default:
		return dbg << "PrefsCollectionCore::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
