/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

#include "modules/hardcore/keys/opkeys.h"

/* static */ const uni_char*
OpKey::ToString(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_CANCEL_ENABLED
	case OP_KEY_CANCEL: return UNI_L("Cancel");
#endif // OP_KEY_CANCEL_ENABLED
#ifdef OP_KEY_BACKSPACE_ENABLED
	case OP_KEY_BACKSPACE: return UNI_L("Backspace");
#endif // OP_KEY_BACKSPACE_ENABLED
#ifdef OP_KEY_TAB_ENABLED
	case OP_KEY_TAB: return UNI_L("Tab");
#endif // OP_KEY_TAB_ENABLED
#ifdef OP_KEY_CLEAR_ENABLED
	case OP_KEY_CLEAR: return UNI_L("Clear");
#endif // OP_KEY_CLEAR_ENABLED
#ifdef OP_KEY_ENTER_ENABLED
	case OP_KEY_ENTER: return UNI_L("Enter");
#endif // OP_KEY_ENTER_ENABLED
#ifdef OP_KEY_SHIFT_ENABLED
	case OP_KEY_SHIFT: return UNI_L("Shift");
#endif // OP_KEY_SHIFT_ENABLED
#ifdef OP_KEY_CTRL_ENABLED
	case OP_KEY_CTRL: return UNI_L("Control");
#endif // OP_KEY_CTRL_ENABLED
#ifdef OP_KEY_ALT_ENABLED
	case OP_KEY_ALT: return UNI_L("Alt");
#endif // OP_KEY_ALT_ENABLED
#ifdef OP_KEY_PAUSE_ENABLED
	case OP_KEY_PAUSE: return UNI_L("Pause");
#endif // OP_KEY_PAUSE_ENABLED
#ifdef OP_KEY_CAPS_LOCK_ENABLED
	case OP_KEY_CAPS_LOCK: return UNI_L("CapsLock");
#endif // OP_KEY_CAPS_LOCK_ENABLED
#ifdef OP_KEY_KANA_ENABLED
	case OP_KEY_KANA: return UNI_L("Kana");
#endif // OP_KEY_KANA_ENABLED
#ifdef OP_KEY_FINAL_ENABLED
	case OP_KEY_FINAL: return UNI_L("Final");
#endif // OP_KEY_FINAL_ENABLED
#ifdef OP_KEY_KANJI_ENABLED
	case OP_KEY_KANJI: return UNI_L("Kanji");
#endif // OP_KEY_KANJI_ENABLED
#ifdef OP_KEY_ESCAPE_ENABLED
	case OP_KEY_ESCAPE: return UNI_L("Esc");
#endif // OP_KEY_ESCAPE_ENABLED
#ifdef OP_KEY_CONVERT_ENABLED
	case OP_KEY_CONVERT: return UNI_L("Convert");
#endif // OP_KEY_CONVERT_ENABLED
#ifdef OP_KEY_NONCONVERT_ENABLED
	case OP_KEY_NONCONVERT: return UNI_L("NonConvert");
#endif // OP_KEY_NONCONVERT_ENABLED
#ifdef OP_KEY_ACCEPT_ENABLED
	case OP_KEY_ACCEPT: return UNI_L("Accept");
#endif // OP_KEY_ACCEPT_ENABLED
#ifdef OP_KEY_MODECHANGE_ENABLED
	case OP_KEY_MODECHANGE: return UNI_L("ModeChange");
#endif // OP_KEY_MODECHANGE_ENABLED
#ifdef OP_KEY_SPACE_ENABLED
	case OP_KEY_SPACE: return UNI_L("Spacebar");
#endif // OP_KEY_SPACE_ENABLED
#ifdef OP_KEY_PAGEUP_ENABLED
	case OP_KEY_PAGEUP: return UNI_L("PageUp");
#endif // OP_KEY_PAGEUP_ENABLED
#ifdef OP_KEY_PAGEDOWN_ENABLED
	case OP_KEY_PAGEDOWN: return UNI_L("PageDown");
#endif // OP_KEY_PAGEDOWN_ENABLED
#ifdef OP_KEY_END_ENABLED
	case OP_KEY_END: return UNI_L("End");
#endif // OP_KEY_END_ENABLED
#ifdef OP_KEY_HOME_ENABLED
	case OP_KEY_HOME: return UNI_L("Home");
#endif // OP_KEY_HOME_ENABLED
#ifdef OP_KEY_LEFT_ENABLED
	case OP_KEY_LEFT: return UNI_L("Left");
#endif // OP_KEY_LEFT_ENABLED
#ifdef OP_KEY_UP_ENABLED
	case OP_KEY_UP: return UNI_L("Up");
#endif // OP_KEY_UP_ENABLED
#ifdef OP_KEY_RIGHT_ENABLED
	case OP_KEY_RIGHT: return UNI_L("Right");
#endif // OP_KEY_RIGHT_ENABLED
#ifdef OP_KEY_DOWN_ENABLED
	case OP_KEY_DOWN: return UNI_L("Down");
#endif // OP_KEY_DOWN_ENABLED
#ifdef OP_KEY_SELECT_ENABLED
	case OP_KEY_SELECT: return UNI_L("Select");
#endif // OP_KEY_SELECT_ENABLED
#ifdef OP_KEY_PRINT_ENABLED
	case OP_KEY_PRINT: return UNI_L("Print");
#endif // OP_KEY_PRINT_ENABLED
#ifdef OP_KEY_EXECUTE_ENABLED
	case OP_KEY_EXECUTE: return UNI_L("Execute");
#endif // OP_KEY_EXECUTE_ENABLED
#ifdef OP_KEY_PRINTSCREEN_ENABLED
	case OP_KEY_PRINTSCREEN: return UNI_L("PrintScreen");
#endif // OP_KEY_PRINTSCREEN_ENABLED
#ifdef OP_KEY_INSERT_ENABLED
	case OP_KEY_INSERT: return UNI_L("Insert");
#endif // OP_KEY_INSERT_ENABLED
#ifdef OP_KEY_DELETE_ENABLED
	case OP_KEY_DELETE: return UNI_L("Delete");
#endif // OP_KEY_DELETE_ENABLED
#ifdef OP_KEY_HELP_ENABLED
	case OP_KEY_HELP: return UNI_L("Help");
#endif // OP_KEY_HELP_ENABLED
#ifdef OP_KEY_0_ENABLED
	case OP_KEY_0: return UNI_L("0");
#endif // OP_KEY_0_ENABLED
#ifdef OP_KEY_1_ENABLED
	case OP_KEY_1: return UNI_L("1");
#endif // OP_KEY_1_ENABLED
#ifdef OP_KEY_2_ENABLED
	case OP_KEY_2: return UNI_L("2");
#endif // OP_KEY_2_ENABLED
#ifdef OP_KEY_3_ENABLED
	case OP_KEY_3: return UNI_L("3");
#endif // OP_KEY_3_ENABLED
#ifdef OP_KEY_4_ENABLED
	case OP_KEY_4: return UNI_L("4");
#endif // OP_KEY_4_ENABLED
#ifdef OP_KEY_5_ENABLED
	case OP_KEY_5: return UNI_L("5");
#endif // OP_KEY_5_ENABLED
#ifdef OP_KEY_6_ENABLED
	case OP_KEY_6: return UNI_L("6");
#endif // OP_KEY_6_ENABLED
#ifdef OP_KEY_7_ENABLED
	case OP_KEY_7: return UNI_L("7");
#endif // OP_KEY_7_ENABLED
#ifdef OP_KEY_8_ENABLED
	case OP_KEY_8: return UNI_L("8");
#endif // OP_KEY_8_ENABLED
#ifdef OP_KEY_9_ENABLED
	case OP_KEY_9: return UNI_L("9");
#endif // OP_KEY_9_ENABLED
#ifdef OP_KEY_A_ENABLED
	case OP_KEY_A: return UNI_L("A");
#endif // OP_KEY_A_ENABLED
#ifdef OP_KEY_B_ENABLED
	case OP_KEY_B: return UNI_L("B");
#endif // OP_KEY_B_ENABLED
#ifdef OP_KEY_C_ENABLED
	case OP_KEY_C: return UNI_L("C");
#endif // OP_KEY_C_ENABLED
#ifdef OP_KEY_D_ENABLED
	case OP_KEY_D: return UNI_L("D");
#endif // OP_KEY_D_ENABLED
#ifdef OP_KEY_E_ENABLED
	case OP_KEY_E: return UNI_L("E");
#endif // OP_KEY_E_ENABLED
#ifdef OP_KEY_F_ENABLED
	case OP_KEY_F: return UNI_L("F");
#endif // OP_KEY_F_ENABLED
#ifdef OP_KEY_G_ENABLED
	case OP_KEY_G: return UNI_L("G");
#endif // OP_KEY_G_ENABLED
#ifdef OP_KEY_H_ENABLED
	case OP_KEY_H: return UNI_L("H");
#endif // OP_KEY_H_ENABLED
#ifdef OP_KEY_I_ENABLED
	case OP_KEY_I: return UNI_L("I");
#endif // OP_KEY_I_ENABLED
#ifdef OP_KEY_J_ENABLED
	case OP_KEY_J: return UNI_L("J");
#endif // OP_KEY_J_ENABLED
#ifdef OP_KEY_K_ENABLED
	case OP_KEY_K: return UNI_L("K");
#endif // OP_KEY_K_ENABLED
#ifdef OP_KEY_L_ENABLED
	case OP_KEY_L: return UNI_L("L");
#endif // OP_KEY_L_ENABLED
#ifdef OP_KEY_M_ENABLED
	case OP_KEY_M: return UNI_L("M");
#endif // OP_KEY_M_ENABLED
#ifdef OP_KEY_N_ENABLED
	case OP_KEY_N: return UNI_L("N");
#endif // OP_KEY_N_ENABLED
#ifdef OP_KEY_O_ENABLED
	case OP_KEY_O: return UNI_L("O");
#endif // OP_KEY_O_ENABLED
#ifdef OP_KEY_P_ENABLED
	case OP_KEY_P: return UNI_L("P");
#endif // OP_KEY_P_ENABLED
#ifdef OP_KEY_Q_ENABLED
	case OP_KEY_Q: return UNI_L("Q");
#endif // OP_KEY_Q_ENABLED
#ifdef OP_KEY_R_ENABLED
	case OP_KEY_R: return UNI_L("R");
#endif // OP_KEY_R_ENABLED
#ifdef OP_KEY_S_ENABLED
	case OP_KEY_S: return UNI_L("S");
#endif // OP_KEY_S_ENABLED
#ifdef OP_KEY_T_ENABLED
	case OP_KEY_T: return UNI_L("T");
#endif // OP_KEY_T_ENABLED
#ifdef OP_KEY_U_ENABLED
	case OP_KEY_U: return UNI_L("U");
#endif // OP_KEY_U_ENABLED
#ifdef OP_KEY_V_ENABLED
	case OP_KEY_V: return UNI_L("V");
#endif // OP_KEY_V_ENABLED
#ifdef OP_KEY_W_ENABLED
	case OP_KEY_W: return UNI_L("W");
#endif // OP_KEY_W_ENABLED
#ifdef OP_KEY_X_ENABLED
	case OP_KEY_X: return UNI_L("X");
#endif // OP_KEY_X_ENABLED
#ifdef OP_KEY_Y_ENABLED
	case OP_KEY_Y: return UNI_L("Y");
#endif // OP_KEY_Y_ENABLED
#ifdef OP_KEY_Z_ENABLED
	case OP_KEY_Z: return UNI_L("Z");
#endif // OP_KEY_Z_ENABLED
#ifdef OP_KEY_WINDOW_ENABLED
	case OP_KEY_WINDOW: return UNI_L("Window");
#endif // OP_KEY_WINDOW_ENABLED
#ifdef OP_KEY_MAC_CTRL_ENABLED
	case OP_KEY_MAC_CTRL: return UNI_L("MacControl");
#endif // OP_KEY_MAC_CTRL_ENABLED
#ifdef OP_KEY_CONTEXT_MENU_ENABLED
	case OP_KEY_CONTEXT_MENU: return UNI_L("ContextMenu");
#endif // OP_KEY_CONTEXT_MENU_ENABLED
#ifdef OP_KEY_SLEEP_ENABLED
	case OP_KEY_SLEEP: return UNI_L("Sleep");
#endif // OP_KEY_SLEEP_ENABLED
#ifdef OP_KEY_NUMPAD0_ENABLED
	case OP_KEY_NUMPAD0: return UNI_L("NumPad0");
#endif // OP_KEY_NUMPAD0_ENABLED
#ifdef OP_KEY_NUMPAD1_ENABLED
	case OP_KEY_NUMPAD1: return UNI_L("NumPad1");
#endif // OP_KEY_NUMPAD1_ENABLED
#ifdef OP_KEY_NUMPAD2_ENABLED
	case OP_KEY_NUMPAD2: return UNI_L("NumPad2");
#endif // OP_KEY_NUMPAD2_ENABLED
#ifdef OP_KEY_NUMPAD3_ENABLED
	case OP_KEY_NUMPAD3: return UNI_L("NumPad3");
#endif // OP_KEY_NUMPAD3_ENABLED
#ifdef OP_KEY_NUMPAD4_ENABLED
	case OP_KEY_NUMPAD4: return UNI_L("NumPad4");
#endif // OP_KEY_NUMPAD4_ENABLED
#ifdef OP_KEY_NUMPAD5_ENABLED
	case OP_KEY_NUMPAD5: return UNI_L("NumPad5");
#endif // OP_KEY_NUMPAD5_ENABLED
#ifdef OP_KEY_NUMPAD6_ENABLED
	case OP_KEY_NUMPAD6: return UNI_L("NumPad6");
#endif // OP_KEY_NUMPAD6_ENABLED
#ifdef OP_KEY_NUMPAD7_ENABLED
	case OP_KEY_NUMPAD7: return UNI_L("NumPad7");
#endif // OP_KEY_NUMPAD7_ENABLED
#ifdef OP_KEY_NUMPAD8_ENABLED
	case OP_KEY_NUMPAD8: return UNI_L("NumPad8");
#endif // OP_KEY_NUMPAD8_ENABLED
#ifdef OP_KEY_NUMPAD9_ENABLED
	case OP_KEY_NUMPAD9: return UNI_L("NumPad9");
#endif // OP_KEY_NUMPAD9_ENABLED
#ifdef OP_KEY_MULTIPLY_ENABLED
	case OP_KEY_MULTIPLY: return UNI_L("Mul");
#endif // OP_KEY_MULTIPLY_ENABLED
#ifdef OP_KEY_ADD_ENABLED
	case OP_KEY_ADD: return UNI_L("Add");
#endif // OP_KEY_ADD_ENABLED
#ifdef OP_KEY_SEPARATOR_ENABLED
	case OP_KEY_SEPARATOR: return UNI_L("Separator");
#endif // OP_KEY_SEPARATOR_ENABLED
#ifdef OP_KEY_SUBTRACT_ENABLED
	case OP_KEY_SUBTRACT: return UNI_L("Subtract");
#endif // OP_KEY_SUBTRACT_ENABLED
#ifdef OP_KEY_DECIMAL_ENABLED
	case OP_KEY_DECIMAL: return UNI_L("Decimal");
#endif // OP_KEY_DECIMAL_ENABLED
#ifdef OP_KEY_DIVIDE_ENABLED
	case OP_KEY_DIVIDE: return UNI_L("Divide");
#endif // OP_KEY_DIVIDE_ENABLED
#ifdef OP_KEY_F1_ENABLED
	case OP_KEY_F1: return UNI_L("F1");
#endif // OP_KEY_F1_ENABLED
#ifdef OP_KEY_F2_ENABLED
	case OP_KEY_F2: return UNI_L("F2");
#endif // OP_KEY_F2_ENABLED
#ifdef OP_KEY_F3_ENABLED
	case OP_KEY_F3: return UNI_L("F3");
#endif // OP_KEY_F3_ENABLED
#ifdef OP_KEY_F4_ENABLED
	case OP_KEY_F4: return UNI_L("F4");
#endif // OP_KEY_F4_ENABLED
#ifdef OP_KEY_F5_ENABLED
	case OP_KEY_F5: return UNI_L("F5");
#endif // OP_KEY_F5_ENABLED
#ifdef OP_KEY_F6_ENABLED
	case OP_KEY_F6: return UNI_L("F6");
#endif // OP_KEY_F6_ENABLED
#ifdef OP_KEY_F7_ENABLED
	case OP_KEY_F7: return UNI_L("F7");
#endif // OP_KEY_F7_ENABLED
#ifdef OP_KEY_F8_ENABLED
	case OP_KEY_F8: return UNI_L("F8");
#endif // OP_KEY_F8_ENABLED
#ifdef OP_KEY_F9_ENABLED
	case OP_KEY_F9: return UNI_L("F9");
#endif // OP_KEY_F9_ENABLED
#ifdef OP_KEY_F10_ENABLED
	case OP_KEY_F10: return UNI_L("F10");
#endif // OP_KEY_F10_ENABLED
#ifdef OP_KEY_F11_ENABLED
	case OP_KEY_F11: return UNI_L("F11");
#endif // OP_KEY_F11_ENABLED
#ifdef OP_KEY_F12_ENABLED
	case OP_KEY_F12: return UNI_L("F12");
#endif // OP_KEY_F12_ENABLED
#ifdef OP_KEY_F13_ENABLED
	case OP_KEY_F13: return UNI_L("F13");
#endif // OP_KEY_F13_ENABLED
#ifdef OP_KEY_F14_ENABLED
	case OP_KEY_F14: return UNI_L("F14");
#endif // OP_KEY_F14_ENABLED
#ifdef OP_KEY_F15_ENABLED
	case OP_KEY_F15: return UNI_L("F15");
#endif // OP_KEY_F15_ENABLED
#ifdef OP_KEY_F16_ENABLED
	case OP_KEY_F16: return UNI_L("F16");
#endif // OP_KEY_F16_ENABLED
#ifdef OP_KEY_F17_ENABLED
	case OP_KEY_F17: return UNI_L("F17");
#endif // OP_KEY_F17_ENABLED
#ifdef OP_KEY_F18_ENABLED
	case OP_KEY_F18: return UNI_L("F18");
#endif // OP_KEY_F18_ENABLED
#ifdef OP_KEY_F19_ENABLED
	case OP_KEY_F19: return UNI_L("F19");
#endif // OP_KEY_F19_ENABLED
#ifdef OP_KEY_F20_ENABLED
	case OP_KEY_F20: return UNI_L("F20");
#endif // OP_KEY_F20_ENABLED
#ifdef OP_KEY_F21_ENABLED
	case OP_KEY_F21: return UNI_L("F21");
#endif // OP_KEY_F21_ENABLED
#ifdef OP_KEY_F22_ENABLED
	case OP_KEY_F22: return UNI_L("F22");
#endif // OP_KEY_F22_ENABLED
#ifdef OP_KEY_F23_ENABLED
	case OP_KEY_F23: return UNI_L("F23");
#endif // OP_KEY_F23_ENABLED
#ifdef OP_KEY_F24_ENABLED
	case OP_KEY_F24: return UNI_L("F24");
#endif // OP_KEY_F24_ENABLED
#ifdef OP_KEY_NUM_LOCK_ENABLED
	case OP_KEY_NUM_LOCK: return UNI_L("NumLock");
#endif // OP_KEY_NUM_LOCK_ENABLED
#ifdef OP_KEY_SCROLL_LOCK_ENABLED
	case OP_KEY_SCROLL_LOCK: return UNI_L("ScrollLock");
#endif // OP_KEY_SCROLL_LOCK_ENABLED
#ifdef OP_KEY_META_ENABLED
	case OP_KEY_META: return UNI_L("Meta");
#endif // OP_KEY_META_ENABLED
#ifdef OP_KEY_OEM_1_ENABLED
	case OP_KEY_OEM_1: return UNI_L("Oem1");
#endif // OP_KEY_OEM_1_ENABLED
#ifdef OP_KEY_OEM_PLUS_ENABLED
	case OP_KEY_OEM_PLUS: return UNI_L("OemPlus");
#endif // OP_KEY_OEM_PLUS_ENABLED
#ifdef OP_KEY_OEM_COMMA_ENABLED
	case OP_KEY_OEM_COMMA: return UNI_L("OemComma");
#endif // OP_KEY_OEM_COMMA_ENABLED
#ifdef OP_KEY_OEM_MINUS_ENABLED
	case OP_KEY_OEM_MINUS: return UNI_L("OemMinus");
#endif // OP_KEY_OEM_MINUS_ENABLED
#ifdef OP_KEY_OEM_PERIOD_ENABLED
	case OP_KEY_OEM_PERIOD: return UNI_L("OemPeriod");
#endif // OP_KEY_OEM_PERIOD_ENABLED
#ifdef OP_KEY_OEM_2_ENABLED
	case OP_KEY_OEM_2: return UNI_L("Oem2");
#endif // OP_KEY_OEM_2_ENABLED
#ifdef OP_KEY_OEM_3_ENABLED
	case OP_KEY_OEM_3: return UNI_L("Oem3");
#endif // OP_KEY_OEM_3_ENABLED
#ifdef OP_KEY_OEM_4_ENABLED
	case OP_KEY_OEM_4: return UNI_L("Oem4");
#endif // OP_KEY_OEM_4_ENABLED
#ifdef OP_KEY_OEM_5_ENABLED
	case OP_KEY_OEM_5: return UNI_L("Oem5");
#endif // OP_KEY_OEM_5_ENABLED
#ifdef OP_KEY_OEM_6_ENABLED
	case OP_KEY_OEM_6: return UNI_L("Oem6");
#endif // OP_KEY_OEM_6_ENABLED
#ifdef OP_KEY_OEM_7_ENABLED
	case OP_KEY_OEM_7: return UNI_L("Oem7");
#endif // OP_KEY_OEM_7_ENABLED
#ifdef OP_KEY_OEM_8_ENABLED
	case OP_KEY_OEM_8: return UNI_L("Oem8");
#endif // OP_KEY_OEM_8_ENABLED
#ifdef OP_KEY_OEM_102_ENABLED
	case OP_KEY_OEM_102: return UNI_L("Oem102");
#endif // OP_KEY_OEM_102_ENABLED
#ifdef OP_KEY_PROCESSKEY_ENABLED
	case OP_KEY_PROCESSKEY: return UNI_L("IMEProcess");
#endif // OP_KEY_PROCESSKEY_ENABLED
#ifdef OP_KEY_UNICODE_ENABLED
	case OP_KEY_UNICODE: return UNI_L("KeyInput");
#endif // OP_KEY_UNICODE_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_1_ENABLED
	case OP_KEY_MOUSE_BUTTON_1: return UNI_L("Button1");
#endif // OP_KEY_MOUSE_BUTTON_1_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_2_ENABLED
	case OP_KEY_MOUSE_BUTTON_2: return UNI_L("Button2");
#endif // OP_KEY_MOUSE_BUTTON_2_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_3_ENABLED
	case OP_KEY_MOUSE_BUTTON_3: return UNI_L("Button3");
#endif // OP_KEY_MOUSE_BUTTON_3_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_4_ENABLED
	case OP_KEY_MOUSE_BUTTON_4: return UNI_L("Button4");
#endif // OP_KEY_MOUSE_BUTTON_4_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_5_ENABLED
	case OP_KEY_MOUSE_BUTTON_5: return UNI_L("Button5");
#endif // OP_KEY_MOUSE_BUTTON_5_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_6_ENABLED
	case OP_KEY_MOUSE_BUTTON_6: return UNI_L("Button6");
#endif // OP_KEY_MOUSE_BUTTON_6_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_7_ENABLED
	case OP_KEY_MOUSE_BUTTON_7: return UNI_L("Button7");
#endif // OP_KEY_MOUSE_BUTTON_7_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_8_ENABLED
	case OP_KEY_MOUSE_BUTTON_8: return UNI_L("Button8");
#endif // OP_KEY_MOUSE_BUTTON_8_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_9_ENABLED
	case OP_KEY_MOUSE_BUTTON_9: return UNI_L("Button9");
#endif // OP_KEY_MOUSE_BUTTON_9_ENABLED
#ifdef OP_KEY_GESTURE_UP_ENABLED
	case OP_KEY_GESTURE_UP: return UNI_L("GestureUp");
#endif // OP_KEY_GESTURE_UP_ENABLED
#ifdef OP_KEY_GESTURE_RIGHT_ENABLED
	case OP_KEY_GESTURE_RIGHT: return UNI_L("GestureRight");
#endif // OP_KEY_GESTURE_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_ENABLED
	case OP_KEY_GESTURE_DOWN: return UNI_L("GestureDown");
#endif // OP_KEY_GESTURE_DOWN_ENABLED
#ifdef OP_KEY_GESTURE_LEFT_ENABLED
	case OP_KEY_GESTURE_LEFT: return UNI_L("GestureLeft");
#endif // OP_KEY_GESTURE_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_LEFT_ENABLED
	case OP_KEY_GESTURE_UP_LEFT: return UNI_L("GestureUpLeft");
#endif // OP_KEY_GESTURE_UP_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_RIGHT_ENABLED
	case OP_KEY_GESTURE_UP_RIGHT: return UNI_L("GestureUpRight");
#endif // OP_KEY_GESTURE_UP_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_LEFT_ENABLED
	case OP_KEY_GESTURE_DOWN_LEFT: return UNI_L("GestureDownLeft");
#endif // OP_KEY_GESTURE_DOWN_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
	case OP_KEY_GESTURE_DOWN_RIGHT: return UNI_L("GestureDownRight");
#endif // OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
#ifdef OP_KEY_FLIP_BACK_ENABLED
	case OP_KEY_FLIP_BACK: return UNI_L("FlipBack");
#endif // OP_KEY_FLIP_BACK_ENABLED
#ifdef OP_KEY_FLIP_FORWARD_ENABLED
	case OP_KEY_FLIP_FORWARD: return UNI_L("FlipForward");
#endif // OP_KEY_FLIP_FORWARD_ENABLED
#ifdef OP_KEY_F25_ENABLED
	case OP_KEY_F25: return UNI_L("F25");
#endif // OP_KEY_F25_ENABLED
#ifdef OP_KEY_F26_ENABLED
	case OP_KEY_F26: return UNI_L("F26");
#endif // OP_KEY_F26_ENABLED
#ifdef OP_KEY_F27_ENABLED
	case OP_KEY_F27: return UNI_L("F27");
#endif // OP_KEY_F27_ENABLED
#ifdef OP_KEY_F28_ENABLED
	case OP_KEY_F28: return UNI_L("F28");
#endif // OP_KEY_F28_ENABLED
#ifdef OP_KEY_F29_ENABLED
	case OP_KEY_F29: return UNI_L("F29");
#endif // OP_KEY_F29_ENABLED
#ifdef OP_KEY_F30_ENABLED
	case OP_KEY_F30: return UNI_L("F30");
#endif // OP_KEY_F30_ENABLED
#ifdef OP_KEY_F31_ENABLED
	case OP_KEY_F31: return UNI_L("F31");
#endif // OP_KEY_F31_ENABLED
#ifdef OP_KEY_F32_ENABLED
	case OP_KEY_F32: return UNI_L("F32");
#endif // OP_KEY_F32_ENABLED
#ifdef OP_KEY_F33_ENABLED
	case OP_KEY_F33: return UNI_L("F33");
#endif // OP_KEY_F33_ENABLED
#ifdef OP_KEY_F34_ENABLED
	case OP_KEY_F34: return UNI_L("F34");
#endif // OP_KEY_F34_ENABLED
#ifdef OP_KEY_F35_ENABLED
	case OP_KEY_F35: return UNI_L("F35");
#endif // OP_KEY_F35_ENABLED
#ifdef OP_KEY_F36_ENABLED
	case OP_KEY_F36: return UNI_L("F36");
#endif // OP_KEY_F36_ENABLED
#ifdef OP_KEY_VOLUMEUP_ENABLED
	case OP_KEY_VOLUMEUP: return UNI_L("RC_VOLUMEUP");
#endif // OP_KEY_VOLUMEUP_ENABLED
#ifdef OP_KEY_VOLUMEDOWN_ENABLED
	case OP_KEY_VOLUMEDOWN: return UNI_L("RC_VOLUMEDOWN");
#endif // OP_KEY_VOLUMEDOWN_ENABLED
#ifdef OP_KEY_MENU_ENABLED
	case OP_KEY_MENU: return UNI_L("RC_MENU");
#endif // OP_KEY_MENU_ENABLED
#ifdef OP_KEY_PLAY_ENABLED
	case OP_KEY_PLAY: return UNI_L("RC_PLAY");
#endif // OP_KEY_PLAY_ENABLED
#ifdef OP_KEY_NEXT_ENABLED
	case OP_KEY_NEXT: return UNI_L("RC_NEXT");
#endif // OP_KEY_NEXT_ENABLED
#ifdef OP_KEY_PREVIOUS_ENABLED
	case OP_KEY_PREVIOUS: return UNI_L("RC_PREVIOUS");
#endif // OP_KEY_PREVIOUS_ENABLED
#ifdef OP_KEY_FASTFORWARD_ENABLED
	case OP_KEY_FASTFORWARD: return UNI_L("RC_FASTFORWARD");
#endif // OP_KEY_FASTFORWARD_ENABLED
#ifdef OP_KEY_REWIND_ENABLED
	case OP_KEY_REWIND: return UNI_L("RC_REWIND");
#endif // OP_KEY_REWIND_ENABLED
#ifdef OP_KEY_STOP_ENABLED
	case OP_KEY_STOP: return UNI_L("RC_STOP");
#endif // OP_KEY_STOP_ENABLED
#ifdef OP_KEY_REDO_ENABLED
	case OP_KEY_REDO: return UNI_L("Redo");
#endif // OP_KEY_REDO_ENABLED
#ifdef OP_KEY_UNDO_ENABLED
	case OP_KEY_UNDO: return UNI_L("Undo");
#endif // OP_KEY_UNDO_ENABLED
#ifdef OP_KEY_PROPERITES_ENABLED
	case OP_KEY_PROPERITES: return UNI_L("Properites");
#endif // OP_KEY_PROPERITES_ENABLED
#ifdef OP_KEY_FRONT_ENABLED
	case OP_KEY_FRONT: return UNI_L("Front");
#endif // OP_KEY_FRONT_ENABLED
#ifdef OP_KEY_LEFT_TAB_ENABLED
	case OP_KEY_LEFT_TAB: return UNI_L("LeftTab");
#endif // OP_KEY_LEFT_TAB_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
	case OP_KEY_XF86XK_MON_BRIGHTNESS_UP: return UNI_L("MonBrightnessUp");
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
	case OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN: return UNI_L("MonBrightnessDown");
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
	case OP_KEY_XF86XK_KBD_LIGHT_ON_OFF: return UNI_L("KbdLightOnOff");
#endif // OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
	case OP_KEY_XF86XK_KBD_BRIGHTNESS_UP: return UNI_L("KbdBrightnessUp");
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
	case OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN: return UNI_L("KbdBrightnessDown");
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_STANDBY_ENABLED
	case OP_KEY_XF86XK_STANDBY: return UNI_L("Standby");
#endif // OP_KEY_XF86XK_STANDBY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
	case OP_KEY_XF86XK_AUDIO_LOWER_VOLUME: return UNI_L("AudioLowerVolume");
#endif // OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
	case OP_KEY_XF86XK_AUDIO_MUTE: return UNI_L("AudioMute");
#endif // OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
	case OP_KEY_XF86XK_AUDIO_RAISE_VOLUME: return UNI_L("AudioRaiseVolume");
#endif // OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
	case OP_KEY_XF86XK_AUDIO_PLAY: return UNI_L("AudioPlay");
#endif // OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_STOP_ENABLED
	case OP_KEY_XF86XK_AUDIO_STOP: return UNI_L("AudioStop");
#endif // OP_KEY_XF86XK_AUDIO_STOP_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PREV_ENABLED
	case OP_KEY_XF86XK_AUDIO_PREV: return UNI_L("AudioPrev");
#endif // OP_KEY_XF86XK_AUDIO_PREV_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
	case OP_KEY_XF86XK_AUDIO_NEXT: return UNI_L("AudioNext");
#endif // OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
#ifdef OP_KEY_XF86XK_HOME_PAGE_ENABLED
	case OP_KEY_XF86XK_HOME_PAGE: return UNI_L("HomePage");
#endif // OP_KEY_XF86XK_HOME_PAGE_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_ENABLED
	case OP_KEY_XF86XK_MAIL: return UNI_L("Mail");
#endif // OP_KEY_XF86XK_MAIL_ENABLED
#ifdef OP_KEY_XF86XK_START_ENABLED
	case OP_KEY_XF86XK_START: return UNI_L("Start");
#endif // OP_KEY_XF86XK_START_ENABLED
#ifdef OP_KEY_XF86XK_SEARCH_ENABLED
	case OP_KEY_XF86XK_SEARCH: return UNI_L("Search");
#endif // OP_KEY_XF86XK_SEARCH_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
	case OP_KEY_XF86XK_AUDIO_RECORD: return UNI_L("AudioRecord");
#endif // OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
#ifdef OP_KEY_XF86XK_CALCULATOR_ENABLED
	case OP_KEY_XF86XK_CALCULATOR: return UNI_L("Calculator");
#endif // OP_KEY_XF86XK_CALCULATOR_ENABLED
#ifdef OP_KEY_XF86XK_MEMO_ENABLED
	case OP_KEY_XF86XK_MEMO: return UNI_L("Memo");
#endif // OP_KEY_XF86XK_MEMO_ENABLED
#ifdef OP_KEY_XF86XK_TO_DO_LIST_ENABLED
	case OP_KEY_XF86XK_TO_DO_LIST: return UNI_L("ToDoList");
#endif // OP_KEY_XF86XK_TO_DO_LIST_ENABLED
#ifdef OP_KEY_XF86XK_CALENDAR_ENABLED
	case OP_KEY_XF86XK_CALENDAR: return UNI_L("Calendar");
#endif // OP_KEY_XF86XK_CALENDAR_ENABLED
#ifdef OP_KEY_XF86XK_POWER_DOWN_ENABLED
	case OP_KEY_XF86XK_POWER_DOWN: return UNI_L("PowerDown");
#endif // OP_KEY_XF86XK_POWER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
	case OP_KEY_XF86XK_CONTRAST_ADJUST: return UNI_L("ContrastAdjust");
#endif // OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_UP_ENABLED
	case OP_KEY_XF86XK_ROCKER_UP: return UNI_L("RockerUp");
#endif // OP_KEY_XF86XK_ROCKER_UP_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
	case OP_KEY_XF86XK_ROCKER_DOWN: return UNI_L("RockerDown");
#endif // OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
	case OP_KEY_XF86XK_ROCKER_ENTER: return UNI_L("RockerEnter");
#endif // OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
#ifdef OP_KEY_XF86XK_BACK_ENABLED
	case OP_KEY_XF86XK_BACK: return UNI_L("Back");
#endif // OP_KEY_XF86XK_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FORWARD_ENABLED
	case OP_KEY_XF86XK_FORWARD: return UNI_L("Forward");
#endif // OP_KEY_XF86XK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_STOP_ENABLED
	case OP_KEY_XF86XK_STOP: return UNI_L("Stop");
#endif // OP_KEY_XF86XK_STOP_ENABLED
#ifdef OP_KEY_XF86XK_REFRESH_ENABLED
	case OP_KEY_XF86XK_REFRESH: return UNI_L("Refresh");
#endif // OP_KEY_XF86XK_REFRESH_ENABLED
#ifdef OP_KEY_XF86XK_POWER_OFF_ENABLED
	case OP_KEY_XF86XK_POWER_OFF: return UNI_L("PowerOff");
#endif // OP_KEY_XF86XK_POWER_OFF_ENABLED
#ifdef OP_KEY_XF86XK_WAKE_UP_ENABLED
	case OP_KEY_XF86XK_WAKE_UP: return UNI_L("WakeUp");
#endif // OP_KEY_XF86XK_WAKE_UP_ENABLED
#ifdef OP_KEY_XF86XK_EJECT_ENABLED
	case OP_KEY_XF86XK_EJECT: return UNI_L("Eject");
#endif // OP_KEY_XF86XK_EJECT_ENABLED
#ifdef OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
	case OP_KEY_XF86XK_SCREEN_SAVER: return UNI_L("ScreenSaver");
#endif // OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
#ifdef OP_KEY_XF86XK_WWW_ENABLED
	case OP_KEY_XF86XK_WWW: return UNI_L("WWW");
#endif // OP_KEY_XF86XK_WWW_ENABLED
#ifdef OP_KEY_XF86XK_FAVORITES_ENABLED
	case OP_KEY_XF86XK_FAVORITES: return UNI_L("Favorites");
#endif // OP_KEY_XF86XK_FAVORITES_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
	case OP_KEY_XF86XK_AUDIO_PAUSE: return UNI_L("AudioPause");
#endif // OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
	case OP_KEY_XF86XK_AUDIO_MEDIA: return UNI_L("AudioMedia");
#endif // OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
#ifdef OP_KEY_XF86XK_MY_COMPUTER_ENABLED
	case OP_KEY_XF86XK_MY_COMPUTER: return UNI_L("MyComputer");
#endif // OP_KEY_XF86XK_MY_COMPUTER_ENABLED
#ifdef OP_KEY_XF86XK_VENDOR_HOME_ENABLED
	case OP_KEY_XF86XK_VENDOR_HOME: return UNI_L("VendorHome");
#endif // OP_KEY_XF86XK_VENDOR_HOME_ENABLED
#ifdef OP_KEY_XF86XK_LIGHT_BULB_ENABLED
	case OP_KEY_XF86XK_LIGHT_BULB: return UNI_L("LightBulb");
#endif // OP_KEY_XF86XK_LIGHT_BULB_ENABLED
#ifdef OP_KEY_XF86XK_SHOP_ENABLED
	case OP_KEY_XF86XK_SHOP: return UNI_L("Shop");
#endif // OP_KEY_XF86XK_SHOP_ENABLED
#ifdef OP_KEY_XF86XK_HISTORY_ENABLED
	case OP_KEY_XF86XK_HISTORY: return UNI_L("History");
#endif // OP_KEY_XF86XK_HISTORY_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_URL_ENABLED
	case OP_KEY_XF86XK_OPEN_URL: return UNI_L("OpenURL");
#endif // OP_KEY_XF86XK_OPEN_URL_ENABLED
#ifdef OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
	case OP_KEY_XF86XK_ADD_FAVORITE: return UNI_L("AddFavorite");
#endif // OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
#ifdef OP_KEY_XF86XK_HOT_LINKS_ENABLED
	case OP_KEY_XF86XK_HOT_LINKS: return UNI_L("HotLinks");
#endif // OP_KEY_XF86XK_HOT_LINKS_ENABLED
#ifdef OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
	case OP_KEY_XF86XK_BRIGHTNESS_ADJUST: return UNI_L("BrightnessAdjust");
#endif // OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_FINANCE_ENABLED
	case OP_KEY_XF86XK_FINANCE: return UNI_L("Finance");
#endif // OP_KEY_XF86XK_FINANCE_ENABLED
#ifdef OP_KEY_XF86XK_COMMUNITY_ENABLED
	case OP_KEY_XF86XK_COMMUNITY: return UNI_L("Community");
#endif // OP_KEY_XF86XK_COMMUNITY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
	case OP_KEY_XF86XK_AUDIO_REWIND: return UNI_L("AudioRewind");
#endif // OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
#ifdef OP_KEY_XF86XK_BACK_FORWARD_ENABLED
	case OP_KEY_XF86XK_BACK_FORWARD: return UNI_L("BackForward");
#endif // OP_KEY_XF86XK_BACK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH0_ENABLED
	case OP_KEY_XF86XK_LAUNCH0: return UNI_L("Launch0");
#endif // OP_KEY_XF86XK_LAUNCH0_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH1_ENABLED
	case OP_KEY_XF86XK_LAUNCH1: return UNI_L("Launch1");
#endif // OP_KEY_XF86XK_LAUNCH1_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH2_ENABLED
	case OP_KEY_XF86XK_LAUNCH2: return UNI_L("Launch2");
#endif // OP_KEY_XF86XK_LAUNCH2_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH3_ENABLED
	case OP_KEY_XF86XK_LAUNCH3: return UNI_L("Launch3");
#endif // OP_KEY_XF86XK_LAUNCH3_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH4_ENABLED
	case OP_KEY_XF86XK_LAUNCH4: return UNI_L("Launch4");
#endif // OP_KEY_XF86XK_LAUNCH4_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH5_ENABLED
	case OP_KEY_XF86XK_LAUNCH5: return UNI_L("Launch5");
#endif // OP_KEY_XF86XK_LAUNCH5_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH6_ENABLED
	case OP_KEY_XF86XK_LAUNCH6: return UNI_L("Launch6");
#endif // OP_KEY_XF86XK_LAUNCH6_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH7_ENABLED
	case OP_KEY_XF86XK_LAUNCH7: return UNI_L("Launch7");
#endif // OP_KEY_XF86XK_LAUNCH7_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH8_ENABLED
	case OP_KEY_XF86XK_LAUNCH8: return UNI_L("Launch8");
#endif // OP_KEY_XF86XK_LAUNCH8_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH9_ENABLED
	case OP_KEY_XF86XK_LAUNCH9: return UNI_L("Launch9");
#endif // OP_KEY_XF86XK_LAUNCH9_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_A_ENABLED
	case OP_KEY_XF86XK_LAUNCH_A: return UNI_L("LaunchA");
#endif // OP_KEY_XF86XK_LAUNCH_A_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_B_ENABLED
	case OP_KEY_XF86XK_LAUNCH_B: return UNI_L("LaunchB");
#endif // OP_KEY_XF86XK_LAUNCH_B_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_C_ENABLED
	case OP_KEY_XF86XK_LAUNCH_C: return UNI_L("LaunchC");
#endif // OP_KEY_XF86XK_LAUNCH_C_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_D_ENABLED
	case OP_KEY_XF86XK_LAUNCH_D: return UNI_L("LaunchD");
#endif // OP_KEY_XF86XK_LAUNCH_D_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_E_ENABLED
	case OP_KEY_XF86XK_LAUNCH_E: return UNI_L("LaunchE");
#endif // OP_KEY_XF86XK_LAUNCH_E_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_F_ENABLED
	case OP_KEY_XF86XK_LAUNCH_F: return UNI_L("LaunchF");
#endif // OP_KEY_XF86XK_LAUNCH_F_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
	case OP_KEY_XF86XK_APPLICATION_LEFT: return UNI_L("ApplicationLeft");
#endif // OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
	case OP_KEY_XF86XK_APPLICATION_RIGHT: return UNI_L("ApplicationRight");
#endif // OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
#ifdef OP_KEY_XF86XK_BOOK_ENABLED
	case OP_KEY_XF86XK_BOOK: return UNI_L("Book");
#endif // OP_KEY_XF86XK_BOOK_ENABLED
#ifdef OP_KEY_XF86XK_CD_ENABLED
	case OP_KEY_XF86XK_CD: return UNI_L("CD");
#endif // OP_KEY_XF86XK_CD_ENABLED
#ifdef OP_KEY_XF86XK_CLOSE_ENABLED
	case OP_KEY_XF86XK_CLOSE: return UNI_L("Close");
#endif // OP_KEY_XF86XK_CLOSE_ENABLED
#ifdef OP_KEY_XF86XK_COPY_ENABLED
	case OP_KEY_XF86XK_COPY: return UNI_L("Copy");
#endif // OP_KEY_XF86XK_COPY_ENABLED
#ifdef OP_KEY_XF86XK_CUT_ENABLED
	case OP_KEY_XF86XK_CUT: return UNI_L("Cut");
#endif // OP_KEY_XF86XK_CUT_ENABLED
#ifdef OP_KEY_XF86XK_DISPLAY_ENABLED
	case OP_KEY_XF86XK_DISPLAY: return UNI_L("Display");
#endif // OP_KEY_XF86XK_DISPLAY_ENABLED
#ifdef OP_KEY_XF86XK_DOS_ENABLED
	case OP_KEY_XF86XK_DOS: return UNI_L("DOS");
#endif // OP_KEY_XF86XK_DOS_ENABLED
#ifdef OP_KEY_XF86XK_DOCUMENTS_ENABLED
	case OP_KEY_XF86XK_DOCUMENTS: return UNI_L("Documents");
#endif // OP_KEY_XF86XK_DOCUMENTS_ENABLED
#ifdef OP_KEY_XF86XK_EXCEL_ENABLED
	case OP_KEY_XF86XK_EXCEL: return UNI_L("Excel");
#endif // OP_KEY_XF86XK_EXCEL_ENABLED
#ifdef OP_KEY_XF86XK_EXPLORER_ENABLED
	case OP_KEY_XF86XK_EXPLORER: return UNI_L("Explorer");
#endif // OP_KEY_XF86XK_EXPLORER_ENABLED
#ifdef OP_KEY_XF86XK_GAME_ENABLED
	case OP_KEY_XF86XK_GAME: return UNI_L("Game");
#endif // OP_KEY_XF86XK_GAME_ENABLED
#ifdef OP_KEY_XF86XK_GO_ENABLED
	case OP_KEY_XF86XK_GO: return UNI_L("Go");
#endif // OP_KEY_XF86XK_GO_ENABLED
#ifdef OP_KEY_XF86XK_I_TOUCH_ENABLED
	case OP_KEY_XF86XK_I_TOUCH: return UNI_L("iTouch");
#endif // OP_KEY_XF86XK_I_TOUCH_ENABLED
#ifdef OP_KEY_XF86XK_LOG_OFF_ENABLED
	case OP_KEY_XF86XK_LOG_OFF: return UNI_L("LogOff");
#endif // OP_KEY_XF86XK_LOG_OFF_ENABLED
#ifdef OP_KEY_XF86XK_MARKET_ENABLED
	case OP_KEY_XF86XK_MARKET: return UNI_L("Market");
#endif // OP_KEY_XF86XK_MARKET_ENABLED
#ifdef OP_KEY_XF86XK_MEETING_ENABLED
	case OP_KEY_XF86XK_MEETING: return UNI_L("Meeting");
#endif // OP_KEY_XF86XK_MEETING_ENABLED
#ifdef OP_KEY_XF86XK_MENU_KB_ENABLED
	case OP_KEY_XF86XK_MENU_KB: return UNI_L("MenuKB");
#endif // OP_KEY_XF86XK_MENU_KB_ENABLED
#ifdef OP_KEY_XF86XK_MENU_PB_ENABLED
	case OP_KEY_XF86XK_MENU_PB: return UNI_L("MenuPB");
#endif // OP_KEY_XF86XK_MENU_PB_ENABLED
#ifdef OP_KEY_XF86XK_MY_SITES_ENABLED
	case OP_KEY_XF86XK_MY_SITES: return UNI_L("MySites");
#endif // OP_KEY_XF86XK_MY_SITES_ENABLED
#ifdef OP_KEY_XF86XK_NEW_ENABLED
	case OP_KEY_XF86XK_NEW: return UNI_L("New");
#endif // OP_KEY_XF86XK_NEW_ENABLED
#ifdef OP_KEY_XF86XK_NEWS_ENABLED
	case OP_KEY_XF86XK_NEWS: return UNI_L("News");
#endif // OP_KEY_XF86XK_NEWS_ENABLED
#ifdef OP_KEY_XF86XK_OFFICE_HOME_ENABLED
	case OP_KEY_XF86XK_OFFICE_HOME: return UNI_L("OfficeHome");
#endif // OP_KEY_XF86XK_OFFICE_HOME_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_ENABLED
	case OP_KEY_XF86XK_OPEN: return UNI_L("Open");
#endif // OP_KEY_XF86XK_OPEN_ENABLED
#ifdef OP_KEY_XF86XK_OPTION_ENABLED
	case OP_KEY_XF86XK_OPTION: return UNI_L("Option");
#endif // OP_KEY_XF86XK_OPTION_ENABLED
#ifdef OP_KEY_XF86XK_PASTE_ENABLED
	case OP_KEY_XF86XK_PASTE: return UNI_L("Paste");
#endif // OP_KEY_XF86XK_PASTE_ENABLED
#ifdef OP_KEY_XF86XK_PHONE_ENABLED
	case OP_KEY_XF86XK_PHONE: return UNI_L("Phone");
#endif // OP_KEY_XF86XK_PHONE_ENABLED
#ifdef OP_KEY_XF86XK_REPLY_ENABLED
	case OP_KEY_XF86XK_REPLY: return UNI_L("Reply");
#endif // OP_KEY_XF86XK_REPLY_ENABLED
#ifdef OP_KEY_XF86XK_RELOAD_ENABLED
	case OP_KEY_XF86XK_RELOAD: return UNI_L("Reload");
#endif // OP_KEY_XF86XK_RELOAD_ENABLED
#ifdef OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
	case OP_KEY_XF86XK_ROTATE_WINDOWS: return UNI_L("RotateWindows");
#endif // OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_PB_ENABLED
	case OP_KEY_XF86XK_ROTATION_PB: return UNI_L("RotationPB");
#endif // OP_KEY_XF86XK_ROTATION_PB_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_KB_ENABLED
	case OP_KEY_XF86XK_ROTATION_KB: return UNI_L("RotationKB");
#endif // OP_KEY_XF86XK_ROTATION_KB_ENABLED
#ifdef OP_KEY_XF86XK_SAVE_ENABLED
	case OP_KEY_XF86XK_SAVE: return UNI_L("Save");
#endif // OP_KEY_XF86XK_SAVE_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_UP_ENABLED
	case OP_KEY_XF86XK_SCROLL_UP: return UNI_L("ScrollUp");
#endif // OP_KEY_XF86XK_SCROLL_UP_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
	case OP_KEY_XF86XK_SCROLL_DOWN: return UNI_L("ScrollDown");
#endif // OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
	case OP_KEY_XF86XK_SCROLL_CLICK: return UNI_L("ScrollClick");
#endif // OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
#ifdef OP_KEY_XF86XK_SEND_ENABLED
	case OP_KEY_XF86XK_SEND: return UNI_L("Send");
#endif // OP_KEY_XF86XK_SEND_ENABLED
#ifdef OP_KEY_XF86XK_SPELL_ENABLED
	case OP_KEY_XF86XK_SPELL: return UNI_L("Spell");
#endif // OP_KEY_XF86XK_SPELL_ENABLED
#ifdef OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
	case OP_KEY_XF86XK_SPLIT_SCREEN: return UNI_L("SplitScreen");
#endif // OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
#ifdef OP_KEY_XF86XK_SUPPORT_ENABLED
	case OP_KEY_XF86XK_SUPPORT: return UNI_L("Support");
#endif // OP_KEY_XF86XK_SUPPORT_ENABLED
#ifdef OP_KEY_XF86XK_TASK_PANE_ENABLED
	case OP_KEY_XF86XK_TASK_PANE: return UNI_L("TaskPanel");
#endif // OP_KEY_XF86XK_TASK_PANE_ENABLED
#ifdef OP_KEY_XF86XK_TERMINAL_ENABLED
	case OP_KEY_XF86XK_TERMINAL: return UNI_L("Terminal");
#endif // OP_KEY_XF86XK_TERMINAL_ENABLED
#ifdef OP_KEY_XF86XK_TOOLS_ENABLED
	case OP_KEY_XF86XK_TOOLS: return UNI_L("Tools");
#endif // OP_KEY_XF86XK_TOOLS_ENABLED
#ifdef OP_KEY_XF86XK_TRAVEL_ENABLED
	case OP_KEY_XF86XK_TRAVEL: return UNI_L("Travel");
#endif // OP_KEY_XF86XK_TRAVEL_ENABLED
#ifdef OP_KEY_XF86XK_USER_PB_ENABLED
	case OP_KEY_XF86XK_USER_PB: return UNI_L("UserPB");
#endif // OP_KEY_XF86XK_USER_PB_ENABLED
#ifdef OP_KEY_XF86XK_USER1KB_ENABLED
	case OP_KEY_XF86XK_USER1KB: return UNI_L("User1KB");
#endif // OP_KEY_XF86XK_USER1KB_ENABLED
#ifdef OP_KEY_XF86XK_USER2KB_ENABLED
	case OP_KEY_XF86XK_USER2KB: return UNI_L("User2KB");
#endif // OP_KEY_XF86XK_USER2KB_ENABLED
#ifdef OP_KEY_XF86XK_VIDEO_ENABLED
	case OP_KEY_XF86XK_VIDEO: return UNI_L("Video");
#endif // OP_KEY_XF86XK_VIDEO_ENABLED
#ifdef OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
	case OP_KEY_XF86XK_WHEEL_BUTTON: return UNI_L("WheelButton");
#endif // OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
#ifdef OP_KEY_XF86XK_WORD_ENABLED
	case OP_KEY_XF86XK_WORD: return UNI_L("Word");
#endif // OP_KEY_XF86XK_WORD_ENABLED
#ifdef OP_KEY_XF86XK_XFER_ENABLED
	case OP_KEY_XF86XK_XFER: return UNI_L("Xfer");
#endif // OP_KEY_XF86XK_XFER_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_IN_ENABLED
	case OP_KEY_XF86XK_ZOOM_IN: return UNI_L("ZoomIn");
#endif // OP_KEY_XF86XK_ZOOM_IN_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_OUT_ENABLED
	case OP_KEY_XF86XK_ZOOM_OUT: return UNI_L("ZoomOut");
#endif // OP_KEY_XF86XK_ZOOM_OUT_ENABLED
#ifdef OP_KEY_XF86XK_AWAY_ENABLED
	case OP_KEY_XF86XK_AWAY: return UNI_L("Away");
#endif // OP_KEY_XF86XK_AWAY_ENABLED
#ifdef OP_KEY_XF86XK_MESSENGER_ENABLED
	case OP_KEY_XF86XK_MESSENGER: return UNI_L("Messenger");
#endif // OP_KEY_XF86XK_MESSENGER_ENABLED
#ifdef OP_KEY_XF86XK_WEB_CAM_ENABLED
	case OP_KEY_XF86XK_WEB_CAM: return UNI_L("WebCam");
#endif // OP_KEY_XF86XK_WEB_CAM_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
	case OP_KEY_XF86XK_MAIL_FORWARD: return UNI_L("MailForward");
#endif // OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_PICTURES_ENABLED
	case OP_KEY_XF86XK_PICTURES: return UNI_L("Pictures");
#endif // OP_KEY_XF86XK_PICTURES_ENABLED
#ifdef OP_KEY_XF86XK_MUSIC_ENABLED
	case OP_KEY_XF86XK_MUSIC: return UNI_L("Music");
#endif // OP_KEY_XF86XK_MUSIC_ENABLED
#ifdef OP_KEY_XF86XK_BATTERY_ENABLED
	case OP_KEY_XF86XK_BATTERY: return UNI_L("Battery");
#endif // OP_KEY_XF86XK_BATTERY_ENABLED
#ifdef OP_KEY_XF86XK_BLUETOOTH_ENABLED
	case OP_KEY_XF86XK_BLUETOOTH: return UNI_L("Bluetooth");
#endif // OP_KEY_XF86XK_BLUETOOTH_ENABLED
#ifdef OP_KEY_XF86XK_WLAN_ENABLED
	case OP_KEY_XF86XK_WLAN: return UNI_L("WLAN");
#endif // OP_KEY_XF86XK_WLAN_ENABLED
#ifdef OP_KEY_XF86XK_UWB_ENABLED
	case OP_KEY_XF86XK_UWB: return UNI_L("UWB");
#endif // OP_KEY_XF86XK_UWB_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
	case OP_KEY_XF86XK_AUDIO_FORWARD: return UNI_L("AudioForward");
#endif // OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
	case OP_KEY_XF86XK_AUDIO_REPEAT: return UNI_L("AudioRepeat");
#endif // OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
	case OP_KEY_XF86XK_AUDIO_RANDOM_PLAY: return UNI_L("AudioRandomPlay");
#endif // OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_SUBTITLE_ENABLED
	case OP_KEY_XF86XK_SUBTITLE: return UNI_L("Subtitle");
#endif // OP_KEY_XF86XK_SUBTITLE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
	case OP_KEY_XF86XK_AUDIO_CYCLE_TRACK: return UNI_L("AudioCycleTrack");
#endif // OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
#ifdef OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
	case OP_KEY_XF86XK_CYCLE_ANGLE: return UNI_L("CycleAngle");
#endif // OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_BACK_ENABLED
	case OP_KEY_XF86XK_FRAME_BACK: return UNI_L("FrameBack");
#endif // OP_KEY_XF86XK_FRAME_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
	case OP_KEY_XF86XK_FRAME_FORWARD: return UNI_L("FrameForward");
#endif // OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_TIME_ENABLED
	case OP_KEY_XF86XK_TIME: return UNI_L("Time");
#endif // OP_KEY_XF86XK_TIME_ENABLED
#ifdef OP_KEY_XF86XK_VIEW_ENABLED
	case OP_KEY_XF86XK_VIEW: return UNI_L("View");
#endif // OP_KEY_XF86XK_VIEW_ENABLED
#ifdef OP_KEY_XF86XK_TOP_MENU_ENABLED
	case OP_KEY_XF86XK_TOP_MENU: return UNI_L("TopMenu");
#endif // OP_KEY_XF86XK_TOP_MENU_ENABLED
#ifdef OP_KEY_XF86XK_RED_ENABLED
	case OP_KEY_XF86XK_RED: return UNI_L("Red");
#endif // OP_KEY_XF86XK_RED_ENABLED
#ifdef OP_KEY_XF86XK_GREEN_ENABLED
	case OP_KEY_XF86XK_GREEN: return UNI_L("Green");
#endif // OP_KEY_XF86XK_GREEN_ENABLED
#ifdef OP_KEY_XF86XK_YELLOW_ENABLED
	case OP_KEY_XF86XK_YELLOW: return UNI_L("Yellow");
#endif // OP_KEY_XF86XK_YELLOW_ENABLED
#ifdef OP_KEY_XF86XK_BLUE_ENABLED
	case OP_KEY_XF86XK_BLUE: return UNI_L("Blue");
#endif // OP_KEY_XF86XK_BLUE_ENABLED
#ifdef OP_KEY_XF86XK_SUSPEND_ENABLED
	case OP_KEY_XF86XK_SUSPEND: return UNI_L("Suspend");
#endif // OP_KEY_XF86XK_SUSPEND_ENABLED
#ifdef OP_KEY_XF86XK_HIBERNATE_ENABLED
	case OP_KEY_XF86XK_HIBERNATE: return UNI_L("Hibernate");
#endif // OP_KEY_XF86XK_HIBERNATE_ENABLED
#ifdef OP_KEY_MAC_CTRL_LEFT_ENABLED
	case OP_KEY_MAC_CTRL_LEFT: return UNI_L("MacControlL");
#endif // OP_KEY_MAC_CTRL_LEFT_ENABLED
#ifdef OP_KEY_MAC_CTRL_RIGHT_ENABLED
	case OP_KEY_MAC_CTRL_RIGHT: return UNI_L("MacControlR");
#endif // OP_KEY_MAC_CTRL_RIGHT_ENABLED
#ifdef OP_KEY_SWIPE_UP_ENABLED
	case OP_KEY_SWIPE_UP: return UNI_L("SwipeUp");
#endif // OP_KEY_SWIPE_UP_ENABLED
#ifdef OP_KEY_SWIPE_DOWN_ENABLED
	case OP_KEY_SWIPE_DOWN: return UNI_L("SwipeDown");
#endif // OP_KEY_SWIPE_DOWN_ENABLED
#ifdef OP_KEY_SWIPE_LEFT_ENABLED
	case OP_KEY_SWIPE_LEFT: return UNI_L("SwipeLeft");
#endif // OP_KEY_SWIPE_LEFT_ENABLED
#ifdef OP_KEY_SWIPE_RIGHT_ENABLED
	case OP_KEY_SWIPE_RIGHT: return UNI_L("SwipeRight");
#endif // OP_KEY_SWIPE_RIGHT_ENABLED
#ifdef OP_KEY_BACK_ENABLED
	case OP_KEY_BACK: return UNI_L("BACK");
#endif // OP_KEY_BACK_ENABLED
#ifdef OP_KEY_CONTEXT1_ENABLED
	case OP_KEY_CONTEXT1: return UNI_L("CONTEXT1");
#endif // OP_KEY_CONTEXT1_ENABLED
#ifdef OP_KEY_CONTEXT2_ENABLED
	case OP_KEY_CONTEXT2: return UNI_L("CONTEXT2");
#endif // OP_KEY_CONTEXT2_ENABLED
#ifdef OP_KEY_CONTEXT3_ENABLED
	case OP_KEY_CONTEXT3: return UNI_L("CONTEXT3");
#endif // OP_KEY_CONTEXT3_ENABLED
#ifdef OP_KEY_CONTEXT4_ENABLED
	case OP_KEY_CONTEXT4: return UNI_L("CONTEXT4");
#endif // OP_KEY_CONTEXT4_ENABLED
#ifdef OP_KEY_YES_ENABLED
	case OP_KEY_YES: return UNI_L("YES");
#endif // OP_KEY_YES_ENABLED
#ifdef OP_KEY_NO_ENABLED
	case OP_KEY_NO: return UNI_L("NO");
#endif // OP_KEY_NO_ENABLED
#ifdef OP_KEY_CALL_ENABLED
	case OP_KEY_CALL: return UNI_L("CALL");
#endif // OP_KEY_CALL_ENABLED
#ifdef OP_KEY_HANGUP_ENABLED
	case OP_KEY_HANGUP: return UNI_L("HANGUP");
#endif // OP_KEY_HANGUP_ENABLED
#ifdef OP_KEY_HK_TOGGLE_ENABLED
	case OP_KEY_HK_TOGGLE: return UNI_L("HiraganaKatakanatoggle");
#endif // OP_KEY_HK_TOGGLE_ENABLED
#ifdef OP_KEY_KATAKANA_ENABLED
	case OP_KEY_KATAKANA: return UNI_L("Katakana");
#endif // OP_KEY_KATAKANA_ENABLED
#ifdef OP_KEY_HIRAGANA_ENABLED
	case OP_KEY_HIRAGANA: return UNI_L("Hiragana");
#endif // OP_KEY_HIRAGANA_ENABLED
#ifdef OP_KEY_CHANNELDOWN_ENABLED
	case OP_KEY_CHANNELDOWN: return UNI_L("RC_CHANNELDOWN");
#endif // OP_KEY_CHANNELDOWN_ENABLED
#ifdef OP_KEY_CHANNELUP_ENABLED
	case OP_KEY_CHANNELUP: return UNI_L("RC_CHANNELUP");
#endif // OP_KEY_CHANNELUP_ENABLED
#ifdef OP_KEY_MUTE_ENABLED
	case OP_KEY_MUTE: return UNI_L("RC_MUTE");
#endif // OP_KEY_MUTE_ENABLED
#ifdef OP_KEY_RECORD_ENABLED
	case OP_KEY_RECORD: return UNI_L("RC_RECORD");
#endif // OP_KEY_RECORD_ENABLED
	}
	return NULL;
}

/* static */ OpKey::Code
OpKey::FromString(const uni_char* str)
{
#ifdef OP_KEY_CANCEL_ENABLED
	if (uni_stri_eq(str, "Cancel")) return OP_KEY_CANCEL;
#endif // OP_KEY_CANCEL_ENABLED
#ifdef OP_KEY_BACKSPACE_ENABLED
	if (uni_stri_eq(str, "Backspace")) return OP_KEY_BACKSPACE;
#endif // OP_KEY_BACKSPACE_ENABLED
#ifdef OP_KEY_TAB_ENABLED
	if (uni_stri_eq(str, "Tab")) return OP_KEY_TAB;
#endif // OP_KEY_TAB_ENABLED
#ifdef OP_KEY_CLEAR_ENABLED
	if (uni_stri_eq(str, "Clear")) return OP_KEY_CLEAR;
#endif // OP_KEY_CLEAR_ENABLED
#ifdef OP_KEY_ENTER_ENABLED
	if (uni_stri_eq(str, "Enter")) return OP_KEY_ENTER;
#endif // OP_KEY_ENTER_ENABLED
#ifdef OP_KEY_SHIFT_ENABLED
	if (uni_stri_eq(str, "Shift")) return OP_KEY_SHIFT;
#endif // OP_KEY_SHIFT_ENABLED
#ifdef OP_KEY_CTRL_ENABLED
	if (uni_stri_eq(str, "Control")) return OP_KEY_CTRL;
#endif // OP_KEY_CTRL_ENABLED
#ifdef OP_KEY_ALT_ENABLED
	if (uni_stri_eq(str, "Alt")) return OP_KEY_ALT;
#endif // OP_KEY_ALT_ENABLED
#ifdef OP_KEY_PAUSE_ENABLED
	if (uni_stri_eq(str, "Pause")) return OP_KEY_PAUSE;
#endif // OP_KEY_PAUSE_ENABLED
#ifdef OP_KEY_CAPS_LOCK_ENABLED
	if (uni_stri_eq(str, "CapsLock")) return OP_KEY_CAPS_LOCK;
#endif // OP_KEY_CAPS_LOCK_ENABLED
#ifdef OP_KEY_KANA_ENABLED
	if (uni_stri_eq(str, "Kana")) return OP_KEY_KANA;
#endif // OP_KEY_KANA_ENABLED
#ifdef OP_KEY_FINAL_ENABLED
	if (uni_stri_eq(str, "Final")) return OP_KEY_FINAL;
#endif // OP_KEY_FINAL_ENABLED
#ifdef OP_KEY_KANJI_ENABLED
	if (uni_stri_eq(str, "Kanji")) return OP_KEY_KANJI;
#endif // OP_KEY_KANJI_ENABLED
#ifdef OP_KEY_ESCAPE_ENABLED
	if (uni_stri_eq(str, "Esc")) return OP_KEY_ESCAPE;
#endif // OP_KEY_ESCAPE_ENABLED
#ifdef OP_KEY_CONVERT_ENABLED
	if (uni_stri_eq(str, "Convert")) return OP_KEY_CONVERT;
#endif // OP_KEY_CONVERT_ENABLED
#ifdef OP_KEY_NONCONVERT_ENABLED
	if (uni_stri_eq(str, "NonConvert")) return OP_KEY_NONCONVERT;
#endif // OP_KEY_NONCONVERT_ENABLED
#ifdef OP_KEY_ACCEPT_ENABLED
	if (uni_stri_eq(str, "Accept")) return OP_KEY_ACCEPT;
#endif // OP_KEY_ACCEPT_ENABLED
#ifdef OP_KEY_MODECHANGE_ENABLED
	if (uni_stri_eq(str, "ModeChange")) return OP_KEY_MODECHANGE;
#endif // OP_KEY_MODECHANGE_ENABLED
#ifdef OP_KEY_SPACE_ENABLED
	if (uni_stri_eq(str, "Spacebar")) return OP_KEY_SPACE;
#endif // OP_KEY_SPACE_ENABLED
#ifdef OP_KEY_SPACE_ENABLED
	if (uni_stri_eq(str, "Space")) return OP_KEY_SPACE;
#endif // OP_KEY_SPACE_ENABLED
#ifdef OP_KEY_PAGEUP_ENABLED
	if (uni_stri_eq(str, "PageUp")) return OP_KEY_PAGEUP;
#endif // OP_KEY_PAGEUP_ENABLED
#ifdef OP_KEY_PAGEDOWN_ENABLED
	if (uni_stri_eq(str, "PageDown")) return OP_KEY_PAGEDOWN;
#endif // OP_KEY_PAGEDOWN_ENABLED
#ifdef OP_KEY_END_ENABLED
	if (uni_stri_eq(str, "End")) return OP_KEY_END;
#endif // OP_KEY_END_ENABLED
#ifdef OP_KEY_HOME_ENABLED
	if (uni_stri_eq(str, "Home")) return OP_KEY_HOME;
#endif // OP_KEY_HOME_ENABLED
#ifdef OP_KEY_LEFT_ENABLED
	if (uni_stri_eq(str, "Left")) return OP_KEY_LEFT;
#endif // OP_KEY_LEFT_ENABLED
#ifdef OP_KEY_UP_ENABLED
	if (uni_stri_eq(str, "Up")) return OP_KEY_UP;
#endif // OP_KEY_UP_ENABLED
#ifdef OP_KEY_RIGHT_ENABLED
	if (uni_stri_eq(str, "Right")) return OP_KEY_RIGHT;
#endif // OP_KEY_RIGHT_ENABLED
#ifdef OP_KEY_DOWN_ENABLED
	if (uni_stri_eq(str, "Down")) return OP_KEY_DOWN;
#endif // OP_KEY_DOWN_ENABLED
#ifdef OP_KEY_SELECT_ENABLED
	if (uni_stri_eq(str, "Select")) return OP_KEY_SELECT;
#endif // OP_KEY_SELECT_ENABLED
#ifdef OP_KEY_PRINT_ENABLED
	if (uni_stri_eq(str, "Print")) return OP_KEY_PRINT;
#endif // OP_KEY_PRINT_ENABLED
#ifdef OP_KEY_EXECUTE_ENABLED
	if (uni_stri_eq(str, "Execute")) return OP_KEY_EXECUTE;
#endif // OP_KEY_EXECUTE_ENABLED
#ifdef OP_KEY_PRINTSCREEN_ENABLED
	if (uni_stri_eq(str, "PrintScreen")) return OP_KEY_PRINTSCREEN;
#endif // OP_KEY_PRINTSCREEN_ENABLED
#ifdef OP_KEY_INSERT_ENABLED
	if (uni_stri_eq(str, "Insert")) return OP_KEY_INSERT;
#endif // OP_KEY_INSERT_ENABLED
#ifdef OP_KEY_INSERT_ENABLED
	if (uni_stri_eq(str, "Ins")) return OP_KEY_INSERT;
#endif // OP_KEY_INSERT_ENABLED
#ifdef OP_KEY_DELETE_ENABLED
	if (uni_stri_eq(str, "Delete")) return OP_KEY_DELETE;
#endif // OP_KEY_DELETE_ENABLED
#ifdef OP_KEY_DELETE_ENABLED
	if (uni_stri_eq(str, "Del")) return OP_KEY_DELETE;
#endif // OP_KEY_DELETE_ENABLED
#ifdef OP_KEY_HELP_ENABLED
	if (uni_stri_eq(str, "Help")) return OP_KEY_HELP;
#endif // OP_KEY_HELP_ENABLED
#ifdef OP_KEY_0_ENABLED
	if (uni_stri_eq(str, "0")) return OP_KEY_0;
#endif // OP_KEY_0_ENABLED
#ifdef OP_KEY_1_ENABLED
	if (uni_stri_eq(str, "1")) return OP_KEY_1;
#endif // OP_KEY_1_ENABLED
#ifdef OP_KEY_2_ENABLED
	if (uni_stri_eq(str, "2")) return OP_KEY_2;
#endif // OP_KEY_2_ENABLED
#ifdef OP_KEY_3_ENABLED
	if (uni_stri_eq(str, "3")) return OP_KEY_3;
#endif // OP_KEY_3_ENABLED
#ifdef OP_KEY_4_ENABLED
	if (uni_stri_eq(str, "4")) return OP_KEY_4;
#endif // OP_KEY_4_ENABLED
#ifdef OP_KEY_5_ENABLED
	if (uni_stri_eq(str, "5")) return OP_KEY_5;
#endif // OP_KEY_5_ENABLED
#ifdef OP_KEY_6_ENABLED
	if (uni_stri_eq(str, "6")) return OP_KEY_6;
#endif // OP_KEY_6_ENABLED
#ifdef OP_KEY_7_ENABLED
	if (uni_stri_eq(str, "7")) return OP_KEY_7;
#endif // OP_KEY_7_ENABLED
#ifdef OP_KEY_8_ENABLED
	if (uni_stri_eq(str, "8")) return OP_KEY_8;
#endif // OP_KEY_8_ENABLED
#ifdef OP_KEY_9_ENABLED
	if (uni_stri_eq(str, "9")) return OP_KEY_9;
#endif // OP_KEY_9_ENABLED
#ifdef OP_KEY_A_ENABLED
	if (uni_stri_eq(str, "A")) return OP_KEY_A;
#endif // OP_KEY_A_ENABLED
#ifdef OP_KEY_B_ENABLED
	if (uni_stri_eq(str, "B")) return OP_KEY_B;
#endif // OP_KEY_B_ENABLED
#ifdef OP_KEY_C_ENABLED
	if (uni_stri_eq(str, "C")) return OP_KEY_C;
#endif // OP_KEY_C_ENABLED
#ifdef OP_KEY_D_ENABLED
	if (uni_stri_eq(str, "D")) return OP_KEY_D;
#endif // OP_KEY_D_ENABLED
#ifdef OP_KEY_E_ENABLED
	if (uni_stri_eq(str, "E")) return OP_KEY_E;
#endif // OP_KEY_E_ENABLED
#ifdef OP_KEY_F_ENABLED
	if (uni_stri_eq(str, "F")) return OP_KEY_F;
#endif // OP_KEY_F_ENABLED
#ifdef OP_KEY_G_ENABLED
	if (uni_stri_eq(str, "G")) return OP_KEY_G;
#endif // OP_KEY_G_ENABLED
#ifdef OP_KEY_H_ENABLED
	if (uni_stri_eq(str, "H")) return OP_KEY_H;
#endif // OP_KEY_H_ENABLED
#ifdef OP_KEY_I_ENABLED
	if (uni_stri_eq(str, "I")) return OP_KEY_I;
#endif // OP_KEY_I_ENABLED
#ifdef OP_KEY_J_ENABLED
	if (uni_stri_eq(str, "J")) return OP_KEY_J;
#endif // OP_KEY_J_ENABLED
#ifdef OP_KEY_K_ENABLED
	if (uni_stri_eq(str, "K")) return OP_KEY_K;
#endif // OP_KEY_K_ENABLED
#ifdef OP_KEY_L_ENABLED
	if (uni_stri_eq(str, "L")) return OP_KEY_L;
#endif // OP_KEY_L_ENABLED
#ifdef OP_KEY_M_ENABLED
	if (uni_stri_eq(str, "M")) return OP_KEY_M;
#endif // OP_KEY_M_ENABLED
#ifdef OP_KEY_N_ENABLED
	if (uni_stri_eq(str, "N")) return OP_KEY_N;
#endif // OP_KEY_N_ENABLED
#ifdef OP_KEY_O_ENABLED
	if (uni_stri_eq(str, "O")) return OP_KEY_O;
#endif // OP_KEY_O_ENABLED
#ifdef OP_KEY_P_ENABLED
	if (uni_stri_eq(str, "P")) return OP_KEY_P;
#endif // OP_KEY_P_ENABLED
#ifdef OP_KEY_Q_ENABLED
	if (uni_stri_eq(str, "Q")) return OP_KEY_Q;
#endif // OP_KEY_Q_ENABLED
#ifdef OP_KEY_R_ENABLED
	if (uni_stri_eq(str, "R")) return OP_KEY_R;
#endif // OP_KEY_R_ENABLED
#ifdef OP_KEY_S_ENABLED
	if (uni_stri_eq(str, "S")) return OP_KEY_S;
#endif // OP_KEY_S_ENABLED
#ifdef OP_KEY_T_ENABLED
	if (uni_stri_eq(str, "T")) return OP_KEY_T;
#endif // OP_KEY_T_ENABLED
#ifdef OP_KEY_U_ENABLED
	if (uni_stri_eq(str, "U")) return OP_KEY_U;
#endif // OP_KEY_U_ENABLED
#ifdef OP_KEY_V_ENABLED
	if (uni_stri_eq(str, "V")) return OP_KEY_V;
#endif // OP_KEY_V_ENABLED
#ifdef OP_KEY_W_ENABLED
	if (uni_stri_eq(str, "W")) return OP_KEY_W;
#endif // OP_KEY_W_ENABLED
#ifdef OP_KEY_X_ENABLED
	if (uni_stri_eq(str, "X")) return OP_KEY_X;
#endif // OP_KEY_X_ENABLED
#ifdef OP_KEY_Y_ENABLED
	if (uni_stri_eq(str, "Y")) return OP_KEY_Y;
#endif // OP_KEY_Y_ENABLED
#ifdef OP_KEY_Z_ENABLED
	if (uni_stri_eq(str, "Z")) return OP_KEY_Z;
#endif // OP_KEY_Z_ENABLED
#ifdef OP_KEY_WINDOW_ENABLED
	if (uni_stri_eq(str, "Window")) return OP_KEY_WINDOW;
#endif // OP_KEY_WINDOW_ENABLED
#ifdef OP_KEY_MAC_CTRL_ENABLED
	if (uni_stri_eq(str, "MacControl")) return OP_KEY_MAC_CTRL;
#endif // OP_KEY_MAC_CTRL_ENABLED
#ifdef OP_KEY_CONTEXT_MENU_ENABLED
	if (uni_stri_eq(str, "ContextMenu")) return OP_KEY_CONTEXT_MENU;
#endif // OP_KEY_CONTEXT_MENU_ENABLED
#ifdef OP_KEY_SLEEP_ENABLED
	if (uni_stri_eq(str, "Sleep")) return OP_KEY_SLEEP;
#endif // OP_KEY_SLEEP_ENABLED
#ifdef OP_KEY_NUMPAD0_ENABLED
	if (uni_stri_eq(str, "NumPad0")) return OP_KEY_NUMPAD0;
#endif // OP_KEY_NUMPAD0_ENABLED
#ifdef OP_KEY_NUMPAD1_ENABLED
	if (uni_stri_eq(str, "NumPad1")) return OP_KEY_NUMPAD1;
#endif // OP_KEY_NUMPAD1_ENABLED
#ifdef OP_KEY_NUMPAD2_ENABLED
	if (uni_stri_eq(str, "NumPad2")) return OP_KEY_NUMPAD2;
#endif // OP_KEY_NUMPAD2_ENABLED
#ifdef OP_KEY_NUMPAD3_ENABLED
	if (uni_stri_eq(str, "NumPad3")) return OP_KEY_NUMPAD3;
#endif // OP_KEY_NUMPAD3_ENABLED
#ifdef OP_KEY_NUMPAD4_ENABLED
	if (uni_stri_eq(str, "NumPad4")) return OP_KEY_NUMPAD4;
#endif // OP_KEY_NUMPAD4_ENABLED
#ifdef OP_KEY_NUMPAD5_ENABLED
	if (uni_stri_eq(str, "NumPad5")) return OP_KEY_NUMPAD5;
#endif // OP_KEY_NUMPAD5_ENABLED
#ifdef OP_KEY_NUMPAD6_ENABLED
	if (uni_stri_eq(str, "NumPad6")) return OP_KEY_NUMPAD6;
#endif // OP_KEY_NUMPAD6_ENABLED
#ifdef OP_KEY_NUMPAD7_ENABLED
	if (uni_stri_eq(str, "NumPad7")) return OP_KEY_NUMPAD7;
#endif // OP_KEY_NUMPAD7_ENABLED
#ifdef OP_KEY_NUMPAD8_ENABLED
	if (uni_stri_eq(str, "NumPad8")) return OP_KEY_NUMPAD8;
#endif // OP_KEY_NUMPAD8_ENABLED
#ifdef OP_KEY_NUMPAD9_ENABLED
	if (uni_stri_eq(str, "NumPad9")) return OP_KEY_NUMPAD9;
#endif // OP_KEY_NUMPAD9_ENABLED
#ifdef OP_KEY_MULTIPLY_ENABLED
	if (uni_stri_eq(str, "Mul")) return OP_KEY_MULTIPLY;
#endif // OP_KEY_MULTIPLY_ENABLED
#ifdef OP_KEY_ADD_ENABLED
	if (uni_stri_eq(str, "Add")) return OP_KEY_ADD;
#endif // OP_KEY_ADD_ENABLED
#ifdef OP_KEY_SEPARATOR_ENABLED
	if (uni_stri_eq(str, "Separator")) return OP_KEY_SEPARATOR;
#endif // OP_KEY_SEPARATOR_ENABLED
#ifdef OP_KEY_SUBTRACT_ENABLED
	if (uni_stri_eq(str, "Subtract")) return OP_KEY_SUBTRACT;
#endif // OP_KEY_SUBTRACT_ENABLED
#ifdef OP_KEY_DECIMAL_ENABLED
	if (uni_stri_eq(str, "Decimal")) return OP_KEY_DECIMAL;
#endif // OP_KEY_DECIMAL_ENABLED
#ifdef OP_KEY_DECIMAL_ENABLED
	if (uni_stri_eq(str, "Dec")) return OP_KEY_DECIMAL;
#endif // OP_KEY_DECIMAL_ENABLED
#ifdef OP_KEY_DIVIDE_ENABLED
	if (uni_stri_eq(str, "Divide")) return OP_KEY_DIVIDE;
#endif // OP_KEY_DIVIDE_ENABLED
#ifdef OP_KEY_F1_ENABLED
	if (uni_stri_eq(str, "F1")) return OP_KEY_F1;
#endif // OP_KEY_F1_ENABLED
#ifdef OP_KEY_F2_ENABLED
	if (uni_stri_eq(str, "F2")) return OP_KEY_F2;
#endif // OP_KEY_F2_ENABLED
#ifdef OP_KEY_F3_ENABLED
	if (uni_stri_eq(str, "F3")) return OP_KEY_F3;
#endif // OP_KEY_F3_ENABLED
#ifdef OP_KEY_F4_ENABLED
	if (uni_stri_eq(str, "F4")) return OP_KEY_F4;
#endif // OP_KEY_F4_ENABLED
#ifdef OP_KEY_F5_ENABLED
	if (uni_stri_eq(str, "F5")) return OP_KEY_F5;
#endif // OP_KEY_F5_ENABLED
#ifdef OP_KEY_F6_ENABLED
	if (uni_stri_eq(str, "F6")) return OP_KEY_F6;
#endif // OP_KEY_F6_ENABLED
#ifdef OP_KEY_F7_ENABLED
	if (uni_stri_eq(str, "F7")) return OP_KEY_F7;
#endif // OP_KEY_F7_ENABLED
#ifdef OP_KEY_F8_ENABLED
	if (uni_stri_eq(str, "F8")) return OP_KEY_F8;
#endif // OP_KEY_F8_ENABLED
#ifdef OP_KEY_F9_ENABLED
	if (uni_stri_eq(str, "F9")) return OP_KEY_F9;
#endif // OP_KEY_F9_ENABLED
#ifdef OP_KEY_F10_ENABLED
	if (uni_stri_eq(str, "F10")) return OP_KEY_F10;
#endif // OP_KEY_F10_ENABLED
#ifdef OP_KEY_F11_ENABLED
	if (uni_stri_eq(str, "F11")) return OP_KEY_F11;
#endif // OP_KEY_F11_ENABLED
#ifdef OP_KEY_F12_ENABLED
	if (uni_stri_eq(str, "F12")) return OP_KEY_F12;
#endif // OP_KEY_F12_ENABLED
#ifdef OP_KEY_F13_ENABLED
	if (uni_stri_eq(str, "F13")) return OP_KEY_F13;
#endif // OP_KEY_F13_ENABLED
#ifdef OP_KEY_F14_ENABLED
	if (uni_stri_eq(str, "F14")) return OP_KEY_F14;
#endif // OP_KEY_F14_ENABLED
#ifdef OP_KEY_F15_ENABLED
	if (uni_stri_eq(str, "F15")) return OP_KEY_F15;
#endif // OP_KEY_F15_ENABLED
#ifdef OP_KEY_F16_ENABLED
	if (uni_stri_eq(str, "F16")) return OP_KEY_F16;
#endif // OP_KEY_F16_ENABLED
#ifdef OP_KEY_F17_ENABLED
	if (uni_stri_eq(str, "F17")) return OP_KEY_F17;
#endif // OP_KEY_F17_ENABLED
#ifdef OP_KEY_F18_ENABLED
	if (uni_stri_eq(str, "F18")) return OP_KEY_F18;
#endif // OP_KEY_F18_ENABLED
#ifdef OP_KEY_F19_ENABLED
	if (uni_stri_eq(str, "F19")) return OP_KEY_F19;
#endif // OP_KEY_F19_ENABLED
#ifdef OP_KEY_F20_ENABLED
	if (uni_stri_eq(str, "F20")) return OP_KEY_F20;
#endif // OP_KEY_F20_ENABLED
#ifdef OP_KEY_F21_ENABLED
	if (uni_stri_eq(str, "F21")) return OP_KEY_F21;
#endif // OP_KEY_F21_ENABLED
#ifdef OP_KEY_F22_ENABLED
	if (uni_stri_eq(str, "F22")) return OP_KEY_F22;
#endif // OP_KEY_F22_ENABLED
#ifdef OP_KEY_F23_ENABLED
	if (uni_stri_eq(str, "F23")) return OP_KEY_F23;
#endif // OP_KEY_F23_ENABLED
#ifdef OP_KEY_F24_ENABLED
	if (uni_stri_eq(str, "F24")) return OP_KEY_F24;
#endif // OP_KEY_F24_ENABLED
#ifdef OP_KEY_NUM_LOCK_ENABLED
	if (uni_stri_eq(str, "NumLock")) return OP_KEY_NUM_LOCK;
#endif // OP_KEY_NUM_LOCK_ENABLED
#ifdef OP_KEY_SCROLL_LOCK_ENABLED
	if (uni_stri_eq(str, "ScrollLock")) return OP_KEY_SCROLL_LOCK;
#endif // OP_KEY_SCROLL_LOCK_ENABLED
#ifdef OP_KEY_META_ENABLED
	if (uni_stri_eq(str, "Meta")) return OP_KEY_META;
#endif // OP_KEY_META_ENABLED
#ifdef OP_KEY_OEM_1_ENABLED
	if (uni_stri_eq(str, "Oem1")) return OP_KEY_OEM_1;
#endif // OP_KEY_OEM_1_ENABLED
#ifdef OP_KEY_OEM_1_ENABLED
	if (uni_stri_eq(str, "Semicolon")) return OP_KEY_OEM_1;
#endif // OP_KEY_OEM_1_ENABLED
#ifdef OP_KEY_OEM_PLUS_ENABLED
	if (uni_stri_eq(str, "OemPlus")) return OP_KEY_OEM_PLUS;
#endif // OP_KEY_OEM_PLUS_ENABLED
#ifdef OP_KEY_OEM_PLUS_ENABLED
	if (uni_stri_eq(str, "Plus")) return OP_KEY_OEM_PLUS;
#endif // OP_KEY_OEM_PLUS_ENABLED
#ifdef OP_KEY_OEM_COMMA_ENABLED
	if (uni_stri_eq(str, "OemComma")) return OP_KEY_OEM_COMMA;
#endif // OP_KEY_OEM_COMMA_ENABLED
#ifdef OP_KEY_OEM_COMMA_ENABLED
	if (uni_stri_eq(str, "Comma")) return OP_KEY_OEM_COMMA;
#endif // OP_KEY_OEM_COMMA_ENABLED
#ifdef OP_KEY_OEM_MINUS_ENABLED
	if (uni_stri_eq(str, "OemMinus")) return OP_KEY_OEM_MINUS;
#endif // OP_KEY_OEM_MINUS_ENABLED
#ifdef OP_KEY_OEM_PERIOD_ENABLED
	if (uni_stri_eq(str, "OemPeriod")) return OP_KEY_OEM_PERIOD;
#endif // OP_KEY_OEM_PERIOD_ENABLED
#ifdef OP_KEY_OEM_2_ENABLED
	if (uni_stri_eq(str, "Oem2")) return OP_KEY_OEM_2;
#endif // OP_KEY_OEM_2_ENABLED
#ifdef OP_KEY_OEM_3_ENABLED
	if (uni_stri_eq(str, "Oem3")) return OP_KEY_OEM_3;
#endif // OP_KEY_OEM_3_ENABLED
#ifdef OP_KEY_OEM_4_ENABLED
	if (uni_stri_eq(str, "Oem4")) return OP_KEY_OEM_4;
#endif // OP_KEY_OEM_4_ENABLED
#ifdef OP_KEY_OEM_5_ENABLED
	if (uni_stri_eq(str, "Oem5")) return OP_KEY_OEM_5;
#endif // OP_KEY_OEM_5_ENABLED
#ifdef OP_KEY_OEM_6_ENABLED
	if (uni_stri_eq(str, "Oem6")) return OP_KEY_OEM_6;
#endif // OP_KEY_OEM_6_ENABLED
#ifdef OP_KEY_OEM_7_ENABLED
	if (uni_stri_eq(str, "Oem7")) return OP_KEY_OEM_7;
#endif // OP_KEY_OEM_7_ENABLED
#ifdef OP_KEY_OEM_8_ENABLED
	if (uni_stri_eq(str, "Oem8")) return OP_KEY_OEM_8;
#endif // OP_KEY_OEM_8_ENABLED
#ifdef OP_KEY_OEM_102_ENABLED
	if (uni_stri_eq(str, "Oem102")) return OP_KEY_OEM_102;
#endif // OP_KEY_OEM_102_ENABLED
#ifdef OP_KEY_PROCESSKEY_ENABLED
	if (uni_stri_eq(str, "IMEProcess")) return OP_KEY_PROCESSKEY;
#endif // OP_KEY_PROCESSKEY_ENABLED
#ifdef OP_KEY_UNICODE_ENABLED
	if (uni_stri_eq(str, "KeyInput")) return OP_KEY_UNICODE;
#endif // OP_KEY_UNICODE_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_1_ENABLED
	if (uni_stri_eq(str, "Button1")) return OP_KEY_MOUSE_BUTTON_1;
#endif // OP_KEY_MOUSE_BUTTON_1_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_2_ENABLED
	if (uni_stri_eq(str, "Button2")) return OP_KEY_MOUSE_BUTTON_2;
#endif // OP_KEY_MOUSE_BUTTON_2_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_3_ENABLED
	if (uni_stri_eq(str, "Button3")) return OP_KEY_MOUSE_BUTTON_3;
#endif // OP_KEY_MOUSE_BUTTON_3_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_4_ENABLED
	if (uni_stri_eq(str, "Button4")) return OP_KEY_MOUSE_BUTTON_4;
#endif // OP_KEY_MOUSE_BUTTON_4_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_5_ENABLED
	if (uni_stri_eq(str, "Button5")) return OP_KEY_MOUSE_BUTTON_5;
#endif // OP_KEY_MOUSE_BUTTON_5_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_6_ENABLED
	if (uni_stri_eq(str, "Button6")) return OP_KEY_MOUSE_BUTTON_6;
#endif // OP_KEY_MOUSE_BUTTON_6_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_7_ENABLED
	if (uni_stri_eq(str, "Button7")) return OP_KEY_MOUSE_BUTTON_7;
#endif // OP_KEY_MOUSE_BUTTON_7_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_8_ENABLED
	if (uni_stri_eq(str, "Button8")) return OP_KEY_MOUSE_BUTTON_8;
#endif // OP_KEY_MOUSE_BUTTON_8_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_9_ENABLED
	if (uni_stri_eq(str, "Button9")) return OP_KEY_MOUSE_BUTTON_9;
#endif // OP_KEY_MOUSE_BUTTON_9_ENABLED
#ifdef OP_KEY_GESTURE_UP_ENABLED
	if (uni_stri_eq(str, "GestureUp")) return OP_KEY_GESTURE_UP;
#endif // OP_KEY_GESTURE_UP_ENABLED
#ifdef OP_KEY_GESTURE_RIGHT_ENABLED
	if (uni_stri_eq(str, "GestureRight")) return OP_KEY_GESTURE_RIGHT;
#endif // OP_KEY_GESTURE_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_ENABLED
	if (uni_stri_eq(str, "GestureDown")) return OP_KEY_GESTURE_DOWN;
#endif // OP_KEY_GESTURE_DOWN_ENABLED
#ifdef OP_KEY_GESTURE_LEFT_ENABLED
	if (uni_stri_eq(str, "GestureLeft")) return OP_KEY_GESTURE_LEFT;
#endif // OP_KEY_GESTURE_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_LEFT_ENABLED
	if (uni_stri_eq(str, "GestureUpLeft")) return OP_KEY_GESTURE_UP_LEFT;
#endif // OP_KEY_GESTURE_UP_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_RIGHT_ENABLED
	if (uni_stri_eq(str, "GestureUpRight")) return OP_KEY_GESTURE_UP_RIGHT;
#endif // OP_KEY_GESTURE_UP_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_LEFT_ENABLED
	if (uni_stri_eq(str, "GestureDownLeft")) return OP_KEY_GESTURE_DOWN_LEFT;
#endif // OP_KEY_GESTURE_DOWN_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
	if (uni_stri_eq(str, "GestureDownRight")) return OP_KEY_GESTURE_DOWN_RIGHT;
#endif // OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
#ifdef OP_KEY_FLIP_BACK_ENABLED
	if (uni_stri_eq(str, "FlipBack")) return OP_KEY_FLIP_BACK;
#endif // OP_KEY_FLIP_BACK_ENABLED
#ifdef OP_KEY_FLIP_FORWARD_ENABLED
	if (uni_stri_eq(str, "FlipForward")) return OP_KEY_FLIP_FORWARD;
#endif // OP_KEY_FLIP_FORWARD_ENABLED
#ifdef OP_KEY_F25_ENABLED
	if (uni_stri_eq(str, "F25")) return OP_KEY_F25;
#endif // OP_KEY_F25_ENABLED
#ifdef OP_KEY_F26_ENABLED
	if (uni_stri_eq(str, "F26")) return OP_KEY_F26;
#endif // OP_KEY_F26_ENABLED
#ifdef OP_KEY_F27_ENABLED
	if (uni_stri_eq(str, "F27")) return OP_KEY_F27;
#endif // OP_KEY_F27_ENABLED
#ifdef OP_KEY_F28_ENABLED
	if (uni_stri_eq(str, "F28")) return OP_KEY_F28;
#endif // OP_KEY_F28_ENABLED
#ifdef OP_KEY_F29_ENABLED
	if (uni_stri_eq(str, "F29")) return OP_KEY_F29;
#endif // OP_KEY_F29_ENABLED
#ifdef OP_KEY_F30_ENABLED
	if (uni_stri_eq(str, "F30")) return OP_KEY_F30;
#endif // OP_KEY_F30_ENABLED
#ifdef OP_KEY_F31_ENABLED
	if (uni_stri_eq(str, "F31")) return OP_KEY_F31;
#endif // OP_KEY_F31_ENABLED
#ifdef OP_KEY_F32_ENABLED
	if (uni_stri_eq(str, "F32")) return OP_KEY_F32;
#endif // OP_KEY_F32_ENABLED
#ifdef OP_KEY_F33_ENABLED
	if (uni_stri_eq(str, "F33")) return OP_KEY_F33;
#endif // OP_KEY_F33_ENABLED
#ifdef OP_KEY_F34_ENABLED
	if (uni_stri_eq(str, "F34")) return OP_KEY_F34;
#endif // OP_KEY_F34_ENABLED
#ifdef OP_KEY_F35_ENABLED
	if (uni_stri_eq(str, "F35")) return OP_KEY_F35;
#endif // OP_KEY_F35_ENABLED
#ifdef OP_KEY_F36_ENABLED
	if (uni_stri_eq(str, "F36")) return OP_KEY_F36;
#endif // OP_KEY_F36_ENABLED
#ifdef OP_KEY_VOLUMEUP_ENABLED
	if (uni_stri_eq(str, "RC_VOLUMEUP")) return OP_KEY_VOLUMEUP;
#endif // OP_KEY_VOLUMEUP_ENABLED
#ifdef OP_KEY_VOLUMEDOWN_ENABLED
	if (uni_stri_eq(str, "RC_VOLUMEDOWN")) return OP_KEY_VOLUMEDOWN;
#endif // OP_KEY_VOLUMEDOWN_ENABLED
#ifdef OP_KEY_MENU_ENABLED
	if (uni_stri_eq(str, "RC_MENU")) return OP_KEY_MENU;
#endif // OP_KEY_MENU_ENABLED
#ifdef OP_KEY_PLAY_ENABLED
	if (uni_stri_eq(str, "RC_PLAY")) return OP_KEY_PLAY;
#endif // OP_KEY_PLAY_ENABLED
#ifdef OP_KEY_NEXT_ENABLED
	if (uni_stri_eq(str, "RC_NEXT")) return OP_KEY_NEXT;
#endif // OP_KEY_NEXT_ENABLED
#ifdef OP_KEY_PREVIOUS_ENABLED
	if (uni_stri_eq(str, "RC_PREVIOUS")) return OP_KEY_PREVIOUS;
#endif // OP_KEY_PREVIOUS_ENABLED
#ifdef OP_KEY_FASTFORWARD_ENABLED
	if (uni_stri_eq(str, "RC_FASTFORWARD")) return OP_KEY_FASTFORWARD;
#endif // OP_KEY_FASTFORWARD_ENABLED
#ifdef OP_KEY_REWIND_ENABLED
	if (uni_stri_eq(str, "RC_REWIND")) return OP_KEY_REWIND;
#endif // OP_KEY_REWIND_ENABLED
#ifdef OP_KEY_STOP_ENABLED
	if (uni_stri_eq(str, "RC_STOP")) return OP_KEY_STOP;
#endif // OP_KEY_STOP_ENABLED
#ifdef OP_KEY_REDO_ENABLED
	if (uni_stri_eq(str, "Redo")) return OP_KEY_REDO;
#endif // OP_KEY_REDO_ENABLED
#ifdef OP_KEY_UNDO_ENABLED
	if (uni_stri_eq(str, "Undo")) return OP_KEY_UNDO;
#endif // OP_KEY_UNDO_ENABLED
#ifdef OP_KEY_PROPERITES_ENABLED
	if (uni_stri_eq(str, "Properites")) return OP_KEY_PROPERITES;
#endif // OP_KEY_PROPERITES_ENABLED
#ifdef OP_KEY_FRONT_ENABLED
	if (uni_stri_eq(str, "Front")) return OP_KEY_FRONT;
#endif // OP_KEY_FRONT_ENABLED
#ifdef OP_KEY_LEFT_TAB_ENABLED
	if (uni_stri_eq(str, "LeftTab")) return OP_KEY_LEFT_TAB;
#endif // OP_KEY_LEFT_TAB_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
	if (uni_stri_eq(str, "MonBrightnessUp")) return OP_KEY_XF86XK_MON_BRIGHTNESS_UP;
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
	if (uni_stri_eq(str, "MonBrightnessDown")) return OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN;
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
	if (uni_stri_eq(str, "KbdLightOnOff")) return OP_KEY_XF86XK_KBD_LIGHT_ON_OFF;
#endif // OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
	if (uni_stri_eq(str, "KbdBrightnessUp")) return OP_KEY_XF86XK_KBD_BRIGHTNESS_UP;
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
	if (uni_stri_eq(str, "KbdBrightnessDown")) return OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN;
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_STANDBY_ENABLED
	if (uni_stri_eq(str, "Standby")) return OP_KEY_XF86XK_STANDBY;
#endif // OP_KEY_XF86XK_STANDBY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
	if (uni_stri_eq(str, "AudioLowerVolume")) return OP_KEY_XF86XK_AUDIO_LOWER_VOLUME;
#endif // OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
	if (uni_stri_eq(str, "AudioMute")) return OP_KEY_XF86XK_AUDIO_MUTE;
#endif // OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
	if (uni_stri_eq(str, "AudioRaiseVolume")) return OP_KEY_XF86XK_AUDIO_RAISE_VOLUME;
#endif // OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
	if (uni_stri_eq(str, "AudioPlay")) return OP_KEY_XF86XK_AUDIO_PLAY;
#endif // OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_STOP_ENABLED
	if (uni_stri_eq(str, "AudioStop")) return OP_KEY_XF86XK_AUDIO_STOP;
#endif // OP_KEY_XF86XK_AUDIO_STOP_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PREV_ENABLED
	if (uni_stri_eq(str, "AudioPrev")) return OP_KEY_XF86XK_AUDIO_PREV;
#endif // OP_KEY_XF86XK_AUDIO_PREV_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
	if (uni_stri_eq(str, "AudioNext")) return OP_KEY_XF86XK_AUDIO_NEXT;
#endif // OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
#ifdef OP_KEY_XF86XK_HOME_PAGE_ENABLED
	if (uni_stri_eq(str, "HomePage")) return OP_KEY_XF86XK_HOME_PAGE;
#endif // OP_KEY_XF86XK_HOME_PAGE_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_ENABLED
	if (uni_stri_eq(str, "Mail")) return OP_KEY_XF86XK_MAIL;
#endif // OP_KEY_XF86XK_MAIL_ENABLED
#ifdef OP_KEY_XF86XK_START_ENABLED
	if (uni_stri_eq(str, "Start")) return OP_KEY_XF86XK_START;
#endif // OP_KEY_XF86XK_START_ENABLED
#ifdef OP_KEY_XF86XK_SEARCH_ENABLED
	if (uni_stri_eq(str, "Search")) return OP_KEY_XF86XK_SEARCH;
#endif // OP_KEY_XF86XK_SEARCH_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
	if (uni_stri_eq(str, "AudioRecord")) return OP_KEY_XF86XK_AUDIO_RECORD;
#endif // OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
#ifdef OP_KEY_XF86XK_CALCULATOR_ENABLED
	if (uni_stri_eq(str, "Calculator")) return OP_KEY_XF86XK_CALCULATOR;
#endif // OP_KEY_XF86XK_CALCULATOR_ENABLED
#ifdef OP_KEY_XF86XK_MEMO_ENABLED
	if (uni_stri_eq(str, "Memo")) return OP_KEY_XF86XK_MEMO;
#endif // OP_KEY_XF86XK_MEMO_ENABLED
#ifdef OP_KEY_XF86XK_TO_DO_LIST_ENABLED
	if (uni_stri_eq(str, "ToDoList")) return OP_KEY_XF86XK_TO_DO_LIST;
#endif // OP_KEY_XF86XK_TO_DO_LIST_ENABLED
#ifdef OP_KEY_XF86XK_CALENDAR_ENABLED
	if (uni_stri_eq(str, "Calendar")) return OP_KEY_XF86XK_CALENDAR;
#endif // OP_KEY_XF86XK_CALENDAR_ENABLED
#ifdef OP_KEY_XF86XK_POWER_DOWN_ENABLED
	if (uni_stri_eq(str, "PowerDown")) return OP_KEY_XF86XK_POWER_DOWN;
#endif // OP_KEY_XF86XK_POWER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
	if (uni_stri_eq(str, "ContrastAdjust")) return OP_KEY_XF86XK_CONTRAST_ADJUST;
#endif // OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_UP_ENABLED
	if (uni_stri_eq(str, "RockerUp")) return OP_KEY_XF86XK_ROCKER_UP;
#endif // OP_KEY_XF86XK_ROCKER_UP_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
	if (uni_stri_eq(str, "RockerDown")) return OP_KEY_XF86XK_ROCKER_DOWN;
#endif // OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
	if (uni_stri_eq(str, "RockerEnter")) return OP_KEY_XF86XK_ROCKER_ENTER;
#endif // OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
#ifdef OP_KEY_XF86XK_BACK_ENABLED
	if (uni_stri_eq(str, "Back")) return OP_KEY_XF86XK_BACK;
#endif // OP_KEY_XF86XK_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FORWARD_ENABLED
	if (uni_stri_eq(str, "Forward")) return OP_KEY_XF86XK_FORWARD;
#endif // OP_KEY_XF86XK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_STOP_ENABLED
	if (uni_stri_eq(str, "Stop")) return OP_KEY_XF86XK_STOP;
#endif // OP_KEY_XF86XK_STOP_ENABLED
#ifdef OP_KEY_XF86XK_REFRESH_ENABLED
	if (uni_stri_eq(str, "Refresh")) return OP_KEY_XF86XK_REFRESH;
#endif // OP_KEY_XF86XK_REFRESH_ENABLED
#ifdef OP_KEY_XF86XK_POWER_OFF_ENABLED
	if (uni_stri_eq(str, "PowerOff")) return OP_KEY_XF86XK_POWER_OFF;
#endif // OP_KEY_XF86XK_POWER_OFF_ENABLED
#ifdef OP_KEY_XF86XK_WAKE_UP_ENABLED
	if (uni_stri_eq(str, "WakeUp")) return OP_KEY_XF86XK_WAKE_UP;
#endif // OP_KEY_XF86XK_WAKE_UP_ENABLED
#ifdef OP_KEY_XF86XK_EJECT_ENABLED
	if (uni_stri_eq(str, "Eject")) return OP_KEY_XF86XK_EJECT;
#endif // OP_KEY_XF86XK_EJECT_ENABLED
#ifdef OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
	if (uni_stri_eq(str, "ScreenSaver")) return OP_KEY_XF86XK_SCREEN_SAVER;
#endif // OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
#ifdef OP_KEY_XF86XK_WWW_ENABLED
	if (uni_stri_eq(str, "WWW")) return OP_KEY_XF86XK_WWW;
#endif // OP_KEY_XF86XK_WWW_ENABLED
#ifdef OP_KEY_XF86XK_FAVORITES_ENABLED
	if (uni_stri_eq(str, "Favorites")) return OP_KEY_XF86XK_FAVORITES;
#endif // OP_KEY_XF86XK_FAVORITES_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
	if (uni_stri_eq(str, "AudioPause")) return OP_KEY_XF86XK_AUDIO_PAUSE;
#endif // OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
	if (uni_stri_eq(str, "AudioMedia")) return OP_KEY_XF86XK_AUDIO_MEDIA;
#endif // OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
#ifdef OP_KEY_XF86XK_MY_COMPUTER_ENABLED
	if (uni_stri_eq(str, "MyComputer")) return OP_KEY_XF86XK_MY_COMPUTER;
#endif // OP_KEY_XF86XK_MY_COMPUTER_ENABLED
#ifdef OP_KEY_XF86XK_VENDOR_HOME_ENABLED
	if (uni_stri_eq(str, "VendorHome")) return OP_KEY_XF86XK_VENDOR_HOME;
#endif // OP_KEY_XF86XK_VENDOR_HOME_ENABLED
#ifdef OP_KEY_XF86XK_LIGHT_BULB_ENABLED
	if (uni_stri_eq(str, "LightBulb")) return OP_KEY_XF86XK_LIGHT_BULB;
#endif // OP_KEY_XF86XK_LIGHT_BULB_ENABLED
#ifdef OP_KEY_XF86XK_SHOP_ENABLED
	if (uni_stri_eq(str, "Shop")) return OP_KEY_XF86XK_SHOP;
#endif // OP_KEY_XF86XK_SHOP_ENABLED
#ifdef OP_KEY_XF86XK_HISTORY_ENABLED
	if (uni_stri_eq(str, "History")) return OP_KEY_XF86XK_HISTORY;
#endif // OP_KEY_XF86XK_HISTORY_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_URL_ENABLED
	if (uni_stri_eq(str, "OpenURL")) return OP_KEY_XF86XK_OPEN_URL;
#endif // OP_KEY_XF86XK_OPEN_URL_ENABLED
#ifdef OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
	if (uni_stri_eq(str, "AddFavorite")) return OP_KEY_XF86XK_ADD_FAVORITE;
#endif // OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
#ifdef OP_KEY_XF86XK_HOT_LINKS_ENABLED
	if (uni_stri_eq(str, "HotLinks")) return OP_KEY_XF86XK_HOT_LINKS;
#endif // OP_KEY_XF86XK_HOT_LINKS_ENABLED
#ifdef OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
	if (uni_stri_eq(str, "BrightnessAdjust")) return OP_KEY_XF86XK_BRIGHTNESS_ADJUST;
#endif // OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_FINANCE_ENABLED
	if (uni_stri_eq(str, "Finance")) return OP_KEY_XF86XK_FINANCE;
#endif // OP_KEY_XF86XK_FINANCE_ENABLED
#ifdef OP_KEY_XF86XK_COMMUNITY_ENABLED
	if (uni_stri_eq(str, "Community")) return OP_KEY_XF86XK_COMMUNITY;
#endif // OP_KEY_XF86XK_COMMUNITY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
	if (uni_stri_eq(str, "AudioRewind")) return OP_KEY_XF86XK_AUDIO_REWIND;
#endif // OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
#ifdef OP_KEY_XF86XK_BACK_FORWARD_ENABLED
	if (uni_stri_eq(str, "BackForward")) return OP_KEY_XF86XK_BACK_FORWARD;
#endif // OP_KEY_XF86XK_BACK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH0_ENABLED
	if (uni_stri_eq(str, "Launch0")) return OP_KEY_XF86XK_LAUNCH0;
#endif // OP_KEY_XF86XK_LAUNCH0_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH1_ENABLED
	if (uni_stri_eq(str, "Launch1")) return OP_KEY_XF86XK_LAUNCH1;
#endif // OP_KEY_XF86XK_LAUNCH1_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH2_ENABLED
	if (uni_stri_eq(str, "Launch2")) return OP_KEY_XF86XK_LAUNCH2;
#endif // OP_KEY_XF86XK_LAUNCH2_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH3_ENABLED
	if (uni_stri_eq(str, "Launch3")) return OP_KEY_XF86XK_LAUNCH3;
#endif // OP_KEY_XF86XK_LAUNCH3_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH4_ENABLED
	if (uni_stri_eq(str, "Launch4")) return OP_KEY_XF86XK_LAUNCH4;
#endif // OP_KEY_XF86XK_LAUNCH4_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH5_ENABLED
	if (uni_stri_eq(str, "Launch5")) return OP_KEY_XF86XK_LAUNCH5;
#endif // OP_KEY_XF86XK_LAUNCH5_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH6_ENABLED
	if (uni_stri_eq(str, "Launch6")) return OP_KEY_XF86XK_LAUNCH6;
#endif // OP_KEY_XF86XK_LAUNCH6_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH7_ENABLED
	if (uni_stri_eq(str, "Launch7")) return OP_KEY_XF86XK_LAUNCH7;
#endif // OP_KEY_XF86XK_LAUNCH7_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH8_ENABLED
	if (uni_stri_eq(str, "Launch8")) return OP_KEY_XF86XK_LAUNCH8;
#endif // OP_KEY_XF86XK_LAUNCH8_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH9_ENABLED
	if (uni_stri_eq(str, "Launch9")) return OP_KEY_XF86XK_LAUNCH9;
#endif // OP_KEY_XF86XK_LAUNCH9_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_A_ENABLED
	if (uni_stri_eq(str, "LaunchA")) return OP_KEY_XF86XK_LAUNCH_A;
#endif // OP_KEY_XF86XK_LAUNCH_A_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_B_ENABLED
	if (uni_stri_eq(str, "LaunchB")) return OP_KEY_XF86XK_LAUNCH_B;
#endif // OP_KEY_XF86XK_LAUNCH_B_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_C_ENABLED
	if (uni_stri_eq(str, "LaunchC")) return OP_KEY_XF86XK_LAUNCH_C;
#endif // OP_KEY_XF86XK_LAUNCH_C_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_D_ENABLED
	if (uni_stri_eq(str, "LaunchD")) return OP_KEY_XF86XK_LAUNCH_D;
#endif // OP_KEY_XF86XK_LAUNCH_D_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_E_ENABLED
	if (uni_stri_eq(str, "LaunchE")) return OP_KEY_XF86XK_LAUNCH_E;
#endif // OP_KEY_XF86XK_LAUNCH_E_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_F_ENABLED
	if (uni_stri_eq(str, "LaunchF")) return OP_KEY_XF86XK_LAUNCH_F;
#endif // OP_KEY_XF86XK_LAUNCH_F_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
	if (uni_stri_eq(str, "ApplicationLeft")) return OP_KEY_XF86XK_APPLICATION_LEFT;
#endif // OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
	if (uni_stri_eq(str, "ApplicationRight")) return OP_KEY_XF86XK_APPLICATION_RIGHT;
#endif // OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
#ifdef OP_KEY_XF86XK_BOOK_ENABLED
	if (uni_stri_eq(str, "Book")) return OP_KEY_XF86XK_BOOK;
#endif // OP_KEY_XF86XK_BOOK_ENABLED
#ifdef OP_KEY_XF86XK_CD_ENABLED
	if (uni_stri_eq(str, "CD")) return OP_KEY_XF86XK_CD;
#endif // OP_KEY_XF86XK_CD_ENABLED
#ifdef OP_KEY_XF86XK_CLOSE_ENABLED
	if (uni_stri_eq(str, "Close")) return OP_KEY_XF86XK_CLOSE;
#endif // OP_KEY_XF86XK_CLOSE_ENABLED
#ifdef OP_KEY_XF86XK_COPY_ENABLED
	if (uni_stri_eq(str, "Copy")) return OP_KEY_XF86XK_COPY;
#endif // OP_KEY_XF86XK_COPY_ENABLED
#ifdef OP_KEY_XF86XK_CUT_ENABLED
	if (uni_stri_eq(str, "Cut")) return OP_KEY_XF86XK_CUT;
#endif // OP_KEY_XF86XK_CUT_ENABLED
#ifdef OP_KEY_XF86XK_DISPLAY_ENABLED
	if (uni_stri_eq(str, "Display")) return OP_KEY_XF86XK_DISPLAY;
#endif // OP_KEY_XF86XK_DISPLAY_ENABLED
#ifdef OP_KEY_XF86XK_DOS_ENABLED
	if (uni_stri_eq(str, "DOS")) return OP_KEY_XF86XK_DOS;
#endif // OP_KEY_XF86XK_DOS_ENABLED
#ifdef OP_KEY_XF86XK_DOCUMENTS_ENABLED
	if (uni_stri_eq(str, "Documents")) return OP_KEY_XF86XK_DOCUMENTS;
#endif // OP_KEY_XF86XK_DOCUMENTS_ENABLED
#ifdef OP_KEY_XF86XK_EXCEL_ENABLED
	if (uni_stri_eq(str, "Excel")) return OP_KEY_XF86XK_EXCEL;
#endif // OP_KEY_XF86XK_EXCEL_ENABLED
#ifdef OP_KEY_XF86XK_EXPLORER_ENABLED
	if (uni_stri_eq(str, "Explorer")) return OP_KEY_XF86XK_EXPLORER;
#endif // OP_KEY_XF86XK_EXPLORER_ENABLED
#ifdef OP_KEY_XF86XK_GAME_ENABLED
	if (uni_stri_eq(str, "Game")) return OP_KEY_XF86XK_GAME;
#endif // OP_KEY_XF86XK_GAME_ENABLED
#ifdef OP_KEY_XF86XK_GO_ENABLED
	if (uni_stri_eq(str, "Go")) return OP_KEY_XF86XK_GO;
#endif // OP_KEY_XF86XK_GO_ENABLED
#ifdef OP_KEY_XF86XK_I_TOUCH_ENABLED
	if (uni_stri_eq(str, "iTouch")) return OP_KEY_XF86XK_I_TOUCH;
#endif // OP_KEY_XF86XK_I_TOUCH_ENABLED
#ifdef OP_KEY_XF86XK_LOG_OFF_ENABLED
	if (uni_stri_eq(str, "LogOff")) return OP_KEY_XF86XK_LOG_OFF;
#endif // OP_KEY_XF86XK_LOG_OFF_ENABLED
#ifdef OP_KEY_XF86XK_MARKET_ENABLED
	if (uni_stri_eq(str, "Market")) return OP_KEY_XF86XK_MARKET;
#endif // OP_KEY_XF86XK_MARKET_ENABLED
#ifdef OP_KEY_XF86XK_MEETING_ENABLED
	if (uni_stri_eq(str, "Meeting")) return OP_KEY_XF86XK_MEETING;
#endif // OP_KEY_XF86XK_MEETING_ENABLED
#ifdef OP_KEY_XF86XK_MENU_KB_ENABLED
	if (uni_stri_eq(str, "MenuKB")) return OP_KEY_XF86XK_MENU_KB;
#endif // OP_KEY_XF86XK_MENU_KB_ENABLED
#ifdef OP_KEY_XF86XK_MENU_PB_ENABLED
	if (uni_stri_eq(str, "MenuPB")) return OP_KEY_XF86XK_MENU_PB;
#endif // OP_KEY_XF86XK_MENU_PB_ENABLED
#ifdef OP_KEY_XF86XK_MY_SITES_ENABLED
	if (uni_stri_eq(str, "MySites")) return OP_KEY_XF86XK_MY_SITES;
#endif // OP_KEY_XF86XK_MY_SITES_ENABLED
#ifdef OP_KEY_XF86XK_NEW_ENABLED
	if (uni_stri_eq(str, "New")) return OP_KEY_XF86XK_NEW;
#endif // OP_KEY_XF86XK_NEW_ENABLED
#ifdef OP_KEY_XF86XK_NEWS_ENABLED
	if (uni_stri_eq(str, "News")) return OP_KEY_XF86XK_NEWS;
#endif // OP_KEY_XF86XK_NEWS_ENABLED
#ifdef OP_KEY_XF86XK_OFFICE_HOME_ENABLED
	if (uni_stri_eq(str, "OfficeHome")) return OP_KEY_XF86XK_OFFICE_HOME;
#endif // OP_KEY_XF86XK_OFFICE_HOME_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_ENABLED
	if (uni_stri_eq(str, "Open")) return OP_KEY_XF86XK_OPEN;
#endif // OP_KEY_XF86XK_OPEN_ENABLED
#ifdef OP_KEY_XF86XK_OPTION_ENABLED
	if (uni_stri_eq(str, "Option")) return OP_KEY_XF86XK_OPTION;
#endif // OP_KEY_XF86XK_OPTION_ENABLED
#ifdef OP_KEY_XF86XK_PASTE_ENABLED
	if (uni_stri_eq(str, "Paste")) return OP_KEY_XF86XK_PASTE;
#endif // OP_KEY_XF86XK_PASTE_ENABLED
#ifdef OP_KEY_XF86XK_PHONE_ENABLED
	if (uni_stri_eq(str, "Phone")) return OP_KEY_XF86XK_PHONE;
#endif // OP_KEY_XF86XK_PHONE_ENABLED
#ifdef OP_KEY_XF86XK_REPLY_ENABLED
	if (uni_stri_eq(str, "Reply")) return OP_KEY_XF86XK_REPLY;
#endif // OP_KEY_XF86XK_REPLY_ENABLED
#ifdef OP_KEY_XF86XK_RELOAD_ENABLED
	if (uni_stri_eq(str, "Reload")) return OP_KEY_XF86XK_RELOAD;
#endif // OP_KEY_XF86XK_RELOAD_ENABLED
#ifdef OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
	if (uni_stri_eq(str, "RotateWindows")) return OP_KEY_XF86XK_ROTATE_WINDOWS;
#endif // OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_PB_ENABLED
	if (uni_stri_eq(str, "RotationPB")) return OP_KEY_XF86XK_ROTATION_PB;
#endif // OP_KEY_XF86XK_ROTATION_PB_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_KB_ENABLED
	if (uni_stri_eq(str, "RotationKB")) return OP_KEY_XF86XK_ROTATION_KB;
#endif // OP_KEY_XF86XK_ROTATION_KB_ENABLED
#ifdef OP_KEY_XF86XK_SAVE_ENABLED
	if (uni_stri_eq(str, "Save")) return OP_KEY_XF86XK_SAVE;
#endif // OP_KEY_XF86XK_SAVE_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_UP_ENABLED
	if (uni_stri_eq(str, "ScrollUp")) return OP_KEY_XF86XK_SCROLL_UP;
#endif // OP_KEY_XF86XK_SCROLL_UP_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
	if (uni_stri_eq(str, "ScrollDown")) return OP_KEY_XF86XK_SCROLL_DOWN;
#endif // OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
	if (uni_stri_eq(str, "ScrollClick")) return OP_KEY_XF86XK_SCROLL_CLICK;
#endif // OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
#ifdef OP_KEY_XF86XK_SEND_ENABLED
	if (uni_stri_eq(str, "Send")) return OP_KEY_XF86XK_SEND;
#endif // OP_KEY_XF86XK_SEND_ENABLED
#ifdef OP_KEY_XF86XK_SPELL_ENABLED
	if (uni_stri_eq(str, "Spell")) return OP_KEY_XF86XK_SPELL;
#endif // OP_KEY_XF86XK_SPELL_ENABLED
#ifdef OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
	if (uni_stri_eq(str, "SplitScreen")) return OP_KEY_XF86XK_SPLIT_SCREEN;
#endif // OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
#ifdef OP_KEY_XF86XK_SUPPORT_ENABLED
	if (uni_stri_eq(str, "Support")) return OP_KEY_XF86XK_SUPPORT;
#endif // OP_KEY_XF86XK_SUPPORT_ENABLED
#ifdef OP_KEY_XF86XK_TASK_PANE_ENABLED
	if (uni_stri_eq(str, "TaskPanel")) return OP_KEY_XF86XK_TASK_PANE;
#endif // OP_KEY_XF86XK_TASK_PANE_ENABLED
#ifdef OP_KEY_XF86XK_TERMINAL_ENABLED
	if (uni_stri_eq(str, "Terminal")) return OP_KEY_XF86XK_TERMINAL;
#endif // OP_KEY_XF86XK_TERMINAL_ENABLED
#ifdef OP_KEY_XF86XK_TOOLS_ENABLED
	if (uni_stri_eq(str, "Tools")) return OP_KEY_XF86XK_TOOLS;
#endif // OP_KEY_XF86XK_TOOLS_ENABLED
#ifdef OP_KEY_XF86XK_TRAVEL_ENABLED
	if (uni_stri_eq(str, "Travel")) return OP_KEY_XF86XK_TRAVEL;
#endif // OP_KEY_XF86XK_TRAVEL_ENABLED
#ifdef OP_KEY_XF86XK_USER_PB_ENABLED
	if (uni_stri_eq(str, "UserPB")) return OP_KEY_XF86XK_USER_PB;
#endif // OP_KEY_XF86XK_USER_PB_ENABLED
#ifdef OP_KEY_XF86XK_USER1KB_ENABLED
	if (uni_stri_eq(str, "User1KB")) return OP_KEY_XF86XK_USER1KB;
#endif // OP_KEY_XF86XK_USER1KB_ENABLED
#ifdef OP_KEY_XF86XK_USER2KB_ENABLED
	if (uni_stri_eq(str, "User2KB")) return OP_KEY_XF86XK_USER2KB;
#endif // OP_KEY_XF86XK_USER2KB_ENABLED
#ifdef OP_KEY_XF86XK_VIDEO_ENABLED
	if (uni_stri_eq(str, "Video")) return OP_KEY_XF86XK_VIDEO;
#endif // OP_KEY_XF86XK_VIDEO_ENABLED
#ifdef OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
	if (uni_stri_eq(str, "WheelButton")) return OP_KEY_XF86XK_WHEEL_BUTTON;
#endif // OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
#ifdef OP_KEY_XF86XK_WORD_ENABLED
	if (uni_stri_eq(str, "Word")) return OP_KEY_XF86XK_WORD;
#endif // OP_KEY_XF86XK_WORD_ENABLED
#ifdef OP_KEY_XF86XK_XFER_ENABLED
	if (uni_stri_eq(str, "Xfer")) return OP_KEY_XF86XK_XFER;
#endif // OP_KEY_XF86XK_XFER_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_IN_ENABLED
	if (uni_stri_eq(str, "ZoomIn")) return OP_KEY_XF86XK_ZOOM_IN;
#endif // OP_KEY_XF86XK_ZOOM_IN_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_OUT_ENABLED
	if (uni_stri_eq(str, "ZoomOut")) return OP_KEY_XF86XK_ZOOM_OUT;
#endif // OP_KEY_XF86XK_ZOOM_OUT_ENABLED
#ifdef OP_KEY_XF86XK_AWAY_ENABLED
	if (uni_stri_eq(str, "Away")) return OP_KEY_XF86XK_AWAY;
#endif // OP_KEY_XF86XK_AWAY_ENABLED
#ifdef OP_KEY_XF86XK_MESSENGER_ENABLED
	if (uni_stri_eq(str, "Messenger")) return OP_KEY_XF86XK_MESSENGER;
#endif // OP_KEY_XF86XK_MESSENGER_ENABLED
#ifdef OP_KEY_XF86XK_WEB_CAM_ENABLED
	if (uni_stri_eq(str, "WebCam")) return OP_KEY_XF86XK_WEB_CAM;
#endif // OP_KEY_XF86XK_WEB_CAM_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
	if (uni_stri_eq(str, "MailForward")) return OP_KEY_XF86XK_MAIL_FORWARD;
#endif // OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_PICTURES_ENABLED
	if (uni_stri_eq(str, "Pictures")) return OP_KEY_XF86XK_PICTURES;
#endif // OP_KEY_XF86XK_PICTURES_ENABLED
#ifdef OP_KEY_XF86XK_MUSIC_ENABLED
	if (uni_stri_eq(str, "Music")) return OP_KEY_XF86XK_MUSIC;
#endif // OP_KEY_XF86XK_MUSIC_ENABLED
#ifdef OP_KEY_XF86XK_BATTERY_ENABLED
	if (uni_stri_eq(str, "Battery")) return OP_KEY_XF86XK_BATTERY;
#endif // OP_KEY_XF86XK_BATTERY_ENABLED
#ifdef OP_KEY_XF86XK_BLUETOOTH_ENABLED
	if (uni_stri_eq(str, "Bluetooth")) return OP_KEY_XF86XK_BLUETOOTH;
#endif // OP_KEY_XF86XK_BLUETOOTH_ENABLED
#ifdef OP_KEY_XF86XK_WLAN_ENABLED
	if (uni_stri_eq(str, "WLAN")) return OP_KEY_XF86XK_WLAN;
#endif // OP_KEY_XF86XK_WLAN_ENABLED
#ifdef OP_KEY_XF86XK_UWB_ENABLED
	if (uni_stri_eq(str, "UWB")) return OP_KEY_XF86XK_UWB;
#endif // OP_KEY_XF86XK_UWB_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
	if (uni_stri_eq(str, "AudioForward")) return OP_KEY_XF86XK_AUDIO_FORWARD;
#endif // OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
	if (uni_stri_eq(str, "AudioRepeat")) return OP_KEY_XF86XK_AUDIO_REPEAT;
#endif // OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
	if (uni_stri_eq(str, "AudioRandomPlay")) return OP_KEY_XF86XK_AUDIO_RANDOM_PLAY;
#endif // OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_SUBTITLE_ENABLED
	if (uni_stri_eq(str, "Subtitle")) return OP_KEY_XF86XK_SUBTITLE;
#endif // OP_KEY_XF86XK_SUBTITLE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
	if (uni_stri_eq(str, "AudioCycleTrack")) return OP_KEY_XF86XK_AUDIO_CYCLE_TRACK;
#endif // OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
#ifdef OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
	if (uni_stri_eq(str, "CycleAngle")) return OP_KEY_XF86XK_CYCLE_ANGLE;
#endif // OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_BACK_ENABLED
	if (uni_stri_eq(str, "FrameBack")) return OP_KEY_XF86XK_FRAME_BACK;
#endif // OP_KEY_XF86XK_FRAME_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
	if (uni_stri_eq(str, "FrameForward")) return OP_KEY_XF86XK_FRAME_FORWARD;
#endif // OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_TIME_ENABLED
	if (uni_stri_eq(str, "Time")) return OP_KEY_XF86XK_TIME;
#endif // OP_KEY_XF86XK_TIME_ENABLED
#ifdef OP_KEY_XF86XK_VIEW_ENABLED
	if (uni_stri_eq(str, "View")) return OP_KEY_XF86XK_VIEW;
#endif // OP_KEY_XF86XK_VIEW_ENABLED
#ifdef OP_KEY_XF86XK_TOP_MENU_ENABLED
	if (uni_stri_eq(str, "TopMenu")) return OP_KEY_XF86XK_TOP_MENU;
#endif // OP_KEY_XF86XK_TOP_MENU_ENABLED
#ifdef OP_KEY_XF86XK_RED_ENABLED
	if (uni_stri_eq(str, "Red")) return OP_KEY_XF86XK_RED;
#endif // OP_KEY_XF86XK_RED_ENABLED
#ifdef OP_KEY_XF86XK_GREEN_ENABLED
	if (uni_stri_eq(str, "Green")) return OP_KEY_XF86XK_GREEN;
#endif // OP_KEY_XF86XK_GREEN_ENABLED
#ifdef OP_KEY_XF86XK_YELLOW_ENABLED
	if (uni_stri_eq(str, "Yellow")) return OP_KEY_XF86XK_YELLOW;
#endif // OP_KEY_XF86XK_YELLOW_ENABLED
#ifdef OP_KEY_XF86XK_BLUE_ENABLED
	if (uni_stri_eq(str, "Blue")) return OP_KEY_XF86XK_BLUE;
#endif // OP_KEY_XF86XK_BLUE_ENABLED
#ifdef OP_KEY_XF86XK_SUSPEND_ENABLED
	if (uni_stri_eq(str, "Suspend")) return OP_KEY_XF86XK_SUSPEND;
#endif // OP_KEY_XF86XK_SUSPEND_ENABLED
#ifdef OP_KEY_XF86XK_HIBERNATE_ENABLED
	if (uni_stri_eq(str, "Hibernate")) return OP_KEY_XF86XK_HIBERNATE;
#endif // OP_KEY_XF86XK_HIBERNATE_ENABLED
#ifdef OP_KEY_MAC_CTRL_LEFT_ENABLED
	if (uni_stri_eq(str, "MacControlL")) return OP_KEY_MAC_CTRL_LEFT;
#endif // OP_KEY_MAC_CTRL_LEFT_ENABLED
#ifdef OP_KEY_MAC_CTRL_RIGHT_ENABLED
	if (uni_stri_eq(str, "MacControlR")) return OP_KEY_MAC_CTRL_RIGHT;
#endif // OP_KEY_MAC_CTRL_RIGHT_ENABLED
#ifdef OP_KEY_SWIPE_UP_ENABLED
	if (uni_stri_eq(str, "SwipeUp")) return OP_KEY_SWIPE_UP;
#endif // OP_KEY_SWIPE_UP_ENABLED
#ifdef OP_KEY_SWIPE_DOWN_ENABLED
	if (uni_stri_eq(str, "SwipeDown")) return OP_KEY_SWIPE_DOWN;
#endif // OP_KEY_SWIPE_DOWN_ENABLED
#ifdef OP_KEY_SWIPE_LEFT_ENABLED
	if (uni_stri_eq(str, "SwipeLeft")) return OP_KEY_SWIPE_LEFT;
#endif // OP_KEY_SWIPE_LEFT_ENABLED
#ifdef OP_KEY_SWIPE_RIGHT_ENABLED
	if (uni_stri_eq(str, "SwipeRight")) return OP_KEY_SWIPE_RIGHT;
#endif // OP_KEY_SWIPE_RIGHT_ENABLED
#ifdef OP_KEY_BACK_ENABLED
	if (uni_stri_eq(str, "BACK")) return OP_KEY_BACK;
#endif // OP_KEY_BACK_ENABLED
#ifdef OP_KEY_CONTEXT1_ENABLED
	if (uni_stri_eq(str, "CONTEXT1")) return OP_KEY_CONTEXT1;
#endif // OP_KEY_CONTEXT1_ENABLED
#ifdef OP_KEY_CONTEXT2_ENABLED
	if (uni_stri_eq(str, "CONTEXT2")) return OP_KEY_CONTEXT2;
#endif // OP_KEY_CONTEXT2_ENABLED
#ifdef OP_KEY_CONTEXT3_ENABLED
	if (uni_stri_eq(str, "CONTEXT3")) return OP_KEY_CONTEXT3;
#endif // OP_KEY_CONTEXT3_ENABLED
#ifdef OP_KEY_CONTEXT4_ENABLED
	if (uni_stri_eq(str, "CONTEXT4")) return OP_KEY_CONTEXT4;
#endif // OP_KEY_CONTEXT4_ENABLED
#ifdef OP_KEY_YES_ENABLED
	if (uni_stri_eq(str, "YES")) return OP_KEY_YES;
#endif // OP_KEY_YES_ENABLED
#ifdef OP_KEY_NO_ENABLED
	if (uni_stri_eq(str, "NO")) return OP_KEY_NO;
#endif // OP_KEY_NO_ENABLED
#ifdef OP_KEY_CALL_ENABLED
	if (uni_stri_eq(str, "CALL")) return OP_KEY_CALL;
#endif // OP_KEY_CALL_ENABLED
#ifdef OP_KEY_HANGUP_ENABLED
	if (uni_stri_eq(str, "HANGUP")) return OP_KEY_HANGUP;
#endif // OP_KEY_HANGUP_ENABLED
#ifdef OP_KEY_HK_TOGGLE_ENABLED
	if (uni_stri_eq(str, "HiraganaKatakanatoggle")) return OP_KEY_HK_TOGGLE;
#endif // OP_KEY_HK_TOGGLE_ENABLED
#ifdef OP_KEY_KATAKANA_ENABLED
	if (uni_stri_eq(str, "Katakana")) return OP_KEY_KATAKANA;
#endif // OP_KEY_KATAKANA_ENABLED
#ifdef OP_KEY_HIRAGANA_ENABLED
	if (uni_stri_eq(str, "Hiragana")) return OP_KEY_HIRAGANA;
#endif // OP_KEY_HIRAGANA_ENABLED
#ifdef OP_KEY_CHANNELDOWN_ENABLED
	if (uni_stri_eq(str, "RC_CHANNELDOWN")) return OP_KEY_CHANNELDOWN;
#endif // OP_KEY_CHANNELDOWN_ENABLED
#ifdef OP_KEY_CHANNELUP_ENABLED
	if (uni_stri_eq(str, "RC_CHANNELUP")) return OP_KEY_CHANNELUP;
#endif // OP_KEY_CHANNELUP_ENABLED
#ifdef OP_KEY_MUTE_ENABLED
	if (uni_stri_eq(str, "RC_MUTE")) return OP_KEY_MUTE;
#endif // OP_KEY_MUTE_ENABLED
#ifdef OP_KEY_RECORD_ENABLED
	if (uni_stri_eq(str, "RC_RECORD")) return OP_KEY_RECORD;
#endif // OP_KEY_RECORD_ENABLED

	return OP_KEY_FIRST;
}

/* static */ BOOL
OpKey::IsInValueSet(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_0_ENABLED
	case OP_KEY_0:
#endif // OP_KEY_0_ENABLED
#ifdef OP_KEY_1_ENABLED
	case OP_KEY_1:
#endif // OP_KEY_1_ENABLED
#ifdef OP_KEY_2_ENABLED
	case OP_KEY_2:
#endif // OP_KEY_2_ENABLED
#ifdef OP_KEY_3_ENABLED
	case OP_KEY_3:
#endif // OP_KEY_3_ENABLED
#ifdef OP_KEY_4_ENABLED
	case OP_KEY_4:
#endif // OP_KEY_4_ENABLED
#ifdef OP_KEY_5_ENABLED
	case OP_KEY_5:
#endif // OP_KEY_5_ENABLED
#ifdef OP_KEY_6_ENABLED
	case OP_KEY_6:
#endif // OP_KEY_6_ENABLED
#ifdef OP_KEY_7_ENABLED
	case OP_KEY_7:
#endif // OP_KEY_7_ENABLED
#ifdef OP_KEY_8_ENABLED
	case OP_KEY_8:
#endif // OP_KEY_8_ENABLED
#ifdef OP_KEY_9_ENABLED
	case OP_KEY_9:
#endif // OP_KEY_9_ENABLED
#ifdef OP_KEY_A_ENABLED
	case OP_KEY_A:
#endif // OP_KEY_A_ENABLED
#ifdef OP_KEY_B_ENABLED
	case OP_KEY_B:
#endif // OP_KEY_B_ENABLED
#ifdef OP_KEY_C_ENABLED
	case OP_KEY_C:
#endif // OP_KEY_C_ENABLED
#ifdef OP_KEY_D_ENABLED
	case OP_KEY_D:
#endif // OP_KEY_D_ENABLED
#ifdef OP_KEY_E_ENABLED
	case OP_KEY_E:
#endif // OP_KEY_E_ENABLED
#ifdef OP_KEY_F_ENABLED
	case OP_KEY_F:
#endif // OP_KEY_F_ENABLED
#ifdef OP_KEY_G_ENABLED
	case OP_KEY_G:
#endif // OP_KEY_G_ENABLED
#ifdef OP_KEY_H_ENABLED
	case OP_KEY_H:
#endif // OP_KEY_H_ENABLED
#ifdef OP_KEY_I_ENABLED
	case OP_KEY_I:
#endif // OP_KEY_I_ENABLED
#ifdef OP_KEY_J_ENABLED
	case OP_KEY_J:
#endif // OP_KEY_J_ENABLED
#ifdef OP_KEY_K_ENABLED
	case OP_KEY_K:
#endif // OP_KEY_K_ENABLED
#ifdef OP_KEY_L_ENABLED
	case OP_KEY_L:
#endif // OP_KEY_L_ENABLED
#ifdef OP_KEY_M_ENABLED
	case OP_KEY_M:
#endif // OP_KEY_M_ENABLED
#ifdef OP_KEY_N_ENABLED
	case OP_KEY_N:
#endif // OP_KEY_N_ENABLED
#ifdef OP_KEY_O_ENABLED
	case OP_KEY_O:
#endif // OP_KEY_O_ENABLED
#ifdef OP_KEY_P_ENABLED
	case OP_KEY_P:
#endif // OP_KEY_P_ENABLED
#ifdef OP_KEY_Q_ENABLED
	case OP_KEY_Q:
#endif // OP_KEY_Q_ENABLED
#ifdef OP_KEY_R_ENABLED
	case OP_KEY_R:
#endif // OP_KEY_R_ENABLED
#ifdef OP_KEY_S_ENABLED
	case OP_KEY_S:
#endif // OP_KEY_S_ENABLED
#ifdef OP_KEY_T_ENABLED
	case OP_KEY_T:
#endif // OP_KEY_T_ENABLED
#ifdef OP_KEY_U_ENABLED
	case OP_KEY_U:
#endif // OP_KEY_U_ENABLED
#ifdef OP_KEY_V_ENABLED
	case OP_KEY_V:
#endif // OP_KEY_V_ENABLED
#ifdef OP_KEY_W_ENABLED
	case OP_KEY_W:
#endif // OP_KEY_W_ENABLED
#ifdef OP_KEY_X_ENABLED
	case OP_KEY_X:
#endif // OP_KEY_X_ENABLED
#ifdef OP_KEY_Y_ENABLED
	case OP_KEY_Y:
#endif // OP_KEY_Y_ENABLED
#ifdef OP_KEY_Z_ENABLED
	case OP_KEY_Z:
#endif // OP_KEY_Z_ENABLED
#ifdef OP_KEY_NUMPAD0_ENABLED
	case OP_KEY_NUMPAD0:
#endif // OP_KEY_NUMPAD0_ENABLED
#ifdef OP_KEY_NUMPAD1_ENABLED
	case OP_KEY_NUMPAD1:
#endif // OP_KEY_NUMPAD1_ENABLED
#ifdef OP_KEY_NUMPAD2_ENABLED
	case OP_KEY_NUMPAD2:
#endif // OP_KEY_NUMPAD2_ENABLED
#ifdef OP_KEY_NUMPAD3_ENABLED
	case OP_KEY_NUMPAD3:
#endif // OP_KEY_NUMPAD3_ENABLED
#ifdef OP_KEY_NUMPAD4_ENABLED
	case OP_KEY_NUMPAD4:
#endif // OP_KEY_NUMPAD4_ENABLED
#ifdef OP_KEY_NUMPAD5_ENABLED
	case OP_KEY_NUMPAD5:
#endif // OP_KEY_NUMPAD5_ENABLED
#ifdef OP_KEY_NUMPAD6_ENABLED
	case OP_KEY_NUMPAD6:
#endif // OP_KEY_NUMPAD6_ENABLED
#ifdef OP_KEY_NUMPAD7_ENABLED
	case OP_KEY_NUMPAD7:
#endif // OP_KEY_NUMPAD7_ENABLED
#ifdef OP_KEY_NUMPAD8_ENABLED
	case OP_KEY_NUMPAD8:
#endif // OP_KEY_NUMPAD8_ENABLED
#ifdef OP_KEY_NUMPAD9_ENABLED
	case OP_KEY_NUMPAD9:
#endif // OP_KEY_NUMPAD9_ENABLED
#ifdef OP_KEY_OEM_1_ENABLED
	case OP_KEY_OEM_1:
#endif // OP_KEY_OEM_1_ENABLED
#ifdef OP_KEY_OEM_PLUS_ENABLED
	case OP_KEY_OEM_PLUS:
#endif // OP_KEY_OEM_PLUS_ENABLED
#ifdef OP_KEY_OEM_COMMA_ENABLED
	case OP_KEY_OEM_COMMA:
#endif // OP_KEY_OEM_COMMA_ENABLED
#ifdef OP_KEY_OEM_MINUS_ENABLED
	case OP_KEY_OEM_MINUS:
#endif // OP_KEY_OEM_MINUS_ENABLED
#ifdef OP_KEY_OEM_PERIOD_ENABLED
	case OP_KEY_OEM_PERIOD:
#endif // OP_KEY_OEM_PERIOD_ENABLED
#ifdef OP_KEY_OEM_2_ENABLED
	case OP_KEY_OEM_2:
#endif // OP_KEY_OEM_2_ENABLED
#ifdef OP_KEY_OEM_3_ENABLED
	case OP_KEY_OEM_3:
#endif // OP_KEY_OEM_3_ENABLED
#ifdef OP_KEY_OEM_4_ENABLED
	case OP_KEY_OEM_4:
#endif // OP_KEY_OEM_4_ENABLED
#ifdef OP_KEY_OEM_5_ENABLED
	case OP_KEY_OEM_5:
#endif // OP_KEY_OEM_5_ENABLED
#ifdef OP_KEY_OEM_6_ENABLED
	case OP_KEY_OEM_6:
#endif // OP_KEY_OEM_6_ENABLED
#ifdef OP_KEY_OEM_7_ENABLED
	case OP_KEY_OEM_7:
#endif // OP_KEY_OEM_7_ENABLED
#ifdef OP_KEY_OEM_8_ENABLED
	case OP_KEY_OEM_8:
#endif // OP_KEY_OEM_8_ENABLED
#ifdef OP_KEY_OEM_102_ENABLED
	case OP_KEY_OEM_102:
#endif // OP_KEY_OEM_102_ENABLED
#ifdef OP_KEY_PROCESSKEY_ENABLED
	case OP_KEY_PROCESSKEY:
#endif // OP_KEY_PROCESSKEY_ENABLED
#ifdef OP_KEY_UNICODE_ENABLED
	case OP_KEY_UNICODE:
#endif // OP_KEY_UNICODE_ENABLED
		return FALSE;
	default:
		return TRUE;
	}
}

/* static */ uni_char
OpKey::CharValue(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_TAB_ENABLED
	case OP_KEY_TAB: return 0x09;
#endif // OP_KEY_TAB_ENABLED
#ifdef OP_KEY_ESCAPE_ENABLED
	case OP_KEY_ESCAPE: return 0x1b;
#endif // OP_KEY_ESCAPE_ENABLED
#ifdef OP_KEY_SPACE_ENABLED
	case OP_KEY_SPACE: return 0x20;
#endif // OP_KEY_SPACE_ENABLED
#ifdef OP_KEY_NUMPAD0_ENABLED
	case OP_KEY_NUMPAD0: return 0x30;
#endif // OP_KEY_NUMPAD0_ENABLED
#ifdef OP_KEY_NUMPAD1_ENABLED
	case OP_KEY_NUMPAD1: return 0x31;
#endif // OP_KEY_NUMPAD1_ENABLED
#ifdef OP_KEY_NUMPAD2_ENABLED
	case OP_KEY_NUMPAD2: return 0x32;
#endif // OP_KEY_NUMPAD2_ENABLED
#ifdef OP_KEY_NUMPAD3_ENABLED
	case OP_KEY_NUMPAD3: return 0x33;
#endif // OP_KEY_NUMPAD3_ENABLED
#ifdef OP_KEY_NUMPAD4_ENABLED
	case OP_KEY_NUMPAD4: return 0x34;
#endif // OP_KEY_NUMPAD4_ENABLED
#ifdef OP_KEY_NUMPAD5_ENABLED
	case OP_KEY_NUMPAD5: return 0x35;
#endif // OP_KEY_NUMPAD5_ENABLED
#ifdef OP_KEY_NUMPAD6_ENABLED
	case OP_KEY_NUMPAD6: return 0x36;
#endif // OP_KEY_NUMPAD6_ENABLED
#ifdef OP_KEY_NUMPAD7_ENABLED
	case OP_KEY_NUMPAD7: return 0x37;
#endif // OP_KEY_NUMPAD7_ENABLED
#ifdef OP_KEY_NUMPAD8_ENABLED
	case OP_KEY_NUMPAD8: return 0x38;
#endif // OP_KEY_NUMPAD8_ENABLED
#ifdef OP_KEY_NUMPAD9_ENABLED
	case OP_KEY_NUMPAD9: return 0x39;
#endif // OP_KEY_NUMPAD9_ENABLED
#ifdef OP_KEY_ADD_ENABLED
	case OP_KEY_ADD: return 0x2b;
#endif // OP_KEY_ADD_ENABLED
#ifdef OP_KEY_SUBTRACT_ENABLED
	case OP_KEY_SUBTRACT: return 0x2d;
#endif // OP_KEY_SUBTRACT_ENABLED
#ifdef OP_KEY_DECIMAL_ENABLED
	case OP_KEY_DECIMAL: return 0x2e;
#endif // OP_KEY_DECIMAL_ENABLED
#ifdef OP_KEY_DIVIDE_ENABLED
	case OP_KEY_DIVIDE: return 0x2f;
#endif // OP_KEY_DIVIDE_ENABLED
	}
	return 0;
}

/* static */ BOOL
OpKey::IsModifier(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_SHIFT_ENABLED
	case OP_KEY_SHIFT:
#endif // OP_KEY_SHIFT_ENABLED
#ifdef OP_KEY_CTRL_ENABLED
	case OP_KEY_CTRL:
#endif // OP_KEY_CTRL_ENABLED
#ifdef OP_KEY_ALT_ENABLED
	case OP_KEY_ALT:
#endif // OP_KEY_ALT_ENABLED
#ifdef OP_KEY_META_ENABLED
	case OP_KEY_META:
#endif // OP_KEY_META_ENABLED
#ifdef OP_KEY_BACK_ENABLED
	case OP_KEY_BACK:
#endif // OP_KEY_BACK_ENABLED
#ifdef OP_KEY_CONTEXT1_ENABLED
	case OP_KEY_CONTEXT1:
#endif // OP_KEY_CONTEXT1_ENABLED
#ifdef OP_KEY_CONTEXT2_ENABLED
	case OP_KEY_CONTEXT2:
#endif // OP_KEY_CONTEXT2_ENABLED
#ifdef OP_KEY_CONTEXT3_ENABLED
	case OP_KEY_CONTEXT3:
#endif // OP_KEY_CONTEXT3_ENABLED
#ifdef OP_KEY_CONTEXT4_ENABLED
	case OP_KEY_CONTEXT4:
#endif // OP_KEY_CONTEXT4_ENABLED
#ifdef OP_KEY_YES_ENABLED
	case OP_KEY_YES:
#endif // OP_KEY_YES_ENABLED
#ifdef OP_KEY_NO_ENABLED
	case OP_KEY_NO:
#endif // OP_KEY_NO_ENABLED
#ifdef OP_KEY_CALL_ENABLED
	case OP_KEY_CALL:
#endif // OP_KEY_CALL_ENABLED
#ifdef OP_KEY_HANGUP_ENABLED
	case OP_KEY_HANGUP:
#endif // OP_KEY_HANGUP_ENABLED
#ifdef OP_KEY_CHANNELDOWN_ENABLED
	case OP_KEY_CHANNELDOWN:
#endif // OP_KEY_CHANNELDOWN_ENABLED
#ifdef OP_KEY_CHANNELUP_ENABLED
	case OP_KEY_CHANNELUP:
#endif // OP_KEY_CHANNELUP_ENABLED
#ifdef OP_KEY_MUTE_ENABLED
	case OP_KEY_MUTE:
#endif // OP_KEY_MUTE_ENABLED
#ifdef OP_KEY_RECORD_ENABLED
	case OP_KEY_RECORD:
#endif // OP_KEY_RECORD_ENABLED
		return TRUE;

	default:
		return FALSE;
	}
}

/* static */ BOOL
OpKey::IsFunctionKey(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_CANCEL_ENABLED
	case OP_KEY_CANCEL:
#endif // OP_KEY_CANCEL_ENABLED
#ifdef OP_KEY_BACKSPACE_ENABLED
	case OP_KEY_BACKSPACE:
#endif // OP_KEY_BACKSPACE_ENABLED
#ifdef OP_KEY_CLEAR_ENABLED
	case OP_KEY_CLEAR:
#endif // OP_KEY_CLEAR_ENABLED
#ifdef OP_KEY_PAUSE_ENABLED
	case OP_KEY_PAUSE:
#endif // OP_KEY_PAUSE_ENABLED
#ifdef OP_KEY_CAPS_LOCK_ENABLED
	case OP_KEY_CAPS_LOCK:
#endif // OP_KEY_CAPS_LOCK_ENABLED
#ifdef OP_KEY_KANA_ENABLED
	case OP_KEY_KANA:
#endif // OP_KEY_KANA_ENABLED
#ifdef OP_KEY_FINAL_ENABLED
	case OP_KEY_FINAL:
#endif // OP_KEY_FINAL_ENABLED
#ifdef OP_KEY_KANJI_ENABLED
	case OP_KEY_KANJI:
#endif // OP_KEY_KANJI_ENABLED
#ifdef OP_KEY_CONVERT_ENABLED
	case OP_KEY_CONVERT:
#endif // OP_KEY_CONVERT_ENABLED
#ifdef OP_KEY_NONCONVERT_ENABLED
	case OP_KEY_NONCONVERT:
#endif // OP_KEY_NONCONVERT_ENABLED
#ifdef OP_KEY_ACCEPT_ENABLED
	case OP_KEY_ACCEPT:
#endif // OP_KEY_ACCEPT_ENABLED
#ifdef OP_KEY_MODECHANGE_ENABLED
	case OP_KEY_MODECHANGE:
#endif // OP_KEY_MODECHANGE_ENABLED
#ifdef OP_KEY_PAGEUP_ENABLED
	case OP_KEY_PAGEUP:
#endif // OP_KEY_PAGEUP_ENABLED
#ifdef OP_KEY_PAGEDOWN_ENABLED
	case OP_KEY_PAGEDOWN:
#endif // OP_KEY_PAGEDOWN_ENABLED
#ifdef OP_KEY_END_ENABLED
	case OP_KEY_END:
#endif // OP_KEY_END_ENABLED
#ifdef OP_KEY_HOME_ENABLED
	case OP_KEY_HOME:
#endif // OP_KEY_HOME_ENABLED
#ifdef OP_KEY_LEFT_ENABLED
	case OP_KEY_LEFT:
#endif // OP_KEY_LEFT_ENABLED
#ifdef OP_KEY_UP_ENABLED
	case OP_KEY_UP:
#endif // OP_KEY_UP_ENABLED
#ifdef OP_KEY_RIGHT_ENABLED
	case OP_KEY_RIGHT:
#endif // OP_KEY_RIGHT_ENABLED
#ifdef OP_KEY_DOWN_ENABLED
	case OP_KEY_DOWN:
#endif // OP_KEY_DOWN_ENABLED
#ifdef OP_KEY_SELECT_ENABLED
	case OP_KEY_SELECT:
#endif // OP_KEY_SELECT_ENABLED
#ifdef OP_KEY_PRINT_ENABLED
	case OP_KEY_PRINT:
#endif // OP_KEY_PRINT_ENABLED
#ifdef OP_KEY_EXECUTE_ENABLED
	case OP_KEY_EXECUTE:
#endif // OP_KEY_EXECUTE_ENABLED
#ifdef OP_KEY_PRINTSCREEN_ENABLED
	case OP_KEY_PRINTSCREEN:
#endif // OP_KEY_PRINTSCREEN_ENABLED
#ifdef OP_KEY_INSERT_ENABLED
	case OP_KEY_INSERT:
#endif // OP_KEY_INSERT_ENABLED
#ifdef OP_KEY_DELETE_ENABLED
	case OP_KEY_DELETE:
#endif // OP_KEY_DELETE_ENABLED
#ifdef OP_KEY_HELP_ENABLED
	case OP_KEY_HELP:
#endif // OP_KEY_HELP_ENABLED
#ifdef OP_KEY_WINDOW_ENABLED
	case OP_KEY_WINDOW:
#endif // OP_KEY_WINDOW_ENABLED
#ifdef OP_KEY_MAC_CTRL_ENABLED
	case OP_KEY_MAC_CTRL:
#endif // OP_KEY_MAC_CTRL_ENABLED
#ifdef OP_KEY_CONTEXT_MENU_ENABLED
	case OP_KEY_CONTEXT_MENU:
#endif // OP_KEY_CONTEXT_MENU_ENABLED
#ifdef OP_KEY_SLEEP_ENABLED
	case OP_KEY_SLEEP:
#endif // OP_KEY_SLEEP_ENABLED
#ifdef OP_KEY_F1_ENABLED
	case OP_KEY_F1:
#endif // OP_KEY_F1_ENABLED
#ifdef OP_KEY_F2_ENABLED
	case OP_KEY_F2:
#endif // OP_KEY_F2_ENABLED
#ifdef OP_KEY_F3_ENABLED
	case OP_KEY_F3:
#endif // OP_KEY_F3_ENABLED
#ifdef OP_KEY_F4_ENABLED
	case OP_KEY_F4:
#endif // OP_KEY_F4_ENABLED
#ifdef OP_KEY_F5_ENABLED
	case OP_KEY_F5:
#endif // OP_KEY_F5_ENABLED
#ifdef OP_KEY_F6_ENABLED
	case OP_KEY_F6:
#endif // OP_KEY_F6_ENABLED
#ifdef OP_KEY_F7_ENABLED
	case OP_KEY_F7:
#endif // OP_KEY_F7_ENABLED
#ifdef OP_KEY_F8_ENABLED
	case OP_KEY_F8:
#endif // OP_KEY_F8_ENABLED
#ifdef OP_KEY_F9_ENABLED
	case OP_KEY_F9:
#endif // OP_KEY_F9_ENABLED
#ifdef OP_KEY_F10_ENABLED
	case OP_KEY_F10:
#endif // OP_KEY_F10_ENABLED
#ifdef OP_KEY_F11_ENABLED
	case OP_KEY_F11:
#endif // OP_KEY_F11_ENABLED
#ifdef OP_KEY_F12_ENABLED
	case OP_KEY_F12:
#endif // OP_KEY_F12_ENABLED
#ifdef OP_KEY_F13_ENABLED
	case OP_KEY_F13:
#endif // OP_KEY_F13_ENABLED
#ifdef OP_KEY_F14_ENABLED
	case OP_KEY_F14:
#endif // OP_KEY_F14_ENABLED
#ifdef OP_KEY_F15_ENABLED
	case OP_KEY_F15:
#endif // OP_KEY_F15_ENABLED
#ifdef OP_KEY_F16_ENABLED
	case OP_KEY_F16:
#endif // OP_KEY_F16_ENABLED
#ifdef OP_KEY_F17_ENABLED
	case OP_KEY_F17:
#endif // OP_KEY_F17_ENABLED
#ifdef OP_KEY_F18_ENABLED
	case OP_KEY_F18:
#endif // OP_KEY_F18_ENABLED
#ifdef OP_KEY_F19_ENABLED
	case OP_KEY_F19:
#endif // OP_KEY_F19_ENABLED
#ifdef OP_KEY_F20_ENABLED
	case OP_KEY_F20:
#endif // OP_KEY_F20_ENABLED
#ifdef OP_KEY_F21_ENABLED
	case OP_KEY_F21:
#endif // OP_KEY_F21_ENABLED
#ifdef OP_KEY_F22_ENABLED
	case OP_KEY_F22:
#endif // OP_KEY_F22_ENABLED
#ifdef OP_KEY_F23_ENABLED
	case OP_KEY_F23:
#endif // OP_KEY_F23_ENABLED
#ifdef OP_KEY_F24_ENABLED
	case OP_KEY_F24:
#endif // OP_KEY_F24_ENABLED
#ifdef OP_KEY_NUM_LOCK_ENABLED
	case OP_KEY_NUM_LOCK:
#endif // OP_KEY_NUM_LOCK_ENABLED
#ifdef OP_KEY_SCROLL_LOCK_ENABLED
	case OP_KEY_SCROLL_LOCK:
#endif // OP_KEY_SCROLL_LOCK_ENABLED
#ifdef OP_KEY_PROCESSKEY_ENABLED
	case OP_KEY_PROCESSKEY:
#endif // OP_KEY_PROCESSKEY_ENABLED
#ifdef OP_KEY_F25_ENABLED
	case OP_KEY_F25:
#endif // OP_KEY_F25_ENABLED
#ifdef OP_KEY_F26_ENABLED
	case OP_KEY_F26:
#endif // OP_KEY_F26_ENABLED
#ifdef OP_KEY_F27_ENABLED
	case OP_KEY_F27:
#endif // OP_KEY_F27_ENABLED
#ifdef OP_KEY_F28_ENABLED
	case OP_KEY_F28:
#endif // OP_KEY_F28_ENABLED
#ifdef OP_KEY_F29_ENABLED
	case OP_KEY_F29:
#endif // OP_KEY_F29_ENABLED
#ifdef OP_KEY_F30_ENABLED
	case OP_KEY_F30:
#endif // OP_KEY_F30_ENABLED
#ifdef OP_KEY_F31_ENABLED
	case OP_KEY_F31:
#endif // OP_KEY_F31_ENABLED
#ifdef OP_KEY_F32_ENABLED
	case OP_KEY_F32:
#endif // OP_KEY_F32_ENABLED
#ifdef OP_KEY_F33_ENABLED
	case OP_KEY_F33:
#endif // OP_KEY_F33_ENABLED
#ifdef OP_KEY_F34_ENABLED
	case OP_KEY_F34:
#endif // OP_KEY_F34_ENABLED
#ifdef OP_KEY_F35_ENABLED
	case OP_KEY_F35:
#endif // OP_KEY_F35_ENABLED
#ifdef OP_KEY_F36_ENABLED
	case OP_KEY_F36:
#endif // OP_KEY_F36_ENABLED
#ifdef OP_KEY_VOLUMEUP_ENABLED
	case OP_KEY_VOLUMEUP:
#endif // OP_KEY_VOLUMEUP_ENABLED
#ifdef OP_KEY_VOLUMEDOWN_ENABLED
	case OP_KEY_VOLUMEDOWN:
#endif // OP_KEY_VOLUMEDOWN_ENABLED
#ifdef OP_KEY_MENU_ENABLED
	case OP_KEY_MENU:
#endif // OP_KEY_MENU_ENABLED
#ifdef OP_KEY_PLAY_ENABLED
	case OP_KEY_PLAY:
#endif // OP_KEY_PLAY_ENABLED
#ifdef OP_KEY_NEXT_ENABLED
	case OP_KEY_NEXT:
#endif // OP_KEY_NEXT_ENABLED
#ifdef OP_KEY_PREVIOUS_ENABLED
	case OP_KEY_PREVIOUS:
#endif // OP_KEY_PREVIOUS_ENABLED
#ifdef OP_KEY_FASTFORWARD_ENABLED
	case OP_KEY_FASTFORWARD:
#endif // OP_KEY_FASTFORWARD_ENABLED
#ifdef OP_KEY_REWIND_ENABLED
	case OP_KEY_REWIND:
#endif // OP_KEY_REWIND_ENABLED
#ifdef OP_KEY_STOP_ENABLED
	case OP_KEY_STOP:
#endif // OP_KEY_STOP_ENABLED
#ifdef OP_KEY_REDO_ENABLED
	case OP_KEY_REDO:
#endif // OP_KEY_REDO_ENABLED
#ifdef OP_KEY_UNDO_ENABLED
	case OP_KEY_UNDO:
#endif // OP_KEY_UNDO_ENABLED
#ifdef OP_KEY_PROPERITES_ENABLED
	case OP_KEY_PROPERITES:
#endif // OP_KEY_PROPERITES_ENABLED
#ifdef OP_KEY_FRONT_ENABLED
	case OP_KEY_FRONT:
#endif // OP_KEY_FRONT_ENABLED
#ifdef OP_KEY_LEFT_TAB_ENABLED
	case OP_KEY_LEFT_TAB:
#endif // OP_KEY_LEFT_TAB_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
	case OP_KEY_XF86XK_MON_BRIGHTNESS_UP:
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
	case OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN:
#endif // OP_KEY_XF86XK_MON_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
	case OP_KEY_XF86XK_KBD_LIGHT_ON_OFF:
#endif // OP_KEY_XF86XK_KBD_LIGHT_ON_OFF_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
	case OP_KEY_XF86XK_KBD_BRIGHTNESS_UP:
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_UP_ENABLED
#ifdef OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
	case OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN:
#endif // OP_KEY_XF86XK_KBD_BRIGHTNESS_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_STANDBY_ENABLED
	case OP_KEY_XF86XK_STANDBY:
#endif // OP_KEY_XF86XK_STANDBY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
	case OP_KEY_XF86XK_AUDIO_LOWER_VOLUME:
#endif // OP_KEY_XF86XK_AUDIO_LOWER_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
	case OP_KEY_XF86XK_AUDIO_MUTE:
#endif // OP_KEY_XF86XK_AUDIO_MUTE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
	case OP_KEY_XF86XK_AUDIO_RAISE_VOLUME:
#endif // OP_KEY_XF86XK_AUDIO_RAISE_VOLUME_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
	case OP_KEY_XF86XK_AUDIO_PLAY:
#endif // OP_KEY_XF86XK_AUDIO_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_STOP_ENABLED
	case OP_KEY_XF86XK_AUDIO_STOP:
#endif // OP_KEY_XF86XK_AUDIO_STOP_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PREV_ENABLED
	case OP_KEY_XF86XK_AUDIO_PREV:
#endif // OP_KEY_XF86XK_AUDIO_PREV_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
	case OP_KEY_XF86XK_AUDIO_NEXT:
#endif // OP_KEY_XF86XK_AUDIO_NEXT_ENABLED
#ifdef OP_KEY_XF86XK_HOME_PAGE_ENABLED
	case OP_KEY_XF86XK_HOME_PAGE:
#endif // OP_KEY_XF86XK_HOME_PAGE_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_ENABLED
	case OP_KEY_XF86XK_MAIL:
#endif // OP_KEY_XF86XK_MAIL_ENABLED
#ifdef OP_KEY_XF86XK_START_ENABLED
	case OP_KEY_XF86XK_START:
#endif // OP_KEY_XF86XK_START_ENABLED
#ifdef OP_KEY_XF86XK_SEARCH_ENABLED
	case OP_KEY_XF86XK_SEARCH:
#endif // OP_KEY_XF86XK_SEARCH_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
	case OP_KEY_XF86XK_AUDIO_RECORD:
#endif // OP_KEY_XF86XK_AUDIO_RECORD_ENABLED
#ifdef OP_KEY_XF86XK_CALCULATOR_ENABLED
	case OP_KEY_XF86XK_CALCULATOR:
#endif // OP_KEY_XF86XK_CALCULATOR_ENABLED
#ifdef OP_KEY_XF86XK_MEMO_ENABLED
	case OP_KEY_XF86XK_MEMO:
#endif // OP_KEY_XF86XK_MEMO_ENABLED
#ifdef OP_KEY_XF86XK_TO_DO_LIST_ENABLED
	case OP_KEY_XF86XK_TO_DO_LIST:
#endif // OP_KEY_XF86XK_TO_DO_LIST_ENABLED
#ifdef OP_KEY_XF86XK_CALENDAR_ENABLED
	case OP_KEY_XF86XK_CALENDAR:
#endif // OP_KEY_XF86XK_CALENDAR_ENABLED
#ifdef OP_KEY_XF86XK_POWER_DOWN_ENABLED
	case OP_KEY_XF86XK_POWER_DOWN:
#endif // OP_KEY_XF86XK_POWER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
	case OP_KEY_XF86XK_CONTRAST_ADJUST:
#endif // OP_KEY_XF86XK_CONTRAST_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_UP_ENABLED
	case OP_KEY_XF86XK_ROCKER_UP:
#endif // OP_KEY_XF86XK_ROCKER_UP_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
	case OP_KEY_XF86XK_ROCKER_DOWN:
#endif // OP_KEY_XF86XK_ROCKER_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
	case OP_KEY_XF86XK_ROCKER_ENTER:
#endif // OP_KEY_XF86XK_ROCKER_ENTER_ENABLED
#ifdef OP_KEY_XF86XK_BACK_ENABLED
	case OP_KEY_XF86XK_BACK:
#endif // OP_KEY_XF86XK_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FORWARD_ENABLED
	case OP_KEY_XF86XK_FORWARD:
#endif // OP_KEY_XF86XK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_STOP_ENABLED
	case OP_KEY_XF86XK_STOP:
#endif // OP_KEY_XF86XK_STOP_ENABLED
#ifdef OP_KEY_XF86XK_REFRESH_ENABLED
	case OP_KEY_XF86XK_REFRESH:
#endif // OP_KEY_XF86XK_REFRESH_ENABLED
#ifdef OP_KEY_XF86XK_POWER_OFF_ENABLED
	case OP_KEY_XF86XK_POWER_OFF:
#endif // OP_KEY_XF86XK_POWER_OFF_ENABLED
#ifdef OP_KEY_XF86XK_WAKE_UP_ENABLED
	case OP_KEY_XF86XK_WAKE_UP:
#endif // OP_KEY_XF86XK_WAKE_UP_ENABLED
#ifdef OP_KEY_XF86XK_EJECT_ENABLED
	case OP_KEY_XF86XK_EJECT:
#endif // OP_KEY_XF86XK_EJECT_ENABLED
#ifdef OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
	case OP_KEY_XF86XK_SCREEN_SAVER:
#endif // OP_KEY_XF86XK_SCREEN_SAVER_ENABLED
#ifdef OP_KEY_XF86XK_WWW_ENABLED
	case OP_KEY_XF86XK_WWW:
#endif // OP_KEY_XF86XK_WWW_ENABLED
#ifdef OP_KEY_XF86XK_FAVORITES_ENABLED
	case OP_KEY_XF86XK_FAVORITES:
#endif // OP_KEY_XF86XK_FAVORITES_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
	case OP_KEY_XF86XK_AUDIO_PAUSE:
#endif // OP_KEY_XF86XK_AUDIO_PAUSE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
	case OP_KEY_XF86XK_AUDIO_MEDIA:
#endif // OP_KEY_XF86XK_AUDIO_MEDIA_ENABLED
#ifdef OP_KEY_XF86XK_MY_COMPUTER_ENABLED
	case OP_KEY_XF86XK_MY_COMPUTER:
#endif // OP_KEY_XF86XK_MY_COMPUTER_ENABLED
#ifdef OP_KEY_XF86XK_VENDOR_HOME_ENABLED
	case OP_KEY_XF86XK_VENDOR_HOME:
#endif // OP_KEY_XF86XK_VENDOR_HOME_ENABLED
#ifdef OP_KEY_XF86XK_LIGHT_BULB_ENABLED
	case OP_KEY_XF86XK_LIGHT_BULB:
#endif // OP_KEY_XF86XK_LIGHT_BULB_ENABLED
#ifdef OP_KEY_XF86XK_SHOP_ENABLED
	case OP_KEY_XF86XK_SHOP:
#endif // OP_KEY_XF86XK_SHOP_ENABLED
#ifdef OP_KEY_XF86XK_HISTORY_ENABLED
	case OP_KEY_XF86XK_HISTORY:
#endif // OP_KEY_XF86XK_HISTORY_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_URL_ENABLED
	case OP_KEY_XF86XK_OPEN_URL:
#endif // OP_KEY_XF86XK_OPEN_URL_ENABLED
#ifdef OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
	case OP_KEY_XF86XK_ADD_FAVORITE:
#endif // OP_KEY_XF86XK_ADD_FAVORITE_ENABLED
#ifdef OP_KEY_XF86XK_HOT_LINKS_ENABLED
	case OP_KEY_XF86XK_HOT_LINKS:
#endif // OP_KEY_XF86XK_HOT_LINKS_ENABLED
#ifdef OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
	case OP_KEY_XF86XK_BRIGHTNESS_ADJUST:
#endif // OP_KEY_XF86XK_BRIGHTNESS_ADJUST_ENABLED
#ifdef OP_KEY_XF86XK_FINANCE_ENABLED
	case OP_KEY_XF86XK_FINANCE:
#endif // OP_KEY_XF86XK_FINANCE_ENABLED
#ifdef OP_KEY_XF86XK_COMMUNITY_ENABLED
	case OP_KEY_XF86XK_COMMUNITY:
#endif // OP_KEY_XF86XK_COMMUNITY_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
	case OP_KEY_XF86XK_AUDIO_REWIND:
#endif // OP_KEY_XF86XK_AUDIO_REWIND_ENABLED
#ifdef OP_KEY_XF86XK_BACK_FORWARD_ENABLED
	case OP_KEY_XF86XK_BACK_FORWARD:
#endif // OP_KEY_XF86XK_BACK_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH0_ENABLED
	case OP_KEY_XF86XK_LAUNCH0:
#endif // OP_KEY_XF86XK_LAUNCH0_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH1_ENABLED
	case OP_KEY_XF86XK_LAUNCH1:
#endif // OP_KEY_XF86XK_LAUNCH1_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH2_ENABLED
	case OP_KEY_XF86XK_LAUNCH2:
#endif // OP_KEY_XF86XK_LAUNCH2_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH3_ENABLED
	case OP_KEY_XF86XK_LAUNCH3:
#endif // OP_KEY_XF86XK_LAUNCH3_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH4_ENABLED
	case OP_KEY_XF86XK_LAUNCH4:
#endif // OP_KEY_XF86XK_LAUNCH4_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH5_ENABLED
	case OP_KEY_XF86XK_LAUNCH5:
#endif // OP_KEY_XF86XK_LAUNCH5_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH6_ENABLED
	case OP_KEY_XF86XK_LAUNCH6:
#endif // OP_KEY_XF86XK_LAUNCH6_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH7_ENABLED
	case OP_KEY_XF86XK_LAUNCH7:
#endif // OP_KEY_XF86XK_LAUNCH7_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH8_ENABLED
	case OP_KEY_XF86XK_LAUNCH8:
#endif // OP_KEY_XF86XK_LAUNCH8_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH9_ENABLED
	case OP_KEY_XF86XK_LAUNCH9:
#endif // OP_KEY_XF86XK_LAUNCH9_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_A_ENABLED
	case OP_KEY_XF86XK_LAUNCH_A:
#endif // OP_KEY_XF86XK_LAUNCH_A_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_B_ENABLED
	case OP_KEY_XF86XK_LAUNCH_B:
#endif // OP_KEY_XF86XK_LAUNCH_B_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_C_ENABLED
	case OP_KEY_XF86XK_LAUNCH_C:
#endif // OP_KEY_XF86XK_LAUNCH_C_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_D_ENABLED
	case OP_KEY_XF86XK_LAUNCH_D:
#endif // OP_KEY_XF86XK_LAUNCH_D_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_E_ENABLED
	case OP_KEY_XF86XK_LAUNCH_E:
#endif // OP_KEY_XF86XK_LAUNCH_E_ENABLED
#ifdef OP_KEY_XF86XK_LAUNCH_F_ENABLED
	case OP_KEY_XF86XK_LAUNCH_F:
#endif // OP_KEY_XF86XK_LAUNCH_F_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
	case OP_KEY_XF86XK_APPLICATION_LEFT:
#endif // OP_KEY_XF86XK_APPLICATION_LEFT_ENABLED
#ifdef OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
	case OP_KEY_XF86XK_APPLICATION_RIGHT:
#endif // OP_KEY_XF86XK_APPLICATION_RIGHT_ENABLED
#ifdef OP_KEY_XF86XK_BOOK_ENABLED
	case OP_KEY_XF86XK_BOOK:
#endif // OP_KEY_XF86XK_BOOK_ENABLED
#ifdef OP_KEY_XF86XK_CD_ENABLED
	case OP_KEY_XF86XK_CD:
#endif // OP_KEY_XF86XK_CD_ENABLED
#ifdef OP_KEY_XF86XK_CLOSE_ENABLED
	case OP_KEY_XF86XK_CLOSE:
#endif // OP_KEY_XF86XK_CLOSE_ENABLED
#ifdef OP_KEY_XF86XK_COPY_ENABLED
	case OP_KEY_XF86XK_COPY:
#endif // OP_KEY_XF86XK_COPY_ENABLED
#ifdef OP_KEY_XF86XK_CUT_ENABLED
	case OP_KEY_XF86XK_CUT:
#endif // OP_KEY_XF86XK_CUT_ENABLED
#ifdef OP_KEY_XF86XK_DISPLAY_ENABLED
	case OP_KEY_XF86XK_DISPLAY:
#endif // OP_KEY_XF86XK_DISPLAY_ENABLED
#ifdef OP_KEY_XF86XK_DOS_ENABLED
	case OP_KEY_XF86XK_DOS:
#endif // OP_KEY_XF86XK_DOS_ENABLED
#ifdef OP_KEY_XF86XK_DOCUMENTS_ENABLED
	case OP_KEY_XF86XK_DOCUMENTS:
#endif // OP_KEY_XF86XK_DOCUMENTS_ENABLED
#ifdef OP_KEY_XF86XK_EXCEL_ENABLED
	case OP_KEY_XF86XK_EXCEL:
#endif // OP_KEY_XF86XK_EXCEL_ENABLED
#ifdef OP_KEY_XF86XK_EXPLORER_ENABLED
	case OP_KEY_XF86XK_EXPLORER:
#endif // OP_KEY_XF86XK_EXPLORER_ENABLED
#ifdef OP_KEY_XF86XK_GAME_ENABLED
	case OP_KEY_XF86XK_GAME:
#endif // OP_KEY_XF86XK_GAME_ENABLED
#ifdef OP_KEY_XF86XK_GO_ENABLED
	case OP_KEY_XF86XK_GO:
#endif // OP_KEY_XF86XK_GO_ENABLED
#ifdef OP_KEY_XF86XK_I_TOUCH_ENABLED
	case OP_KEY_XF86XK_I_TOUCH:
#endif // OP_KEY_XF86XK_I_TOUCH_ENABLED
#ifdef OP_KEY_XF86XK_LOG_OFF_ENABLED
	case OP_KEY_XF86XK_LOG_OFF:
#endif // OP_KEY_XF86XK_LOG_OFF_ENABLED
#ifdef OP_KEY_XF86XK_MARKET_ENABLED
	case OP_KEY_XF86XK_MARKET:
#endif // OP_KEY_XF86XK_MARKET_ENABLED
#ifdef OP_KEY_XF86XK_MEETING_ENABLED
	case OP_KEY_XF86XK_MEETING:
#endif // OP_KEY_XF86XK_MEETING_ENABLED
#ifdef OP_KEY_XF86XK_MENU_KB_ENABLED
	case OP_KEY_XF86XK_MENU_KB:
#endif // OP_KEY_XF86XK_MENU_KB_ENABLED
#ifdef OP_KEY_XF86XK_MENU_PB_ENABLED
	case OP_KEY_XF86XK_MENU_PB:
#endif // OP_KEY_XF86XK_MENU_PB_ENABLED
#ifdef OP_KEY_XF86XK_MY_SITES_ENABLED
	case OP_KEY_XF86XK_MY_SITES:
#endif // OP_KEY_XF86XK_MY_SITES_ENABLED
#ifdef OP_KEY_XF86XK_NEW_ENABLED
	case OP_KEY_XF86XK_NEW:
#endif // OP_KEY_XF86XK_NEW_ENABLED
#ifdef OP_KEY_XF86XK_NEWS_ENABLED
	case OP_KEY_XF86XK_NEWS:
#endif // OP_KEY_XF86XK_NEWS_ENABLED
#ifdef OP_KEY_XF86XK_OFFICE_HOME_ENABLED
	case OP_KEY_XF86XK_OFFICE_HOME:
#endif // OP_KEY_XF86XK_OFFICE_HOME_ENABLED
#ifdef OP_KEY_XF86XK_OPEN_ENABLED
	case OP_KEY_XF86XK_OPEN:
#endif // OP_KEY_XF86XK_OPEN_ENABLED
#ifdef OP_KEY_XF86XK_OPTION_ENABLED
	case OP_KEY_XF86XK_OPTION:
#endif // OP_KEY_XF86XK_OPTION_ENABLED
#ifdef OP_KEY_XF86XK_PASTE_ENABLED
	case OP_KEY_XF86XK_PASTE:
#endif // OP_KEY_XF86XK_PASTE_ENABLED
#ifdef OP_KEY_XF86XK_PHONE_ENABLED
	case OP_KEY_XF86XK_PHONE:
#endif // OP_KEY_XF86XK_PHONE_ENABLED
#ifdef OP_KEY_XF86XK_REPLY_ENABLED
	case OP_KEY_XF86XK_REPLY:
#endif // OP_KEY_XF86XK_REPLY_ENABLED
#ifdef OP_KEY_XF86XK_RELOAD_ENABLED
	case OP_KEY_XF86XK_RELOAD:
#endif // OP_KEY_XF86XK_RELOAD_ENABLED
#ifdef OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
	case OP_KEY_XF86XK_ROTATE_WINDOWS:
#endif // OP_KEY_XF86XK_ROTATE_WINDOWS_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_PB_ENABLED
	case OP_KEY_XF86XK_ROTATION_PB:
#endif // OP_KEY_XF86XK_ROTATION_PB_ENABLED
#ifdef OP_KEY_XF86XK_ROTATION_KB_ENABLED
	case OP_KEY_XF86XK_ROTATION_KB:
#endif // OP_KEY_XF86XK_ROTATION_KB_ENABLED
#ifdef OP_KEY_XF86XK_SAVE_ENABLED
	case OP_KEY_XF86XK_SAVE:
#endif // OP_KEY_XF86XK_SAVE_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_UP_ENABLED
	case OP_KEY_XF86XK_SCROLL_UP:
#endif // OP_KEY_XF86XK_SCROLL_UP_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
	case OP_KEY_XF86XK_SCROLL_DOWN:
#endif // OP_KEY_XF86XK_SCROLL_DOWN_ENABLED
#ifdef OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
	case OP_KEY_XF86XK_SCROLL_CLICK:
#endif // OP_KEY_XF86XK_SCROLL_CLICK_ENABLED
#ifdef OP_KEY_XF86XK_SEND_ENABLED
	case OP_KEY_XF86XK_SEND:
#endif // OP_KEY_XF86XK_SEND_ENABLED
#ifdef OP_KEY_XF86XK_SPELL_ENABLED
	case OP_KEY_XF86XK_SPELL:
#endif // OP_KEY_XF86XK_SPELL_ENABLED
#ifdef OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
	case OP_KEY_XF86XK_SPLIT_SCREEN:
#endif // OP_KEY_XF86XK_SPLIT_SCREEN_ENABLED
#ifdef OP_KEY_XF86XK_SUPPORT_ENABLED
	case OP_KEY_XF86XK_SUPPORT:
#endif // OP_KEY_XF86XK_SUPPORT_ENABLED
#ifdef OP_KEY_XF86XK_TASK_PANE_ENABLED
	case OP_KEY_XF86XK_TASK_PANE:
#endif // OP_KEY_XF86XK_TASK_PANE_ENABLED
#ifdef OP_KEY_XF86XK_TERMINAL_ENABLED
	case OP_KEY_XF86XK_TERMINAL:
#endif // OP_KEY_XF86XK_TERMINAL_ENABLED
#ifdef OP_KEY_XF86XK_TOOLS_ENABLED
	case OP_KEY_XF86XK_TOOLS:
#endif // OP_KEY_XF86XK_TOOLS_ENABLED
#ifdef OP_KEY_XF86XK_TRAVEL_ENABLED
	case OP_KEY_XF86XK_TRAVEL:
#endif // OP_KEY_XF86XK_TRAVEL_ENABLED
#ifdef OP_KEY_XF86XK_USER_PB_ENABLED
	case OP_KEY_XF86XK_USER_PB:
#endif // OP_KEY_XF86XK_USER_PB_ENABLED
#ifdef OP_KEY_XF86XK_USER1KB_ENABLED
	case OP_KEY_XF86XK_USER1KB:
#endif // OP_KEY_XF86XK_USER1KB_ENABLED
#ifdef OP_KEY_XF86XK_USER2KB_ENABLED
	case OP_KEY_XF86XK_USER2KB:
#endif // OP_KEY_XF86XK_USER2KB_ENABLED
#ifdef OP_KEY_XF86XK_VIDEO_ENABLED
	case OP_KEY_XF86XK_VIDEO:
#endif // OP_KEY_XF86XK_VIDEO_ENABLED
#ifdef OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
	case OP_KEY_XF86XK_WHEEL_BUTTON:
#endif // OP_KEY_XF86XK_WHEEL_BUTTON_ENABLED
#ifdef OP_KEY_XF86XK_WORD_ENABLED
	case OP_KEY_XF86XK_WORD:
#endif // OP_KEY_XF86XK_WORD_ENABLED
#ifdef OP_KEY_XF86XK_XFER_ENABLED
	case OP_KEY_XF86XK_XFER:
#endif // OP_KEY_XF86XK_XFER_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_IN_ENABLED
	case OP_KEY_XF86XK_ZOOM_IN:
#endif // OP_KEY_XF86XK_ZOOM_IN_ENABLED
#ifdef OP_KEY_XF86XK_ZOOM_OUT_ENABLED
	case OP_KEY_XF86XK_ZOOM_OUT:
#endif // OP_KEY_XF86XK_ZOOM_OUT_ENABLED
#ifdef OP_KEY_XF86XK_AWAY_ENABLED
	case OP_KEY_XF86XK_AWAY:
#endif // OP_KEY_XF86XK_AWAY_ENABLED
#ifdef OP_KEY_XF86XK_MESSENGER_ENABLED
	case OP_KEY_XF86XK_MESSENGER:
#endif // OP_KEY_XF86XK_MESSENGER_ENABLED
#ifdef OP_KEY_XF86XK_WEB_CAM_ENABLED
	case OP_KEY_XF86XK_WEB_CAM:
#endif // OP_KEY_XF86XK_WEB_CAM_ENABLED
#ifdef OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
	case OP_KEY_XF86XK_MAIL_FORWARD:
#endif // OP_KEY_XF86XK_MAIL_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_PICTURES_ENABLED
	case OP_KEY_XF86XK_PICTURES:
#endif // OP_KEY_XF86XK_PICTURES_ENABLED
#ifdef OP_KEY_XF86XK_MUSIC_ENABLED
	case OP_KEY_XF86XK_MUSIC:
#endif // OP_KEY_XF86XK_MUSIC_ENABLED
#ifdef OP_KEY_XF86XK_BATTERY_ENABLED
	case OP_KEY_XF86XK_BATTERY:
#endif // OP_KEY_XF86XK_BATTERY_ENABLED
#ifdef OP_KEY_XF86XK_BLUETOOTH_ENABLED
	case OP_KEY_XF86XK_BLUETOOTH:
#endif // OP_KEY_XF86XK_BLUETOOTH_ENABLED
#ifdef OP_KEY_XF86XK_WLAN_ENABLED
	case OP_KEY_XF86XK_WLAN:
#endif // OP_KEY_XF86XK_WLAN_ENABLED
#ifdef OP_KEY_XF86XK_UWB_ENABLED
	case OP_KEY_XF86XK_UWB:
#endif // OP_KEY_XF86XK_UWB_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
	case OP_KEY_XF86XK_AUDIO_FORWARD:
#endif // OP_KEY_XF86XK_AUDIO_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
	case OP_KEY_XF86XK_AUDIO_REPEAT:
#endif // OP_KEY_XF86XK_AUDIO_REPEAT_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
	case OP_KEY_XF86XK_AUDIO_RANDOM_PLAY:
#endif // OP_KEY_XF86XK_AUDIO_RANDOM_PLAY_ENABLED
#ifdef OP_KEY_XF86XK_SUBTITLE_ENABLED
	case OP_KEY_XF86XK_SUBTITLE:
#endif // OP_KEY_XF86XK_SUBTITLE_ENABLED
#ifdef OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
	case OP_KEY_XF86XK_AUDIO_CYCLE_TRACK:
#endif // OP_KEY_XF86XK_AUDIO_CYCLE_TRACK_ENABLED
#ifdef OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
	case OP_KEY_XF86XK_CYCLE_ANGLE:
#endif // OP_KEY_XF86XK_CYCLE_ANGLE_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_BACK_ENABLED
	case OP_KEY_XF86XK_FRAME_BACK:
#endif // OP_KEY_XF86XK_FRAME_BACK_ENABLED
#ifdef OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
	case OP_KEY_XF86XK_FRAME_FORWARD:
#endif // OP_KEY_XF86XK_FRAME_FORWARD_ENABLED
#ifdef OP_KEY_XF86XK_TIME_ENABLED
	case OP_KEY_XF86XK_TIME:
#endif // OP_KEY_XF86XK_TIME_ENABLED
#ifdef OP_KEY_XF86XK_VIEW_ENABLED
	case OP_KEY_XF86XK_VIEW:
#endif // OP_KEY_XF86XK_VIEW_ENABLED
#ifdef OP_KEY_XF86XK_TOP_MENU_ENABLED
	case OP_KEY_XF86XK_TOP_MENU:
#endif // OP_KEY_XF86XK_TOP_MENU_ENABLED
#ifdef OP_KEY_XF86XK_RED_ENABLED
	case OP_KEY_XF86XK_RED:
#endif // OP_KEY_XF86XK_RED_ENABLED
#ifdef OP_KEY_XF86XK_GREEN_ENABLED
	case OP_KEY_XF86XK_GREEN:
#endif // OP_KEY_XF86XK_GREEN_ENABLED
#ifdef OP_KEY_XF86XK_YELLOW_ENABLED
	case OP_KEY_XF86XK_YELLOW:
#endif // OP_KEY_XF86XK_YELLOW_ENABLED
#ifdef OP_KEY_XF86XK_BLUE_ENABLED
	case OP_KEY_XF86XK_BLUE:
#endif // OP_KEY_XF86XK_BLUE_ENABLED
#ifdef OP_KEY_XF86XK_SUSPEND_ENABLED
	case OP_KEY_XF86XK_SUSPEND:
#endif // OP_KEY_XF86XK_SUSPEND_ENABLED
#ifdef OP_KEY_XF86XK_HIBERNATE_ENABLED
	case OP_KEY_XF86XK_HIBERNATE:
#endif // OP_KEY_XF86XK_HIBERNATE_ENABLED
#ifdef OP_KEY_MAC_CTRL_LEFT_ENABLED
	case OP_KEY_MAC_CTRL_LEFT:
#endif // OP_KEY_MAC_CTRL_LEFT_ENABLED
#ifdef OP_KEY_MAC_CTRL_RIGHT_ENABLED
	case OP_KEY_MAC_CTRL_RIGHT:
#endif // OP_KEY_MAC_CTRL_RIGHT_ENABLED
#ifdef OP_KEY_HK_TOGGLE_ENABLED
	case OP_KEY_HK_TOGGLE:
#endif // OP_KEY_HK_TOGGLE_ENABLED
#ifdef OP_KEY_KATAKANA_ENABLED
	case OP_KEY_KATAKANA:
#endif // OP_KEY_KATAKANA_ENABLED
#ifdef OP_KEY_HIRAGANA_ENABLED
	case OP_KEY_HIRAGANA:
#endif // OP_KEY_HIRAGANA_ENABLED
	    return TRUE;
	}
	return FALSE;
}

/* static */ OpKey::Location
OpKey::ToLocation(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_MAC_CTRL_ENABLED
	case OP_KEY_MAC_CTRL: return LOCATION_LEFT;
#endif // OP_KEY_MAC_CTRL_ENABLED
#ifdef OP_KEY_CONTEXT_MENU_ENABLED
	case OP_KEY_CONTEXT_MENU: return LOCATION_RIGHT;
#endif // OP_KEY_CONTEXT_MENU_ENABLED
#ifdef OP_KEY_NUMPAD0_ENABLED
	case OP_KEY_NUMPAD0: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD0_ENABLED
#ifdef OP_KEY_NUMPAD1_ENABLED
	case OP_KEY_NUMPAD1: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD1_ENABLED
#ifdef OP_KEY_NUMPAD2_ENABLED
	case OP_KEY_NUMPAD2: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD2_ENABLED
#ifdef OP_KEY_NUMPAD3_ENABLED
	case OP_KEY_NUMPAD3: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD3_ENABLED
#ifdef OP_KEY_NUMPAD4_ENABLED
	case OP_KEY_NUMPAD4: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD4_ENABLED
#ifdef OP_KEY_NUMPAD5_ENABLED
	case OP_KEY_NUMPAD5: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD5_ENABLED
#ifdef OP_KEY_NUMPAD6_ENABLED
	case OP_KEY_NUMPAD6: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD6_ENABLED
#ifdef OP_KEY_NUMPAD7_ENABLED
	case OP_KEY_NUMPAD7: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD7_ENABLED
#ifdef OP_KEY_NUMPAD8_ENABLED
	case OP_KEY_NUMPAD8: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD8_ENABLED
#ifdef OP_KEY_NUMPAD9_ENABLED
	case OP_KEY_NUMPAD9: return LOCATION_NUMPAD;
#endif // OP_KEY_NUMPAD9_ENABLED
#ifdef OP_KEY_MULTIPLY_ENABLED
	case OP_KEY_MULTIPLY: return LOCATION_NUMPAD;
#endif // OP_KEY_MULTIPLY_ENABLED
#ifdef OP_KEY_ADD_ENABLED
	case OP_KEY_ADD: return LOCATION_NUMPAD;
#endif // OP_KEY_ADD_ENABLED
#ifdef OP_KEY_SEPARATOR_ENABLED
	case OP_KEY_SEPARATOR: return LOCATION_NUMPAD;
#endif // OP_KEY_SEPARATOR_ENABLED
#ifdef OP_KEY_SUBTRACT_ENABLED
	case OP_KEY_SUBTRACT: return LOCATION_NUMPAD;
#endif // OP_KEY_SUBTRACT_ENABLED
#ifdef OP_KEY_DECIMAL_ENABLED
	case OP_KEY_DECIMAL: return LOCATION_NUMPAD;
#endif // OP_KEY_DECIMAL_ENABLED
#ifdef OP_KEY_DIVIDE_ENABLED
	case OP_KEY_DIVIDE: return LOCATION_NUMPAD;
#endif // OP_KEY_DIVIDE_ENABLED
#ifdef OP_KEY_MAC_CTRL_LEFT_ENABLED
	case OP_KEY_MAC_CTRL_LEFT: return LOCATION_LEFT;
#endif // OP_KEY_MAC_CTRL_LEFT_ENABLED
#ifdef OP_KEY_MAC_CTRL_RIGHT_ENABLED
	case OP_KEY_MAC_CTRL_RIGHT: return LOCATION_RIGHT;
#endif // OP_KEY_MAC_CTRL_RIGHT_ENABLED

	}
	return LOCATION_STANDARD;
}

#ifdef MOUSE_SUPPORT

/* static */ BOOL
OpKey::IsMouseButton(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_MOUSE_BUTTON_1_ENABLED
	case OP_KEY_MOUSE_BUTTON_1:
#endif // OP_KEY_MOUSE_BUTTON_1_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_2_ENABLED
	case OP_KEY_MOUSE_BUTTON_2:
#endif // OP_KEY_MOUSE_BUTTON_2_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_3_ENABLED
	case OP_KEY_MOUSE_BUTTON_3:
#endif // OP_KEY_MOUSE_BUTTON_3_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_4_ENABLED
	case OP_KEY_MOUSE_BUTTON_4:
#endif // OP_KEY_MOUSE_BUTTON_4_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_5_ENABLED
	case OP_KEY_MOUSE_BUTTON_5:
#endif // OP_KEY_MOUSE_BUTTON_5_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_6_ENABLED
	case OP_KEY_MOUSE_BUTTON_6:
#endif // OP_KEY_MOUSE_BUTTON_6_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_7_ENABLED
	case OP_KEY_MOUSE_BUTTON_7:
#endif // OP_KEY_MOUSE_BUTTON_7_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_8_ENABLED
	case OP_KEY_MOUSE_BUTTON_8:
#endif // OP_KEY_MOUSE_BUTTON_8_ENABLED
#ifdef OP_KEY_MOUSE_BUTTON_9_ENABLED
	case OP_KEY_MOUSE_BUTTON_9:
#endif // OP_KEY_MOUSE_BUTTON_9_ENABLED
		return TRUE;

	default:
		return FALSE;
	}
}

#endif // MOUSE_SUPPORT

/* static */ BOOL
OpKey::IsGesture(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_GESTURE_UP_ENABLED
	case OP_KEY_GESTURE_UP:
#endif // OP_KEY_GESTURE_UP_ENABLED
#ifdef OP_KEY_GESTURE_RIGHT_ENABLED
	case OP_KEY_GESTURE_RIGHT:
#endif // OP_KEY_GESTURE_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_ENABLED
	case OP_KEY_GESTURE_DOWN:
#endif // OP_KEY_GESTURE_DOWN_ENABLED
#ifdef OP_KEY_GESTURE_LEFT_ENABLED
	case OP_KEY_GESTURE_LEFT:
#endif // OP_KEY_GESTURE_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_LEFT_ENABLED
	case OP_KEY_GESTURE_UP_LEFT:
#endif // OP_KEY_GESTURE_UP_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_UP_RIGHT_ENABLED
	case OP_KEY_GESTURE_UP_RIGHT:
#endif // OP_KEY_GESTURE_UP_RIGHT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_LEFT_ENABLED
	case OP_KEY_GESTURE_DOWN_LEFT:
#endif // OP_KEY_GESTURE_DOWN_LEFT_ENABLED
#ifdef OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
	case OP_KEY_GESTURE_DOWN_RIGHT:
#endif // OP_KEY_GESTURE_DOWN_RIGHT_ENABLED
#ifdef OP_KEY_SWIPE_UP_ENABLED
	case OP_KEY_SWIPE_UP:
#endif // OP_KEY_SWIPE_UP_ENABLED
#ifdef OP_KEY_SWIPE_DOWN_ENABLED
	case OP_KEY_SWIPE_DOWN:
#endif // OP_KEY_SWIPE_DOWN_ENABLED
#ifdef OP_KEY_SWIPE_LEFT_ENABLED
	case OP_KEY_SWIPE_LEFT:
#endif // OP_KEY_SWIPE_LEFT_ENABLED
#ifdef OP_KEY_SWIPE_RIGHT_ENABLED
	case OP_KEY_SWIPE_RIGHT:
#endif // OP_KEY_SWIPE_RIGHT_ENABLED
		return TRUE;

	default:
		return FALSE;
	}
}

/* static */ BOOL
OpKey::IsFlip(OpKey::Code key)
{
	switch (key)
	{
#ifdef OP_KEY_FLIP_BACK_ENABLED
	case OP_KEY_FLIP_BACK:
#endif // OP_KEY_FLIP_BACK_ENABLED
#ifdef OP_KEY_FLIP_FORWARD_ENABLED
	case OP_KEY_FLIP_FORWARD:
#endif // OP_KEY_FLIP_FORWARD_ENABLED
		return TRUE;

	default:
		return FALSE;
	}
}

/* static */ OpKey::Code
OpKey::FromASCIIToKeyCode(char ch, ShiftKeyState &modifiers)
{
    modifiers = SHIFTKEY_NONE;
    if (ch >= 'a' && ch <= 'z')
        return static_cast<OpKey::Code>(OP_KEY_A + (ch - 'a'));
    else if (ch >= '0' && ch <= '9')
        return static_cast<OpKey::Code>(OP_KEY_0 + (ch - '0'));
    else if (ch >= 'A' && ch <= 'Z')
    {
        modifiers |= SHIFTKEY_SHIFT;
        return static_cast<OpKey::Code>(OP_KEY_A + (ch - 'A'));
    }
    else
        /* US-ASCII means US keyboard layout. */
        switch (ch)
        {
#if OP_KEY_BACKSPACE_ENABLED
        case 8: return OP_KEY_BACKSPACE;
#endif // OP_KEY_BACKSPACE_ENABLED
#if OP_KEY_TAB_ENABLED
        case '\t': return OP_KEY_TAB;
#endif // OP_KEY_TAB_ENABLED
#if OP_KEY_ENTER_ENABLED
        case '\r':
        case '\n': return OP_KEY_ENTER;
#endif // OP_KEY_ENTER_ENABLED
#if OP_KEY_ESCAPE_ENABLED
        case 27: return OP_KEY_ESCAPE;
#endif // OP_KEY_ESCAPE_ENABLED
#if OP_KEY_SPACE_ENABLED
        case ' ': return OP_KEY_SPACE;
#endif // OP_KEY_SPACE_ENABLED
        case '!':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_1;
#ifdef OP_KEY_OEM_7_ENABLED
        case '"':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_7;
#endif // OP_KEY_OEM_7_ENABLED
        case '#':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_3;
        case '$':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_4;
        case '%':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_5;
        case '&':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_7;
#if OP_KEY_OEM_7_ENABLED
        case '\'':
            return OP_KEY_OEM_7;
#endif // OP_KEY_OEM_7_ENABLED
        case '(':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_9;
        case ')':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_0;
        case '*':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_8;
#if OP_KEY_OEM_PLUS_ENABLED
        case '+':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_PLUS;
#endif // OP_KEY_OEM_PLUS_ENABLED
#if OP_KEY_OEM_COMMA_ENABLED
        case ',':
            return OP_KEY_OEM_COMMA;
#endif // OP_KEY_OEM_COMMA_ENABLED
#if OP_KEY_OEM_MINUS_ENABLED
        case '-':
            return OP_KEY_OEM_MINUS;
#endif // OP_KEY_OEM_MINUS_ENABLED
#if OP_KEY_OEM_PERIOD_ENABLED
        case '.':
            return OP_KEY_OEM_PERIOD;
#endif // OP_KEY_OEM_PERIOD_ENABLED
#if OP_KEY_OEM_2_ENABLED
        case '/':
            return OP_KEY_OEM_2;
#endif // OP_KEY_OEM_2_ENABLED
#if OP_KEY_OEM_1_ENABLED
        case ':':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_1;
#endif // OP_KEY_OEM_1_ENABLED
#if OP_KEY_OEM_1_ENABLED
        case ';':
            return OP_KEY_OEM_1;
#endif // OP_KEY_OEM_1_ENABLED
#if OP_KEY_OEM_COMMA_ENABLED
        case '<':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_COMMA;
#endif // OP_KEY_OEM_COMMA_ENABLED
#if OP_KEY_OEM_PLUS_ENABLED
        case '=':
            return OP_KEY_OEM_PLUS;
#endif // OP_KEY_OEM_PLUS_ENABLED
#if OP_KEY_OEM_PERIOD_ENABLED
        case '>':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_PERIOD;
#endif // OP_KEY_OEM_PERIOD_ENABLED
#if OP_KEY_OEM_2_ENABLED
        case '?':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_2;
#endif // OP_KEY_OEM_2_ENABLED
        case '@':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_2;
#if OP_KEY_OEM_4_ENABLED
        case '[':
            return OP_KEY_OEM_4;
#endif // OP_KEY_OEM_4_ENABLED
#if OP_KEY_OEM_5_ENABLED
        case '\\':
            return OP_KEY_OEM_5;
#endif // OP_KEY_OEM_5_ENABLED
#if OP_KEY_OEM_6_ENABLED
        case ']':
            return OP_KEY_OEM_6;
#endif // OP_KEY_OEM_6_ENABLED
        case '^':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_6;
#if OP_KEY_OEM_MINUS_ENABLED
        case '_':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_MINUS;
#endif // OP_KEY_OEM_MINUS_ENABLED
#if OP_KEY_OEM_3_ENABLED
        case '`':
            return OP_KEY_OEM_3;
#endif // OP_KEY_OEM_3_ENABLED
#if OP_KEY_OEM_4_ENABLED
        case '{':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_4;
#endif // OP_KEY_OEM_4_ENABLED
#if OP_KEY_OEM_5_ENABLED
        case '|':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_5;
#endif // OP_KEY_OEM_5_ENABLED
#if OP_KEY_OEM_6_ENABLED
        case '}':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_6;
#endif // OP_KEY_OEM_6_ENABLED
#if OP_KEY_OEM_3_ENABLED
        case '~':
            modifiers |= SHIFTKEY_SHIFT;
            return OP_KEY_OEM_3;
#endif // OP_KEY_OEM_3_ENABLED
#if OP_KEY_DELETE_ENABLED
        case 0x7f:
            return OP_KEY_DELETE;
#endif // OP_KEY_DELETE_ENABLED
        }
    return OP_KEY_FIRST;
}
