/* -*- Mode: c++; indent-tabs-mode: t; tab-width: 4 -*- */

enum Prototype
{
	/* JavaScript */
	NAVIGATOR_PROTOTYPE,
	HISTORY_PROTOTYPE,
	CONSOLE_PROTOTYPE,
	LOCATION_PROTOTYPE,
	PLUGINARRAY_PROTOTYPE,

	/* DOM 2 Core */
	NODE_PROTOTYPE,
	DOCUMENT_PROTOTYPE,
	DOCUMENTFRAGMENT_PROTOTYPE,
	CHARACTERDATA_PROTOTYPE,
	ATTR_PROTOTYPE,
	ELEMENT_PROTOTYPE,
	TEXT_PROTOTYPE,
	COMMENT_PROTOTYPE,
	CDATASECTION_PROTOTYPE,
	DOCUMENTTYPE_PROTOTYPE,
	NOTATION_PROTOTYPE,
	ENTITY_PROTOTYPE,
	ENTITYREFERENCE_PROTOTYPE,
	PROCESSINGINSTRUCTION_PROTOTYPE,
	NODELIST_PROTOTYPE,
	NAMEDNODEMAP_PROTOTYPE,
	XMLDOCUMENT_PROTOTYPE,
	DOMEXCEPTION_PROTOTYPE,
	CLIENTRECT_PROTOTYPE,
	CLIENTRECTLIST_PROTOTYPE,

	/* HTML5 Microdata */
	HTMLPROPERTIESCOLLECTION_PROTOTYPE,
	HTMLPROPERTYNODELISTCOLLECTION_PROTOTYPE,

	/* DOM 3 Core */
	DOMCONFIGURATION_PROTOTYPE,
	DOMSTRINGLIST_PROTOTYPE,
	DOMSTRINGMAP_PROTOTYPE,
	DOMTOKENLIST_PROTOTYPE,
	DOMSETTABLETOKENLIST_PROTOTYPE,

	/* DOM 2 Events */
	EVENT_PROTOTYPE,
	UIEVENT_PROTOTYPE,
	MOUSEEVENT_PROTOTYPE,
	KEYBOARDEVENT_PROTOTYPE,
#ifdef DOM2_MUTATION_EVENTS
	MUTATIONEVENT_PROTOTYPE,
#endif // DOM2_MUTATION_EVENTS
#ifdef PROGRESS_EVENTS_SUPPORT
	PROGRESSEVENT_PROTOTYPE,
#endif // PROGRESS_EVENTS_SUPPORT
#ifdef CSS_TRANSITIONS
	TRANSITIONEVENT_PROTOTYPE,
	OTRANSITIONEVENT_PROTOTYPE,
	WEBKITTRANSITIONEVENT_PROTOTYPE,
#endif // CSS_TRANSITIONS
#ifdef CSS_ANIMATIONS
	ANIMATIONEVENT_PROTOTYPE,
#endif // CSS_ANIMATIONS
	HASHCHANGEEVENT_PROTOTYPE,
	ERROREVENT_PROTOTYPE,
	CUSTOMEVENT_PROTOTYPE,

	/* DOM 3 Events */
	TEXTEVENT_PROTOTYPE,

	/* DOM 2 HTML */
	HTMLCOLLECTION_PROTOTYPE,
	HTMLOPTIONSCOLLECTION_PROTOTYPE,
	HTMLDOCUMENT_PROTOTYPE,
	HTMLELEMENT_PROTOTYPE,

	/* DOM 2 CSS */
	CSSSTYLEDECLARATION_PROTOTYPE,
	CSSSTYLESHEET_PROTOTYPE,
	CSSRULELIST_PROTOTYPE,
	CSSRULE_PROTOTYPE,
	CSSCONDITIONALRULE_PROTOTYPE,
	CSSMEDIARULE_PROTOTYPE,
	CSSSUPPORTSRULE_PROTOTYPE,
#ifdef CSS_ANIMATIONS
	CSSKEYFRAMESRULE_PROTOTYPE,
#endif // CSS_ANIMATIONS
#ifdef CSS_TRANSFORMS
	CSSMATRIX_PROTOTYPE,
#endif // CSS_TRANSFORMS

	/* DOM 2 Traversal & Range */
#ifdef DOM2_TRAVERSAL
	NODEFILTER_PROTOTYPE,
	NODEITERATOR_PROTOTYPE,
	TREEWALKER_PROTOTYPE,
#endif // DOM2_TRAVERSAL
#ifdef DOM2_RANGE
	RANGE_PROTOTYPE,
#endif // DOM2_RANGE

	/* DOM 2 Style Sheets */
	STYLESHEETLIST_PROTOTYPE,
	MEDIALIST_PROTOTYPE,

	/* CSSOM View */
	MEDIAQUERYLIST_PROTOTYPE,

	/* DOM 3 Load & Save and extras */
#ifdef DOM3_LOAD
	LSEXCEPTION_PROTOTYPE,
	LSPARSER_PROTOTYPE,
	DOMPARSER_PROTOTYPE,
#endif // DOM3_LOAD
#ifdef DOM3_SAVE
	LSSERIALIZER_PROTOTYPE,
	XMLSERIALIZER_PROTOTYPE,
#endif // DOM3_SAVE
#ifdef DOM_HTTP_SUPPORT
	XMLHTTPREQUEST_PROTOTYPE,
#endif // DOM_HTTP_SUPPORT
#if defined DOM_HTTP_SUPPORT && defined PROGRESS_EVENTS_SUPPORT
	XMLHTTPREQUESTUPLOAD_PROTOTYPE,
#endif // DOM_HTTP_SUPPORT && PROGRESS_EVENTS_SUPPORT
#ifdef DOM_HTTP_SUPPORT
	ANONXMLHTTPREQUEST_PROTOTYPE,
	FORMDATA_PROTOTYPE,
#endif // DOM_HTTP_SUPPORT

	/* DOM 3 XPath */
#ifdef DOM3_XPATH
	XPATHEVALUATOR_PROTOTYPE,
	XPATHEXCEPTION_PROTOTYPE,
	XPATHEXPRESSION_PROTOTYPE,
	XPATHNSRESOLVER_PROTOTYPE,
	XPATHRESULT_PROTOTYPE,
	XPATHNAMESPACE_PROTOTYPE,
	XPATHRESULT_NODELIST_PROTOTYPE,
#endif // DOM3_XPATH

	/* Canvas */
#ifdef CANVAS_SUPPORT
	CANVASCONTEXT2D_PROTOTYPE,
	CANVASGRADIENT_PROTOTYPE,
	CANVASPATTERN_PROTOTYPE,
	CANVASIMAGEDATA_PROTOTYPE,
	TEXTMETRICS_PROTOTYPE,
#endif // CANVAS_SUPPORT

	/* Canvas3D */
#ifdef CANVAS3D_SUPPORT
	CANVASCONTEXTWEBGL_PROTOTYPE,
	WEBGLCONTEXTATTRIBUTES_PROTOTYPE,
	WEBGLOBJECT_PROTOTYPE,
	WEBGLBUFFER_PROTOTYPE,
	WEBGLEXTENSION_PROTOTYPE,
	WEBGLFRAMEBUFFER_PROTOTYPE,
	WEBGLPROGRAM_PROTOTYPE,
	WEBGLRENDERBUFFER_PROTOTYPE,
	WEBGLSHADER_PROTOTYPE,
	WEBGLTEXTURE_PROTOTYPE,
	WEBGLUNIFORMLOCATION_PROTOTYPE,
	WEBGLACTIVEINFO_PROTOTYPE,
#endif // CANVAS3D_SUPPORT

	/* SVG */
#ifdef SVG_DOM
	SVGDOCUMENT_PROTOTYPE,
	SVGEXCEPTION_PROTOTYPE,
	SVGELEMENT_PROTOTYPE,
	SVGOBJECT_PROTOTYPE,
#ifdef SVG_FULL_11
	SVGLIST_PROTOTYPE,
	SVGSTRINGLIST_PROTOTYPE,
#endif // SVG_FULL_11
	SVGELEMENTINSTANCE_PROTOTYPE,
#ifdef SVG_FULL_11
	SVGELEMENTINSTANCELIST_PROTOTYPE,
#endif // SVG_FULL_11
	TIMEEVENT_PROTOTYPE,
#endif // SVG_DOM

	/* Debugger */
#ifdef DOM_DEBUGGER_SUPPORT
	DEBUGGER_PROTOTYPE,
#endif // DOM_DEBUGGER_SUPPORT

	/* TextRange */
#ifdef DOM_SELECTION_SUPPORT
	WINDOWSELECTION_PROTOTYPE,
#endif // DOM_SELECTION_SUPPORT

	/* Proprietary XSLT support */
#ifdef DOM_XSLT_SUPPORT
	XSLTPROCESSOR_PROTOTYPE,
#endif // DOM_XSLT_SUPPORT

	/* UPnP Services Discovery */
#if defined UPNP_SUPPORT && defined UPNP_SERVICE_DISCOVERY
	DEVICEDESCRIPTOR_PROTOTYPE,
	SERVICEDESCRIPTOR_PROTOTYPE,
	UPNPCOLLECTION_PROTOTYPE,
#endif // UPNP_SUPPORT && UPNP_SERVICE_DISCOVERY

	/* WebFeeds support */
#ifdef WEBFEEDS_BACKEND_SUPPORT
	WEBFEEDS_PROTOTYPE,
	FEEDLIST_PROTOTYPE,
	FEED_PROTOTYPE,
	FEEDENTRYLIST_PROTOTYPE,
	FEEDENTRY_PROTOTYPE,
	FEEDCONTENT_PROTOTYPE,
#ifdef WEBFEEDS_EXTERNAL_READERS
	FEEDREADERLIST_PROTOTYPE,
	FEEDREADER_PROTOTYPE,
#endif // WEBFEEDS_EXTERNAL_READERS
#endif // WEBFEEDS_BACKEND_SUPPORT

	/* WebServer support */
#ifdef WEBSERVER_SUPPORT
	WEBSERVERREQUEST_PROTOTYPE,
	WEBSERVERRESPONSE_PROTOTYPE,
	WEBSERVERUPLOADEDFILE_PROTOTYPE,
	WEBSERVERSESSION_PROTOTYPE,
	WEBSERVERCONNECTION_PROTOTYPE,
	WEBSERVERARRAY_PROTOTYPE,
	WEBSERVERCOLLECTION_PROTOTYPE,
	WEBSERVERSERVICEDESCRIPTOR_PROTOTYPE,
#endif // WEBSERVER_SUPPORT

	/* Gadget support */
#ifdef GADGET_SUPPORT
	WIDGET_PROTOTYPE,
	WIDGETICON_PROTOTYPE,
	WIDGETWINDOW_PROTOTYPE,
	WIDGETCOLLECTION_PROTOTYPE,
#endif // GADGET_SUPPORT

	/* Gadget Manager support */
#if defined DOM_WIDGETMANAGER_SUPPORT || defined DOM_UNITEAPPMANAGER_SUPPORT || defined EXTENSION_MANAGER_SUPPORT
	WIDGETMANAGER_PROTOTYPE,
#endif // DOM_WIDGETMANAGER_SUPPORT || DOM_UNITEAPPMANAGER_SUPPORT || EXTENSION_MANAGER_SUPPORT

	/* Opera Account support */
#if defined DOM_ACCOUNTMANAGER_SUPPORT
	OPERAACCOUNTMANAGER_PROTOTYPE,
#endif // DOM_ACCOUNTMANAGER_SUPPORT

	/* Unite support */
#if defined DOM_UNITEDEVMANAGER_SUPPORT
	UNITEDEVICEMANAGER_PROTOTYPE,
#endif // DOM_UNITEDEVMANAGER_SUPPORT

	/* IO support */
#if defined DOM_GADGET_FILE_API_SUPPORT || defined WEBSERVER_SUPPORT
	IO_PROTOTYPE,
	BYTEARRAY_PROTOTYPE,
#endif // DOM_GADGET_FILE_API_SUPPORT || WEBSERVER_SUPPORT

	/* Gadget File API support */
#if defined DOM_GADGET_FILE_API_SUPPORT
	GADGETFILE_PROTOTYPE,
	FILESTREAM_PROTOTYPE,
	FILESYSTEM_PROTOTYPE,
#endif // DOM_GADGET_FILE_API_SUPPORT

	/* File API support */
	BLOB_PROTOTYPE,
	FILE_PROTOTYPE,
	FILELIST_PROTOTYPE,
	FILEREADER_PROTOTYPE,
	FILEREADERSYNC_PROTOTYPE,
	FILEERROR_PROTOTYPE,
	FILEEXCEPTION_PROTOTYPE,

	/* Media */
#ifdef MEDIA_HTML_SUPPORT
	MEDIAERROR_PROTOTYPE,
	TIMERANGES_PROTOTYPE,
	TEXTTRACK_PROTOTYPE,
	TEXTTRACKLIST_PROTOTYPE,
	TEXTTRACKCUE_PROTOTYPE,
	TEXTTRACKCUELIST_PROTOTYPE,
	TRACKEVENT_PROTOTYPE,
#endif // MEDIA_HTML_SUPPORT

	/* Geolocation support */
#if defined(DOM_GEOLOCATION_SUPPORT) && defined(PI_GEOLOCATION)
	GEOLOCATION_PROTOTYPE,
	POSITION_PROTOTYPE,
	COORDINATES_PROTOTYPE,
	POSITIONERROR_PROTOTYPE,
#endif // DOM_GEOLOCATION_SUPPORT && PI_GEOLOCATION

	/* HTML5 Client-side Storage */
#ifdef CLIENTSIDE_STORAGE_SUPPORT
	STORAGE_PROTOTYPE,
#ifdef WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	STORAGE_USERJS_PROTOTYPE,
#endif // WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	STORAGEEVENT_PROTOTYPE,
#endif // CLIENTSIDE_STORAGE_SUPPORT

	/* HTML5 Database Storage */
#ifdef DATABASE_STORAGE_SUPPORT
	DATABASE_PROTOTYPE,
	SQLTRANSACTION_PROTOTYPE,
	SQLRESULTSET_PROTOTYPE,
	SQLRESULTSETROWLIST_PROTOTYPE,
	SQLERROR_PROTOTYPE,
#endif // DATABASE_STORAGE_SUPPORT

	/* JIL API support */
#ifdef DOM_JIL_API_SUPPORT
	JIL_ACCELEROMETERINFO_PROTOTYPE,
	JIL_ACCOUNTINFO_PROTOTYPE,
	JIL_ADDRESSBOOKITEM_PROTOTYPE,
	JIL_ATTACHMENT_PROTOTYPE,
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	JIL_AUDIOPLAYER_PROTOTYPE,
#endif // MEDIA_JIL_PLAYER_SUPPORT
	JIL_CALENDARITEM_PROTOTYPE,
	JIL_CALLRECORD_PROTOTYPE,
	JIL_CALLRECORDTYPES_PROTOTYPE,
#ifdef JIL_CAMERA_SUPPORT
	JIL_CAMERA_PROTOTYPE,
#endif // JIL_CAMERA_SUPPORT
	JIL_CONFIG_PROTOTYPE,
	JIL_DATANETWORKINFO_PROTOTYPE,
	JIL_DEVICE_PROTOTYPE,
	JIL_DEVICEINFO_PROTOTYPE,
	JIL_DEVICESTATEINFO_PROTOTYPE,
	JIL_EMAILACCOUNT_PROTOTYPE,
	JIL_EXCEPTION_PROTOTYPE,
	JIL_FILE_PROTOTYPE,
	JIL_MESSAGE_PROTOTYPE,
	JIL_MESSAGEFOLDERTYPES_PROTOTYPE,
	JIL_MESSAGEQUANTITIES_PROTOTYPE,
	JIL_MESSAGETYPES_PROTOTYPE,
	JIL_MESSAGING_PROTOTYPE,
#ifndef MEDIA_JIL_PLAYER_SUPPORT
	JIL_MULTIMEDIA_PROTOTYPE,
#endif // MEDIA_JIL_PLAYER_SUPPORT
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	JIL_MULTIMEDIA_PROTOTYPE,
#endif // MEDIA_JIL_PLAYER_SUPPORT
	JIL_PIM_PROTOTYPE,
	JIL_POSITIONINFO_PROTOTYPE,
	JIL_POWERINFO_PROTOTYPE,
	JIL_RADIOINFO_PROTOTYPE,
	JIL_TELEPHONY_PROTOTYPE,
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	JIL_VIDEOPLAYER_PROTOTYPE,
#endif // MEDIA_JIL_PLAYER_SUPPORT
	JIL_WIDGET_PROTOTYPE,
#endif // DOM_JIL_API_SUPPORT

	/* HTML 5 Offline Web Application */
#ifdef APPLICATION_CACHE_SUPPORT
	APPLICATIONCACHE_PROTOTYPE,
#endif // APPLICATION_CACHE_SUPPORT

	/* WebSocket */
#ifdef WEBSOCKETS_SUPPORT
	WEBSOCKET_PROTOTYPE,
	CLOSEEVENT_PROTOTYPE,
#endif // WEBSOCKETS_SUPPORT

	/* HTML5 Web Workers */
#ifdef DOM_WEBWORKERS_SUPPORT
	WEBWORKERS_DEDICATED_OBJECT_PROTOTYPE,
	WEBWORKERS_SHARED_OBJECT_PROTOTYPE,
	WEBWORKERS_LOCATION_PROTOTYPE,
	WEBWORKERS_NAVIGATOR_PROTOTYPE,
#endif // DOM_WEBWORKERS_SUPPORT

	/* HTML5 Cross Document Messaging */
#ifdef DOM_CROSSDOCUMENT_MESSAGING_SUPPORT
	CROSSDOCUMENT_MESSAGECHANNEL_PROTOTYPE,
	CROSSDOCUMENT_MESSAGEEVENT_PROTOTYPE,
	CROSSDOCUMENT_MESSAGEPORT_PROTOTYPE,
#endif // DOM_CROSSDOCUMENT_MESSAGING_SUPPORT

	/* HTML5 Server-Sent Events */
#ifdef EVENT_SOURCE_SUPPORT
	EVENTSOURCE_PROTOTYPE,
#endif // EVENT_SOURCE_SUPPORT

	/* Touch Events support */
#ifdef TOUCH_EVENTS_SUPPORT
	TOUCH_PROTOTYPE,
	TOUCHLIST_PROTOTYPE,
	TOUCHEVENT_PROTOTYPE,
#endif // TOUCH_EVENTS_SUPPORT

	/* Extension support */
#ifdef EXTENSION_SUPPORT
	EXTENSION_PROTOTYPE,
	EXTENSION_BACKGROUND_PROTOTYPE,
	EXTENSION_CONTEXT_PROTOTYPE,
	EXTENSION_SPEEDDIAL_CONTEXT_PROTOTYPE,
	EXTENSION_CONTEXTS_PROTOTYPE,
	EXTENSION_PAGE_CONTEXT_PROTOTYPE,
	EXTENSION_UIBADGE_PROTOTYPE,
	EXTENSION_UIITEM_PROTOTYPE,
	EXTENSION_UIITEM_EVENT_PROTOTYPE,
	EXTENSION_UIPOPUP_PROTOTYPE,
#ifdef URL_FILTER
	EXTENSION_URLFILTER_PROTOTYPE,
	EXTENSION_URLFILTER_EVENT_PROTOTYPE,
	EXTENSION_RULELIST_PROTOTYPE,
	EXTENSION_RULEOPTIONS_PROTOTYPE,
#endif // URL_FILTER
#endif // EXTENSION_SUPPORT

	/* Tabs & windows API */
#ifdef DOM_EXTENSIONS_TAB_API_SUPPORT
	BROWSER_TAB_PROTOTYPE,
	BROWSER_TAB_MANAGER_PROTOTYPE,
	BROWSER_TAB_EVENT_PROTOTYPE,
	BROWSER_TAB_GROUP_PROTOTYPE,
	BROWSER_TAB_GROUP_MANAGER_PROTOTYPE,
	BROWSER_TAB_GROUP_EVENT_PROTOTYPE,
	BROWSER_WINDOW_PROTOTYPE,
	BROWSER_WINDOW_MANAGER_PROTOTYPE,
	BROWSER_WINDOW_EVENT_PROTOTYPE,
#endif // DOM_EXTENSIONS_TAB_API_SUPPORT

	/* Extension Context Menu API */
#ifdef DOM_EXTENSIONS_CONTEXT_MENU_API_SUPPORT
	EXTENSION_MENUCONTEXT_PROTOTYPE,
	EXTENSION_ROOTMENUCONTEXT_PROTOTYPE,
	EXTENSION_MENUITEM_PROTOTYPE,
	EXTENSION_MENUCONTEXT_PROXY_PROTOTYPE,
	EXTENSION_MENUITEM_PROXY_PROTOTYPE,
#endif // DOM_EXTENSIONS_CONTEXT_MENU_API_SUPPORT

	/* HTML5 History */
	POPSTATEEVENT_PROTOTYPE,

	/* DOMPerformance */
#ifdef DOM_WINDOW_PERFORMANCE_OBJECT_SUPPORT
	PERFORMANCE_PROTOTYPE,
#endif // DOM_WINDOW_PERFORMANCE_OBJECT_SUPPORT

	/* Stream API support */
#ifdef DOM_STREAM_API_SUPPORT
	LOCALMEDIASTREAM_PROTOTYPE,
#endif // DOM_STREAM_API_SUPPORT

	/* DeviceOrientation Event */
#ifdef DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
	DEVICEORIENTATION_EVENT_PROTOTYPE,
	DEVICEMOTION_EVENT_PROTOTYPE,
#endif // DOM_DEVICE_ORIENTATION_EVENT_SUPPORT

	/* Search Suggestions Support */
#ifdef DOC_SEARCH_SUGGESTIONS_SUPPORT
	SEARCHSUGGESTS_PROTOTYPE,
#endif // DOC_SEARCH_SUGGESTIONS_SUPPORT

	/* Paged display */
#ifdef PAGED_MEDIA_SUPPORT
	PAGEEVENT_PROTOTYPE,
#endif // PAGED_MEDIA_SUPPORT

	/* HTML5 Data Transfer */
#if defined(DRAG_SUPPORT) || defined(USE_OP_CLIPBOARD)
	DATATRANSFER_PROTOTYPE,
	DATATRANSFERITEM_PROTOTYPE,
	DATATRANSFERITEMS_PROTOTYPE,
#endif // DRAG_SUPPORT || USE_OP_CLIPBOARD

	/* HTML5 DND */
#ifdef DRAG_SUPPORT
	DRAGEVENT_PROTOTYPE,
#endif // DRAG_SUPPORT

	/* Clipboard Event */
#ifdef USE_OP_CLIPBOARD
	CLIPBOARDEVENT_PROTOTYPE,
#endif // USE_OP_CLIPBOARD

	PROTOTYPES_COUNT
};
