/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
#ifdef AUTO_UPDATE_SUPPORT
	AutoUpdateGeoServer, ///< The address of the Geo-DNS autoupdate server. Used for the metrics.
	AutoUpdateServer, ///< The address of the autoupdate server
#endif
	AuCountryCode, ///< Sets which region settings to use for the region of the world you are in. Setting is sent from the Autoupdate server.
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	BrandedBannerURL, ///< URL for branded banner
#endif
	HotlistActiveTab, ///< Active tab in hotlist
	HotlistBookmarksYSplitter, ///< Splitter pos (float) in bookmarks window. Valid range 0-1  (height_of_top_view / (height_of_bottom_view + height_of_top_view))
	HotlistContactsYSplitter, ///< Splitter pos (float) in contacts window.  Valid range 0-1  (height_of_top_view / (height_of_bottom_view + height_of_top_view))
	CustomBookmarkImportFilename, ///< Filename of the custom bookmarkfile to import
	FirstVersionRun, ///< Indicates the first version of Opera that has succcessfully run
	NewestUsedBetaName, ///< Indicates the newest beta name of Opera that has succcessfully run
	MaxVersionRun, ///< Indicates the highest version of Opera that has succcessfully run
	OneTimePage, ///< Page to only display once after install
	ClickedSound, ///< Link clicked sound path
	EndSound, ///< Shutdown sound path
	FailureSound, ///< Loading failure sound path
	LoadedSound, ///< Page loaded sound path
	StartSound, ///< Start-up sound path
	TransferDoneSound, ///< Transfer done sound path
	ActiveCountryCode, ///< Country code in ISO 3166-1 alpha-2 format. Determines ActiveRegion
	ActiveDefaultLanguage, ///< Default language for active country. Used as a second choice (after region) when loading regional customizations
	ActiveRegion, ///< Sets folder from which Opera should load regional customizations (bookmarks, speed dials, etc.)
	IdOfHardcodedDefaultSearch, ///< Search protection (hidden preference)
	HashOfDefaultSearch, ///< Search protection (hidden preference)
	IdOfHardcodedSpeedDialSearch, ///< Search protection (hidden preference)
	HashOfSpeedDialSearch, ///< Search protection (hidden preference)
	DetectedCountryCode, ///< Country code in ISO 3166-1 alpha-2 format. Value reported by OS or received from autoupdate server
	UpgradeFromVersion, ///< The version previous to current when installation has been upgraded
	CountryCode, ///< Country code in ISO 3166-1 alpha-2 format. Overrides country code detected by Opera
	CrashFeedbackPage, ///< web address of feedback page about the crash after Opera crashed and the user has choosed to upload the log
	DownloadManager, ///< The path of external download manager to use, empty value or "opera" indicates none.
#ifdef OPERA_CONSOLE
	ErrorConsoleFilter, ///< Current display filter for the console
#endif
	ExtensionSetParent, ///< Name of toolbar, that is supposed to show ExtensionSet widget
	GoogleTLDDefault, ///< Default top level domain to use for google
	GoogleTLDServer, ///< URL to google's top level domain lookup server
	IntranetHosts, ///< List of hostnames that should be treated like URLs instead of go to default search engine. Previosly typed intranets are stored here.
	LanguageCodesFileName, ///< Filename of text file describing language codes with name
	NewestSeenVersion, ///< Most current version notified to the user
	TipsConfigFile, ///< Tips configuration file
	TipsConfigMetaFile, ///< Tips configuration meta file
	ProgramTitle, ///< Caption for main window
	UserEmail, ///< Email address of the user, logged when reporting crash log
	ValidationForm, ///< Form element to use for uploaded file
	ValidationURL, ///< URL to document validation service

	DummyLastStringPref
};
#define PCUI_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionUI::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
#ifdef AUTO_UPDATE_SUPPORT
	UpdateCheckIntervalGadgets, ///< This setting holds the interval Opera checks for gadgets (extensions, unite, widgets) updates (in seconds). Min is one day, max is 30 days, default 3 days.
	AutoUpdateResponded, ///< This is set after the first response from the autoupdate server. This will separate the first installs from the upgrades
	AutoUpdateState, ///< This setting holds the state of the automatic update system, which are: No update available, Update on server, Update downloaded and Update installation started, which are represented by the integers [0,3].
	BrowserJSTime, ///< Holds the time of the last downloaded browser.js file
	DelayedUpdateCheckInterval, ///< This setting holds the delayed interval Opera checks for updates (in seconds) when server is not responding
	DictionaryTime, ///< Holds the time of the last downloaded dictionaries.xml
	DownloadAllSnapshots, ///< Set to download all snapshots
	HandlersIgnoreTime, ///< Holds the time of the last downloaded handlers ignore file
	HardwareBlocklistTime, ///< Holds the time of the last downloaded hardware blocklist
#endif
#ifdef PLUGIN_AUTO_INSTALL
	PluginAutoInstallEnabled, ///< Enable the missing plugin detection and automatic installation wizard
	PluginAutoInstallMaxItems, ///< How many missing plugin items will be tracked at maximum
#endif
#ifdef AUTO_UPDATE_SUPPORT
	SaveAutoUpdateXML, ///< Set to save the XML returned from the auto update server to disk
	SpoofTime, ///< Holds the time of the last downloaded spoof file
	ThrottleLevel, ///< This setting holds the level at which to throttle an active update download when throttling is active
	ThrottlePeriod, ///< This setting holds the time in seconds of one period of throttling when throttling is active
	TimeOfLastUpdateCheck, ///< This setting holds the time of the last call home to Opera to check for updates
	UpdateCheckInterval, ///< This setting holds the interval Opera checks for updates (in seconds)
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	BrandedBannerHeight, ///< Height of branded banner (pixels)
	BrandedBannerWidth, ///< Width of branded banner (pixels)
#endif
#ifdef _BANNER_VERSION_
	TargetedAds, ///< Use targeted ads
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	UseBrandedBanner, ///< Enable branded banner
#endif
	ClearPrivateDataDialog_CheckFlags, ///< bit field for checkbox states
	CollectionSortType, ///< There are two types of sorting: a. Sort by date which has value 0   b. Sort by name which has value 1.  Default sorting is by date.
	CollectionSplitter, ///< Position of splitter in collection manager
	CollectionStyle, ///< There are two types of collection view style: a. Listview which has value 0.  b. Thumbnail-view which has value 1.  Default is set to thumbnail-view.
	CollectionZoomLevel, ///< Indicates current zoom level of collection's viewpane for thumbnail style. Default is 100%
	AskAboutFlashDownload, ///< Prompt about Flash Plug-in Download when Flash Plug-in is not available
	HotlistBookmarksManagerSplitter, ///< Position of splitter in bookmark manager
	HotlistBookmarksManagerStyle, ///< View mode for bookmarks manager
	HotlistBookmarksSplitter, ///< Position of splitter in bookmark panel
	HotlistBookmarksStyle, ///< View mode for bookmarks panel
	HotlistContactsManagerSplitter, ///< Position of splitter in contacts manager
	HotlistContactsManagerStyle, ///< View mode for contacts manager
	HotlistContactsSplitter, ///< Position of splitter in contacts panel
	HotlistContactsStyle, ///< View mode for contacts panel
	HotlistSingleClick, ///< Use single click in panels
	HotlistNotesSplitter, ///< Position of splitter in notes panel
#ifdef M2_SUPPORT
	HotlistShowAccountInfoDetails, ///< Show server status for each mail account
#endif
	HotlistSortAsc, ///< Sort hotlist ascending
	HotlistSortBy, ///< Order of hotlist sorting
	HotlistVisible, ///< Display hotlist
	HotlistSplitter, ///< Undocumented
	ImportedCustomBookmarks, ///< Filename of bookmarks that should be merged into existsing bookmarks on startup
	FirstRunTimestamp, ///< Unix timestamp of first run
#ifdef M2_SUPPORT
	MailHandler, ///< How to handle mail
#endif
	WebmailService, ///< ID of a webmail service to use for mailto URLs
	SoundsEnabled, ///< Enable program sounds
	SecondsBeforeAutoHome, ///< Time before returning to home page (seconds)
#ifdef PREFS_HAVE_LICENSE
	AcceptLicense, ///< Has accepted license agreement
#endif
	CountryCheck, ///< State of country check. Default value means it is not active (finished or not started).
	Running, ///< Already running?
	StartupTimestamp, ///< Timestamp from when Opera was started
	TotalUptime, ///< Total uptime in seconds since the last crash
	UpgradeCount, ///< Number of times this installation has been upgraded
	TransWinActivateOnNewTransfer, ///< Activate transfer window on new transfer, 0=not, 1=front, 2=background
	TransWinLogEntryDaysToLive, ///< Lifetime for transfer items (days)
	TransWinShowDetails, ///< Show detailed information
	ActivateTabOnClose, ///< Activate next tab behavior on closing tabs
	AddressSearchDropDownWeightedWidth, ///< New default weighted width of the address search drop down field
	AddressbarAlignment, ///< Position of address bar
	AddressbarInlineAutocompletion, ///< Automatic completion of previosly typed addresses inline in the addressfield.
	AddressDropdownMixSuggestions, ///< Switch for mixing search engine suggestions with history in the dropdown
	AllowContextMenus, ///< Show context menus
	AllowEmptyWorkspace, ///< Allow to close the last tab while maintaining an empty workspace
	AlternativePageCycleMode, ///< Cycle order when not displaying list of pages
#ifdef AUTO_UPDATE_SUPPORT
	AskAboutMissingDictionary, ///< Ask if we should use Autoupdate to install a dictionary matching Opera's UI language
#endif
#ifdef ENABLE_USAGE_REPORT
	AskForUsageStatsPercentage, ///< Percentage of users that will be asked if they want to participate in usage stats when installing or upgrading.
#endif
	CenterMouseButtonAction, ///< Decide what to do on a mid-click
	CheckForNewOpera, ///< Keeps track of the time of the next check. Set to 0 if no checking is to occur.
	ChromeIntegrationDragArea, ///< The height of the draggable area when the tabs are integrated in the window chrome
	ChromeIntegrationDragAreaMaximized, ///< The height of the draggable area when the tabs are integrated in the window chrome and the window is maximized
	ClickToMinimize, ///< Click a tab to minimize it
	ColorListRowMode, ///< Alternate background colours in listings
	ConfirmOpenBookmarkLimit, ///< Prompt if more than X bookmarks are opened
#ifdef SKIN_SUPPORT
	DebugSkin, ///< When set, will show information about the skin element in the tooltip hover
#endif
#ifdef INTEGRATED_DEVTOOLS_SUPPORT
	DevToolsIsAttached, ///< Last used state of developer tools window (attached or detached).
	DevToolsSplitter, ///< Splitter pos in in main window for integrated developer tools window. Set in pixels
#endif
	DimSearchOpacity, ///< Opacity for the dim effect used when using page search.
	DisableBookmarkImport, ///< Disable import of bookmarks on first run. Can be set on packaging/installation to prevent bookmark import from current default browser.
	DisableOperaPackageAutoUpdate, ///< Disables the autoupdate of Opera package
	ShowLanguageFileWarning, ///< Warning dialog for version conflicts
	DoubleclickToClose, ///< Close tab when doubleclicked
	EllipsisInCenter, ///< Shorten button and tab names in the middle
	EnableDrag, ///< Select elements to enable drag and drop for
	ExtendedKeyboardShortcuts, ///< When enabled, extended keyboard shortcuts (mostly single key shortcuts) are active
#ifdef FEATURE_SCROLL_MARKER
	EnableScrollMarker, ///< Enable the marker on the visual device, indicating the last position before scrolling
#endif
#ifdef SHOW_DISCOVERED_DEVICES_SUPPORT
	EnableServiceDiscoveryNotifications, ///< Preference that shows/hides discovered devices in the UI.
#endif
#ifdef QUICK
	EnableUIAnimations, ///< Enable animations in the UI.
#endif
#ifdef WEBSERVER_SUPPORT
	EnableUnite, ///< Preference for enabling unite services.
#endif
#ifdef ENABLE_USAGE_REPORT
	EnableUsageStatistics, ///< Enable generation and uploading of usage statistics.
#endif
#ifdef PREFS_HAVE_MIDDLE_MOUSEBUTTON_EXT
	ExtendedCenterMouseButtonAction, ///< 0 = start panning
#endif
	GoogleTLDDownloaded, ///< Set on a successful download of the google tld, and reset on every attempt to download the tld
	HasShownCenterClickInfo, ///< Mid-click configuration dialogue displayed
	HideURLParameter, ///< Hide URL parameter in address bar
	HistoryViewStyle, ///< View mode for history panel
	HotlistAlignment, ///< Position of hot list window
#ifdef AUTO_UPDATE_SUPPORT
	LevelOfUpdateAutomation, ///< This setting holds the level of automation in the automatic update system. The range is from 0 to 2, where 0 is no checking and 2 is automatic installation of security updates
#endif
#ifdef M2_SUPPORT
	LimitAttentionToPersonalChatMessages, ///< Notify new chat messages if they are to me
#endif
#ifdef LINK_BAR
	LinkBarPosition, ///< Position of LINK bar
#endif
	MainbarAlignment, ///< Position of main button bar
	MaxWidthForBookmarksInMenu, ///< Maximum width for bookmark items in the bookmarks menu
	MaximizeNewWindowsWhenAppropriate, ///< Maximize new windows when no other windows are displayed
	NavigationbarAlignment, ///< Position of site navigation bar
	NavigationbarAutoAlignment, ///< Display navigation bar when needed
#ifdef PREFS_HAVE_DISABLE_OPEN_SAVE
	NoOpen, ///< Disable all file open dialogs
	NoSave, ///< Disable all file save dialogs
#endif
#ifdef SUPPORT_SPEED_DIAL
	NumberOfSpeedDialColumns, ///< Number of speed dial columns
#endif
	OpenDraggedLinkInBackground, ///< Open in background window when dragging link in page
	OpenPageNextToCurrent, ///< Open page adjacent in page bar
#ifdef WEB_TURBO_MODE
	OperaTurboMode, ///< Opera Turbo Mode (0=auto, 1=on, 2=off)
#endif
	OperaUniteExitPolicy, ///< Decides if a dialog should be shown when Unite is running, or if Opera should be exited/hidden automatically
	PagebarAlignment, ///< Position of page bar
	PagebarAutoAlignment, ///< Display page bar when needed
	PagebarOpenURLOnMiddleClick, ///< Open url in clipboard when creating a new page
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	PagebarHeight, ///< Height of page bar if it has been resized
	PagebarWidth, ///< Width of page bar if it has been resized
#endif
#ifdef PERMANENT_HOMEPAGE_SUPPORT
	PermanentHomepage, ///< Removes all UI to change the homepage and startup type
#endif
	PersonalbarAlignment, ///< Position of personal bar
	PersonalbarInlineAlignment, ///< Position of the tab inline personal bar
	PopupButtonHelp, ///< Show help for buttons as popup
	WindowRecoveryStrategy, ///< Last used window recovery strategy
#ifdef ENABLE_USAGE_REPORT
	ReportTimeoutForUsageStatistics, ///< Set report timeout (in minutes) for usage statistics in order to alleviate testing
#endif
#ifdef WEBSERVER_SUPPORT
	RestartUniteServicesAfterCrash, ///< Option to restart Opera Unite services after a crash
#endif
	SDI, ///< Use SDI support
#ifdef SUPPORT_SPEED_DIAL
	ShowAddSpeedDialButton, ///< The Speed Dial should show the button for adding new speed dials
#endif
	ShowAddressInCaption, ///< Display URL in title bar instead of page title
	ShowCloseAllButActiveDialog, ///< Prompt when closing all but active document
	ShowCloseAllDialog, ///< Prompt when closing all documents
	ShowCloseButtons, ///< Show close buttons on each tab
	ShowCrashLogUploadDlg, ///< Show crash log upload dialogue after crash
	ShowDefaultBrowserDialog, ///< Show set default browser dialog on start
	ShowDisableJSCheckbox, ///< Show disable JS checkbox in JS dialogs
	ShowDownloadManagerSelectionDialog, ///< Show the download manager selection dialog where the user can choose a preferred tool
	ShowDropdownButtonInAddressfield, ///< Restores the dropdown button inside the address field
	ShowExitDialog, ///< Show exit dialog
	EnableAddressbarFavicons, ///< Show Favicons in addressbar dropdown
	ShowFullURL, ///< Show the full url in address bar
	ShowFullscreenExitInformation, ///< Show the fullscreen exit help overlay when entering fullscreeen
#ifdef DOM_GEOLOCATION_SUPPORT
	ShowGeolocationLicenseDialog, ///< Show the Geolocation license/privacy dialog on next use
#endif
	ShowGestureUI, ///< Show the mouse gesture UI when performing a gesture
	ShowHiddenToolbarsWhileCustomizing, ///< Display all toolbars when customizing
	ShowMailErrorDialog, ///< Show special dialog instead of console when mailer errors are posted to the console.
#if !defined _NO_MENU_TOGGLE_MENU_
	ShowMenu, ///< Show menu
#endif
#ifdef WEB_TURBO_MODE
	ShowNetworkSpeedNotification, ///< Should we show notification when detecting fast or slow network
#endif
	ShowNewOperaDialog, ///< Display a dialog if a new version is available when checking
	ShowNotificationForBlockedPopups, ///< Notify blocked popups
	ShowNotificationForFinishedTransfers, ///< Notify finished downloads
#ifdef M2_SUPPORT
	ShowNotificationForNewMessages, ///< Notify new messages
	ShowNotificationForNoNewMessages, ///< Notify on no new messages
#endif
	ShowNotificationsForWidgets, ///< Show widget notifications
#ifdef WEB_TURBO_MODE
	ShowOperaTurboInfo, ///< Set if we should open a turbo info page
#endif
	ShowPrivateIntroPage, ///< When set, will show private mode introduction page on starting a new private tab.
	ShowProblemDlg, ///< Show problem dialogue after crash
	ProgressPopup, ///< Type of progress bar display
	ShowProgressDlg, ///< Enable address bar
	ShowSearchesInAddressfieldAutocompletion, ///< Show search suggestions in addressfield dropdown.
#if !defined TARGETED_BANNER_SUPPORT
	ShowSetupdialogOnStart, ///< Show first-time setup dialog
#endif
	ShowStartupDialog, ///< Show dialog on startup, also when not recovering after crash.
#ifdef QUICK
	ShowTrayIcon, ///< Show an icon in the tray
#endif
#ifdef _VALIDATION_SUPPORT_
	ShowValidationDialog, ///< Ask about upload to external server for validation
#endif
#ifdef WIDGET_RUNTIME_SUPPORT
	ShowWidgetDebugInfoDialog, ///< Shows dialog with information about widget in debug mode
#endif
	ShowWindowMenu, ///< Show the window menu in the main menu
	ShowPanelToggle, ///< Display panel toggle
	SourceViewerMode, ///< Source viewer setting
#ifdef SUPPORT_SPEED_DIAL
	SpeedDialState, ///< Indicates the current state of the speed dial
	SpeedDialZoomLevel, ///< Indicates the current zoom level of the speed dial
#endif
	StartupType, ///< What to display when starting
	StatusbarAlignment, ///< Position of status bar
	StrategyOnApplicationCache, ///< What to do when a webpage requests saving offline cache
	TransferItemsAddedOnTop, ///< Show transfers in reverse chronological order
	TreeViewDropDownMaxLines, ///< Max number of lines to show in a tree view show in a drop down (i.e. Address bar drop down)
#ifdef WEB_TURBO_MODE
	TurboSNNotificationLeft, ///< Indicates how many more notifications comming from Turbo will be shown to the user
#endif
	UIPropertyExaminer, ///< Set to show quick widget and window properties in a tooltip to aid writing automated tests
#ifdef _INTERNAL_BUTTONSET_SUPPORT_
	UseExternalButtonSet, ///< Use external buttonset
#endif
	UseExternalDownloadManager, ///< Detect and use external download manager
	UseHTTPProxyForAllProtocols, ///< Use HTTP proxy server for all protocols
	UseIntegratedSearch, ///< Use inline search from search field
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	UseThumbnailsInsideTabs, ///< Use thumbnails inside tabs
#endif
#ifdef SUPPORT_GENERATE_THUMBNAILS
	UseThumbnailsInTabTooltips, ///< Use thumbnails when hovering over a tab
	UseThumbnailsInWindowCycle, ///< Use thumbnails when cycling between windows with Ctrl+Tab
#endif
#ifdef MSWIN
	UseWindows7TaskbarThumbnails, ///< Integrate with the Windows 7 taskbar thumbnails
#endif
#ifdef API_PRF_DESKTOP_UI
	VirtualKeyboardType, ///< Type of virtual keyboard to use. (0 standard for platform)
#endif
	WarnAboutActiveTransfersOnExit, ///< Prompt about active downloads when closing Opera
	WindowCycleType, ///< How to switch between windows
#ifdef WIDGET_RUNTIME_SUPPORT
	DisableWidgetRuntime, ///< Disables widget runtime
#endif

	DummyLastIntegerPref
};
#define PCUI_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionUI::DummyLastIntegerPref)

