/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionUI, PCUI_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef AUTO_UPDATE_SUPPORT
	P(SAutoUpdate, "Autoupdate Geo Server", UNI_L("https://autoupdate.geo.opera.com/")),
	P(SAutoUpdate, "Autoupdate Server", DEFAULT_AUTOUPDATE_SERVER),
#endif
	P(SAutoUpdate, "Country Code", UNI_L("")),
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	P(SBrand, "Branded Banner URL", UNI_L("")),
#endif
	P(SHotListWindow, "ActiveTab", 0),
	P(SHotListWindow, "Bookmarks Splitter Position", UNI_L("0.33")),
	P(SHotListWindow, "Contacts Splitter Position", UNI_L("0.33")),
	P(SInstall, "Custom Bookmark Merge File", UNI_L("")),
	P(SInstall, "First Used Version", UNI_L("")),
	P(SInstall, "Newest Used Beta Name", UNI_L("")),
	P(SInstall, "Newest Used Version", UNI_L("9.63.1")),
	P(SInstall, "One Time Page", UNI_L("")),
	P(SSounds, "Clicked", UNI_L("")),
	P(SSounds, "End", UNI_L("")),
	P(SSounds, "Failure", UNI_L("")),
	P(SSounds, "Loaded", UNI_L("")),
	P(SSounds, "Start", UNI_L("")),
	P(SSounds, "Transfer Done", UNI_L("")),
	P(SState, "Active Country Code", UNI_L("")),
	P(SState, "Active Default Language", UNI_L("")),
	P(SState, "Active Region", UNI_L("")),
	P(SState, "Data1", UNI_L("")),
	P(SState, "Data2", UNI_L("")),
	P(SState, "Data3", UNI_L("")),
	P(SState, "Data4", UNI_L("")),
	P(SState, "Detected Country Code", UNI_L("")),
	P(SState, "Upgrade From Version", UNI_L("")),
	P(SUserPrefs, "Country Code", UNI_L("")),
	P(SUserPrefs, "Crash Feedback Page", UNI_L("")),
	P(SUserPrefs, "Download Manager", UNI_L("")),
#ifdef OPERA_CONSOLE
	P(SUserPrefs, "Error Console Filter", UNI_L("mail=3")),
#endif
	P(SUserPrefs, "Extension Set Parent", UNI_L("Document Toolbar")),
	P(SUserPrefs, "Google TLD Default", UNI_L(".google.com")),
	P(SUserPrefs, "Google TLD URL", UNI_L("https://www.google.com/searchdomaincheck?format=domain")),
	P(SUserPrefs, "IntranetHosts", 0),
	P(SUserPrefs, "Language Codes File", UNI_L("")),
	P(SUserPrefs, "Newest Seen Version", UNI_L("")),
	P(SUserPrefs, "Tips Configuration", UNI_L("")),
	P(SUserPrefs, "Tips Meta Configuration", UNI_L("")),
	P(SUserPrefs, "Title", UNI_L("")),
	P(SUserPrefs, "User Email", UNI_L("")),
	P(SUserPrefs, "Validation Form Element", UNI_L("uploaded_file")),
	P(SUserPrefs, "Validation URL", UNI_L("http://validator.w3.org/check")),

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionUI, PCUI_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef AUTO_UPDATE_SUPPORT
	I(SAutoUpdate, "Add-ons Check Interval", 259200, prefssetting::integer),
	I(SAutoUpdate, "Auto Update Responded", FALSE, prefssetting::boolean),
	I(SAutoUpdate, "Auto Update State", 0, prefssetting::integer),
	I(SAutoUpdate, "Browser JS Time", 0, prefssetting::integer),
	I(SAutoUpdate, "Delayed Update Check Interval", 0, prefssetting::integer),
	I(SAutoUpdate, "Dictionary Time", 0, prefssetting::integer),
	I(SAutoUpdate, "Download All Snapshots", TRUE, prefssetting::boolean),
	I(SAutoUpdate, "Handlers Ignore Time", 0, prefssetting::integer),
	I(SAutoUpdate, "Hardware Blocklist Time", 0, prefssetting::integer),
#endif
#ifdef PLUGIN_AUTO_INSTALL
	I(SAutoUpdate, "Plugin Auto Install Enabled", TRUE, prefssetting::boolean),
	I(SAutoUpdate, "Plugin Auto Install Max Item Count", 20, prefssetting::integer),
#endif
#ifdef AUTO_UPDATE_SUPPORT
	I(SAutoUpdate, "Save Auto Update XML", FALSE, prefssetting::boolean),
	I(SAutoUpdate, "Spoof Time", 0, prefssetting::integer),
	I(SAutoUpdate, "Throttle Level", 5, prefssetting::integer),
	I(SAutoUpdate, "Throttle Period", 120, prefssetting::integer),
	I(SAutoUpdate, "Time Of Last Upgrade Check", 0, prefssetting::integer),
	I(SAutoUpdate, "Update Check Interval", 86400, prefssetting::integer),
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	I(SBrand, "Branded Banner Height", 60, prefssetting::integer),
	I(SBrand, "Branded Banner Width", 468, prefssetting::integer),
#endif
#ifdef _BANNER_VERSION_
	I(SBrand, "Targeted Ads", FALSE, prefssetting::boolean),
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	I(SBrand, "Use Branded Banner", FALSE, prefssetting::boolean),
#endif
	I(SClearPrivateDataDialog, "CheckFlags", 0, prefssetting::integer),
	I(SCollectionView, "Collection Sort Type", 0, prefssetting::integer),
	I(SCollectionView, "Collection Splitter", 0x3300, prefssetting::integer),
	I(SCollectionView, "Collection Style", 1, prefssetting::integer),
	I(SCollectionView, "Collection Zoom Level", 100, prefssetting::integer),
	I(SExtensions, "Ask Flash Download", TRUE, prefssetting::boolean),
	I(SHotListWindow, "Bookmarks Manager Splitter", 0x4000, prefssetting::integer),
	I(SHotListWindow, "Bookmarks Manager Style", 1, prefssetting::integer),
	I(SHotListWindow, "Bookmarks Splitter", 0x8000, prefssetting::integer),
	I(SHotListWindow, "Bookmarks Style", 0, prefssetting::integer),
	I(SHotListWindow, "Contacts Manager Splitter", 0x4000, prefssetting::integer),
	I(SHotListWindow, "Contacts Manager Style", 1, prefssetting::integer),
	I(SHotListWindow, "Contacts Splitter", 0x8000, prefssetting::integer),
	I(SHotListWindow, "Contacts Style", 0, prefssetting::integer),
	I(SHotListWindow, "Hotlist Single Click", TRUE, prefssetting::boolean),
	I(SHotListWindow, "Notes Splitter", 0x8000, prefssetting::integer),
#ifdef M2_SUPPORT
	I(SHotListWindow, "Show Accountinfo Details", 0, prefssetting::integer),
#endif
	I(SHotListWindow, "SortAsc", TRUE, prefssetting::integer),
	I(SHotListWindow, "SortBy", 0, prefssetting::integer),
	I(SHotListWindow, "Visible", TRUE, prefssetting::boolean),
	I(SHotListWindow, "cxDocked", 272, prefssetting::integer),
	I(SInstall, "Custom Bookmark Revision", 0, prefssetting::integer),
	I(SInstall, "First Run Timestamp", 0, prefssetting::integer),
#ifdef M2_SUPPORT
	I(SMail, "Handler", MAILHANDLER_OPERA, prefssetting::integer),
#endif
	I(SMail, "Webmail Service", 0, prefssetting::integer),
	I(SSounds, "Enabled", TRUE, prefssetting::boolean),
	I(SSpecial, "Go Home Time Out", 0, prefssetting::integer),
#ifdef PREFS_HAVE_LICENSE
	I(SState, "Accept License", DEFAULT_ACCEPT_LICENSE, prefssetting::integer),
#endif
	I(SState, "Country Check", 0, prefssetting::integer),
	I(SState, "Run", FALSE, prefssetting::boolean),
	I(SState, "Startup Timestamp", 0, prefssetting::integer),
	I(SState, "Total Uptime", 0, prefssetting::integer),
	I(SState, "Upgrade Count", 0, prefssetting::integer),
	I(STransferWindow, "Activate On New Transfer", 2, prefssetting::integer),
	I(STransferWindow, "Keep Entries Days", 7, prefssetting::integer),
	I(STransferWindow, "ShowDetails", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Activate Tab On Close", 0, prefssetting::integer),
	I(SUserPrefs, "Address Search Drop Down Weighted Width", DEFAULT_ADDRESS_SEARCH_DROP_DOWN_WIDTH, prefssetting::integer),
	I(SUserPrefs, "AddressBar Alignment", 2, prefssetting::integer),
	I(SUserPrefs, "Addressbar Inline Auto Completion", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Addressfield: mix search engine suggestions with history", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Allow Context Menus", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Allow Empty Workspace", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Alternative Page Cycle Mode", 1, prefssetting::integer),
#ifdef AUTO_UPDATE_SUPPORT
	I(SUserPrefs, "Ask About Missing Dictionary", TRUE, prefssetting::boolean),
#endif
#ifdef ENABLE_USAGE_REPORT
	I(SUserPrefs, "Ask For Usage Stats Percentage", 1, prefssetting::integer),
#endif
	I(SUserPrefs, "Center Mousebutton Action", 2, prefssetting::integer),
	I(SUserPrefs, "Check For New Opera", 1, prefssetting::integer),
	I(SUserPrefs, "Chrome Integration Drag Area", 20, prefssetting::integer),
	I(SUserPrefs, "Chrome Integration Drag Area Maximized", 1, prefssetting::integer),
	I(SUserPrefs, "Click To Minimize", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Color List Row Mode", 0, prefssetting::integer),
	I(SUserPrefs, "Confirm Open Bookmark Limit", 5, prefssetting::integer),
#ifdef SKIN_SUPPORT
	I(SUserPrefs, "Debug Skin", FALSE, prefssetting::boolean),
#endif
#ifdef INTEGRATED_DEVTOOLS_SUPPORT
	I(SUserPrefs, "DevTools Open Attached", TRUE, prefssetting::boolean),
	I(SUserPrefs, "DevTools Splitter Position", 500, prefssetting::integer),
#endif
	I(SUserPrefs, "Dim Search Opacity", 52, prefssetting::integer),
	I(SUserPrefs, "Disable Bookmark Import", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Disable Opera Package AutoUpdate", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Do Not Show Language Version Conflict Warning", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Doubleclick to Close Tab", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Ellipsis In Center", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Enable Drag", DRAG_ALL&(~DRAG_SAMEWINDOW), prefssetting::integer),
	I(SUserPrefs, "Enable Extended Keyboard Shortcuts", FALSE, prefssetting::boolean),
#ifdef FEATURE_SCROLL_MARKER
	I(SUserPrefs, "Enable Scroll Marker", 0, prefssetting::integer),
#endif
#ifdef SHOW_DISCOVERED_DEVICES_SUPPORT
	I(SUserPrefs, "Enable Service Discovery Notifications", TRUE, prefssetting::boolean),
#endif
#ifdef QUICK
	I(SUserPrefs, "Enable UI Animations", TRUE, prefssetting::boolean),
#endif
#ifdef WEBSERVER_SUPPORT
	I(SUserPrefs, "Enable Unite", FALSE, prefssetting::boolean),
#endif
#ifdef ENABLE_USAGE_REPORT
	I(SUserPrefs, "Enable Usage Statistics", TRUE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_MIDDLE_MOUSEBUTTON_EXT
	I(SUserPrefs, "Extended Center Mousebutton Action", 1, prefssetting::integer),
#endif
	I(SUserPrefs, "Google TLD Downloaded", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Has Shown Center Click Info", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Hide URL Parameter", TRUE, prefssetting::boolean),
	I(SUserPrefs, "History View Style", 0, prefssetting::integer),
	I(SUserPrefs, "Hotlist Alignment", 1, prefssetting::integer),
#ifdef AUTO_UPDATE_SUPPORT
	I(SUserPrefs, "Level Of Update Automation", 2, prefssetting::integer),
#endif
#ifdef M2_SUPPORT
	I(SUserPrefs, "Limit Task Bar Attention To Personal Chat Messages", TRUE, prefssetting::boolean),
#endif
#ifdef LINK_BAR
	I(SUserPrefs, "Linkbar Position", kLinkBarDefaultPosition, prefssetting::integer),
#endif
	I(SUserPrefs, "MainBar Alignment", 2, prefssetting::integer),
	I(SUserPrefs, "Max width for bookmarks in menu", 200, prefssetting::integer),
	I(SUserPrefs, "Maximize New Windows", 1, prefssetting::integer),
	I(SUserPrefs, "NavigationBar Alignment", 0, prefssetting::integer),
	I(SUserPrefs, "NavigationBar Auto Alignment", FALSE, prefssetting::boolean),
#ifdef PREFS_HAVE_DISABLE_OPEN_SAVE
	I(SUserPrefs, "No Open", FALSE, prefssetting::boolean),
	I(SUserPrefs, "No Save", FALSE, prefssetting::boolean),
#endif
#ifdef SUPPORT_SPEED_DIAL
	I(SUserPrefs, "Number Of Speed Dial Columns", 0, prefssetting::integer),
#endif
	I(SUserPrefs, "Open Dragged Link In Background", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Open Page Next To Current", FALSE, prefssetting::boolean),
#ifdef WEB_TURBO_MODE
	I(SUserPrefs, "Opera Turbo Mode", 2, prefssetting::integer),
#endif
	I(SUserPrefs, "Opera Unite exit policy", ExitStrategyConfirm, prefssetting::integer),
	I(SUserPrefs, "PageBar Alignment", 2, prefssetting::integer),
	I(SUserPrefs, "PageBar Auto Alignment", FALSE, prefssetting::integer),
	I(SUserPrefs, "PageBar Open URL On MiddleClick", DEFAULT_PAGEBAR_OPEN_URL_ON_MIDDLE_CLICK, prefssetting::boolean),
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	I(SUserPrefs, "Pagebar Height", 0, prefssetting::integer),
	I(SUserPrefs, "Pagebar Width", 0, prefssetting::integer),
#endif
#ifdef PERMANENT_HOMEPAGE_SUPPORT
	I(SUserPrefs, "Permanent Homepage", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "PersonalBar Alignment", 0, prefssetting::integer),
	I(SUserPrefs, "PersonalBar Inline Alignment", 2, prefssetting::integer),
	I(SUserPrefs, "Popup Button Help", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Recovery Strategy", Restore_RegularStartup, prefssetting::integer),
#ifdef ENABLE_USAGE_REPORT
	I(SUserPrefs, "Report Timeout For Usage Statistics", 60, prefssetting::integer),
#endif
#ifdef WEBSERVER_SUPPORT
	I(SUserPrefs, "Restart Unite Services After Crash", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "SDI", FALSE, prefssetting::boolean),
#ifdef SUPPORT_SPEED_DIAL
	I(SUserPrefs, "Show Add Speed Dial Button", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Address In Caption", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Close All But Active Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Close All Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Close Buttons", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Crash Log Upload Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Default Browser Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Disable JS Checkbox", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Download Manager Selection Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Dropdown Button In Addressfield", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Exit Dialog", ExitStrategyExit, prefssetting::integer),
	I(SUserPrefs, "Show Favicons in Addressfield", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Full URL", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Fullscreen Exit Information", TRUE, prefssetting::boolean),
#ifdef DOM_GEOLOCATION_SUPPORT
	I(SUserPrefs, "Show Geolocation License Dialog", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Gesture UI", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Hidden Toolbars While Customizing", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show Mail Error Dialog", TRUE, prefssetting::boolean),
#if !defined _NO_MENU_TOGGLE_MENU_
	I(SUserPrefs, "Show Menu", FALSE, prefssetting::boolean),
#endif
#ifdef WEB_TURBO_MODE
	I(SUserPrefs, "Show Network Speed Notification", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show New Opera Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Notification For Blocked Popups", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Notification For Finished Transfers", TRUE, prefssetting::boolean),
#ifdef M2_SUPPORT
	I(SUserPrefs, "Show Notification For New Messages", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Notification For No New Messages", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Notifications For Widgets", TRUE, prefssetting::boolean),
#ifdef WEB_TURBO_MODE
	I(SUserPrefs, "Show Opera Turbo Info", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Private Mode Introduction Page", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Problem Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Progress As Popup", 2, prefssetting::integer),
	I(SUserPrefs, "Show Progress Dialog", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Show Search Suggestions In Addressfield Dropdown", TRUE, prefssetting::boolean),
#if !defined TARGETED_BANNER_SUPPORT
	I(SUserPrefs, "Show Setupdialog On Start", 1, prefssetting::integer),
#endif
	I(SUserPrefs, "Show Startup Dialog", FALSE, prefssetting::boolean),
#ifdef QUICK
	I(SUserPrefs, "Show Tray Icon", TRUE, prefssetting::boolean),
#endif
#ifdef _VALIDATION_SUPPORT_
	I(SUserPrefs, "Show Validation Dialog", TRUE, prefssetting::boolean),
#endif
#ifdef WIDGET_RUNTIME_SUPPORT
	I(SUserPrefs, "Show Widget Debug Info Dialog", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Window Menu", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Show panel toggle", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Source Viewer Mode", UseInternalApplication, prefssetting::integer),
#ifdef SUPPORT_SPEED_DIAL
	I(SUserPrefs, "Speed Dial State", 1, prefssetting::integer),
	I(SUserPrefs, "Speed Dial Zoom Level", 0, prefssetting::integer),
#endif
	I(SUserPrefs, "Startup Type", STARTUP_CONTINUE, prefssetting::integer),
	I(SUserPrefs, "StatusBar Alignment", 4, prefssetting::integer),
	I(SUserPrefs, "Strategy On Application Cache", 1, prefssetting::integer),
	I(SUserPrefs, "Transfers Added On Top", TRUE, prefssetting::boolean),
	I(SUserPrefs, "TreeView DropDown Max Lines", 20, prefssetting::integer),
#ifdef WEB_TURBO_MODE
	I(SUserPrefs, "Turbo Slow Network Notifications Left", 2, prefssetting::integer),
#endif
	I(SUserPrefs, "UI Property Examiner", FALSE, prefssetting::boolean),
#ifdef _INTERNAL_BUTTONSET_SUPPORT_
	I(SUserPrefs, "Use External Button Set", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Use External Download Manager", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Use HTTP Proxy For All Protocols", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Use Integrated Search", FALSE, prefssetting::boolean),
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	I(SUserPrefs, "Use Thumbnails Inside Tabs", TRUE, prefssetting::boolean),
#endif
#ifdef SUPPORT_GENERATE_THUMBNAILS
	I(SUserPrefs, "Use Thumbnails in Tab Tooltips", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Use Thumbnails in Window Cycle", DEFAULT_THUMBNAILS_IN_WINDOWS_CYCLE, prefssetting::boolean),
#endif
#ifdef MSWIN
	I(SUserPrefs, "Use Windows 7 Taskbar Thumbnails", FALSE, prefssetting::boolean),
#endif
#ifdef API_PRF_DESKTOP_UI
	I(SUserPrefs, "Virtual Keyboard Type", 0, prefssetting::integer),
#endif
	I(SUserPrefs, "Warn about active transfers on exit", ExitStrategyConfirm, prefssetting::integer),
	I(SUserPrefs, "Window Cycle Type", WINDOW_CYCLE_TYPE_STACK, prefssetting::integer),
#ifdef WIDGET_RUNTIME_SUPPORT
	I(SWidgets, "Disable Widget Runtime", TRUE, prefssetting::boolean),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionUI::stringpref e)
{
	switch (e) {
#ifdef AUTO_UPDATE_SUPPORT
	case PrefsCollectionUI::AutoUpdateGeoServer:
		return dbg << "PrefsCollectionUI::AutoUpdateGeoServer";
	case PrefsCollectionUI::AutoUpdateServer:
		return dbg << "PrefsCollectionUI::AutoUpdateServer";
#endif
	case PrefsCollectionUI::AuCountryCode:
		return dbg << "PrefsCollectionUI::AuCountryCode";
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	case PrefsCollectionUI::BrandedBannerURL:
		return dbg << "PrefsCollectionUI::BrandedBannerURL";
#endif
	case PrefsCollectionUI::HotlistActiveTab:
		return dbg << "PrefsCollectionUI::HotlistActiveTab";
	case PrefsCollectionUI::HotlistBookmarksYSplitter:
		return dbg << "PrefsCollectionUI::HotlistBookmarksYSplitter";
	case PrefsCollectionUI::HotlistContactsYSplitter:
		return dbg << "PrefsCollectionUI::HotlistContactsYSplitter";
	case PrefsCollectionUI::CustomBookmarkImportFilename:
		return dbg << "PrefsCollectionUI::CustomBookmarkImportFilename";
	case PrefsCollectionUI::FirstVersionRun:
		return dbg << "PrefsCollectionUI::FirstVersionRun";
	case PrefsCollectionUI::NewestUsedBetaName:
		return dbg << "PrefsCollectionUI::NewestUsedBetaName";
	case PrefsCollectionUI::MaxVersionRun:
		return dbg << "PrefsCollectionUI::MaxVersionRun";
	case PrefsCollectionUI::OneTimePage:
		return dbg << "PrefsCollectionUI::OneTimePage";
	case PrefsCollectionUI::ClickedSound:
		return dbg << "PrefsCollectionUI::ClickedSound";
	case PrefsCollectionUI::EndSound:
		return dbg << "PrefsCollectionUI::EndSound";
	case PrefsCollectionUI::FailureSound:
		return dbg << "PrefsCollectionUI::FailureSound";
	case PrefsCollectionUI::LoadedSound:
		return dbg << "PrefsCollectionUI::LoadedSound";
	case PrefsCollectionUI::StartSound:
		return dbg << "PrefsCollectionUI::StartSound";
	case PrefsCollectionUI::TransferDoneSound:
		return dbg << "PrefsCollectionUI::TransferDoneSound";
	case PrefsCollectionUI::ActiveCountryCode:
		return dbg << "PrefsCollectionUI::ActiveCountryCode";
	case PrefsCollectionUI::ActiveDefaultLanguage:
		return dbg << "PrefsCollectionUI::ActiveDefaultLanguage";
	case PrefsCollectionUI::ActiveRegion:
		return dbg << "PrefsCollectionUI::ActiveRegion";
	case PrefsCollectionUI::IdOfHardcodedDefaultSearch:
		return dbg << "PrefsCollectionUI::IdOfHardcodedDefaultSearch";
	case PrefsCollectionUI::HashOfDefaultSearch:
		return dbg << "PrefsCollectionUI::HashOfDefaultSearch";
	case PrefsCollectionUI::IdOfHardcodedSpeedDialSearch:
		return dbg << "PrefsCollectionUI::IdOfHardcodedSpeedDialSearch";
	case PrefsCollectionUI::HashOfSpeedDialSearch:
		return dbg << "PrefsCollectionUI::HashOfSpeedDialSearch";
	case PrefsCollectionUI::DetectedCountryCode:
		return dbg << "PrefsCollectionUI::DetectedCountryCode";
	case PrefsCollectionUI::UpgradeFromVersion:
		return dbg << "PrefsCollectionUI::UpgradeFromVersion";
	case PrefsCollectionUI::CountryCode:
		return dbg << "PrefsCollectionUI::CountryCode";
	case PrefsCollectionUI::CrashFeedbackPage:
		return dbg << "PrefsCollectionUI::CrashFeedbackPage";
	case PrefsCollectionUI::DownloadManager:
		return dbg << "PrefsCollectionUI::DownloadManager";
#ifdef OPERA_CONSOLE
	case PrefsCollectionUI::ErrorConsoleFilter:
		return dbg << "PrefsCollectionUI::ErrorConsoleFilter";
#endif
	case PrefsCollectionUI::ExtensionSetParent:
		return dbg << "PrefsCollectionUI::ExtensionSetParent";
	case PrefsCollectionUI::GoogleTLDDefault:
		return dbg << "PrefsCollectionUI::GoogleTLDDefault";
	case PrefsCollectionUI::GoogleTLDServer:
		return dbg << "PrefsCollectionUI::GoogleTLDServer";
	case PrefsCollectionUI::IntranetHosts:
		return dbg << "PrefsCollectionUI::IntranetHosts";
	case PrefsCollectionUI::LanguageCodesFileName:
		return dbg << "PrefsCollectionUI::LanguageCodesFileName";
	case PrefsCollectionUI::NewestSeenVersion:
		return dbg << "PrefsCollectionUI::NewestSeenVersion";
	case PrefsCollectionUI::TipsConfigFile:
		return dbg << "PrefsCollectionUI::TipsConfigFile";
	case PrefsCollectionUI::TipsConfigMetaFile:
		return dbg << "PrefsCollectionUI::TipsConfigMetaFile";
	case PrefsCollectionUI::ProgramTitle:
		return dbg << "PrefsCollectionUI::ProgramTitle";
	case PrefsCollectionUI::UserEmail:
		return dbg << "PrefsCollectionUI::UserEmail";
	case PrefsCollectionUI::ValidationForm:
		return dbg << "PrefsCollectionUI::ValidationForm";
	case PrefsCollectionUI::ValidationURL:
		return dbg << "PrefsCollectionUI::ValidationURL";
	default:
		return dbg << "PrefsCollectionUI::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionUI::integerpref e)
{
	switch (e) {
#ifdef AUTO_UPDATE_SUPPORT
	case PrefsCollectionUI::UpdateCheckIntervalGadgets:
		return dbg << "PrefsCollectionUI::UpdateCheckIntervalGadgets";
	case PrefsCollectionUI::AutoUpdateResponded:
		return dbg << "PrefsCollectionUI::AutoUpdateResponded";
	case PrefsCollectionUI::AutoUpdateState:
		return dbg << "PrefsCollectionUI::AutoUpdateState";
	case PrefsCollectionUI::BrowserJSTime:
		return dbg << "PrefsCollectionUI::BrowserJSTime";
	case PrefsCollectionUI::DelayedUpdateCheckInterval:
		return dbg << "PrefsCollectionUI::DelayedUpdateCheckInterval";
	case PrefsCollectionUI::DictionaryTime:
		return dbg << "PrefsCollectionUI::DictionaryTime";
	case PrefsCollectionUI::DownloadAllSnapshots:
		return dbg << "PrefsCollectionUI::DownloadAllSnapshots";
	case PrefsCollectionUI::HandlersIgnoreTime:
		return dbg << "PrefsCollectionUI::HandlersIgnoreTime";
	case PrefsCollectionUI::HardwareBlocklistTime:
		return dbg << "PrefsCollectionUI::HardwareBlocklistTime";
#endif
#ifdef PLUGIN_AUTO_INSTALL
	case PrefsCollectionUI::PluginAutoInstallEnabled:
		return dbg << "PrefsCollectionUI::PluginAutoInstallEnabled";
	case PrefsCollectionUI::PluginAutoInstallMaxItems:
		return dbg << "PrefsCollectionUI::PluginAutoInstallMaxItems";
#endif
#ifdef AUTO_UPDATE_SUPPORT
	case PrefsCollectionUI::SaveAutoUpdateXML:
		return dbg << "PrefsCollectionUI::SaveAutoUpdateXML";
	case PrefsCollectionUI::SpoofTime:
		return dbg << "PrefsCollectionUI::SpoofTime";
	case PrefsCollectionUI::ThrottleLevel:
		return dbg << "PrefsCollectionUI::ThrottleLevel";
	case PrefsCollectionUI::ThrottlePeriod:
		return dbg << "PrefsCollectionUI::ThrottlePeriod";
	case PrefsCollectionUI::TimeOfLastUpdateCheck:
		return dbg << "PrefsCollectionUI::TimeOfLastUpdateCheck";
	case PrefsCollectionUI::UpdateCheckInterval:
		return dbg << "PrefsCollectionUI::UpdateCheckInterval";
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	case PrefsCollectionUI::BrandedBannerHeight:
		return dbg << "PrefsCollectionUI::BrandedBannerHeight";
	case PrefsCollectionUI::BrandedBannerWidth:
		return dbg << "PrefsCollectionUI::BrandedBannerWidth";
#endif
#ifdef _BANNER_VERSION_
	case PrefsCollectionUI::TargetedAds:
		return dbg << "PrefsCollectionUI::TargetedAds";
#endif
#if defined BRANDED_BANNER_WITHOUT_REGISTRATION || defined TARGETED_BANNER_SUPPORT
	case PrefsCollectionUI::UseBrandedBanner:
		return dbg << "PrefsCollectionUI::UseBrandedBanner";
#endif
	case PrefsCollectionUI::ClearPrivateDataDialog_CheckFlags:
		return dbg << "PrefsCollectionUI::ClearPrivateDataDialog_CheckFlags";
	case PrefsCollectionUI::CollectionSortType:
		return dbg << "PrefsCollectionUI::CollectionSortType";
	case PrefsCollectionUI::CollectionSplitter:
		return dbg << "PrefsCollectionUI::CollectionSplitter";
	case PrefsCollectionUI::CollectionStyle:
		return dbg << "PrefsCollectionUI::CollectionStyle";
	case PrefsCollectionUI::CollectionZoomLevel:
		return dbg << "PrefsCollectionUI::CollectionZoomLevel";
	case PrefsCollectionUI::AskAboutFlashDownload:
		return dbg << "PrefsCollectionUI::AskAboutFlashDownload";
	case PrefsCollectionUI::HotlistBookmarksManagerSplitter:
		return dbg << "PrefsCollectionUI::HotlistBookmarksManagerSplitter";
	case PrefsCollectionUI::HotlistBookmarksManagerStyle:
		return dbg << "PrefsCollectionUI::HotlistBookmarksManagerStyle";
	case PrefsCollectionUI::HotlistBookmarksSplitter:
		return dbg << "PrefsCollectionUI::HotlistBookmarksSplitter";
	case PrefsCollectionUI::HotlistBookmarksStyle:
		return dbg << "PrefsCollectionUI::HotlistBookmarksStyle";
	case PrefsCollectionUI::HotlistContactsManagerSplitter:
		return dbg << "PrefsCollectionUI::HotlistContactsManagerSplitter";
	case PrefsCollectionUI::HotlistContactsManagerStyle:
		return dbg << "PrefsCollectionUI::HotlistContactsManagerStyle";
	case PrefsCollectionUI::HotlistContactsSplitter:
		return dbg << "PrefsCollectionUI::HotlistContactsSplitter";
	case PrefsCollectionUI::HotlistContactsStyle:
		return dbg << "PrefsCollectionUI::HotlistContactsStyle";
	case PrefsCollectionUI::HotlistSingleClick:
		return dbg << "PrefsCollectionUI::HotlistSingleClick";
	case PrefsCollectionUI::HotlistNotesSplitter:
		return dbg << "PrefsCollectionUI::HotlistNotesSplitter";
#ifdef M2_SUPPORT
	case PrefsCollectionUI::HotlistShowAccountInfoDetails:
		return dbg << "PrefsCollectionUI::HotlistShowAccountInfoDetails";
#endif
	case PrefsCollectionUI::HotlistSortAsc:
		return dbg << "PrefsCollectionUI::HotlistSortAsc";
	case PrefsCollectionUI::HotlistSortBy:
		return dbg << "PrefsCollectionUI::HotlistSortBy";
	case PrefsCollectionUI::HotlistVisible:
		return dbg << "PrefsCollectionUI::HotlistVisible";
	case PrefsCollectionUI::HotlistSplitter:
		return dbg << "PrefsCollectionUI::HotlistSplitter";
	case PrefsCollectionUI::ImportedCustomBookmarks:
		return dbg << "PrefsCollectionUI::ImportedCustomBookmarks";
	case PrefsCollectionUI::FirstRunTimestamp:
		return dbg << "PrefsCollectionUI::FirstRunTimestamp";
#ifdef M2_SUPPORT
	case PrefsCollectionUI::MailHandler:
		return dbg << "PrefsCollectionUI::MailHandler";
#endif
	case PrefsCollectionUI::WebmailService:
		return dbg << "PrefsCollectionUI::WebmailService";
	case PrefsCollectionUI::SoundsEnabled:
		return dbg << "PrefsCollectionUI::SoundsEnabled";
	case PrefsCollectionUI::SecondsBeforeAutoHome:
		return dbg << "PrefsCollectionUI::SecondsBeforeAutoHome";
#ifdef PREFS_HAVE_LICENSE
	case PrefsCollectionUI::AcceptLicense:
		return dbg << "PrefsCollectionUI::AcceptLicense";
#endif
	case PrefsCollectionUI::CountryCheck:
		return dbg << "PrefsCollectionUI::CountryCheck";
	case PrefsCollectionUI::Running:
		return dbg << "PrefsCollectionUI::Running";
	case PrefsCollectionUI::StartupTimestamp:
		return dbg << "PrefsCollectionUI::StartupTimestamp";
	case PrefsCollectionUI::TotalUptime:
		return dbg << "PrefsCollectionUI::TotalUptime";
	case PrefsCollectionUI::UpgradeCount:
		return dbg << "PrefsCollectionUI::UpgradeCount";
	case PrefsCollectionUI::TransWinActivateOnNewTransfer:
		return dbg << "PrefsCollectionUI::TransWinActivateOnNewTransfer";
	case PrefsCollectionUI::TransWinLogEntryDaysToLive:
		return dbg << "PrefsCollectionUI::TransWinLogEntryDaysToLive";
	case PrefsCollectionUI::TransWinShowDetails:
		return dbg << "PrefsCollectionUI::TransWinShowDetails";
	case PrefsCollectionUI::ActivateTabOnClose:
		return dbg << "PrefsCollectionUI::ActivateTabOnClose";
	case PrefsCollectionUI::AddressSearchDropDownWeightedWidth:
		return dbg << "PrefsCollectionUI::AddressSearchDropDownWeightedWidth";
	case PrefsCollectionUI::AddressbarAlignment:
		return dbg << "PrefsCollectionUI::AddressbarAlignment";
	case PrefsCollectionUI::AddressbarInlineAutocompletion:
		return dbg << "PrefsCollectionUI::AddressbarInlineAutocompletion";
	case PrefsCollectionUI::AddressDropdownMixSuggestions:
		return dbg << "PrefsCollectionUI::AddressDropdownMixSuggestions";
	case PrefsCollectionUI::AllowContextMenus:
		return dbg << "PrefsCollectionUI::AllowContextMenus";
	case PrefsCollectionUI::AllowEmptyWorkspace:
		return dbg << "PrefsCollectionUI::AllowEmptyWorkspace";
	case PrefsCollectionUI::AlternativePageCycleMode:
		return dbg << "PrefsCollectionUI::AlternativePageCycleMode";
#ifdef AUTO_UPDATE_SUPPORT
	case PrefsCollectionUI::AskAboutMissingDictionary:
		return dbg << "PrefsCollectionUI::AskAboutMissingDictionary";
#endif
#ifdef ENABLE_USAGE_REPORT
	case PrefsCollectionUI::AskForUsageStatsPercentage:
		return dbg << "PrefsCollectionUI::AskForUsageStatsPercentage";
#endif
	case PrefsCollectionUI::CenterMouseButtonAction:
		return dbg << "PrefsCollectionUI::CenterMouseButtonAction";
	case PrefsCollectionUI::CheckForNewOpera:
		return dbg << "PrefsCollectionUI::CheckForNewOpera";
	case PrefsCollectionUI::ChromeIntegrationDragArea:
		return dbg << "PrefsCollectionUI::ChromeIntegrationDragArea";
	case PrefsCollectionUI::ChromeIntegrationDragAreaMaximized:
		return dbg << "PrefsCollectionUI::ChromeIntegrationDragAreaMaximized";
	case PrefsCollectionUI::ClickToMinimize:
		return dbg << "PrefsCollectionUI::ClickToMinimize";
	case PrefsCollectionUI::ColorListRowMode:
		return dbg << "PrefsCollectionUI::ColorListRowMode";
	case PrefsCollectionUI::ConfirmOpenBookmarkLimit:
		return dbg << "PrefsCollectionUI::ConfirmOpenBookmarkLimit";
#ifdef SKIN_SUPPORT
	case PrefsCollectionUI::DebugSkin:
		return dbg << "PrefsCollectionUI::DebugSkin";
#endif
#ifdef INTEGRATED_DEVTOOLS_SUPPORT
	case PrefsCollectionUI::DevToolsIsAttached:
		return dbg << "PrefsCollectionUI::DevToolsIsAttached";
	case PrefsCollectionUI::DevToolsSplitter:
		return dbg << "PrefsCollectionUI::DevToolsSplitter";
#endif
	case PrefsCollectionUI::DimSearchOpacity:
		return dbg << "PrefsCollectionUI::DimSearchOpacity";
	case PrefsCollectionUI::DisableBookmarkImport:
		return dbg << "PrefsCollectionUI::DisableBookmarkImport";
	case PrefsCollectionUI::DisableOperaPackageAutoUpdate:
		return dbg << "PrefsCollectionUI::DisableOperaPackageAutoUpdate";
	case PrefsCollectionUI::ShowLanguageFileWarning:
		return dbg << "PrefsCollectionUI::ShowLanguageFileWarning";
	case PrefsCollectionUI::DoubleclickToClose:
		return dbg << "PrefsCollectionUI::DoubleclickToClose";
	case PrefsCollectionUI::EllipsisInCenter:
		return dbg << "PrefsCollectionUI::EllipsisInCenter";
	case PrefsCollectionUI::EnableDrag:
		return dbg << "PrefsCollectionUI::EnableDrag";
	case PrefsCollectionUI::ExtendedKeyboardShortcuts:
		return dbg << "PrefsCollectionUI::ExtendedKeyboardShortcuts";
#ifdef FEATURE_SCROLL_MARKER
	case PrefsCollectionUI::EnableScrollMarker:
		return dbg << "PrefsCollectionUI::EnableScrollMarker";
#endif
#ifdef SHOW_DISCOVERED_DEVICES_SUPPORT
	case PrefsCollectionUI::EnableServiceDiscoveryNotifications:
		return dbg << "PrefsCollectionUI::EnableServiceDiscoveryNotifications";
#endif
#ifdef QUICK
	case PrefsCollectionUI::EnableUIAnimations:
		return dbg << "PrefsCollectionUI::EnableUIAnimations";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionUI::EnableUnite:
		return dbg << "PrefsCollectionUI::EnableUnite";
#endif
#ifdef ENABLE_USAGE_REPORT
	case PrefsCollectionUI::EnableUsageStatistics:
		return dbg << "PrefsCollectionUI::EnableUsageStatistics";
#endif
#ifdef PREFS_HAVE_MIDDLE_MOUSEBUTTON_EXT
	case PrefsCollectionUI::ExtendedCenterMouseButtonAction:
		return dbg << "PrefsCollectionUI::ExtendedCenterMouseButtonAction";
#endif
	case PrefsCollectionUI::GoogleTLDDownloaded:
		return dbg << "PrefsCollectionUI::GoogleTLDDownloaded";
	case PrefsCollectionUI::HasShownCenterClickInfo:
		return dbg << "PrefsCollectionUI::HasShownCenterClickInfo";
	case PrefsCollectionUI::HideURLParameter:
		return dbg << "PrefsCollectionUI::HideURLParameter";
	case PrefsCollectionUI::HistoryViewStyle:
		return dbg << "PrefsCollectionUI::HistoryViewStyle";
	case PrefsCollectionUI::HotlistAlignment:
		return dbg << "PrefsCollectionUI::HotlistAlignment";
#ifdef AUTO_UPDATE_SUPPORT
	case PrefsCollectionUI::LevelOfUpdateAutomation:
		return dbg << "PrefsCollectionUI::LevelOfUpdateAutomation";
#endif
#ifdef M2_SUPPORT
	case PrefsCollectionUI::LimitAttentionToPersonalChatMessages:
		return dbg << "PrefsCollectionUI::LimitAttentionToPersonalChatMessages";
#endif
#ifdef LINK_BAR
	case PrefsCollectionUI::LinkBarPosition:
		return dbg << "PrefsCollectionUI::LinkBarPosition";
#endif
	case PrefsCollectionUI::MainbarAlignment:
		return dbg << "PrefsCollectionUI::MainbarAlignment";
	case PrefsCollectionUI::MaxWidthForBookmarksInMenu:
		return dbg << "PrefsCollectionUI::MaxWidthForBookmarksInMenu";
	case PrefsCollectionUI::MaximizeNewWindowsWhenAppropriate:
		return dbg << "PrefsCollectionUI::MaximizeNewWindowsWhenAppropriate";
	case PrefsCollectionUI::NavigationbarAlignment:
		return dbg << "PrefsCollectionUI::NavigationbarAlignment";
	case PrefsCollectionUI::NavigationbarAutoAlignment:
		return dbg << "PrefsCollectionUI::NavigationbarAutoAlignment";
#ifdef PREFS_HAVE_DISABLE_OPEN_SAVE
	case PrefsCollectionUI::NoOpen:
		return dbg << "PrefsCollectionUI::NoOpen";
	case PrefsCollectionUI::NoSave:
		return dbg << "PrefsCollectionUI::NoSave";
#endif
#ifdef SUPPORT_SPEED_DIAL
	case PrefsCollectionUI::NumberOfSpeedDialColumns:
		return dbg << "PrefsCollectionUI::NumberOfSpeedDialColumns";
#endif
	case PrefsCollectionUI::OpenDraggedLinkInBackground:
		return dbg << "PrefsCollectionUI::OpenDraggedLinkInBackground";
	case PrefsCollectionUI::OpenPageNextToCurrent:
		return dbg << "PrefsCollectionUI::OpenPageNextToCurrent";
#ifdef WEB_TURBO_MODE
	case PrefsCollectionUI::OperaTurboMode:
		return dbg << "PrefsCollectionUI::OperaTurboMode";
#endif
	case PrefsCollectionUI::OperaUniteExitPolicy:
		return dbg << "PrefsCollectionUI::OperaUniteExitPolicy";
	case PrefsCollectionUI::PagebarAlignment:
		return dbg << "PrefsCollectionUI::PagebarAlignment";
	case PrefsCollectionUI::PagebarAutoAlignment:
		return dbg << "PrefsCollectionUI::PagebarAutoAlignment";
	case PrefsCollectionUI::PagebarOpenURLOnMiddleClick:
		return dbg << "PrefsCollectionUI::PagebarOpenURLOnMiddleClick";
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	case PrefsCollectionUI::PagebarHeight:
		return dbg << "PrefsCollectionUI::PagebarHeight";
	case PrefsCollectionUI::PagebarWidth:
		return dbg << "PrefsCollectionUI::PagebarWidth";
#endif
#ifdef PERMANENT_HOMEPAGE_SUPPORT
	case PrefsCollectionUI::PermanentHomepage:
		return dbg << "PrefsCollectionUI::PermanentHomepage";
#endif
	case PrefsCollectionUI::PersonalbarAlignment:
		return dbg << "PrefsCollectionUI::PersonalbarAlignment";
	case PrefsCollectionUI::PersonalbarInlineAlignment:
		return dbg << "PrefsCollectionUI::PersonalbarInlineAlignment";
	case PrefsCollectionUI::PopupButtonHelp:
		return dbg << "PrefsCollectionUI::PopupButtonHelp";
	case PrefsCollectionUI::WindowRecoveryStrategy:
		return dbg << "PrefsCollectionUI::WindowRecoveryStrategy";
#ifdef ENABLE_USAGE_REPORT
	case PrefsCollectionUI::ReportTimeoutForUsageStatistics:
		return dbg << "PrefsCollectionUI::ReportTimeoutForUsageStatistics";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionUI::RestartUniteServicesAfterCrash:
		return dbg << "PrefsCollectionUI::RestartUniteServicesAfterCrash";
#endif
	case PrefsCollectionUI::SDI:
		return dbg << "PrefsCollectionUI::SDI";
#ifdef SUPPORT_SPEED_DIAL
	case PrefsCollectionUI::ShowAddSpeedDialButton:
		return dbg << "PrefsCollectionUI::ShowAddSpeedDialButton";
#endif
	case PrefsCollectionUI::ShowAddressInCaption:
		return dbg << "PrefsCollectionUI::ShowAddressInCaption";
	case PrefsCollectionUI::ShowCloseAllButActiveDialog:
		return dbg << "PrefsCollectionUI::ShowCloseAllButActiveDialog";
	case PrefsCollectionUI::ShowCloseAllDialog:
		return dbg << "PrefsCollectionUI::ShowCloseAllDialog";
	case PrefsCollectionUI::ShowCloseButtons:
		return dbg << "PrefsCollectionUI::ShowCloseButtons";
	case PrefsCollectionUI::ShowCrashLogUploadDlg:
		return dbg << "PrefsCollectionUI::ShowCrashLogUploadDlg";
	case PrefsCollectionUI::ShowDefaultBrowserDialog:
		return dbg << "PrefsCollectionUI::ShowDefaultBrowserDialog";
	case PrefsCollectionUI::ShowDisableJSCheckbox:
		return dbg << "PrefsCollectionUI::ShowDisableJSCheckbox";
	case PrefsCollectionUI::ShowDownloadManagerSelectionDialog:
		return dbg << "PrefsCollectionUI::ShowDownloadManagerSelectionDialog";
	case PrefsCollectionUI::ShowDropdownButtonInAddressfield:
		return dbg << "PrefsCollectionUI::ShowDropdownButtonInAddressfield";
	case PrefsCollectionUI::ShowExitDialog:
		return dbg << "PrefsCollectionUI::ShowExitDialog";
	case PrefsCollectionUI::EnableAddressbarFavicons:
		return dbg << "PrefsCollectionUI::EnableAddressbarFavicons";
	case PrefsCollectionUI::ShowFullURL:
		return dbg << "PrefsCollectionUI::ShowFullURL";
	case PrefsCollectionUI::ShowFullscreenExitInformation:
		return dbg << "PrefsCollectionUI::ShowFullscreenExitInformation";
#ifdef DOM_GEOLOCATION_SUPPORT
	case PrefsCollectionUI::ShowGeolocationLicenseDialog:
		return dbg << "PrefsCollectionUI::ShowGeolocationLicenseDialog";
#endif
	case PrefsCollectionUI::ShowGestureUI:
		return dbg << "PrefsCollectionUI::ShowGestureUI";
	case PrefsCollectionUI::ShowHiddenToolbarsWhileCustomizing:
		return dbg << "PrefsCollectionUI::ShowHiddenToolbarsWhileCustomizing";
	case PrefsCollectionUI::ShowMailErrorDialog:
		return dbg << "PrefsCollectionUI::ShowMailErrorDialog";
#if !defined _NO_MENU_TOGGLE_MENU_
	case PrefsCollectionUI::ShowMenu:
		return dbg << "PrefsCollectionUI::ShowMenu";
#endif
#ifdef WEB_TURBO_MODE
	case PrefsCollectionUI::ShowNetworkSpeedNotification:
		return dbg << "PrefsCollectionUI::ShowNetworkSpeedNotification";
#endif
	case PrefsCollectionUI::ShowNewOperaDialog:
		return dbg << "PrefsCollectionUI::ShowNewOperaDialog";
	case PrefsCollectionUI::ShowNotificationForBlockedPopups:
		return dbg << "PrefsCollectionUI::ShowNotificationForBlockedPopups";
	case PrefsCollectionUI::ShowNotificationForFinishedTransfers:
		return dbg << "PrefsCollectionUI::ShowNotificationForFinishedTransfers";
#ifdef M2_SUPPORT
	case PrefsCollectionUI::ShowNotificationForNewMessages:
		return dbg << "PrefsCollectionUI::ShowNotificationForNewMessages";
	case PrefsCollectionUI::ShowNotificationForNoNewMessages:
		return dbg << "PrefsCollectionUI::ShowNotificationForNoNewMessages";
#endif
	case PrefsCollectionUI::ShowNotificationsForWidgets:
		return dbg << "PrefsCollectionUI::ShowNotificationsForWidgets";
#ifdef WEB_TURBO_MODE
	case PrefsCollectionUI::ShowOperaTurboInfo:
		return dbg << "PrefsCollectionUI::ShowOperaTurboInfo";
#endif
	case PrefsCollectionUI::ShowPrivateIntroPage:
		return dbg << "PrefsCollectionUI::ShowPrivateIntroPage";
	case PrefsCollectionUI::ShowProblemDlg:
		return dbg << "PrefsCollectionUI::ShowProblemDlg";
	case PrefsCollectionUI::ProgressPopup:
		return dbg << "PrefsCollectionUI::ProgressPopup";
	case PrefsCollectionUI::ShowProgressDlg:
		return dbg << "PrefsCollectionUI::ShowProgressDlg";
	case PrefsCollectionUI::ShowSearchesInAddressfieldAutocompletion:
		return dbg << "PrefsCollectionUI::ShowSearchesInAddressfieldAutocompletion";
#if !defined TARGETED_BANNER_SUPPORT
	case PrefsCollectionUI::ShowSetupdialogOnStart:
		return dbg << "PrefsCollectionUI::ShowSetupdialogOnStart";
#endif
	case PrefsCollectionUI::ShowStartupDialog:
		return dbg << "PrefsCollectionUI::ShowStartupDialog";
#ifdef QUICK
	case PrefsCollectionUI::ShowTrayIcon:
		return dbg << "PrefsCollectionUI::ShowTrayIcon";
#endif
#ifdef _VALIDATION_SUPPORT_
	case PrefsCollectionUI::ShowValidationDialog:
		return dbg << "PrefsCollectionUI::ShowValidationDialog";
#endif
#ifdef WIDGET_RUNTIME_SUPPORT
	case PrefsCollectionUI::ShowWidgetDebugInfoDialog:
		return dbg << "PrefsCollectionUI::ShowWidgetDebugInfoDialog";
#endif
	case PrefsCollectionUI::ShowWindowMenu:
		return dbg << "PrefsCollectionUI::ShowWindowMenu";
	case PrefsCollectionUI::ShowPanelToggle:
		return dbg << "PrefsCollectionUI::ShowPanelToggle";
	case PrefsCollectionUI::SourceViewerMode:
		return dbg << "PrefsCollectionUI::SourceViewerMode";
#ifdef SUPPORT_SPEED_DIAL
	case PrefsCollectionUI::SpeedDialState:
		return dbg << "PrefsCollectionUI::SpeedDialState";
	case PrefsCollectionUI::SpeedDialZoomLevel:
		return dbg << "PrefsCollectionUI::SpeedDialZoomLevel";
#endif
	case PrefsCollectionUI::StartupType:
		return dbg << "PrefsCollectionUI::StartupType";
	case PrefsCollectionUI::StatusbarAlignment:
		return dbg << "PrefsCollectionUI::StatusbarAlignment";
	case PrefsCollectionUI::StrategyOnApplicationCache:
		return dbg << "PrefsCollectionUI::StrategyOnApplicationCache";
	case PrefsCollectionUI::TransferItemsAddedOnTop:
		return dbg << "PrefsCollectionUI::TransferItemsAddedOnTop";
	case PrefsCollectionUI::TreeViewDropDownMaxLines:
		return dbg << "PrefsCollectionUI::TreeViewDropDownMaxLines";
#ifdef WEB_TURBO_MODE
	case PrefsCollectionUI::TurboSNNotificationLeft:
		return dbg << "PrefsCollectionUI::TurboSNNotificationLeft";
#endif
	case PrefsCollectionUI::UIPropertyExaminer:
		return dbg << "PrefsCollectionUI::UIPropertyExaminer";
#ifdef _INTERNAL_BUTTONSET_SUPPORT_
	case PrefsCollectionUI::UseExternalButtonSet:
		return dbg << "PrefsCollectionUI::UseExternalButtonSet";
#endif
	case PrefsCollectionUI::UseExternalDownloadManager:
		return dbg << "PrefsCollectionUI::UseExternalDownloadManager";
	case PrefsCollectionUI::UseHTTPProxyForAllProtocols:
		return dbg << "PrefsCollectionUI::UseHTTPProxyForAllProtocols";
	case PrefsCollectionUI::UseIntegratedSearch:
		return dbg << "PrefsCollectionUI::UseIntegratedSearch";
#ifdef PAGEBAR_THUMBNAILS_SUPPORT
	case PrefsCollectionUI::UseThumbnailsInsideTabs:
		return dbg << "PrefsCollectionUI::UseThumbnailsInsideTabs";
#endif
#ifdef SUPPORT_GENERATE_THUMBNAILS
	case PrefsCollectionUI::UseThumbnailsInTabTooltips:
		return dbg << "PrefsCollectionUI::UseThumbnailsInTabTooltips";
	case PrefsCollectionUI::UseThumbnailsInWindowCycle:
		return dbg << "PrefsCollectionUI::UseThumbnailsInWindowCycle";
#endif
#ifdef MSWIN
	case PrefsCollectionUI::UseWindows7TaskbarThumbnails:
		return dbg << "PrefsCollectionUI::UseWindows7TaskbarThumbnails";
#endif
#ifdef API_PRF_DESKTOP_UI
	case PrefsCollectionUI::VirtualKeyboardType:
		return dbg << "PrefsCollectionUI::VirtualKeyboardType";
#endif
	case PrefsCollectionUI::WarnAboutActiveTransfersOnExit:
		return dbg << "PrefsCollectionUI::WarnAboutActiveTransfersOnExit";
	case PrefsCollectionUI::WindowCycleType:
		return dbg << "PrefsCollectionUI::WindowCycleType";
#ifdef WIDGET_RUNTIME_SUPPORT
	case PrefsCollectionUI::DisableWidgetRuntime:
		return dbg << "PrefsCollectionUI::DisableWidgetRuntime";
#endif
	default:
		return dbg << "PrefsCollectionUI::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
