; EncodePointer and DecodePointer functions (kernel32.dll) are not available
; in Win2k and WinXP without SP3, but builds generated by VS2010 depend
; on them (they are used by CRT code).
; This file overrides IAT symbols for EncodePointer and DecodePointer with
; code that uses these functions if kernel32.dll has them and simply returns
; input argument on older systems.
;
; compile with: yasm.exe -f win32 noencodepointer.asm

extern __imp__LoadLibraryA@4
extern __imp__GetProcAddress@8
extern __imp__FreeLibrary@4

global __imp__EncodePointer@4:data
global __imp__DecodePointer@4:data

section .data
__imp__EncodePointer@4 DD EncpFirstrun
__imp__DecodePointer@4 DD DecpFirstrun
dll_name DB 'KERNEL32.DLL',0
encp_name DB 'EncodePointer',0
decp_name DB 'DecodePointer',0

section .text
; EncodePointer/DecodePointer for older systems
Dummy:
    mov eax, [esp+4]
    retn 4

; check if kernel32.dll has EncodePointer and DecodePointer and
; setup __imp__EncodePointer and __imp__DecodePointer accordingly
Init:
    push eax
    push esi
    push ebx

    mov eax, Dummy
    mov [__imp__EncodePointer@4], eax
    mov [__imp__DecodePointer@4], eax

    push dll_name
    call [__imp__LoadLibraryA@4]
    test eax, eax
    je Init_end
    mov esi, eax

    push encp_name
    push esi
    call [__imp__GetProcAddress@8]
    test eax, eax
    je Init_unload
    mov ebx, eax

    push decp_name
    push esi
    call [__imp__GetProcAddress@8]
    je Init_unload

    mov [__imp__EncodePointer@4], ebx
    mov [__imp__DecodePointer@4], eax

Init_unload:
    push esi
    call [__imp__FreeLibrary@4]

Init_end:
    pop ebx
    pop esi
    pop eax
    ret

; handles first call to EncodePointer
EncpFirstrun:
    push ebp
    mov ebp,esp
    call Init
    pop ebp
    jmp [__imp__EncodePointer@4]

; handles first call to DecodePointer (if called before EncodePointer)
DecpFirstrun:
    push ebp
    mov ebp,esp
    call Init
    pop ebp
    jmp [__imp__DecodePointer@4]