
import os.path
import glob
import shutil

@goal('clean', 'Remove files generated by the build.')
@flow
def clean(self):
    removed = []
    for pattern in config.cleanPatterns:
        for name in glob.glob(pattern):
            if os.path.islink(name) or os.path.isfile(name):
                os.unlink(name)
            else:
                shutil.rmtree(name, ignore_errors=True)
            removed.append(name)
    if removed:
        self['result'] = "Removed build-generated files and directories ({0}).".format(' '.join(removed))
    else:
        self['result'] = 'Nothing to remove.'

@goal('setup', 'Make everything ready for compilation.')
@flow
def sourceSetup(self):
    yield hardcoreSetup(), productSetup()
