/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2007 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
** Peter Karlsson
*/

#if !defined UTIL_OPGUID_H && defined UTIL_GUID_GENERATE_SUPPORT
#define UTIL_OPGUID_H

#include "modules/pi/OpSystemInfo.h"

/**
 * Generator for universsaly unique identifiers (UUIDs), also known as
 * globally unique identifiers (GUID). The UUIDs generated by this
 * class conform to the specification in RFC 4122.
 */
class OpGUIDManager
{
public:
#ifndef GUID_GENERATE_SUPPORT
	OpGUIDManager()
		: clocksequence(0)
	{}
#endif

	/**
	 * Generate a new GUID. The GUID will be different from any
	 * previous one generated.
	 *
	 * @param guid (Output) Set to the GUID generated.
	 * @return
	 *   Status of the operation. The value of guid is undefined
	 *   if the return value is not OpStatus::OK;
	 */
	OP_STATUS GenerateGuid(OpGuid &guid)
#ifdef GUID_GENERATE_SUPPORT
		{ return g_op_system_info->GenerateGuid(guid); }
#else
		;
#endif

	/**
	 * Convert a GUID to the string representation described in
	 * RFC 4122.
	 *
	 * @param guid A GUID.
	 * @param buf A buffer to write to.
	 * @param buflen
	 *    Length of the buffer. Should be at least 37 to allow for
	 *    the entire string and a terminating nul character.
	 */
	static void ToString(const OpGuid &guid, char *buf, size_t buflen);

private:
#ifndef GUID_GENERATE_SUPPORT
	double clocksequence;
#endif
};

# define g_opguidManager g_opera->util_module.m_opguidmanager
#endif
