# -*- Mode: python; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-

import sys
import os

#
# global variables
#

debug = False
verbosity = 0
table_files = []
in_file_name = ""
max_attr_len = 0

#
# definition of functions and classes used
#

def verbose(s, level = 0):
    global verbosity
    if verbosity >= level:
        print s

def toFile(file, s):
	global debug
	if debug:
		verbose(s)
	else:
		file.write(s)

def makeArray(s, ns):
	out_str = ""
	index_increment = 1
	str_len = len(s)
	add_flattened = s != s.lower()
	if add_flattened:
		out_str += "%d, HTML5Element::%s" % ((str_len + 1), ns.upper())
	else:
		out_str += "0, 0"

	index_increment += str_len + 1
	for i in range(str_len):
		out_str += ", '%s'" % s[i]
		out_str += ", 0"

	out_str += ", 0, 0"

	if add_flattened:
		index_increment += str_len + 1
		for i in range(str_len):
			out_str += ", '%s'" % s[i].lower()
			out_str += ", 0"
		out_str += ", 0, 0"

	return [out_str, index_increment * 2]


if len(sys.argv) < 2:
    print "\nUsage: mkattrs.py attribute-file\n"
    sys.exit()

verbose("Creating attribute tables...")

in_file_name = sys.argv[1]
in_file_dir = os.path.dirname(os.path.abspath(in_file_name)) + "/"

type_file_name = in_file_dir + "attrtypes.h"
name_file_name = in_file_dir + "attrnames.h"

in_file = open(in_file_name, "r")
type_file = open(type_file_name, "w")
name_file = open(name_file_name, "w")
first = True
attr_map = {}
attr_list = []
attr_indices = []
attr_index = 0

for line in in_file:
	attr_entry = line.strip()
	[attr_name, ns] = attr_entry.split(',')
	if not attr_name in attr_map:
		attr_map[attr_name] = ns
	attr_list.append([attr_name, ns])

attr_list.sort()

# write files
header = """/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; c-file-style: "stroustrup" -*-
 *
 * Copyright (C) 2011 Opera Software ASA.  All rights reserved.
 *
 * This file is part of the Opera web browser.
 * It may not be distributed under any circumstances.
 */

/***********************************************************************
 * This file is generated by the mkattrs.py script in the logdoc module.
 *
 * DO NOT EDIT BY HAND. CHANGE THE html5attrs.txt FILE AND REGENERATE!!
 *
 ***********************************************************************/

"""

toFile(type_file, header)
toFile(type_file, "enum AttrType\n{\n\tHA_NULL\n\t, HA_XML\n")
toFile(name_file, header)
toFile(name_file, "char const g_html5_attr_names[] = {\n")

upper_names = "CONST_ARRAY(g_html5_attr_names_upper, uni_char*)\n"
placeholder = ""
for [attr_name, ns] in attr_list:
	attr_len = len(attr_name)
	if attr_len > max_attr_len:
		max_attr_len = attr_len
	attr_name_esc = attr_name.replace('-', '_').upper()
	if ns != attr_map[attr_name]:
		toFile(type_file, "\t, BEFORE_%sA_%s%s\n" % (ns.upper(), attr_name_esc, placeholder))
		toFile(type_file, "\t, %sA_%s = %sA_%s\n" % (ns.upper(), attr_name_esc, attr_map[attr_name].upper(), attr_name_esc))
		placeholder = " = BEFORE_%sA_%s" % (ns.upper(), attr_name_esc)
	else:
		toFile(type_file, "\t, %sA_%s%s\n" % (ns.upper(), attr_name_esc.upper(), placeholder))
		attr_indices.append(attr_index)
		placeholder = ""
		result = makeArray(attr_name, ns)
		attr_index += result[1]
		if first:
			toFile(name_file, "\t%s\n" % result[0])
			upper_names += "\tCONST_ENTRY(UNI_L(\"%s\"))\n" % attr_name.upper()
			first = False
		else:
			toFile(name_file, "\t, %s\n" % result[0])
			upper_names += "\t, CONST_ENTRY(UNI_L(\"%s\"))\n" % attr_name.upper()

toFile(type_file, "\t, HA_LAST // This is the last that maps to a string\n")
# add some special SVG attribute types
toFile(type_file, "\t, SVGA_SPECIAL\n\t, SVGA_ANIMATED_MARKER_PROP\n\t, SVGA_MOTION_TRANSFORM\n\t, SVGA_ANIMATE_TRANSFORM\n\t, SVGA_ANIMATE_TRANSFORM_ADDITIVE\n\t, SVGA_REAL_NODE\n\t, SVGA_SHADOW_TREE_BUILT\n\t, SVGA_SVG_CONTEXT\n\t, SVGA_ELEMENT_RENDERING_CONTEXT\n")

toFile(type_file, "\t, HA_ABSOLUTELY_LAST\n};\n")
toFile(name_file, "};\n\n#define HTML5_MAX_ATTR_LEN %d\n\n" % max_attr_len)

toFile(name_file, "const unsigned g_html5_attr_indices[] = {\n")
for index in attr_indices:
	if index == 0:
		toFile(name_file, "\t%d\n" % index)
	else:
		toFile(name_file, "\t, %d\n" % index)
toFile(name_file, "};\n\n")
upper_names += "CONST_END(g_html5_attr_names_upper)\n"
toFile(name_file, upper_names);

type_file.close()
name_file.close()
in_file.close()

verbose("  Wrote %s" % type_file_name);
verbose("  Wrote %s" % name_file_name);
verbose("\nRemember to run mkhash.py to optimize hashing")
