#! /usr/bin/python
import sys
import re
import array

def error(message):
	print >>sys.stderr, message
	sys.exit(1)

pattern = re.compile('([\d\.A-Fa-f]+); (.*)')
ranges = []
enum = ['BLK_No_Block']
values = []
last_end = 0

# Let the selftest support BMP, SMP and SIP only.
selftest_table = ['BLK_No_Block']*0x30000;

# Open and parse the input data
try:
	file = open('../data/Blocks.txt', 'r')
except:
	error("Error opening Blocks.txt")

for line in file.readlines():
	m = pattern.match(line)
	if not m:
		continue

	# Get range and block_name from the parsed line
	range_s, block_name = m.group(1,2)

	block_name = "BLK_"+block_name.replace('-', '').replace(' ', '')
	range_splited = range_s.split("..")
	start, end = (int(range_splited[0], 16), int(range_splited[-1], 16))

	if not block_name in enum:
		enum.append(block_name)

	if last_end != 0 and last_end+1 != start:
		ranges.append(last_end+1)
		values.append('BLK_No_Block')
		
	if (end+1<0x30000):
		for i in range(start, end+1):
			selftest_table[i] = block_name;

	values.append(block_name)
	ranges.append(start)
	last_end = end

ranges.append(last_end)

values.append('BLK_No_Block')
ranges.append(0xFFFFFF)

# Write the selftest data
out = open("blocks.dat", "wb")
array.array("B", [enum.index(x) for x in selftest_table]).tofile(out)
out.close()

# Write the requested table
# Write enum and table used by Unicode::GetUnicodeBlock method
print "/** @file blocks.inl"
print " * This file is auto-generated by modules/unicode/scripts/make_blocks.py."
print " * DO NOT EDIT THIS FILE MANUALLY."
print " */\n"
print "#ifdef USE_UNICODE_INC_DATA\n";

print "enum UnicodeBlockType {"
rest = enum
row = rest[0:4]
while row:
	print "\t" + ",".join(row) + ","
	rest = rest[4:]
	row = rest[0:4]
print "};\n"


print "static const UnicodePoint table_blocks_ranges[] = {"
row = ranges[0:8]
while row:
	print "\t"+", ".join(["0x%.4x" % v for v in row])+","
	ranges = ranges[8:]
	row = ranges[0:8]
print "};\n"

print "static const int table_blocks_values[] = {"
row = values[0:16]
while row:
	print "\t"+", ".join([str(enum.index(v)) for v in row])+","
	values = values[16:]
	row = values[0:16]
print "};\n"

print "#endif // USE_UNICODE_INC_DATA\n";
