/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2006 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

#ifndef MODULES_HARDCORE_MH_CONSTANT_H
#define MODULES_HARDCORE_MH_CONSTANT_H

#include "modules/hardcore/mh/messages.h"

// Most of the constants in this file should probably go away
// or move to another module.

enum OpGlobalConstant
{
	ERR_REDIRECT_FAILED = 21462,
	ERR_URL_TO_LONG = 22072,
	ERR_OUT_OF_MEMORY = 21002,
	NO_SOUND_STRING = 21111,
	FIRST_MESSAGE_NUMERIC_SYNTAX = 21760,
	LAST_MESSAGE_NUMERIC_SYNTAX = 21799,
	IDSTR_JAVA_ACCEPTCERT_TEXT = 22222,
	OPERA_PROGRAM_VERSION = 21110,
	ERR_ILLEGAL_URL = 32832,
	ERR_LOADING_ABORTED_OOM = 32863,
	ERR_COMM_CONNECTION_CLOSED = 32864,
	ERR_NETWORK_PROBLEM = 32865,
	ERR_WINSOCK_BLOCKING = 32866,
	ERR_WINSOCK_RESOURCE_FAIL = 32867,
	ERR_COMM_INTERNAL_ERROR = 32868,
	ERR_COMM_CONNECT_FAILED = 32869,
	ERR_WINSOCK_WRONG_VERSION = 32870,
	ERR_COMM_HOST_NOT_FOUND = 32871,
	ERR_COMM_HOST_UNAVAILABLE = 32872,
	ERR_COMM_CONNECTION_REFUSED = 32873,
	ERR_COMM_REPEATED_FAILED = 32874,
	ERR_COMM_NETWORK_UNREACHABLE = 32881,
	ERR_WINSOCK_UNSUPPORTED_FUNC = 32882,
	ERR_WINSOCK_NO_RECOVERY = 32883,
	ERR_CONNECT_TIMED_OUT = 32885,
	ERR_NO_CONTENT = 32887,
	ERR_VERSION_EXPIRED = 32889,
	ERR_LOCKED_VERSION = 32896,
	ERR_COMM_PROXY_CONNECT_FAILED = 32897,
	ERR_COMM_PROXY_HOST_NOT_FOUND = 32898,
	ERR_COMM_PROXY_HOST_UNAVAILABLE = 32899,
	ERR_COMM_PROXY_CONNECTION_REFUSED = 32900,
	ERR_UNSUPPORTED_SERVER_AUTH = 32901,
	ERR_UNSUPPORTED_PROXY_AUTH = 32902,
	ERR_ACCESS_DENIED = 32903,
	ERR_FILE_DOES_NOT_EXIST = 32904,
	ERR_DISK_IS_FULL = 32905,
	ERR_CACHE_INTERNAL_ERROR = 32906,
	ERR_AUTH_DOMAIN_MATCH = 32907,
	ERR_COMM_OUT_STATE = 32917, //  "The endpoint was not in an appropriate state"
	ERR_COMM_RESERVED_MAC1 = 32918, //  "Open Transport error" (generic)
	ERR_COMM_BLOCKED_URL = 32919,
	ERR_HTTP_FORBIDDEN = 33040,
	ERR_HTTP_NOT_FOUND = 33041,
	ERR_HTTP_SERVER_ERROR = 33042,
	ERR_HTTP_NOT_IMPLEMENTED = 33043,
	ERR_HTTP_NO_CONTENT = 33044,
	ERR_HTTP_100CONTINUE_ERROR = 33045,
	ERR_HTTP_DECODING_FAILURE = 33046,
	ERR_HTTP_AUTH_FAILED = 33047,
	ERR_HTTP_PROXY_AUTH_FAILED = 33048,
	ERR_HTTP_RESET_CONTENT = 33049,
	ERR_ILLEGAL_PORT = 33050,
	ERR_OUT_OF_COVERAGE = 33053,
	ERR_FTP_SERVICE_UNAVAILABLE = 33056,
	ERR_FTP_INTERNAL_ERROR = 33057,
	ERR_FTP_NOT_LOGGED_IN = 33058,
	ERR_FTP_USER_ERROR = 33059,
	ERR_FTP_NEED_PASSWORD = 33060,
	ERR_FTP_DIR_UNAVAILABLE = 33061,
	ERR_FTP_FILE_UNAVAILABLE = 33062,
	ERR_FTP_FILE_TRANSFER_ABORTED = 33063,
	ERR_FTP_CANNOT_OPEN_PASV_DATA_CONN = 33064,
	ERR_FTP_UPLOAD_FAILED = 33065,
	ERR_FTP_INSUFFICIENT_STORAGE = 33066,
	ERR_LOCALHOST_REMOVED_IN_VERSION_TEXT = 33067,
	ERR_FILE_CANNOT_OPEN = 33120,
	ERR_SSL_ERROR_HANDLED = 33366,
	ERR_HTTP_METHOD_NOT_ALLOWED = 33424,
	ERR_HTTP_NOT_ACCEPTABLE = 33425,
	ERR_HTTP_TIMEOUT = 33426,
	ERR_HTTP_CONFLICT = 33427,
	ERR_HTTP_GONE = 33428,
	ERR_HTTP_LENGTH_REQUIRED = 33429,
	ERR_HTTP_PRECOND_FAILED = 33430,
	ERR_HTTP_REQUEST_ENT_TOO_LARGE = 33431,
	ERR_HTTP_REQUEST_URI_TOO_LARGE = 33432,
	ERR_HTTP_UNSUPPORTED_MEDIA_TYPE = 33433,
	ERR_HTTP_RANGE_NOT_SATISFIABLE = 33434,
	ERR_HTTP_EXPECTATION_FAILED = 33435,
	ERR_HTTP_BAD_GATEWAY = 33436,
	ERR_HTTP_SERVICE_UNAVAILABLE = 33437,
	ERR_HTTP_GATEWAY_TIMEOUT = 33438,
	ERR_HTTP_VERSION_NOT_SUPPORTED = 33439,
	ERR_HTTP_PAYMENT_REQUIRED = 33440,
	ERR_URL_TIMEOUT = 33441,
	ERR_URL_IDLE_TIMEOUT = 33442,
	IDM_NEW_MAILTO_WINDOW = 33568,
	P2P_HITS_LOADED = 0x878a,
	AUTH_NEEDED = 0,
	AUTH_WRONG = 1,
	PROXY_AUTH_NEEDED = 2,
	PROXY_AUTH_WRONG = 3,
	DEF_STRING = 20000,
	ERR_UNKNOWN_ADDRESS_TYPE = 20003,
	ERR_NO_HOME = 20005,
	WRONG_AUTH_STRING = 20053,
	NEW_AUTH_STRING = 20082,
	OPERA_USER_AGENT = 20097,
	WRONG_PROXY_AUTH_STRING = 20109,
	NEW_PROXY_AUTH_STRING = 20110,
	UI_FONT = 20220,
	UI_DISFONT = 20222,
	UI_HOTLIST_TREE_FONT = 20225,
	UI_MENU_FONT = 20229,
	UI_TOOLBAR_FONT = 20231,
	UI_DIALOG_FONT = 20232,
	UI_PANEL_FONT = 20233,
	UI_EMAIL_COMPOSE_FONT = 20234,
	OPERA_USER_AGENT_OPERA = 30000,
	OPERA_USER_AGENT_MSIE = 30002,
	IDM_OE_IMPORT_TITLE = 30100,
	IDM_EUDORA_IMPORT_TITLE = 30101,
	IDM_STR_OE4TAG = 30102,
	IDM_STR_OE5TAG = 30103,
	IDM_STR_NSMAILTAG = 30104,
	IDSTR_SYSTEM_LOW_RESOURCE = 30121,
	ERR_AUTO_PROXY_CONFIG_FAILED = 30211,
	ERR_COULD_NOT_CREATE_WINDOW = 20002,
	BROWSE_TEXT = 20046,
	PROGS_TYPES = 20052,
	MCI_CANNOT_PLAY = 20101,
	IDM_WWW_FIRSTID = 20240,
	IDM_WWW_HOMEPAGE = 20240,
	IDM_WWW_SUPPORT = 20241,
	IDM_WWW_REGISTER = 20242,
	IDM_WWW_TELLFRIEND = 20243,
	IDM_WWW_QTUTORIAL = 20244,
	IDM_WWW_QSTART = 20245,
	IDM_WWW_MYOPERA = 20246,
	IDM_WWW_LASTID = 20259,
	PB_FIRST = 20330,
	PB_SETSTATUS = 20330, //  lParam = (LPCTSTR) status text
	PB_SETPROGRESS = 20331, //  wParam = percent complete
	PB_CLEARSTATUS = 20332,
	PB_CLEARPROGRESS = 20333,
	PB_SETSTATUSTIMEOUT = 20334, //  wParam = time in milliseconds
	PB_KILLSTATUSTIMEOUT = 20335,
	PB_SETFINISHED = 20336,
	PB_DELAYEDCLOSE = 20337, //  wParam = time in milliseconds
	PB_LAST = 20339,
	IDM_STR_NONETAG = 30108,
	IDM_STR_EUDORATAG = 30109,
	IDM_STR_FOLD_BROWSE = 30110,
	IDM_STR_FOLD_MBX_BROWSE = 30111,
	IDM_STR_CVSADDRTAG = 30112,
	IDM_NETSCAPE_IMPORT_TITLE = 30113
};

# define HTTPVersion_1_1			"HTTP/1.1"
# define HTTPVersion_1_0			"HTTP/1.0"

#ifndef MB_TASKMODAL
# define MB_TASKMODAL                 0x00002000L
#endif

#ifndef MB_OK
# define MB_OK                        0x00000000L
#endif

#ifndef MB_OKCANCEL
# define MB_OKCANCEL                  0x00000001L
#endif

#ifndef MB_YESNOCANCEL
# define MB_YESNOCANCEL               0x00000003L
#endif

#ifndef MB_YESNO
# define MB_YESNO                     0x00000004L
#endif

#ifndef MB_ICONHAND
# define MB_ICONHAND                  0x00000010L
#endif

#ifndef MB_ICONQUESTION
# define MB_ICONQUESTION              0x00000020L
#endif

#ifndef MB_ICONEXCLAMATION
# define MB_ICONEXCLAMATION           0x00000030L
#endif

#ifndef MB_ICONASTERISK
# define MB_ICONASTERISK              0x00000040L
#endif

#ifndef MB_ICONERROR
# define MB_ICONERROR                 0x00000050L
#endif

#ifndef IDOK
# define IDOK                         1
#endif

#ifndef IDCANCEL
# define IDCANCEL                     2
#endif

#ifndef IDYES
# define IDYES                        6
#endif

#ifndef IDNO
# define IDNO                         7
#endif

#endif // !MODULES_HARDCORE_MH_CONSTANT_H
