/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 2006 Opera Software ASA.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
**
** Peter Krefting
*/

#include "core/pch.h"

#include "modules/about/opredirectpage.h"
#include "modules/locale/oplanguagemanager.h"
#include "modules/locale/locale-enum.h"
#include "modules/util/htmlify.h"
#include "modules/prefs/prefsmanager/collections/pc_files.h"

OP_STATUS OpRedirectPage::GenerateData()
{
	/* Create the document */
	OpString template_string;

#ifdef _LOCALHOST_SUPPORT_
	RETURN_IF_ERROR(OpenDocument(Str::S_GENERATED_REDIRECT_MSG_HEADER, PrefsCollectionFiles::StyleMessageFile));
#else
	RETURN_IF_ERROR(OpenDocument(Str::S_GENERATED_REDIRECT_MSG_HEADER));
#endif
	RETURN_IF_ERROR(OpenBody(Str::S_GENERATED_REDIRECT_MSG_HEADER));
	RETURN_IF_ERROR(g_languageManager->GetString(Str::S_GENERATED_REDIRECT_MSG_BODY, template_string));

	OpString target_url_name;
	RETURN_IF_ERROR(m_target_url->GetAttribute(URL::KUniName_Username_Escaped, target_url_name));
	uni_char *url_string_html = HTMLify_string(target_url_name.CStr());

	if (url_string_html)
	{
		ANCHOR_ARRAY(uni_char, url_string_html);
		OpString link;
		if (OpStatus::IsSuccess(link.AppendFormat(UNI_L("<a href=\"%s\">%s</a>"), url_string_html, url_string_html)))
		{
			RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("<p>")));
			m_url.WriteDocumentDataUniSprintf(template_string.CStr(), link.CStr());
			RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("</p>\n")));

			// If redirect count is zero, redirects are disabled in preferences
			if (m_url.GetAttribute(URL::KRedirectCount) == 0)
			{
				OpString redirect_help;
				RETURN_IF_ERROR(g_languageManager->GetString(Str::S_GENERATED_REDIRECT_MSG_HELP, redirect_help));
				RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("<p>")));
				RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, redirect_help));
				RETURN_IF_ERROR(m_url.WriteDocumentData(URL::KNormal, UNI_L("</p>\n")));
			}
		}
	}

	/* Say that page is generated by Opera. */
	GeneratedByOpera();

	/* Done */
	return CloseDocument();
}

