/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
	OperaLabsName, ///< When Opera product is set to 2, the full name of the Labs build
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	SupportedCameraFormat, ///< When set, will limit the supported formats to the format given. Must be one of: RGB24, RGB32, YUY2, MJPG, I420
#endif
	ApplicationIconFile, ///< Icon replacing the internal

	DummyLastStringPref
};
#define PCMSWIN_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionMSWIN::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	BanDefaultDirectShowRenderers, ///< When set to TRUE, will disable adding default renderers to the graph by IGraphBuilder::Render; when set to FALSE, can result in actual behaviour of DSK-362335. This is done on camera manager startup, but will affect all DShow graphs created inside Opera. OTOH, currently only camera uses DShow.
#endif
#ifdef DOXYGEN_DOCUMENTATION
	MultiUser, ///< Enable multiple profiles (only read from operadef6.ini)
#endif
	OperaProduct, ///< Whether to run as Opera (0), Opera next (1) or Opera Labs (2)
#ifdef ACCESSIBILITY_EXTENSION_SUPPORT
	UseScreenReaderMenus, ///< Enables screen-reader compatible menus when an MSAA query is detected
#endif
#ifdef _RAS_SUPPORT_
	ShowCloseRasDialog, ///< Should close dial-up dialogue be shown?
#endif
#if defined(ACCESSIBILITY_EXTENSION_SUPPORT) && defined(MSWIN)
	EnableAccessibilitySupport, ///< Enable accessibility (IAccessible) support
#endif
	DDEEnabled, ///< Accept DDE calls from other applications
#ifdef MSWIN
	EnableTouchUI, ///< Set 0 to disable touch UI, 1 for autodetect (default), 2 to force on if available (use at your own risk).
	UseGDIMeasuringMode, ///< Use GDI measuring mode when using DirectDraw for text layout. If DirectDraw is not used, this pref does nothing.
#endif
	MaxCachedBitmaps, ///< Maximum #of bitmaps to cache in memory
	MinAllowedGDIResources, ///< Amount of GDI resources to keep free
#ifdef MSWIN
	PaintThrottling, ///< Delay in ms the paint events should be throttled with.
#endif
	ShowWarningMSIMG32, ///< Show MSIMG32 upgrade warning on W9x

	DummyLastIntegerPref
};
#define PCMSWIN_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionMSWIN::DummyLastIntegerPref)

