/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionMSWIN, PCMSWIN_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
	P(SSystem, "Opera Labs Name", UNI_L("")),
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	P(SSystem, "Supported Camera Format", UNI_L("")),
#endif
	P(SUserPrefs, "Application Icon", UNI_L("")),

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionMSWIN, PCMSWIN_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	I(SSystem, "Ban Default DirectShow Renderers", TRUE, prefssetting::boolean),
#endif
#ifdef DOXYGEN_DOCUMENTATION
	I(SSystem, "Multi User", TRUE, prefssetting::boolean),
#endif
	I(SSystem, "Opera Product", 0, prefssetting::integer),
#ifdef ACCESSIBILITY_EXTENSION_SUPPORT
	I(SSystem, "Use ScreenReader Menus", FALSE, prefssetting::boolean),
#endif
#ifdef _RAS_SUPPORT_
	I(SUserPrefs, "Ask Closing DialUp Connections", FALSE, prefssetting::boolean),
#endif
#if defined(ACCESSIBILITY_EXTENSION_SUPPORT) && defined(MSWIN)
	I(SUserPrefs, "Enable Accessibility Support", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Enable DDE", TRUE, prefssetting::boolean),
#ifdef MSWIN
	I(SUserPrefs, "Enable Touch UI", 1, prefssetting::integer),
	I(SUserPrefs, "GDI Measuring Mode", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Max Number Cached Bitmaps", 100, prefssetting::integer),
	I(SUserPrefs, "Min Allowed GDI Resources", 20, prefssetting::integer),
#ifdef MSWIN
	I(SUserPrefs, "Paint Throttling", 15, prefssetting::integer),
#endif
	I(SUserPrefs, "Show MSIMG32 Warning", TRUE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionMSWIN::stringpref e)
{
	switch (e) {
	case PrefsCollectionMSWIN::OperaLabsName:
		return dbg << "PrefsCollectionMSWIN::OperaLabsName";
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	case PrefsCollectionMSWIN::SupportedCameraFormat:
		return dbg << "PrefsCollectionMSWIN::SupportedCameraFormat";
#endif
	case PrefsCollectionMSWIN::ApplicationIconFile:
		return dbg << "PrefsCollectionMSWIN::ApplicationIconFile";
	default:
		return dbg << "PrefsCollectionMSWIN::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionMSWIN::integerpref e)
{
	switch (e) {
#ifdef WINDOWS_CAMERA_GRAPH_TEST
	case PrefsCollectionMSWIN::BanDefaultDirectShowRenderers:
		return dbg << "PrefsCollectionMSWIN::BanDefaultDirectShowRenderers";
#endif
#ifdef DOXYGEN_DOCUMENTATION
	case PrefsCollectionMSWIN::MultiUser:
		return dbg << "PrefsCollectionMSWIN::MultiUser";
#endif
	case PrefsCollectionMSWIN::OperaProduct:
		return dbg << "PrefsCollectionMSWIN::OperaProduct";
#ifdef ACCESSIBILITY_EXTENSION_SUPPORT
	case PrefsCollectionMSWIN::UseScreenReaderMenus:
		return dbg << "PrefsCollectionMSWIN::UseScreenReaderMenus";
#endif
#ifdef _RAS_SUPPORT_
	case PrefsCollectionMSWIN::ShowCloseRasDialog:
		return dbg << "PrefsCollectionMSWIN::ShowCloseRasDialog";
#endif
#if defined(ACCESSIBILITY_EXTENSION_SUPPORT) && defined(MSWIN)
	case PrefsCollectionMSWIN::EnableAccessibilitySupport:
		return dbg << "PrefsCollectionMSWIN::EnableAccessibilitySupport";
#endif
	case PrefsCollectionMSWIN::DDEEnabled:
		return dbg << "PrefsCollectionMSWIN::DDEEnabled";
#ifdef MSWIN
	case PrefsCollectionMSWIN::EnableTouchUI:
		return dbg << "PrefsCollectionMSWIN::EnableTouchUI";
	case PrefsCollectionMSWIN::UseGDIMeasuringMode:
		return dbg << "PrefsCollectionMSWIN::UseGDIMeasuringMode";
#endif
	case PrefsCollectionMSWIN::MaxCachedBitmaps:
		return dbg << "PrefsCollectionMSWIN::MaxCachedBitmaps";
	case PrefsCollectionMSWIN::MinAllowedGDIResources:
		return dbg << "PrefsCollectionMSWIN::MinAllowedGDIResources";
#ifdef MSWIN
	case PrefsCollectionMSWIN::PaintThrottling:
		return dbg << "PrefsCollectionMSWIN::PaintThrottling";
#endif
	case PrefsCollectionMSWIN::ShowWarningMSIMG32:
		return dbg << "PrefsCollectionMSWIN::ShowWarningMSIMG32";
	default:
		return dbg << "PrefsCollectionMSWIN::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
