/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionWebserver, PCWEBSERVER_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	P(SWebServer, "Device", UNI_L("")),
	P(SWebServer, "Proxy Host", WEB_RDV_PROXY_HOST),
#endif
#ifdef WEB_UPLOAD_SERVICE_LIST
	P(SWebServer, "Service Discovery Server", UNI_L("https://asd.opera.com/1.0/register")),
#endif
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	P(SWebServer, "Shared Secret", UNI_L("")),
	P(SWebServer, "User", UNI_L("")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionWebserver, PCWEBSERVER_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef WEBSERVER_SUPPORT
	I(SWebServer, "Backlog", WEB_RDV_BACKLOG, prefssetting::integer),
	I(SWebServer, "Enable", DEFAULT_ENABLE_WEBSERVER, prefssetting::boolean),
	I(SWebServer, "Listen To All Networks", DEFAULT_WEBSERVER_BIND_ALL, prefssetting::boolean),
	I(SWebServer, "Max Upload Rate (kBps)", 0, prefssetting::integer),
	I(SWebServer, "Port", WEB_PARM_DEFAULT_PORT, prefssetting::integer),
#endif
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	I(SWebServer, "Proxy Port", 16680, prefssetting::integer),
#endif
#ifdef WEBSERVER_SUPPORT
	I(SWebServer, "Service Discovery Enabled", TRUE, prefssetting::boolean),
#endif
#ifdef UPNP_SUPPORT
	I(SWebServer, "UPnP Enabled", TRUE, prefssetting::boolean),
	I(SWebServer, "UPnP Service Discovery Enabled", TRUE, prefssetting::boolean),
#endif
#ifdef WEBSERVER_SUPPORT
	I(SWebServer, "Use Opera Account", DEFAULT_USE_OPERA_ACCOUNT, prefssetting::boolean),
	I(SWebServer, "Webserver Always On", TRUE, prefssetting::boolean),
	I(SWebServer, "Webserver Used", FALSE, prefssetting::boolean),
	I(SWebServer, "robots.txt Enabled", TRUE, prefssetting::boolean),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionWebserver::stringpref e)
{
	switch (e) {
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	case PrefsCollectionWebserver::WebserverDevice:
		return dbg << "PrefsCollectionWebserver::WebserverDevice";
	case PrefsCollectionWebserver::WebserverProxyHost:
		return dbg << "PrefsCollectionWebserver::WebserverProxyHost";
#endif
#ifdef WEB_UPLOAD_SERVICE_LIST
	case PrefsCollectionWebserver::ServiceDiscoveryServer:
		return dbg << "PrefsCollectionWebserver::ServiceDiscoveryServer";
#endif
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	case PrefsCollectionWebserver::WebserverHashedPassword:
		return dbg << "PrefsCollectionWebserver::WebserverHashedPassword";
	case PrefsCollectionWebserver::WebserverUser:
		return dbg << "PrefsCollectionWebserver::WebserverUser";
#endif
	default:
		return dbg << "PrefsCollectionWebserver::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionWebserver::integerpref e)
{
	switch (e) {
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionWebserver::WebserverBacklog:
		return dbg << "PrefsCollectionWebserver::WebserverBacklog";
	case PrefsCollectionWebserver::WebserverEnable:
		return dbg << "PrefsCollectionWebserver::WebserverEnable";
	case PrefsCollectionWebserver::WebserverListenToAllNetworks:
		return dbg << "PrefsCollectionWebserver::WebserverListenToAllNetworks";
	case PrefsCollectionWebserver::WebserverUploadRate:
		return dbg << "PrefsCollectionWebserver::WebserverUploadRate";
	case PrefsCollectionWebserver::WebserverPort:
		return dbg << "PrefsCollectionWebserver::WebserverPort";
#endif
#ifdef WEBSERVER_RENDEZVOUS_SUPPORT
	case PrefsCollectionWebserver::WebserverProxyPort:
		return dbg << "PrefsCollectionWebserver::WebserverProxyPort";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionWebserver::ServiceDiscoveryEnabled:
		return dbg << "PrefsCollectionWebserver::ServiceDiscoveryEnabled";
#endif
#ifdef UPNP_SUPPORT
	case PrefsCollectionWebserver::UPnPEnabled:
		return dbg << "PrefsCollectionWebserver::UPnPEnabled";
	case PrefsCollectionWebserver::UPnPServiceDiscoveryEnabled:
		return dbg << "PrefsCollectionWebserver::UPnPServiceDiscoveryEnabled";
#endif
#ifdef WEBSERVER_SUPPORT
	case PrefsCollectionWebserver::UseOperaAccount:
		return dbg << "PrefsCollectionWebserver::UseOperaAccount";
	case PrefsCollectionWebserver::WebserverAlwaysOn:
		return dbg << "PrefsCollectionWebserver::WebserverAlwaysOn";
	case PrefsCollectionWebserver::WebserverUsed:
		return dbg << "PrefsCollectionWebserver::WebserverUsed";
	case PrefsCollectionWebserver::RobotsTxtEnabled:
		return dbg << "PrefsCollectionWebserver::RobotsTxtEnabled";
#endif
	default:
		return dbg << "PrefsCollectionWebserver::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
