/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionSync, PCSYNC_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
	P(SOperaSyncServer, "Server Address", DEFAULT_OPERA_LINK_SERVER),
	P(SOperaSync, "Sync Client State", UNI_L("0")),
	P(SOperaSync, "Sync Client State Bookmarks", UNI_L("0")),
#ifdef SYNC_HAVE_EXTENSIONS
	P(SOperaSync, "Sync Client State Extensions", UNI_L("0")),
#endif
#ifdef SYNC_HAVE_NOTES
	P(SOperaSync, "Sync Client State Notes", UNI_L("0")),
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	P(SOperaSync, "Sync Client State Password Manager", UNI_L("0")),
#endif
#ifdef SYNC_HAVE_SEARCHES
	P(SOperaSync, "Sync Client State Searches", UNI_L("0")),
#endif
#if defined(SYNC_HAVE_SPEED_DIAL) && !defined(SYNC_HAVE_SPEED_DIAL_2)
	P(SOperaSync, "Sync Client State Speed Dial", UNI_L("0")),
#endif
#ifdef SYNC_HAVE_SPEED_DIAL_2
	P(SOperaSync, "Sync Client State Speed Dial 2", UNI_L("0")),
#endif
#ifdef SYNC_TYPED_HISTORY
	P(SOperaSync, "Sync Client State Typed History", UNI_L("0")),
#endif
#ifdef SYNC_CONTENT_FILTERS
	P(SOperaSync, "Sync Client State URL Filter", UNI_L("0")),
#endif
#ifdef SUPPORT_DATA_SYNC
	P(SOperaSync, "Sync Data Provider", DEFAULT_SYNC_PROVIDER),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionSync, PCSYNC_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SOperaSyncServer, "Complete Sync", FALSE, prefssetting::boolean),
	I(SOperaSyncServer, "Log Traffic", FALSE, prefssetting::boolean),
	I(SOperaSync, "Last Cached Access", 0, prefssetting::integer),
	I(SOperaSync, "Last Cached Access Num", 0, prefssetting::integer),
#ifdef SYNC_HAVE_BOOKMARKS
	I(SOperaSync, "Sync Bookmarks", TRUE, prefssetting::boolean),
#endif
	I(SOperaSync, "Sync Enabled", FALSE, prefssetting::boolean),
#ifdef SYNC_HAVE_EXTENSIONS
	I(SOperaSync, "Sync Extensions", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_FEEDS
	I(SOperaSync, "Sync Feeds", TRUE, prefssetting::boolean),
#endif
	I(SOperaSync, "Sync Last Used", 0, prefssetting::integer),
#ifdef SYNC_HAVE_NOTES
	I(SOperaSync, "Sync Notes", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	I(SOperaSync, "Sync Password Manager", FALSE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_PERSONAL_BAR
	I(SOperaSync, "Sync Personalbar", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_SEARCHES
	I(SOperaSync, "Sync Searches", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_SPEED_DIAL
	I(SOperaSync, "Sync Speed Dial", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_HAVE_TYPED_HISTORY
	I(SOperaSync, "Sync Typed History", TRUE, prefssetting::boolean),
#endif
#ifdef SYNC_CONTENT_FILTERS
	I(SOperaSync, "Sync URL Filter", TRUE, prefssetting::boolean),
#endif
	I(SOperaSync, "Sync Used", FALSE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionSync::stringpref e)
{
	switch (e) {
	case PrefsCollectionSync::ServerAddress:
		return dbg << "PrefsCollectionSync::ServerAddress";
	case PrefsCollectionSync::SyncClientState:
		return dbg << "PrefsCollectionSync::SyncClientState";
	case PrefsCollectionSync::SyncClientStateBookmarks:
		return dbg << "PrefsCollectionSync::SyncClientStateBookmarks";
#ifdef SYNC_HAVE_EXTENSIONS
	case PrefsCollectionSync::SyncClientStateExtensions:
		return dbg << "PrefsCollectionSync::SyncClientStateExtensions";
#endif
#ifdef SYNC_HAVE_NOTES
	case PrefsCollectionSync::SyncClientStateNotes:
		return dbg << "PrefsCollectionSync::SyncClientStateNotes";
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	case PrefsCollectionSync::SyncClientStatePasswordManager:
		return dbg << "PrefsCollectionSync::SyncClientStatePasswordManager";
#endif
#ifdef SYNC_HAVE_SEARCHES
	case PrefsCollectionSync::SyncClientStateSearches:
		return dbg << "PrefsCollectionSync::SyncClientStateSearches";
#endif
#if defined(SYNC_HAVE_SPEED_DIAL) && !defined(SYNC_HAVE_SPEED_DIAL_2)
	case PrefsCollectionSync::SyncClientStateSpeeddial:
		return dbg << "PrefsCollectionSync::SyncClientStateSpeeddial";
#endif
#ifdef SYNC_HAVE_SPEED_DIAL_2
	case PrefsCollectionSync::SyncClientStateSpeeddial2:
		return dbg << "PrefsCollectionSync::SyncClientStateSpeeddial2";
#endif
#ifdef SYNC_TYPED_HISTORY
	case PrefsCollectionSync::SyncClientStateTypedHistory:
		return dbg << "PrefsCollectionSync::SyncClientStateTypedHistory";
#endif
#ifdef SYNC_CONTENT_FILTERS
	case PrefsCollectionSync::SyncClientStateURLFilter:
		return dbg << "PrefsCollectionSync::SyncClientStateURLFilter";
#endif
#ifdef SUPPORT_DATA_SYNC
	case PrefsCollectionSync::SyncDataProvider:
		return dbg << "PrefsCollectionSync::SyncDataProvider";
#endif
	default:
		return dbg << "PrefsCollectionSync::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionSync::integerpref e)
{
	switch (e) {
	case PrefsCollectionSync::CompleteSync:
		return dbg << "PrefsCollectionSync::CompleteSync";
	case PrefsCollectionSync::SyncLogTraffic:
		return dbg << "PrefsCollectionSync::SyncLogTraffic";
	case PrefsCollectionSync::LastCachedAccess:
		return dbg << "PrefsCollectionSync::LastCachedAccess";
	case PrefsCollectionSync::LastCachedAccessNum:
		return dbg << "PrefsCollectionSync::LastCachedAccessNum";
#ifdef SYNC_HAVE_BOOKMARKS
	case PrefsCollectionSync::SyncBookmarks:
		return dbg << "PrefsCollectionSync::SyncBookmarks";
#endif
	case PrefsCollectionSync::SyncEnabled:
		return dbg << "PrefsCollectionSync::SyncEnabled";
#ifdef SYNC_HAVE_EXTENSIONS
	case PrefsCollectionSync::SyncExtensions:
		return dbg << "PrefsCollectionSync::SyncExtensions";
#endif
#ifdef SYNC_HAVE_FEEDS
	case PrefsCollectionSync::SyncFeeds:
		return dbg << "PrefsCollectionSync::SyncFeeds";
#endif
	case PrefsCollectionSync::SyncLastUsed:
		return dbg << "PrefsCollectionSync::SyncLastUsed";
#ifdef SYNC_HAVE_NOTES
	case PrefsCollectionSync::SyncNotes:
		return dbg << "PrefsCollectionSync::SyncNotes";
#endif
#ifdef SYNC_HAVE_PASSWORD_MANAGER
	case PrefsCollectionSync::SyncPasswordManager:
		return dbg << "PrefsCollectionSync::SyncPasswordManager";
#endif
#ifdef SYNC_HAVE_PERSONAL_BAR
	case PrefsCollectionSync::SyncPersonalbar:
		return dbg << "PrefsCollectionSync::SyncPersonalbar";
#endif
#ifdef SYNC_HAVE_SEARCHES
	case PrefsCollectionSync::SyncSearches:
		return dbg << "PrefsCollectionSync::SyncSearches";
#endif
#ifdef SYNC_HAVE_SPEED_DIAL
	case PrefsCollectionSync::SyncSpeeddial:
		return dbg << "PrefsCollectionSync::SyncSpeeddial";
#endif
#ifdef SYNC_HAVE_TYPED_HISTORY
	case PrefsCollectionSync::SyncTypedHistory:
		return dbg << "PrefsCollectionSync::SyncTypedHistory";
#endif
#ifdef SYNC_CONTENT_FILTERS
	case PrefsCollectionSync::SyncURLFilter:
		return dbg << "PrefsCollectionSync::SyncURLFilter";
#endif
	case PrefsCollectionSync::SyncUsed:
		return dbg << "PrefsCollectionSync::SyncUsed";
	default:
		return dbg << "PrefsCollectionSync::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
