/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	IspUserAgentId, ///< ISP id for User-Agent string
#endif
#if defined PREFS_HAVE_EBO_GUID || defined _EMBEDDED_BYTEMOBILE
	BytemobileGUID, ///< Unique identifier code for Bytemobile
#endif
	AcceptTypes, ///< Data for HTTP header "Accept"
	AcceptLanguage, ///< Data for HTTP header "Accept-Language"
#ifdef ADD_PERMUTE_NAME_PARTS
	HostNameExpansionPostfix, ///< What to append to URLs
	HostNameExpansionPrefix, ///< What to prepend to URLs
	HostNameWebLookupAddress, ///< Search engine address to use for Web lookup of entered hostname.
#endif
	IdnaWhiteList, ///< IDNA white list for display of Unicode
	PermittedPorts, ///< Comma-separated list of additional permitted ports
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	LongbatchURL, ///< Which URL to load the long batch test configuration from
#endif
#ifdef __OEM_EXTENDED_CACHE_MANAGEMENT
	NeverFlushTrustedServers, ///< Which servers to trust for the Never Flush cache management functionality
	OutOfCoverageFileName, ///< Name of substitute file name to use if unit is out of coverage
#endif
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	AutomaticProxyConfigURL, ///< URL of automatic proxy config file
#endif
#ifdef FTP_SUPPORT
	FTPProxy, ///< Proxy host:port for FTP
#endif
#ifdef GOPHER_SUPPORT
	GopherProxy, ///< Proxy host:port for Gopher
#endif
	HTTPProxy, ///< Proxy host:port for HTTP
	HTTPSProxy, ///< Proxy host:port for HTTPS
	NoProxyServers, ///< Servers not to use proxy for
#ifdef WEB_TURBO_MODE
	WebTurboBypassURLs, ///< A list of URLs for which OperaTurbo should not be used.
#endif
#ifdef SOCKS_SUPPORT
	SOCKSPass, ///< password for SOCKS basic authentication
	SOCKSProxy, ///< Proxy host:port for SOCKS
	SOCKSUser, ///< username for SOCKS basic authentication
#endif
#ifdef WAIS_SUPPORT
	WAISProxy, ///< Proxy host:port for WAIS
#endif
#if !defined _NATIVE_SSL_SUPPORT_
	MasterPasswordCheckCodeAndSalt, ///< Master password check codes for external ssl. Used to check that you type in correct password, without storing the actual password.
#endif
#ifdef HELP_SUPPORT
	HelpUrl, ///< URL to help files
#endif

	DummyLastStringPref
};
#define PCNETWORK_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionNetwork::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
#ifdef _BITTORRENT_SUPPORT_
	BTBandwidthRestrictionMode, ///< Which method to use when restricting bandwidth use. 1 = automatic, 2 = fixed rates
	EnableBitTorrent, ///< Enable BitTorrent support
	BTListenPort, ///< Port for incoming bittorrent connections
	BTMaxDownloadRate, ///< Maximum bandwidth in KB/s to use for downloads
	BTMaxUploadRate, ///< Maximum bandwidth in KB/s to use for uploads
	BTWarningDialog, ///< Display warning dialog for BitTorrent downloads
#endif
	AlwaysCheckNeverExpireGetQueries, ///< Check normal GET URLs if they have "?" in the URL and no expiration date from server
	AlwaysCheckRedirectChanged, ///< Check redirection for cache
	AlwaysCheckRedirectChangedImages, ///< Check redirection for images
	AlwaysReloadHTTPSInHistory, ///< Always Reload HTTPS In History
	CacheHTTPSAfterSessions, ///< Keep HTTPS pages in cache
	CheckExpiryHistory, ///< How to check expiry when walking in history
	CheckExpiryLoad, ///< How to check expiry when loading pages
#ifdef SUPPORT_THREADED_FILEWRITER
	FileWriterCacheSize, ///< The size (in bytes) of the file writer memory cache
	FileWriterThreadPriority, ///< The priority to set the file writer thread to (platform dependent interpretation)
	SetFileWriterThreadPriority, ///< Whether to set the priority of the file writer thread
#endif
	DiskCacheBufferSize, ///< Size of disk cache buffer (kbytes)
	CacheDocs, ///< Whether to cache documents on disk
	CacheFigs, ///< Whether to cache images on disk
	CacheHTTPS, ///< Whether to cache HTTPS data on disk
	CacheOther, ///< Whether to cache other stuff on disk
	CheckDocModification, ///< When to check if documents are modified
	DocExpiry, ///< Expiry time of documents in seconds
#ifdef DISK_CACHE_SUPPORT
	EmptyCacheOnExit, ///< Whether to empty cache when leaving
	CacheToDisk, ///< Whether to cache to disk
#endif
	CheckFigModification, ///< When to check if images are modified
	FigsExpiry, ///< Expiry time of images in seconds
#ifdef MEDIA_PLAYER_SUPPORT
	MediaCacheSize, ///< Size of media disk cache (kbytes)
#endif
#ifdef DISK_CACHE_SUPPORT
	MultimediaStreamAlways, ///< Always stream Multimedia content (audio/video tag), wasting bandwidth but saving disk space
	MultimediaStreamSize, ///< Size, in KB, of the file used when streaming with the Multimedia Cache
	MultimediaStreamRAM, ///< When streaming, do it in RAM
#endif
	OtherExpiry, ///< Expiry time of other objects in seconds
	CheckOtherModification, ///< When to check if other objects are modified
	DiskCacheSize, ///< Size of disk cache (kbytes)
	FollowedLinkExpireDays, ///< Expiry time for followed links (day part)
	FollowedLinkExpireHours, ///< Expiry time for followed links (hour part)
	AllowCrossNetworkNavigation, ///< Allow navigation between hosts of different network types
#ifdef _USE_PREAUTHENTICATION_
	AllowPreSendAuthentication, ///< Store HTTP authentication?
#endif
	BlockIDNAInvalidDomains, ///< Block IDNA Invalid Domains
#ifdef ADD_PERMUTE_NAME_PARTS
	CheckHostOnLocalNetwork, ///< Check local network URLs?
#endif
#ifdef DNS_PREFETCHING
	DNSPrefetching, ///< Enables DNS prefetching when hovering and parsing links
#endif
#ifdef URL_FILTER
	EnableContentBlocker, ///< Enable the content blocker
#endif
	EnableCookiesDNSCheck, ///< Enable support for checking for the cookie monster bug with a DNS/HEAD request
	EnableCookiesV2, ///< Enable support for Cookies version 2, RFC 2965
	DoNotTrack, ///< Enables the Do-Not-Track HTTP header (DNT), to express your preference that third party websites (e.g. ad networks) not track your identity between websites
#ifdef ADD_PERMUTE_NAME_PARTS
	CheckPermutedHostNames, ///< Use auto-completion of URLs?
	EnableHostNameWebLookup, ///< Perform Web search for entered host name?
#endif
#ifdef _SUPPORT_PROXY_NTLM_AUTH_
	EnableNTLM, ///< Enable NTLM and Negotiate authentication methods.
#endif
#ifdef HTTP_CONNECTION_TIMERS
	HTTPIdleTimeout, ///< Timeout for idle HTTP (seconds)
	HTTPResponseTimeout, ///< Timeout for HTTP responses (seconds)
#endif
	HoldOnFillingPipelines, ///< Hold On Filling Pipelines
	IPAddressSecondsToLive, ///< Time in seconds during which an IP address is pinned in memory after a successful resolve. A value equal or lower than 0 means forever.
#ifdef PREFS_HAVE_PREFER_IPV6
	PreferIPv6, ///< Prefer IPv6 if available
#endif
#ifdef USE_SPDY
	SpdyAlwaysForSSL, ///< Forces Opera to always use SPDY for SSL, even if not negotiated with NPN; 0 = disabled, 1 = spdy/2, 2 = spdy/3
	SpdyInitialWindowSize, ///< Initial window size used in the flow control
	SpdyPingEnabled, ///< Enables Opera to initiate PINGs
	SpdyPingTimeout, ///< Timeout for PING response (in seconds)
	SpdySettingsPersistence, ///< Enables Opera to persist SPDY settings when requested by server side
	SpdySettingsPersistenceTimeout, ///< Time after unsused persisted settings are removed from the storage (in seconds)
	SpdyWithoutSSL, ///< Forces Opera to use SPDY instead of HTTP; 0 = disabled, 1 = spdy/2, 2 = spdy/3
#endif
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	TestLongbatch, ///< Enable the "long batch" test engine
#endif
#ifdef LIBSSL_AUTO_UPDATE_ROOTS_PERIODICALLY
	TimeOfLastCertUpdateCheck, ///< This setting holds the time of the last call home to Opera to check for updated Root Certificates
#endif
	TagUrlsUsingPasswordRelatedCookies, ///< Tag any Urls that may have been accessed with a cookie that may contain a password (directly or indirectly)
	UseUTF8Urls, ///< UTF-8 escape non-ASCII URLs
#ifdef FTP_SUPPORT
	UseAbsoluteFTPPath, ///< Absolute or relative FTP paths
#endif
#ifdef USE_SPDY
	UseSpdy2, ///< Enables Opera to use SPDY2 protocol
	UseSpdy3, ///< Enables Opera to use SPDY3 protocol
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && !defined __OEM_OPERATOR_CACHE_MANAGEMENT
	NeverFlushExpirationTimeDays, ///< Number of days to keep a never flush item
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	OperatorDiskCacheSize, ///< Size of operator disk cache (kbytes)
#endif
	EnablePipelining, ///< Enable HTTP Pipelining
	UseExtraIdleConnections, ///< Open extra idle connections to current server.
	MaxConnectionsServer, ///< Maximum simultaneous connections per server
	MaxConnectionsTotal, ///< Maximum simultaneous connections total
	MaxPersistentConnectionsServer, ///< Maximum simultaneous persistent connections per server
	NetworkBufferSize, ///< Size of network buffer, in kilobytes
	NoConnectionKeepAlive, ///< Allow persistent connections to servers for HTTP, FTP and news?
#ifdef PREFS_HOSTOVERRIDE
	Use100Continue, ///< Use 100-continue override for non-compliant host
#endif
	OpenIdleConnectionOnClose, ///< Open an idle connection to current server when a connection used for sending requests closes.
#ifdef SYNCHRONOUS_HOST_RESOLVING
	SyncDNSLookup, ///< Use synchronous DNS lookup
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	EmbeddedImageResize, ///< ByteMobile image resize enabled.
#endif
#ifdef _BYTEMOBILE
	BytemobileOptimizationEnabled, ///< ByteMobile optimization enabled
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	EmbeddedOptimizationLevel, ///< ByteMobile optimization level.
	EmbeddedPrediction, ///< ByteMobile prediction enabled.
#endif
	EnableHTTP11ForProxy, ///< Permit HTTP 1.1 when connecting to proxy
#ifdef URL_PER_SITE_PROXY_POLICY
	EnableProxy, ///< Enable proxy or not
#endif
	EnableStartWithHTTP11ForProxy, ///< Permit HTTP 1.1 on first request when connecting to proxy
	HasNoProxyServers, ///< Should the proxy exclusion list beused?
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	AutomaticProxyConfig, ///< Should automatic proxy configuration be used?
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	EmbeddedBytemobile, ///< Should ByteMobile proxy configuration be used?
#endif
#ifdef FTP_SUPPORT
	UseFTPProxy, ///< Enable FTP proxy
#endif
#ifdef GOPHER_SUPPORT
	UseGopherProxy, ///< Enable gopher proxy
#endif
	UseHTTPProxy, ///< Enable HTTP proxy
	UseHTTPSProxy, ///< Enable HTTPS proxy
#ifdef WEB_TURBO_MODE
	UseWebTurbo, ///< Enable Opera Turbo
#endif
	HasUseProxyLocalNames, ///< Should proxy be used on local servers?
#ifdef SOCKS_SUPPORT
	RemoteSocksDNS, ///< Let SOCKS proxy handle DNS lookups
	UseSOCKSProxy, ///< Enable SOCKS proxy
#endif
	UseSpdyForHTTPProxy, ///< Enable SPDY for HTTP proxy; 0 = disabled, 1 = spdy/2, 2 = spdy/3
	UseSpdyForTurbo, ///< Enable SPDY for Turbo
#ifdef WAIS_SUPPORT
	UseWAISProxy, ///< Enable WAIS proxy
#endif
#ifdef LIBSSL_ENABLE_CRL_SUPPORT
	UseCRLValidationForSSL, ///< Enable online revocation of certificates for ssl connections
#endif
#if defined _SSL_SUPPORT_ || defined LIBOPEAY_ENABLE_PARTLY_OPENSSL_SUPPORT
	CryptoMethodOverride, ///< "Bitflags for overriding handling of specific crypto methods"
#endif
#if defined _SSL_SUPPORT_ && defined SSL_2_0_SUPPORT
	EnableSSL2_X, ///< Enable SSL 2 support
#endif
#ifdef _SSL_SUPPORT_
	EnableSSL3_0, ///< Enable SSL 3.0 support
	EnableSSL3_1, ///< Enable TLS 1.0 support
	EnableTLS1_1, ///< Enable TLS 1.1 support
#endif
#if defined _SSL_SUPPORT_ && defined _SUPPORT_TLS_1_2
	EnableTLS1_2, ///< Enable TLS 1.2 support
#endif
#ifdef _SSL_SUPPORT_
	MinimumSecurityLevel, ///< Minimum SSL security level allowed
#endif
	UseOCSPValidation, ///< Enable online certificate validation
#ifdef CRYPTO_API_SUPPORT
	SecurityPasswordLifeTime, ///< Time to keep security password in mem (minutes)
#endif
#ifdef LIBSSL_ENABLE_SSL_FALSE_START
	UseSSLFalseStart, ///< Enable false start for faster tls/ssl handshakes.
#endif
#ifdef SSL_CHECK_EXT_VALIDATION_POLICY
	StrictEVMode, ///< Enable the strict Extended Validastion mode that does not permit the EV indicator to be displayed for EV documents that include non-EV content
#endif
#ifdef LIBSSL_ENABLE_STRICT_TRANSPORT_SECURITY
	UseStrictTransportSecurity, ///< If supported by server, only access the server using HTTPS.
#endif
#if defined M2_SUPPORT || defined WAND_SUPPORT
	UseParanoidMailpassword, ///< Use master password for Wand/e-mail
#endif
#ifdef _SSL_SUPPORT_
	WarnAboutImportedCACertificates, ///< Enable warnings about imported CA certificates
#endif
#ifdef _SSL_USE_SMARTCARD_
	AutomaticallyUseSingleAvailableSmartcard, ///< Undocumented
	SmartCardTimeOutMinutes, ///< Undocumented
	StrictSmartCardSecurityLevel, ///< Undocumented
	WarnIfNoSmartCardInReader, ///< Undocumented
#endif
#ifdef PREFS_HAVE_FORCE_CD
	ForceCD, ///< Only allow CD operation
#endif
	UABaseId, ///< Browser identification string
#ifdef _ASK_COOKIE
	AcceptCookiesSessionOnly, ///< Do not keep cookies after exiting Opera
	DisplayReceivedCookies, ///< Display incoming cookies
#endif
#ifdef PREFS_AUTOMATIC_RAMCACHE
	AutomaticRamCache, ///< Calculate size of RAM cache from total RAM
#endif
	EnableClientPull, ///< Enable redirection by HTTP header
	EnableClientRefresh, ///< Enable refresh by META tag
	ClientRefreshToSame, ///< Allow multiple refreshes by META tag to the same location
#ifdef _ASK_COOKIE
	CookiePathErrMode, ///< Avoid displaying error dialogs for cookie paths
#endif
#ifdef PREFS_HAVE_DISABLED_COOKIE_STATE
	DisabledCookieState, ///< Cookiestate setting when last enabled (used by UI)
#endif
	CookiesEnabled, ///< Enable cookie support
	ReferrerEnabled, ///< Enable Referer:
#ifdef TRUST_RATING
	EnableTrustRating, ///< Enable anti-phising by trust rating each visited web-site
#endif
#if defined VISITED_PAGES_SEARCH && !defined HISTORY_SUPPORT
	VSMaxIndexSize, ///< Maximum size of the index for visited pages search, 0 means that the index is disabled
#endif
#ifdef PREFS_HAVE_MAX_COOKIES
	MaxTotalCookies, ///< Maximum number of cookies
#endif
	NoLocalFile, ///< Disable browsing of local files
	OfflineMode, ///< Flag for offline mode
#ifdef PREFS_HAVE_RIM_MDS_BROWSER_MODE
	RIMMDSBrowserMode, ///< Enable RIM MDS browser mode
#endif
#if defined _ASK_COOKIE && !defined PUBSUFFIX_ENABLED
	DontShowCookieNoIPAddressErr, ///< Handling missing IP address when trying to set cookie (0=refuse with error, 1=refuse silently, 2=accept for server)
#endif
#ifdef _ASK_COOKIE
	ShowCookieDomainErr, ///< No cookie domain errors
#endif
	DecodeAll, ///< Decode images until cache is full.
	TrustServerTypes, ///< Trust server's Content-Types
#ifdef PREFS_HAVE_UAMODE
	UAMode, ///< UA string extension, used with Identify as on UI
#endif
#ifdef SMILEY_SUPPORT
	UseSmileyImages, ///< Enable smileys
#endif
	WarnInsecureFormSubmit, ///< Warn when form is submitted in clear text

	DummyLastIntegerPref
};
#define PCNETWORK_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionNetwork::DummyLastIntegerPref)

