/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionNetwork, PCNETWORK_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	P(SISP, "Id", UNI_L("")),
#endif
#if defined PREFS_HAVE_EBO_GUID || defined _EMBEDDED_BYTEMOBILE
	P(SNetwork, "ByteMobile GUID", UNI_L("")),
#endif
	P(SNetwork, "HTTP Accept", UNI_L("")),
	P(SNetwork, "HTTP Accept Language", UNI_L("")),
#ifdef ADD_PERMUTE_NAME_PARTS
	P(SNetwork, "HostName Expansion Postfix", UNI_L("")),
	P(SNetwork, "HostName Expansion Prefix", DEFAULT_PREFS_EXPANSION_PREFIX),
	P(SNetwork, "HostName Web Lookup Address", UNI_L("")),
#endif
	P(SNetwork, "IDNA White List", UNI_L(":no:jp:de:se:kr:tw:cn:at:dk:ch:li:museum:hu:")),
	P(SNetwork, "Permitted Ports", UNI_L("")),
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	P(SNetwork, "Test Longbatch URL", UNI_L("http://testsuites.oslo.osa/core/selftest/libssl/longbatch/all-ssl-urls.txt")),
#endif
#ifdef __OEM_EXTENDED_CACHE_MANAGEMENT
	P(SOEM, "Never Flush Trusted Servers", DEFAULT_OEM_TRUSTED_SERVERS),
	P(SOEM, "Out Of Coverage File Name", UNI_L("")),
#endif
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	P(SProxy, "Automatic Proxy Configuration URL", UNI_L("")),
#endif
#ifdef FTP_SUPPORT
	P(SProxy, "FTP server", UNI_L("")),
#endif
#ifdef GOPHER_SUPPORT
	P(SProxy, "Gopher server", UNI_L("")),
#endif
	P(SProxy, "HTTP server", UNI_L("")),
	P(SProxy, "HTTPS server", UNI_L("")),
	P(SProxy, "No Proxy Servers", UNI_L("")),
#ifdef WEB_TURBO_MODE
	P(SProxy, "Opera Turbo bypass URLs", UNI_L("")),
#endif
#ifdef SOCKS_SUPPORT
	P(SProxy, "SOCKS password", UNI_L("")),
	P(SProxy, "SOCKS server", UNI_L("")),
	P(SProxy, "SOCKS username", UNI_L("")),
#endif
#ifdef WAIS_SUPPORT
	P(SProxy, "WAIS server", UNI_L("")),
#endif
#if !defined _NATIVE_SSL_SUPPORT_
	P(SSecurityPrefs, "Master password check code", UNI_L("")),
#endif
#ifdef HELP_SUPPORT
	P(SUserPrefs, "Help URL", UNI_L("http://help.opera.com/help/")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionNetwork, PCNETWORK_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef _BITTORRENT_SUPPORT_
	I(SBitTorrent, "Bandwidth Restriction Mode", 1, prefssetting::integer),
	I(SBitTorrent, "Enable", TRUE, prefssetting::boolean),
	I(SBitTorrent, "Listen Port", DEFAULT_BITTORRENT_PORT, prefssetting::integer),
	I(SBitTorrent, "Max Download Rate", 0, prefssetting::integer),
	I(SBitTorrent, "Max Upload Rate", 0, prefssetting::integer),
	I(SBitTorrent, "Warning Dialog", TRUE, prefssetting::boolean),
#endif
	I(SCache, "Always Check Never-Expiring GET queries", DEFAULT_CHECK_NEVER_EXPIRE_GET_QUERIES, prefssetting::boolean),
	I(SCache, "Always Check Redirect", DEFAULT_CHECK_REDIRECT, prefssetting::boolean),
	I(SCache, "Always Check Redirect Images", DEFAULT_CHECK_REDIRECT_CHANGED_IMAGES, prefssetting::boolean),
	I(SCache, "Always Reload HTTPS In History", DEFAULT_RELOAD_HTTPS_IN_HISTORY, prefssetting::boolean),
	I(SCache, "Cache HTTPS After Sessions", TRUE, prefssetting::boolean),
	I(SCache, "Check Expiry History", CHECK_EXPIRY_NEVER, prefssetting::integer),
	I(SCache, "Check Expiry Load", CHECK_EXPIRY_NORMAL, prefssetting::integer),
#ifdef SUPPORT_THREADED_FILEWRITER
	I(SCache, "File Writer Cache Size", 0x40000, prefssetting::integer),
	I(SCache, "File Writer Thread Priority", 0, prefssetting::integer),
	I(SCache, "Set File Writer Thread Priority", FALSE, prefssetting::boolean),
#endif
	I(SDiskCache, "Buffer Size", DEFAULT_CACHE_DISK_BUFFER_SIZE, prefssetting::integer),
	I(SDiskCache, "Cache Docs", DEFAULT_CACHE_DISK_DOCS, prefssetting::boolean),
	I(SDiskCache, "Cache Figs", DEFAULT_CACHE_DISK_FIGS, prefssetting::boolean),
	I(SDiskCache, "Cache HTTPS", FALSE, prefssetting::boolean),
	I(SDiskCache, "Cache Other", DEFAULT_CACHE_DISK_OTHER, prefssetting::boolean),
	I(SDiskCache, "Docs Modification", TIME, prefssetting::integer),
	I(SDiskCache, "Documents Expiry", DEFAULT_DOCUMENTS_EXPIRY, prefssetting::integer),
#ifdef DISK_CACHE_SUPPORT
	I(SDiskCache, "Empty On Exit", FALSE, prefssetting::boolean),
	I(SDiskCache, "Enabled", DEFAULT_CACHE_TO_DISK, prefssetting::boolean),
#endif
	I(SDiskCache, "Figs Modification", TIME, prefssetting::integer),
	I(SDiskCache, "Images Expiry", DEFAULT_IMAGES_EXPIRY, prefssetting::integer),
#ifdef MEDIA_PLAYER_SUPPORT
	I(SDiskCache, "Media Cache Size", DEFAULT_MEDIA_CACHE_SIZE, prefssetting::integer),
#endif
#ifdef DISK_CACHE_SUPPORT
	I(SDiskCache, "Multimedia Stream Always", DEFAULT_MULTIMEDIA_STREAM_ALWAYS, prefssetting::boolean),
	I(SDiskCache, "Multimedia Stream Size", DEFAULT_MULTIMEDIA_STREAM_SIZE, prefssetting::integer),
	I(SDiskCache, "Multimedia Stream in RAM", DEFAULT_MULTIMEDIA_STREAM_RAM, prefssetting::boolean),
#endif
	I(SDiskCache, "Other Expiry", DEFAULT_OTHERS_EXPIRY, prefssetting::integer),
	I(SDiskCache, "Other Modification", TIME, prefssetting::integer),
	I(SDiskCache, "Size", DEFAULT_CACHE_DISK_SIZE, prefssetting::integer),
	I(SLink, "Expiry", 10, prefssetting::integer),
	I(SLink, "Expiry (Hours)", 10, prefssetting::integer),
	I(SNetwork, "Allow Cross Network Navigation", FALSE, prefssetting::boolean),
#ifdef _USE_PREAUTHENTICATION_
	I(SNetwork, "Allow Pre Authentication", TRUE, prefssetting::boolean),
#endif
	I(SNetwork, "Block IDNA Invalid Domains", FALSE, prefssetting::boolean),
#ifdef ADD_PERMUTE_NAME_PARTS
	I(SNetwork, "Check Local HostName", DEFAULT_ENABLE_LOCAL_HOST_NAME, prefssetting::boolean),
#endif
#ifdef DNS_PREFETCHING
	I(SNetwork, "DNS Prefetching", TRUE, prefssetting::boolean),
#endif
#ifdef URL_FILTER
	I(SNetwork, "Enable Content Blocker", TRUE, prefssetting::boolean),
#endif
	I(SNetwork, "Enable Cookies DNS Check", FALSE, prefssetting::boolean),
	I(SNetwork, "Enable Cookies V2", FALSE, prefssetting::boolean),
	I(SNetwork, "Enable Do Not Track Header", FALSE, prefssetting::boolean),
#ifdef ADD_PERMUTE_NAME_PARTS
	I(SNetwork, "Enable HostName Expansion", DEFAULT_ENABLE_HOSTNAME_EXPANSION, prefssetting::boolean),
	I(SNetwork, "Enable HostName Web Lookup", FALSE, prefssetting::boolean),
#endif
#ifdef _SUPPORT_PROXY_NTLM_AUTH_
	I(SNetwork, "Enable NTLM", TRUE, prefssetting::boolean),
#endif
#ifdef HTTP_CONNECTION_TIMERS
	I(SNetwork, "HTTP Idle Timeout", DEFAULT_HTTP_IDLE_TIMEOUT, prefssetting::integer),
	I(SNetwork, "HTTP Response Timeout", DEFAULT_HTTP_RESPONSE_TIMEOUT, prefssetting::integer),
#endif
	I(SNetwork, "Hold On Filling Pipelines", FALSE, prefssetting::boolean),
	I(SNetwork, "IP Address Seconds To Live", 600, prefssetting::integer),
#ifdef PREFS_HAVE_PREFER_IPV6
	I(SNetwork, "Prefer IPv6", FALSE, prefssetting::boolean),
#endif
#ifdef USE_SPDY
	I(SNetwork, "Spdy Always For SSL", 0, prefssetting::integer),
	I(SNetwork, "Spdy Initial Window Size", 65536, prefssetting::integer),
	I(SNetwork, "Spdy Ping", DEFAULT_SPDY_PING_ENABLED, prefssetting::boolean),
	I(SNetwork, "Spdy Ping Timeout", 30, prefssetting::integer),
	I(SNetwork, "Spdy Settings Persistence", TRUE, prefssetting::boolean),
	I(SNetwork, "Spdy Settings Persistence Timeout", 864000, prefssetting::integer),
	I(SNetwork, "Spdy Without SSL", 0, prefssetting::integer),
#endif
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	I(SNetwork, "Test Longbatch", FALSE, prefssetting::boolean),
#endif
#ifdef LIBSSL_AUTO_UPDATE_ROOTS_PERIODICALLY
	I(SNetwork, "Time Of Last Root Certificate Update Check", 0, prefssetting::integer),
#endif
	I(SNetwork, "Track Password Cookie Usage", FALSE, prefssetting::boolean),
	I(SNetwork, "UTF8 Escape URLs", TRUE, prefssetting::boolean),
#ifdef FTP_SUPPORT
	I(SNetwork, "Use Absolute FTP Path", FALSE, prefssetting::boolean),
#endif
#ifdef USE_SPDY
	I(SNetwork, "Use Spdy2", TRUE, prefssetting::boolean),
	I(SNetwork, "Use Spdy3", TRUE, prefssetting::boolean),
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && !defined __OEM_OPERATOR_CACHE_MANAGEMENT
	I(SOEM, "Never Flush Cache Expiration Time Days", 30, prefssetting::integer),
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	I(SOEM, "Operator Cache Size", DEFAULT_CACHE_DISK_SIZE, prefssetting::integer),
#endif
	I(SPerformance, "Enable Pipelining", TRUE, prefssetting::boolean),
	I(SPerformance, "Extra Idle Connections", DEFAULT_USE_EXTRA_IDLE_CONNECTIONS, prefssetting::boolean),
	I(SPerformance, "Max Connections Server", DEFAULT_MAX_CONNECTIONS_SERVER, prefssetting::integer),
	I(SPerformance, "Max Connections Total", DEFAULT_MAX_CONNECTIONS_TOTAL, prefssetting::integer),
	I(SPerformance, "Max Persistent Connections Server", DEFAULT_MAX_PERSISTENT_CONNECTIONS_SERVER, prefssetting::integer),
	I(SPerformance, "Network Buffer Size", DEFAULT_NETWORK_BUFFER_SIZE, prefssetting::integer),
	I(SPerformance, "No Connection Keepalive", DEFAULT_NOKEEPALIVE, prefssetting::boolean),
#ifdef PREFS_HOSTOVERRIDE
	I(SPerformance, "Non-Compliant Server 100 Continue", FALSE, prefssetting::boolean),
#endif
	I(SPerformance, "Open Idle Connections On Close", DEFAULT_OPEN_IDLE_CONNECTION_ON_CLOSE, prefssetting::boolean),
#ifdef SYNCHRONOUS_HOST_RESOLVING
	I(SPerformance, "Synchronous DNS Lookup", DEFAULT_SYNC_DNS_LOOKUP, prefssetting::boolean),
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	I(SProxy, "ByteMobile Image Resize", FALSE, prefssetting::boolean),
#endif
#ifdef _BYTEMOBILE
	I(SProxy, "ByteMobile Optimization", FALSE, prefssetting::boolean),
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	I(SProxy, "ByteMobile Optimization Level", 0, prefssetting::integer),
	I(SProxy, "ByteMobile Prediction", TRUE, prefssetting::boolean),
#endif
	I(SProxy, "Enable HTTP 1.1 for proxy", DEFAULT_HTTP_1_1_FOR_PROXY, prefssetting::boolean),
#ifdef URL_PER_SITE_PROXY_POLICY
	I(SProxy, "Enable Proxy", TRUE, prefssetting::boolean),
#endif
	I(SProxy, "Enable start with HTTP 1.1 for proxy", TRUE, prefssetting::boolean),
	I(SProxy, "No Proxy Servers Check", TRUE, prefssetting::boolean),
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	I(SProxy, "Use Automatic Proxy Configuration", FALSE, prefssetting::boolean),
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	I(SProxy, "Use ByteMobile Optimizing Proxy", TRUE, prefssetting::boolean),
#endif
#ifdef FTP_SUPPORT
	I(SProxy, "Use FTP", FALSE, prefssetting::boolean),
#endif
#ifdef GOPHER_SUPPORT
	I(SProxy, "Use GOPHER", FALSE, prefssetting::boolean),
#endif
	I(SProxy, "Use HTTP", FALSE, prefssetting::boolean),
	I(SProxy, "Use HTTPS", FALSE, prefssetting::boolean),
#ifdef WEB_TURBO_MODE
	I(SProxy, "Use Opera Turbo", DEFAULT_WEB_TURBO_MODE, prefssetting::integer),
#endif
	I(SProxy, "Use Proxy On Local Names Check", DEFAULT_PROXY_LOCAL_NAMES, prefssetting::boolean),
#ifdef SOCKS_SUPPORT
	I(SProxy, "Use Remote SOCKS DNS Lookups", FALSE, prefssetting::boolean),
	I(SProxy, "Use SOCKS", FALSE, prefssetting::boolean),
#endif
	I(SProxy, "Use SPDY for HTTP proxy", 0, prefssetting::integer),
	I(SProxy, "Use SPDY for Turbo", FALSE, prefssetting::boolean),
#ifdef WAIS_SUPPORT
	I(SProxy, "Use WAIS", FALSE, prefssetting::boolean),
#endif
#ifdef LIBSSL_ENABLE_CRL_SUPPORT
	I(SSecurityPrefs, "Certificate revocation lists for ssl", DEFAULT_USE_CRL_PREFERENCE_FOR_WEBCERTIFICATES, prefssetting::boolean),
#endif
#if defined _SSL_SUPPORT_ || defined LIBOPEAY_ENABLE_PARTLY_OPENSSL_SUPPORT
	I(SSecurityPrefs, "Crypto Method Overrides", DEFAULT_CRYPTO_METH_OVERRIDE, prefssetting::integer),
#endif
#if defined _SSL_SUPPORT_ && defined SSL_2_0_SUPPORT
	I(SSecurityPrefs, "Enable SSL v2", FALSE, prefssetting::boolean),
#endif
#ifdef _SSL_SUPPORT_
	I(SSecurityPrefs, "Enable SSL v3", TRUE, prefssetting::boolean),
	I(SSecurityPrefs, "Enable TLS v1.0", TRUE, prefssetting::boolean),
	I(SSecurityPrefs, "Enable TLS v1.1", FALSE, prefssetting::boolean),
#endif
#if defined _SSL_SUPPORT_ && defined _SUPPORT_TLS_1_2
	I(SSecurityPrefs, "Enable TLS v1.2", FALSE, prefssetting::boolean),
#endif
#ifdef _SSL_SUPPORT_
	I(SSecurityPrefs, "Minimum Security Level", 0, prefssetting::integer),
#endif
	I(SSecurityPrefs, "OCSP Validate Certificates", TRUE, prefssetting::boolean),
#ifdef CRYPTO_API_SUPPORT
	I(SSecurityPrefs, "Password Lifetime", 5, prefssetting::integer),
#endif
#ifdef LIBSSL_ENABLE_SSL_FALSE_START
	I(SSecurityPrefs, "SSL False Start Support", DEFAULT_PREFERENCE_ENABLE_SSL_FALSE_START, prefssetting::boolean),
#endif
#ifdef SSL_CHECK_EXT_VALIDATION_POLICY
	I(SSecurityPrefs, "Strict EV Mode", FALSE, prefssetting::boolean),
#endif
#ifdef LIBSSL_ENABLE_STRICT_TRANSPORT_SECURITY
	I(SSecurityPrefs, "Strict Transport Security support", DEFAULT_PREFERENCE_ENABLE_STRICT_TRANSPORT_SECURITY, prefssetting::boolean),
#endif
#if defined M2_SUPPORT || defined WAND_SUPPORT
	I(SSecurityPrefs, "Use Paranoid Mailpassword", FALSE, prefssetting::boolean),
#endif
#ifdef _SSL_SUPPORT_
	I(SSecurityPrefs, "Warn About Imported CA Certificates", DEFAULT_IMPORTED_CACERTIFICATES_WARNING, prefssetting::boolean),
#endif
#ifdef _SSL_USE_SMARTCARD_
	I(SSmartCards, "Automatically Select Single Certificate", TRUE, prefssetting::boolean),
	I(SSmartCards, "Session Timeout Minutes", 5, prefssetting::integer),
	I(SSmartCards, "Strict Management Level", 1, prefssetting::integer),
	I(SSmartCards, "Warn If No Card In Reader", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_FORCE_CD
	I(SSystem, "Force CD", FALSE, prefssetting::boolean),
#endif
	I(SUserAgent, "Spoof UserAgent ID", UA_Opera, prefssetting::integer),
#ifdef _ASK_COOKIE
	I(SUserPrefs, "Accept Cookies Session Only", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Ask For Cookie Confirmation", FALSE, prefssetting::boolean),
#endif
#ifdef PREFS_AUTOMATIC_RAMCACHE
	I(SUserPrefs, "Automatic RAM Cache", DEFAULT_AUTOMATIC_RAM_CACHE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Client Pull", DEFAULT_ENABLE_CLIENT_PULL, prefssetting::boolean),
	I(SUserPrefs, "Client Refresh", DEFAULT_ENABLE_CLIENT_REFRESH, prefssetting::boolean),
	I(SUserPrefs, "Client Refresh To Same Location", DEFAULT_ALLOW_CLIENT_REFRESH_TO_SAME, prefssetting::boolean),
#ifdef _ASK_COOKIE
	I(SUserPrefs, "Cookie Path Error Mode", 2, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_DISABLED_COOKIE_STATE
	I(SUserPrefs, "Disabled Cookie State", COOKIE_ALL, prefssetting::integer),
#endif
	I(SUserPrefs, "Enable Cookies", COOKIE_ALL, prefssetting::integer),
	I(SUserPrefs, "Enable Referrer", TRUE, prefssetting::boolean),
#ifdef TRUST_RATING
	I(SUserPrefs, "Enable Trust Rating", DEFAULT_TRUST_RATING_ENABLED, prefssetting::boolean),
#endif
#if defined VISITED_PAGES_SEARCH && !defined HISTORY_SUPPORT
	I(SUserPrefs, "Max Visited Pages Index Size", -1, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_MAX_COOKIES
	I(SUserPrefs, "Maximum Total Cookies", 300, prefssetting::integer),
#endif
	I(SUserPrefs, "No Local File", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Offline Mode", FALSE, prefssetting::boolean),
#ifdef PREFS_HAVE_RIM_MDS_BROWSER_MODE
	I(SUserPrefs, "RIM MDS Browser Mode", FALSE, prefssetting::boolean),
#endif
#if defined _ASK_COOKIE && !defined PUBSUFFIX_ENABLED
	I(SUserPrefs, "Set-Cookie No IP Address Policy", 2, prefssetting::integer),
#endif
#ifdef _ASK_COOKIE
	I(SUserPrefs, "Show Cookie Domain Errors", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Synchronous decode", DEFAULT_DECODEALL_MODE, prefssetting::boolean),
	I(SUserPrefs, "Trust Server Types", DEFAULT_TRUST_SERVER_TYPES, prefssetting::boolean),
#ifdef PREFS_HAVE_UAMODE
	I(SUserPrefs, "UA Mode", 0, prefssetting::integer),
#endif
#ifdef SMILEY_SUPPORT
	I(SUserPrefs, "Use Smiley Images", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Warn Insecure Form", DEFAULT_WARN_INSECURE_VALUE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionNetwork::stringpref e)
{
	switch (e) {
#ifdef COMPONENT_IN_UASTRING_SUPPORT
	case PrefsCollectionNetwork::IspUserAgentId:
		return dbg << "PrefsCollectionNetwork::IspUserAgentId";
#endif
#if defined PREFS_HAVE_EBO_GUID || defined _EMBEDDED_BYTEMOBILE
	case PrefsCollectionNetwork::BytemobileGUID:
		return dbg << "PrefsCollectionNetwork::BytemobileGUID";
#endif
	case PrefsCollectionNetwork::AcceptTypes:
		return dbg << "PrefsCollectionNetwork::AcceptTypes";
	case PrefsCollectionNetwork::AcceptLanguage:
		return dbg << "PrefsCollectionNetwork::AcceptLanguage";
#ifdef ADD_PERMUTE_NAME_PARTS
	case PrefsCollectionNetwork::HostNameExpansionPostfix:
		return dbg << "PrefsCollectionNetwork::HostNameExpansionPostfix";
	case PrefsCollectionNetwork::HostNameExpansionPrefix:
		return dbg << "PrefsCollectionNetwork::HostNameExpansionPrefix";
	case PrefsCollectionNetwork::HostNameWebLookupAddress:
		return dbg << "PrefsCollectionNetwork::HostNameWebLookupAddress";
#endif
	case PrefsCollectionNetwork::IdnaWhiteList:
		return dbg << "PrefsCollectionNetwork::IdnaWhiteList";
	case PrefsCollectionNetwork::PermittedPorts:
		return dbg << "PrefsCollectionNetwork::PermittedPorts";
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	case PrefsCollectionNetwork::LongbatchURL:
		return dbg << "PrefsCollectionNetwork::LongbatchURL";
#endif
#ifdef __OEM_EXTENDED_CACHE_MANAGEMENT
	case PrefsCollectionNetwork::NeverFlushTrustedServers:
		return dbg << "PrefsCollectionNetwork::NeverFlushTrustedServers";
	case PrefsCollectionNetwork::OutOfCoverageFileName:
		return dbg << "PrefsCollectionNetwork::OutOfCoverageFileName";
#endif
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	case PrefsCollectionNetwork::AutomaticProxyConfigURL:
		return dbg << "PrefsCollectionNetwork::AutomaticProxyConfigURL";
#endif
#ifdef FTP_SUPPORT
	case PrefsCollectionNetwork::FTPProxy:
		return dbg << "PrefsCollectionNetwork::FTPProxy";
#endif
#ifdef GOPHER_SUPPORT
	case PrefsCollectionNetwork::GopherProxy:
		return dbg << "PrefsCollectionNetwork::GopherProxy";
#endif
	case PrefsCollectionNetwork::HTTPProxy:
		return dbg << "PrefsCollectionNetwork::HTTPProxy";
	case PrefsCollectionNetwork::HTTPSProxy:
		return dbg << "PrefsCollectionNetwork::HTTPSProxy";
	case PrefsCollectionNetwork::NoProxyServers:
		return dbg << "PrefsCollectionNetwork::NoProxyServers";
#ifdef WEB_TURBO_MODE
	case PrefsCollectionNetwork::WebTurboBypassURLs:
		return dbg << "PrefsCollectionNetwork::WebTurboBypassURLs";
#endif
#ifdef SOCKS_SUPPORT
	case PrefsCollectionNetwork::SOCKSPass:
		return dbg << "PrefsCollectionNetwork::SOCKSPass";
	case PrefsCollectionNetwork::SOCKSProxy:
		return dbg << "PrefsCollectionNetwork::SOCKSProxy";
	case PrefsCollectionNetwork::SOCKSUser:
		return dbg << "PrefsCollectionNetwork::SOCKSUser";
#endif
#ifdef WAIS_SUPPORT
	case PrefsCollectionNetwork::WAISProxy:
		return dbg << "PrefsCollectionNetwork::WAISProxy";
#endif
#if !defined _NATIVE_SSL_SUPPORT_
	case PrefsCollectionNetwork::MasterPasswordCheckCodeAndSalt:
		return dbg << "PrefsCollectionNetwork::MasterPasswordCheckCodeAndSalt";
#endif
#ifdef HELP_SUPPORT
	case PrefsCollectionNetwork::HelpUrl:
		return dbg << "PrefsCollectionNetwork::HelpUrl";
#endif
	default:
		return dbg << "PrefsCollectionNetwork::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionNetwork::integerpref e)
{
	switch (e) {
#ifdef _BITTORRENT_SUPPORT_
	case PrefsCollectionNetwork::BTBandwidthRestrictionMode:
		return dbg << "PrefsCollectionNetwork::BTBandwidthRestrictionMode";
	case PrefsCollectionNetwork::EnableBitTorrent:
		return dbg << "PrefsCollectionNetwork::EnableBitTorrent";
	case PrefsCollectionNetwork::BTListenPort:
		return dbg << "PrefsCollectionNetwork::BTListenPort";
	case PrefsCollectionNetwork::BTMaxDownloadRate:
		return dbg << "PrefsCollectionNetwork::BTMaxDownloadRate";
	case PrefsCollectionNetwork::BTMaxUploadRate:
		return dbg << "PrefsCollectionNetwork::BTMaxUploadRate";
	case PrefsCollectionNetwork::BTWarningDialog:
		return dbg << "PrefsCollectionNetwork::BTWarningDialog";
#endif
	case PrefsCollectionNetwork::AlwaysCheckNeverExpireGetQueries:
		return dbg << "PrefsCollectionNetwork::AlwaysCheckNeverExpireGetQueries";
	case PrefsCollectionNetwork::AlwaysCheckRedirectChanged:
		return dbg << "PrefsCollectionNetwork::AlwaysCheckRedirectChanged";
	case PrefsCollectionNetwork::AlwaysCheckRedirectChangedImages:
		return dbg << "PrefsCollectionNetwork::AlwaysCheckRedirectChangedImages";
	case PrefsCollectionNetwork::AlwaysReloadHTTPSInHistory:
		return dbg << "PrefsCollectionNetwork::AlwaysReloadHTTPSInHistory";
	case PrefsCollectionNetwork::CacheHTTPSAfterSessions:
		return dbg << "PrefsCollectionNetwork::CacheHTTPSAfterSessions";
	case PrefsCollectionNetwork::CheckExpiryHistory:
		return dbg << "PrefsCollectionNetwork::CheckExpiryHistory";
	case PrefsCollectionNetwork::CheckExpiryLoad:
		return dbg << "PrefsCollectionNetwork::CheckExpiryLoad";
#ifdef SUPPORT_THREADED_FILEWRITER
	case PrefsCollectionNetwork::FileWriterCacheSize:
		return dbg << "PrefsCollectionNetwork::FileWriterCacheSize";
	case PrefsCollectionNetwork::FileWriterThreadPriority:
		return dbg << "PrefsCollectionNetwork::FileWriterThreadPriority";
	case PrefsCollectionNetwork::SetFileWriterThreadPriority:
		return dbg << "PrefsCollectionNetwork::SetFileWriterThreadPriority";
#endif
	case PrefsCollectionNetwork::DiskCacheBufferSize:
		return dbg << "PrefsCollectionNetwork::DiskCacheBufferSize";
	case PrefsCollectionNetwork::CacheDocs:
		return dbg << "PrefsCollectionNetwork::CacheDocs";
	case PrefsCollectionNetwork::CacheFigs:
		return dbg << "PrefsCollectionNetwork::CacheFigs";
	case PrefsCollectionNetwork::CacheHTTPS:
		return dbg << "PrefsCollectionNetwork::CacheHTTPS";
	case PrefsCollectionNetwork::CacheOther:
		return dbg << "PrefsCollectionNetwork::CacheOther";
	case PrefsCollectionNetwork::CheckDocModification:
		return dbg << "PrefsCollectionNetwork::CheckDocModification";
	case PrefsCollectionNetwork::DocExpiry:
		return dbg << "PrefsCollectionNetwork::DocExpiry";
#ifdef DISK_CACHE_SUPPORT
	case PrefsCollectionNetwork::EmptyCacheOnExit:
		return dbg << "PrefsCollectionNetwork::EmptyCacheOnExit";
	case PrefsCollectionNetwork::CacheToDisk:
		return dbg << "PrefsCollectionNetwork::CacheToDisk";
#endif
	case PrefsCollectionNetwork::CheckFigModification:
		return dbg << "PrefsCollectionNetwork::CheckFigModification";
	case PrefsCollectionNetwork::FigsExpiry:
		return dbg << "PrefsCollectionNetwork::FigsExpiry";
#ifdef MEDIA_PLAYER_SUPPORT
	case PrefsCollectionNetwork::MediaCacheSize:
		return dbg << "PrefsCollectionNetwork::MediaCacheSize";
#endif
#ifdef DISK_CACHE_SUPPORT
	case PrefsCollectionNetwork::MultimediaStreamAlways:
		return dbg << "PrefsCollectionNetwork::MultimediaStreamAlways";
	case PrefsCollectionNetwork::MultimediaStreamSize:
		return dbg << "PrefsCollectionNetwork::MultimediaStreamSize";
	case PrefsCollectionNetwork::MultimediaStreamRAM:
		return dbg << "PrefsCollectionNetwork::MultimediaStreamRAM";
#endif
	case PrefsCollectionNetwork::OtherExpiry:
		return dbg << "PrefsCollectionNetwork::OtherExpiry";
	case PrefsCollectionNetwork::CheckOtherModification:
		return dbg << "PrefsCollectionNetwork::CheckOtherModification";
	case PrefsCollectionNetwork::DiskCacheSize:
		return dbg << "PrefsCollectionNetwork::DiskCacheSize";
	case PrefsCollectionNetwork::FollowedLinkExpireDays:
		return dbg << "PrefsCollectionNetwork::FollowedLinkExpireDays";
	case PrefsCollectionNetwork::FollowedLinkExpireHours:
		return dbg << "PrefsCollectionNetwork::FollowedLinkExpireHours";
	case PrefsCollectionNetwork::AllowCrossNetworkNavigation:
		return dbg << "PrefsCollectionNetwork::AllowCrossNetworkNavigation";
#ifdef _USE_PREAUTHENTICATION_
	case PrefsCollectionNetwork::AllowPreSendAuthentication:
		return dbg << "PrefsCollectionNetwork::AllowPreSendAuthentication";
#endif
	case PrefsCollectionNetwork::BlockIDNAInvalidDomains:
		return dbg << "PrefsCollectionNetwork::BlockIDNAInvalidDomains";
#ifdef ADD_PERMUTE_NAME_PARTS
	case PrefsCollectionNetwork::CheckHostOnLocalNetwork:
		return dbg << "PrefsCollectionNetwork::CheckHostOnLocalNetwork";
#endif
#ifdef DNS_PREFETCHING
	case PrefsCollectionNetwork::DNSPrefetching:
		return dbg << "PrefsCollectionNetwork::DNSPrefetching";
#endif
#ifdef URL_FILTER
	case PrefsCollectionNetwork::EnableContentBlocker:
		return dbg << "PrefsCollectionNetwork::EnableContentBlocker";
#endif
	case PrefsCollectionNetwork::EnableCookiesDNSCheck:
		return dbg << "PrefsCollectionNetwork::EnableCookiesDNSCheck";
	case PrefsCollectionNetwork::EnableCookiesV2:
		return dbg << "PrefsCollectionNetwork::EnableCookiesV2";
	case PrefsCollectionNetwork::DoNotTrack:
		return dbg << "PrefsCollectionNetwork::DoNotTrack";
#ifdef ADD_PERMUTE_NAME_PARTS
	case PrefsCollectionNetwork::CheckPermutedHostNames:
		return dbg << "PrefsCollectionNetwork::CheckPermutedHostNames";
	case PrefsCollectionNetwork::EnableHostNameWebLookup:
		return dbg << "PrefsCollectionNetwork::EnableHostNameWebLookup";
#endif
#ifdef _SUPPORT_PROXY_NTLM_AUTH_
	case PrefsCollectionNetwork::EnableNTLM:
		return dbg << "PrefsCollectionNetwork::EnableNTLM";
#endif
#ifdef HTTP_CONNECTION_TIMERS
	case PrefsCollectionNetwork::HTTPIdleTimeout:
		return dbg << "PrefsCollectionNetwork::HTTPIdleTimeout";
	case PrefsCollectionNetwork::HTTPResponseTimeout:
		return dbg << "PrefsCollectionNetwork::HTTPResponseTimeout";
#endif
	case PrefsCollectionNetwork::HoldOnFillingPipelines:
		return dbg << "PrefsCollectionNetwork::HoldOnFillingPipelines";
	case PrefsCollectionNetwork::IPAddressSecondsToLive:
		return dbg << "PrefsCollectionNetwork::IPAddressSecondsToLive";
#ifdef PREFS_HAVE_PREFER_IPV6
	case PrefsCollectionNetwork::PreferIPv6:
		return dbg << "PrefsCollectionNetwork::PreferIPv6";
#endif
#ifdef USE_SPDY
	case PrefsCollectionNetwork::SpdyAlwaysForSSL:
		return dbg << "PrefsCollectionNetwork::SpdyAlwaysForSSL";
	case PrefsCollectionNetwork::SpdyInitialWindowSize:
		return dbg << "PrefsCollectionNetwork::SpdyInitialWindowSize";
	case PrefsCollectionNetwork::SpdyPingEnabled:
		return dbg << "PrefsCollectionNetwork::SpdyPingEnabled";
	case PrefsCollectionNetwork::SpdyPingTimeout:
		return dbg << "PrefsCollectionNetwork::SpdyPingTimeout";
	case PrefsCollectionNetwork::SpdySettingsPersistence:
		return dbg << "PrefsCollectionNetwork::SpdySettingsPersistence";
	case PrefsCollectionNetwork::SpdySettingsPersistenceTimeout:
		return dbg << "PrefsCollectionNetwork::SpdySettingsPersistenceTimeout";
	case PrefsCollectionNetwork::SpdyWithoutSSL:
		return dbg << "PrefsCollectionNetwork::SpdyWithoutSSL";
#endif
#if defined _NATIVE_SSL_SUPPORT_ && defined SELFTEST
	case PrefsCollectionNetwork::TestLongbatch:
		return dbg << "PrefsCollectionNetwork::TestLongbatch";
#endif
#ifdef LIBSSL_AUTO_UPDATE_ROOTS_PERIODICALLY
	case PrefsCollectionNetwork::TimeOfLastCertUpdateCheck:
		return dbg << "PrefsCollectionNetwork::TimeOfLastCertUpdateCheck";
#endif
	case PrefsCollectionNetwork::TagUrlsUsingPasswordRelatedCookies:
		return dbg << "PrefsCollectionNetwork::TagUrlsUsingPasswordRelatedCookies";
	case PrefsCollectionNetwork::UseUTF8Urls:
		return dbg << "PrefsCollectionNetwork::UseUTF8Urls";
#ifdef FTP_SUPPORT
	case PrefsCollectionNetwork::UseAbsoluteFTPPath:
		return dbg << "PrefsCollectionNetwork::UseAbsoluteFTPPath";
#endif
#ifdef USE_SPDY
	case PrefsCollectionNetwork::UseSpdy2:
		return dbg << "PrefsCollectionNetwork::UseSpdy2";
	case PrefsCollectionNetwork::UseSpdy3:
		return dbg << "PrefsCollectionNetwork::UseSpdy3";
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && !defined __OEM_OPERATOR_CACHE_MANAGEMENT
	case PrefsCollectionNetwork::NeverFlushExpirationTimeDays:
		return dbg << "PrefsCollectionNetwork::NeverFlushExpirationTimeDays";
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	case PrefsCollectionNetwork::OperatorDiskCacheSize:
		return dbg << "PrefsCollectionNetwork::OperatorDiskCacheSize";
#endif
	case PrefsCollectionNetwork::EnablePipelining:
		return dbg << "PrefsCollectionNetwork::EnablePipelining";
	case PrefsCollectionNetwork::UseExtraIdleConnections:
		return dbg << "PrefsCollectionNetwork::UseExtraIdleConnections";
	case PrefsCollectionNetwork::MaxConnectionsServer:
		return dbg << "PrefsCollectionNetwork::MaxConnectionsServer";
	case PrefsCollectionNetwork::MaxConnectionsTotal:
		return dbg << "PrefsCollectionNetwork::MaxConnectionsTotal";
	case PrefsCollectionNetwork::MaxPersistentConnectionsServer:
		return dbg << "PrefsCollectionNetwork::MaxPersistentConnectionsServer";
	case PrefsCollectionNetwork::NetworkBufferSize:
		return dbg << "PrefsCollectionNetwork::NetworkBufferSize";
	case PrefsCollectionNetwork::NoConnectionKeepAlive:
		return dbg << "PrefsCollectionNetwork::NoConnectionKeepAlive";
#ifdef PREFS_HOSTOVERRIDE
	case PrefsCollectionNetwork::Use100Continue:
		return dbg << "PrefsCollectionNetwork::Use100Continue";
#endif
	case PrefsCollectionNetwork::OpenIdleConnectionOnClose:
		return dbg << "PrefsCollectionNetwork::OpenIdleConnectionOnClose";
#ifdef SYNCHRONOUS_HOST_RESOLVING
	case PrefsCollectionNetwork::SyncDNSLookup:
		return dbg << "PrefsCollectionNetwork::SyncDNSLookup";
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	case PrefsCollectionNetwork::EmbeddedImageResize:
		return dbg << "PrefsCollectionNetwork::EmbeddedImageResize";
#endif
#ifdef _BYTEMOBILE
	case PrefsCollectionNetwork::BytemobileOptimizationEnabled:
		return dbg << "PrefsCollectionNetwork::BytemobileOptimizationEnabled";
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	case PrefsCollectionNetwork::EmbeddedOptimizationLevel:
		return dbg << "PrefsCollectionNetwork::EmbeddedOptimizationLevel";
	case PrefsCollectionNetwork::EmbeddedPrediction:
		return dbg << "PrefsCollectionNetwork::EmbeddedPrediction";
#endif
	case PrefsCollectionNetwork::EnableHTTP11ForProxy:
		return dbg << "PrefsCollectionNetwork::EnableHTTP11ForProxy";
#ifdef URL_PER_SITE_PROXY_POLICY
	case PrefsCollectionNetwork::EnableProxy:
		return dbg << "PrefsCollectionNetwork::EnableProxy";
#endif
	case PrefsCollectionNetwork::EnableStartWithHTTP11ForProxy:
		return dbg << "PrefsCollectionNetwork::EnableStartWithHTTP11ForProxy";
	case PrefsCollectionNetwork::HasNoProxyServers:
		return dbg << "PrefsCollectionNetwork::HasNoProxyServers";
#ifdef SUPPORT_AUTO_PROXY_CONFIGURATION
	case PrefsCollectionNetwork::AutomaticProxyConfig:
		return dbg << "PrefsCollectionNetwork::AutomaticProxyConfig";
#endif
#ifdef _EMBEDDED_BYTEMOBILE
	case PrefsCollectionNetwork::EmbeddedBytemobile:
		return dbg << "PrefsCollectionNetwork::EmbeddedBytemobile";
#endif
#ifdef FTP_SUPPORT
	case PrefsCollectionNetwork::UseFTPProxy:
		return dbg << "PrefsCollectionNetwork::UseFTPProxy";
#endif
#ifdef GOPHER_SUPPORT
	case PrefsCollectionNetwork::UseGopherProxy:
		return dbg << "PrefsCollectionNetwork::UseGopherProxy";
#endif
	case PrefsCollectionNetwork::UseHTTPProxy:
		return dbg << "PrefsCollectionNetwork::UseHTTPProxy";
	case PrefsCollectionNetwork::UseHTTPSProxy:
		return dbg << "PrefsCollectionNetwork::UseHTTPSProxy";
#ifdef WEB_TURBO_MODE
	case PrefsCollectionNetwork::UseWebTurbo:
		return dbg << "PrefsCollectionNetwork::UseWebTurbo";
#endif
	case PrefsCollectionNetwork::HasUseProxyLocalNames:
		return dbg << "PrefsCollectionNetwork::HasUseProxyLocalNames";
#ifdef SOCKS_SUPPORT
	case PrefsCollectionNetwork::RemoteSocksDNS:
		return dbg << "PrefsCollectionNetwork::RemoteSocksDNS";
	case PrefsCollectionNetwork::UseSOCKSProxy:
		return dbg << "PrefsCollectionNetwork::UseSOCKSProxy";
#endif
	case PrefsCollectionNetwork::UseSpdyForHTTPProxy:
		return dbg << "PrefsCollectionNetwork::UseSpdyForHTTPProxy";
	case PrefsCollectionNetwork::UseSpdyForTurbo:
		return dbg << "PrefsCollectionNetwork::UseSpdyForTurbo";
#ifdef WAIS_SUPPORT
	case PrefsCollectionNetwork::UseWAISProxy:
		return dbg << "PrefsCollectionNetwork::UseWAISProxy";
#endif
#ifdef LIBSSL_ENABLE_CRL_SUPPORT
	case PrefsCollectionNetwork::UseCRLValidationForSSL:
		return dbg << "PrefsCollectionNetwork::UseCRLValidationForSSL";
#endif
#if defined _SSL_SUPPORT_ || defined LIBOPEAY_ENABLE_PARTLY_OPENSSL_SUPPORT
	case PrefsCollectionNetwork::CryptoMethodOverride:
		return dbg << "PrefsCollectionNetwork::CryptoMethodOverride";
#endif
#if defined _SSL_SUPPORT_ && defined SSL_2_0_SUPPORT
	case PrefsCollectionNetwork::EnableSSL2_X:
		return dbg << "PrefsCollectionNetwork::EnableSSL2_X";
#endif
#ifdef _SSL_SUPPORT_
	case PrefsCollectionNetwork::EnableSSL3_0:
		return dbg << "PrefsCollectionNetwork::EnableSSL3_0";
	case PrefsCollectionNetwork::EnableSSL3_1:
		return dbg << "PrefsCollectionNetwork::EnableSSL3_1";
	case PrefsCollectionNetwork::EnableTLS1_1:
		return dbg << "PrefsCollectionNetwork::EnableTLS1_1";
#endif
#if defined _SSL_SUPPORT_ && defined _SUPPORT_TLS_1_2
	case PrefsCollectionNetwork::EnableTLS1_2:
		return dbg << "PrefsCollectionNetwork::EnableTLS1_2";
#endif
#ifdef _SSL_SUPPORT_
	case PrefsCollectionNetwork::MinimumSecurityLevel:
		return dbg << "PrefsCollectionNetwork::MinimumSecurityLevel";
#endif
	case PrefsCollectionNetwork::UseOCSPValidation:
		return dbg << "PrefsCollectionNetwork::UseOCSPValidation";
#ifdef CRYPTO_API_SUPPORT
	case PrefsCollectionNetwork::SecurityPasswordLifeTime:
		return dbg << "PrefsCollectionNetwork::SecurityPasswordLifeTime";
#endif
#ifdef LIBSSL_ENABLE_SSL_FALSE_START
	case PrefsCollectionNetwork::UseSSLFalseStart:
		return dbg << "PrefsCollectionNetwork::UseSSLFalseStart";
#endif
#ifdef SSL_CHECK_EXT_VALIDATION_POLICY
	case PrefsCollectionNetwork::StrictEVMode:
		return dbg << "PrefsCollectionNetwork::StrictEVMode";
#endif
#ifdef LIBSSL_ENABLE_STRICT_TRANSPORT_SECURITY
	case PrefsCollectionNetwork::UseStrictTransportSecurity:
		return dbg << "PrefsCollectionNetwork::UseStrictTransportSecurity";
#endif
#if defined M2_SUPPORT || defined WAND_SUPPORT
	case PrefsCollectionNetwork::UseParanoidMailpassword:
		return dbg << "PrefsCollectionNetwork::UseParanoidMailpassword";
#endif
#ifdef _SSL_SUPPORT_
	case PrefsCollectionNetwork::WarnAboutImportedCACertificates:
		return dbg << "PrefsCollectionNetwork::WarnAboutImportedCACertificates";
#endif
#ifdef _SSL_USE_SMARTCARD_
	case PrefsCollectionNetwork::AutomaticallyUseSingleAvailableSmartcard:
		return dbg << "PrefsCollectionNetwork::AutomaticallyUseSingleAvailableSmartcard";
	case PrefsCollectionNetwork::SmartCardTimeOutMinutes:
		return dbg << "PrefsCollectionNetwork::SmartCardTimeOutMinutes";
	case PrefsCollectionNetwork::StrictSmartCardSecurityLevel:
		return dbg << "PrefsCollectionNetwork::StrictSmartCardSecurityLevel";
	case PrefsCollectionNetwork::WarnIfNoSmartCardInReader:
		return dbg << "PrefsCollectionNetwork::WarnIfNoSmartCardInReader";
#endif
#ifdef PREFS_HAVE_FORCE_CD
	case PrefsCollectionNetwork::ForceCD:
		return dbg << "PrefsCollectionNetwork::ForceCD";
#endif
	case PrefsCollectionNetwork::UABaseId:
		return dbg << "PrefsCollectionNetwork::UABaseId";
#ifdef _ASK_COOKIE
	case PrefsCollectionNetwork::AcceptCookiesSessionOnly:
		return dbg << "PrefsCollectionNetwork::AcceptCookiesSessionOnly";
	case PrefsCollectionNetwork::DisplayReceivedCookies:
		return dbg << "PrefsCollectionNetwork::DisplayReceivedCookies";
#endif
#ifdef PREFS_AUTOMATIC_RAMCACHE
	case PrefsCollectionNetwork::AutomaticRamCache:
		return dbg << "PrefsCollectionNetwork::AutomaticRamCache";
#endif
	case PrefsCollectionNetwork::EnableClientPull:
		return dbg << "PrefsCollectionNetwork::EnableClientPull";
	case PrefsCollectionNetwork::EnableClientRefresh:
		return dbg << "PrefsCollectionNetwork::EnableClientRefresh";
	case PrefsCollectionNetwork::ClientRefreshToSame:
		return dbg << "PrefsCollectionNetwork::ClientRefreshToSame";
#ifdef _ASK_COOKIE
	case PrefsCollectionNetwork::CookiePathErrMode:
		return dbg << "PrefsCollectionNetwork::CookiePathErrMode";
#endif
#ifdef PREFS_HAVE_DISABLED_COOKIE_STATE
	case PrefsCollectionNetwork::DisabledCookieState:
		return dbg << "PrefsCollectionNetwork::DisabledCookieState";
#endif
	case PrefsCollectionNetwork::CookiesEnabled:
		return dbg << "PrefsCollectionNetwork::CookiesEnabled";
	case PrefsCollectionNetwork::ReferrerEnabled:
		return dbg << "PrefsCollectionNetwork::ReferrerEnabled";
#ifdef TRUST_RATING
	case PrefsCollectionNetwork::EnableTrustRating:
		return dbg << "PrefsCollectionNetwork::EnableTrustRating";
#endif
#if defined VISITED_PAGES_SEARCH && !defined HISTORY_SUPPORT
	case PrefsCollectionNetwork::VSMaxIndexSize:
		return dbg << "PrefsCollectionNetwork::VSMaxIndexSize";
#endif
#ifdef PREFS_HAVE_MAX_COOKIES
	case PrefsCollectionNetwork::MaxTotalCookies:
		return dbg << "PrefsCollectionNetwork::MaxTotalCookies";
#endif
	case PrefsCollectionNetwork::NoLocalFile:
		return dbg << "PrefsCollectionNetwork::NoLocalFile";
	case PrefsCollectionNetwork::OfflineMode:
		return dbg << "PrefsCollectionNetwork::OfflineMode";
#ifdef PREFS_HAVE_RIM_MDS_BROWSER_MODE
	case PrefsCollectionNetwork::RIMMDSBrowserMode:
		return dbg << "PrefsCollectionNetwork::RIMMDSBrowserMode";
#endif
#if defined _ASK_COOKIE && !defined PUBSUFFIX_ENABLED
	case PrefsCollectionNetwork::DontShowCookieNoIPAddressErr:
		return dbg << "PrefsCollectionNetwork::DontShowCookieNoIPAddressErr";
#endif
#ifdef _ASK_COOKIE
	case PrefsCollectionNetwork::ShowCookieDomainErr:
		return dbg << "PrefsCollectionNetwork::ShowCookieDomainErr";
#endif
	case PrefsCollectionNetwork::DecodeAll:
		return dbg << "PrefsCollectionNetwork::DecodeAll";
	case PrefsCollectionNetwork::TrustServerTypes:
		return dbg << "PrefsCollectionNetwork::TrustServerTypes";
#ifdef PREFS_HAVE_UAMODE
	case PrefsCollectionNetwork::UAMode:
		return dbg << "PrefsCollectionNetwork::UAMode";
#endif
#ifdef SMILEY_SUPPORT
	case PrefsCollectionNetwork::UseSmileyImages:
		return dbg << "PrefsCollectionNetwork::UseSmileyImages";
#endif
	case PrefsCollectionNetwork::WarnInsecureFormSubmit:
		return dbg << "PrefsCollectionNetwork::WarnInsecureFormSubmit";
	default:
		return dbg << "PrefsCollectionNetwork::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
