/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
#ifdef ES_OVERRIDE_FPMODE
	FPMode, ///< Controls which floating point instruction is used in JIT code
#endif
#if defined SUPPORT_DEBUGGING_SHELL && !defined PREFS_TOOLS_PROXY
	OpShellProxyIP, ///< OBSOLETE - replaced by API_PRF_TOOLS_PROXY - IP address of the OpShell proxy server
#endif
#if defined ECMASCRIPT_REMOTE_DEBUGGER && !defined PREFS_TOOLS_PROXY
	EcmaScriptRemoteDebuggerIP, ///< OBSOLETE - replaced by API_PRF_TOOLS_PROXY - Host the remote script debugger connects to in active mode
#endif
	ES_AppCodeName, ///< appCodeName to return
	ES_NSAppName, ///< appName to return when identifying as Mozilla
#ifdef VEGA_3DDEVICE
	JS_HWAAccess, ///< Secure server allowed access to the window.opera.hwa DOM object. Normally the Opera Bugwizard.
#endif
	ES_IEAppName, ///< appName to return when identifying as MSIE
	ES_OperaAppName, ///< appName to return when identifying as Opera
#ifdef WEB_HANDLERS_SUPPORT
	DisallowedWebHandlers, ///< Determines protocols/mime types web handlers are not allowed to be registered for
#endif
#ifdef USER_JAVASCRIPT
	UserJSFiles, ///< Name of user javascript files
#endif

	DummyLastStringPref
};
#define PCJS_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionJS::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
#ifdef DELAYED_SCRIPT_EXECUTION
	DelayedScriptExecution, ///< Enable delayed script execution
#endif
#ifdef ES_HARDCORE_GC_MODE
	HardcoreGCMode, ///< Enables hardcore GC mode
#endif
#ifdef ECMASCRIPT_NATIVE_SUPPORT
	JIT, ///< Enables machine code generation for ECMAScript
#endif
#if defined SUPPORT_DEBUGGING_SHELL && !defined PREFS_TOOLS_PROXY
	OpShellProxyPort, ///< OBSOLETE - replaced by API_PRF_TOOLS_PROXY - Port number of the OpShell proxy server
#endif
#if defined ECMASCRIPT_DEBUGGER && defined ECMASCRIPT_REMOTE_DEBUGGER && !defined PREFS_TOOLS_PROXY
	EcmaScriptRemoteDebugger, ///< OBSOLETE - replaced by API_PRF_TOOLS_PROXY - Enable the remote script debugger
	EcmaScriptRemoteDebuggerPort, ///< OBSOLETE - replaced by API_PRF_TOOLS_PROXY - TCP port number for the remote script debugger
#endif
#if defined ECMASCRIPT_DEBUGGER && !defined PREFS_SCRIPT_DEBUG
	EcmaScriptDebugger, ///< OBSOLETE - replaced by API_PRF_TOOLS_SCRIPT_DEBUG - Enable the script debugger
#endif
	EcmaScriptEnabled, ///< Enable scripts
#ifdef CANVAS3D_SUPPORT
	ShaderValidation, ///< Enables validation of WebGL shader source
#endif
#ifdef SPECULATIVE_PARSER
	SpeculativeParser, ///< Enable speculative HTML parser
#endif
#ifdef DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
	EnableOrientation, ///< Enable or disable orientation and motion events
#endif
#ifdef USER_JAVASCRIPT
	UserJSAlwaysLoad, ///< User Javascript is always loaded
#endif
#ifdef DOM_BROWSERJS_SUPPORT
	BrowserJSSetting, ///< When to load browser JavaScript (0=never, 1=download but don't load, 2=download when changed and use)
#endif
#ifdef PREFS_HAVE_BROWSERJS_TIMESTAMP
	BrowserJSServerTimeStamp, ///< Identifies the browser.js which currently available at the server. This value is different from BrowserJSTimeStamp if a browser.js update is available on the server, but the update was not yet downloaded and installed.
	BrowserJSTimeStamp, ///< Identifies the browser.js currently used, used when checking for updates
#endif
#ifdef DOM_STREAM_API_SUPPORT
	AllowCamera, ///< Determines whether websites are allowed to access camera
#endif
#ifdef DOM_FULLSCREEN_MODE
	ChromelessDOMFullscreen, ///< Allows the DOM Fullscreen API to hide the browser chrome. Else the broser chrome is kept but content is still resized to fit the whole viewport.
#endif
#ifdef GEOLOCATION_SUPPORT
	AllowGeolocation, ///< Determines whether websites are allowed to retrieve the current geolocation
#endif
	IgnoreUnrequestedPopups, ///< Disallow unrequested window creation
#if defined DOCUMENT_EDIT_SUPPORT && defined USE_OP_CLIPBOARD
	LetSiteAccessClipboard, ///< Determines whether pages have access to the clipboard
#endif
#ifdef DOM_WEBWORKERS_SUPPORT
	MaxWorkersPerSession, ///< The maximum number of Web Worker instances to allow per browser session
	MaxWorkersPerWindow, ///< The maximum number of Web Worker instances to allow per scripting environment
#endif
	ScriptSpoof, ///< Special User Agent Id used only in scripts
	TargetDestination, ///< Open window in background, or ignore it
#ifdef USER_JAVASCRIPT
	UserJSEnabled, ///< User Javascript is enabled
	UserJSEnabledHTTPS, ///< User Javascript is enabled also on HTTPS pages
#endif

	DummyLastIntegerPref
};
#define PCJS_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionJS::DummyLastIntegerPref)

