/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionGeolocation, PCGEOLOCATION_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef GEOLOCATION_SUPPORT
	P(SGeolocation, "Google2011 Location Provider Access Token", UNI_L("")),
	P(SGeolocation, "Location Provider URL", UNI_L("https://maps.googleapis.com/maps/api/browserlocation/json")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionGeolocation, PCGEOLOCATION_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef GEOLOCATION_SUPPORT
	I(SGeolocation, "Enable geolocation", TRUE, prefssetting::boolean),
	I(SGeolocation, "Send location request only on change", TRUE, prefssetting::boolean),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionGeolocation::stringpref e)
{
	switch (e) {
#ifdef GEOLOCATION_SUPPORT
	case PrefsCollectionGeolocation::Google2011LocationProviderAccessToken:
		return dbg << "PrefsCollectionGeolocation::Google2011LocationProviderAccessToken";
	case PrefsCollectionGeolocation::LocationProviderUrl:
		return dbg << "PrefsCollectionGeolocation::LocationProviderUrl";
#endif
	default:
		return dbg << "PrefsCollectionGeolocation::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionGeolocation::integerpref e)
{
	switch (e) {
#ifdef GEOLOCATION_SUPPORT
	case PrefsCollectionGeolocation::EnableGeolocation:
		return dbg << "PrefsCollectionGeolocation::EnableGeolocation";
	case PrefsCollectionGeolocation::SendLocationRequestOnlyOnChange:
		return dbg << "PrefsCollectionGeolocation::SendLocationRequestOnlyOnChange";
#endif
	default:
		return dbg << "PrefsCollectionGeolocation::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
