/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all file preferences in this collection. */
enum filepref
{
#ifdef _BITTORRENT_SUPPORT_
	BTLogfile, ///< Log file for BitTorrent
#endif
#ifdef PREFS_HAVE_HOTLIST_EXTRA
	ContactListFile, ///< Name of contacts file
	MusicListFile, ///< Name of music player file
	NoteListFile, ///< Name of notes file
#endif
#ifdef M2_SUPPORT
	StyleMailFile, ///< Style for runtime generated mail pages
#endif
#ifdef _PLUGIN_SUPPORT_
	PluginIgnoreFile, ///< File with filenames of plugins to be ignored
#endif
#ifdef URL_FILTER
	UrlFilterFile, ///< Filter rules in exclude and include list
#endif
#ifdef WEB_TURBO_MODE
	WebTurboConfigFile, ///< Configuration file for Opera Turbo
#endif
#if defined OPERA_URL_SUPPORT
	StyleAboutFile, ///< Style for runtime generated about page
#endif
#ifdef AUTOSAVE_WINDOWS
	AutosaveWindowsStorageFile, ///< Name of file for automatic window storage
#endif
#ifdef PREFS_HAVE_BOOKMARKS_FILE
	BookmarksFile, ///< Name of bookmarks file
#endif
#ifdef OPERABOOKMARKS_URL
	StyleBookmarksFile, ///< Style for runtime generated bookmarks page
#endif
	BrowserCSSFile, ///< Name of browser default style sheet
#ifdef SKIN_SUPPORT
	ButtonSet, ///< Name of file holding skin setup
#endif
#if defined CPUUSAGETRACKING
	StyleCPUFile, ///< Style for runtime generated CPU page
#endif
#ifdef OPERA_URL_SUPPORT
	StyleCacheFile, ///< Style for runtime generated cache content page
#endif
#ifdef _SSL_SUPPORT_
	StyleCertificateInfoPanelFile, ///< Style for runtime generated certificate info panel content
#endif
#if defined OPERA_URL_SUPPORT && defined OPERACONFIG_URL
	StyleConfigFile, ///< Style for runtime generated config page
#endif
#ifdef OPERA_CONSOLE_LOGFILE
	ConsoleErrorLogName, ///< Name of file to which to log console messages
#endif
#ifdef SUPPORT_VISUAL_ADBLOCK
	ContentBlockCSSFile, ///< css file used in content block edit mode
#endif
#ifdef ABOUT_OPERA_DEBUG
	StyleDebugFile, ///< Style for runtime generated opera:debug page
#endif
#if defined DOM_JIL_API_SUPPORT
	DeviceSettingsFile, ///< File containing device specific settings
#endif
#if defined PREFS_HAVE_TOOLBARS
	DialogConfig, ///< File defining dialog layout
#endif
#if defined _LOCALHOST_SUPPORT_ || defined FTP_SUPPORT
	StyleDirFile, ///< Style for runtime generated directory listing
#endif
#ifdef DIRECT_HISTORY_SUPPORT
	DirectHistoryFile, ///< Name of file for direct URL entry history
#endif
#if defined PREFS_HOSTOVERRIDE && defined PREFSFILE_WRITE_GLOBAL
	DownloadedOverridesFile, ///< File storing downloaded host overrides
#endif
#if defined _LOCALHOST_SUPPORT_ && defined SYS_CAP_FILESYSTEM_HAS_MULTIPLE_DRIVES
	StyleDrivesFile, ///< Style for runtime generated drives listing
#endif
#ifdef PREFS_HAVE_ERROR_CSS
	StyleErrorFile, ///< Style for runtime generated error page
#endif
#if defined PREFS_HAVE_FASTFORWARD
	FastForwardFile, ///< File defining fast forward keywords
#endif
#if defined OPERA_URL_SUPPORT
	StyleGPUFile, ///< Style for runtime generated GPU page
#endif
#ifdef HISTORY_SUPPORT
	GlobalHistoryFile, ///< Name of file for global URL history
#endif
	HandlersDataFile, ///< File containing data of the protocol handlers/viewers
#ifdef WEB_HANDLERS_SUPPORT
	HandlersIgnoreFile, ///< File containing a white list of the protocols a handler can be registered for
#endif
#if defined OPERA_URL_SUPPORT && defined HISTORY_SUPPORT
	StyleHistoryFile, ///< Style for runtime generated history content page
#endif
#ifdef PREFS_HAVE_HOTLIST
	HotListFile, ///< Name of bookmarks file
#endif
#ifdef M2_SUPPORT
	StyleIMFile, ///< Style for runtime generated instant messenger
#endif
	StyleImageFile, ///< Style for runtime generated image page
#ifdef DOC_HAS_PAGE_INFO
	StyleInfoPanelFile, ///< Style for runtime generated info panel content
#endif
#if defined PREFS_HAVE_KEYBOARD_CONFIG
	KeyboardConfig, ///< File defining OpInputActions
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	LanguageFile, ///< Name of language file
#endif
	LocalCSSFile, ///< Name of user's style sheet
#ifdef _MIME_SUPPORT_
	StyleMIMEFile, ///< Style for runtime generated mime content
#endif
#ifdef CSS_MATHML_STYLESHEET
	MathMLCSSFile, ///< Name of MathML style sheet
#endif
#ifdef MEDIA_HTML_SUPPORT
	StyleMediaFile, ///< Style for runtime generated media page
#endif
#if defined PREFS_HAVE_TOOLBARS
	MenuConfig, ///< File defining menu layout
#endif
	StyleMessageFile, ///< Style for runtime generated message pages
#if defined PREFS_HAVE_MOUSE_CONFIG
	MouseConfig, ///< File defining OpInputActions
#endif
#ifdef SELFTEST
	StyleSelftestFile, ///< Style for runtime generated opera:selftest test page
#endif
#if defined OPERAUNITE_URL || defined OPERAWIDGETS_URL
	StyleWidgetsFile, ///< Style for runtime generated opera:widgets and opera:unite admin page
#endif
#ifdef PREFS_HOSTOVERRIDE
	OverridesFile, ///< File storing host overrides
#endif
#if defined SKIN_SUPPORT && defined PERSONA_SKIN_SUPPORT
	PersonaFile, ///< Name of file holding persona skin setup
#endif
#if defined OPERA_URL_SUPPORT && defined _PLUGIN_SUPPORT_
	StylePluginsFile, ///< Style for runtime generated plugins page
#endif
	StylePrivateModeFile, ///< Style for runtime generated opera:private page
#if !defined CORE_SPEED_DIAL_SUPPORT
	SpeedDialFile, ///< Speed Dial configuration file
#endif
#ifdef OPERASPEEDDIAL_URL
	StyleSpeedDialFile, ///< Style for speed dial page
#endif
#if defined PREFS_HAVE_TOOLBARS
	ToolbarConfig, ///< File defining toolbar layout
#endif
	UserStyleIniFile, ///< Name of userstyle.ini file
#ifdef MEDIA_HTML_SUPPORT
	VideobackendFile, ///< Shared library for rendering audio/video element
#endif
#ifdef OPERAHISTORYSEARCH_URL
	StyleSearchFile, ///< Style for visited pages search
#endif
#ifdef _WML_SUPPORT_
	WMLCSSFile, ///< Style for WML pages
#endif
#ifdef WAND_SUPPORT
	WandFile, ///< Wand storage file name
#endif
	StyleWarningFile, ///< Style for anti-phishing filter warning message
#if defined DATABASE_STORAGE_SUPPORT || defined CLIENTSIDE_STORAGE_SUPPORT
	StyleWebStorageFile, ///< Style for runtime generated opera:webstorage admin page
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && defined USE_ABOUT_TEMPLATES
	TemplateWebFeedsDisplay, ///< HTML template for runtime generated webfeed pages
#endif
#if defined WEBFEEDS_DISPLAY_SUPPORT && !defined USE_ABOUT_TEMPLATES
	StyleWebFeedsDisplay, ///< Style for runtime generated webfeed pages
#endif
#ifdef SESSION_SUPPORT
	WindowsStorageFile, ///< Name of file to store window settings in
#endif
#ifdef WEBSERVER_SUPPORT
	WebserverResourceConfiguration, ///< Path for separate configuration file
	TrustedRepositoriesFile, ///< Trusted repositories
#endif
#if defined PREFS_HAVE_HOTLIST_EXTRA && defined GADGET_SUPPORT
	GadgetListFile, ///< Name of gadgets file
#endif

	DummyLastFilePref
};
#define PCFILES_NUMBEROFFILEPREFS static_cast<int>(PrefsCollectionFiles::DummyLastFilePref)

#ifdef PREFS_READ
/** Enumeration of all directory preferences in this collection.
  * Please note that the preferences are accessed by using
  * OpFolderManager's OpFileFolder enumeration. */
enum directorypref
{
#ifdef M2_SUPPORT
	dummy_OPFILE_MAIL_FOLDER, ///< Mail root directory
#endif
#ifdef _FILE_UPLOAD_SUPPORT_
	dummy_OPFILE_OPEN_FOLDER, ///< File-Open directory
	dummy_OPFILE_SAVE_FOLDER, ///< File-Save directory
#endif
#ifdef PREFS_HAVE_BUTTON_FOLDER
	dummy_OPFILE_BUTTON_FOLDER, ///< Skin directory
#endif
#ifdef DISK_CACHE_SUPPORT
	dummy_OPFILE_CACHE_FOLDER, ///< Cache directory
#endif
	dummy_OPFILE_COOKIE_FOLDER, ///< Cookies (write) directory
#if defined DOM_JIL_API_SUPPORT
	dummy_OPFILE_DEVICE_SETTINGS_FOLDER, ///< Directory containing device specific configuration files
#endif
#ifdef PREFS_HAVE_DOWNLOAD_FOLDER
	dummy_OPFILE_DOWNLOAD_FOLDER, ///< Download directory
#endif
#if defined LANGUAGE_FILE_SUPPORT || defined LOCALE_BINARY_LANGUAGE_FILE
	dummy_OPFILE_LANGUAGE_FOLDER, ///< Opera language directory. This is the default location to look for language files etc. Note that the current language file may well reside somewhere else.
#endif
#ifdef PREFS_USE_CSS_FOLDER_SCAN
	dummy_OPFILE_USERPREFSSTYLE_FOLDER, ///< User style sheets directory
#endif
	dummy_OPFILE_HOME_FOLDER, ///< Opera home (write) directory
#ifdef UTIL_HAVE_LOCAL_HOME_FOLDER
	dummy_OPFILE_LOCAL_HOME_FOLDER, ///< Opera home (write) directory that is not part of the roaming profile
#endif
#if defined __OEM_EXTENDED_CACHE_MANAGEMENT && defined __OEM_OPERATOR_CACHE_MANAGEMENT
	dummy_OPFILE_OCACHE_FOLDER, ///< Operator cache directory
#endif
#ifdef SKIN_SUPPORT
	dummy_OPFILE_SKIN_FOLDER, ///< Skin directory
#endif
#ifdef EXTERNAL_APPLICATIONS_SUPPORT
	dummy_OPFILE_TEMPDOWNLOAD_FOLDER, ///< Temporary Download directory
#endif
#ifdef WEBSERVER_SUPPORT
	dummy_OPFILE_WEBSERVER_FOLDER, ///< Absolute path for web server's directory
#endif

	DummyLastFolderPref
};
#define PCFILES_NUMBEROFFOLDERPREFS static_cast<int>(PrefsCollectionFiles::DummyLastFolderPref)
#endif

