/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
#ifdef SEARCH_TEXT_SUPPORT
	DefaultSearchType, ///< Default search engine
#endif

	DummyLastStringPref
};
#define PCDOC_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionDoc::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
	ExternalImage, ///< Allow external images in handheld mode
#ifdef MEDIA_HTML_SUPPORT
	AllowAutoplay, ///< Allow media to autoplay
#endif
#ifdef SHORTCUT_ICON_SUPPORT
	AlwaysLoadFavIcon, ///< Load shortcut icons automatically
#endif
	ShowAnimation, ///< Enable animations
#ifdef IMAGE_TURBO_MODE
	TurboMode, ///< Draw images instantly
#endif
	PrefetchWebFonts, ///< Number of web fonts that may be prefetched. A non-zero value enables speculative prefetching of web fonts referred to by style sheets. When enabled pages using web fonts will generally be able to show content with the correct fonts earlier. However, there is a chance that style sheets refer to fonts that are never used, in which case unused fonts will get downloaded and load time increase.
	ReflowDelayLoad, ///< Determines how often, in milliseconds, we aim to reflow the document while loading.  Lower value means more "incremental" rendering, but slows loading down since we'll spend more time in total reflowing.  If the value is zero, there will be no delay, which is not recommended for anyone. The appropriate value for this tweak depends largely on platform performance, and so is difficult to estimate accurately based on profile only.  Testing and tuning "on device" while performing "average browsing" is typically very useful.
	ReflowDelayScript, ///< Determines how often, in milliseconds, we aim to reflow the document while executing a script (usually the reflow would then be caused by the script.)  Lower value means more "incremental" rendering, but slows down script execution since we'll spend more time in total reflowing.  If the value is zero, there will be no delay.
	WaitForStyles, ///< Determines how long we will hold the layout waiting for styles. This is to avoid drawing something unstyled (ugly)that will be replaced by something styled very soon. Setting this to 0 means that we won't wait for styles and instead show anything as fast as possible.
	WaitForWebFonts, ///< Determines how long we will suppress displaying web font text while waiting for the web font to load. This is to avoid drawing text with a fall back font that will later be replaced by a web font (FOUT). Setting this to 0 means that we will immediately display web font text using the fall back font. A non-zero value means that we won't display web font text until either the font is loaded or the time out expires and the fall back font is applied.
#ifdef TEXT_SELECTION_SUPPORT
	DisableTextSelect, ///< Disable text selection
#endif
#ifdef UPGRADE_SUPPORT
	TrustedProtocolsVersion, ///< Version number for handlers list
#endif
	AllowAutofocusFormElement, ///< Allow autofocus of form upon loading webpage, both via javascript focus() and html attribute autofocus. Turning this off will forbid any autofocusing except moving focus only between input text fields.
	AllowFileXMLHttpRequest, ///< Allow XMLHttpRequest between files which is something that is normally blocked for security reasons. Turning this on will allow web developers to test web applications stored on disk.
	AllowScriptToNavigateInHistory, ///< Enables or disables scripts to navigate in DOM history
	AlwaysReloadInterruptedImages, ///< Restart download of interrupted images when activating a document
	CompatModeOverride, ///< Override CSS compat mode found by DOCTYPE sniffing
	DisplayLinkTitle, ///< Dislay title of links
#ifdef _SPAT_NAV_SUPPORT_
	EnableSpatialNavigation, ///< Set to false to disable spatial navigation
#endif
#ifdef WEBSOCKETS_SUPPORT
	EnableWebSockets, ///< Enables or disables scripts to use WebSockets.
#endif
#ifdef ENCODINGS_HAVE_ENTITY_ENCODING
	UseEntitiesInForms, ///< Enable entities for unconvertible characters in forms data
#endif
	HistoryNavigationMode, ///< 1 = automatic, 2 = compatible, 3 = fast
	IgnoreTarget, ///< Disallow window creation
#ifdef _AUTO_WIN_RELOAD_SUPPORT_
	LastUsedAutoWindowReloadTimeout, ///< Last used value for automatic document reload (seconds)
#endif
#ifdef FORMS_LIMIT_FORM_SIZE
	MaximumBytesFormGet, ///< Maximum bytes to submit with GET in a form
	MaximumBytesFormPost, ///< Maximum bytes to submit with POST in a form
#endif
#ifdef FORMS_LIMIT_INPUT_SIZE
	MaximumBytesInputPassword, ///< Maximum bytes of content for a password field
	MaximumBytesInputText, ///< Maximum bytes of content for an input field
#endif
	NewWindow, ///< Do not reuse existing page
#ifdef VISITED_PAGES_SEARCH
	PageContentSearch, ///< Turns on/off web pages content indexing. Based on that indexed content results in Addressfield drop down might be presented, while typing.
#endif
	RenderingMode, ///< Start in SSR/MSR/desktop mode.
#ifdef SAVE_SUPPORT
	TxtCharsPerLine, ///< Characters per line when saving as text
	SaveUseSubfolder, ///< Save with images should store images in a subfolder
#endif
	ShowImageState, ///< 1 = no images, 2 = show cached, 3 = all images
#ifdef PAGED_MEDIA_SUPPORT
	ShowPageControls, ///< Allow the page control widget to be displayed (for paged documents)
#endif
	ShowScrollbars, ///< Show scroll bars
	ShowWinSize, ///< Show window size
	SingleWindowBrowsing, ///< Use the current window instead of creating new ones for popups.
#ifdef CORE_THUMBNAIL_SUPPORT
	ThumbnailRequestHeader, ///< Sends an additional HTTP header along with a thumbnail request
#endif
	SuppressExternalEmbeds, ///< Suppress loading of external inline elements
#ifdef CORE_THUMBNAIL_SUPPORT
	ThumbnailAspectRatioX, ///< This value, along with the Y value, determines the aspect ratio of the Speed Dial thumbnails.
	ThumbnailAspectRatioY, ///< This value, along with the X value, determines the aspect ratio of the Speed Dial thumbnails.
#endif
#ifdef THUMBNAILS_LOGO_TUNING_VIA_PREFS
	ThumbnailIconMinH, ///< Thumbnail icon min height
	ThumbnailIconMinW, ///< Thumbnail icon min width
	ThumbnailLogoPosMaxX, ///< Thumbnail logo pos max X
	ThumbnailLogoPosMaxY, ///< Thumbnail logo pos max Y
	ThumbnailLogoScoreBanner, ///< Thumbnail logo scoring banner
	ThumbnailLogoScoreLogoALT, ///< Thumbnail logo scoring logo ALT
	ThumbnailLogoScoreLogoURL, ///< Thumbnail logo scoring logo URL
	ThumbnailLogoScoreSiteALT, ///< Thumbnail logo scoring site ALT
	ThumbnailLogoScoreSiteLink, ///< Thumbnail logo scoring site link
	ThumbnailLogoScoreSiteURL, ///< Thumbnail logo scoring site URL
	ThumbnailLogoScoreThreshold, ///< Thumbnail logo scoring threshold used when looking for page logo for speeddial thumbnail.
	ThumbnailLogoScoreX, ///< Thumbnail logo scoring X
	ThumbnailLogoScoreY, ///< Thumbnail logo scoring Y
	ThumbnailLogoSizeMaxX, ///< Thumbnail logo size max X
	ThumbnailLogoSizeMaxY, ///< Thumbnail logo size max y
	ThumbnailLogoSizeMinX, ///< Thumbnail logo size min X
	ThumbnailLogoSizeMinY, ///< Thumbnail logo size min y
#endif
#ifdef MEDIA_HTML_SUPPORT
	MediaPlaybackTimeUpdateInterval, ///< Define the interval between timeupdate events in milliseconds
#endif
	XMLLoadExternalEntities, ///< Load external doctype subset and other referenced external entities.

	DummyLastIntegerPref
};
#define PCDOC_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionDoc::DummyLastIntegerPref)

