/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionDoc, PCDOC_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef SEARCH_TEXT_SUPPORT
	P(SUserPrefs, "Search Type", UNI_L("7A8CADE6677811DDBA4B5E9D55D89593")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionDoc, PCDOC_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SHandheld, "External Image", TRUE, prefssetting::boolean),
#ifdef MEDIA_HTML_SUPPORT
	I(SMultimedia, "Allow Autoplay", DEFAULT_ALLOW_AUTOPLAY, prefssetting::boolean),
#endif
#ifdef SHORTCUT_ICON_SUPPORT
	I(SMultimedia, "Always load favicon", DEFAULT_ALWAYS_LOAD_FAVICON, prefssetting::integer),
#endif
	I(SMultimedia, "Show Animation", DEFAULT_SHOW_ANIMATION, prefssetting::boolean),
#ifdef IMAGE_TURBO_MODE
	I(SPerformance, "Draw Images Instantly", DEFAULT_TURBO_MODE, prefssetting::boolean),
#endif
	I(SPerformance, "Prefetch Web Fonts", DEFAULT_PREFETCH_WEB_FONTS, prefssetting::integer),
	I(SPerformance, "Reflow Delay Load", DEFAULT_DOC_REFLOW_DELAY_LOAD, prefssetting::integer),
	I(SPerformance, "Reflow Delay Script", DEFAULT_DOC_REFLOW_DELAY_SCRIPT, prefssetting::integer),
	I(SPerformance, "Wait For Styles", DEFAULT_STYLESHEET_TIMEOUT_TIME, prefssetting::integer),
	I(SPerformance, "Wait For Web Fonts", DEFAULT_WEB_FONT_TIMEOUT, prefssetting::integer),
#ifdef TEXT_SELECTION_SUPPORT
	I(SSystem, "DisableTextSelect", FALSE, prefssetting::boolean),
#endif
#ifdef UPGRADE_SUPPORT
	I(STrustedProtocolsSectionInfo, "Version", 0, prefssetting::integer),
#endif
	I(SUserPrefs, "Allow Autofocus Form Element", DEFAULT_ALLOW_AUTOFOCUS_FORM_ELEMENT, prefssetting::boolean),
	I(SUserPrefs, "Allow File XMLHttpRequest", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Allow Scripts To Navigate In History", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Always Reload Interrupted Images", FALSE, prefssetting::boolean),
	I(SUserPrefs, "CompatMode Override", CSS_COMPAT_MODE_AUTO, prefssetting::integer),
	I(SUserPrefs, "Display Link Title", TRUE, prefssetting::boolean),
#ifdef _SPAT_NAV_SUPPORT_
	I(SUserPrefs, "Enable Spatial Navigation", TRUE, prefssetting::boolean),
#endif
#ifdef WEBSOCKETS_SUPPORT
	I(SUserPrefs, "Enable WebSockets", TRUE, prefssetting::boolean),
#endif
#ifdef ENCODINGS_HAVE_ENTITY_ENCODING
	I(SUserPrefs, "Entities In Forms", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "History Navigation Mode", 1, prefssetting::integer),
	I(SUserPrefs, "Ignore Target", DEFAULT_IGNORETARGET, prefssetting::boolean),
#ifdef _AUTO_WIN_RELOAD_SUPPORT_
	I(SUserPrefs, "Last Used Auto Window Timeout", DEFAULT_AUTO_WINDOW_TIMEOUT, prefssetting::integer),
#endif
#ifdef FORMS_LIMIT_FORM_SIZE
	I(SUserPrefs, "Max Bytes Form Get", 5000, prefssetting::integer),
	I(SUserPrefs, "Max Bytes Form Post", DEFAULT_MAX_BYTES_FORM_POST, prefssetting::integer),
#endif
#ifdef FORMS_LIMIT_INPUT_SIZE
	I(SUserPrefs, "Max Bytes Input Password", 128, prefssetting::integer),
	I(SUserPrefs, "Max Bytes Input Text", 256, prefssetting::integer),
#endif
	I(SUserPrefs, "New Window", FALSE, prefssetting::boolean),
#ifdef VISITED_PAGES_SEARCH
	I(SUserPrefs, "Page Content Search results In Addressfield Dropdown", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Rendering mode", DEFAULT_LAYOUTMODE, prefssetting::integer),
#ifdef SAVE_SUPPORT
	I(SUserPrefs, "Save As Text Line Length", 80, prefssetting::integer),
	I(SUserPrefs, "Save With Images Use Subfolder", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show Images", FIGS_ON, prefssetting::integer),
#ifdef PAGED_MEDIA_SUPPORT
	I(SUserPrefs, "Show Page Controls", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Show ScrollBars", DEFAULT_SHOW_SCROLLBARS, prefssetting::boolean),
	I(SUserPrefs, "Show Window Size", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Single Window Browsing", FALSE, prefssetting::boolean),
#ifdef CORE_THUMBNAIL_SUPPORT
	I(SUserPrefs, "Speeddial Thumbnail Request Header", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Suppress External Embeds", TRUE, prefssetting::boolean),
#ifdef CORE_THUMBNAIL_SUPPORT
	I(SUserPrefs, "Thumbnail Aspect Ratio X", 16, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Aspect Ratio Y", 10, prefssetting::integer),
#endif
#ifdef THUMBNAILS_LOGO_TUNING_VIA_PREFS
	I(SUserPrefs, "Thumbnail Icon Min Height", 114, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Icon Min Width", 114, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Pos Max X", 1200, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Pos Max Y", 300, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Banner", 90, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Logo ALT", 70, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Logo URL", 75, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Site ALT", 35, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Site Link", 20, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Site URL", 20, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Threshold", 75, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score X", 20, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Score Y", 35, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Size Max X", 800, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Size Max Y", 199, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Size Min X", 20, prefssetting::integer),
	I(SUserPrefs, "Thumbnail Logo Size Min Y", 15, prefssetting::integer),
#endif
#ifdef MEDIA_HTML_SUPPORT
	I(SUserPrefs, "Time Update Interval", 200, prefssetting::integer),
#endif
	I(SUserPrefs, "XML Load External Entities", FALSE, prefssetting::boolean),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionDoc::stringpref e)
{
	switch (e) {
#ifdef SEARCH_TEXT_SUPPORT
	case PrefsCollectionDoc::DefaultSearchType:
		return dbg << "PrefsCollectionDoc::DefaultSearchType";
#endif
	default:
		return dbg << "PrefsCollectionDoc::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionDoc::integerpref e)
{
	switch (e) {
	case PrefsCollectionDoc::ExternalImage:
		return dbg << "PrefsCollectionDoc::ExternalImage";
#ifdef MEDIA_HTML_SUPPORT
	case PrefsCollectionDoc::AllowAutoplay:
		return dbg << "PrefsCollectionDoc::AllowAutoplay";
#endif
#ifdef SHORTCUT_ICON_SUPPORT
	case PrefsCollectionDoc::AlwaysLoadFavIcon:
		return dbg << "PrefsCollectionDoc::AlwaysLoadFavIcon";
#endif
	case PrefsCollectionDoc::ShowAnimation:
		return dbg << "PrefsCollectionDoc::ShowAnimation";
#ifdef IMAGE_TURBO_MODE
	case PrefsCollectionDoc::TurboMode:
		return dbg << "PrefsCollectionDoc::TurboMode";
#endif
	case PrefsCollectionDoc::PrefetchWebFonts:
		return dbg << "PrefsCollectionDoc::PrefetchWebFonts";
	case PrefsCollectionDoc::ReflowDelayLoad:
		return dbg << "PrefsCollectionDoc::ReflowDelayLoad";
	case PrefsCollectionDoc::ReflowDelayScript:
		return dbg << "PrefsCollectionDoc::ReflowDelayScript";
	case PrefsCollectionDoc::WaitForStyles:
		return dbg << "PrefsCollectionDoc::WaitForStyles";
	case PrefsCollectionDoc::WaitForWebFonts:
		return dbg << "PrefsCollectionDoc::WaitForWebFonts";
#ifdef TEXT_SELECTION_SUPPORT
	case PrefsCollectionDoc::DisableTextSelect:
		return dbg << "PrefsCollectionDoc::DisableTextSelect";
#endif
#ifdef UPGRADE_SUPPORT
	case PrefsCollectionDoc::TrustedProtocolsVersion:
		return dbg << "PrefsCollectionDoc::TrustedProtocolsVersion";
#endif
	case PrefsCollectionDoc::AllowAutofocusFormElement:
		return dbg << "PrefsCollectionDoc::AllowAutofocusFormElement";
	case PrefsCollectionDoc::AllowFileXMLHttpRequest:
		return dbg << "PrefsCollectionDoc::AllowFileXMLHttpRequest";
	case PrefsCollectionDoc::AllowScriptToNavigateInHistory:
		return dbg << "PrefsCollectionDoc::AllowScriptToNavigateInHistory";
	case PrefsCollectionDoc::AlwaysReloadInterruptedImages:
		return dbg << "PrefsCollectionDoc::AlwaysReloadInterruptedImages";
	case PrefsCollectionDoc::CompatModeOverride:
		return dbg << "PrefsCollectionDoc::CompatModeOverride";
	case PrefsCollectionDoc::DisplayLinkTitle:
		return dbg << "PrefsCollectionDoc::DisplayLinkTitle";
#ifdef _SPAT_NAV_SUPPORT_
	case PrefsCollectionDoc::EnableSpatialNavigation:
		return dbg << "PrefsCollectionDoc::EnableSpatialNavigation";
#endif
#ifdef WEBSOCKETS_SUPPORT
	case PrefsCollectionDoc::EnableWebSockets:
		return dbg << "PrefsCollectionDoc::EnableWebSockets";
#endif
#ifdef ENCODINGS_HAVE_ENTITY_ENCODING
	case PrefsCollectionDoc::UseEntitiesInForms:
		return dbg << "PrefsCollectionDoc::UseEntitiesInForms";
#endif
	case PrefsCollectionDoc::HistoryNavigationMode:
		return dbg << "PrefsCollectionDoc::HistoryNavigationMode";
	case PrefsCollectionDoc::IgnoreTarget:
		return dbg << "PrefsCollectionDoc::IgnoreTarget";
#ifdef _AUTO_WIN_RELOAD_SUPPORT_
	case PrefsCollectionDoc::LastUsedAutoWindowReloadTimeout:
		return dbg << "PrefsCollectionDoc::LastUsedAutoWindowReloadTimeout";
#endif
#ifdef FORMS_LIMIT_FORM_SIZE
	case PrefsCollectionDoc::MaximumBytesFormGet:
		return dbg << "PrefsCollectionDoc::MaximumBytesFormGet";
	case PrefsCollectionDoc::MaximumBytesFormPost:
		return dbg << "PrefsCollectionDoc::MaximumBytesFormPost";
#endif
#ifdef FORMS_LIMIT_INPUT_SIZE
	case PrefsCollectionDoc::MaximumBytesInputPassword:
		return dbg << "PrefsCollectionDoc::MaximumBytesInputPassword";
	case PrefsCollectionDoc::MaximumBytesInputText:
		return dbg << "PrefsCollectionDoc::MaximumBytesInputText";
#endif
	case PrefsCollectionDoc::NewWindow:
		return dbg << "PrefsCollectionDoc::NewWindow";
#ifdef VISITED_PAGES_SEARCH
	case PrefsCollectionDoc::PageContentSearch:
		return dbg << "PrefsCollectionDoc::PageContentSearch";
#endif
	case PrefsCollectionDoc::RenderingMode:
		return dbg << "PrefsCollectionDoc::RenderingMode";
#ifdef SAVE_SUPPORT
	case PrefsCollectionDoc::TxtCharsPerLine:
		return dbg << "PrefsCollectionDoc::TxtCharsPerLine";
	case PrefsCollectionDoc::SaveUseSubfolder:
		return dbg << "PrefsCollectionDoc::SaveUseSubfolder";
#endif
	case PrefsCollectionDoc::ShowImageState:
		return dbg << "PrefsCollectionDoc::ShowImageState";
#ifdef PAGED_MEDIA_SUPPORT
	case PrefsCollectionDoc::ShowPageControls:
		return dbg << "PrefsCollectionDoc::ShowPageControls";
#endif
	case PrefsCollectionDoc::ShowScrollbars:
		return dbg << "PrefsCollectionDoc::ShowScrollbars";
	case PrefsCollectionDoc::ShowWinSize:
		return dbg << "PrefsCollectionDoc::ShowWinSize";
	case PrefsCollectionDoc::SingleWindowBrowsing:
		return dbg << "PrefsCollectionDoc::SingleWindowBrowsing";
#ifdef CORE_THUMBNAIL_SUPPORT
	case PrefsCollectionDoc::ThumbnailRequestHeader:
		return dbg << "PrefsCollectionDoc::ThumbnailRequestHeader";
#endif
	case PrefsCollectionDoc::SuppressExternalEmbeds:
		return dbg << "PrefsCollectionDoc::SuppressExternalEmbeds";
#ifdef CORE_THUMBNAIL_SUPPORT
	case PrefsCollectionDoc::ThumbnailAspectRatioX:
		return dbg << "PrefsCollectionDoc::ThumbnailAspectRatioX";
	case PrefsCollectionDoc::ThumbnailAspectRatioY:
		return dbg << "PrefsCollectionDoc::ThumbnailAspectRatioY";
#endif
#ifdef THUMBNAILS_LOGO_TUNING_VIA_PREFS
	case PrefsCollectionDoc::ThumbnailIconMinH:
		return dbg << "PrefsCollectionDoc::ThumbnailIconMinH";
	case PrefsCollectionDoc::ThumbnailIconMinW:
		return dbg << "PrefsCollectionDoc::ThumbnailIconMinW";
	case PrefsCollectionDoc::ThumbnailLogoPosMaxX:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoPosMaxX";
	case PrefsCollectionDoc::ThumbnailLogoPosMaxY:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoPosMaxY";
	case PrefsCollectionDoc::ThumbnailLogoScoreBanner:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreBanner";
	case PrefsCollectionDoc::ThumbnailLogoScoreLogoALT:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreLogoALT";
	case PrefsCollectionDoc::ThumbnailLogoScoreLogoURL:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreLogoURL";
	case PrefsCollectionDoc::ThumbnailLogoScoreSiteALT:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreSiteALT";
	case PrefsCollectionDoc::ThumbnailLogoScoreSiteLink:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreSiteLink";
	case PrefsCollectionDoc::ThumbnailLogoScoreSiteURL:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreSiteURL";
	case PrefsCollectionDoc::ThumbnailLogoScoreThreshold:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreThreshold";
	case PrefsCollectionDoc::ThumbnailLogoScoreX:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreX";
	case PrefsCollectionDoc::ThumbnailLogoScoreY:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoScoreY";
	case PrefsCollectionDoc::ThumbnailLogoSizeMaxX:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoSizeMaxX";
	case PrefsCollectionDoc::ThumbnailLogoSizeMaxY:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoSizeMaxY";
	case PrefsCollectionDoc::ThumbnailLogoSizeMinX:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoSizeMinX";
	case PrefsCollectionDoc::ThumbnailLogoSizeMinY:
		return dbg << "PrefsCollectionDoc::ThumbnailLogoSizeMinY";
#endif
#ifdef MEDIA_HTML_SUPPORT
	case PrefsCollectionDoc::MediaPlaybackTimeUpdateInterval:
		return dbg << "PrefsCollectionDoc::MediaPlaybackTimeUpdateInterval";
#endif
	case PrefsCollectionDoc::XMLLoadExternalEntities:
		return dbg << "PrefsCollectionDoc::XMLLoadExternalEntities";
	default:
		return dbg << "PrefsCollectionDoc::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
