/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/prefs/prefsmanager/collections/make-prefs.py

/** Enumeration of all string preferences in this collection. */
enum stringpref
{
	CSSFamilyCursive, ///< Face name for CSS family "cursive"
	CSSFamilyFantasy, ///< Face name for CSS family "fantasy"
	CSSFamilyMonospace, ///< Face name for CSS family "monospace"
	CSSFamilySansserif, ///< Face name for CSS family "sans-serif"
	CSSFamilySerif, ///< Face name for CSS family "serif"
	DefaultEncoding, ///< Global default HTML encoding
	ForceEncoding, ///< Global overridden encoding
	PasswordCharacterPlaceholder, ///< The UNICODE character to use as a placeholder for password fields. Only the first character will be used.

	DummyLastStringPref
};
#define PCDISPLAY_NUMBEROFSTRINGPREFS static_cast<int>(PrefsCollectionDisplay::DummyLastStringPref)

/** Enumeration of all integer preferences in this collection. */
enum integerpref
{
	DM_AuthorCSS, ///< Use author's CSS in Document Mode
	DM_AuthorFonts, ///< Use author's fonts in Document Mode
	DM_UserCSS, ///< Use user's CSS in Document Mode
	DM_UserFonts, ///< Use user's fonts in Document Mode
	DM_UserLinks, ///< Use user's links in Document Mode
#ifdef CANVAS_SUPPORT
	CanvasEnabled, ///< Enable Canvas support
#endif
#ifdef USE_FLASH_PREF
	FlashEnabled, ///< Enable Flash plug-in
#endif
	FramesEnabled, ///< Enable frames
	ShowActiveFrame, ///< Show the active frame always
	IFramesEnabled, ///< Enable iframes
#ifdef _PLUGIN_SUPPORT_
	PluginsEnabled, ///< Enable plugins
#endif
	LinkHasColor, ///< Link appearance: Does link show in different color?
	LinkHasFrame, ///< Link appearance: Does link have frame?
	LinkHasStrikeThrough, ///< Link appearance: Are links strike-throughed?
	LinkHasUnderline, ///< Link appearance: Are links underlined?
#ifdef PREFS_HAVE_INTERPOLATE_IMAGES
	InterpolateImages, ///< Enable smooth zooming of images
#endif
#ifdef EMBEDDED_ICC_SUPPORT
	ImagesUseICC, ///< Use any Embedded ICC Profile when rendering images
#endif
	RM1_AvoidInterlaceFlicker, ///< Avoid interlace flicker for SSR
	RM1_AbsolutelyPositionedElements, ///< Absolutely positioned elements for SSR
	RM1_AllowScrollbarsInIFrame, ///< Allow scrollbar in iframes for SSR
	RM1_AllowAggressiveWordBreaking, ///< Allow aggressive word breaking for SSR
	RM1_Large, ///< Font size in pixels for large for SSR
	RM1_Medium, ///< Font size in pixels for medium for SSR
	RM1_Small, ///< Font size in pixels for small for SSR
	RM1_FlexibleFonts, ///< Flexible fonts mode for SSR
	RM1_XLarge, ///< Font size in pixels for x-large for SSR
	RM1_XXLarge, ///< Font size in pixels for xx-large for SSR
	RM1_ShowBackgroundImages, ///< Show background images for SSR
	RM1_DownloadImagesAsap, ///< Download images ASAP for SSR
	RM1_Float, ///< Enable float for SSR
	RM1_FlexibleImageSizes, ///< Flexible replaced content sizes mode for SSR
	RM1_MinimumImageWidth, ///< Minimum image width in percent for SSR
	RM1_RemoveLargeImages, ///< Remove large images for SSR
	RM1_RemoveOrnamentalImages, ///< Remove ornamental images for SSR
	RM1_ShowImages, ///< Show image mode for SSR
	RM1_UseAltForCertainImages, ///< Use alternative text for certain images for SSR
	RM1_AbsolutePositioning, ///< Absolute positioning for SSR
	RM1_AllowHorizontalScrollbar, ///< Allow horizontal scrollbar for SSR
	RM1_CrossoverSize, ///< Crossover size in pixels for SSR
	RM1_DownloadAndApplyDocumentStyleSheets, ///< Download and apply document style sheets mode for SSR
	RM1_FramesPolicy, ///< Frames policy mode for SSR
	RM1_RespondToMediaType, ///< Media type to respond to for SSR
	RM1_MediaStyleHandling, ///< Media style handling for SSR
	RM1_ApplyModeSpecificTricks, ///< Apply mode specific tricks for SSR
	RM1_HonorHidden, ///< Honour visibility:hidden and display:none for SSR
	RM1_ShowIFrames, ///< Show iframes for SSR
	RM1_HighlightBlocks, ///< Highlight blocks for SSR
	RM1_MinimumTextColorContrast, ///< Minimum text color contrast (0-255) for SSR
	RM1_TextColorDark, ///< Dark text color (24-bit RGB value) for SSR
	RM1_TextColorLight, ///< Light text color (24-bit RGB value) for SSR
	RM1_ConvertNbspIntoNormalSpace, ///< Convert nbsp into normal space for SSR
	RM1_ColumnStretch, ///< Column stretch mode for SSR
	RM1_FlexibleColumns, ///< Enable Flexible columns for SSR
	RM1_HonorNowrap, ///< Honour nowrap for SSR
	RM1_IgnoreRowspanWhenRestructuring, ///< Ignore rowspan when restructuring the table for SSR
	RM1_SplitHideLongWords, ///< Split or hide long words for SSR
	RM1_TableMagic, ///< Enable content magic for SSR
	RM1_TableStrategy, ///< Table strategy for SSR
	RM2_AvoidInterlaceFlicker, ///< Avoid interlace flicker for CSSR
	RM2_AbsolutelyPositionedElements, ///< Absolutely positioned elements for CSSR
	RM2_AllowScrollbarsInIFrame, ///< Allow scrollbar in iframes for CSSR
	RM2_AllowAggressiveWordBreaking, ///< Allow aggressive word breaking for CSSR
	RM2_Large, ///< Font size in pixels for large for CSSR
	RM2_Medium, ///< Font size in pixels for medium for CSSR
	RM2_Small, ///< Font size in pixels for small for CSSR
	RM2_FlexibleFonts, ///< Flexible fonts mode for CSSR
	RM2_XLarge, ///< Font size in pixels for x-large for CSSR
	RM2_XXLarge, ///< Font size in pixels for xx-large for CSSR
	RM2_ShowBackgroundImages, ///< Show background images for CSSR
	RM2_DownloadImagesAsap, ///< Download images ASAP for CSSR
	RM2_Float, ///< Enable float for CSSR
	RM2_FlexibleImageSizes, ///< Flexible replaced content sizes mode for CSSR
	RM2_MinimumImageWidth, ///< Minimum image width in percent for CSSR
	RM2_RemoveLargeImages, ///< Remove large images for CSSR
	RM2_RemoveOrnamentalImages, ///< Remove ornamental images for CSSR
	RM2_ShowImages, ///< Show image mode for CSSR
	RM2_UseAltForCertainImages, ///< Use alternative text for certain images for CSSR
	RM2_AbsolutePositioning, ///< Absolute positioning for CSSR
	RM2_AllowHorizontalScrollbar, ///< Allow horizontal scrollbar for CSSR
	RM2_CrossoverSize, ///< Crossover size in pixels for CSSR
	RM2_DownloadAndApplyDocumentStyleSheets, ///< Download and apply document style sheets mode for CSSR
	RM2_FramesPolicy, ///< Frames policy mode for CSSR
	RM2_RespondToMediaType, ///< Media type to respond to for CSSR
	RM2_MediaStyleHandling, ///< Media style handling for CSSR
	RM2_ApplyModeSpecificTricks, ///< Apply mode specific tricks for CSSR
	RM2_HonorHidden, ///< Honour visibility:hidden and display:none for CSSR
	RM2_ShowIFrames, ///< Show iframes for CSSR
	RM2_HighlightBlocks, ///< Highlight blocks for CSSR
	RM2_MinimumTextColorContrast, ///< Minimum text color contrast (0-255) for CSSR
	RM2_TextColorDark, ///< Dark text color (24-bit RGB value) for CSSR
	RM2_TextColorLight, ///< Light text color (24-bit RGB value) for CSSR
	RM2_ConvertNbspIntoNormalSpace, ///< Convert nbsp into normal space for CSSR
	RM2_ColumnStretch, ///< Column stretch mode for CSSR
	RM2_FlexibleColumns, ///< Enable Flexible columns for CSSR
	RM2_HonorNowrap, ///< Honour nowrap for CSSR
	RM2_IgnoreRowspanWhenRestructuring, ///< Ignore rowspan when restructuring the table for CSSR
	RM2_SplitHideLongWords, ///< Split or hide long words for CSSR
	RM2_TableMagic, ///< Enable content magic for CSSR
	RM2_TableStrategy, ///< Table strategy for CSSR
	RM3_AvoidInterlaceFlicker, ///< Avoid interlace flicker for AMSR
	RM3_AbsolutelyPositionedElements, ///< Absolutely positioned elements for AMSR
	RM3_AllowScrollbarsInIFrame, ///< Allow scrollbar in iframes for AMSR
	RM3_AllowAggressiveWordBreaking, ///< Allow aggressive word breaking for AMSR
	RM3_Large, ///< Font size in pixels for large for AMSR
	RM3_Medium, ///< Font size in pixels for medium for AMSR
	RM3_Small, ///< Font size in pixels for small for AMSR
	RM3_FlexibleFonts, ///< Flexible fonts mode for AMSR
	RM3_XLarge, ///< Font size in pixels for x-large for AMSR
	RM3_XXLarge, ///< Font size in pixels for xx-large for AMSR
	RM3_ShowBackgroundImages, ///< Show background images for AMSR
	RM3_DownloadImagesAsap, ///< Download images ASAP for AMSR
	RM3_Float, ///< Enable float for AMSR
	RM3_FlexibleImageSizes, ///< Flexible replaced content sizes mode for AMSR
	RM3_MinimumImageWidth, ///< Minimum image width in percent for AMSR
	RM3_RemoveLargeImages, ///< Remove large images for AMSR
	RM3_RemoveOrnamentalImages, ///< Remove ornamental images for AMSR
	RM3_ShowImages, ///< Show image mode for AMSR
	RM3_UseAltForCertainImages, ///< Use alternative text for certain images for AMSR
	RM3_AbsolutePositioning, ///< Absolute positioning for AMSR
	RM3_AllowHorizontalScrollbar, ///< Allow horizontal scrollbar for AMSR
	RM3_CrossoverSize, ///< Crossover size in pixels for AMSR
	RM3_DownloadAndApplyDocumentStyleSheets, ///< Download and apply document style sheets mode for AMSR
	RM3_FramesPolicy, ///< Frames policy mode for AMSR
	RM3_RespondToMediaType, ///< Media type to respond to for AMSR
	RM3_MediaStyleHandling, ///< Media style handling for AMSR
	RM3_ApplyModeSpecificTricks, ///< Apply mode specific tricks for AMSR
	RM3_HonorHidden, ///< Honour visibility:hidden and display:none for AMSR
	RM3_ShowIFrames, ///< Show iframes for AMSR
	RM3_HighlightBlocks, ///< Highlight blocks for AMSR
	RM3_MinimumTextColorContrast, ///< Minimum text color contrast (0-255) for AMSR
	RM3_TextColorDark, ///< Dark text color (24-bit RGB value) for AMSR
	RM3_TextColorLight, ///< Light text color (24-bit RGB value) for AMSR
	RM3_ConvertNbspIntoNormalSpace, ///< Convert nbsp into normal space for AMSR
	RM3_ColumnStretch, ///< Column stretch mode for AMSR
	RM3_FlexibleColumns, ///< Enable Flexible columns for AMSR
	RM3_HonorNowrap, ///< Honour nowrap for AMSR
	RM3_IgnoreRowspanWhenRestructuring, ///< Ignore rowspan when restructuring the table for AMSR
	RM3_SplitHideLongWords, ///< Split or hide long words for AMSR
	RM3_TableMagic, ///< Enable content magic for AMSR
	RM3_TableStrategy, ///< Table strategy for AMSR
	RM4_AvoidInterlaceFlicker, ///< Avoid interlace flicker for MSR
	RM4_AbsolutelyPositionedElements, ///< Absolutely positioned elements for MSR
	RM4_AllowScrollbarsInIFrame, ///< Allow scrollbar in iframes for MSR
	RM4_AllowAggressiveWordBreaking, ///< Allow aggressive word breaking for MSR
	RM4_Large, ///< Font size in pixels for large for MSR
	RM4_Medium, ///< Font size in pixels for medium for MSR
	RM4_Small, ///< Font size in pixels for small for MSR
	RM4_FlexibleFonts, ///< Flexible fonts mode for MSR
	RM4_XLarge, ///< Font size in pixels for x-large for MSR
	RM4_XXLarge, ///< Font size in pixels for xx-large for MSR
	RM4_ShowBackgroundImages, ///< Show background images for MSR
	RM4_DownloadImagesAsap, ///< Download images ASAP for MSR
	RM4_Float, ///< Enable float for MSR
	RM4_FlexibleImageSizes, ///< Flexible replaced content sizes mode for MSR
	RM4_MinimumImageWidth, ///< Minimum image width in percent for MSR
	RM4_RemoveLargeImages, ///< Remove large images for MSR
	RM4_RemoveOrnamentalImages, ///< Remove ornamental images for MSR
	RM4_ShowImages, ///< Show image mode for MSR
	RM4_UseAltForCertainImages, ///< Use alternative text for certain images for MSR
	RM4_AbsolutePositioning, ///< Absolute positioning for MSR
	RM4_AllowHorizontalScrollbar, ///< Allow horizontal scrollbar for MSR
	RM4_CrossoverSize, ///< Crossover size in pixels for MSR
	RM4_DownloadAndApplyDocumentStyleSheets, ///< Download and apply document style sheets mode for MSR
	RM4_FramesPolicy, ///< Frames policy mode for MSR
	RM4_RespondToMediaType, ///< Media type to respond to for MSR
	RM4_MediaStyleHandling, ///< Media style handling for MSR
	RM4_ApplyModeSpecificTricks, ///< Apply mode specific tricks for MSR
	RM4_HonorHidden, ///< Honour visibility:hidden and display:none for MSR
	RM4_ShowIFrames, ///< Show iframes for MSR
	RM4_HighlightBlocks, ///< Highlight blocks for MSR
	RM4_MinimumTextColorContrast, ///< Minimum text color contrast (0-255) for MSR
	RM4_TextColorDark, ///< Dark text color (24-bit RGB value) for MSR
	RM4_TextColorLight, ///< Light text color (24-bit RGB value) for MSR
	RM4_ConvertNbspIntoNormalSpace, ///< Convert nbsp into normal space for MSR
	RM4_ColumnStretch, ///< Column stretch mode for MSR
	RM4_FlexibleColumns, ///< Enable Flexible columns for MSR
	RM4_HonorNowrap, ///< Honour nowrap for MSR
	RM4_IgnoreRowspanWhenRestructuring, ///< Ignore rowspan when restructuring the table for MSR
	RM4_SplitHideLongWords, ///< Split or hide long words for MSR
	RM4_TableMagic, ///< Enable content magic for MSR
	RM4_TableStrategy, ///< Table strategy for MSR
#ifdef TV_RENDERING
	RM5_AvoidInterlaceFlicker, ///< Avoid interlace flicker for TVR
	RM5_AbsolutelyPositionedElements, ///< Absolutely positioned elements for TVR
	RM5_AllowScrollbarsInIFrame, ///< Allow scrollbar in iframes for TVR
	RM5_AllowAggressiveWordBreaking, ///< Allow aggressive word breaking for TVR
	RM5_Large, ///< Font size in pixels for large for TVR
	RM5_Medium, ///< Font size in pixels for medium for TVR
	RM5_Small, ///< Font size in pixels for small for TVR
	RM5_FlexibleFonts, ///< Flexible fonts mode for TVR
	RM5_XLarge, ///< Font size in pixels for x-large for TVR
	RM5_XXLarge, ///< Font size in pixels for xx-large for TVR
	RM5_ShowBackgroundImages, ///< Show background images for TVR
	RM5_DownloadImagesAsap, ///< Download images ASAP for TVR
	RM5_Float, ///< Enable float for TVR
	RM5_FlexibleImageSizes, ///< Flexible replaced content sizes mode for TVR
	RM5_MinimumImageWidth, ///< Minimum image width in percent for TVR
	RM5_RemoveLargeImages, ///< Remove large images for TVR
	RM5_RemoveOrnamentalImages, ///< Remove ornamental images for TVR
	RM5_ShowImages, ///< Show image mode for TVR
	RM5_UseAltForCertainImages, ///< Use alternative text for certain images for TVR
	RM5_AbsolutePositioning, ///< Absolute positioning for TVR
	RM5_AllowHorizontalScrollbar, ///< Allow horizontal scrollbar for TVR
	RM5_CrossoverSize, ///< Crossover size in pixels for TVR
	RM5_DownloadAndApplyDocumentStyleSheets, ///< Download and apply document style sheets mode for TVR
	RM5_FramesPolicy, ///< Frames policy mode for TVR
	RM5_RespondToMediaType, ///< Media type to respond to for TVR
	RM5_MediaStyleHandling, ///< Media style handling for TVR
	RM5_ApplyModeSpecificTricks, ///< Apply mode specific tricks for TVR
	RM5_HonorHidden, ///< Honour visibility:hidden and display:none for TVR
	RM5_ShowIFrames, ///< Show iframes for TVR
	RM5_HighlightBlocks, ///< Highlight blocks for TVR
	RM5_MinimumTextColorContrast, ///< Minimum text color contrast (0-255) for TVR
	RM5_TextColorDark, ///< Dark text color (24-bit RGB value) for TVR
	RM5_TextColorLight, ///< Light text color (24-bit RGB value) for TVR
	RM5_ConvertNbspIntoNormalSpace, ///< Convert nbsp into normal space for TVR
	RM5_ColumnStretch, ///< Column stretch mode for TVR
	RM5_FlexibleColumns, ///< Enable Flexible columns for TVR
	RM5_HonorNowrap, ///< Honour nowrap for TVR
	RM5_IgnoreRowspanWhenRestructuring, ///< Ignore rowspan when restructuring the table for TVR
	RM5_SplitHideLongWords, ///< Split or hide long words for TVR
	RM5_TableMagic, ///< Enable content magic for TVR
	RM5_TableStrategy, ///< Table strategy for TVR
#endif
#ifdef SVG_SUPPORT
	SVGRenderingQuality, ///< Smoothness of curves in SVG
	SVGTargetFrameRate, ///< The target framerate in SVG
#endif
	UM_AuthorCSS, ///< Use author's CSS in User Mode
	UM_AuthorFonts, ///< Use author's fonts in User Mode
	UM_UserCSS, ///< Use user's CSS in User Mode
	UM_UserFonts, ///< Use user's fonts in User Mode
	UM_UserLinks, ///< Use user's links in User Mode
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	AllowScriptToChangeStatus, ///< Allow script to update status field
#endif
	AllowScriptToHideURL, ///< Allowed script to hide URL field in popups
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	AllowScriptToLowerWindow, ///< Allow script to bring document window to background
	AllowScriptToMoveWindow, ///< Allow script to move document window
	AllowScriptToRaiseWindow, ///< Allow script to bring document window to front
#endif
	AllowScriptToReceiveRightClicks, ///< Allow script to capture right mouse button
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	AllowScriptToResizeWindow, ///< Allow script to resize document window
#endif
	AltImageBorderEnabled, ///< Enables border for image ALT texts.
#ifdef _DIRECT_URL_WINDOW_
	AutoDropDown, ///< Drop-down auto completion
#endif
#ifdef PREFS_HAVE_HOTCLICK
	AutomaticSelectMenu, ///< Open the hotclick menu automatically after double click
#endif
#if !defined USE_HTML_PARSER_FOR_XML
	ReparseFailedXHTML, ///< If parsing errors occured during parsing XHTML, automatically reparse document as HTML
#endif
#ifdef _SUPPORT_SMOOTH_DISPLAY_
	SmoothDisplay, ///< Avoid flicker (double buffering)
#endif
#ifdef ENCODING_DRIVEN_LINE_HEIGHT
	DefaultLineHeightCyrillic, ///< Line height to use for pages encoded with a Cyrillic encoding, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
	DefaultLineHeightGeneral, ///< Line height to use for pages not covered by the following preferences, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
	DefaultLineHeightJapanese, ///< Line height to use for pages encoded with a Japanese encoding, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
	DefaultLineHeightKorean, ///< Line height to use for pages encoded with a Korean encoding, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
	DefaultLineHeightSimplifiedChinese, ///< Line height to use for pages encoded with a simplified Chinese encoding, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
	DefaultLineHeightTraditionalChinese, ///< Line height to use for pages encoded with a traditional Chinese encoding, when line height is not explicitly specified. Values >= 0 represent the line height in relation to the font height in permille, e.g 1200 for 1.2. Use -1 for default line height.
#endif
#ifdef SKIN_HIGHLIGHTED_ELEMENT
	DisableHighlightUponOutline, ///< When TRUE, a navigated element won't be highlighted if it has an invisible outline that is explicitly set in some style sheet. Invisible outline means 'outline:none' or an outline that has zero width.
#endif
	DocumentMode, ///< CSS usage settings
#ifdef ON_DEMAND_PLUGIN
	EnableOnDemandPlugin, ///< Enable not loading plugins until activated by the user
	EnableOnDemandPluginPlaceholder, ///< Enable displaying an image as placeholder for on demand plugins
#endif
#ifdef CSS_SCROLLBARS_SUPPORT
	EnableScrollbarColors, ///< Enable IE CSS extension for colors on scrollbars
#endif
	EnableStylingOnForms, ///< Enable CSS on forms.
	EnableWebfonts, ///< Enable downloadable fonts
	FirstUpdateDelay, ///< Time in milliseconds from the server response that we are prepared to with until we see anything painted. The higher, the likelier we do only a single good paint. The lower, the less yout have to wait to see something, but the more likely the first paint only has unusable contents. In general it's best to keep this high and instead work with "First Styled Update Delay" which is a slightly shorter timer.
	FlexRootMaxWidth, ///< Max-width of flex-root (0 means disable flex-root)
	FlexRootMinWidth, ///< Min-width of flex-root (Ignored if FlexRootMaxWidth is 0. FlexRootMinWidth=0 means use viewport width)
#ifdef FORMAT_UNSTYLED_XML
	FormatUnstyledXML, ///< Enables pretty printing of unstyled XML
#endif
#ifdef LAYOUT_YIELD_REFLOW
	InitialYieldReflowTime, ///< Try to keep reflow time less than this value before returning to the message loop. Value 0 means yield off
#endif
	LeftHandedUI, ///< Position UI elements for southpaws. Intended for use on tablet/pen-input devices.
	LimitParagraphWidth, ///< MSR-light, limit the width of a line to the size of the window
	MaximumMarqueeLoops, ///< Maximum number of loops for marquees (-1 for infinite)
#ifdef WIDGETS_LIMIT_TEXTAREA_SIZE
	MaximumBytesTextarea, ///< Maximum bytes of content for a textarea
#endif
	MaxFontSize, ///< Maximum font size
	MinFontSize, ///< Minimum font size
#ifdef SUPPORT_TEXT_DIRECTION
	RTLFlipsUI, ///< Move scrollbars and other UI elements to the opposite side when displaying right-to-left content.
#endif
#ifdef LAYOUT_USE_SSR_MAX_WIDTH_PREF
	SSRMaxWidth, ///< Max width in SSR/CSSR, effectively the column width
#endif
#ifdef SESSION_SUPPORT
	SavePasswordProtectedPages, ///< Allow saving password protected pages to .win files
#endif
	Scale, ///< Zoom factor (percent)
#ifdef GRAB_AND_SCROLL
	ScrollIsPan, ///< Enable "grab and scroll" mode
#endif
#ifdef SUPPORT_IME_PASSWORD_INPUT
	ShowIMEPassword, ///< Make the last character visible for short time.
#endif
	SmoothScrolling, ///< Enable smooth scrolling
	StyledFirstUpdateTimeout, ///< Time in milliseconds from the server response that we will delay a paint to make sure that the first paint has enough content to look good and meaningful. This timer will only be used if we have all known stylesheet data. Otherwise we will wait until "First Update Delay" has been reached. For this to be meaningful it has to be set to a value lower than "First Update Delay" to be meaningful.
	UpdateDelay, ///< Delay in milliseconds between paints during page load. A value of 200 (ms) means we'll limit painting to 5 fps while the page is still loading. A high number here means faster page loads. A low number means high fps during page load but slower page loads.
#ifdef LAYOUT_YIELD_REFLOW
	YieldReflowTimeIncreaseRate, ///< How fast should the maximum reflow time increase if we cant manage inside that time.
#endif
	VisitedLinkHasColor, ///< Visited link appearance: Does link show in different color?
	VisitedLinkHasStrikeThrough, ///< Visited link appearance: Are links strike-throughed?
	VisitedLinkHasUnderline, ///< Visited link appearance: Are links underlined?
	VisitedLinksState, ///< Preference to handle the usage of :visited pseudo class. 0 - disable, 1 - same domain only, 2 - enable

	DummyLastIntegerPref
};
#define PCDISPLAY_NUMBEROFINTEGERPREFS static_cast<int>(PrefsCollectionDisplay::DummyLastIntegerPref)

