/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionDisplay, PCDISPLAY_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
	P(SCSSGenericFontFamily, "Cursive", UNI_L("")),
	P(SCSSGenericFontFamily, "Fantasy", UNI_L("")),
	P(SCSSGenericFontFamily, "Monospace", UNI_L("")),
	P(SCSSGenericFontFamily, "Sans-Serif", UNI_L("")),
	P(SCSSGenericFontFamily, "Serif", UNI_L("")),
	P(SUserPrefs, "Fallback HTML Encoding", UNI_L("")),
	P(SUserPrefs, "Force Encoding", UNI_L("")),
	P(SUserPrefs, "Password Character Placeholder", WIDGETS_PASSWORD_CHAR),

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionDisplay, PCDISPLAY_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
	I(SAuthorDisplayMode, "Author CSS", TRUE, prefssetting::boolean),
	I(SAuthorDisplayMode, "Author Font and Colors", TRUE, prefssetting::boolean),
	I(SAuthorDisplayMode, "User CSS", TRUE, prefssetting::boolean),
	I(SAuthorDisplayMode, "User Font and Colors", FALSE, prefssetting::boolean),
	I(SAuthorDisplayMode, "User Link Settings", TRUE, prefssetting::boolean),
#ifdef CANVAS_SUPPORT
	I(SExtensions, "Enable Canvas", TRUE, prefssetting::boolean),
#endif
#ifdef USE_FLASH_PREF
	I(SExtensions, "Enable Flash", TRUE, prefssetting::boolean),
#endif
	I(SExtensions, "Frames", TRUE, prefssetting::boolean),
	I(SExtensions, "Frames Show Active", DEFAULT_FRAMES_SHOW_ACTIVE, prefssetting::boolean),
	I(SExtensions, "IFrames", TRUE, prefssetting::boolean),
#ifdef _PLUGIN_SUPPORT_
	I(SExtensions, "Plugins", TRUE, prefssetting::boolean),
#endif
	I(SLink, "Color", TRUE, prefssetting::boolean),
	I(SLink, "Frame", FALSE, prefssetting::boolean),
	I(SLink, "StrikeThrough", FALSE, prefssetting::boolean),
	I(SLink, "Underline", DEFAULT_LINK_UNDERLINE, prefssetting::boolean),
#ifdef PREFS_HAVE_INTERPOLATE_IMAGES
	I(SMultimedia, "Interpolate Images", DEFAULT_SMOOTH_IMAGE_ZOOM, prefssetting::boolean),
#endif
#ifdef EMBEDDED_ICC_SUPPORT
	I(SMultimedia, "Use Embedded ICC Profiles", DEFAULT_USE_ICC_PROFILES, prefssetting::boolean),
#endif
	I(SRM1, "aif", 0, prefssetting::integer),
	I(SRM1, "ape", 1, prefssetting::integer),
	I(SRM1, "asi", 0, prefssetting::integer),
	I(SRM1, "awb", 1, prefssetting::integer),
	I(SRM1, "fla", RM1_FLA, prefssetting::integer),
	I(SRM1, "fme", RM1_FME, prefssetting::integer),
	I(SRM1, "fsm", RM1_FSM, prefssetting::integer),
	I(SRM1, "fxf", RM1_FXF, prefssetting::integer),
	I(SRM1, "fxl", RM1_FXL, prefssetting::integer),
	I(SRM1, "fxx", RM1_FXX, prefssetting::integer),
	I(SRM1, "ibs", 0, prefssetting::integer),
	I(SRM1, "ida", 0, prefssetting::integer),
	I(SRM1, "ifl", 0, prefssetting::integer),
	I(SRM1, "ifs", 1, prefssetting::integer),
	I(SRM1, "imw", RM1_IMW, prefssetting::integer),
	I(SRM1, "irl", RM1_IRL, prefssetting::integer),
	I(SRM1, "iro", 1, prefssetting::integer),
	I(SRM1, "isi", RM1_ISI, prefssetting::integer),
	I(SRM1, "iua", 1, prefssetting::integer),
	I(SRM1, "map", 1, prefssetting::integer),
	I(SRM1, "mas", 0, prefssetting::integer),
	I(SRM1, "mcs", RM1_MCS, prefssetting::integer),
	I(SRM1, "mds", 0, prefssetting::integer),
	I(SRM1, "mfp", 1, prefssetting::integer),
	I(SRM1, "mrm", 1, prefssetting::integer),
	I(SRM1, "msh", 1, prefssetting::integer),
	I(SRM1, "mst", 1, prefssetting::integer),
	I(SRM1, "mvd", 2, prefssetting::integer),
	I(SRM1, "rfu", 2, prefssetting::integer),
	I(SRM1, "shb", 1, prefssetting::integer),
	I(SRM1, "tcc", 70, prefssetting::integer),
	I(SRM1, "tcd", OP_RGB(0,0,0), prefssetting::integer),
	I(SRM1, "tcl", OP_RGB(255,255,255), prefssetting::integer),
	I(SRM1, "tcn", 1, prefssetting::integer),
	I(SRM1, "tcs", 2, prefssetting::integer),
	I(SRM1, "tfc", 1, prefssetting::integer),
	I(SRM1, "thn", 0, prefssetting::integer),
	I(SRM1, "tir", 0, prefssetting::integer),
	I(SRM1, "tsh", 1, prefssetting::integer),
	I(SRM1, "ttm", RM1_TTM, prefssetting::integer),
	I(SRM1, "ttt", 1, prefssetting::integer),
	I(SRM2, "aif", 0, prefssetting::integer),
	I(SRM2, "ape", 1, prefssetting::integer),
	I(SRM2, "asi", 0, prefssetting::integer),
	I(SRM2, "awb", 1, prefssetting::integer),
	I(SRM2, "fla", RM2_FLA, prefssetting::integer),
	I(SRM2, "fme", RM2_FME, prefssetting::integer),
	I(SRM2, "fsm", RM2_FSM, prefssetting::integer),
	I(SRM2, "fxf", RM2_FXF, prefssetting::integer),
	I(SRM2, "fxl", RM2_FXL, prefssetting::integer),
	I(SRM2, "fxx", RM2_FXX, prefssetting::integer),
	I(SRM2, "ibs", 0, prefssetting::integer),
	I(SRM2, "ida", 0, prefssetting::integer),
	I(SRM2, "ifl", 1, prefssetting::integer),
	I(SRM2, "ifs", 1, prefssetting::integer),
	I(SRM2, "imw", RM2_IMW, prefssetting::integer),
	I(SRM2, "irl", RM2_IRL, prefssetting::integer),
	I(SRM2, "iro", 2, prefssetting::integer),
	I(SRM2, "isi", RM2_ISI, prefssetting::integer),
	I(SRM2, "iua", 0, prefssetting::integer),
	I(SRM2, "map", 1, prefssetting::integer),
	I(SRM2, "mas", 0, prefssetting::integer),
	I(SRM2, "mcs", RM2_MCS, prefssetting::integer),
	I(SRM2, "mds", 1, prefssetting::integer),
	I(SRM2, "mfp", 1, prefssetting::integer),
	I(SRM2, "mrm", 1, prefssetting::integer),
	I(SRM2, "msh", 1, prefssetting::integer),
	I(SRM2, "mst", 2, prefssetting::integer),
	I(SRM2, "mvd", 2, prefssetting::integer),
	I(SRM2, "rfu", 2, prefssetting::integer),
	I(SRM2, "shb", 0, prefssetting::integer),
	I(SRM2, "tcc", 70, prefssetting::integer),
	I(SRM2, "tcd", OP_RGB(0,0,0), prefssetting::integer),
	I(SRM2, "tcl", OP_RGB(255,255,255), prefssetting::integer),
	I(SRM2, "tcn", 1, prefssetting::integer),
	I(SRM2, "tcs", 2, prefssetting::integer),
	I(SRM2, "tfc", 1, prefssetting::integer),
	I(SRM2, "thn", 0, prefssetting::integer),
	I(SRM2, "tir", 0, prefssetting::integer),
	I(SRM2, "tsh", 1, prefssetting::integer),
	I(SRM2, "ttm", RM2_TTM, prefssetting::integer),
	I(SRM2, "ttt", 1, prefssetting::integer),
	I(SRM3, "aif", 0, prefssetting::integer),
	I(SRM3, "ape", 2, prefssetting::integer),
	I(SRM3, "asi", 1, prefssetting::integer),
	I(SRM3, "awb", 1, prefssetting::integer),
	I(SRM3, "fla", RM3_FLA, prefssetting::integer),
	I(SRM3, "fme", RM3_FME, prefssetting::integer),
	I(SRM3, "fsm", RM3_FSM, prefssetting::integer),
	I(SRM3, "fxf", RM3_FXF, prefssetting::integer),
	I(SRM3, "fxl", RM3_FXL, prefssetting::integer),
	I(SRM3, "fxx", RM3_FXX, prefssetting::integer),
	I(SRM3, "ibs", 1, prefssetting::integer),
	I(SRM3, "ida", 1, prefssetting::integer),
	I(SRM3, "ifl", 1, prefssetting::integer),
	I(SRM3, "ifs", 2, prefssetting::integer),
	I(SRM3, "imw", RM3_IMW, prefssetting::integer),
	I(SRM3, "irl", RM3_IRL, prefssetting::integer),
	I(SRM3, "iro", 0, prefssetting::integer),
	I(SRM3, "isi", RM3_ISI, prefssetting::integer),
	I(SRM3, "iua", 0, prefssetting::integer),
	I(SRM3, "map", 2, prefssetting::integer),
	I(SRM3, "mas", 0, prefssetting::integer),
	I(SRM3, "mcs", RM3_MCS, prefssetting::integer),
	I(SRM3, "mds", 2, prefssetting::integer),
	I(SRM3, "mfp", 2, prefssetting::integer),
	I(SRM3, "mrm", 0, prefssetting::integer),
	I(SRM3, "msh", 0, prefssetting::integer),
	I(SRM3, "mst", 3, prefssetting::integer),
	I(SRM3, "mvd", 0, prefssetting::integer),
	I(SRM3, "rfu", 3, prefssetting::integer),
	I(SRM3, "shb", 0, prefssetting::integer),
	I(SRM3, "tcc", 70, prefssetting::integer),
	I(SRM3, "tcd", OP_RGB(0,0,0), prefssetting::integer),
	I(SRM3, "tcl", OP_RGB(255,255,255), prefssetting::integer),
	I(SRM3, "tcn", 1, prefssetting::integer),
	I(SRM3, "tcs", 0, prefssetting::integer),
	I(SRM3, "tfc", 1, prefssetting::integer),
	I(SRM3, "thn", 1, prefssetting::integer),
	I(SRM3, "tir", 0, prefssetting::integer),
	I(SRM3, "tsh", 1, prefssetting::integer),
	I(SRM3, "ttm", RM3_TTM, prefssetting::integer),
	I(SRM3, "ttt", 2, prefssetting::integer),
	I(SRM4, "aif", 0, prefssetting::integer),
	I(SRM4, "ape", 2, prefssetting::integer),
	I(SRM4, "asi", 1, prefssetting::integer),
	I(SRM4, "awb", 1, prefssetting::integer),
	I(SRM4, "fla", RM4_FLA, prefssetting::integer),
	I(SRM4, "fme", RM4_FME, prefssetting::integer),
	I(SRM4, "fsm", RM4_FSM, prefssetting::integer),
	I(SRM4, "fxf", RM4_FXF, prefssetting::integer),
	I(SRM4, "fxl", RM4_FXL, prefssetting::integer),
	I(SRM4, "fxx", RM4_FXX, prefssetting::integer),
	I(SRM4, "ibs", 2, prefssetting::integer),
	I(SRM4, "ida", 1, prefssetting::integer),
	I(SRM4, "ifl", 1, prefssetting::integer),
	I(SRM4, "ifs", 2, prefssetting::integer),
	I(SRM4, "imw", RM4_IMW, prefssetting::integer),
	I(SRM4, "irl", RM4_IRL, prefssetting::integer),
	I(SRM4, "iro", 0, prefssetting::integer),
	I(SRM4, "isi", RM4_ISI, prefssetting::integer),
	I(SRM4, "iua", 0, prefssetting::integer),
	I(SRM4, "map", 2, prefssetting::integer),
	I(SRM4, "mas", 1, prefssetting::integer),
	I(SRM4, "mcs", RM4_MCS, prefssetting::integer),
	I(SRM4, "mds", 2, prefssetting::integer),
	I(SRM4, "mfp", 2, prefssetting::integer),
	I(SRM4, "mrm", 0, prefssetting::integer),
	I(SRM4, "msh", 0, prefssetting::integer),
	I(SRM4, "mst", 4, prefssetting::integer),
	I(SRM4, "mvd", 0, prefssetting::integer),
	I(SRM4, "rfu", 3, prefssetting::integer),
	I(SRM4, "shb", 0, prefssetting::integer),
	I(SRM4, "tcc", 70, prefssetting::integer),
	I(SRM4, "tcd", OP_RGB(0,0,0), prefssetting::integer),
	I(SRM4, "tcl", OP_RGB(255,255,255), prefssetting::integer),
	I(SRM4, "tcn", 0, prefssetting::integer),
	I(SRM4, "tcs", 0, prefssetting::integer),
	I(SRM4, "tfc", 0, prefssetting::integer),
	I(SRM4, "thn", 1, prefssetting::integer),
	I(SRM4, "tir", 0, prefssetting::integer),
	I(SRM4, "tsh", 1, prefssetting::integer),
	I(SRM4, "ttm", RM4_TTM, prefssetting::integer),
	I(SRM4, "ttt", 2, prefssetting::integer),
#ifdef TV_RENDERING
	I(SRM5, "aif", 1, prefssetting::integer),
	I(SRM5, "ape", 2, prefssetting::integer),
	I(SRM5, "asi", 1, prefssetting::integer),
	I(SRM5, "awb", 1, prefssetting::integer),
	I(SRM5, "fla", RM5_FLA, prefssetting::integer),
	I(SRM5, "fme", RM5_FME, prefssetting::integer),
	I(SRM5, "fsm", RM5_FSM, prefssetting::integer),
	I(SRM5, "fxf", RM5_FXF, prefssetting::integer),
	I(SRM5, "fxl", RM5_FXL, prefssetting::integer),
	I(SRM5, "fxx", RM5_FXX, prefssetting::integer),
	I(SRM5, "ibs", 1, prefssetting::integer),
	I(SRM5, "ida", 1, prefssetting::integer),
	I(SRM5, "ifl", 1, prefssetting::integer),
	I(SRM5, "ifs", 2, prefssetting::integer),
	I(SRM5, "imw", RM5_IMW, prefssetting::integer),
	I(SRM5, "irl", RM5_IRL, prefssetting::integer),
	I(SRM5, "iro", 0, prefssetting::integer),
	I(SRM5, "isi", RM5_ISI, prefssetting::integer),
	I(SRM5, "iua", 0, prefssetting::integer),
	I(SRM5, "map", 2, prefssetting::integer),
	I(SRM5, "mas", 0, prefssetting::integer),
	I(SRM5, "mcs", 0, prefssetting::integer),
	I(SRM5, "mds", 2, prefssetting::integer),
	I(SRM5, "mfp", 2, prefssetting::integer),
	I(SRM5, "mrm", 2, prefssetting::integer),
	I(SRM5, "msh", 0, prefssetting::integer),
	I(SRM5, "mst", 5, prefssetting::integer),
	I(SRM5, "mvd", 0, prefssetting::integer),
	I(SRM5, "rfu", 3, prefssetting::integer),
	I(SRM5, "shb", 0, prefssetting::integer),
	I(SRM5, "tcc", 60, prefssetting::integer),
	I(SRM5, "tcd", OP_RGB(0,0,0), prefssetting::integer),
	I(SRM5, "tcl", OP_RGB(240,240,240), prefssetting::integer),
	I(SRM5, "tcn", 1, prefssetting::integer),
	I(SRM5, "tcs", 0, prefssetting::integer),
	I(SRM5, "tfc", 1, prefssetting::integer),
	I(SRM5, "thn", 1, prefssetting::integer),
	I(SRM5, "tir", 0, prefssetting::integer),
	I(SRM5, "tsh", 1, prefssetting::integer),
	I(SRM5, "ttm", RM5_TTM, prefssetting::integer),
	I(SRM5, "ttt", 2, prefssetting::integer),
#endif
#ifdef SVG_SUPPORT
	I(SSVG, "Rendering Quality", DEFAULT_SVG_RENDERING_QUALITY, prefssetting::integer),
	I(SSVG, "Target Framerate", DEFAULT_SVG_TARGET_FRAMERATE, prefssetting::integer),
#endif
	I(SUserDisplayMode, "Author CSS", FALSE, prefssetting::boolean),
	I(SUserDisplayMode, "Author Font and Colors", FALSE, prefssetting::boolean),
	I(SUserDisplayMode, "User CSS", TRUE, prefssetting::boolean),
	I(SUserDisplayMode, "User Font and Colors", TRUE, prefssetting::boolean),
	I(SUserDisplayMode, "User Link Settings", TRUE, prefssetting::boolean),
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	I(SUserPrefs, "Allow script to change status", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Allow script to hide address", DEFAULT_POPUP_ALLOW_HIDE_URL, prefssetting::boolean),
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	I(SUserPrefs, "Allow script to lower window", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Allow script to move window", TRUE, prefssetting::boolean),
	I(SUserPrefs, "Allow script to raise window", FALSE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Allow script to receive right clicks", TRUE, prefssetting::boolean),
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	I(SUserPrefs, "Allow script to resize window", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Alt Image Border", TRUE, prefssetting::boolean),
#ifdef _DIRECT_URL_WINDOW_
	I(SUserPrefs, "Auto Dropdown", TRUE, prefssetting::boolean),
#endif
#ifdef PREFS_HAVE_HOTCLICK
	I(SUserPrefs, "Automatic Select Menu", DEFAULT_AUTOSELECTMENU, prefssetting::boolean),
#endif
#if !defined USE_HTML_PARSER_FOR_XML
	I(SUserPrefs, "Automatically reparse XHTML with parsing errors as HTML", DEFAULT_FALLBACK_TO_REPARSE_XHTML_AS_HTML, prefssetting::boolean),
#endif
#ifdef _SUPPORT_SMOOTH_DISPLAY_
	I(SUserPrefs, "Avoid Flicker", TRUE, prefssetting::boolean),
#endif
#ifdef ENCODING_DRIVEN_LINE_HEIGHT
	I(SUserPrefs, "Default Line Height Cyrillic", -1, prefssetting::integer),
	I(SUserPrefs, "Default Line Height General", -1, prefssetting::integer),
	I(SUserPrefs, "Default Line Height Japanese", 1200, prefssetting::integer),
	I(SUserPrefs, "Default Line Height Korean", -1, prefssetting::integer),
	I(SUserPrefs, "Default Line Height Simplified Chinese", 1200, prefssetting::integer),
	I(SUserPrefs, "Default Line Height Traditional Chinese", 1200, prefssetting::integer),
#endif
#ifdef SKIN_HIGHLIGHTED_ELEMENT
	I(SUserPrefs, "Disable Highlight Upon Outline", DEFAULT_DISABLE_HIGHLIGHT_UPON_OUTLINE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Document Mode", CSS_FULL, prefssetting::integer),
#ifdef ON_DEMAND_PLUGIN
	I(SUserPrefs, "Enable On Demand Plugin", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Enable On Demand Plugin Placeholder", DEFAULT_PLUGIN_PLACEHOLDER, prefssetting::boolean),
#endif
#ifdef CSS_SCROLLBARS_SUPPORT
	I(SUserPrefs, "Enable Scrollbar Colors", DEFAULT_CSS_SCROLLBARS, prefssetting::boolean),
#endif
	I(SUserPrefs, "Enable Styling On Forms", DEFAULT_STYLING_ON_FORMS, prefssetting::boolean),
	I(SUserPrefs, "Enable Webfonts", DEFAULT_ENABLE_WEBFONTS, prefssetting::boolean),
	I(SUserPrefs, "First Update Delay", DEFAULT_FIRST_UPDATE_DELAY, prefssetting::integer),
	I(SUserPrefs, "FlexRoot Max Width", DEFAULT_FLEXROOT_MAX_WIDTH, prefssetting::integer),
	I(SUserPrefs, "FlexRoot Min Width", 0, prefssetting::integer),
#ifdef FORMAT_UNSTYLED_XML
	I(SUserPrefs, "Format Unstyled XML", TRUE, prefssetting::boolean),
#endif
#ifdef LAYOUT_YIELD_REFLOW
	I(SUserPrefs, "Initial Yield Reflow Time", 0, prefssetting::integer),
#endif
	I(SUserPrefs, "Left-handed UI", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Limit Paragraph Width", DEFAULT_PREFS_LIMIT_PARAGRAPH, prefssetting::boolean),
	I(SUserPrefs, "Max Marquee Loops", DEFAULT_MARQUEE_LOOPS, prefssetting::integer),
#ifdef WIDGETS_LIMIT_TEXTAREA_SIZE
	I(SUserPrefs, "Max bytes textarea", 10000, prefssetting::integer),
#endif
	I(SUserPrefs, "Maximum Font Size", 10000, prefssetting::integer),
	I(SUserPrefs, "Minimum Font Size", DEFAULT_MINFONTSIZE, prefssetting::integer),
#ifdef SUPPORT_TEXT_DIRECTION
	I(SUserPrefs, "RTL Flips UI", TRUE, prefssetting::boolean),
#endif
#ifdef LAYOUT_USE_SSR_MAX_WIDTH_PREF
	I(SUserPrefs, "SSR Max Width", 240, prefssetting::integer),
#endif
#ifdef SESSION_SUPPORT
	I(SUserPrefs, "Save Password Protected Pages", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Scale", 100, prefssetting::integer),
#ifdef GRAB_AND_SCROLL
	I(SUserPrefs, "Scroll Is Pan", DEFAULT_SCROLL_IS_PAN, prefssetting::boolean),
#endif
#ifdef SUPPORT_IME_PASSWORD_INPUT
	I(SUserPrefs, "Show IME Password", TRUE, prefssetting::boolean),
#endif
	I(SUserPrefs, "Smooth Scrolling", DEFAULT_SMOOTH_SCROLLING, prefssetting::boolean),
	I(SUserPrefs, "Styled First Update Timeout", DEFAULT_STYLED_FIRST_UPDATE_TIMEOUT, prefssetting::integer),
	I(SUserPrefs, "Update Delay", DEFAULT_UPDATE_DELAY, prefssetting::integer),
#ifdef LAYOUT_YIELD_REFLOW
	I(SUserPrefs, "Yield Reflow Time Increase Rate", 10, prefssetting::integer),
#endif
	I(SVisitedLink, "Color", TRUE, prefssetting::boolean),
	I(SVisitedLink, "StrikeThrough", FALSE, prefssetting::boolean),
	I(SVisitedLink, "Underline", DEFAULT_LINK_UNDERLINE, prefssetting::boolean),
	I(SVisitedLink, "Visited Links State", 2, prefssetting::integer),

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionDisplay::stringpref e)
{
	switch (e) {
	case PrefsCollectionDisplay::CSSFamilyCursive:
		return dbg << "PrefsCollectionDisplay::CSSFamilyCursive";
	case PrefsCollectionDisplay::CSSFamilyFantasy:
		return dbg << "PrefsCollectionDisplay::CSSFamilyFantasy";
	case PrefsCollectionDisplay::CSSFamilyMonospace:
		return dbg << "PrefsCollectionDisplay::CSSFamilyMonospace";
	case PrefsCollectionDisplay::CSSFamilySansserif:
		return dbg << "PrefsCollectionDisplay::CSSFamilySansserif";
	case PrefsCollectionDisplay::CSSFamilySerif:
		return dbg << "PrefsCollectionDisplay::CSSFamilySerif";
	case PrefsCollectionDisplay::DefaultEncoding:
		return dbg << "PrefsCollectionDisplay::DefaultEncoding";
	case PrefsCollectionDisplay::ForceEncoding:
		return dbg << "PrefsCollectionDisplay::ForceEncoding";
	case PrefsCollectionDisplay::PasswordCharacterPlaceholder:
		return dbg << "PrefsCollectionDisplay::PasswordCharacterPlaceholder";
	default:
		return dbg << "PrefsCollectionDisplay::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionDisplay::integerpref e)
{
	switch (e) {
	case PrefsCollectionDisplay::DM_AuthorCSS:
		return dbg << "PrefsCollectionDisplay::DM_AuthorCSS";
	case PrefsCollectionDisplay::DM_AuthorFonts:
		return dbg << "PrefsCollectionDisplay::DM_AuthorFonts";
	case PrefsCollectionDisplay::DM_UserCSS:
		return dbg << "PrefsCollectionDisplay::DM_UserCSS";
	case PrefsCollectionDisplay::DM_UserFonts:
		return dbg << "PrefsCollectionDisplay::DM_UserFonts";
	case PrefsCollectionDisplay::DM_UserLinks:
		return dbg << "PrefsCollectionDisplay::DM_UserLinks";
#ifdef CANVAS_SUPPORT
	case PrefsCollectionDisplay::CanvasEnabled:
		return dbg << "PrefsCollectionDisplay::CanvasEnabled";
#endif
#ifdef USE_FLASH_PREF
	case PrefsCollectionDisplay::FlashEnabled:
		return dbg << "PrefsCollectionDisplay::FlashEnabled";
#endif
	case PrefsCollectionDisplay::FramesEnabled:
		return dbg << "PrefsCollectionDisplay::FramesEnabled";
	case PrefsCollectionDisplay::ShowActiveFrame:
		return dbg << "PrefsCollectionDisplay::ShowActiveFrame";
	case PrefsCollectionDisplay::IFramesEnabled:
		return dbg << "PrefsCollectionDisplay::IFramesEnabled";
#ifdef _PLUGIN_SUPPORT_
	case PrefsCollectionDisplay::PluginsEnabled:
		return dbg << "PrefsCollectionDisplay::PluginsEnabled";
#endif
	case PrefsCollectionDisplay::LinkHasColor:
		return dbg << "PrefsCollectionDisplay::LinkHasColor";
	case PrefsCollectionDisplay::LinkHasFrame:
		return dbg << "PrefsCollectionDisplay::LinkHasFrame";
	case PrefsCollectionDisplay::LinkHasStrikeThrough:
		return dbg << "PrefsCollectionDisplay::LinkHasStrikeThrough";
	case PrefsCollectionDisplay::LinkHasUnderline:
		return dbg << "PrefsCollectionDisplay::LinkHasUnderline";
#ifdef PREFS_HAVE_INTERPOLATE_IMAGES
	case PrefsCollectionDisplay::InterpolateImages:
		return dbg << "PrefsCollectionDisplay::InterpolateImages";
#endif
#ifdef EMBEDDED_ICC_SUPPORT
	case PrefsCollectionDisplay::ImagesUseICC:
		return dbg << "PrefsCollectionDisplay::ImagesUseICC";
#endif
	case PrefsCollectionDisplay::RM1_AvoidInterlaceFlicker:
		return dbg << "PrefsCollectionDisplay::RM1_AvoidInterlaceFlicker";
	case PrefsCollectionDisplay::RM1_AbsolutelyPositionedElements:
		return dbg << "PrefsCollectionDisplay::RM1_AbsolutelyPositionedElements";
	case PrefsCollectionDisplay::RM1_AllowScrollbarsInIFrame:
		return dbg << "PrefsCollectionDisplay::RM1_AllowScrollbarsInIFrame";
	case PrefsCollectionDisplay::RM1_AllowAggressiveWordBreaking:
		return dbg << "PrefsCollectionDisplay::RM1_AllowAggressiveWordBreaking";
	case PrefsCollectionDisplay::RM1_Large:
		return dbg << "PrefsCollectionDisplay::RM1_Large";
	case PrefsCollectionDisplay::RM1_Medium:
		return dbg << "PrefsCollectionDisplay::RM1_Medium";
	case PrefsCollectionDisplay::RM1_Small:
		return dbg << "PrefsCollectionDisplay::RM1_Small";
	case PrefsCollectionDisplay::RM1_FlexibleFonts:
		return dbg << "PrefsCollectionDisplay::RM1_FlexibleFonts";
	case PrefsCollectionDisplay::RM1_XLarge:
		return dbg << "PrefsCollectionDisplay::RM1_XLarge";
	case PrefsCollectionDisplay::RM1_XXLarge:
		return dbg << "PrefsCollectionDisplay::RM1_XXLarge";
	case PrefsCollectionDisplay::RM1_ShowBackgroundImages:
		return dbg << "PrefsCollectionDisplay::RM1_ShowBackgroundImages";
	case PrefsCollectionDisplay::RM1_DownloadImagesAsap:
		return dbg << "PrefsCollectionDisplay::RM1_DownloadImagesAsap";
	case PrefsCollectionDisplay::RM1_Float:
		return dbg << "PrefsCollectionDisplay::RM1_Float";
	case PrefsCollectionDisplay::RM1_FlexibleImageSizes:
		return dbg << "PrefsCollectionDisplay::RM1_FlexibleImageSizes";
	case PrefsCollectionDisplay::RM1_MinimumImageWidth:
		return dbg << "PrefsCollectionDisplay::RM1_MinimumImageWidth";
	case PrefsCollectionDisplay::RM1_RemoveLargeImages:
		return dbg << "PrefsCollectionDisplay::RM1_RemoveLargeImages";
	case PrefsCollectionDisplay::RM1_RemoveOrnamentalImages:
		return dbg << "PrefsCollectionDisplay::RM1_RemoveOrnamentalImages";
	case PrefsCollectionDisplay::RM1_ShowImages:
		return dbg << "PrefsCollectionDisplay::RM1_ShowImages";
	case PrefsCollectionDisplay::RM1_UseAltForCertainImages:
		return dbg << "PrefsCollectionDisplay::RM1_UseAltForCertainImages";
	case PrefsCollectionDisplay::RM1_AbsolutePositioning:
		return dbg << "PrefsCollectionDisplay::RM1_AbsolutePositioning";
	case PrefsCollectionDisplay::RM1_AllowHorizontalScrollbar:
		return dbg << "PrefsCollectionDisplay::RM1_AllowHorizontalScrollbar";
	case PrefsCollectionDisplay::RM1_CrossoverSize:
		return dbg << "PrefsCollectionDisplay::RM1_CrossoverSize";
	case PrefsCollectionDisplay::RM1_DownloadAndApplyDocumentStyleSheets:
		return dbg << "PrefsCollectionDisplay::RM1_DownloadAndApplyDocumentStyleSheets";
	case PrefsCollectionDisplay::RM1_FramesPolicy:
		return dbg << "PrefsCollectionDisplay::RM1_FramesPolicy";
	case PrefsCollectionDisplay::RM1_RespondToMediaType:
		return dbg << "PrefsCollectionDisplay::RM1_RespondToMediaType";
	case PrefsCollectionDisplay::RM1_MediaStyleHandling:
		return dbg << "PrefsCollectionDisplay::RM1_MediaStyleHandling";
	case PrefsCollectionDisplay::RM1_ApplyModeSpecificTricks:
		return dbg << "PrefsCollectionDisplay::RM1_ApplyModeSpecificTricks";
	case PrefsCollectionDisplay::RM1_HonorHidden:
		return dbg << "PrefsCollectionDisplay::RM1_HonorHidden";
	case PrefsCollectionDisplay::RM1_ShowIFrames:
		return dbg << "PrefsCollectionDisplay::RM1_ShowIFrames";
	case PrefsCollectionDisplay::RM1_HighlightBlocks:
		return dbg << "PrefsCollectionDisplay::RM1_HighlightBlocks";
	case PrefsCollectionDisplay::RM1_MinimumTextColorContrast:
		return dbg << "PrefsCollectionDisplay::RM1_MinimumTextColorContrast";
	case PrefsCollectionDisplay::RM1_TextColorDark:
		return dbg << "PrefsCollectionDisplay::RM1_TextColorDark";
	case PrefsCollectionDisplay::RM1_TextColorLight:
		return dbg << "PrefsCollectionDisplay::RM1_TextColorLight";
	case PrefsCollectionDisplay::RM1_ConvertNbspIntoNormalSpace:
		return dbg << "PrefsCollectionDisplay::RM1_ConvertNbspIntoNormalSpace";
	case PrefsCollectionDisplay::RM1_ColumnStretch:
		return dbg << "PrefsCollectionDisplay::RM1_ColumnStretch";
	case PrefsCollectionDisplay::RM1_FlexibleColumns:
		return dbg << "PrefsCollectionDisplay::RM1_FlexibleColumns";
	case PrefsCollectionDisplay::RM1_HonorNowrap:
		return dbg << "PrefsCollectionDisplay::RM1_HonorNowrap";
	case PrefsCollectionDisplay::RM1_IgnoreRowspanWhenRestructuring:
		return dbg << "PrefsCollectionDisplay::RM1_IgnoreRowspanWhenRestructuring";
	case PrefsCollectionDisplay::RM1_SplitHideLongWords:
		return dbg << "PrefsCollectionDisplay::RM1_SplitHideLongWords";
	case PrefsCollectionDisplay::RM1_TableMagic:
		return dbg << "PrefsCollectionDisplay::RM1_TableMagic";
	case PrefsCollectionDisplay::RM1_TableStrategy:
		return dbg << "PrefsCollectionDisplay::RM1_TableStrategy";
	case PrefsCollectionDisplay::RM2_AvoidInterlaceFlicker:
		return dbg << "PrefsCollectionDisplay::RM2_AvoidInterlaceFlicker";
	case PrefsCollectionDisplay::RM2_AbsolutelyPositionedElements:
		return dbg << "PrefsCollectionDisplay::RM2_AbsolutelyPositionedElements";
	case PrefsCollectionDisplay::RM2_AllowScrollbarsInIFrame:
		return dbg << "PrefsCollectionDisplay::RM2_AllowScrollbarsInIFrame";
	case PrefsCollectionDisplay::RM2_AllowAggressiveWordBreaking:
		return dbg << "PrefsCollectionDisplay::RM2_AllowAggressiveWordBreaking";
	case PrefsCollectionDisplay::RM2_Large:
		return dbg << "PrefsCollectionDisplay::RM2_Large";
	case PrefsCollectionDisplay::RM2_Medium:
		return dbg << "PrefsCollectionDisplay::RM2_Medium";
	case PrefsCollectionDisplay::RM2_Small:
		return dbg << "PrefsCollectionDisplay::RM2_Small";
	case PrefsCollectionDisplay::RM2_FlexibleFonts:
		return dbg << "PrefsCollectionDisplay::RM2_FlexibleFonts";
	case PrefsCollectionDisplay::RM2_XLarge:
		return dbg << "PrefsCollectionDisplay::RM2_XLarge";
	case PrefsCollectionDisplay::RM2_XXLarge:
		return dbg << "PrefsCollectionDisplay::RM2_XXLarge";
	case PrefsCollectionDisplay::RM2_ShowBackgroundImages:
		return dbg << "PrefsCollectionDisplay::RM2_ShowBackgroundImages";
	case PrefsCollectionDisplay::RM2_DownloadImagesAsap:
		return dbg << "PrefsCollectionDisplay::RM2_DownloadImagesAsap";
	case PrefsCollectionDisplay::RM2_Float:
		return dbg << "PrefsCollectionDisplay::RM2_Float";
	case PrefsCollectionDisplay::RM2_FlexibleImageSizes:
		return dbg << "PrefsCollectionDisplay::RM2_FlexibleImageSizes";
	case PrefsCollectionDisplay::RM2_MinimumImageWidth:
		return dbg << "PrefsCollectionDisplay::RM2_MinimumImageWidth";
	case PrefsCollectionDisplay::RM2_RemoveLargeImages:
		return dbg << "PrefsCollectionDisplay::RM2_RemoveLargeImages";
	case PrefsCollectionDisplay::RM2_RemoveOrnamentalImages:
		return dbg << "PrefsCollectionDisplay::RM2_RemoveOrnamentalImages";
	case PrefsCollectionDisplay::RM2_ShowImages:
		return dbg << "PrefsCollectionDisplay::RM2_ShowImages";
	case PrefsCollectionDisplay::RM2_UseAltForCertainImages:
		return dbg << "PrefsCollectionDisplay::RM2_UseAltForCertainImages";
	case PrefsCollectionDisplay::RM2_AbsolutePositioning:
		return dbg << "PrefsCollectionDisplay::RM2_AbsolutePositioning";
	case PrefsCollectionDisplay::RM2_AllowHorizontalScrollbar:
		return dbg << "PrefsCollectionDisplay::RM2_AllowHorizontalScrollbar";
	case PrefsCollectionDisplay::RM2_CrossoverSize:
		return dbg << "PrefsCollectionDisplay::RM2_CrossoverSize";
	case PrefsCollectionDisplay::RM2_DownloadAndApplyDocumentStyleSheets:
		return dbg << "PrefsCollectionDisplay::RM2_DownloadAndApplyDocumentStyleSheets";
	case PrefsCollectionDisplay::RM2_FramesPolicy:
		return dbg << "PrefsCollectionDisplay::RM2_FramesPolicy";
	case PrefsCollectionDisplay::RM2_RespondToMediaType:
		return dbg << "PrefsCollectionDisplay::RM2_RespondToMediaType";
	case PrefsCollectionDisplay::RM2_MediaStyleHandling:
		return dbg << "PrefsCollectionDisplay::RM2_MediaStyleHandling";
	case PrefsCollectionDisplay::RM2_ApplyModeSpecificTricks:
		return dbg << "PrefsCollectionDisplay::RM2_ApplyModeSpecificTricks";
	case PrefsCollectionDisplay::RM2_HonorHidden:
		return dbg << "PrefsCollectionDisplay::RM2_HonorHidden";
	case PrefsCollectionDisplay::RM2_ShowIFrames:
		return dbg << "PrefsCollectionDisplay::RM2_ShowIFrames";
	case PrefsCollectionDisplay::RM2_HighlightBlocks:
		return dbg << "PrefsCollectionDisplay::RM2_HighlightBlocks";
	case PrefsCollectionDisplay::RM2_MinimumTextColorContrast:
		return dbg << "PrefsCollectionDisplay::RM2_MinimumTextColorContrast";
	case PrefsCollectionDisplay::RM2_TextColorDark:
		return dbg << "PrefsCollectionDisplay::RM2_TextColorDark";
	case PrefsCollectionDisplay::RM2_TextColorLight:
		return dbg << "PrefsCollectionDisplay::RM2_TextColorLight";
	case PrefsCollectionDisplay::RM2_ConvertNbspIntoNormalSpace:
		return dbg << "PrefsCollectionDisplay::RM2_ConvertNbspIntoNormalSpace";
	case PrefsCollectionDisplay::RM2_ColumnStretch:
		return dbg << "PrefsCollectionDisplay::RM2_ColumnStretch";
	case PrefsCollectionDisplay::RM2_FlexibleColumns:
		return dbg << "PrefsCollectionDisplay::RM2_FlexibleColumns";
	case PrefsCollectionDisplay::RM2_HonorNowrap:
		return dbg << "PrefsCollectionDisplay::RM2_HonorNowrap";
	case PrefsCollectionDisplay::RM2_IgnoreRowspanWhenRestructuring:
		return dbg << "PrefsCollectionDisplay::RM2_IgnoreRowspanWhenRestructuring";
	case PrefsCollectionDisplay::RM2_SplitHideLongWords:
		return dbg << "PrefsCollectionDisplay::RM2_SplitHideLongWords";
	case PrefsCollectionDisplay::RM2_TableMagic:
		return dbg << "PrefsCollectionDisplay::RM2_TableMagic";
	case PrefsCollectionDisplay::RM2_TableStrategy:
		return dbg << "PrefsCollectionDisplay::RM2_TableStrategy";
	case PrefsCollectionDisplay::RM3_AvoidInterlaceFlicker:
		return dbg << "PrefsCollectionDisplay::RM3_AvoidInterlaceFlicker";
	case PrefsCollectionDisplay::RM3_AbsolutelyPositionedElements:
		return dbg << "PrefsCollectionDisplay::RM3_AbsolutelyPositionedElements";
	case PrefsCollectionDisplay::RM3_AllowScrollbarsInIFrame:
		return dbg << "PrefsCollectionDisplay::RM3_AllowScrollbarsInIFrame";
	case PrefsCollectionDisplay::RM3_AllowAggressiveWordBreaking:
		return dbg << "PrefsCollectionDisplay::RM3_AllowAggressiveWordBreaking";
	case PrefsCollectionDisplay::RM3_Large:
		return dbg << "PrefsCollectionDisplay::RM3_Large";
	case PrefsCollectionDisplay::RM3_Medium:
		return dbg << "PrefsCollectionDisplay::RM3_Medium";
	case PrefsCollectionDisplay::RM3_Small:
		return dbg << "PrefsCollectionDisplay::RM3_Small";
	case PrefsCollectionDisplay::RM3_FlexibleFonts:
		return dbg << "PrefsCollectionDisplay::RM3_FlexibleFonts";
	case PrefsCollectionDisplay::RM3_XLarge:
		return dbg << "PrefsCollectionDisplay::RM3_XLarge";
	case PrefsCollectionDisplay::RM3_XXLarge:
		return dbg << "PrefsCollectionDisplay::RM3_XXLarge";
	case PrefsCollectionDisplay::RM3_ShowBackgroundImages:
		return dbg << "PrefsCollectionDisplay::RM3_ShowBackgroundImages";
	case PrefsCollectionDisplay::RM3_DownloadImagesAsap:
		return dbg << "PrefsCollectionDisplay::RM3_DownloadImagesAsap";
	case PrefsCollectionDisplay::RM3_Float:
		return dbg << "PrefsCollectionDisplay::RM3_Float";
	case PrefsCollectionDisplay::RM3_FlexibleImageSizes:
		return dbg << "PrefsCollectionDisplay::RM3_FlexibleImageSizes";
	case PrefsCollectionDisplay::RM3_MinimumImageWidth:
		return dbg << "PrefsCollectionDisplay::RM3_MinimumImageWidth";
	case PrefsCollectionDisplay::RM3_RemoveLargeImages:
		return dbg << "PrefsCollectionDisplay::RM3_RemoveLargeImages";
	case PrefsCollectionDisplay::RM3_RemoveOrnamentalImages:
		return dbg << "PrefsCollectionDisplay::RM3_RemoveOrnamentalImages";
	case PrefsCollectionDisplay::RM3_ShowImages:
		return dbg << "PrefsCollectionDisplay::RM3_ShowImages";
	case PrefsCollectionDisplay::RM3_UseAltForCertainImages:
		return dbg << "PrefsCollectionDisplay::RM3_UseAltForCertainImages";
	case PrefsCollectionDisplay::RM3_AbsolutePositioning:
		return dbg << "PrefsCollectionDisplay::RM3_AbsolutePositioning";
	case PrefsCollectionDisplay::RM3_AllowHorizontalScrollbar:
		return dbg << "PrefsCollectionDisplay::RM3_AllowHorizontalScrollbar";
	case PrefsCollectionDisplay::RM3_CrossoverSize:
		return dbg << "PrefsCollectionDisplay::RM3_CrossoverSize";
	case PrefsCollectionDisplay::RM3_DownloadAndApplyDocumentStyleSheets:
		return dbg << "PrefsCollectionDisplay::RM3_DownloadAndApplyDocumentStyleSheets";
	case PrefsCollectionDisplay::RM3_FramesPolicy:
		return dbg << "PrefsCollectionDisplay::RM3_FramesPolicy";
	case PrefsCollectionDisplay::RM3_RespondToMediaType:
		return dbg << "PrefsCollectionDisplay::RM3_RespondToMediaType";
	case PrefsCollectionDisplay::RM3_MediaStyleHandling:
		return dbg << "PrefsCollectionDisplay::RM3_MediaStyleHandling";
	case PrefsCollectionDisplay::RM3_ApplyModeSpecificTricks:
		return dbg << "PrefsCollectionDisplay::RM3_ApplyModeSpecificTricks";
	case PrefsCollectionDisplay::RM3_HonorHidden:
		return dbg << "PrefsCollectionDisplay::RM3_HonorHidden";
	case PrefsCollectionDisplay::RM3_ShowIFrames:
		return dbg << "PrefsCollectionDisplay::RM3_ShowIFrames";
	case PrefsCollectionDisplay::RM3_HighlightBlocks:
		return dbg << "PrefsCollectionDisplay::RM3_HighlightBlocks";
	case PrefsCollectionDisplay::RM3_MinimumTextColorContrast:
		return dbg << "PrefsCollectionDisplay::RM3_MinimumTextColorContrast";
	case PrefsCollectionDisplay::RM3_TextColorDark:
		return dbg << "PrefsCollectionDisplay::RM3_TextColorDark";
	case PrefsCollectionDisplay::RM3_TextColorLight:
		return dbg << "PrefsCollectionDisplay::RM3_TextColorLight";
	case PrefsCollectionDisplay::RM3_ConvertNbspIntoNormalSpace:
		return dbg << "PrefsCollectionDisplay::RM3_ConvertNbspIntoNormalSpace";
	case PrefsCollectionDisplay::RM3_ColumnStretch:
		return dbg << "PrefsCollectionDisplay::RM3_ColumnStretch";
	case PrefsCollectionDisplay::RM3_FlexibleColumns:
		return dbg << "PrefsCollectionDisplay::RM3_FlexibleColumns";
	case PrefsCollectionDisplay::RM3_HonorNowrap:
		return dbg << "PrefsCollectionDisplay::RM3_HonorNowrap";
	case PrefsCollectionDisplay::RM3_IgnoreRowspanWhenRestructuring:
		return dbg << "PrefsCollectionDisplay::RM3_IgnoreRowspanWhenRestructuring";
	case PrefsCollectionDisplay::RM3_SplitHideLongWords:
		return dbg << "PrefsCollectionDisplay::RM3_SplitHideLongWords";
	case PrefsCollectionDisplay::RM3_TableMagic:
		return dbg << "PrefsCollectionDisplay::RM3_TableMagic";
	case PrefsCollectionDisplay::RM3_TableStrategy:
		return dbg << "PrefsCollectionDisplay::RM3_TableStrategy";
	case PrefsCollectionDisplay::RM4_AvoidInterlaceFlicker:
		return dbg << "PrefsCollectionDisplay::RM4_AvoidInterlaceFlicker";
	case PrefsCollectionDisplay::RM4_AbsolutelyPositionedElements:
		return dbg << "PrefsCollectionDisplay::RM4_AbsolutelyPositionedElements";
	case PrefsCollectionDisplay::RM4_AllowScrollbarsInIFrame:
		return dbg << "PrefsCollectionDisplay::RM4_AllowScrollbarsInIFrame";
	case PrefsCollectionDisplay::RM4_AllowAggressiveWordBreaking:
		return dbg << "PrefsCollectionDisplay::RM4_AllowAggressiveWordBreaking";
	case PrefsCollectionDisplay::RM4_Large:
		return dbg << "PrefsCollectionDisplay::RM4_Large";
	case PrefsCollectionDisplay::RM4_Medium:
		return dbg << "PrefsCollectionDisplay::RM4_Medium";
	case PrefsCollectionDisplay::RM4_Small:
		return dbg << "PrefsCollectionDisplay::RM4_Small";
	case PrefsCollectionDisplay::RM4_FlexibleFonts:
		return dbg << "PrefsCollectionDisplay::RM4_FlexibleFonts";
	case PrefsCollectionDisplay::RM4_XLarge:
		return dbg << "PrefsCollectionDisplay::RM4_XLarge";
	case PrefsCollectionDisplay::RM4_XXLarge:
		return dbg << "PrefsCollectionDisplay::RM4_XXLarge";
	case PrefsCollectionDisplay::RM4_ShowBackgroundImages:
		return dbg << "PrefsCollectionDisplay::RM4_ShowBackgroundImages";
	case PrefsCollectionDisplay::RM4_DownloadImagesAsap:
		return dbg << "PrefsCollectionDisplay::RM4_DownloadImagesAsap";
	case PrefsCollectionDisplay::RM4_Float:
		return dbg << "PrefsCollectionDisplay::RM4_Float";
	case PrefsCollectionDisplay::RM4_FlexibleImageSizes:
		return dbg << "PrefsCollectionDisplay::RM4_FlexibleImageSizes";
	case PrefsCollectionDisplay::RM4_MinimumImageWidth:
		return dbg << "PrefsCollectionDisplay::RM4_MinimumImageWidth";
	case PrefsCollectionDisplay::RM4_RemoveLargeImages:
		return dbg << "PrefsCollectionDisplay::RM4_RemoveLargeImages";
	case PrefsCollectionDisplay::RM4_RemoveOrnamentalImages:
		return dbg << "PrefsCollectionDisplay::RM4_RemoveOrnamentalImages";
	case PrefsCollectionDisplay::RM4_ShowImages:
		return dbg << "PrefsCollectionDisplay::RM4_ShowImages";
	case PrefsCollectionDisplay::RM4_UseAltForCertainImages:
		return dbg << "PrefsCollectionDisplay::RM4_UseAltForCertainImages";
	case PrefsCollectionDisplay::RM4_AbsolutePositioning:
		return dbg << "PrefsCollectionDisplay::RM4_AbsolutePositioning";
	case PrefsCollectionDisplay::RM4_AllowHorizontalScrollbar:
		return dbg << "PrefsCollectionDisplay::RM4_AllowHorizontalScrollbar";
	case PrefsCollectionDisplay::RM4_CrossoverSize:
		return dbg << "PrefsCollectionDisplay::RM4_CrossoverSize";
	case PrefsCollectionDisplay::RM4_DownloadAndApplyDocumentStyleSheets:
		return dbg << "PrefsCollectionDisplay::RM4_DownloadAndApplyDocumentStyleSheets";
	case PrefsCollectionDisplay::RM4_FramesPolicy:
		return dbg << "PrefsCollectionDisplay::RM4_FramesPolicy";
	case PrefsCollectionDisplay::RM4_RespondToMediaType:
		return dbg << "PrefsCollectionDisplay::RM4_RespondToMediaType";
	case PrefsCollectionDisplay::RM4_MediaStyleHandling:
		return dbg << "PrefsCollectionDisplay::RM4_MediaStyleHandling";
	case PrefsCollectionDisplay::RM4_ApplyModeSpecificTricks:
		return dbg << "PrefsCollectionDisplay::RM4_ApplyModeSpecificTricks";
	case PrefsCollectionDisplay::RM4_HonorHidden:
		return dbg << "PrefsCollectionDisplay::RM4_HonorHidden";
	case PrefsCollectionDisplay::RM4_ShowIFrames:
		return dbg << "PrefsCollectionDisplay::RM4_ShowIFrames";
	case PrefsCollectionDisplay::RM4_HighlightBlocks:
		return dbg << "PrefsCollectionDisplay::RM4_HighlightBlocks";
	case PrefsCollectionDisplay::RM4_MinimumTextColorContrast:
		return dbg << "PrefsCollectionDisplay::RM4_MinimumTextColorContrast";
	case PrefsCollectionDisplay::RM4_TextColorDark:
		return dbg << "PrefsCollectionDisplay::RM4_TextColorDark";
	case PrefsCollectionDisplay::RM4_TextColorLight:
		return dbg << "PrefsCollectionDisplay::RM4_TextColorLight";
	case PrefsCollectionDisplay::RM4_ConvertNbspIntoNormalSpace:
		return dbg << "PrefsCollectionDisplay::RM4_ConvertNbspIntoNormalSpace";
	case PrefsCollectionDisplay::RM4_ColumnStretch:
		return dbg << "PrefsCollectionDisplay::RM4_ColumnStretch";
	case PrefsCollectionDisplay::RM4_FlexibleColumns:
		return dbg << "PrefsCollectionDisplay::RM4_FlexibleColumns";
	case PrefsCollectionDisplay::RM4_HonorNowrap:
		return dbg << "PrefsCollectionDisplay::RM4_HonorNowrap";
	case PrefsCollectionDisplay::RM4_IgnoreRowspanWhenRestructuring:
		return dbg << "PrefsCollectionDisplay::RM4_IgnoreRowspanWhenRestructuring";
	case PrefsCollectionDisplay::RM4_SplitHideLongWords:
		return dbg << "PrefsCollectionDisplay::RM4_SplitHideLongWords";
	case PrefsCollectionDisplay::RM4_TableMagic:
		return dbg << "PrefsCollectionDisplay::RM4_TableMagic";
	case PrefsCollectionDisplay::RM4_TableStrategy:
		return dbg << "PrefsCollectionDisplay::RM4_TableStrategy";
#ifdef TV_RENDERING
	case PrefsCollectionDisplay::RM5_AvoidInterlaceFlicker:
		return dbg << "PrefsCollectionDisplay::RM5_AvoidInterlaceFlicker";
	case PrefsCollectionDisplay::RM5_AbsolutelyPositionedElements:
		return dbg << "PrefsCollectionDisplay::RM5_AbsolutelyPositionedElements";
	case PrefsCollectionDisplay::RM5_AllowScrollbarsInIFrame:
		return dbg << "PrefsCollectionDisplay::RM5_AllowScrollbarsInIFrame";
	case PrefsCollectionDisplay::RM5_AllowAggressiveWordBreaking:
		return dbg << "PrefsCollectionDisplay::RM5_AllowAggressiveWordBreaking";
	case PrefsCollectionDisplay::RM5_Large:
		return dbg << "PrefsCollectionDisplay::RM5_Large";
	case PrefsCollectionDisplay::RM5_Medium:
		return dbg << "PrefsCollectionDisplay::RM5_Medium";
	case PrefsCollectionDisplay::RM5_Small:
		return dbg << "PrefsCollectionDisplay::RM5_Small";
	case PrefsCollectionDisplay::RM5_FlexibleFonts:
		return dbg << "PrefsCollectionDisplay::RM5_FlexibleFonts";
	case PrefsCollectionDisplay::RM5_XLarge:
		return dbg << "PrefsCollectionDisplay::RM5_XLarge";
	case PrefsCollectionDisplay::RM5_XXLarge:
		return dbg << "PrefsCollectionDisplay::RM5_XXLarge";
	case PrefsCollectionDisplay::RM5_ShowBackgroundImages:
		return dbg << "PrefsCollectionDisplay::RM5_ShowBackgroundImages";
	case PrefsCollectionDisplay::RM5_DownloadImagesAsap:
		return dbg << "PrefsCollectionDisplay::RM5_DownloadImagesAsap";
	case PrefsCollectionDisplay::RM5_Float:
		return dbg << "PrefsCollectionDisplay::RM5_Float";
	case PrefsCollectionDisplay::RM5_FlexibleImageSizes:
		return dbg << "PrefsCollectionDisplay::RM5_FlexibleImageSizes";
	case PrefsCollectionDisplay::RM5_MinimumImageWidth:
		return dbg << "PrefsCollectionDisplay::RM5_MinimumImageWidth";
	case PrefsCollectionDisplay::RM5_RemoveLargeImages:
		return dbg << "PrefsCollectionDisplay::RM5_RemoveLargeImages";
	case PrefsCollectionDisplay::RM5_RemoveOrnamentalImages:
		return dbg << "PrefsCollectionDisplay::RM5_RemoveOrnamentalImages";
	case PrefsCollectionDisplay::RM5_ShowImages:
		return dbg << "PrefsCollectionDisplay::RM5_ShowImages";
	case PrefsCollectionDisplay::RM5_UseAltForCertainImages:
		return dbg << "PrefsCollectionDisplay::RM5_UseAltForCertainImages";
	case PrefsCollectionDisplay::RM5_AbsolutePositioning:
		return dbg << "PrefsCollectionDisplay::RM5_AbsolutePositioning";
	case PrefsCollectionDisplay::RM5_AllowHorizontalScrollbar:
		return dbg << "PrefsCollectionDisplay::RM5_AllowHorizontalScrollbar";
	case PrefsCollectionDisplay::RM5_CrossoverSize:
		return dbg << "PrefsCollectionDisplay::RM5_CrossoverSize";
	case PrefsCollectionDisplay::RM5_DownloadAndApplyDocumentStyleSheets:
		return dbg << "PrefsCollectionDisplay::RM5_DownloadAndApplyDocumentStyleSheets";
	case PrefsCollectionDisplay::RM5_FramesPolicy:
		return dbg << "PrefsCollectionDisplay::RM5_FramesPolicy";
	case PrefsCollectionDisplay::RM5_RespondToMediaType:
		return dbg << "PrefsCollectionDisplay::RM5_RespondToMediaType";
	case PrefsCollectionDisplay::RM5_MediaStyleHandling:
		return dbg << "PrefsCollectionDisplay::RM5_MediaStyleHandling";
	case PrefsCollectionDisplay::RM5_ApplyModeSpecificTricks:
		return dbg << "PrefsCollectionDisplay::RM5_ApplyModeSpecificTricks";
	case PrefsCollectionDisplay::RM5_HonorHidden:
		return dbg << "PrefsCollectionDisplay::RM5_HonorHidden";
	case PrefsCollectionDisplay::RM5_ShowIFrames:
		return dbg << "PrefsCollectionDisplay::RM5_ShowIFrames";
	case PrefsCollectionDisplay::RM5_HighlightBlocks:
		return dbg << "PrefsCollectionDisplay::RM5_HighlightBlocks";
	case PrefsCollectionDisplay::RM5_MinimumTextColorContrast:
		return dbg << "PrefsCollectionDisplay::RM5_MinimumTextColorContrast";
	case PrefsCollectionDisplay::RM5_TextColorDark:
		return dbg << "PrefsCollectionDisplay::RM5_TextColorDark";
	case PrefsCollectionDisplay::RM5_TextColorLight:
		return dbg << "PrefsCollectionDisplay::RM5_TextColorLight";
	case PrefsCollectionDisplay::RM5_ConvertNbspIntoNormalSpace:
		return dbg << "PrefsCollectionDisplay::RM5_ConvertNbspIntoNormalSpace";
	case PrefsCollectionDisplay::RM5_ColumnStretch:
		return dbg << "PrefsCollectionDisplay::RM5_ColumnStretch";
	case PrefsCollectionDisplay::RM5_FlexibleColumns:
		return dbg << "PrefsCollectionDisplay::RM5_FlexibleColumns";
	case PrefsCollectionDisplay::RM5_HonorNowrap:
		return dbg << "PrefsCollectionDisplay::RM5_HonorNowrap";
	case PrefsCollectionDisplay::RM5_IgnoreRowspanWhenRestructuring:
		return dbg << "PrefsCollectionDisplay::RM5_IgnoreRowspanWhenRestructuring";
	case PrefsCollectionDisplay::RM5_SplitHideLongWords:
		return dbg << "PrefsCollectionDisplay::RM5_SplitHideLongWords";
	case PrefsCollectionDisplay::RM5_TableMagic:
		return dbg << "PrefsCollectionDisplay::RM5_TableMagic";
	case PrefsCollectionDisplay::RM5_TableStrategy:
		return dbg << "PrefsCollectionDisplay::RM5_TableStrategy";
#endif
#ifdef SVG_SUPPORT
	case PrefsCollectionDisplay::SVGRenderingQuality:
		return dbg << "PrefsCollectionDisplay::SVGRenderingQuality";
	case PrefsCollectionDisplay::SVGTargetFrameRate:
		return dbg << "PrefsCollectionDisplay::SVGTargetFrameRate";
#endif
	case PrefsCollectionDisplay::UM_AuthorCSS:
		return dbg << "PrefsCollectionDisplay::UM_AuthorCSS";
	case PrefsCollectionDisplay::UM_AuthorFonts:
		return dbg << "PrefsCollectionDisplay::UM_AuthorFonts";
	case PrefsCollectionDisplay::UM_UserCSS:
		return dbg << "PrefsCollectionDisplay::UM_UserCSS";
	case PrefsCollectionDisplay::UM_UserFonts:
		return dbg << "PrefsCollectionDisplay::UM_UserFonts";
	case PrefsCollectionDisplay::UM_UserLinks:
		return dbg << "PrefsCollectionDisplay::UM_UserLinks";
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	case PrefsCollectionDisplay::AllowScriptToChangeStatus:
		return dbg << "PrefsCollectionDisplay::AllowScriptToChangeStatus";
#endif
	case PrefsCollectionDisplay::AllowScriptToHideURL:
		return dbg << "PrefsCollectionDisplay::AllowScriptToHideURL";
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	case PrefsCollectionDisplay::AllowScriptToLowerWindow:
		return dbg << "PrefsCollectionDisplay::AllowScriptToLowerWindow";
	case PrefsCollectionDisplay::AllowScriptToMoveWindow:
		return dbg << "PrefsCollectionDisplay::AllowScriptToMoveWindow";
	case PrefsCollectionDisplay::AllowScriptToRaiseWindow:
		return dbg << "PrefsCollectionDisplay::AllowScriptToRaiseWindow";
#endif
	case PrefsCollectionDisplay::AllowScriptToReceiveRightClicks:
		return dbg << "PrefsCollectionDisplay::AllowScriptToReceiveRightClicks";
#ifdef PREFS_HAVE_SCRIPT_ALLOW
	case PrefsCollectionDisplay::AllowScriptToResizeWindow:
		return dbg << "PrefsCollectionDisplay::AllowScriptToResizeWindow";
#endif
	case PrefsCollectionDisplay::AltImageBorderEnabled:
		return dbg << "PrefsCollectionDisplay::AltImageBorderEnabled";
#ifdef _DIRECT_URL_WINDOW_
	case PrefsCollectionDisplay::AutoDropDown:
		return dbg << "PrefsCollectionDisplay::AutoDropDown";
#endif
#ifdef PREFS_HAVE_HOTCLICK
	case PrefsCollectionDisplay::AutomaticSelectMenu:
		return dbg << "PrefsCollectionDisplay::AutomaticSelectMenu";
#endif
#if !defined USE_HTML_PARSER_FOR_XML
	case PrefsCollectionDisplay::ReparseFailedXHTML:
		return dbg << "PrefsCollectionDisplay::ReparseFailedXHTML";
#endif
#ifdef _SUPPORT_SMOOTH_DISPLAY_
	case PrefsCollectionDisplay::SmoothDisplay:
		return dbg << "PrefsCollectionDisplay::SmoothDisplay";
#endif
#ifdef ENCODING_DRIVEN_LINE_HEIGHT
	case PrefsCollectionDisplay::DefaultLineHeightCyrillic:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightCyrillic";
	case PrefsCollectionDisplay::DefaultLineHeightGeneral:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightGeneral";
	case PrefsCollectionDisplay::DefaultLineHeightJapanese:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightJapanese";
	case PrefsCollectionDisplay::DefaultLineHeightKorean:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightKorean";
	case PrefsCollectionDisplay::DefaultLineHeightSimplifiedChinese:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightSimplifiedChinese";
	case PrefsCollectionDisplay::DefaultLineHeightTraditionalChinese:
		return dbg << "PrefsCollectionDisplay::DefaultLineHeightTraditionalChinese";
#endif
#ifdef SKIN_HIGHLIGHTED_ELEMENT
	case PrefsCollectionDisplay::DisableHighlightUponOutline:
		return dbg << "PrefsCollectionDisplay::DisableHighlightUponOutline";
#endif
	case PrefsCollectionDisplay::DocumentMode:
		return dbg << "PrefsCollectionDisplay::DocumentMode";
#ifdef ON_DEMAND_PLUGIN
	case PrefsCollectionDisplay::EnableOnDemandPlugin:
		return dbg << "PrefsCollectionDisplay::EnableOnDemandPlugin";
	case PrefsCollectionDisplay::EnableOnDemandPluginPlaceholder:
		return dbg << "PrefsCollectionDisplay::EnableOnDemandPluginPlaceholder";
#endif
#ifdef CSS_SCROLLBARS_SUPPORT
	case PrefsCollectionDisplay::EnableScrollbarColors:
		return dbg << "PrefsCollectionDisplay::EnableScrollbarColors";
#endif
	case PrefsCollectionDisplay::EnableStylingOnForms:
		return dbg << "PrefsCollectionDisplay::EnableStylingOnForms";
	case PrefsCollectionDisplay::EnableWebfonts:
		return dbg << "PrefsCollectionDisplay::EnableWebfonts";
	case PrefsCollectionDisplay::FirstUpdateDelay:
		return dbg << "PrefsCollectionDisplay::FirstUpdateDelay";
	case PrefsCollectionDisplay::FlexRootMaxWidth:
		return dbg << "PrefsCollectionDisplay::FlexRootMaxWidth";
	case PrefsCollectionDisplay::FlexRootMinWidth:
		return dbg << "PrefsCollectionDisplay::FlexRootMinWidth";
#ifdef FORMAT_UNSTYLED_XML
	case PrefsCollectionDisplay::FormatUnstyledXML:
		return dbg << "PrefsCollectionDisplay::FormatUnstyledXML";
#endif
#ifdef LAYOUT_YIELD_REFLOW
	case PrefsCollectionDisplay::InitialYieldReflowTime:
		return dbg << "PrefsCollectionDisplay::InitialYieldReflowTime";
#endif
	case PrefsCollectionDisplay::LeftHandedUI:
		return dbg << "PrefsCollectionDisplay::LeftHandedUI";
	case PrefsCollectionDisplay::LimitParagraphWidth:
		return dbg << "PrefsCollectionDisplay::LimitParagraphWidth";
	case PrefsCollectionDisplay::MaximumMarqueeLoops:
		return dbg << "PrefsCollectionDisplay::MaximumMarqueeLoops";
#ifdef WIDGETS_LIMIT_TEXTAREA_SIZE
	case PrefsCollectionDisplay::MaximumBytesTextarea:
		return dbg << "PrefsCollectionDisplay::MaximumBytesTextarea";
#endif
	case PrefsCollectionDisplay::MaxFontSize:
		return dbg << "PrefsCollectionDisplay::MaxFontSize";
	case PrefsCollectionDisplay::MinFontSize:
		return dbg << "PrefsCollectionDisplay::MinFontSize";
#ifdef SUPPORT_TEXT_DIRECTION
	case PrefsCollectionDisplay::RTLFlipsUI:
		return dbg << "PrefsCollectionDisplay::RTLFlipsUI";
#endif
#ifdef LAYOUT_USE_SSR_MAX_WIDTH_PREF
	case PrefsCollectionDisplay::SSRMaxWidth:
		return dbg << "PrefsCollectionDisplay::SSRMaxWidth";
#endif
#ifdef SESSION_SUPPORT
	case PrefsCollectionDisplay::SavePasswordProtectedPages:
		return dbg << "PrefsCollectionDisplay::SavePasswordProtectedPages";
#endif
	case PrefsCollectionDisplay::Scale:
		return dbg << "PrefsCollectionDisplay::Scale";
#ifdef GRAB_AND_SCROLL
	case PrefsCollectionDisplay::ScrollIsPan:
		return dbg << "PrefsCollectionDisplay::ScrollIsPan";
#endif
#ifdef SUPPORT_IME_PASSWORD_INPUT
	case PrefsCollectionDisplay::ShowIMEPassword:
		return dbg << "PrefsCollectionDisplay::ShowIMEPassword";
#endif
	case PrefsCollectionDisplay::SmoothScrolling:
		return dbg << "PrefsCollectionDisplay::SmoothScrolling";
	case PrefsCollectionDisplay::StyledFirstUpdateTimeout:
		return dbg << "PrefsCollectionDisplay::StyledFirstUpdateTimeout";
	case PrefsCollectionDisplay::UpdateDelay:
		return dbg << "PrefsCollectionDisplay::UpdateDelay";
#ifdef LAYOUT_YIELD_REFLOW
	case PrefsCollectionDisplay::YieldReflowTimeIncreaseRate:
		return dbg << "PrefsCollectionDisplay::YieldReflowTimeIncreaseRate";
#endif
	case PrefsCollectionDisplay::VisitedLinkHasColor:
		return dbg << "PrefsCollectionDisplay::VisitedLinkHasColor";
	case PrefsCollectionDisplay::VisitedLinkHasStrikeThrough:
		return dbg << "PrefsCollectionDisplay::VisitedLinkHasStrikeThrough";
	case PrefsCollectionDisplay::VisitedLinkHasUnderline:
		return dbg << "PrefsCollectionDisplay::VisitedLinkHasUnderline";
	case PrefsCollectionDisplay::VisitedLinksState:
		return dbg << "PrefsCollectionDisplay::VisitedLinksState";
	default:
		return dbg << "PrefsCollectionDisplay::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
