/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionApp, PCAPP_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */
#if defined PREFS_HAVE_APP_INFO
	P(SAppInfo, "App ID", 0),
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_MAIL_APP
	P(SMail, "External Application", UNI_L("")),
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_NEWS_APP
	P(SNews, "External Application", UNI_L("")),
#endif
#ifdef _PLUGIN_SUPPORT_
	P(SUserPrefs, "Disabled Plugins", UNI_L("")),
	P(SUserPrefs, "Plugin Path", UNI_L("")),
#endif
#ifdef EXTERNAL_APPLICATIONS_SUPPORT
	P(SUserPrefs, "Source Viewer", UNI_L("")),
#endif

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionApp, PCAPP_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#if defined PREFS_HAVE_APP_INFO
	I(SAppInfo, "App State", 0, prefssetting::integer),
#endif
#ifdef _PLUGIN_SUPPORT_
	I(SExtensions, "Plugin Script Access", TRUE, prefssetting::boolean),
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_PLUGIN_TIMEOUT
	I(SExtensions, "PluginResponseTimeout", 20, prefssetting::integer),
	I(SExtensions, "PluginStartTimeout", 45, prefssetting::integer),
#endif
#if defined DYNAMIC_VIEWERS && defined UPGRADE_SUPPORT
	I(SFileTypesSectionInfo, "Version", 1, prefssetting::integer),
#endif
#ifdef PREFS_HAVE_HBBTV
	I(SHbbTV, "Initialize HbbTV modules", TRUE, prefssetting::boolean),
#endif
#if defined PREFS_HAVE_MAIL_APP || defined PREFS_HAVE_NEWS_APP
	I(SMail, "ExtAppParamSpaceSubst", FALSE, prefssetting::boolean),
#endif
#ifdef NS4P_COMPONENT_PLUGINS
	I(SUserPrefs, "Plugin Sync Timeout", NS4P_SYNC_TIMEOUT, prefssetting::integer),
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_RUN_IN_TERMINAL
	I(SUserPrefs, "Run Email In Terminal", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Run News In Terminal", FALSE, prefssetting::boolean),
	I(SUserPrefs, "Run Source Viewer In Terminal", FALSE, prefssetting::boolean),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionApp::stringpref e)
{
	switch (e) {
#if defined PREFS_HAVE_APP_INFO
	case PrefsCollectionApp::AppId:
		return dbg << "PrefsCollectionApp::AppId";
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_MAIL_APP
	case PrefsCollectionApp::ExternalMailClient:
		return dbg << "PrefsCollectionApp::ExternalMailClient";
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_NEWS_APP
	case PrefsCollectionApp::ExternalNewsClient:
		return dbg << "PrefsCollectionApp::ExternalNewsClient";
#endif
#ifdef _PLUGIN_SUPPORT_
	case PrefsCollectionApp::DisabledPlugins:
		return dbg << "PrefsCollectionApp::DisabledPlugins";
	case PrefsCollectionApp::PluginPath:
		return dbg << "PrefsCollectionApp::PluginPath";
#endif
#ifdef EXTERNAL_APPLICATIONS_SUPPORT
	case PrefsCollectionApp::SourceViewer:
		return dbg << "PrefsCollectionApp::SourceViewer";
#endif
	default:
		return dbg << "PrefsCollectionApp::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionApp::integerpref e)
{
	switch (e) {
#if defined PREFS_HAVE_APP_INFO
	case PrefsCollectionApp::AppState:
		return dbg << "PrefsCollectionApp::AppState";
#endif
#ifdef _PLUGIN_SUPPORT_
	case PrefsCollectionApp::PluginScriptAccess:
		return dbg << "PrefsCollectionApp::PluginScriptAccess";
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_PLUGIN_TIMEOUT
	case PrefsCollectionApp::PluginResponseTimeout:
		return dbg << "PrefsCollectionApp::PluginResponseTimeout";
	case PrefsCollectionApp::PluginStartTimeout:
		return dbg << "PrefsCollectionApp::PluginStartTimeout";
#endif
#if defined DYNAMIC_VIEWERS && defined UPGRADE_SUPPORT
	case PrefsCollectionApp::ViewerVersion:
		return dbg << "PrefsCollectionApp::ViewerVersion";
#endif
#ifdef PREFS_HAVE_HBBTV
	case PrefsCollectionApp::HbbTVInitialize:
		return dbg << "PrefsCollectionApp::HbbTVInitialize";
#endif
#if defined PREFS_HAVE_MAIL_APP || defined PREFS_HAVE_NEWS_APP
	case PrefsCollectionApp::ExtAppParamSpaceSubst:
		return dbg << "PrefsCollectionApp::ExtAppParamSpaceSubst";
#endif
#ifdef NS4P_COMPONENT_PLUGINS
	case PrefsCollectionApp::PluginSyncTimeout:
		return dbg << "PrefsCollectionApp::PluginSyncTimeout";
#endif
#if defined EXTERNAL_APPLICATIONS_SUPPORT && defined PREFS_HAVE_RUN_IN_TERMINAL
	case PrefsCollectionApp::RunEmailInTerminal:
		return dbg << "PrefsCollectionApp::RunEmailInTerminal";
	case PrefsCollectionApp::RunNewsInTerminal:
		return dbg << "PrefsCollectionApp::RunNewsInTerminal";
	case PrefsCollectionApp::RunSourceViewerInTerminal:
		return dbg << "PrefsCollectionApp::RunSourceViewerInTerminal";
#endif
	default:
		return dbg << "PrefsCollectionApp::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
