/* -*- Mode: c++; indent-tabs-mode: t; tab-width: 4 -*- */

DOM_PROTOTYPES_START()

	/* JavaScript */
	DOM_PROTOTYPES_ITEM3(NAVIGATOR_PROTOTYPE, JS_Navigator_functions, JS_Navigator_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM2(HISTORY_PROTOTYPE, JS_History_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(CONSOLE_PROTOTYPE, JS_Console_functions, JS_Console_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(LOCATION_PROTOTYPE, JS_Location_functions, JS_Location_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(PLUGINARRAY_PROTOTYPE, JS_PluginArray_functions, -1)

	/* DOM 2 Core */
	DOM_PROTOTYPES_ITEM3(NODE_PROTOTYPE, DOM_Node_functions, DOM_Node_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(DOCUMENT_PROTOTYPE, DOM_Document_functions, DOM_Document_functions_with_data, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM2(DOCUMENTFRAGMENT_PROTOTYPE, DOM_DocumentFragment_functions_with_data, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(CHARACTERDATA_PROTOTYPE, DOM_CharacterData_functions, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(ATTR_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM3(ELEMENT_PROTOTYPE, DOM_Element_functions, DOM_Element_functions_with_data, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(TEXT_PROTOTYPE, DOM_Text_functions, DOM_Runtime::CHARACTERDATA_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(COMMENT_PROTOTYPE, DOM_Runtime::CHARACTERDATA_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(CDATASECTION_PROTOTYPE, DOM_Runtime::TEXT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(DOCUMENTTYPE_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(NOTATION_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(ENTITY_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(ENTITYREFERENCE_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(PROCESSINGINSTRUCTION_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(NODELIST_PROTOTYPE, DOM_Collection_functions, -1)
	DOM_PROTOTYPES_ITEM2(NAMEDNODEMAP_PROTOTYPE, DOM_NamedNodeMap_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(XMLDOCUMENT_PROTOTYPE, DOM_XMLDocument_functions, DOM_Runtime::DOCUMENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(DOMEXCEPTION_PROTOTYPE, -2)
	DOM_PROTOTYPES_ITEM0(CLIENTRECT_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(CLIENTRECTLIST_PROTOTYPE, DOM_ClientRectList_functions, -1)

	/* HTML5 Microdata */
	DOM_PROTOTYPES_ITEM1(HTMLPROPERTIESCOLLECTION_PROTOTYPE, DOM_HTMLPropertiesCollection_functions, DOM_Runtime::HTMLCOLLECTION_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(HTMLPROPERTYNODELISTCOLLECTION_PROTOTYPE, DOM_PropertyNodeList_Collection_functions, DOM_Runtime::NODELIST_PROTOTYPE)

	/* DOM 3 Core */
	DOM_PROTOTYPES_ITEM2(DOMCONFIGURATION_PROTOTYPE, DOM_DOMConfiguration_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(DOMSTRINGLIST_PROTOTYPE, DOM_DOMStringList_functions, -1)
	DOM_PROTOTYPES_ITEM0(DOMSTRINGMAP_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM3(DOMTOKENLIST_PROTOTYPE, DOM_DOMTokenList_functions, DOM_DOMTokenList_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(DOMSETTABLETOKENLIST_PROTOTYPE, DOM_Runtime::DOMTOKENLIST_PROTOTYPE)

	/* DOM 2 Events */
	DOM_PROTOTYPES_ITEM3(EVENT_PROTOTYPE, DOM_Event_functions, DOM_Event_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(UIEVENT_PROTOTYPE, DOM_UIEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(MOUSEEVENT_PROTOTYPE, DOM_MouseEvent_functions, DOM_Runtime::UIEVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(KEYBOARDEVENT_PROTOTYPE, DOM_KeyboardEvent_functions, DOM_Runtime::UIEVENT_PROTOTYPE)
#ifdef DOM2_MUTATION_EVENTS
	DOM_PROTOTYPES_ITEM1(MUTATIONEVENT_PROTOTYPE, DOM_MutationEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // DOM2_MUTATION_EVENTS
#ifdef PROGRESS_EVENTS_SUPPORT
	DOM_PROTOTYPES_ITEM1(PROGRESSEVENT_PROTOTYPE, DOM_ProgressEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // PROGRESS_EVENTS_SUPPORT
#ifdef CSS_TRANSITIONS
	DOM_PROTOTYPES_ITEM1(TRANSITIONEVENT_PROTOTYPE, DOM_TransitionEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(OTRANSITIONEVENT_PROTOTYPE, DOM_TransitionEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(WEBKITTRANSITIONEVENT_PROTOTYPE, DOM_TransitionEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // CSS_TRANSITIONS
#ifdef CSS_ANIMATIONS
	DOM_PROTOTYPES_ITEM1(ANIMATIONEVENT_PROTOTYPE, DOM_AnimationEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // CSS_ANIMATIONS
	DOM_PROTOTYPES_ITEM1(HASHCHANGEEVENT_PROTOTYPE, DOM_HashChangeEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(ERROREVENT_PROTOTYPE, DOM_ErrorEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(CUSTOMEVENT_PROTOTYPE, DOM_CustomEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)

	/* DOM 3 Events */
	DOM_PROTOTYPES_ITEM1(TEXTEVENT_PROTOTYPE, DOM_TextEvent_functions, DOM_Runtime::UIEVENT_PROTOTYPE)

	/* DOM 2 HTML */
	DOM_PROTOTYPES_ITEM1(HTMLCOLLECTION_PROTOTYPE, DOM_HTMLCollection_functions, DOM_Runtime::NODELIST_PROTOTYPE)
	DOM_PROTOTYPES_ITEM2(HTMLOPTIONSCOLLECTION_PROTOTYPE, DOM_HTMLOptionsCollection_functions_with_data, DOM_Runtime::HTMLCOLLECTION_PROTOTYPE)
	DOM_PROTOTYPES_ITEM3(HTMLDOCUMENT_PROTOTYPE, DOM_HTMLDocument_functions, DOM_HTMLDocument_functions_with_data, DOM_Runtime::DOCUMENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(HTMLELEMENT_PROTOTYPE, DOM_HTMLElement_functions, DOM_Runtime::ELEMENT_PROTOTYPE)

	/* DOM 2 CSS */
	DOM_PROTOTYPES_ITEM1(CSSSTYLEDECLARATION_PROTOTYPE, DOM_CSSStyleDeclaration_functions, -1)
	DOM_PROTOTYPES_ITEM1(CSSSTYLESHEET_PROTOTYPE, DOM_CSSStyleSheet_functions, -1)
	DOM_PROTOTYPES_ITEM1(CSSRULELIST_PROTOTYPE, DOM_CSSRuleList_functions, -1)
	DOM_PROTOTYPES_ITEM0(CSSRULE_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(CSSCONDITIONALRULE_PROTOTYPE, DOM_CSSConditionalRule_functions, DOM_Runtime::CSSRULE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(CSSMEDIARULE_PROTOTYPE, DOM_Runtime::CSSCONDITIONALRULE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(CSSSUPPORTSRULE_PROTOTYPE, DOM_Runtime::CSSCONDITIONALRULE_PROTOTYPE)
#ifdef CSS_ANIMATIONS
	DOM_PROTOTYPES_ITEM1(CSSKEYFRAMESRULE_PROTOTYPE, DOM_CSSKeyframesRule_functions, DOM_Runtime::CSSRULE_PROTOTYPE)
#endif // CSS_ANIMATIONS
#ifdef CSS_TRANSFORMS
	DOM_PROTOTYPES_ITEM1(CSSMATRIX_PROTOTYPE, DOM_CSSMatrix_functions, -1)
#endif // CSS_TRANSFORMS

	/* DOM 2 Traversal & Range */
#ifdef DOM2_TRAVERSAL
	DOM_PROTOTYPES_ITEM0(NODEFILTER_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM3(NODEITERATOR_PROTOTYPE, DOM_NodeIterator_functions, DOM_NodeIterator_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM2(TREEWALKER_PROTOTYPE, DOM_TreeWalker_functions_with_data, -1)
#endif // DOM2_TRAVERSAL
#ifdef DOM2_RANGE
	DOM_PROTOTYPES_ITEM3(RANGE_PROTOTYPE, DOM_Range_functions, DOM_Range_functions_with_data, -1)
#endif // DOM2_RANGE

	/* DOM 2 Style Sheets */
	DOM_PROTOTYPES_ITEM1(STYLESHEETLIST_PROTOTYPE, DOM_StyleSheetList_functions, -1)
	DOM_PROTOTYPES_ITEM1(MEDIALIST_PROTOTYPE, DOM_MediaList_functions, -1)

	/* CSSOM View */
	DOM_PROTOTYPES_ITEM1(MEDIAQUERYLIST_PROTOTYPE, DOM_MediaQueryList_functions, -1)

	/* DOM 3 Load & Save and extras */
#ifdef DOM3_LOAD
	DOM_PROTOTYPES_ITEM0(LSEXCEPTION_PROTOTYPE, -2)
	DOM_PROTOTYPES_ITEM3(LSPARSER_PROTOTYPE, DOM_LSParser_functions, DOM_LSParser_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(DOMPARSER_PROTOTYPE, DOM_DOMParser_functions, -1)
#endif // DOM3_LOAD
#ifdef DOM3_SAVE
	DOM_PROTOTYPES_ITEM2(LSSERIALIZER_PROTOTYPE, DOM_LSSerializer_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(XMLSERIALIZER_PROTOTYPE, DOM_XMLSerializer_functions, -1)
#endif // DOM3_SAVE
#ifdef DOM_HTTP_SUPPORT
	DOM_PROTOTYPES_ITEM3(XMLHTTPREQUEST_PROTOTYPE, DOM_XMLHttpRequest_functions, DOM_XMLHttpRequest_functions_with_data, -1)
#endif // DOM_HTTP_SUPPORT
#if defined DOM_HTTP_SUPPORT && defined PROGRESS_EVENTS_SUPPORT
	DOM_PROTOTYPES_ITEM3(XMLHTTPREQUESTUPLOAD_PROTOTYPE, DOM_XMLHttpRequestUpload_functions, DOM_XMLHttpRequestUpload_functions_with_data, -1)
#endif // DOM_HTTP_SUPPORT && PROGRESS_EVENTS_SUPPORT
#ifdef DOM_HTTP_SUPPORT
	DOM_PROTOTYPES_ITEM0(ANONXMLHTTPREQUEST_PROTOTYPE, DOM_Runtime::XMLHTTPREQUEST_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(FORMDATA_PROTOTYPE, DOM_FormData_functions, -1)
#endif // DOM_HTTP_SUPPORT

	/* DOM 3 XPath */
#ifdef DOM3_XPATH
	DOM_PROTOTYPES_ITEM3(XPATHEVALUATOR_PROTOTYPE, DOM_XPathEvaluator_functions, DOM_XPathEvaluator_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(XPATHEXCEPTION_PROTOTYPE, -2)
	DOM_PROTOTYPES_ITEM1(XPATHEXPRESSION_PROTOTYPE, DOM_XPathExpression_functions, -1)
	DOM_PROTOTYPES_ITEM1(XPATHNSRESOLVER_PROTOTYPE, DOM_XPathNSResolver_functions, -1)
	DOM_PROTOTYPES_ITEM2(XPATHRESULT_PROTOTYPE, DOM_XPathResult_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(XPATHNAMESPACE_PROTOTYPE, DOM_Runtime::NODE_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(XPATHRESULT_NODELIST_PROTOTYPE, DOM_XPathResult_NodeList_functions, -1)
#endif // DOM3_XPATH

	/* Canvas */
#ifdef CANVAS_SUPPORT
	DOM_PROTOTYPES_ITEM1(CANVASCONTEXT2D_PROTOTYPE, DOMCanvasContext2D_functions, -1)
	DOM_PROTOTYPES_ITEM1(CANVASGRADIENT_PROTOTYPE, DOMCanvasGradient_functions, -1)
	DOM_PROTOTYPES_ITEM0(CANVASPATTERN_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(CANVASIMAGEDATA_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(TEXTMETRICS_PROTOTYPE, -1)
#endif // CANVAS_SUPPORT

	/* Canvas3D */
#ifdef CANVAS3D_SUPPORT
	DOM_PROTOTYPES_ITEM1(CANVASCONTEXTWEBGL_PROTOTYPE, DOMCanvasContextWebGL_functions, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLCONTEXTATTRIBUTES_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLOBJECT_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLBUFFER_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLEXTENSION_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLFRAMEBUFFER_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLPROGRAM_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLRENDERBUFFER_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLSHADER_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLTEXTURE_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLUNIFORMLOCATION_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBGLACTIVEINFO_PROTOTYPE, -1)
#endif // CANVAS3D_SUPPORT

	/* SVG */
#ifdef SVG_DOM
	DOM_PROTOTYPES_ITEM0(SVGDOCUMENT_PROTOTYPE, DOM_Runtime::DOCUMENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(SVGEXCEPTION_PROTOTYPE, -2)
	DOM_PROTOTYPES_ITEM0(SVGELEMENT_PROTOTYPE, DOM_Runtime::ELEMENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(SVGOBJECT_PROTOTYPE, -1)
#ifdef SVG_FULL_11
	DOM_PROTOTYPES_ITEM1(SVGLIST_PROTOTYPE, DOM_SVGList_functions, -1)
	DOM_PROTOTYPES_ITEM1(SVGSTRINGLIST_PROTOTYPE, DOM_SVGStringList_functions, -1)
#endif // SVG_FULL_11
	DOM_PROTOTYPES_ITEM3(SVGELEMENTINSTANCE_PROTOTYPE, DOM_SVGElementInstance_functions, DOM_SVGElementInstance_functions_with_data, -1)
#ifdef SVG_FULL_11
	DOM_PROTOTYPES_ITEM1(SVGELEMENTINSTANCELIST_PROTOTYPE, DOM_SVGElementInstanceList_functions, -1)
#endif // SVG_FULL_11
	DOM_PROTOTYPES_ITEM1(TIMEEVENT_PROTOTYPE, DOM_TimeEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // SVG_DOM

	/* Debugger */
#ifdef DOM_DEBUGGER_SUPPORT
	DOM_PROTOTYPES_ITEM1(DEBUGGER_PROTOTYPE, DOM_Debugger_functions, -1)
#endif // DOM_DEBUGGER_SUPPORT

	/* TextRange */
#ifdef DOM_SELECTION_SUPPORT
	DOM_PROTOTYPES_ITEM3(WINDOWSELECTION_PROTOTYPE, DOM_WindowSelection_functions, DOM_WindowSelection_functions_with_data, -1)
#endif // DOM_SELECTION_SUPPORT

	/* Proprietary XSLT support */
#ifdef DOM_XSLT_SUPPORT
	DOM_PROTOTYPES_ITEM3(XSLTPROCESSOR_PROTOTYPE, DOM_XSLTProcessor_functions, DOM_XSLTProcessor_functions_with_data, -1)
#endif // DOM_XSLT_SUPPORT

	/* UPnP Services Discovery */
#if defined UPNP_SUPPORT && defined UPNP_SERVICE_DISCOVERY
	DOM_PROTOTYPES_ITEM0(DEVICEDESCRIPTOR_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(SERVICEDESCRIPTOR_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(UPNPCOLLECTION_PROTOTYPE, -1)
#endif // UPNP_SUPPORT && UPNP_SERVICE_DISCOVERY

	/* WebFeeds support */
#ifdef WEBFEEDS_BACKEND_SUPPORT
	DOM_PROTOTYPES_ITEM1(WEBFEEDS_PROTOTYPE, DOM_WebFeeds_functions, -1)
	DOM_PROTOTYPES_ITEM1(FEEDLIST_PROTOTYPE, DOM_FeedList_functions, -1)
	DOM_PROTOTYPES_ITEM1(FEED_PROTOTYPE, DOM_Feed_functions, -1)
	DOM_PROTOTYPES_ITEM1(FEEDENTRYLIST_PROTOTYPE, DOM_FeedEntryList_functions, -1)
	DOM_PROTOTYPES_ITEM1(FEEDENTRY_PROTOTYPE, DOM_FeedEntry_functions, -1)
	DOM_PROTOTYPES_ITEM0(FEEDCONTENT_PROTOTYPE, -1)
#ifdef WEBFEEDS_EXTERNAL_READERS
	DOM_PROTOTYPES_ITEM1(FEEDREADERLIST_PROTOTYPE, DOM_FeedReaderList_functions, -1)
	DOM_PROTOTYPES_ITEM1(FEEDREADER_PROTOTYPE, DOM_FeedReader_functions, -1)
#endif // WEBFEEDS_EXTERNAL_READERS
#endif // WEBFEEDS_BACKEND_SUPPORT

	/* WebServer support */
#ifdef WEBSERVER_SUPPORT
	DOM_PROTOTYPES_ITEM1(WEBSERVERREQUEST_PROTOTYPE, DOM_WebServerRequest_functions, -1)
	DOM_PROTOTYPES_ITEM1(WEBSERVERRESPONSE_PROTOTYPE, DOM_WebServerResponse_functions, -1)
	DOM_PROTOTYPES_ITEM1(WEBSERVERUPLOADEDFILE_PROTOTYPE, DOM_WebServerUploadedFile_functions, -1)
	DOM_PROTOTYPES_ITEM1(WEBSERVERSESSION_PROTOTYPE, DOM_WebServerSession_functions, -1)
	DOM_PROTOTYPES_ITEM0(WEBSERVERCONNECTION_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBSERVERARRAY_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBSERVERCOLLECTION_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(WEBSERVERSERVICEDESCRIPTOR_PROTOTYPE, -1)
#endif // WEBSERVER_SUPPORT

	/* Gadget support */
#ifdef GADGET_SUPPORT
	DOM_PROTOTYPES_ITEM0(WIDGET_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM2(WIDGETICON_PROTOTYPE, DOM_WidgetIcon_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(WIDGETWINDOW_PROTOTYPE, DOM_WidgetWindow_functions, DOM_WidgetWindow_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(WIDGETCOLLECTION_PROTOTYPE, -1)
#endif // GADGET_SUPPORT

	/* Gadget Manager support */
#if defined DOM_WIDGETMANAGER_SUPPORT || defined DOM_UNITEAPPMANAGER_SUPPORT || defined EXTENSION_MANAGER_SUPPORT
	DOM_PROTOTYPES_ITEM1(WIDGETMANAGER_PROTOTYPE, DOM_WidgetManager_functions, -1)
#endif // DOM_WIDGETMANAGER_SUPPORT || DOM_UNITEAPPMANAGER_SUPPORT || EXTENSION_MANAGER_SUPPORT

	/* Opera Account support */
#if defined DOM_ACCOUNTMANAGER_SUPPORT
	DOM_PROTOTYPES_ITEM1(OPERAACCOUNTMANAGER_PROTOTYPE, DOM_OperaAccountManager_functions, -1)
#endif // DOM_ACCOUNTMANAGER_SUPPORT

	/* Unite support */
#if defined DOM_UNITEDEVMANAGER_SUPPORT
	DOM_PROTOTYPES_ITEM1(UNITEDEVICEMANAGER_PROTOTYPE, DOM_UniteDeviceManager_functions, -1)
#endif // DOM_UNITEDEVMANAGER_SUPPORT

	/* IO support */
#if defined DOM_GADGET_FILE_API_SUPPORT || defined WEBSERVER_SUPPORT
	DOM_PROTOTYPES_ITEM0(IO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(BYTEARRAY_PROTOTYPE, -1)
#endif // DOM_GADGET_FILE_API_SUPPORT || WEBSERVER_SUPPORT

	/* Gadget File API support */
#if defined DOM_GADGET_FILE_API_SUPPORT
	DOM_PROTOTYPES_ITEM3(GADGETFILE_PROTOTYPE, DOM_GadgetFile_functions, DOM_GadgetFile_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(FILESTREAM_PROTOTYPE, DOM_FileStream_functions, DOM_FileStream_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(FILESYSTEM_PROTOTYPE, DOM_FileSystem_functions, DOM_FileSystem_functions_with_data, -1)
#endif // DOM_GADGET_FILE_API_SUPPORT

	/* File API support */
	DOM_PROTOTYPES_ITEM1(BLOB_PROTOTYPE, DOM_Blob_functions, -1)
	DOM_PROTOTYPES_ITEM0(FILE_PROTOTYPE, DOM_Runtime::BLOB_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(FILELIST_PROTOTYPE, DOM_FileList_functions, -1)
	DOM_PROTOTYPES_ITEM3(FILEREADER_PROTOTYPE, DOM_FileReader_functions, DOM_FileReader_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM2(FILEREADERSYNC_PROTOTYPE, DOM_FileReaderSync_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(FILEERROR_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(FILEEXCEPTION_PROTOTYPE, -2)

	/* Media */
#ifdef MEDIA_HTML_SUPPORT
	DOM_PROTOTYPES_ITEM0(MEDIAERROR_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM2(TIMERANGES_PROTOTYPE, DOM_TimeRanges_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(TEXTTRACK_PROTOTYPE, DOM_TextTrack_functions, DOM_TextTrack_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(TEXTTRACKLIST_PROTOTYPE, DOM_TextTrackList_functions, DOM_TextTrackList_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(TEXTTRACKCUE_PROTOTYPE, DOM_TextTrackCue_functions, DOM_TextTrackCue_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(TEXTTRACKCUELIST_PROTOTYPE, DOM_TextTrackCueList_functions, -1)
	DOM_PROTOTYPES_ITEM0(TRACKEVENT_PROTOTYPE, DOM_Runtime::EVENT_PROTOTYPE)
#endif // MEDIA_HTML_SUPPORT

	/* Geolocation support */
#if defined(DOM_GEOLOCATION_SUPPORT) && defined(PI_GEOLOCATION)
	DOM_PROTOTYPES_ITEM1(GEOLOCATION_PROTOTYPE, DOM_Geolocation_functions, -1)
	DOM_PROTOTYPES_ITEM0(POSITION_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(COORDINATES_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(POSITIONERROR_PROTOTYPE, -1)
#endif // DOM_GEOLOCATION_SUPPORT && PI_GEOLOCATION

	/* HTML5 Client-side Storage */
#ifdef CLIENTSIDE_STORAGE_SUPPORT
	DOM_PROTOTYPES_ITEM1(STORAGE_PROTOTYPE, DOM_Storage_functions, -1)
#ifdef WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	DOM_PROTOTYPES_ITEM1(STORAGE_USERJS_PROTOTYPE, DOM_Storage_functions, -1)
#endif // WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	DOM_PROTOTYPES_ITEM1(STORAGEEVENT_PROTOTYPE, DOM_StorageEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // CLIENTSIDE_STORAGE_SUPPORT

	/* HTML5 Database Storage */
#ifdef DATABASE_STORAGE_SUPPORT
	DOM_PROTOTYPES_ITEM3(DATABASE_PROTOTYPE, DOM_Database_functions, DOM_Database_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(SQLTRANSACTION_PROTOTYPE, DOM_SQLTransaction_functions, -1)
	DOM_PROTOTYPES_ITEM0(SQLRESULTSET_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(SQLRESULTSETROWLIST_PROTOTYPE, DOM_SQLResultSetRowList_functions, -1)
	DOM_PROTOTYPES_ITEM0(SQLERROR_PROTOTYPE, -1)
#endif // DATABASE_STORAGE_SUPPORT

	/* JIL API support */
#ifdef DOM_JIL_API_SUPPORT
	DOM_PROTOTYPES_ITEM0(JIL_ACCELEROMETERINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_ACCOUNTINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(JIL_ADDRESSBOOKITEM_PROTOTYPE, DOM_JILAddressBookItem_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_ATTACHMENT_PROTOTYPE, -1)
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_AUDIOPLAYER_PROTOTYPE, DOM_JILAudioPlayer_functions, -1)
#endif // MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_CALENDARITEM_PROTOTYPE, DOM_JILCalendarItem_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_CALLRECORD_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_CALLRECORDTYPES_PROTOTYPE, -1)
#ifdef JIL_CAMERA_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_CAMERA_PROTOTYPE, DOM_JILCamera_functions, -1)
#endif // JIL_CAMERA_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_CONFIG_PROTOTYPE, DOM_JILConfig_functions, -1)
	DOM_PROTOTYPES_ITEM1(JIL_DATANETWORKINFO_PROTOTYPE, DOM_JILDataNetworkInfo_functions, -1)
	DOM_PROTOTYPES_ITEM1(JIL_DEVICE_PROTOTYPE, DOM_JILDevice_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_DEVICEINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(JIL_DEVICESTATEINFO_PROTOTYPE, DOM_JILDeviceStateInfo_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_EMAILACCOUNT_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_EXCEPTION_PROTOTYPE, -2)
	DOM_PROTOTYPES_ITEM0(JIL_FILE_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(JIL_MESSAGE_PROTOTYPE, DOM_JILMessage_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_MESSAGEFOLDERTYPES_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_MESSAGEQUANTITIES_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_MESSAGETYPES_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(JIL_MESSAGING_PROTOTYPE, DOM_JILMessaging_functions, -1)
#ifndef MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM0(JIL_MULTIMEDIA_PROTOTYPE, -1)
#endif // MEDIA_JIL_PLAYER_SUPPORT
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_MULTIMEDIA_PROTOTYPE, DOM_JILMultimedia_functions, -1)
#endif // MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_PIM_PROTOTYPE, DOM_JILPIM_functions, -1)
	DOM_PROTOTYPES_ITEM0(JIL_POSITIONINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_POWERINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(JIL_RADIOINFO_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(JIL_TELEPHONY_PROTOTYPE, DOM_JILTelephony_functions, -1)
#ifdef MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_VIDEOPLAYER_PROTOTYPE, DOM_JILVideoPlayer_functions, -1)
#endif // MEDIA_JIL_PLAYER_SUPPORT
	DOM_PROTOTYPES_ITEM1(JIL_WIDGET_PROTOTYPE, DOM_JILWidget_functions, -1)
#endif // DOM_JIL_API_SUPPORT

	/* HTML 5 Offline Web Application */
#ifdef APPLICATION_CACHE_SUPPORT
	DOM_PROTOTYPES_ITEM3(APPLICATIONCACHE_PROTOTYPE, DOM_ApplicationCache_functions, DOM_ApplicationCache_functions_with_data, -1)
#endif // APPLICATION_CACHE_SUPPORT

	/* WebSocket */
#ifdef WEBSOCKETS_SUPPORT
	DOM_PROTOTYPES_ITEM3(WEBSOCKET_PROTOTYPE, DOM_WebSocket_functions, DOM_WebSocket_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(CLOSEEVENT_PROTOTYPE, DOM_CloseEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // WEBSOCKETS_SUPPORT

	/* HTML5 Web Workers */
#ifdef DOM_WEBWORKERS_SUPPORT
	DOM_PROTOTYPES_ITEM3(WEBWORKERS_DEDICATED_OBJECT_PROTOTYPE, DOM_DedicatedWorkerObject_functions, DOM_DedicatedWorkerObject_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(WEBWORKERS_SHARED_OBJECT_PROTOTYPE, DOM_SharedWorkerObject_functions, DOM_SharedWorkerObject_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(WEBWORKERS_LOCATION_PROTOTYPE, JS_Location_Worker_functions, -1)
	DOM_PROTOTYPES_ITEM0(WEBWORKERS_NAVIGATOR_PROTOTYPE, -1)
#endif // DOM_WEBWORKERS_SUPPORT

	/* HTML5 Cross Document Messaging */
#ifdef DOM_CROSSDOCUMENT_MESSAGING_SUPPORT
	DOM_PROTOTYPES_ITEM0(CROSSDOCUMENT_MESSAGECHANNEL_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(CROSSDOCUMENT_MESSAGEEVENT_PROTOTYPE, DOM_MessageEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM3(CROSSDOCUMENT_MESSAGEPORT_PROTOTYPE, DOM_MessagePort_functions, DOM_MessagePort_functions_with_data, -1)
#endif // DOM_CROSSDOCUMENT_MESSAGING_SUPPORT

	/* HTML5 Server-Sent Events */
#ifdef EVENT_SOURCE_SUPPORT
	DOM_PROTOTYPES_ITEM3(EVENTSOURCE_PROTOTYPE, DOM_EventSource_functions, DOM_EventSource_functions_with_data, -1)
#endif // EVENT_SOURCE_SUPPORT

	/* Touch Events support */
#ifdef TOUCH_EVENTS_SUPPORT
	DOM_PROTOTYPES_ITEM0(TOUCH_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(TOUCHLIST_PROTOTYPE, DOM_TouchList_functions, -1)
	DOM_PROTOTYPES_ITEM1(TOUCHEVENT_PROTOTYPE, DOM_TouchEvent_functions, DOM_Runtime::UIEVENT_PROTOTYPE)
#endif // TOUCH_EVENTS_SUPPORT

	/* Extension support */
#ifdef EXTENSION_SUPPORT
	DOM_PROTOTYPES_ITEM3(EXTENSION_PROTOTYPE, DOM_Extension_functions, DOM_Extension_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM3(EXTENSION_BACKGROUND_PROTOTYPE, DOM_ExtensionBackground_functions, DOM_ExtensionBackground_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(EXTENSION_CONTEXT_PROTOTYPE, DOM_ExtensionContext_functions, -1)
	DOM_PROTOTYPES_ITEM0(EXTENSION_SPEEDDIAL_CONTEXT_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM0(EXTENSION_CONTEXTS_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM3(EXTENSION_PAGE_CONTEXT_PROTOTYPE, DOM_ExtensionPageContext_functions, DOM_ExtensionPageContext_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(EXTENSION_UIBADGE_PROTOTYPE, DOM_ExtensionUIBadge_functions, -1)
	DOM_PROTOTYPES_ITEM3(EXTENSION_UIITEM_PROTOTYPE, DOM_ExtensionUIItem_functions, DOM_ExtensionUIItem_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(EXTENSION_UIITEM_EVENT_PROTOTYPE, DOM_ExtensionUIItemEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(EXTENSION_UIPOPUP_PROTOTYPE, DOM_ExtensionUIPopup_functions, -1)
#ifdef URL_FILTER
	DOM_PROTOTYPES_ITEM2(EXTENSION_URLFILTER_PROTOTYPE, DOM_ExtensionURLFilter_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(EXTENSION_URLFILTER_EVENT_PROTOTYPE, -1)
	DOM_PROTOTYPES_ITEM1(EXTENSION_RULELIST_PROTOTYPE, DOM_ExtensionRuleList_functions, -1)
	DOM_PROTOTYPES_ITEM0(EXTENSION_RULEOPTIONS_PROTOTYPE, -1)
#endif // URL_FILTER
#endif // EXTENSION_SUPPORT

	/* Tabs & windows API */
#ifdef DOM_EXTENSIONS_TAB_API_SUPPORT
	DOM_PROTOTYPES_ITEM1(BROWSER_TAB_PROTOTYPE, DOM_BrowserTab_functions, -1)
	DOM_PROTOTYPES_ITEM3(BROWSER_TAB_MANAGER_PROTOTYPE, DOM_BrowserTabManager_functions, DOM_BrowserTabManager_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(BROWSER_TAB_EVENT_PROTOTYPE, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(BROWSER_TAB_GROUP_PROTOTYPE, DOM_BrowserTabGroup_functions, -1)
	DOM_PROTOTYPES_ITEM3(BROWSER_TAB_GROUP_MANAGER_PROTOTYPE, DOM_BrowserTabGroupManager_functions, DOM_BrowserTabGroupManager_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(BROWSER_TAB_GROUP_EVENT_PROTOTYPE, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(BROWSER_WINDOW_PROTOTYPE, DOM_BrowserWindow_functions, -1)
	DOM_PROTOTYPES_ITEM3(BROWSER_WINDOW_MANAGER_PROTOTYPE, DOM_BrowserWindowManager_functions, DOM_BrowserWindowManager_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(BROWSER_WINDOW_EVENT_PROTOTYPE, DOM_Runtime::EVENT_PROTOTYPE)
#endif // DOM_EXTENSIONS_TAB_API_SUPPORT

	/* Extension Context Menu API */
#ifdef DOM_EXTENSIONS_CONTEXT_MENU_API_SUPPORT
	DOM_PROTOTYPES_ITEM3(EXTENSION_MENUCONTEXT_PROTOTYPE, DOM_ExtensionMenuContext_functions, DOM_ExtensionMenuContext_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(EXTENSION_ROOTMENUCONTEXT_PROTOTYPE, DOM_ExtensionRootMenuContext_functions, DOM_Runtime::EXTENSION_MENUCONTEXT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM0(EXTENSION_MENUITEM_PROTOTYPE, DOM_Runtime::EXTENSION_MENUCONTEXT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM2(EXTENSION_MENUCONTEXT_PROXY_PROTOTYPE, DOM_ExtensionMenuContextProxy_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM0(EXTENSION_MENUITEM_PROXY_PROTOTYPE, DOM_Runtime::EXTENSION_MENUCONTEXT_PROXY_PROTOTYPE)
#endif // DOM_EXTENSIONS_CONTEXT_MENU_API_SUPPORT

	/* HTML5 History */
	DOM_PROTOTYPES_ITEM1(POPSTATEEVENT_PROTOTYPE, DOM_PopStateEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)

	/* DOMPerformance */
#ifdef DOM_WINDOW_PERFORMANCE_OBJECT_SUPPORT
	DOM_PROTOTYPES_ITEM1(PERFORMANCE_PROTOTYPE, DOM_Performance_functions, -1)
#endif // DOM_WINDOW_PERFORMANCE_OBJECT_SUPPORT

	/* Stream API support */
#ifdef DOM_STREAM_API_SUPPORT
	DOM_PROTOTYPES_ITEM3(LOCALMEDIASTREAM_PROTOTYPE, DOM_LocalMediaStream_functions, DOM_LocalMediaStream_functions_with_data, -1)
#endif // DOM_STREAM_API_SUPPORT

	/* DeviceOrientation Event */
#ifdef DOM_DEVICE_ORIENTATION_EVENT_SUPPORT
	DOM_PROTOTYPES_ITEM1(DEVICEORIENTATION_EVENT_PROTOTYPE, DOM_DeviceOrientationEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
	DOM_PROTOTYPES_ITEM1(DEVICEMOTION_EVENT_PROTOTYPE, DOM_DeviceMotionEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // DOM_DEVICE_ORIENTATION_EVENT_SUPPORT

	/* Search Suggestions Support */
#ifdef DOC_SEARCH_SUGGESTIONS_SUPPORT
	DOM_PROTOTYPES_ITEM0(SEARCHSUGGESTS_PROTOTYPE, DOM_Runtime::EVENT_PROTOTYPE)
#endif // DOC_SEARCH_SUGGESTIONS_SUPPORT

	/* Paged display */
#ifdef PAGED_MEDIA_SUPPORT
	DOM_PROTOTYPES_ITEM1(PAGEEVENT_PROTOTYPE, DOM_PageEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // PAGED_MEDIA_SUPPORT

	/* HTML5 Data Transfer */
#if defined(DRAG_SUPPORT) || defined(USE_OP_CLIPBOARD)
	DOM_PROTOTYPES_ITEM3(DATATRANSFER_PROTOTYPE, DOM_DataTransfer_functions, DOM_DataTransfer_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM2(DATATRANSFERITEM_PROTOTYPE, DOM_DataTransferItem_functions_with_data, -1)
	DOM_PROTOTYPES_ITEM1(DATATRANSFERITEMS_PROTOTYPE, DOM_DataTransferItems_functions, -1)
#endif // DRAG_SUPPORT || USE_OP_CLIPBOARD

	/* HTML5 DND */
#ifdef DRAG_SUPPORT
	DOM_PROTOTYPES_ITEM1(DRAGEVENT_PROTOTYPE, DOM_DragEvent_functions, DOM_Runtime::MOUSEEVENT_PROTOTYPE)
#endif // DRAG_SUPPORT

	/* Clipboard Event */
#ifdef USE_OP_CLIPBOARD
	DOM_PROTOTYPES_ITEM1(CLIPBOARDEVENT_PROTOTYPE, DOM_ClipboardEvent_functions, DOM_Runtime::EVENT_PROTOTYPE)
#endif // USE_OP_CLIPBOARD

DOM_PROTOTYPES_END()

void
DOM_Runtime::PreparePrototypeL(ES_Object *object, Prototype type)
{
	switch (type)
	{
	/* JavaScript */
	case LOCATION_PROTOTYPE:
		JS_Location::PreparePrototype(object, this);
		return;

	/* DOM 2 Core */
	case NODE_PROTOTYPE:
		DOM_Node::ConstructNodeObjectL(object, this);
		return;
	case DOCUMENT_PROTOTYPE:
		DOM_Document::ConstructDocumentObjectL(object, this);
		return;
	case DOMEXCEPTION_PROTOTYPE:
		DOM_DOMException::ConstructDOMExceptionObjectL(object, this);
		return;

	/* DOM 2 Events */
	case EVENT_PROTOTYPE:
		DOM_Event::ConstructEventObjectL(object, this);
		return;
	case KEYBOARDEVENT_PROTOTYPE:
		DOM_KeyboardEvent::ConstructKeyboardEventObjectL(object, this);
		return;

	/* DOM 3 Events */
	case TEXTEVENT_PROTOTYPE:
		DOM_TextEvent::ConstructTextEventObjectL(object, this);
		return;

	/* DOM 2 HTML */
	case HTMLELEMENT_PROTOTYPE:
		DOM_HTMLElement::ConstructHTMLElementPrototypeL(object, this);
		return;

	/* DOM 2 CSS */
	case CSSRULE_PROTOTYPE:
		DOM_CSSRule::ConstructCSSRuleObjectL(object, this);
		return;

	/* DOM 2 Traversal & Range */
#ifdef DOM2_TRAVERSAL
	case NODEFILTER_PROTOTYPE:
		DOM_NodeFilter::ConstructNodeFilterObjectL(object, this);
		return;
#endif // DOM2_TRAVERSAL
#ifdef DOM2_RANGE
	case RANGE_PROTOTYPE:
		DOM_Range::ConstructRangeObjectL(object, this);
		return;
#endif // DOM2_RANGE

	/* DOM 3 Load & Save and extras */
#ifdef DOM_HTTP_SUPPORT
	case XMLHTTPREQUEST_PROTOTYPE:
		DOM_XMLHttpRequest::ConstructXMLHttpRequestObjectL(object, this);
		return;
#endif // DOM_HTTP_SUPPORT

	/* Canvas3D */
#ifdef CANVAS3D_SUPPORT
	case CANVASCONTEXTWEBGL_PROTOTYPE:
		DOMCanvasContextWebGL::ConstructCanvasContextWebGLObjectL(object, this);
		return;
#endif // CANVAS3D_SUPPORT

	/* UPnP Services Discovery */
#if defined UPNP_SUPPORT && defined UPNP_SERVICE_DISCOVERY
	case DEVICEDESCRIPTOR_PROTOTYPE:
		DOM_DeviceDescriptor::ConstructDeviceDescriptorL(object, this);
		return;
	case SERVICEDESCRIPTOR_PROTOTYPE:
		DOM_ServiceDescriptor::ConstructServiceDescriptorL(object, this);
		return;
#endif // UPNP_SUPPORT && UPNP_SERVICE_DISCOVERY

	/* File API support */
	case FILEREADER_PROTOTYPE:
		DOM_FileReader::ConstructFileReaderObjectL(object, this);
		return;
	case FILEERROR_PROTOTYPE:
		DOM_FileError::ConstructFileErrorObjectL(object, this);
		return;
	case FILEEXCEPTION_PROTOTYPE:
		DOM_FileException::ConstructFileExceptionObjectL(object, this);
		return;

	/* Media */
#ifdef MEDIA_HTML_SUPPORT
	case MEDIAERROR_PROTOTYPE:
		DOM_MediaError::ConstructMediaErrorObjectL(object, this);
		return;
#endif // MEDIA_HTML_SUPPORT

	/* HTML5 Database Storage */
#ifdef DATABASE_STORAGE_SUPPORT
	case SQLERROR_PROTOTYPE:
		DOM_SQLError::ConstructSQLErrorObjectL(object, this);
		return;
#endif // DATABASE_STORAGE_SUPPORT

	/* HTML 5 Offline Web Application */
#ifdef APPLICATION_CACHE_SUPPORT
	case APPLICATIONCACHE_PROTOTYPE:
		DOM_ApplicationCache::ConstructApplicationCacheObjectL(object, this);
		return;
#endif // APPLICATION_CACHE_SUPPORT

	/* WebSocket */
#ifdef WEBSOCKETS_SUPPORT
	case WEBSOCKET_PROTOTYPE:
		DOM_WebSocket::ConstructWebSocketObjectL(object, this);
		return;
#endif // WEBSOCKETS_SUPPORT

	/* HTML5 Server-Sent Events */
#ifdef EVENT_SOURCE_SUPPORT
	case EVENTSOURCE_PROTOTYPE:
		DOM_EventSource::ConstructEventSourceObjectL(object, this);
		return;
#endif // EVENT_SOURCE_SUPPORT

	/* Extension support */
#ifdef EXTENSION_SUPPORT
#ifdef URL_FILTER
	case EXTENSION_URLFILTER_PROTOTYPE:
		DOM_ExtensionURLFilter::ConstructExtensionURLFilterL(object, this);
		return;
#endif // URL_FILTER
#endif // EXTENSION_SUPPORT

	default:
		static_cast<void>(object);
		/* No preparation necessary. */
		return;
	}
}
