/* -*- Mode: c++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
**
** Copyright (C) 1995-2017 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.  It may not be distributed
** under any circumstances.
*/

// Please don't modify this file.

// This file is automatically generated by modules/hardcore/scripts/generate_prefs.py

INITSTRINGS(PrefsCollectionDatabase, PCDATABASE_NUMBEROFSTRINGPREFS)
{
	INITSTART
	/* Section, Key, Default */

	// Sentinel, always the last entry
	P(SNone, NULL, NULL)
	INITEND
};

INITINTS(PrefsCollectionDatabase, PCDATABASE_NUMBEROFINTEGERPREFS)
{
	INITSTART
	/* Section, Key, Default */
#ifdef SUPPORT_DATABASE_INTERNAL
	I(SPersistentStorage, "Databases Access Handling", PS_Policy::KAccessAllow, prefssetting::integer),
	I(SPersistentStorage, "Domain Quota Exceeded Handling For Databases", PS_Policy::KQuotaAskUser, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	I(SPersistentStorage, "Domain Quota Exceeded Handling For Widget Preferences", PS_Policy::KQuotaDeny, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	I(SPersistentStorage, "Domain Quota Exceeded Handling For localStorage", PS_Policy::KQuotaAskUser, prefssetting::integer),
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	I(SPersistentStorage, "Domain Quota For Databases", DATABASE_INTERNAL_QUOTA_PER_ORIGIN, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	I(SPersistentStorage, "Domain Quota For Widget Preferences", OPSTORAGE_LOCAL_ORIGIN_QUOTA, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	I(SPersistentStorage, "Domain Quota For localStorage", OPSTORAGE_LOCAL_ORIGIN_QUOTA, prefssetting::integer),
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	I(SPersistentStorage, "Global Quota For Databases", DATABASE_INTERNAL_GLOBAL_QUOTA, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	I(SPersistentStorage, "Global Quota For Widget Preferences", OPSTORAGE_LOCAL_GLOBAL_QUOTA, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	I(SPersistentStorage, "Global Quota For localStorage", OPSTORAGE_LOCAL_GLOBAL_QUOTA, prefssetting::integer),
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	I(SPersistentStorage, "SQL Query Execution Timeout", DATABASE_INTERNAL_QUERY_EXECUTION_TIMEOUT, prefssetting::integer),
#endif
#ifdef WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	I(SPersistentStorage, "User JS Storage Quota", 0, prefssetting::integer),
#endif

	// Sentinel, always the last entry
	I(SNone, NULL, 0, prefssetting::prefssettingtypes(0))
	INITEND
};


#ifdef DEBUG
Debug& operator<<(Debug& dbg, enum PrefsCollectionDatabase::stringpref e)
{
	switch (e) {
	default:
		return dbg << "PrefsCollectionDatabase::stringpref(unknown:" << (int)e << ")";
	}
}

Debug& operator<<(Debug& dbg, enum PrefsCollectionDatabase::integerpref e)
{
	switch (e) {
#ifdef SUPPORT_DATABASE_INTERNAL
	case PrefsCollectionDatabase::DatabasesAccessHandling:
		return dbg << "PrefsCollectionDatabase::DatabasesAccessHandling";
	case PrefsCollectionDatabase::DatabaseStorageQuotaExceededHandling:
		return dbg << "PrefsCollectionDatabase::DatabaseStorageQuotaExceededHandling";
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	case PrefsCollectionDatabase::WidgetPrefsQuotaExceededHandling:
		return dbg << "PrefsCollectionDatabase::WidgetPrefsQuotaExceededHandling";
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	case PrefsCollectionDatabase::LocalStorageQuotaExceededHandling:
		return dbg << "PrefsCollectionDatabase::LocalStorageQuotaExceededHandling";
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	case PrefsCollectionDatabase::DatabaseStorageQuota:
		return dbg << "PrefsCollectionDatabase::DatabaseStorageQuota";
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	case PrefsCollectionDatabase::WidgetPrefsQuota:
		return dbg << "PrefsCollectionDatabase::WidgetPrefsQuota";
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	case PrefsCollectionDatabase::LocalStorageQuota:
		return dbg << "PrefsCollectionDatabase::LocalStorageQuota";
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	case PrefsCollectionDatabase::DatabaseStorageGlobalQuota:
		return dbg << "PrefsCollectionDatabase::DatabaseStorageGlobalQuota";
#endif
#ifdef WEBSTORAGE_WIDGET_PREFS_SUPPORT
	case PrefsCollectionDatabase::WidgetPrefsGlobalQuota:
		return dbg << "PrefsCollectionDatabase::WidgetPrefsGlobalQuota";
#endif
#ifdef WEBSTORAGE_ENABLE_SIMPLE_BACKEND
	case PrefsCollectionDatabase::LocalStorageGlobalQuota:
		return dbg << "PrefsCollectionDatabase::LocalStorageGlobalQuota";
#endif
#ifdef SUPPORT_DATABASE_INTERNAL
	case PrefsCollectionDatabase::DatabaseStorageQueryExecutionTimeout:
		return dbg << "PrefsCollectionDatabase::DatabaseStorageQueryExecutionTimeout";
#endif
#ifdef WEBSTORAGE_USER_SCRIPT_STORAGE_SUPPORT
	case PrefsCollectionDatabase::UserJSScriptStorageQuota:
		return dbg << "PrefsCollectionDatabase::UserJSScriptStorageQuota";
#endif
	default:
		return dbg << "PrefsCollectionDatabase::integerpref(unknown:" << (int)e << ")";
	}
}

#endif // DEBUG
